// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.openid_client');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('goog.net.Cookies');
untangled.openid_client.params = (function untangled$openid_client$params(){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.rest.call(null,window.location.hash));
});
untangled.openid_client.get_tokens_from_cookies = (function untangled$openid_client$get_tokens_from_cookies(){
var cookies = (new goog.net.Cookies(document));
var cookie_keys = cookies.getKeys();
return cljs.core.reduce.call(null,((function (cookies,cookie_keys){
return (function (p1__72339_SHARP_,p2__72340_SHARP_){
return cljs.core.assoc.call(null,p1__72339_SHARP_,p2__72340_SHARP_,cookies.get(p2__72340_SHARP_));
});})(cookies,cookie_keys))
,cljs.core.PersistentArrayMap.EMPTY,cookie_keys);
});
untangled.openid_client.tokens_from_params = (function untangled$openid_client$tokens_from_params(params){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,(function (v){
var pairs = clojure.string.split.call(null,v,/=/);
return cljs.core.PersistentArrayMap.fromArray([cljs.core.first.call(null,pairs),cljs.core.second.call(null,pairs)], true, false);
}),clojure.string.split.call(null,params,/&/)));
});
untangled.openid_client.parse_claims = (function untangled$openid_client$parse_claims(token){
var G__72342 = token;
var G__72342__$1 = (((G__72342 == null))?null:clojure.string.split.call(null,G__72342,/\./));
var G__72342__$2 = (((G__72342__$1 == null))?null:cljs.core.second.call(null,G__72342__$1));
var G__72342__$3 = (((G__72342__$2 == null))?null:atob(G__72342__$2));
if((G__72342__$3 == null)){
return null;
} else {
return JSON.parse(G__72342__$3);
}
});
/**
 * Adds an Authorization header for each request based on the claims in the cookies or the url's hash fragments
 */
untangled.openid_client.add_auth_header = (function untangled$openid_client$add_auth_header(req){
var access_token = cljs.core.get.call(null,(function (){var or__27280__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
}
})(),"access_token");
return cljs.core.assoc_in.call(null,req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(access_token)].join(''));
});
/**
 * Installs openid information into the passed in untangled-client app's initial state,
 *   based on the token claims in the cookies or the url's hash fragments.
 */
untangled.openid_client.install_state_BANG_ = (function untangled$openid_client$install_state_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___72349 = arguments.length;
var i__28497__auto___72350 = (0);
while(true){
if((i__28497__auto___72350 < len__28496__auto___72349)){
args__28503__auto__.push((arguments[i__28497__auto___72350]));

var G__72351 = (i__28497__auto___72350 + (1));
i__28497__auto___72350 = G__72351;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (reconciler,p__72345){
var map__72346 = p__72345;
var map__72346__$1 = ((((!((map__72346 == null)))?((((map__72346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72346):map__72346);
var custom_state_fn = cljs.core.get.call(null,map__72346__$1,new cljs.core.Keyword(null,"custom-state-fn","custom-state-fn",1049325348),cljs.core.constantly.call(null,cljs.core.PersistentArrayMap.EMPTY));
var hash_tokens = untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
var tokens = (function (){var or__27280__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return hash_tokens;
}
})();
var id_claims = (function (){var G__72348 = tokens;
var G__72348__$1 = (((G__72348 == null))?null:cljs.core.get.call(null,G__72348,"id_token"));
var G__72348__$2 = (((G__72348__$1 == null))?null:untangled.openid_client.parse_claims.call(null,G__72348__$1));
var G__72348__$3 = (((G__72348__$2 == null))?null:cljs.core.js__GT_clj.call(null,G__72348__$2));
if((G__72348__$3 == null)){
return null;
} else {
return clojure.walk.keywordize_keys.call(null,G__72348__$3);
}
})();
if(cljs.core._EQ_.call(null,tokens,hash_tokens)){
(window.location["hash"] = "");
} else {
}

return cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.merge,cljs.core.merge.call(null,custom_state_fn.call(null,id_claims),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("openid","claims","openid/claims",498347492),id_claims,new cljs.core.Keyword("openid","access-token","openid/access-token",390035886),cljs.core.get.call(null,tokens,"access_token")], null)));
});

untangled.openid_client.install_state_BANG_.cljs$lang$maxFixedArity = (1);

untangled.openid_client.install_state_BANG_.cljs$lang$applyTo = (function (seq72343){
var G__72344 = cljs.core.first.call(null,seq72343);
var seq72343__$1 = cljs.core.next.call(null,seq72343);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__72344,seq72343__$1);
});


//# sourceMappingURL=openid_client.js.map?rel=1479956919794