// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args61647 = [];
var len__28496__auto___61653 = arguments.length;
var i__28497__auto___61654 = (0);
while(true){
if((i__28497__auto___61654 < len__28496__auto___61653)){
args61647.push((arguments[i__28497__auto___61654]));

var G__61655 = (i__28497__auto___61654 + (1));
i__28497__auto___61654 = G__61655;
continue;
} else {
}
break;
}

var G__61649 = args61647.length;
switch (G__61649) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61647.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async61650 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61650 = (function (f,blockable,meta61651){
this.f = f;
this.blockable = blockable;
this.meta61651 = meta61651;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_61652,meta61651__$1){
var self__ = this;
var _61652__$1 = this;
return (new cljs.core.async.t_cljs$core$async61650(self__.f,self__.blockable,meta61651__$1));
});


cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_61652){
var self__ = this;
var _61652__$1 = this;
return self__.meta61651;
});


cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async61650.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async61650.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta61651","meta61651",20505444,null)], null);
});

cljs.core.async.t_cljs$core$async61650.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61650.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61650";

cljs.core.async.t_cljs$core$async61650.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61650");
});

cljs.core.async.__GT_t_cljs$core$async61650 = (function cljs$core$async$__GT_t_cljs$core$async61650(f__$1,blockable__$1,meta61651){
return (new cljs.core.async.t_cljs$core$async61650(f__$1,blockable__$1,meta61651));
});

}

return (new cljs.core.async.t_cljs$core$async61650(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args61659 = [];
var len__28496__auto___61662 = arguments.length;
var i__28497__auto___61663 = (0);
while(true){
if((i__28497__auto___61663 < len__28496__auto___61662)){
args61659.push((arguments[i__28497__auto___61663]));

var G__61664 = (i__28497__auto___61663 + (1));
i__28497__auto___61663 = G__61664;
continue;
} else {
}
break;
}

var G__61661 = args61659.length;
switch (G__61661) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61659.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args61666 = [];
var len__28496__auto___61669 = arguments.length;
var i__28497__auto___61670 = (0);
while(true){
if((i__28497__auto___61670 < len__28496__auto___61669)){
args61666.push((arguments[i__28497__auto___61670]));

var G__61671 = (i__28497__auto___61670 + (1));
i__28497__auto___61670 = G__61671;
continue;
} else {
}
break;
}

var G__61668 = args61666.length;
switch (G__61668) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61666.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args61673 = [];
var len__28496__auto___61676 = arguments.length;
var i__28497__auto___61677 = (0);
while(true){
if((i__28497__auto___61677 < len__28496__auto___61676)){
args61673.push((arguments[i__28497__auto___61677]));

var G__61678 = (i__28497__auto___61677 + (1));
i__28497__auto___61677 = G__61678;
continue;
} else {
}
break;
}

var G__61675 = args61673.length;
switch (G__61675) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61673.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_61680 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_61680);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_61680,ret){
return (function (){
return fn1.call(null,val_61680);
});})(val_61680,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args61681 = [];
var len__28496__auto___61684 = arguments.length;
var i__28497__auto___61685 = (0);
while(true){
if((i__28497__auto___61685 < len__28496__auto___61684)){
args61681.push((arguments[i__28497__auto___61685]));

var G__61686 = (i__28497__auto___61685 + (1));
i__28497__auto___61685 = G__61686;
continue;
} else {
}
break;
}

var G__61683 = args61681.length;
switch (G__61683) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61681.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28296__auto___61688 = n;
var x_61689 = (0);
while(true){
if((x_61689 < n__28296__auto___61688)){
(a[x_61689] = (0));

var G__61690 = (x_61689 + (1));
x_61689 = G__61690;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__61691 = (i + (1));
i = G__61691;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async61695 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61695 = (function (flag,meta61696){
this.flag = flag;
this.meta61696 = meta61696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_61697,meta61696__$1){
var self__ = this;
var _61697__$1 = this;
return (new cljs.core.async.t_cljs$core$async61695(self__.flag,meta61696__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_61697){
var self__ = this;
var _61697__$1 = this;
return self__.meta61696;
});})(flag))
;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async61695.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta61696","meta61696",1824348512,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async61695.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61695.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61695";

cljs.core.async.t_cljs$core$async61695.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61695");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async61695 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async61695(flag__$1,meta61696){
return (new cljs.core.async.t_cljs$core$async61695(flag__$1,meta61696));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async61695(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async61701 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61701 = (function (flag,cb,meta61702){
this.flag = flag;
this.cb = cb;
this.meta61702 = meta61702;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_61703,meta61702__$1){
var self__ = this;
var _61703__$1 = this;
return (new cljs.core.async.t_cljs$core$async61701(self__.flag,self__.cb,meta61702__$1));
});


cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_61703){
var self__ = this;
var _61703__$1 = this;
return self__.meta61702;
});


cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async61701.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async61701.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta61702","meta61702",587032254,null)], null);
});

cljs.core.async.t_cljs$core$async61701.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61701.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61701";

cljs.core.async.t_cljs$core$async61701.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61701");
});

cljs.core.async.__GT_t_cljs$core$async61701 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async61701(flag__$1,cb__$1,meta61702){
return (new cljs.core.async.t_cljs$core$async61701(flag__$1,cb__$1,meta61702));
});

}

return (new cljs.core.async.t_cljs$core$async61701(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__61704_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61704_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__61705_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61705_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27280__auto__ = wport;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return port;
}
})()], null));
} else {
var G__61706 = (i + (1));
i = G__61706;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27280__auto__ = ret;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__27268__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27268__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___61712 = arguments.length;
var i__28497__auto___61713 = (0);
while(true){
if((i__28497__auto___61713 < len__28496__auto___61712)){
args__28503__auto__.push((arguments[i__28497__auto___61713]));

var G__61714 = (i__28497__auto___61713 + (1));
i__28497__auto___61713 = G__61714;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__61709){
var map__61710 = p__61709;
var map__61710__$1 = ((((!((map__61710 == null)))?((((map__61710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61710.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61710):map__61710);
var opts = map__61710__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq61707){
var G__61708 = cljs.core.first.call(null,seq61707);
var seq61707__$1 = cljs.core.next.call(null,seq61707);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__61708,seq61707__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args61715 = [];
var len__28496__auto___61765 = arguments.length;
var i__28497__auto___61766 = (0);
while(true){
if((i__28497__auto___61766 < len__28496__auto___61765)){
args61715.push((arguments[i__28497__auto___61766]));

var G__61767 = (i__28497__auto___61766 + (1));
i__28497__auto___61766 = G__61767;
continue;
} else {
}
break;
}

var G__61717 = args61715.length;
switch (G__61717) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61715.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__41822__auto___61769 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___61769){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___61769){
return (function (state_61741){
var state_val_61742 = (state_61741[(1)]);
if((state_val_61742 === (7))){
var inst_61737 = (state_61741[(2)]);
var state_61741__$1 = state_61741;
var statearr_61743_61770 = state_61741__$1;
(statearr_61743_61770[(2)] = inst_61737);

(statearr_61743_61770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (1))){
var state_61741__$1 = state_61741;
var statearr_61744_61771 = state_61741__$1;
(statearr_61744_61771[(2)] = null);

(statearr_61744_61771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (4))){
var inst_61720 = (state_61741[(7)]);
var inst_61720__$1 = (state_61741[(2)]);
var inst_61721 = (inst_61720__$1 == null);
var state_61741__$1 = (function (){var statearr_61745 = state_61741;
(statearr_61745[(7)] = inst_61720__$1);

return statearr_61745;
})();
if(cljs.core.truth_(inst_61721)){
var statearr_61746_61772 = state_61741__$1;
(statearr_61746_61772[(1)] = (5));

} else {
var statearr_61747_61773 = state_61741__$1;
(statearr_61747_61773[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (13))){
var state_61741__$1 = state_61741;
var statearr_61748_61774 = state_61741__$1;
(statearr_61748_61774[(2)] = null);

(statearr_61748_61774[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (6))){
var inst_61720 = (state_61741[(7)]);
var state_61741__$1 = state_61741;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61741__$1,(11),to,inst_61720);
} else {
if((state_val_61742 === (3))){
var inst_61739 = (state_61741[(2)]);
var state_61741__$1 = state_61741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61741__$1,inst_61739);
} else {
if((state_val_61742 === (12))){
var state_61741__$1 = state_61741;
var statearr_61749_61775 = state_61741__$1;
(statearr_61749_61775[(2)] = null);

(statearr_61749_61775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (2))){
var state_61741__$1 = state_61741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61741__$1,(4),from);
} else {
if((state_val_61742 === (11))){
var inst_61730 = (state_61741[(2)]);
var state_61741__$1 = state_61741;
if(cljs.core.truth_(inst_61730)){
var statearr_61750_61776 = state_61741__$1;
(statearr_61750_61776[(1)] = (12));

} else {
var statearr_61751_61777 = state_61741__$1;
(statearr_61751_61777[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (9))){
var state_61741__$1 = state_61741;
var statearr_61752_61778 = state_61741__$1;
(statearr_61752_61778[(2)] = null);

(statearr_61752_61778[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (5))){
var state_61741__$1 = state_61741;
if(cljs.core.truth_(close_QMARK_)){
var statearr_61753_61779 = state_61741__$1;
(statearr_61753_61779[(1)] = (8));

} else {
var statearr_61754_61780 = state_61741__$1;
(statearr_61754_61780[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (14))){
var inst_61735 = (state_61741[(2)]);
var state_61741__$1 = state_61741;
var statearr_61755_61781 = state_61741__$1;
(statearr_61755_61781[(2)] = inst_61735);

(statearr_61755_61781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (10))){
var inst_61727 = (state_61741[(2)]);
var state_61741__$1 = state_61741;
var statearr_61756_61782 = state_61741__$1;
(statearr_61756_61782[(2)] = inst_61727);

(statearr_61756_61782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61742 === (8))){
var inst_61724 = cljs.core.async.close_BANG_.call(null,to);
var state_61741__$1 = state_61741;
var statearr_61757_61783 = state_61741__$1;
(statearr_61757_61783[(2)] = inst_61724);

(statearr_61757_61783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___61769))
;
return ((function (switch__41805__auto__,c__41822__auto___61769){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_61761 = [null,null,null,null,null,null,null,null];
(statearr_61761[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_61761[(1)] = (1));

return statearr_61761;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_61741){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_61741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e61762){if((e61762 instanceof Object)){
var ex__41809__auto__ = e61762;
var statearr_61763_61784 = state_61741;
(statearr_61763_61784[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61741);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61762;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61785 = state_61741;
state_61741 = G__61785;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_61741){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_61741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___61769))
})();
var state__41824__auto__ = (function (){var statearr_61764 = f__41823__auto__.call(null);
(statearr_61764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___61769);

return statearr_61764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___61769))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__61973){
var vec__61974 = p__61973;
var v = cljs.core.nth.call(null,vec__61974,(0),null);
var p = cljs.core.nth.call(null,vec__61974,(1),null);
var job = vec__61974;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__41822__auto___62160 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results){
return (function (state_61981){
var state_val_61982 = (state_61981[(1)]);
if((state_val_61982 === (1))){
var state_61981__$1 = state_61981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61981__$1,(2),res,v);
} else {
if((state_val_61982 === (2))){
var inst_61978 = (state_61981[(2)]);
var inst_61979 = cljs.core.async.close_BANG_.call(null,res);
var state_61981__$1 = (function (){var statearr_61983 = state_61981;
(statearr_61983[(7)] = inst_61978);

return statearr_61983;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61981__$1,inst_61979);
} else {
return null;
}
}
});})(c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results))
;
return ((function (switch__41805__auto__,c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_61987 = [null,null,null,null,null,null,null,null];
(statearr_61987[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_61987[(1)] = (1));

return statearr_61987;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_61981){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_61981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e61988){if((e61988 instanceof Object)){
var ex__41809__auto__ = e61988;
var statearr_61989_62161 = state_61981;
(statearr_61989_62161[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62162 = state_61981;
state_61981 = G__62162;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_61981){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_61981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results))
})();
var state__41824__auto__ = (function (){var statearr_61990 = f__41823__auto__.call(null);
(statearr_61990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62160);

return statearr_61990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62160,res,vec__61974,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__61991){
var vec__61992 = p__61991;
var v = cljs.core.nth.call(null,vec__61992,(0),null);
var p = cljs.core.nth.call(null,vec__61992,(1),null);
var job = vec__61992;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28296__auto___62163 = n;
var __62164 = (0);
while(true){
if((__62164 < n__28296__auto___62163)){
var G__61995_62165 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__61995_62165) {
case "compute":
var c__41822__auto___62167 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__62164,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (__62164,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function (state_62008){
var state_val_62009 = (state_62008[(1)]);
if((state_val_62009 === (1))){
var state_62008__$1 = state_62008;
var statearr_62010_62168 = state_62008__$1;
(statearr_62010_62168[(2)] = null);

(statearr_62010_62168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62009 === (2))){
var state_62008__$1 = state_62008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62008__$1,(4),jobs);
} else {
if((state_val_62009 === (3))){
var inst_62006 = (state_62008[(2)]);
var state_62008__$1 = state_62008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62008__$1,inst_62006);
} else {
if((state_val_62009 === (4))){
var inst_61998 = (state_62008[(2)]);
var inst_61999 = process.call(null,inst_61998);
var state_62008__$1 = state_62008;
if(cljs.core.truth_(inst_61999)){
var statearr_62011_62169 = state_62008__$1;
(statearr_62011_62169[(1)] = (5));

} else {
var statearr_62012_62170 = state_62008__$1;
(statearr_62012_62170[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62009 === (5))){
var state_62008__$1 = state_62008;
var statearr_62013_62171 = state_62008__$1;
(statearr_62013_62171[(2)] = null);

(statearr_62013_62171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62009 === (6))){
var state_62008__$1 = state_62008;
var statearr_62014_62172 = state_62008__$1;
(statearr_62014_62172[(2)] = null);

(statearr_62014_62172[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62009 === (7))){
var inst_62004 = (state_62008[(2)]);
var state_62008__$1 = state_62008;
var statearr_62015_62173 = state_62008__$1;
(statearr_62015_62173[(2)] = inst_62004);

(statearr_62015_62173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__62164,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
;
return ((function (__62164,switch__41805__auto__,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62019 = [null,null,null,null,null,null,null];
(statearr_62019[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62019[(1)] = (1));

return statearr_62019;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62008){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62020){if((e62020 instanceof Object)){
var ex__41809__auto__ = e62020;
var statearr_62021_62174 = state_62008;
(statearr_62021_62174[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62008);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62175 = state_62008;
state_62008 = G__62175;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62008){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(__62164,switch__41805__auto__,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62022 = f__41823__auto__.call(null);
(statearr_62022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62167);

return statearr_62022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(__62164,c__41822__auto___62167,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
);


break;
case "async":
var c__41822__auto___62176 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__62164,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (__62164,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function (state_62035){
var state_val_62036 = (state_62035[(1)]);
if((state_val_62036 === (1))){
var state_62035__$1 = state_62035;
var statearr_62037_62177 = state_62035__$1;
(statearr_62037_62177[(2)] = null);

(statearr_62037_62177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62036 === (2))){
var state_62035__$1 = state_62035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62035__$1,(4),jobs);
} else {
if((state_val_62036 === (3))){
var inst_62033 = (state_62035[(2)]);
var state_62035__$1 = state_62035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62035__$1,inst_62033);
} else {
if((state_val_62036 === (4))){
var inst_62025 = (state_62035[(2)]);
var inst_62026 = async.call(null,inst_62025);
var state_62035__$1 = state_62035;
if(cljs.core.truth_(inst_62026)){
var statearr_62038_62178 = state_62035__$1;
(statearr_62038_62178[(1)] = (5));

} else {
var statearr_62039_62179 = state_62035__$1;
(statearr_62039_62179[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62036 === (5))){
var state_62035__$1 = state_62035;
var statearr_62040_62180 = state_62035__$1;
(statearr_62040_62180[(2)] = null);

(statearr_62040_62180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62036 === (6))){
var state_62035__$1 = state_62035;
var statearr_62041_62181 = state_62035__$1;
(statearr_62041_62181[(2)] = null);

(statearr_62041_62181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62036 === (7))){
var inst_62031 = (state_62035[(2)]);
var state_62035__$1 = state_62035;
var statearr_62042_62182 = state_62035__$1;
(statearr_62042_62182[(2)] = inst_62031);

(statearr_62042_62182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__62164,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
;
return ((function (__62164,switch__41805__auto__,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62046 = [null,null,null,null,null,null,null];
(statearr_62046[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62046[(1)] = (1));

return statearr_62046;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62035){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62047){if((e62047 instanceof Object)){
var ex__41809__auto__ = e62047;
var statearr_62048_62183 = state_62035;
(statearr_62048_62183[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62184 = state_62035;
state_62035 = G__62184;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62035){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(__62164,switch__41805__auto__,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62049 = f__41823__auto__.call(null);
(statearr_62049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62176);

return statearr_62049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(__62164,c__41822__auto___62176,G__61995_62165,n__28296__auto___62163,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__62185 = (__62164 + (1));
__62164 = G__62185;
continue;
} else {
}
break;
}

var c__41822__auto___62186 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62186,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62186,jobs,results,process,async){
return (function (state_62071){
var state_val_62072 = (state_62071[(1)]);
if((state_val_62072 === (1))){
var state_62071__$1 = state_62071;
var statearr_62073_62187 = state_62071__$1;
(statearr_62073_62187[(2)] = null);

(statearr_62073_62187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62072 === (2))){
var state_62071__$1 = state_62071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62071__$1,(4),from);
} else {
if((state_val_62072 === (3))){
var inst_62069 = (state_62071[(2)]);
var state_62071__$1 = state_62071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62071__$1,inst_62069);
} else {
if((state_val_62072 === (4))){
var inst_62052 = (state_62071[(7)]);
var inst_62052__$1 = (state_62071[(2)]);
var inst_62053 = (inst_62052__$1 == null);
var state_62071__$1 = (function (){var statearr_62074 = state_62071;
(statearr_62074[(7)] = inst_62052__$1);

return statearr_62074;
})();
if(cljs.core.truth_(inst_62053)){
var statearr_62075_62188 = state_62071__$1;
(statearr_62075_62188[(1)] = (5));

} else {
var statearr_62076_62189 = state_62071__$1;
(statearr_62076_62189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62072 === (5))){
var inst_62055 = cljs.core.async.close_BANG_.call(null,jobs);
var state_62071__$1 = state_62071;
var statearr_62077_62190 = state_62071__$1;
(statearr_62077_62190[(2)] = inst_62055);

(statearr_62077_62190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62072 === (6))){
var inst_62057 = (state_62071[(8)]);
var inst_62052 = (state_62071[(7)]);
var inst_62057__$1 = cljs.core.async.chan.call(null,(1));
var inst_62058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62059 = [inst_62052,inst_62057__$1];
var inst_62060 = (new cljs.core.PersistentVector(null,2,(5),inst_62058,inst_62059,null));
var state_62071__$1 = (function (){var statearr_62078 = state_62071;
(statearr_62078[(8)] = inst_62057__$1);

return statearr_62078;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62071__$1,(8),jobs,inst_62060);
} else {
if((state_val_62072 === (7))){
var inst_62067 = (state_62071[(2)]);
var state_62071__$1 = state_62071;
var statearr_62079_62191 = state_62071__$1;
(statearr_62079_62191[(2)] = inst_62067);

(statearr_62079_62191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62072 === (8))){
var inst_62057 = (state_62071[(8)]);
var inst_62062 = (state_62071[(2)]);
var state_62071__$1 = (function (){var statearr_62080 = state_62071;
(statearr_62080[(9)] = inst_62062);

return statearr_62080;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62071__$1,(9),results,inst_62057);
} else {
if((state_val_62072 === (9))){
var inst_62064 = (state_62071[(2)]);
var state_62071__$1 = (function (){var statearr_62081 = state_62071;
(statearr_62081[(10)] = inst_62064);

return statearr_62081;
})();
var statearr_62082_62192 = state_62071__$1;
(statearr_62082_62192[(2)] = null);

(statearr_62082_62192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62186,jobs,results,process,async))
;
return ((function (switch__41805__auto__,c__41822__auto___62186,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62086 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62086[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62086[(1)] = (1));

return statearr_62086;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62071){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62087){if((e62087 instanceof Object)){
var ex__41809__auto__ = e62087;
var statearr_62088_62193 = state_62071;
(statearr_62088_62193[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62071);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62087;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62194 = state_62071;
state_62071 = G__62194;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62071){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62186,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62089 = f__41823__auto__.call(null);
(statearr_62089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62186);

return statearr_62089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62186,jobs,results,process,async))
);


var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__,jobs,results,process,async){
return (function (state_62127){
var state_val_62128 = (state_62127[(1)]);
if((state_val_62128 === (7))){
var inst_62123 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
var statearr_62129_62195 = state_62127__$1;
(statearr_62129_62195[(2)] = inst_62123);

(statearr_62129_62195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (20))){
var state_62127__$1 = state_62127;
var statearr_62130_62196 = state_62127__$1;
(statearr_62130_62196[(2)] = null);

(statearr_62130_62196[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (1))){
var state_62127__$1 = state_62127;
var statearr_62131_62197 = state_62127__$1;
(statearr_62131_62197[(2)] = null);

(statearr_62131_62197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (4))){
var inst_62092 = (state_62127[(7)]);
var inst_62092__$1 = (state_62127[(2)]);
var inst_62093 = (inst_62092__$1 == null);
var state_62127__$1 = (function (){var statearr_62132 = state_62127;
(statearr_62132[(7)] = inst_62092__$1);

return statearr_62132;
})();
if(cljs.core.truth_(inst_62093)){
var statearr_62133_62198 = state_62127__$1;
(statearr_62133_62198[(1)] = (5));

} else {
var statearr_62134_62199 = state_62127__$1;
(statearr_62134_62199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (15))){
var inst_62105 = (state_62127[(8)]);
var state_62127__$1 = state_62127;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62127__$1,(18),to,inst_62105);
} else {
if((state_val_62128 === (21))){
var inst_62118 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
var statearr_62135_62200 = state_62127__$1;
(statearr_62135_62200[(2)] = inst_62118);

(statearr_62135_62200[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (13))){
var inst_62120 = (state_62127[(2)]);
var state_62127__$1 = (function (){var statearr_62136 = state_62127;
(statearr_62136[(9)] = inst_62120);

return statearr_62136;
})();
var statearr_62137_62201 = state_62127__$1;
(statearr_62137_62201[(2)] = null);

(statearr_62137_62201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (6))){
var inst_62092 = (state_62127[(7)]);
var state_62127__$1 = state_62127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62127__$1,(11),inst_62092);
} else {
if((state_val_62128 === (17))){
var inst_62113 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
if(cljs.core.truth_(inst_62113)){
var statearr_62138_62202 = state_62127__$1;
(statearr_62138_62202[(1)] = (19));

} else {
var statearr_62139_62203 = state_62127__$1;
(statearr_62139_62203[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (3))){
var inst_62125 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62127__$1,inst_62125);
} else {
if((state_val_62128 === (12))){
var inst_62102 = (state_62127[(10)]);
var state_62127__$1 = state_62127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62127__$1,(14),inst_62102);
} else {
if((state_val_62128 === (2))){
var state_62127__$1 = state_62127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62127__$1,(4),results);
} else {
if((state_val_62128 === (19))){
var state_62127__$1 = state_62127;
var statearr_62140_62204 = state_62127__$1;
(statearr_62140_62204[(2)] = null);

(statearr_62140_62204[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (11))){
var inst_62102 = (state_62127[(2)]);
var state_62127__$1 = (function (){var statearr_62141 = state_62127;
(statearr_62141[(10)] = inst_62102);

return statearr_62141;
})();
var statearr_62142_62205 = state_62127__$1;
(statearr_62142_62205[(2)] = null);

(statearr_62142_62205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (9))){
var state_62127__$1 = state_62127;
var statearr_62143_62206 = state_62127__$1;
(statearr_62143_62206[(2)] = null);

(statearr_62143_62206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (5))){
var state_62127__$1 = state_62127;
if(cljs.core.truth_(close_QMARK_)){
var statearr_62144_62207 = state_62127__$1;
(statearr_62144_62207[(1)] = (8));

} else {
var statearr_62145_62208 = state_62127__$1;
(statearr_62145_62208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (14))){
var inst_62105 = (state_62127[(8)]);
var inst_62107 = (state_62127[(11)]);
var inst_62105__$1 = (state_62127[(2)]);
var inst_62106 = (inst_62105__$1 == null);
var inst_62107__$1 = cljs.core.not.call(null,inst_62106);
var state_62127__$1 = (function (){var statearr_62146 = state_62127;
(statearr_62146[(8)] = inst_62105__$1);

(statearr_62146[(11)] = inst_62107__$1);

return statearr_62146;
})();
if(inst_62107__$1){
var statearr_62147_62209 = state_62127__$1;
(statearr_62147_62209[(1)] = (15));

} else {
var statearr_62148_62210 = state_62127__$1;
(statearr_62148_62210[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (16))){
var inst_62107 = (state_62127[(11)]);
var state_62127__$1 = state_62127;
var statearr_62149_62211 = state_62127__$1;
(statearr_62149_62211[(2)] = inst_62107);

(statearr_62149_62211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (10))){
var inst_62099 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
var statearr_62150_62212 = state_62127__$1;
(statearr_62150_62212[(2)] = inst_62099);

(statearr_62150_62212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (18))){
var inst_62110 = (state_62127[(2)]);
var state_62127__$1 = state_62127;
var statearr_62151_62213 = state_62127__$1;
(statearr_62151_62213[(2)] = inst_62110);

(statearr_62151_62213[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62128 === (8))){
var inst_62096 = cljs.core.async.close_BANG_.call(null,to);
var state_62127__$1 = state_62127;
var statearr_62152_62214 = state_62127__$1;
(statearr_62152_62214[(2)] = inst_62096);

(statearr_62152_62214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__,jobs,results,process,async))
;
return ((function (switch__41805__auto__,c__41822__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62156 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62156[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62156[(1)] = (1));

return statearr_62156;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62127){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62157){if((e62157 instanceof Object)){
var ex__41809__auto__ = e62157;
var statearr_62158_62215 = state_62127;
(statearr_62158_62215[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62216 = state_62127;
state_62127 = G__62216;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62127){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62159 = f__41823__auto__.call(null);
(statearr_62159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__,jobs,results,process,async))
);

return c__41822__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args62217 = [];
var len__28496__auto___62220 = arguments.length;
var i__28497__auto___62221 = (0);
while(true){
if((i__28497__auto___62221 < len__28496__auto___62220)){
args62217.push((arguments[i__28497__auto___62221]));

var G__62222 = (i__28497__auto___62221 + (1));
i__28497__auto___62221 = G__62222;
continue;
} else {
}
break;
}

var G__62219 = args62217.length;
switch (G__62219) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62217.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args62224 = [];
var len__28496__auto___62227 = arguments.length;
var i__28497__auto___62228 = (0);
while(true){
if((i__28497__auto___62228 < len__28496__auto___62227)){
args62224.push((arguments[i__28497__auto___62228]));

var G__62229 = (i__28497__auto___62228 + (1));
i__28497__auto___62228 = G__62229;
continue;
} else {
}
break;
}

var G__62226 = args62224.length;
switch (G__62226) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62224.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args62231 = [];
var len__28496__auto___62284 = arguments.length;
var i__28497__auto___62285 = (0);
while(true){
if((i__28497__auto___62285 < len__28496__auto___62284)){
args62231.push((arguments[i__28497__auto___62285]));

var G__62286 = (i__28497__auto___62285 + (1));
i__28497__auto___62285 = G__62286;
continue;
} else {
}
break;
}

var G__62233 = args62231.length;
switch (G__62233) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62231.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__41822__auto___62288 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62288,tc,fc){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62288,tc,fc){
return (function (state_62259){
var state_val_62260 = (state_62259[(1)]);
if((state_val_62260 === (7))){
var inst_62255 = (state_62259[(2)]);
var state_62259__$1 = state_62259;
var statearr_62261_62289 = state_62259__$1;
(statearr_62261_62289[(2)] = inst_62255);

(statearr_62261_62289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (1))){
var state_62259__$1 = state_62259;
var statearr_62262_62290 = state_62259__$1;
(statearr_62262_62290[(2)] = null);

(statearr_62262_62290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (4))){
var inst_62236 = (state_62259[(7)]);
var inst_62236__$1 = (state_62259[(2)]);
var inst_62237 = (inst_62236__$1 == null);
var state_62259__$1 = (function (){var statearr_62263 = state_62259;
(statearr_62263[(7)] = inst_62236__$1);

return statearr_62263;
})();
if(cljs.core.truth_(inst_62237)){
var statearr_62264_62291 = state_62259__$1;
(statearr_62264_62291[(1)] = (5));

} else {
var statearr_62265_62292 = state_62259__$1;
(statearr_62265_62292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (13))){
var state_62259__$1 = state_62259;
var statearr_62266_62293 = state_62259__$1;
(statearr_62266_62293[(2)] = null);

(statearr_62266_62293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (6))){
var inst_62236 = (state_62259[(7)]);
var inst_62242 = p.call(null,inst_62236);
var state_62259__$1 = state_62259;
if(cljs.core.truth_(inst_62242)){
var statearr_62267_62294 = state_62259__$1;
(statearr_62267_62294[(1)] = (9));

} else {
var statearr_62268_62295 = state_62259__$1;
(statearr_62268_62295[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (3))){
var inst_62257 = (state_62259[(2)]);
var state_62259__$1 = state_62259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62259__$1,inst_62257);
} else {
if((state_val_62260 === (12))){
var state_62259__$1 = state_62259;
var statearr_62269_62296 = state_62259__$1;
(statearr_62269_62296[(2)] = null);

(statearr_62269_62296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (2))){
var state_62259__$1 = state_62259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62259__$1,(4),ch);
} else {
if((state_val_62260 === (11))){
var inst_62236 = (state_62259[(7)]);
var inst_62246 = (state_62259[(2)]);
var state_62259__$1 = state_62259;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62259__$1,(8),inst_62246,inst_62236);
} else {
if((state_val_62260 === (9))){
var state_62259__$1 = state_62259;
var statearr_62270_62297 = state_62259__$1;
(statearr_62270_62297[(2)] = tc);

(statearr_62270_62297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (5))){
var inst_62239 = cljs.core.async.close_BANG_.call(null,tc);
var inst_62240 = cljs.core.async.close_BANG_.call(null,fc);
var state_62259__$1 = (function (){var statearr_62271 = state_62259;
(statearr_62271[(8)] = inst_62239);

return statearr_62271;
})();
var statearr_62272_62298 = state_62259__$1;
(statearr_62272_62298[(2)] = inst_62240);

(statearr_62272_62298[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (14))){
var inst_62253 = (state_62259[(2)]);
var state_62259__$1 = state_62259;
var statearr_62273_62299 = state_62259__$1;
(statearr_62273_62299[(2)] = inst_62253);

(statearr_62273_62299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (10))){
var state_62259__$1 = state_62259;
var statearr_62274_62300 = state_62259__$1;
(statearr_62274_62300[(2)] = fc);

(statearr_62274_62300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62260 === (8))){
var inst_62248 = (state_62259[(2)]);
var state_62259__$1 = state_62259;
if(cljs.core.truth_(inst_62248)){
var statearr_62275_62301 = state_62259__$1;
(statearr_62275_62301[(1)] = (12));

} else {
var statearr_62276_62302 = state_62259__$1;
(statearr_62276_62302[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62288,tc,fc))
;
return ((function (switch__41805__auto__,c__41822__auto___62288,tc,fc){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_62280 = [null,null,null,null,null,null,null,null,null];
(statearr_62280[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_62280[(1)] = (1));

return statearr_62280;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_62259){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62281){if((e62281 instanceof Object)){
var ex__41809__auto__ = e62281;
var statearr_62282_62303 = state_62259;
(statearr_62282_62303[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62281;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62304 = state_62259;
state_62259 = G__62304;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_62259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_62259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62288,tc,fc))
})();
var state__41824__auto__ = (function (){var statearr_62283 = f__41823__auto__.call(null);
(statearr_62283[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62288);

return statearr_62283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62288,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_62368){
var state_val_62369 = (state_62368[(1)]);
if((state_val_62369 === (7))){
var inst_62364 = (state_62368[(2)]);
var state_62368__$1 = state_62368;
var statearr_62370_62391 = state_62368__$1;
(statearr_62370_62391[(2)] = inst_62364);

(statearr_62370_62391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (1))){
var inst_62348 = init;
var state_62368__$1 = (function (){var statearr_62371 = state_62368;
(statearr_62371[(7)] = inst_62348);

return statearr_62371;
})();
var statearr_62372_62392 = state_62368__$1;
(statearr_62372_62392[(2)] = null);

(statearr_62372_62392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (4))){
var inst_62351 = (state_62368[(8)]);
var inst_62351__$1 = (state_62368[(2)]);
var inst_62352 = (inst_62351__$1 == null);
var state_62368__$1 = (function (){var statearr_62373 = state_62368;
(statearr_62373[(8)] = inst_62351__$1);

return statearr_62373;
})();
if(cljs.core.truth_(inst_62352)){
var statearr_62374_62393 = state_62368__$1;
(statearr_62374_62393[(1)] = (5));

} else {
var statearr_62375_62394 = state_62368__$1;
(statearr_62375_62394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (6))){
var inst_62351 = (state_62368[(8)]);
var inst_62355 = (state_62368[(9)]);
var inst_62348 = (state_62368[(7)]);
var inst_62355__$1 = f.call(null,inst_62348,inst_62351);
var inst_62356 = cljs.core.reduced_QMARK_.call(null,inst_62355__$1);
var state_62368__$1 = (function (){var statearr_62376 = state_62368;
(statearr_62376[(9)] = inst_62355__$1);

return statearr_62376;
})();
if(inst_62356){
var statearr_62377_62395 = state_62368__$1;
(statearr_62377_62395[(1)] = (8));

} else {
var statearr_62378_62396 = state_62368__$1;
(statearr_62378_62396[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (3))){
var inst_62366 = (state_62368[(2)]);
var state_62368__$1 = state_62368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62368__$1,inst_62366);
} else {
if((state_val_62369 === (2))){
var state_62368__$1 = state_62368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62368__$1,(4),ch);
} else {
if((state_val_62369 === (9))){
var inst_62355 = (state_62368[(9)]);
var inst_62348 = inst_62355;
var state_62368__$1 = (function (){var statearr_62379 = state_62368;
(statearr_62379[(7)] = inst_62348);

return statearr_62379;
})();
var statearr_62380_62397 = state_62368__$1;
(statearr_62380_62397[(2)] = null);

(statearr_62380_62397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (5))){
var inst_62348 = (state_62368[(7)]);
var state_62368__$1 = state_62368;
var statearr_62381_62398 = state_62368__$1;
(statearr_62381_62398[(2)] = inst_62348);

(statearr_62381_62398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (10))){
var inst_62362 = (state_62368[(2)]);
var state_62368__$1 = state_62368;
var statearr_62382_62399 = state_62368__$1;
(statearr_62382_62399[(2)] = inst_62362);

(statearr_62382_62399[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62369 === (8))){
var inst_62355 = (state_62368[(9)]);
var inst_62358 = cljs.core.deref.call(null,inst_62355);
var state_62368__$1 = state_62368;
var statearr_62383_62400 = state_62368__$1;
(statearr_62383_62400[(2)] = inst_62358);

(statearr_62383_62400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__41806__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41806__auto____0 = (function (){
var statearr_62387 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62387[(0)] = cljs$core$async$reduce_$_state_machine__41806__auto__);

(statearr_62387[(1)] = (1));

return statearr_62387;
});
var cljs$core$async$reduce_$_state_machine__41806__auto____1 = (function (state_62368){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62388){if((e62388 instanceof Object)){
var ex__41809__auto__ = e62388;
var statearr_62389_62401 = state_62368;
(statearr_62389_62401[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62402 = state_62368;
state_62368 = G__62402;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41806__auto__ = function(state_62368){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41806__auto____1.call(this,state_62368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41806__auto____0;
cljs$core$async$reduce_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41806__auto____1;
return cljs$core$async$reduce_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_62390 = f__41823__auto__.call(null);
(statearr_62390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args62403 = [];
var len__28496__auto___62455 = arguments.length;
var i__28497__auto___62456 = (0);
while(true){
if((i__28497__auto___62456 < len__28496__auto___62455)){
args62403.push((arguments[i__28497__auto___62456]));

var G__62457 = (i__28497__auto___62456 + (1));
i__28497__auto___62456 = G__62457;
continue;
} else {
}
break;
}

var G__62405 = args62403.length;
switch (G__62405) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62403.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_62430){
var state_val_62431 = (state_62430[(1)]);
if((state_val_62431 === (7))){
var inst_62412 = (state_62430[(2)]);
var state_62430__$1 = state_62430;
var statearr_62432_62459 = state_62430__$1;
(statearr_62432_62459[(2)] = inst_62412);

(statearr_62432_62459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (1))){
var inst_62406 = cljs.core.seq.call(null,coll);
var inst_62407 = inst_62406;
var state_62430__$1 = (function (){var statearr_62433 = state_62430;
(statearr_62433[(7)] = inst_62407);

return statearr_62433;
})();
var statearr_62434_62460 = state_62430__$1;
(statearr_62434_62460[(2)] = null);

(statearr_62434_62460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (4))){
var inst_62407 = (state_62430[(7)]);
var inst_62410 = cljs.core.first.call(null,inst_62407);
var state_62430__$1 = state_62430;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62430__$1,(7),ch,inst_62410);
} else {
if((state_val_62431 === (13))){
var inst_62424 = (state_62430[(2)]);
var state_62430__$1 = state_62430;
var statearr_62435_62461 = state_62430__$1;
(statearr_62435_62461[(2)] = inst_62424);

(statearr_62435_62461[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (6))){
var inst_62415 = (state_62430[(2)]);
var state_62430__$1 = state_62430;
if(cljs.core.truth_(inst_62415)){
var statearr_62436_62462 = state_62430__$1;
(statearr_62436_62462[(1)] = (8));

} else {
var statearr_62437_62463 = state_62430__$1;
(statearr_62437_62463[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (3))){
var inst_62428 = (state_62430[(2)]);
var state_62430__$1 = state_62430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62430__$1,inst_62428);
} else {
if((state_val_62431 === (12))){
var state_62430__$1 = state_62430;
var statearr_62438_62464 = state_62430__$1;
(statearr_62438_62464[(2)] = null);

(statearr_62438_62464[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (2))){
var inst_62407 = (state_62430[(7)]);
var state_62430__$1 = state_62430;
if(cljs.core.truth_(inst_62407)){
var statearr_62439_62465 = state_62430__$1;
(statearr_62439_62465[(1)] = (4));

} else {
var statearr_62440_62466 = state_62430__$1;
(statearr_62440_62466[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (11))){
var inst_62421 = cljs.core.async.close_BANG_.call(null,ch);
var state_62430__$1 = state_62430;
var statearr_62441_62467 = state_62430__$1;
(statearr_62441_62467[(2)] = inst_62421);

(statearr_62441_62467[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (9))){
var state_62430__$1 = state_62430;
if(cljs.core.truth_(close_QMARK_)){
var statearr_62442_62468 = state_62430__$1;
(statearr_62442_62468[(1)] = (11));

} else {
var statearr_62443_62469 = state_62430__$1;
(statearr_62443_62469[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (5))){
var inst_62407 = (state_62430[(7)]);
var state_62430__$1 = state_62430;
var statearr_62444_62470 = state_62430__$1;
(statearr_62444_62470[(2)] = inst_62407);

(statearr_62444_62470[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (10))){
var inst_62426 = (state_62430[(2)]);
var state_62430__$1 = state_62430;
var statearr_62445_62471 = state_62430__$1;
(statearr_62445_62471[(2)] = inst_62426);

(statearr_62445_62471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62431 === (8))){
var inst_62407 = (state_62430[(7)]);
var inst_62417 = cljs.core.next.call(null,inst_62407);
var inst_62407__$1 = inst_62417;
var state_62430__$1 = (function (){var statearr_62446 = state_62430;
(statearr_62446[(7)] = inst_62407__$1);

return statearr_62446;
})();
var statearr_62447_62472 = state_62430__$1;
(statearr_62447_62472[(2)] = null);

(statearr_62447_62472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_62451 = [null,null,null,null,null,null,null,null];
(statearr_62451[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_62451[(1)] = (1));

return statearr_62451;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_62430){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62452){if((e62452 instanceof Object)){
var ex__41809__auto__ = e62452;
var statearr_62453_62473 = state_62430;
(statearr_62453_62473[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62452;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62474 = state_62430;
state_62430 = G__62474;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_62430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_62430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_62454 = f__41823__auto__.call(null);
(statearr_62454[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async62700 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async62700 = (function (ch,cs,meta62701){
this.ch = ch;
this.cs = cs;
this.meta62701 = meta62701;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_62702,meta62701__$1){
var self__ = this;
var _62702__$1 = this;
return (new cljs.core.async.t_cljs$core$async62700(self__.ch,self__.cs,meta62701__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_62702){
var self__ = this;
var _62702__$1 = this;
return self__.meta62701;
});})(cs))
;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async62700.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async62700.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta62701","meta62701",-1981411647,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async62700.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async62700.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async62700";

cljs.core.async.t_cljs$core$async62700.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async62700");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async62700 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async62700(ch__$1,cs__$1,meta62701){
return (new cljs.core.async.t_cljs$core$async62700(ch__$1,cs__$1,meta62701));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async62700(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__41822__auto___62925 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62925,cs,m,dchan,dctr,done){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62925,cs,m,dchan,dctr,done){
return (function (state_62837){
var state_val_62838 = (state_62837[(1)]);
if((state_val_62838 === (7))){
var inst_62833 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62839_62926 = state_62837__$1;
(statearr_62839_62926[(2)] = inst_62833);

(statearr_62839_62926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (20))){
var inst_62736 = (state_62837[(7)]);
var inst_62748 = cljs.core.first.call(null,inst_62736);
var inst_62749 = cljs.core.nth.call(null,inst_62748,(0),null);
var inst_62750 = cljs.core.nth.call(null,inst_62748,(1),null);
var state_62837__$1 = (function (){var statearr_62840 = state_62837;
(statearr_62840[(8)] = inst_62749);

return statearr_62840;
})();
if(cljs.core.truth_(inst_62750)){
var statearr_62841_62927 = state_62837__$1;
(statearr_62841_62927[(1)] = (22));

} else {
var statearr_62842_62928 = state_62837__$1;
(statearr_62842_62928[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (27))){
var inst_62785 = (state_62837[(9)]);
var inst_62778 = (state_62837[(10)]);
var inst_62705 = (state_62837[(11)]);
var inst_62780 = (state_62837[(12)]);
var inst_62785__$1 = cljs.core._nth.call(null,inst_62778,inst_62780);
var inst_62786 = cljs.core.async.put_BANG_.call(null,inst_62785__$1,inst_62705,done);
var state_62837__$1 = (function (){var statearr_62843 = state_62837;
(statearr_62843[(9)] = inst_62785__$1);

return statearr_62843;
})();
if(cljs.core.truth_(inst_62786)){
var statearr_62844_62929 = state_62837__$1;
(statearr_62844_62929[(1)] = (30));

} else {
var statearr_62845_62930 = state_62837__$1;
(statearr_62845_62930[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (1))){
var state_62837__$1 = state_62837;
var statearr_62846_62931 = state_62837__$1;
(statearr_62846_62931[(2)] = null);

(statearr_62846_62931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (24))){
var inst_62736 = (state_62837[(7)]);
var inst_62755 = (state_62837[(2)]);
var inst_62756 = cljs.core.next.call(null,inst_62736);
var inst_62714 = inst_62756;
var inst_62715 = null;
var inst_62716 = (0);
var inst_62717 = (0);
var state_62837__$1 = (function (){var statearr_62847 = state_62837;
(statearr_62847[(13)] = inst_62716);

(statearr_62847[(14)] = inst_62755);

(statearr_62847[(15)] = inst_62714);

(statearr_62847[(16)] = inst_62715);

(statearr_62847[(17)] = inst_62717);

return statearr_62847;
})();
var statearr_62848_62932 = state_62837__$1;
(statearr_62848_62932[(2)] = null);

(statearr_62848_62932[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (39))){
var state_62837__$1 = state_62837;
var statearr_62852_62933 = state_62837__$1;
(statearr_62852_62933[(2)] = null);

(statearr_62852_62933[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (4))){
var inst_62705 = (state_62837[(11)]);
var inst_62705__$1 = (state_62837[(2)]);
var inst_62706 = (inst_62705__$1 == null);
var state_62837__$1 = (function (){var statearr_62853 = state_62837;
(statearr_62853[(11)] = inst_62705__$1);

return statearr_62853;
})();
if(cljs.core.truth_(inst_62706)){
var statearr_62854_62934 = state_62837__$1;
(statearr_62854_62934[(1)] = (5));

} else {
var statearr_62855_62935 = state_62837__$1;
(statearr_62855_62935[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (15))){
var inst_62716 = (state_62837[(13)]);
var inst_62714 = (state_62837[(15)]);
var inst_62715 = (state_62837[(16)]);
var inst_62717 = (state_62837[(17)]);
var inst_62732 = (state_62837[(2)]);
var inst_62733 = (inst_62717 + (1));
var tmp62849 = inst_62716;
var tmp62850 = inst_62714;
var tmp62851 = inst_62715;
var inst_62714__$1 = tmp62850;
var inst_62715__$1 = tmp62851;
var inst_62716__$1 = tmp62849;
var inst_62717__$1 = inst_62733;
var state_62837__$1 = (function (){var statearr_62856 = state_62837;
(statearr_62856[(13)] = inst_62716__$1);

(statearr_62856[(18)] = inst_62732);

(statearr_62856[(15)] = inst_62714__$1);

(statearr_62856[(16)] = inst_62715__$1);

(statearr_62856[(17)] = inst_62717__$1);

return statearr_62856;
})();
var statearr_62857_62936 = state_62837__$1;
(statearr_62857_62936[(2)] = null);

(statearr_62857_62936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (21))){
var inst_62759 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62861_62937 = state_62837__$1;
(statearr_62861_62937[(2)] = inst_62759);

(statearr_62861_62937[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (31))){
var inst_62785 = (state_62837[(9)]);
var inst_62789 = done.call(null,null);
var inst_62790 = cljs.core.async.untap_STAR_.call(null,m,inst_62785);
var state_62837__$1 = (function (){var statearr_62862 = state_62837;
(statearr_62862[(19)] = inst_62789);

return statearr_62862;
})();
var statearr_62863_62938 = state_62837__$1;
(statearr_62863_62938[(2)] = inst_62790);

(statearr_62863_62938[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (32))){
var inst_62777 = (state_62837[(20)]);
var inst_62778 = (state_62837[(10)]);
var inst_62779 = (state_62837[(21)]);
var inst_62780 = (state_62837[(12)]);
var inst_62792 = (state_62837[(2)]);
var inst_62793 = (inst_62780 + (1));
var tmp62858 = inst_62777;
var tmp62859 = inst_62778;
var tmp62860 = inst_62779;
var inst_62777__$1 = tmp62858;
var inst_62778__$1 = tmp62859;
var inst_62779__$1 = tmp62860;
var inst_62780__$1 = inst_62793;
var state_62837__$1 = (function (){var statearr_62864 = state_62837;
(statearr_62864[(20)] = inst_62777__$1);

(statearr_62864[(10)] = inst_62778__$1);

(statearr_62864[(21)] = inst_62779__$1);

(statearr_62864[(22)] = inst_62792);

(statearr_62864[(12)] = inst_62780__$1);

return statearr_62864;
})();
var statearr_62865_62939 = state_62837__$1;
(statearr_62865_62939[(2)] = null);

(statearr_62865_62939[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (40))){
var inst_62805 = (state_62837[(23)]);
var inst_62809 = done.call(null,null);
var inst_62810 = cljs.core.async.untap_STAR_.call(null,m,inst_62805);
var state_62837__$1 = (function (){var statearr_62866 = state_62837;
(statearr_62866[(24)] = inst_62809);

return statearr_62866;
})();
var statearr_62867_62940 = state_62837__$1;
(statearr_62867_62940[(2)] = inst_62810);

(statearr_62867_62940[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (33))){
var inst_62796 = (state_62837[(25)]);
var inst_62798 = cljs.core.chunked_seq_QMARK_.call(null,inst_62796);
var state_62837__$1 = state_62837;
if(inst_62798){
var statearr_62868_62941 = state_62837__$1;
(statearr_62868_62941[(1)] = (36));

} else {
var statearr_62869_62942 = state_62837__$1;
(statearr_62869_62942[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (13))){
var inst_62726 = (state_62837[(26)]);
var inst_62729 = cljs.core.async.close_BANG_.call(null,inst_62726);
var state_62837__$1 = state_62837;
var statearr_62870_62943 = state_62837__$1;
(statearr_62870_62943[(2)] = inst_62729);

(statearr_62870_62943[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (22))){
var inst_62749 = (state_62837[(8)]);
var inst_62752 = cljs.core.async.close_BANG_.call(null,inst_62749);
var state_62837__$1 = state_62837;
var statearr_62871_62944 = state_62837__$1;
(statearr_62871_62944[(2)] = inst_62752);

(statearr_62871_62944[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (36))){
var inst_62796 = (state_62837[(25)]);
var inst_62800 = cljs.core.chunk_first.call(null,inst_62796);
var inst_62801 = cljs.core.chunk_rest.call(null,inst_62796);
var inst_62802 = cljs.core.count.call(null,inst_62800);
var inst_62777 = inst_62801;
var inst_62778 = inst_62800;
var inst_62779 = inst_62802;
var inst_62780 = (0);
var state_62837__$1 = (function (){var statearr_62872 = state_62837;
(statearr_62872[(20)] = inst_62777);

(statearr_62872[(10)] = inst_62778);

(statearr_62872[(21)] = inst_62779);

(statearr_62872[(12)] = inst_62780);

return statearr_62872;
})();
var statearr_62873_62945 = state_62837__$1;
(statearr_62873_62945[(2)] = null);

(statearr_62873_62945[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (41))){
var inst_62796 = (state_62837[(25)]);
var inst_62812 = (state_62837[(2)]);
var inst_62813 = cljs.core.next.call(null,inst_62796);
var inst_62777 = inst_62813;
var inst_62778 = null;
var inst_62779 = (0);
var inst_62780 = (0);
var state_62837__$1 = (function (){var statearr_62874 = state_62837;
(statearr_62874[(20)] = inst_62777);

(statearr_62874[(10)] = inst_62778);

(statearr_62874[(21)] = inst_62779);

(statearr_62874[(27)] = inst_62812);

(statearr_62874[(12)] = inst_62780);

return statearr_62874;
})();
var statearr_62875_62946 = state_62837__$1;
(statearr_62875_62946[(2)] = null);

(statearr_62875_62946[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (43))){
var state_62837__$1 = state_62837;
var statearr_62876_62947 = state_62837__$1;
(statearr_62876_62947[(2)] = null);

(statearr_62876_62947[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (29))){
var inst_62821 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62877_62948 = state_62837__$1;
(statearr_62877_62948[(2)] = inst_62821);

(statearr_62877_62948[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (44))){
var inst_62830 = (state_62837[(2)]);
var state_62837__$1 = (function (){var statearr_62878 = state_62837;
(statearr_62878[(28)] = inst_62830);

return statearr_62878;
})();
var statearr_62879_62949 = state_62837__$1;
(statearr_62879_62949[(2)] = null);

(statearr_62879_62949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (6))){
var inst_62769 = (state_62837[(29)]);
var inst_62768 = cljs.core.deref.call(null,cs);
var inst_62769__$1 = cljs.core.keys.call(null,inst_62768);
var inst_62770 = cljs.core.count.call(null,inst_62769__$1);
var inst_62771 = cljs.core.reset_BANG_.call(null,dctr,inst_62770);
var inst_62776 = cljs.core.seq.call(null,inst_62769__$1);
var inst_62777 = inst_62776;
var inst_62778 = null;
var inst_62779 = (0);
var inst_62780 = (0);
var state_62837__$1 = (function (){var statearr_62880 = state_62837;
(statearr_62880[(29)] = inst_62769__$1);

(statearr_62880[(20)] = inst_62777);

(statearr_62880[(10)] = inst_62778);

(statearr_62880[(30)] = inst_62771);

(statearr_62880[(21)] = inst_62779);

(statearr_62880[(12)] = inst_62780);

return statearr_62880;
})();
var statearr_62881_62950 = state_62837__$1;
(statearr_62881_62950[(2)] = null);

(statearr_62881_62950[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (28))){
var inst_62777 = (state_62837[(20)]);
var inst_62796 = (state_62837[(25)]);
var inst_62796__$1 = cljs.core.seq.call(null,inst_62777);
var state_62837__$1 = (function (){var statearr_62882 = state_62837;
(statearr_62882[(25)] = inst_62796__$1);

return statearr_62882;
})();
if(inst_62796__$1){
var statearr_62883_62951 = state_62837__$1;
(statearr_62883_62951[(1)] = (33));

} else {
var statearr_62884_62952 = state_62837__$1;
(statearr_62884_62952[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (25))){
var inst_62779 = (state_62837[(21)]);
var inst_62780 = (state_62837[(12)]);
var inst_62782 = (inst_62780 < inst_62779);
var inst_62783 = inst_62782;
var state_62837__$1 = state_62837;
if(cljs.core.truth_(inst_62783)){
var statearr_62885_62953 = state_62837__$1;
(statearr_62885_62953[(1)] = (27));

} else {
var statearr_62886_62954 = state_62837__$1;
(statearr_62886_62954[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (34))){
var state_62837__$1 = state_62837;
var statearr_62887_62955 = state_62837__$1;
(statearr_62887_62955[(2)] = null);

(statearr_62887_62955[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (17))){
var state_62837__$1 = state_62837;
var statearr_62888_62956 = state_62837__$1;
(statearr_62888_62956[(2)] = null);

(statearr_62888_62956[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (3))){
var inst_62835 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62837__$1,inst_62835);
} else {
if((state_val_62838 === (12))){
var inst_62764 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62889_62957 = state_62837__$1;
(statearr_62889_62957[(2)] = inst_62764);

(statearr_62889_62957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (2))){
var state_62837__$1 = state_62837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62837__$1,(4),ch);
} else {
if((state_val_62838 === (23))){
var state_62837__$1 = state_62837;
var statearr_62890_62958 = state_62837__$1;
(statearr_62890_62958[(2)] = null);

(statearr_62890_62958[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (35))){
var inst_62819 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62891_62959 = state_62837__$1;
(statearr_62891_62959[(2)] = inst_62819);

(statearr_62891_62959[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (19))){
var inst_62736 = (state_62837[(7)]);
var inst_62740 = cljs.core.chunk_first.call(null,inst_62736);
var inst_62741 = cljs.core.chunk_rest.call(null,inst_62736);
var inst_62742 = cljs.core.count.call(null,inst_62740);
var inst_62714 = inst_62741;
var inst_62715 = inst_62740;
var inst_62716 = inst_62742;
var inst_62717 = (0);
var state_62837__$1 = (function (){var statearr_62892 = state_62837;
(statearr_62892[(13)] = inst_62716);

(statearr_62892[(15)] = inst_62714);

(statearr_62892[(16)] = inst_62715);

(statearr_62892[(17)] = inst_62717);

return statearr_62892;
})();
var statearr_62893_62960 = state_62837__$1;
(statearr_62893_62960[(2)] = null);

(statearr_62893_62960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (11))){
var inst_62714 = (state_62837[(15)]);
var inst_62736 = (state_62837[(7)]);
var inst_62736__$1 = cljs.core.seq.call(null,inst_62714);
var state_62837__$1 = (function (){var statearr_62894 = state_62837;
(statearr_62894[(7)] = inst_62736__$1);

return statearr_62894;
})();
if(inst_62736__$1){
var statearr_62895_62961 = state_62837__$1;
(statearr_62895_62961[(1)] = (16));

} else {
var statearr_62896_62962 = state_62837__$1;
(statearr_62896_62962[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (9))){
var inst_62766 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62897_62963 = state_62837__$1;
(statearr_62897_62963[(2)] = inst_62766);

(statearr_62897_62963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (5))){
var inst_62712 = cljs.core.deref.call(null,cs);
var inst_62713 = cljs.core.seq.call(null,inst_62712);
var inst_62714 = inst_62713;
var inst_62715 = null;
var inst_62716 = (0);
var inst_62717 = (0);
var state_62837__$1 = (function (){var statearr_62898 = state_62837;
(statearr_62898[(13)] = inst_62716);

(statearr_62898[(15)] = inst_62714);

(statearr_62898[(16)] = inst_62715);

(statearr_62898[(17)] = inst_62717);

return statearr_62898;
})();
var statearr_62899_62964 = state_62837__$1;
(statearr_62899_62964[(2)] = null);

(statearr_62899_62964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (14))){
var state_62837__$1 = state_62837;
var statearr_62900_62965 = state_62837__$1;
(statearr_62900_62965[(2)] = null);

(statearr_62900_62965[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (45))){
var inst_62827 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62901_62966 = state_62837__$1;
(statearr_62901_62966[(2)] = inst_62827);

(statearr_62901_62966[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (26))){
var inst_62769 = (state_62837[(29)]);
var inst_62823 = (state_62837[(2)]);
var inst_62824 = cljs.core.seq.call(null,inst_62769);
var state_62837__$1 = (function (){var statearr_62902 = state_62837;
(statearr_62902[(31)] = inst_62823);

return statearr_62902;
})();
if(inst_62824){
var statearr_62903_62967 = state_62837__$1;
(statearr_62903_62967[(1)] = (42));

} else {
var statearr_62904_62968 = state_62837__$1;
(statearr_62904_62968[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (16))){
var inst_62736 = (state_62837[(7)]);
var inst_62738 = cljs.core.chunked_seq_QMARK_.call(null,inst_62736);
var state_62837__$1 = state_62837;
if(inst_62738){
var statearr_62905_62969 = state_62837__$1;
(statearr_62905_62969[(1)] = (19));

} else {
var statearr_62906_62970 = state_62837__$1;
(statearr_62906_62970[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (38))){
var inst_62816 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62907_62971 = state_62837__$1;
(statearr_62907_62971[(2)] = inst_62816);

(statearr_62907_62971[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (30))){
var state_62837__$1 = state_62837;
var statearr_62908_62972 = state_62837__$1;
(statearr_62908_62972[(2)] = null);

(statearr_62908_62972[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (10))){
var inst_62715 = (state_62837[(16)]);
var inst_62717 = (state_62837[(17)]);
var inst_62725 = cljs.core._nth.call(null,inst_62715,inst_62717);
var inst_62726 = cljs.core.nth.call(null,inst_62725,(0),null);
var inst_62727 = cljs.core.nth.call(null,inst_62725,(1),null);
var state_62837__$1 = (function (){var statearr_62909 = state_62837;
(statearr_62909[(26)] = inst_62726);

return statearr_62909;
})();
if(cljs.core.truth_(inst_62727)){
var statearr_62910_62973 = state_62837__$1;
(statearr_62910_62973[(1)] = (13));

} else {
var statearr_62911_62974 = state_62837__$1;
(statearr_62911_62974[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (18))){
var inst_62762 = (state_62837[(2)]);
var state_62837__$1 = state_62837;
var statearr_62912_62975 = state_62837__$1;
(statearr_62912_62975[(2)] = inst_62762);

(statearr_62912_62975[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (42))){
var state_62837__$1 = state_62837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62837__$1,(45),dchan);
} else {
if((state_val_62838 === (37))){
var inst_62805 = (state_62837[(23)]);
var inst_62705 = (state_62837[(11)]);
var inst_62796 = (state_62837[(25)]);
var inst_62805__$1 = cljs.core.first.call(null,inst_62796);
var inst_62806 = cljs.core.async.put_BANG_.call(null,inst_62805__$1,inst_62705,done);
var state_62837__$1 = (function (){var statearr_62913 = state_62837;
(statearr_62913[(23)] = inst_62805__$1);

return statearr_62913;
})();
if(cljs.core.truth_(inst_62806)){
var statearr_62914_62976 = state_62837__$1;
(statearr_62914_62976[(1)] = (39));

} else {
var statearr_62915_62977 = state_62837__$1;
(statearr_62915_62977[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62838 === (8))){
var inst_62716 = (state_62837[(13)]);
var inst_62717 = (state_62837[(17)]);
var inst_62719 = (inst_62717 < inst_62716);
var inst_62720 = inst_62719;
var state_62837__$1 = state_62837;
if(cljs.core.truth_(inst_62720)){
var statearr_62916_62978 = state_62837__$1;
(statearr_62916_62978[(1)] = (10));

} else {
var statearr_62917_62979 = state_62837__$1;
(statearr_62917_62979[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62925,cs,m,dchan,dctr,done))
;
return ((function (switch__41805__auto__,c__41822__auto___62925,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__41806__auto__ = null;
var cljs$core$async$mult_$_state_machine__41806__auto____0 = (function (){
var statearr_62921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62921[(0)] = cljs$core$async$mult_$_state_machine__41806__auto__);

(statearr_62921[(1)] = (1));

return statearr_62921;
});
var cljs$core$async$mult_$_state_machine__41806__auto____1 = (function (state_62837){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62922){if((e62922 instanceof Object)){
var ex__41809__auto__ = e62922;
var statearr_62923_62980 = state_62837;
(statearr_62923_62980[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62837);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62981 = state_62837;
state_62837 = G__62981;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41806__auto__ = function(state_62837){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41806__auto____1.call(this,state_62837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41806__auto____0;
cljs$core$async$mult_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41806__auto____1;
return cljs$core$async$mult_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62925,cs,m,dchan,dctr,done))
})();
var state__41824__auto__ = (function (){var statearr_62924 = f__41823__auto__.call(null);
(statearr_62924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62925);

return statearr_62924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62925,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args62982 = [];
var len__28496__auto___62985 = arguments.length;
var i__28497__auto___62986 = (0);
while(true){
if((i__28497__auto___62986 < len__28496__auto___62985)){
args62982.push((arguments[i__28497__auto___62986]));

var G__62987 = (i__28497__auto___62986 + (1));
i__28497__auto___62986 = G__62987;
continue;
} else {
}
break;
}

var G__62984 = args62982.length;
switch (G__62984) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62982.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,state_map);
} else {
var m__27994__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,mode);
} else {
var m__27994__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___62999 = arguments.length;
var i__28497__auto___63000 = (0);
while(true){
if((i__28497__auto___63000 < len__28496__auto___62999)){
args__28503__auto__.push((arguments[i__28497__auto___63000]));

var G__63001 = (i__28497__auto___63000 + (1));
i__28497__auto___63000 = G__63001;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((3) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28504__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__62993){
var map__62994 = p__62993;
var map__62994__$1 = ((((!((map__62994 == null)))?((((map__62994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62994.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62994):map__62994);
var opts = map__62994__$1;
var statearr_62996_63002 = state;
(statearr_62996_63002[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__62994,map__62994__$1,opts){
return (function (val){
var statearr_62997_63003 = state;
(statearr_62997_63003[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__62994,map__62994__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_62998_63004 = state;
(statearr_62998_63004[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq62989){
var G__62990 = cljs.core.first.call(null,seq62989);
var seq62989__$1 = cljs.core.next.call(null,seq62989);
var G__62991 = cljs.core.first.call(null,seq62989__$1);
var seq62989__$2 = cljs.core.next.call(null,seq62989__$1);
var G__62992 = cljs.core.first.call(null,seq62989__$2);
var seq62989__$3 = cljs.core.next.call(null,seq62989__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__62990,G__62991,G__62992,seq62989__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async63172 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63172 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta63173){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta63173 = meta63173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_63174,meta63173__$1){
var self__ = this;
var _63174__$1 = this;
return (new cljs.core.async.t_cljs$core$async63172(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta63173__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_63174){
var self__ = this;
var _63174__$1 = this;
return self__.meta63173;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63172.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async63172.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta63173","meta63173",1036720191,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async63172.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63172";

cljs.core.async.t_cljs$core$async63172.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63172");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async63172 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async63172(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta63173){
return (new cljs.core.async.t_cljs$core$async63172(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta63173));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async63172(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41822__auto___63339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_63276){
var state_val_63277 = (state_63276[(1)]);
if((state_val_63277 === (7))){
var inst_63191 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
var statearr_63278_63340 = state_63276__$1;
(statearr_63278_63340[(2)] = inst_63191);

(statearr_63278_63340[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (20))){
var inst_63203 = (state_63276[(7)]);
var state_63276__$1 = state_63276;
var statearr_63279_63341 = state_63276__$1;
(statearr_63279_63341[(2)] = inst_63203);

(statearr_63279_63341[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (27))){
var state_63276__$1 = state_63276;
var statearr_63280_63342 = state_63276__$1;
(statearr_63280_63342[(2)] = null);

(statearr_63280_63342[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (1))){
var inst_63178 = (state_63276[(8)]);
var inst_63178__$1 = calc_state.call(null);
var inst_63180 = (inst_63178__$1 == null);
var inst_63181 = cljs.core.not.call(null,inst_63180);
var state_63276__$1 = (function (){var statearr_63281 = state_63276;
(statearr_63281[(8)] = inst_63178__$1);

return statearr_63281;
})();
if(inst_63181){
var statearr_63282_63343 = state_63276__$1;
(statearr_63282_63343[(1)] = (2));

} else {
var statearr_63283_63344 = state_63276__$1;
(statearr_63283_63344[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (24))){
var inst_63236 = (state_63276[(9)]);
var inst_63250 = (state_63276[(10)]);
var inst_63227 = (state_63276[(11)]);
var inst_63250__$1 = inst_63227.call(null,inst_63236);
var state_63276__$1 = (function (){var statearr_63284 = state_63276;
(statearr_63284[(10)] = inst_63250__$1);

return statearr_63284;
})();
if(cljs.core.truth_(inst_63250__$1)){
var statearr_63285_63345 = state_63276__$1;
(statearr_63285_63345[(1)] = (29));

} else {
var statearr_63286_63346 = state_63276__$1;
(statearr_63286_63346[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (4))){
var inst_63194 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63194)){
var statearr_63287_63347 = state_63276__$1;
(statearr_63287_63347[(1)] = (8));

} else {
var statearr_63288_63348 = state_63276__$1;
(statearr_63288_63348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (15))){
var inst_63221 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63221)){
var statearr_63289_63349 = state_63276__$1;
(statearr_63289_63349[(1)] = (19));

} else {
var statearr_63290_63350 = state_63276__$1;
(statearr_63290_63350[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (21))){
var inst_63226 = (state_63276[(12)]);
var inst_63226__$1 = (state_63276[(2)]);
var inst_63227 = cljs.core.get.call(null,inst_63226__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_63228 = cljs.core.get.call(null,inst_63226__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_63229 = cljs.core.get.call(null,inst_63226__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_63276__$1 = (function (){var statearr_63291 = state_63276;
(statearr_63291[(12)] = inst_63226__$1);

(statearr_63291[(11)] = inst_63227);

(statearr_63291[(13)] = inst_63228);

return statearr_63291;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_63276__$1,(22),inst_63229);
} else {
if((state_val_63277 === (31))){
var inst_63258 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63258)){
var statearr_63292_63351 = state_63276__$1;
(statearr_63292_63351[(1)] = (32));

} else {
var statearr_63293_63352 = state_63276__$1;
(statearr_63293_63352[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (32))){
var inst_63235 = (state_63276[(14)]);
var state_63276__$1 = state_63276;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63276__$1,(35),out,inst_63235);
} else {
if((state_val_63277 === (33))){
var inst_63226 = (state_63276[(12)]);
var inst_63203 = inst_63226;
var state_63276__$1 = (function (){var statearr_63294 = state_63276;
(statearr_63294[(7)] = inst_63203);

return statearr_63294;
})();
var statearr_63295_63353 = state_63276__$1;
(statearr_63295_63353[(2)] = null);

(statearr_63295_63353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (13))){
var inst_63203 = (state_63276[(7)]);
var inst_63210 = inst_63203.cljs$lang$protocol_mask$partition0$;
var inst_63211 = (inst_63210 & (64));
var inst_63212 = inst_63203.cljs$core$ISeq$;
var inst_63213 = (cljs.core.PROTOCOL_SENTINEL === inst_63212);
var inst_63214 = (inst_63211) || (inst_63213);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63214)){
var statearr_63296_63354 = state_63276__$1;
(statearr_63296_63354[(1)] = (16));

} else {
var statearr_63297_63355 = state_63276__$1;
(statearr_63297_63355[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (22))){
var inst_63236 = (state_63276[(9)]);
var inst_63235 = (state_63276[(14)]);
var inst_63234 = (state_63276[(2)]);
var inst_63235__$1 = cljs.core.nth.call(null,inst_63234,(0),null);
var inst_63236__$1 = cljs.core.nth.call(null,inst_63234,(1),null);
var inst_63237 = (inst_63235__$1 == null);
var inst_63238 = cljs.core._EQ_.call(null,inst_63236__$1,change);
var inst_63239 = (inst_63237) || (inst_63238);
var state_63276__$1 = (function (){var statearr_63298 = state_63276;
(statearr_63298[(9)] = inst_63236__$1);

(statearr_63298[(14)] = inst_63235__$1);

return statearr_63298;
})();
if(cljs.core.truth_(inst_63239)){
var statearr_63299_63356 = state_63276__$1;
(statearr_63299_63356[(1)] = (23));

} else {
var statearr_63300_63357 = state_63276__$1;
(statearr_63300_63357[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (36))){
var inst_63226 = (state_63276[(12)]);
var inst_63203 = inst_63226;
var state_63276__$1 = (function (){var statearr_63301 = state_63276;
(statearr_63301[(7)] = inst_63203);

return statearr_63301;
})();
var statearr_63302_63358 = state_63276__$1;
(statearr_63302_63358[(2)] = null);

(statearr_63302_63358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (29))){
var inst_63250 = (state_63276[(10)]);
var state_63276__$1 = state_63276;
var statearr_63303_63359 = state_63276__$1;
(statearr_63303_63359[(2)] = inst_63250);

(statearr_63303_63359[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (6))){
var state_63276__$1 = state_63276;
var statearr_63304_63360 = state_63276__$1;
(statearr_63304_63360[(2)] = false);

(statearr_63304_63360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (28))){
var inst_63246 = (state_63276[(2)]);
var inst_63247 = calc_state.call(null);
var inst_63203 = inst_63247;
var state_63276__$1 = (function (){var statearr_63305 = state_63276;
(statearr_63305[(15)] = inst_63246);

(statearr_63305[(7)] = inst_63203);

return statearr_63305;
})();
var statearr_63306_63361 = state_63276__$1;
(statearr_63306_63361[(2)] = null);

(statearr_63306_63361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (25))){
var inst_63272 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
var statearr_63307_63362 = state_63276__$1;
(statearr_63307_63362[(2)] = inst_63272);

(statearr_63307_63362[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (34))){
var inst_63270 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
var statearr_63308_63363 = state_63276__$1;
(statearr_63308_63363[(2)] = inst_63270);

(statearr_63308_63363[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (17))){
var state_63276__$1 = state_63276;
var statearr_63309_63364 = state_63276__$1;
(statearr_63309_63364[(2)] = false);

(statearr_63309_63364[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (3))){
var state_63276__$1 = state_63276;
var statearr_63310_63365 = state_63276__$1;
(statearr_63310_63365[(2)] = false);

(statearr_63310_63365[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (12))){
var inst_63274 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63276__$1,inst_63274);
} else {
if((state_val_63277 === (2))){
var inst_63178 = (state_63276[(8)]);
var inst_63183 = inst_63178.cljs$lang$protocol_mask$partition0$;
var inst_63184 = (inst_63183 & (64));
var inst_63185 = inst_63178.cljs$core$ISeq$;
var inst_63186 = (cljs.core.PROTOCOL_SENTINEL === inst_63185);
var inst_63187 = (inst_63184) || (inst_63186);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63187)){
var statearr_63311_63366 = state_63276__$1;
(statearr_63311_63366[(1)] = (5));

} else {
var statearr_63312_63367 = state_63276__$1;
(statearr_63312_63367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (23))){
var inst_63235 = (state_63276[(14)]);
var inst_63241 = (inst_63235 == null);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63241)){
var statearr_63313_63368 = state_63276__$1;
(statearr_63313_63368[(1)] = (26));

} else {
var statearr_63314_63369 = state_63276__$1;
(statearr_63314_63369[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (35))){
var inst_63261 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
if(cljs.core.truth_(inst_63261)){
var statearr_63315_63370 = state_63276__$1;
(statearr_63315_63370[(1)] = (36));

} else {
var statearr_63316_63371 = state_63276__$1;
(statearr_63316_63371[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (19))){
var inst_63203 = (state_63276[(7)]);
var inst_63223 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63203);
var state_63276__$1 = state_63276;
var statearr_63317_63372 = state_63276__$1;
(statearr_63317_63372[(2)] = inst_63223);

(statearr_63317_63372[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (11))){
var inst_63203 = (state_63276[(7)]);
var inst_63207 = (inst_63203 == null);
var inst_63208 = cljs.core.not.call(null,inst_63207);
var state_63276__$1 = state_63276;
if(inst_63208){
var statearr_63318_63373 = state_63276__$1;
(statearr_63318_63373[(1)] = (13));

} else {
var statearr_63319_63374 = state_63276__$1;
(statearr_63319_63374[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (9))){
var inst_63178 = (state_63276[(8)]);
var state_63276__$1 = state_63276;
var statearr_63320_63375 = state_63276__$1;
(statearr_63320_63375[(2)] = inst_63178);

(statearr_63320_63375[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (5))){
var state_63276__$1 = state_63276;
var statearr_63321_63376 = state_63276__$1;
(statearr_63321_63376[(2)] = true);

(statearr_63321_63376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (14))){
var state_63276__$1 = state_63276;
var statearr_63322_63377 = state_63276__$1;
(statearr_63322_63377[(2)] = false);

(statearr_63322_63377[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (26))){
var inst_63236 = (state_63276[(9)]);
var inst_63243 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_63236);
var state_63276__$1 = state_63276;
var statearr_63323_63378 = state_63276__$1;
(statearr_63323_63378[(2)] = inst_63243);

(statearr_63323_63378[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (16))){
var state_63276__$1 = state_63276;
var statearr_63324_63379 = state_63276__$1;
(statearr_63324_63379[(2)] = true);

(statearr_63324_63379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (38))){
var inst_63266 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
var statearr_63325_63380 = state_63276__$1;
(statearr_63325_63380[(2)] = inst_63266);

(statearr_63325_63380[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (30))){
var inst_63236 = (state_63276[(9)]);
var inst_63227 = (state_63276[(11)]);
var inst_63228 = (state_63276[(13)]);
var inst_63253 = cljs.core.empty_QMARK_.call(null,inst_63227);
var inst_63254 = inst_63228.call(null,inst_63236);
var inst_63255 = cljs.core.not.call(null,inst_63254);
var inst_63256 = (inst_63253) && (inst_63255);
var state_63276__$1 = state_63276;
var statearr_63326_63381 = state_63276__$1;
(statearr_63326_63381[(2)] = inst_63256);

(statearr_63326_63381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (10))){
var inst_63178 = (state_63276[(8)]);
var inst_63199 = (state_63276[(2)]);
var inst_63200 = cljs.core.get.call(null,inst_63199,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_63201 = cljs.core.get.call(null,inst_63199,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_63202 = cljs.core.get.call(null,inst_63199,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_63203 = inst_63178;
var state_63276__$1 = (function (){var statearr_63327 = state_63276;
(statearr_63327[(16)] = inst_63201);

(statearr_63327[(7)] = inst_63203);

(statearr_63327[(17)] = inst_63200);

(statearr_63327[(18)] = inst_63202);

return statearr_63327;
})();
var statearr_63328_63382 = state_63276__$1;
(statearr_63328_63382[(2)] = null);

(statearr_63328_63382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (18))){
var inst_63218 = (state_63276[(2)]);
var state_63276__$1 = state_63276;
var statearr_63329_63383 = state_63276__$1;
(statearr_63329_63383[(2)] = inst_63218);

(statearr_63329_63383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (37))){
var state_63276__$1 = state_63276;
var statearr_63330_63384 = state_63276__$1;
(statearr_63330_63384[(2)] = null);

(statearr_63330_63384[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63277 === (8))){
var inst_63178 = (state_63276[(8)]);
var inst_63196 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63178);
var state_63276__$1 = state_63276;
var statearr_63331_63385 = state_63276__$1;
(statearr_63331_63385[(2)] = inst_63196);

(statearr_63331_63385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__41805__auto__,c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__41806__auto__ = null;
var cljs$core$async$mix_$_state_machine__41806__auto____0 = (function (){
var statearr_63335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63335[(0)] = cljs$core$async$mix_$_state_machine__41806__auto__);

(statearr_63335[(1)] = (1));

return statearr_63335;
});
var cljs$core$async$mix_$_state_machine__41806__auto____1 = (function (state_63276){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63336){if((e63336 instanceof Object)){
var ex__41809__auto__ = e63336;
var statearr_63337_63386 = state_63276;
(statearr_63337_63386[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63276);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63387 = state_63276;
state_63276 = G__63387;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41806__auto__ = function(state_63276){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41806__auto____1.call(this,state_63276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41806__auto____0;
cljs$core$async$mix_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41806__auto____1;
return cljs$core$async$mix_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__41824__auto__ = (function (){var statearr_63338 = f__41823__auto__.call(null);
(statearr_63338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63339);

return statearr_63338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63339,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args63388 = [];
var len__28496__auto___63391 = arguments.length;
var i__28497__auto___63392 = (0);
while(true){
if((i__28497__auto___63392 < len__28496__auto___63391)){
args63388.push((arguments[i__28497__auto___63392]));

var G__63393 = (i__28497__auto___63392 + (1));
i__28497__auto___63392 = G__63393;
continue;
} else {
}
break;
}

var G__63390 = args63388.length;
switch (G__63390) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63388.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args63396 = [];
var len__28496__auto___63521 = arguments.length;
var i__28497__auto___63522 = (0);
while(true){
if((i__28497__auto___63522 < len__28496__auto___63521)){
args63396.push((arguments[i__28497__auto___63522]));

var G__63523 = (i__28497__auto___63522 + (1));
i__28497__auto___63522 = G__63523;
continue;
} else {
}
break;
}

var G__63398 = args63396.length;
switch (G__63398) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63396.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27280__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27280__auto__,mults){
return (function (p1__63395_SHARP_){
if(cljs.core.truth_(p1__63395_SHARP_.call(null,topic))){
return p1__63395_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__63395_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27280__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async63399 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63399 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta63400){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta63400 = meta63400;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_63401,meta63400__$1){
var self__ = this;
var _63401__$1 = this;
return (new cljs.core.async.t_cljs$core$async63399(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta63400__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_63401){
var self__ = this;
var _63401__$1 = this;
return self__.meta63400;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63399.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async63399.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta63400","meta63400",1209282298,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async63399.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63399.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63399";

cljs.core.async.t_cljs$core$async63399.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63399");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async63399 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async63399(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta63400){
return (new cljs.core.async.t_cljs$core$async63399(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta63400));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async63399(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41822__auto___63525 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63525,mults,ensure_mult,p){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63525,mults,ensure_mult,p){
return (function (state_63473){
var state_val_63474 = (state_63473[(1)]);
if((state_val_63474 === (7))){
var inst_63469 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63475_63526 = state_63473__$1;
(statearr_63475_63526[(2)] = inst_63469);

(statearr_63475_63526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (20))){
var state_63473__$1 = state_63473;
var statearr_63476_63527 = state_63473__$1;
(statearr_63476_63527[(2)] = null);

(statearr_63476_63527[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (1))){
var state_63473__$1 = state_63473;
var statearr_63477_63528 = state_63473__$1;
(statearr_63477_63528[(2)] = null);

(statearr_63477_63528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (24))){
var inst_63452 = (state_63473[(7)]);
var inst_63461 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_63452);
var state_63473__$1 = state_63473;
var statearr_63478_63529 = state_63473__$1;
(statearr_63478_63529[(2)] = inst_63461);

(statearr_63478_63529[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (4))){
var inst_63404 = (state_63473[(8)]);
var inst_63404__$1 = (state_63473[(2)]);
var inst_63405 = (inst_63404__$1 == null);
var state_63473__$1 = (function (){var statearr_63479 = state_63473;
(statearr_63479[(8)] = inst_63404__$1);

return statearr_63479;
})();
if(cljs.core.truth_(inst_63405)){
var statearr_63480_63530 = state_63473__$1;
(statearr_63480_63530[(1)] = (5));

} else {
var statearr_63481_63531 = state_63473__$1;
(statearr_63481_63531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (15))){
var inst_63446 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63482_63532 = state_63473__$1;
(statearr_63482_63532[(2)] = inst_63446);

(statearr_63482_63532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (21))){
var inst_63466 = (state_63473[(2)]);
var state_63473__$1 = (function (){var statearr_63483 = state_63473;
(statearr_63483[(9)] = inst_63466);

return statearr_63483;
})();
var statearr_63484_63533 = state_63473__$1;
(statearr_63484_63533[(2)] = null);

(statearr_63484_63533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (13))){
var inst_63428 = (state_63473[(10)]);
var inst_63430 = cljs.core.chunked_seq_QMARK_.call(null,inst_63428);
var state_63473__$1 = state_63473;
if(inst_63430){
var statearr_63485_63534 = state_63473__$1;
(statearr_63485_63534[(1)] = (16));

} else {
var statearr_63486_63535 = state_63473__$1;
(statearr_63486_63535[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (22))){
var inst_63458 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
if(cljs.core.truth_(inst_63458)){
var statearr_63487_63536 = state_63473__$1;
(statearr_63487_63536[(1)] = (23));

} else {
var statearr_63488_63537 = state_63473__$1;
(statearr_63488_63537[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (6))){
var inst_63454 = (state_63473[(11)]);
var inst_63404 = (state_63473[(8)]);
var inst_63452 = (state_63473[(7)]);
var inst_63452__$1 = topic_fn.call(null,inst_63404);
var inst_63453 = cljs.core.deref.call(null,mults);
var inst_63454__$1 = cljs.core.get.call(null,inst_63453,inst_63452__$1);
var state_63473__$1 = (function (){var statearr_63489 = state_63473;
(statearr_63489[(11)] = inst_63454__$1);

(statearr_63489[(7)] = inst_63452__$1);

return statearr_63489;
})();
if(cljs.core.truth_(inst_63454__$1)){
var statearr_63490_63538 = state_63473__$1;
(statearr_63490_63538[(1)] = (19));

} else {
var statearr_63491_63539 = state_63473__$1;
(statearr_63491_63539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (25))){
var inst_63463 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63492_63540 = state_63473__$1;
(statearr_63492_63540[(2)] = inst_63463);

(statearr_63492_63540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (17))){
var inst_63428 = (state_63473[(10)]);
var inst_63437 = cljs.core.first.call(null,inst_63428);
var inst_63438 = cljs.core.async.muxch_STAR_.call(null,inst_63437);
var inst_63439 = cljs.core.async.close_BANG_.call(null,inst_63438);
var inst_63440 = cljs.core.next.call(null,inst_63428);
var inst_63414 = inst_63440;
var inst_63415 = null;
var inst_63416 = (0);
var inst_63417 = (0);
var state_63473__$1 = (function (){var statearr_63493 = state_63473;
(statearr_63493[(12)] = inst_63415);

(statearr_63493[(13)] = inst_63416);

(statearr_63493[(14)] = inst_63439);

(statearr_63493[(15)] = inst_63414);

(statearr_63493[(16)] = inst_63417);

return statearr_63493;
})();
var statearr_63494_63541 = state_63473__$1;
(statearr_63494_63541[(2)] = null);

(statearr_63494_63541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (3))){
var inst_63471 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63473__$1,inst_63471);
} else {
if((state_val_63474 === (12))){
var inst_63448 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63495_63542 = state_63473__$1;
(statearr_63495_63542[(2)] = inst_63448);

(statearr_63495_63542[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (2))){
var state_63473__$1 = state_63473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63473__$1,(4),ch);
} else {
if((state_val_63474 === (23))){
var state_63473__$1 = state_63473;
var statearr_63496_63543 = state_63473__$1;
(statearr_63496_63543[(2)] = null);

(statearr_63496_63543[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (19))){
var inst_63454 = (state_63473[(11)]);
var inst_63404 = (state_63473[(8)]);
var inst_63456 = cljs.core.async.muxch_STAR_.call(null,inst_63454);
var state_63473__$1 = state_63473;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63473__$1,(22),inst_63456,inst_63404);
} else {
if((state_val_63474 === (11))){
var inst_63428 = (state_63473[(10)]);
var inst_63414 = (state_63473[(15)]);
var inst_63428__$1 = cljs.core.seq.call(null,inst_63414);
var state_63473__$1 = (function (){var statearr_63497 = state_63473;
(statearr_63497[(10)] = inst_63428__$1);

return statearr_63497;
})();
if(inst_63428__$1){
var statearr_63498_63544 = state_63473__$1;
(statearr_63498_63544[(1)] = (13));

} else {
var statearr_63499_63545 = state_63473__$1;
(statearr_63499_63545[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (9))){
var inst_63450 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63500_63546 = state_63473__$1;
(statearr_63500_63546[(2)] = inst_63450);

(statearr_63500_63546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (5))){
var inst_63411 = cljs.core.deref.call(null,mults);
var inst_63412 = cljs.core.vals.call(null,inst_63411);
var inst_63413 = cljs.core.seq.call(null,inst_63412);
var inst_63414 = inst_63413;
var inst_63415 = null;
var inst_63416 = (0);
var inst_63417 = (0);
var state_63473__$1 = (function (){var statearr_63501 = state_63473;
(statearr_63501[(12)] = inst_63415);

(statearr_63501[(13)] = inst_63416);

(statearr_63501[(15)] = inst_63414);

(statearr_63501[(16)] = inst_63417);

return statearr_63501;
})();
var statearr_63502_63547 = state_63473__$1;
(statearr_63502_63547[(2)] = null);

(statearr_63502_63547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (14))){
var state_63473__$1 = state_63473;
var statearr_63506_63548 = state_63473__$1;
(statearr_63506_63548[(2)] = null);

(statearr_63506_63548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (16))){
var inst_63428 = (state_63473[(10)]);
var inst_63432 = cljs.core.chunk_first.call(null,inst_63428);
var inst_63433 = cljs.core.chunk_rest.call(null,inst_63428);
var inst_63434 = cljs.core.count.call(null,inst_63432);
var inst_63414 = inst_63433;
var inst_63415 = inst_63432;
var inst_63416 = inst_63434;
var inst_63417 = (0);
var state_63473__$1 = (function (){var statearr_63507 = state_63473;
(statearr_63507[(12)] = inst_63415);

(statearr_63507[(13)] = inst_63416);

(statearr_63507[(15)] = inst_63414);

(statearr_63507[(16)] = inst_63417);

return statearr_63507;
})();
var statearr_63508_63549 = state_63473__$1;
(statearr_63508_63549[(2)] = null);

(statearr_63508_63549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (10))){
var inst_63415 = (state_63473[(12)]);
var inst_63416 = (state_63473[(13)]);
var inst_63414 = (state_63473[(15)]);
var inst_63417 = (state_63473[(16)]);
var inst_63422 = cljs.core._nth.call(null,inst_63415,inst_63417);
var inst_63423 = cljs.core.async.muxch_STAR_.call(null,inst_63422);
var inst_63424 = cljs.core.async.close_BANG_.call(null,inst_63423);
var inst_63425 = (inst_63417 + (1));
var tmp63503 = inst_63415;
var tmp63504 = inst_63416;
var tmp63505 = inst_63414;
var inst_63414__$1 = tmp63505;
var inst_63415__$1 = tmp63503;
var inst_63416__$1 = tmp63504;
var inst_63417__$1 = inst_63425;
var state_63473__$1 = (function (){var statearr_63509 = state_63473;
(statearr_63509[(17)] = inst_63424);

(statearr_63509[(12)] = inst_63415__$1);

(statearr_63509[(13)] = inst_63416__$1);

(statearr_63509[(15)] = inst_63414__$1);

(statearr_63509[(16)] = inst_63417__$1);

return statearr_63509;
})();
var statearr_63510_63550 = state_63473__$1;
(statearr_63510_63550[(2)] = null);

(statearr_63510_63550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (18))){
var inst_63443 = (state_63473[(2)]);
var state_63473__$1 = state_63473;
var statearr_63511_63551 = state_63473__$1;
(statearr_63511_63551[(2)] = inst_63443);

(statearr_63511_63551[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63474 === (8))){
var inst_63416 = (state_63473[(13)]);
var inst_63417 = (state_63473[(16)]);
var inst_63419 = (inst_63417 < inst_63416);
var inst_63420 = inst_63419;
var state_63473__$1 = state_63473;
if(cljs.core.truth_(inst_63420)){
var statearr_63512_63552 = state_63473__$1;
(statearr_63512_63552[(1)] = (10));

} else {
var statearr_63513_63553 = state_63473__$1;
(statearr_63513_63553[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63525,mults,ensure_mult,p))
;
return ((function (switch__41805__auto__,c__41822__auto___63525,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63517[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63517[(1)] = (1));

return statearr_63517;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63473){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63518){if((e63518 instanceof Object)){
var ex__41809__auto__ = e63518;
var statearr_63519_63554 = state_63473;
(statearr_63519_63554[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63555 = state_63473;
state_63473 = G__63555;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63473){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63525,mults,ensure_mult,p))
})();
var state__41824__auto__ = (function (){var statearr_63520 = f__41823__auto__.call(null);
(statearr_63520[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63525);

return statearr_63520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63525,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args63556 = [];
var len__28496__auto___63559 = arguments.length;
var i__28497__auto___63560 = (0);
while(true){
if((i__28497__auto___63560 < len__28496__auto___63559)){
args63556.push((arguments[i__28497__auto___63560]));

var G__63561 = (i__28497__auto___63560 + (1));
i__28497__auto___63560 = G__63561;
continue;
} else {
}
break;
}

var G__63558 = args63556.length;
switch (G__63558) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63556.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args63563 = [];
var len__28496__auto___63566 = arguments.length;
var i__28497__auto___63567 = (0);
while(true){
if((i__28497__auto___63567 < len__28496__auto___63566)){
args63563.push((arguments[i__28497__auto___63567]));

var G__63568 = (i__28497__auto___63567 + (1));
i__28497__auto___63567 = G__63568;
continue;
} else {
}
break;
}

var G__63565 = args63563.length;
switch (G__63565) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63563.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args63570 = [];
var len__28496__auto___63641 = arguments.length;
var i__28497__auto___63642 = (0);
while(true){
if((i__28497__auto___63642 < len__28496__auto___63641)){
args63570.push((arguments[i__28497__auto___63642]));

var G__63643 = (i__28497__auto___63642 + (1));
i__28497__auto___63642 = G__63643;
continue;
} else {
}
break;
}

var G__63572 = args63570.length;
switch (G__63572) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63570.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__41822__auto___63645 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_63611){
var state_val_63612 = (state_63611[(1)]);
if((state_val_63612 === (7))){
var state_63611__$1 = state_63611;
var statearr_63613_63646 = state_63611__$1;
(statearr_63613_63646[(2)] = null);

(statearr_63613_63646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (1))){
var state_63611__$1 = state_63611;
var statearr_63614_63647 = state_63611__$1;
(statearr_63614_63647[(2)] = null);

(statearr_63614_63647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (4))){
var inst_63575 = (state_63611[(7)]);
var inst_63577 = (inst_63575 < cnt);
var state_63611__$1 = state_63611;
if(cljs.core.truth_(inst_63577)){
var statearr_63615_63648 = state_63611__$1;
(statearr_63615_63648[(1)] = (6));

} else {
var statearr_63616_63649 = state_63611__$1;
(statearr_63616_63649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (15))){
var inst_63607 = (state_63611[(2)]);
var state_63611__$1 = state_63611;
var statearr_63617_63650 = state_63611__$1;
(statearr_63617_63650[(2)] = inst_63607);

(statearr_63617_63650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (13))){
var inst_63600 = cljs.core.async.close_BANG_.call(null,out);
var state_63611__$1 = state_63611;
var statearr_63618_63651 = state_63611__$1;
(statearr_63618_63651[(2)] = inst_63600);

(statearr_63618_63651[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (6))){
var state_63611__$1 = state_63611;
var statearr_63619_63652 = state_63611__$1;
(statearr_63619_63652[(2)] = null);

(statearr_63619_63652[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (3))){
var inst_63609 = (state_63611[(2)]);
var state_63611__$1 = state_63611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63611__$1,inst_63609);
} else {
if((state_val_63612 === (12))){
var inst_63597 = (state_63611[(8)]);
var inst_63597__$1 = (state_63611[(2)]);
var inst_63598 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_63597__$1);
var state_63611__$1 = (function (){var statearr_63620 = state_63611;
(statearr_63620[(8)] = inst_63597__$1);

return statearr_63620;
})();
if(cljs.core.truth_(inst_63598)){
var statearr_63621_63653 = state_63611__$1;
(statearr_63621_63653[(1)] = (13));

} else {
var statearr_63622_63654 = state_63611__$1;
(statearr_63622_63654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (2))){
var inst_63574 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_63575 = (0);
var state_63611__$1 = (function (){var statearr_63623 = state_63611;
(statearr_63623[(7)] = inst_63575);

(statearr_63623[(9)] = inst_63574);

return statearr_63623;
})();
var statearr_63624_63655 = state_63611__$1;
(statearr_63624_63655[(2)] = null);

(statearr_63624_63655[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (11))){
var inst_63575 = (state_63611[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_63611,(10),Object,null,(9));
var inst_63584 = chs__$1.call(null,inst_63575);
var inst_63585 = done.call(null,inst_63575);
var inst_63586 = cljs.core.async.take_BANG_.call(null,inst_63584,inst_63585);
var state_63611__$1 = state_63611;
var statearr_63625_63656 = state_63611__$1;
(statearr_63625_63656[(2)] = inst_63586);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63611__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (9))){
var inst_63575 = (state_63611[(7)]);
var inst_63588 = (state_63611[(2)]);
var inst_63589 = (inst_63575 + (1));
var inst_63575__$1 = inst_63589;
var state_63611__$1 = (function (){var statearr_63626 = state_63611;
(statearr_63626[(7)] = inst_63575__$1);

(statearr_63626[(10)] = inst_63588);

return statearr_63626;
})();
var statearr_63627_63657 = state_63611__$1;
(statearr_63627_63657[(2)] = null);

(statearr_63627_63657[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (5))){
var inst_63595 = (state_63611[(2)]);
var state_63611__$1 = (function (){var statearr_63628 = state_63611;
(statearr_63628[(11)] = inst_63595);

return statearr_63628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63611__$1,(12),dchan);
} else {
if((state_val_63612 === (14))){
var inst_63597 = (state_63611[(8)]);
var inst_63602 = cljs.core.apply.call(null,f,inst_63597);
var state_63611__$1 = state_63611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63611__$1,(16),out,inst_63602);
} else {
if((state_val_63612 === (16))){
var inst_63604 = (state_63611[(2)]);
var state_63611__$1 = (function (){var statearr_63629 = state_63611;
(statearr_63629[(12)] = inst_63604);

return statearr_63629;
})();
var statearr_63630_63658 = state_63611__$1;
(statearr_63630_63658[(2)] = null);

(statearr_63630_63658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (10))){
var inst_63579 = (state_63611[(2)]);
var inst_63580 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_63611__$1 = (function (){var statearr_63631 = state_63611;
(statearr_63631[(13)] = inst_63579);

return statearr_63631;
})();
var statearr_63632_63659 = state_63611__$1;
(statearr_63632_63659[(2)] = inst_63580);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63611__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63612 === (8))){
var inst_63593 = (state_63611[(2)]);
var state_63611__$1 = state_63611;
var statearr_63633_63660 = state_63611__$1;
(statearr_63633_63660[(2)] = inst_63593);

(statearr_63633_63660[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__41805__auto__,c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63637[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63637[(1)] = (1));

return statearr_63637;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63611){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63638){if((e63638 instanceof Object)){
var ex__41809__auto__ = e63638;
var statearr_63639_63661 = state_63611;
(statearr_63639_63661[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63638;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63662 = state_63611;
state_63611 = G__63662;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63611){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__41824__auto__ = (function (){var statearr_63640 = f__41823__auto__.call(null);
(statearr_63640[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63645);

return statearr_63640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63645,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args63664 = [];
var len__28496__auto___63722 = arguments.length;
var i__28497__auto___63723 = (0);
while(true){
if((i__28497__auto___63723 < len__28496__auto___63722)){
args63664.push((arguments[i__28497__auto___63723]));

var G__63724 = (i__28497__auto___63723 + (1));
i__28497__auto___63723 = G__63724;
continue;
} else {
}
break;
}

var G__63666 = args63664.length;
switch (G__63666) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63664.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63726 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63726,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63726,out){
return (function (state_63698){
var state_val_63699 = (state_63698[(1)]);
if((state_val_63699 === (7))){
var inst_63678 = (state_63698[(7)]);
var inst_63677 = (state_63698[(8)]);
var inst_63677__$1 = (state_63698[(2)]);
var inst_63678__$1 = cljs.core.nth.call(null,inst_63677__$1,(0),null);
var inst_63679 = cljs.core.nth.call(null,inst_63677__$1,(1),null);
var inst_63680 = (inst_63678__$1 == null);
var state_63698__$1 = (function (){var statearr_63700 = state_63698;
(statearr_63700[(7)] = inst_63678__$1);

(statearr_63700[(8)] = inst_63677__$1);

(statearr_63700[(9)] = inst_63679);

return statearr_63700;
})();
if(cljs.core.truth_(inst_63680)){
var statearr_63701_63727 = state_63698__$1;
(statearr_63701_63727[(1)] = (8));

} else {
var statearr_63702_63728 = state_63698__$1;
(statearr_63702_63728[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (1))){
var inst_63667 = cljs.core.vec.call(null,chs);
var inst_63668 = inst_63667;
var state_63698__$1 = (function (){var statearr_63703 = state_63698;
(statearr_63703[(10)] = inst_63668);

return statearr_63703;
})();
var statearr_63704_63729 = state_63698__$1;
(statearr_63704_63729[(2)] = null);

(statearr_63704_63729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (4))){
var inst_63668 = (state_63698[(10)]);
var state_63698__$1 = state_63698;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63698__$1,(7),inst_63668);
} else {
if((state_val_63699 === (6))){
var inst_63694 = (state_63698[(2)]);
var state_63698__$1 = state_63698;
var statearr_63705_63730 = state_63698__$1;
(statearr_63705_63730[(2)] = inst_63694);

(statearr_63705_63730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (3))){
var inst_63696 = (state_63698[(2)]);
var state_63698__$1 = state_63698;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63698__$1,inst_63696);
} else {
if((state_val_63699 === (2))){
var inst_63668 = (state_63698[(10)]);
var inst_63670 = cljs.core.count.call(null,inst_63668);
var inst_63671 = (inst_63670 > (0));
var state_63698__$1 = state_63698;
if(cljs.core.truth_(inst_63671)){
var statearr_63707_63731 = state_63698__$1;
(statearr_63707_63731[(1)] = (4));

} else {
var statearr_63708_63732 = state_63698__$1;
(statearr_63708_63732[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (11))){
var inst_63668 = (state_63698[(10)]);
var inst_63687 = (state_63698[(2)]);
var tmp63706 = inst_63668;
var inst_63668__$1 = tmp63706;
var state_63698__$1 = (function (){var statearr_63709 = state_63698;
(statearr_63709[(11)] = inst_63687);

(statearr_63709[(10)] = inst_63668__$1);

return statearr_63709;
})();
var statearr_63710_63733 = state_63698__$1;
(statearr_63710_63733[(2)] = null);

(statearr_63710_63733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (9))){
var inst_63678 = (state_63698[(7)]);
var state_63698__$1 = state_63698;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63698__$1,(11),out,inst_63678);
} else {
if((state_val_63699 === (5))){
var inst_63692 = cljs.core.async.close_BANG_.call(null,out);
var state_63698__$1 = state_63698;
var statearr_63711_63734 = state_63698__$1;
(statearr_63711_63734[(2)] = inst_63692);

(statearr_63711_63734[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (10))){
var inst_63690 = (state_63698[(2)]);
var state_63698__$1 = state_63698;
var statearr_63712_63735 = state_63698__$1;
(statearr_63712_63735[(2)] = inst_63690);

(statearr_63712_63735[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63699 === (8))){
var inst_63678 = (state_63698[(7)]);
var inst_63677 = (state_63698[(8)]);
var inst_63679 = (state_63698[(9)]);
var inst_63668 = (state_63698[(10)]);
var inst_63682 = (function (){var cs = inst_63668;
var vec__63673 = inst_63677;
var v = inst_63678;
var c = inst_63679;
return ((function (cs,vec__63673,v,c,inst_63678,inst_63677,inst_63679,inst_63668,state_val_63699,c__41822__auto___63726,out){
return (function (p1__63663_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__63663_SHARP_);
});
;})(cs,vec__63673,v,c,inst_63678,inst_63677,inst_63679,inst_63668,state_val_63699,c__41822__auto___63726,out))
})();
var inst_63683 = cljs.core.filterv.call(null,inst_63682,inst_63668);
var inst_63668__$1 = inst_63683;
var state_63698__$1 = (function (){var statearr_63713 = state_63698;
(statearr_63713[(10)] = inst_63668__$1);

return statearr_63713;
})();
var statearr_63714_63736 = state_63698__$1;
(statearr_63714_63736[(2)] = null);

(statearr_63714_63736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63726,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63726,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63718 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63718[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63718[(1)] = (1));

return statearr_63718;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63698){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63698);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63719){if((e63719 instanceof Object)){
var ex__41809__auto__ = e63719;
var statearr_63720_63737 = state_63698;
(statearr_63720_63737[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63698);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63738 = state_63698;
state_63698 = G__63738;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63698){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63726,out))
})();
var state__41824__auto__ = (function (){var statearr_63721 = f__41823__auto__.call(null);
(statearr_63721[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63726);

return statearr_63721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63726,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args63739 = [];
var len__28496__auto___63788 = arguments.length;
var i__28497__auto___63789 = (0);
while(true){
if((i__28497__auto___63789 < len__28496__auto___63788)){
args63739.push((arguments[i__28497__auto___63789]));

var G__63790 = (i__28497__auto___63789 + (1));
i__28497__auto___63789 = G__63790;
continue;
} else {
}
break;
}

var G__63741 = args63739.length;
switch (G__63741) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63739.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63792,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63792,out){
return (function (state_63765){
var state_val_63766 = (state_63765[(1)]);
if((state_val_63766 === (7))){
var inst_63747 = (state_63765[(7)]);
var inst_63747__$1 = (state_63765[(2)]);
var inst_63748 = (inst_63747__$1 == null);
var inst_63749 = cljs.core.not.call(null,inst_63748);
var state_63765__$1 = (function (){var statearr_63767 = state_63765;
(statearr_63767[(7)] = inst_63747__$1);

return statearr_63767;
})();
if(inst_63749){
var statearr_63768_63793 = state_63765__$1;
(statearr_63768_63793[(1)] = (8));

} else {
var statearr_63769_63794 = state_63765__$1;
(statearr_63769_63794[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (1))){
var inst_63742 = (0);
var state_63765__$1 = (function (){var statearr_63770 = state_63765;
(statearr_63770[(8)] = inst_63742);

return statearr_63770;
})();
var statearr_63771_63795 = state_63765__$1;
(statearr_63771_63795[(2)] = null);

(statearr_63771_63795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (4))){
var state_63765__$1 = state_63765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63765__$1,(7),ch);
} else {
if((state_val_63766 === (6))){
var inst_63760 = (state_63765[(2)]);
var state_63765__$1 = state_63765;
var statearr_63772_63796 = state_63765__$1;
(statearr_63772_63796[(2)] = inst_63760);

(statearr_63772_63796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (3))){
var inst_63762 = (state_63765[(2)]);
var inst_63763 = cljs.core.async.close_BANG_.call(null,out);
var state_63765__$1 = (function (){var statearr_63773 = state_63765;
(statearr_63773[(9)] = inst_63762);

return statearr_63773;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63765__$1,inst_63763);
} else {
if((state_val_63766 === (2))){
var inst_63742 = (state_63765[(8)]);
var inst_63744 = (inst_63742 < n);
var state_63765__$1 = state_63765;
if(cljs.core.truth_(inst_63744)){
var statearr_63774_63797 = state_63765__$1;
(statearr_63774_63797[(1)] = (4));

} else {
var statearr_63775_63798 = state_63765__$1;
(statearr_63775_63798[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (11))){
var inst_63742 = (state_63765[(8)]);
var inst_63752 = (state_63765[(2)]);
var inst_63753 = (inst_63742 + (1));
var inst_63742__$1 = inst_63753;
var state_63765__$1 = (function (){var statearr_63776 = state_63765;
(statearr_63776[(10)] = inst_63752);

(statearr_63776[(8)] = inst_63742__$1);

return statearr_63776;
})();
var statearr_63777_63799 = state_63765__$1;
(statearr_63777_63799[(2)] = null);

(statearr_63777_63799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (9))){
var state_63765__$1 = state_63765;
var statearr_63778_63800 = state_63765__$1;
(statearr_63778_63800[(2)] = null);

(statearr_63778_63800[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (5))){
var state_63765__$1 = state_63765;
var statearr_63779_63801 = state_63765__$1;
(statearr_63779_63801[(2)] = null);

(statearr_63779_63801[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (10))){
var inst_63757 = (state_63765[(2)]);
var state_63765__$1 = state_63765;
var statearr_63780_63802 = state_63765__$1;
(statearr_63780_63802[(2)] = inst_63757);

(statearr_63780_63802[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63766 === (8))){
var inst_63747 = (state_63765[(7)]);
var state_63765__$1 = state_63765;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63765__$1,(11),out,inst_63747);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63792,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63792,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63784 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63784[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63784[(1)] = (1));

return statearr_63784;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63765){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63785){if((e63785 instanceof Object)){
var ex__41809__auto__ = e63785;
var statearr_63786_63803 = state_63765;
(statearr_63786_63803[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63785;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63804 = state_63765;
state_63765 = G__63804;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63765){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63792,out))
})();
var state__41824__auto__ = (function (){var statearr_63787 = f__41823__auto__.call(null);
(statearr_63787[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63792);

return statearr_63787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63792,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async63812 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63812 = (function (f,ch,meta63813){
this.f = f;
this.ch = ch;
this.meta63813 = meta63813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63814,meta63813__$1){
var self__ = this;
var _63814__$1 = this;
return (new cljs.core.async.t_cljs$core$async63812(self__.f,self__.ch,meta63813__$1));
});


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63814){
var self__ = this;
var _63814__$1 = this;
return self__.meta63813;
});


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async63815 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63815 = (function (f,ch,meta63813,_,fn1,meta63816){
this.f = f;
this.ch = ch;
this.meta63813 = meta63813;
this._ = _;
this.fn1 = fn1;
this.meta63816 = meta63816;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_63817,meta63816__$1){
var self__ = this;
var _63817__$1 = this;
return (new cljs.core.async.t_cljs$core$async63815(self__.f,self__.ch,self__.meta63813,self__._,self__.fn1,meta63816__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_63817){
var self__ = this;
var _63817__$1 = this;
return self__.meta63816;
});})(___$1))
;


cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async63815.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__63805_SHARP_){
return f1.call(null,(((p1__63805_SHARP_ == null))?null:self__.f.call(null,p1__63805_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async63815.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63813","meta63813",-1131717467,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async63812","cljs.core.async/t_cljs$core$async63812",1835262978,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta63816","meta63816",-134683282,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async63815.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63815.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63815";

cljs.core.async.t_cljs$core$async63815.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63815");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async63815 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async63815(f__$1,ch__$1,meta63813__$1,___$2,fn1__$1,meta63816){
return (new cljs.core.async.t_cljs$core$async63815(f__$1,ch__$1,meta63813__$1,___$2,fn1__$1,meta63816));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async63815(self__.f,self__.ch,self__.meta63813,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27268__auto__ = ret;
if(cljs.core.truth_(and__27268__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27268__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63812.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async63812.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63813","meta63813",-1131717467,null)], null);
});

cljs.core.async.t_cljs$core$async63812.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63812.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63812";

cljs.core.async.t_cljs$core$async63812.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63812");
});

cljs.core.async.__GT_t_cljs$core$async63812 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async63812(f__$1,ch__$1,meta63813){
return (new cljs.core.async.t_cljs$core$async63812(f__$1,ch__$1,meta63813));
});

}

return (new cljs.core.async.t_cljs$core$async63812(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async63821 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63821 = (function (f,ch,meta63822){
this.f = f;
this.ch = ch;
this.meta63822 = meta63822;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63823,meta63822__$1){
var self__ = this;
var _63823__$1 = this;
return (new cljs.core.async.t_cljs$core$async63821(self__.f,self__.ch,meta63822__$1));
});


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63823){
var self__ = this;
var _63823__$1 = this;
return self__.meta63822;
});


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63821.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async63821.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63822","meta63822",-1181708852,null)], null);
});

cljs.core.async.t_cljs$core$async63821.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63821.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63821";

cljs.core.async.t_cljs$core$async63821.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63821");
});

cljs.core.async.__GT_t_cljs$core$async63821 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async63821(f__$1,ch__$1,meta63822){
return (new cljs.core.async.t_cljs$core$async63821(f__$1,ch__$1,meta63822));
});

}

return (new cljs.core.async.t_cljs$core$async63821(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async63827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63827 = (function (p,ch,meta63828){
this.p = p;
this.ch = ch;
this.meta63828 = meta63828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63829,meta63828__$1){
var self__ = this;
var _63829__$1 = this;
return (new cljs.core.async.t_cljs$core$async63827(self__.p,self__.ch,meta63828__$1));
});


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63829){
var self__ = this;
var _63829__$1 = this;
return self__.meta63828;
});


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63827.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async63827.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63828","meta63828",566767693,null)], null);
});

cljs.core.async.t_cljs$core$async63827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63827";

cljs.core.async.t_cljs$core$async63827.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63827");
});

cljs.core.async.__GT_t_cljs$core$async63827 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async63827(p__$1,ch__$1,meta63828){
return (new cljs.core.async.t_cljs$core$async63827(p__$1,ch__$1,meta63828));
});

}

return (new cljs.core.async.t_cljs$core$async63827(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args63830 = [];
var len__28496__auto___63874 = arguments.length;
var i__28497__auto___63875 = (0);
while(true){
if((i__28497__auto___63875 < len__28496__auto___63874)){
args63830.push((arguments[i__28497__auto___63875]));

var G__63876 = (i__28497__auto___63875 + (1));
i__28497__auto___63875 = G__63876;
continue;
} else {
}
break;
}

var G__63832 = args63830.length;
switch (G__63832) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63830.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63878 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63878,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63878,out){
return (function (state_63853){
var state_val_63854 = (state_63853[(1)]);
if((state_val_63854 === (7))){
var inst_63849 = (state_63853[(2)]);
var state_63853__$1 = state_63853;
var statearr_63855_63879 = state_63853__$1;
(statearr_63855_63879[(2)] = inst_63849);

(statearr_63855_63879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (1))){
var state_63853__$1 = state_63853;
var statearr_63856_63880 = state_63853__$1;
(statearr_63856_63880[(2)] = null);

(statearr_63856_63880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (4))){
var inst_63835 = (state_63853[(7)]);
var inst_63835__$1 = (state_63853[(2)]);
var inst_63836 = (inst_63835__$1 == null);
var state_63853__$1 = (function (){var statearr_63857 = state_63853;
(statearr_63857[(7)] = inst_63835__$1);

return statearr_63857;
})();
if(cljs.core.truth_(inst_63836)){
var statearr_63858_63881 = state_63853__$1;
(statearr_63858_63881[(1)] = (5));

} else {
var statearr_63859_63882 = state_63853__$1;
(statearr_63859_63882[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (6))){
var inst_63835 = (state_63853[(7)]);
var inst_63840 = p.call(null,inst_63835);
var state_63853__$1 = state_63853;
if(cljs.core.truth_(inst_63840)){
var statearr_63860_63883 = state_63853__$1;
(statearr_63860_63883[(1)] = (8));

} else {
var statearr_63861_63884 = state_63853__$1;
(statearr_63861_63884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (3))){
var inst_63851 = (state_63853[(2)]);
var state_63853__$1 = state_63853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63853__$1,inst_63851);
} else {
if((state_val_63854 === (2))){
var state_63853__$1 = state_63853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63853__$1,(4),ch);
} else {
if((state_val_63854 === (11))){
var inst_63843 = (state_63853[(2)]);
var state_63853__$1 = state_63853;
var statearr_63862_63885 = state_63853__$1;
(statearr_63862_63885[(2)] = inst_63843);

(statearr_63862_63885[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (9))){
var state_63853__$1 = state_63853;
var statearr_63863_63886 = state_63853__$1;
(statearr_63863_63886[(2)] = null);

(statearr_63863_63886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (5))){
var inst_63838 = cljs.core.async.close_BANG_.call(null,out);
var state_63853__$1 = state_63853;
var statearr_63864_63887 = state_63853__$1;
(statearr_63864_63887[(2)] = inst_63838);

(statearr_63864_63887[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (10))){
var inst_63846 = (state_63853[(2)]);
var state_63853__$1 = (function (){var statearr_63865 = state_63853;
(statearr_63865[(8)] = inst_63846);

return statearr_63865;
})();
var statearr_63866_63888 = state_63853__$1;
(statearr_63866_63888[(2)] = null);

(statearr_63866_63888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63854 === (8))){
var inst_63835 = (state_63853[(7)]);
var state_63853__$1 = state_63853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63853__$1,(11),out,inst_63835);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63878,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63878,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63870 = [null,null,null,null,null,null,null,null,null];
(statearr_63870[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63870[(1)] = (1));

return statearr_63870;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63853){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63871){if((e63871 instanceof Object)){
var ex__41809__auto__ = e63871;
var statearr_63872_63889 = state_63853;
(statearr_63872_63889[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63871;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63890 = state_63853;
state_63853 = G__63890;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63878,out))
})();
var state__41824__auto__ = (function (){var statearr_63873 = f__41823__auto__.call(null);
(statearr_63873[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63878);

return statearr_63873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63878,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args63891 = [];
var len__28496__auto___63894 = arguments.length;
var i__28497__auto___63895 = (0);
while(true){
if((i__28497__auto___63895 < len__28496__auto___63894)){
args63891.push((arguments[i__28497__auto___63895]));

var G__63896 = (i__28497__auto___63895 + (1));
i__28497__auto___63895 = G__63896;
continue;
} else {
}
break;
}

var G__63893 = args63891.length;
switch (G__63893) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63891.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_64063){
var state_val_64064 = (state_64063[(1)]);
if((state_val_64064 === (7))){
var inst_64059 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
var statearr_64065_64106 = state_64063__$1;
(statearr_64065_64106[(2)] = inst_64059);

(statearr_64065_64106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (20))){
var inst_64029 = (state_64063[(7)]);
var inst_64040 = (state_64063[(2)]);
var inst_64041 = cljs.core.next.call(null,inst_64029);
var inst_64015 = inst_64041;
var inst_64016 = null;
var inst_64017 = (0);
var inst_64018 = (0);
var state_64063__$1 = (function (){var statearr_64066 = state_64063;
(statearr_64066[(8)] = inst_64040);

(statearr_64066[(9)] = inst_64018);

(statearr_64066[(10)] = inst_64017);

(statearr_64066[(11)] = inst_64015);

(statearr_64066[(12)] = inst_64016);

return statearr_64066;
})();
var statearr_64067_64107 = state_64063__$1;
(statearr_64067_64107[(2)] = null);

(statearr_64067_64107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (1))){
var state_64063__$1 = state_64063;
var statearr_64068_64108 = state_64063__$1;
(statearr_64068_64108[(2)] = null);

(statearr_64068_64108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (4))){
var inst_64004 = (state_64063[(13)]);
var inst_64004__$1 = (state_64063[(2)]);
var inst_64005 = (inst_64004__$1 == null);
var state_64063__$1 = (function (){var statearr_64069 = state_64063;
(statearr_64069[(13)] = inst_64004__$1);

return statearr_64069;
})();
if(cljs.core.truth_(inst_64005)){
var statearr_64070_64109 = state_64063__$1;
(statearr_64070_64109[(1)] = (5));

} else {
var statearr_64071_64110 = state_64063__$1;
(statearr_64071_64110[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (15))){
var state_64063__$1 = state_64063;
var statearr_64075_64111 = state_64063__$1;
(statearr_64075_64111[(2)] = null);

(statearr_64075_64111[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (21))){
var state_64063__$1 = state_64063;
var statearr_64076_64112 = state_64063__$1;
(statearr_64076_64112[(2)] = null);

(statearr_64076_64112[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (13))){
var inst_64018 = (state_64063[(9)]);
var inst_64017 = (state_64063[(10)]);
var inst_64015 = (state_64063[(11)]);
var inst_64016 = (state_64063[(12)]);
var inst_64025 = (state_64063[(2)]);
var inst_64026 = (inst_64018 + (1));
var tmp64072 = inst_64017;
var tmp64073 = inst_64015;
var tmp64074 = inst_64016;
var inst_64015__$1 = tmp64073;
var inst_64016__$1 = tmp64074;
var inst_64017__$1 = tmp64072;
var inst_64018__$1 = inst_64026;
var state_64063__$1 = (function (){var statearr_64077 = state_64063;
(statearr_64077[(9)] = inst_64018__$1);

(statearr_64077[(10)] = inst_64017__$1);

(statearr_64077[(11)] = inst_64015__$1);

(statearr_64077[(12)] = inst_64016__$1);

(statearr_64077[(14)] = inst_64025);

return statearr_64077;
})();
var statearr_64078_64113 = state_64063__$1;
(statearr_64078_64113[(2)] = null);

(statearr_64078_64113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (22))){
var state_64063__$1 = state_64063;
var statearr_64079_64114 = state_64063__$1;
(statearr_64079_64114[(2)] = null);

(statearr_64079_64114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (6))){
var inst_64004 = (state_64063[(13)]);
var inst_64013 = f.call(null,inst_64004);
var inst_64014 = cljs.core.seq.call(null,inst_64013);
var inst_64015 = inst_64014;
var inst_64016 = null;
var inst_64017 = (0);
var inst_64018 = (0);
var state_64063__$1 = (function (){var statearr_64080 = state_64063;
(statearr_64080[(9)] = inst_64018);

(statearr_64080[(10)] = inst_64017);

(statearr_64080[(11)] = inst_64015);

(statearr_64080[(12)] = inst_64016);

return statearr_64080;
})();
var statearr_64081_64115 = state_64063__$1;
(statearr_64081_64115[(2)] = null);

(statearr_64081_64115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (17))){
var inst_64029 = (state_64063[(7)]);
var inst_64033 = cljs.core.chunk_first.call(null,inst_64029);
var inst_64034 = cljs.core.chunk_rest.call(null,inst_64029);
var inst_64035 = cljs.core.count.call(null,inst_64033);
var inst_64015 = inst_64034;
var inst_64016 = inst_64033;
var inst_64017 = inst_64035;
var inst_64018 = (0);
var state_64063__$1 = (function (){var statearr_64082 = state_64063;
(statearr_64082[(9)] = inst_64018);

(statearr_64082[(10)] = inst_64017);

(statearr_64082[(11)] = inst_64015);

(statearr_64082[(12)] = inst_64016);

return statearr_64082;
})();
var statearr_64083_64116 = state_64063__$1;
(statearr_64083_64116[(2)] = null);

(statearr_64083_64116[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (3))){
var inst_64061 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64063__$1,inst_64061);
} else {
if((state_val_64064 === (12))){
var inst_64049 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
var statearr_64084_64117 = state_64063__$1;
(statearr_64084_64117[(2)] = inst_64049);

(statearr_64084_64117[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (2))){
var state_64063__$1 = state_64063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64063__$1,(4),in$);
} else {
if((state_val_64064 === (23))){
var inst_64057 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
var statearr_64085_64118 = state_64063__$1;
(statearr_64085_64118[(2)] = inst_64057);

(statearr_64085_64118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (19))){
var inst_64044 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
var statearr_64086_64119 = state_64063__$1;
(statearr_64086_64119[(2)] = inst_64044);

(statearr_64086_64119[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (11))){
var inst_64015 = (state_64063[(11)]);
var inst_64029 = (state_64063[(7)]);
var inst_64029__$1 = cljs.core.seq.call(null,inst_64015);
var state_64063__$1 = (function (){var statearr_64087 = state_64063;
(statearr_64087[(7)] = inst_64029__$1);

return statearr_64087;
})();
if(inst_64029__$1){
var statearr_64088_64120 = state_64063__$1;
(statearr_64088_64120[(1)] = (14));

} else {
var statearr_64089_64121 = state_64063__$1;
(statearr_64089_64121[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (9))){
var inst_64051 = (state_64063[(2)]);
var inst_64052 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_64063__$1 = (function (){var statearr_64090 = state_64063;
(statearr_64090[(15)] = inst_64051);

return statearr_64090;
})();
if(cljs.core.truth_(inst_64052)){
var statearr_64091_64122 = state_64063__$1;
(statearr_64091_64122[(1)] = (21));

} else {
var statearr_64092_64123 = state_64063__$1;
(statearr_64092_64123[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (5))){
var inst_64007 = cljs.core.async.close_BANG_.call(null,out);
var state_64063__$1 = state_64063;
var statearr_64093_64124 = state_64063__$1;
(statearr_64093_64124[(2)] = inst_64007);

(statearr_64093_64124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (14))){
var inst_64029 = (state_64063[(7)]);
var inst_64031 = cljs.core.chunked_seq_QMARK_.call(null,inst_64029);
var state_64063__$1 = state_64063;
if(inst_64031){
var statearr_64094_64125 = state_64063__$1;
(statearr_64094_64125[(1)] = (17));

} else {
var statearr_64095_64126 = state_64063__$1;
(statearr_64095_64126[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (16))){
var inst_64047 = (state_64063[(2)]);
var state_64063__$1 = state_64063;
var statearr_64096_64127 = state_64063__$1;
(statearr_64096_64127[(2)] = inst_64047);

(statearr_64096_64127[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64064 === (10))){
var inst_64018 = (state_64063[(9)]);
var inst_64016 = (state_64063[(12)]);
var inst_64023 = cljs.core._nth.call(null,inst_64016,inst_64018);
var state_64063__$1 = state_64063;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64063__$1,(13),out,inst_64023);
} else {
if((state_val_64064 === (18))){
var inst_64029 = (state_64063[(7)]);
var inst_64038 = cljs.core.first.call(null,inst_64029);
var state_64063__$1 = state_64063;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64063__$1,(20),out,inst_64038);
} else {
if((state_val_64064 === (8))){
var inst_64018 = (state_64063[(9)]);
var inst_64017 = (state_64063[(10)]);
var inst_64020 = (inst_64018 < inst_64017);
var inst_64021 = inst_64020;
var state_64063__$1 = state_64063;
if(cljs.core.truth_(inst_64021)){
var statearr_64097_64128 = state_64063__$1;
(statearr_64097_64128[(1)] = (10));

} else {
var statearr_64098_64129 = state_64063__$1;
(statearr_64098_64129[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_64102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64102[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__);

(statearr_64102[(1)] = (1));

return statearr_64102;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1 = (function (state_64063){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64103){if((e64103 instanceof Object)){
var ex__41809__auto__ = e64103;
var statearr_64104_64130 = state_64063;
(statearr_64104_64130[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64063);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64103;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64131 = state_64063;
state_64063 = G__64131;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__ = function(state_64063){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1.call(this,state_64063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_64105 = f__41823__auto__.call(null);
(statearr_64105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_64105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args64132 = [];
var len__28496__auto___64135 = arguments.length;
var i__28497__auto___64136 = (0);
while(true){
if((i__28497__auto___64136 < len__28496__auto___64135)){
args64132.push((arguments[i__28497__auto___64136]));

var G__64137 = (i__28497__auto___64136 + (1));
i__28497__auto___64136 = G__64137;
continue;
} else {
}
break;
}

var G__64134 = args64132.length;
switch (G__64134) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64132.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args64139 = [];
var len__28496__auto___64142 = arguments.length;
var i__28497__auto___64143 = (0);
while(true){
if((i__28497__auto___64143 < len__28496__auto___64142)){
args64139.push((arguments[i__28497__auto___64143]));

var G__64144 = (i__28497__auto___64143 + (1));
i__28497__auto___64143 = G__64144;
continue;
} else {
}
break;
}

var G__64141 = args64139.length;
switch (G__64141) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64139.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args64146 = [];
var len__28496__auto___64197 = arguments.length;
var i__28497__auto___64198 = (0);
while(true){
if((i__28497__auto___64198 < len__28496__auto___64197)){
args64146.push((arguments[i__28497__auto___64198]));

var G__64199 = (i__28497__auto___64198 + (1));
i__28497__auto___64198 = G__64199;
continue;
} else {
}
break;
}

var G__64148 = args64146.length;
switch (G__64148) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64146.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64201 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64201,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64201,out){
return (function (state_64172){
var state_val_64173 = (state_64172[(1)]);
if((state_val_64173 === (7))){
var inst_64167 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
var statearr_64174_64202 = state_64172__$1;
(statearr_64174_64202[(2)] = inst_64167);

(statearr_64174_64202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (1))){
var inst_64149 = null;
var state_64172__$1 = (function (){var statearr_64175 = state_64172;
(statearr_64175[(7)] = inst_64149);

return statearr_64175;
})();
var statearr_64176_64203 = state_64172__$1;
(statearr_64176_64203[(2)] = null);

(statearr_64176_64203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (4))){
var inst_64152 = (state_64172[(8)]);
var inst_64152__$1 = (state_64172[(2)]);
var inst_64153 = (inst_64152__$1 == null);
var inst_64154 = cljs.core.not.call(null,inst_64153);
var state_64172__$1 = (function (){var statearr_64177 = state_64172;
(statearr_64177[(8)] = inst_64152__$1);

return statearr_64177;
})();
if(inst_64154){
var statearr_64178_64204 = state_64172__$1;
(statearr_64178_64204[(1)] = (5));

} else {
var statearr_64179_64205 = state_64172__$1;
(statearr_64179_64205[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (6))){
var state_64172__$1 = state_64172;
var statearr_64180_64206 = state_64172__$1;
(statearr_64180_64206[(2)] = null);

(statearr_64180_64206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (3))){
var inst_64169 = (state_64172[(2)]);
var inst_64170 = cljs.core.async.close_BANG_.call(null,out);
var state_64172__$1 = (function (){var statearr_64181 = state_64172;
(statearr_64181[(9)] = inst_64169);

return statearr_64181;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64172__$1,inst_64170);
} else {
if((state_val_64173 === (2))){
var state_64172__$1 = state_64172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64172__$1,(4),ch);
} else {
if((state_val_64173 === (11))){
var inst_64152 = (state_64172[(8)]);
var inst_64161 = (state_64172[(2)]);
var inst_64149 = inst_64152;
var state_64172__$1 = (function (){var statearr_64182 = state_64172;
(statearr_64182[(10)] = inst_64161);

(statearr_64182[(7)] = inst_64149);

return statearr_64182;
})();
var statearr_64183_64207 = state_64172__$1;
(statearr_64183_64207[(2)] = null);

(statearr_64183_64207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (9))){
var inst_64152 = (state_64172[(8)]);
var state_64172__$1 = state_64172;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64172__$1,(11),out,inst_64152);
} else {
if((state_val_64173 === (5))){
var inst_64152 = (state_64172[(8)]);
var inst_64149 = (state_64172[(7)]);
var inst_64156 = cljs.core._EQ_.call(null,inst_64152,inst_64149);
var state_64172__$1 = state_64172;
if(inst_64156){
var statearr_64185_64208 = state_64172__$1;
(statearr_64185_64208[(1)] = (8));

} else {
var statearr_64186_64209 = state_64172__$1;
(statearr_64186_64209[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (10))){
var inst_64164 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
var statearr_64187_64210 = state_64172__$1;
(statearr_64187_64210[(2)] = inst_64164);

(statearr_64187_64210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (8))){
var inst_64149 = (state_64172[(7)]);
var tmp64184 = inst_64149;
var inst_64149__$1 = tmp64184;
var state_64172__$1 = (function (){var statearr_64188 = state_64172;
(statearr_64188[(7)] = inst_64149__$1);

return statearr_64188;
})();
var statearr_64189_64211 = state_64172__$1;
(statearr_64189_64211[(2)] = null);

(statearr_64189_64211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64201,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64201,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64193 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64193[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64193[(1)] = (1));

return statearr_64193;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64172){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64194){if((e64194 instanceof Object)){
var ex__41809__auto__ = e64194;
var statearr_64195_64212 = state_64172;
(statearr_64195_64212[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64172);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64213 = state_64172;
state_64172 = G__64213;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64172){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64201,out))
})();
var state__41824__auto__ = (function (){var statearr_64196 = f__41823__auto__.call(null);
(statearr_64196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64201);

return statearr_64196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64201,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args64214 = [];
var len__28496__auto___64284 = arguments.length;
var i__28497__auto___64285 = (0);
while(true){
if((i__28497__auto___64285 < len__28496__auto___64284)){
args64214.push((arguments[i__28497__auto___64285]));

var G__64286 = (i__28497__auto___64285 + (1));
i__28497__auto___64285 = G__64286;
continue;
} else {
}
break;
}

var G__64216 = args64214.length;
switch (G__64216) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64214.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64288 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64288,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64288,out){
return (function (state_64254){
var state_val_64255 = (state_64254[(1)]);
if((state_val_64255 === (7))){
var inst_64250 = (state_64254[(2)]);
var state_64254__$1 = state_64254;
var statearr_64256_64289 = state_64254__$1;
(statearr_64256_64289[(2)] = inst_64250);

(statearr_64256_64289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (1))){
var inst_64217 = (new Array(n));
var inst_64218 = inst_64217;
var inst_64219 = (0);
var state_64254__$1 = (function (){var statearr_64257 = state_64254;
(statearr_64257[(7)] = inst_64218);

(statearr_64257[(8)] = inst_64219);

return statearr_64257;
})();
var statearr_64258_64290 = state_64254__$1;
(statearr_64258_64290[(2)] = null);

(statearr_64258_64290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (4))){
var inst_64222 = (state_64254[(9)]);
var inst_64222__$1 = (state_64254[(2)]);
var inst_64223 = (inst_64222__$1 == null);
var inst_64224 = cljs.core.not.call(null,inst_64223);
var state_64254__$1 = (function (){var statearr_64259 = state_64254;
(statearr_64259[(9)] = inst_64222__$1);

return statearr_64259;
})();
if(inst_64224){
var statearr_64260_64291 = state_64254__$1;
(statearr_64260_64291[(1)] = (5));

} else {
var statearr_64261_64292 = state_64254__$1;
(statearr_64261_64292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (15))){
var inst_64244 = (state_64254[(2)]);
var state_64254__$1 = state_64254;
var statearr_64262_64293 = state_64254__$1;
(statearr_64262_64293[(2)] = inst_64244);

(statearr_64262_64293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (13))){
var state_64254__$1 = state_64254;
var statearr_64263_64294 = state_64254__$1;
(statearr_64263_64294[(2)] = null);

(statearr_64263_64294[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (6))){
var inst_64219 = (state_64254[(8)]);
var inst_64240 = (inst_64219 > (0));
var state_64254__$1 = state_64254;
if(cljs.core.truth_(inst_64240)){
var statearr_64264_64295 = state_64254__$1;
(statearr_64264_64295[(1)] = (12));

} else {
var statearr_64265_64296 = state_64254__$1;
(statearr_64265_64296[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (3))){
var inst_64252 = (state_64254[(2)]);
var state_64254__$1 = state_64254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64254__$1,inst_64252);
} else {
if((state_val_64255 === (12))){
var inst_64218 = (state_64254[(7)]);
var inst_64242 = cljs.core.vec.call(null,inst_64218);
var state_64254__$1 = state_64254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64254__$1,(15),out,inst_64242);
} else {
if((state_val_64255 === (2))){
var state_64254__$1 = state_64254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64254__$1,(4),ch);
} else {
if((state_val_64255 === (11))){
var inst_64234 = (state_64254[(2)]);
var inst_64235 = (new Array(n));
var inst_64218 = inst_64235;
var inst_64219 = (0);
var state_64254__$1 = (function (){var statearr_64266 = state_64254;
(statearr_64266[(7)] = inst_64218);

(statearr_64266[(10)] = inst_64234);

(statearr_64266[(8)] = inst_64219);

return statearr_64266;
})();
var statearr_64267_64297 = state_64254__$1;
(statearr_64267_64297[(2)] = null);

(statearr_64267_64297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (9))){
var inst_64218 = (state_64254[(7)]);
var inst_64232 = cljs.core.vec.call(null,inst_64218);
var state_64254__$1 = state_64254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64254__$1,(11),out,inst_64232);
} else {
if((state_val_64255 === (5))){
var inst_64227 = (state_64254[(11)]);
var inst_64218 = (state_64254[(7)]);
var inst_64219 = (state_64254[(8)]);
var inst_64222 = (state_64254[(9)]);
var inst_64226 = (inst_64218[inst_64219] = inst_64222);
var inst_64227__$1 = (inst_64219 + (1));
var inst_64228 = (inst_64227__$1 < n);
var state_64254__$1 = (function (){var statearr_64268 = state_64254;
(statearr_64268[(11)] = inst_64227__$1);

(statearr_64268[(12)] = inst_64226);

return statearr_64268;
})();
if(cljs.core.truth_(inst_64228)){
var statearr_64269_64298 = state_64254__$1;
(statearr_64269_64298[(1)] = (8));

} else {
var statearr_64270_64299 = state_64254__$1;
(statearr_64270_64299[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (14))){
var inst_64247 = (state_64254[(2)]);
var inst_64248 = cljs.core.async.close_BANG_.call(null,out);
var state_64254__$1 = (function (){var statearr_64272 = state_64254;
(statearr_64272[(13)] = inst_64247);

return statearr_64272;
})();
var statearr_64273_64300 = state_64254__$1;
(statearr_64273_64300[(2)] = inst_64248);

(statearr_64273_64300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (10))){
var inst_64238 = (state_64254[(2)]);
var state_64254__$1 = state_64254;
var statearr_64274_64301 = state_64254__$1;
(statearr_64274_64301[(2)] = inst_64238);

(statearr_64274_64301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64255 === (8))){
var inst_64227 = (state_64254[(11)]);
var inst_64218 = (state_64254[(7)]);
var tmp64271 = inst_64218;
var inst_64218__$1 = tmp64271;
var inst_64219 = inst_64227;
var state_64254__$1 = (function (){var statearr_64275 = state_64254;
(statearr_64275[(7)] = inst_64218__$1);

(statearr_64275[(8)] = inst_64219);

return statearr_64275;
})();
var statearr_64276_64302 = state_64254__$1;
(statearr_64276_64302[(2)] = null);

(statearr_64276_64302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64288,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64288,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64280 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64280[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64280[(1)] = (1));

return statearr_64280;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64254){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64281){if((e64281 instanceof Object)){
var ex__41809__auto__ = e64281;
var statearr_64282_64303 = state_64254;
(statearr_64282_64303[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64281;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64304 = state_64254;
state_64254 = G__64304;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64288,out))
})();
var state__41824__auto__ = (function (){var statearr_64283 = f__41823__auto__.call(null);
(statearr_64283[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64288);

return statearr_64283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64288,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args64305 = [];
var len__28496__auto___64379 = arguments.length;
var i__28497__auto___64380 = (0);
while(true){
if((i__28497__auto___64380 < len__28496__auto___64379)){
args64305.push((arguments[i__28497__auto___64380]));

var G__64381 = (i__28497__auto___64380 + (1));
i__28497__auto___64380 = G__64381;
continue;
} else {
}
break;
}

var G__64307 = args64305.length;
switch (G__64307) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64305.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64383 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64383,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64383,out){
return (function (state_64349){
var state_val_64350 = (state_64349[(1)]);
if((state_val_64350 === (7))){
var inst_64345 = (state_64349[(2)]);
var state_64349__$1 = state_64349;
var statearr_64351_64384 = state_64349__$1;
(statearr_64351_64384[(2)] = inst_64345);

(statearr_64351_64384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (1))){
var inst_64308 = [];
var inst_64309 = inst_64308;
var inst_64310 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_64349__$1 = (function (){var statearr_64352 = state_64349;
(statearr_64352[(7)] = inst_64309);

(statearr_64352[(8)] = inst_64310);

return statearr_64352;
})();
var statearr_64353_64385 = state_64349__$1;
(statearr_64353_64385[(2)] = null);

(statearr_64353_64385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (4))){
var inst_64313 = (state_64349[(9)]);
var inst_64313__$1 = (state_64349[(2)]);
var inst_64314 = (inst_64313__$1 == null);
var inst_64315 = cljs.core.not.call(null,inst_64314);
var state_64349__$1 = (function (){var statearr_64354 = state_64349;
(statearr_64354[(9)] = inst_64313__$1);

return statearr_64354;
})();
if(inst_64315){
var statearr_64355_64386 = state_64349__$1;
(statearr_64355_64386[(1)] = (5));

} else {
var statearr_64356_64387 = state_64349__$1;
(statearr_64356_64387[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (15))){
var inst_64339 = (state_64349[(2)]);
var state_64349__$1 = state_64349;
var statearr_64357_64388 = state_64349__$1;
(statearr_64357_64388[(2)] = inst_64339);

(statearr_64357_64388[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (13))){
var state_64349__$1 = state_64349;
var statearr_64358_64389 = state_64349__$1;
(statearr_64358_64389[(2)] = null);

(statearr_64358_64389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (6))){
var inst_64309 = (state_64349[(7)]);
var inst_64334 = inst_64309.length;
var inst_64335 = (inst_64334 > (0));
var state_64349__$1 = state_64349;
if(cljs.core.truth_(inst_64335)){
var statearr_64359_64390 = state_64349__$1;
(statearr_64359_64390[(1)] = (12));

} else {
var statearr_64360_64391 = state_64349__$1;
(statearr_64360_64391[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (3))){
var inst_64347 = (state_64349[(2)]);
var state_64349__$1 = state_64349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64349__$1,inst_64347);
} else {
if((state_val_64350 === (12))){
var inst_64309 = (state_64349[(7)]);
var inst_64337 = cljs.core.vec.call(null,inst_64309);
var state_64349__$1 = state_64349;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64349__$1,(15),out,inst_64337);
} else {
if((state_val_64350 === (2))){
var state_64349__$1 = state_64349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64349__$1,(4),ch);
} else {
if((state_val_64350 === (11))){
var inst_64313 = (state_64349[(9)]);
var inst_64317 = (state_64349[(10)]);
var inst_64327 = (state_64349[(2)]);
var inst_64328 = [];
var inst_64329 = inst_64328.push(inst_64313);
var inst_64309 = inst_64328;
var inst_64310 = inst_64317;
var state_64349__$1 = (function (){var statearr_64361 = state_64349;
(statearr_64361[(11)] = inst_64327);

(statearr_64361[(12)] = inst_64329);

(statearr_64361[(7)] = inst_64309);

(statearr_64361[(8)] = inst_64310);

return statearr_64361;
})();
var statearr_64362_64392 = state_64349__$1;
(statearr_64362_64392[(2)] = null);

(statearr_64362_64392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (9))){
var inst_64309 = (state_64349[(7)]);
var inst_64325 = cljs.core.vec.call(null,inst_64309);
var state_64349__$1 = state_64349;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64349__$1,(11),out,inst_64325);
} else {
if((state_val_64350 === (5))){
var inst_64313 = (state_64349[(9)]);
var inst_64317 = (state_64349[(10)]);
var inst_64310 = (state_64349[(8)]);
var inst_64317__$1 = f.call(null,inst_64313);
var inst_64318 = cljs.core._EQ_.call(null,inst_64317__$1,inst_64310);
var inst_64319 = cljs.core.keyword_identical_QMARK_.call(null,inst_64310,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_64320 = (inst_64318) || (inst_64319);
var state_64349__$1 = (function (){var statearr_64363 = state_64349;
(statearr_64363[(10)] = inst_64317__$1);

return statearr_64363;
})();
if(cljs.core.truth_(inst_64320)){
var statearr_64364_64393 = state_64349__$1;
(statearr_64364_64393[(1)] = (8));

} else {
var statearr_64365_64394 = state_64349__$1;
(statearr_64365_64394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (14))){
var inst_64342 = (state_64349[(2)]);
var inst_64343 = cljs.core.async.close_BANG_.call(null,out);
var state_64349__$1 = (function (){var statearr_64367 = state_64349;
(statearr_64367[(13)] = inst_64342);

return statearr_64367;
})();
var statearr_64368_64395 = state_64349__$1;
(statearr_64368_64395[(2)] = inst_64343);

(statearr_64368_64395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (10))){
var inst_64332 = (state_64349[(2)]);
var state_64349__$1 = state_64349;
var statearr_64369_64396 = state_64349__$1;
(statearr_64369_64396[(2)] = inst_64332);

(statearr_64369_64396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64350 === (8))){
var inst_64313 = (state_64349[(9)]);
var inst_64317 = (state_64349[(10)]);
var inst_64309 = (state_64349[(7)]);
var inst_64322 = inst_64309.push(inst_64313);
var tmp64366 = inst_64309;
var inst_64309__$1 = tmp64366;
var inst_64310 = inst_64317;
var state_64349__$1 = (function (){var statearr_64370 = state_64349;
(statearr_64370[(14)] = inst_64322);

(statearr_64370[(7)] = inst_64309__$1);

(statearr_64370[(8)] = inst_64310);

return statearr_64370;
})();
var statearr_64371_64397 = state_64349__$1;
(statearr_64371_64397[(2)] = null);

(statearr_64371_64397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64383,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64383,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64375[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64375[(1)] = (1));

return statearr_64375;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64349){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64376){if((e64376 instanceof Object)){
var ex__41809__auto__ = e64376;
var statearr_64377_64398 = state_64349;
(statearr_64377_64398[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64349);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64399 = state_64349;
state_64349 = G__64399;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64349){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64383,out))
})();
var state__41824__auto__ = (function (){var statearr_64378 = f__41823__auto__.call(null);
(statearr_64378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64383);

return statearr_64378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64383,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1481754439169