// Compiled by ClojureScript 1.9.293 {}
goog.provide('devtools.core');
goog.require('cljs.core');
goog.require('devtools.prefs');
goog.require('devtools.sanity_hints');
goog.require('devtools.dirac');
goog.require('devtools.custom_formatters');
goog.require('devtools.util');
goog.require('goog.userAgent');
devtools.core.known_features = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779),new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327),new cljs.core.Keyword(null,"dirac","dirac",1785994033),new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649),new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858),new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)], null);
devtools.core.missing_feature_warning = (function devtools$core$missing_feature_warning(feature,known_features){
return [cljs.core.str("No such feature '"),cljs.core.str(feature),cljs.core.str("' is currently available in cljs-devtools. "),cljs.core.str("List of supported features:"),cljs.core.str(cljs.core.keys.call(null,known_features))].join('');
});
devtools.core.warn_feature_not_available = (function devtools$core$warn_feature_not_available(feature){
return console.warn([cljs.core.str("Feature '"),cljs.core.str(cljs.core.name.call(null,feature)),cljs.core.str("' cannot be installed. Unsupported browser "),cljs.core.str(goog.userAgent.getUserAgentString()),cljs.core.str(".")].join(''));
});
devtools.core.install_BANG_ = (function devtools$core$install_BANG_(){
devtools.util.display_banner.call(null,"Installing cljs-devtools:",devtools.core.known_features);

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327)))){
if(cljs.core.truth_(devtools.custom_formatters.available_QMARK_.call(null))){
devtools.custom_formatters.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)))){
if(cljs.core.truth_(devtools.sanity_hints.available_QMARK_.call(null))){
devtools.sanity_hints.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649)))){
if(cljs.core.truth_(devtools.dirac.available_QMARK_.call(null))){
return devtools.dirac.install_BANG_.call(null);
} else {
return devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"dirac","dirac",1785994033));
}
} else {
return null;
}
});
devtools.core.uninstall_BANG_ = (function devtools$core$uninstall_BANG_(){
devtools.custom_formatters.uninstall_BANG_.call(null);

devtools.sanity_hints.uninstall_BANG_.call(null);

return devtools.dirac.uninstall_BANG_.call(null);
});
devtools.core.set_prefs_BANG_ = (function devtools$core$set_prefs_BANG_(new_prefs){
return devtools.prefs.set_prefs_BANG_.call(null,new_prefs);
});
devtools.core.get_prefs = (function devtools$core$get_prefs(){
return devtools.prefs.get_prefs.call(null);
});
devtools.core.set_pref_BANG_ = (function devtools$core$set_pref_BANG_(pref,val){
return devtools.prefs.set_pref_BANG_.call(null,pref,val);
});
devtools.core.set_single_feature_BANG_ = (function devtools$core$set_single_feature_BANG_(feature,val){
var temp__6751__auto__ = feature.call(null,devtools.core.known_features);
if(cljs.core.truth_(temp__6751__auto__)){
var feature_installation_key = temp__6751__auto__;
return devtools.core.set_pref_BANG_.call(null,feature_installation_key,val);
} else {
return console.warn(devtools.core.missing_feature_warning.call(null,feature,devtools.core.known_features));
}
});
devtools.core.enable_single_feature_BANG_ = (function devtools$core$enable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,true);
});
devtools.core.disable_single_feature_BANG_ = (function devtools$core$disable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,false);
});
devtools.core.enable_feature_BANG_ = (function devtools$core$enable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67649 = arguments.length;
var i__28497__auto___67650 = (0);
while(true){
if((i__28497__auto___67650 < len__28496__auto___67649)){
args__28503__auto__.push((arguments[i__28497__auto___67650]));

var G__67651 = (i__28497__auto___67650 + (1));
i__28497__auto___67650 = G__67651;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67645 = cljs.core.seq.call(null,features);
var chunk__67646 = null;
var count__67647 = (0);
var i__67648 = (0);
while(true){
if((i__67648 < count__67647)){
var feature = cljs.core._nth.call(null,chunk__67646,i__67648);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67652 = seq__67645;
var G__67653 = chunk__67646;
var G__67654 = count__67647;
var G__67655 = (i__67648 + (1));
seq__67645 = G__67652;
chunk__67646 = G__67653;
count__67647 = G__67654;
i__67648 = G__67655;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67645);
if(temp__6753__auto__){
var seq__67645__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67645__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__67645__$1);
var G__67656 = cljs.core.chunk_rest.call(null,seq__67645__$1);
var G__67657 = c__28186__auto__;
var G__67658 = cljs.core.count.call(null,c__28186__auto__);
var G__67659 = (0);
seq__67645 = G__67656;
chunk__67646 = G__67657;
count__67647 = G__67658;
i__67648 = G__67659;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67645__$1);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67660 = cljs.core.next.call(null,seq__67645__$1);
var G__67661 = null;
var G__67662 = (0);
var G__67663 = (0);
seq__67645 = G__67660;
chunk__67646 = G__67661;
count__67647 = G__67662;
i__67648 = G__67663;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.enable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.enable_feature_BANG_.cljs$lang$applyTo = (function (seq67644){
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67644));
});

devtools.core.disable_feature_BANG_ = (function devtools$core$disable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67669 = arguments.length;
var i__28497__auto___67670 = (0);
while(true){
if((i__28497__auto___67670 < len__28496__auto___67669)){
args__28503__auto__.push((arguments[i__28497__auto___67670]));

var G__67671 = (i__28497__auto___67670 + (1));
i__28497__auto___67670 = G__67671;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67665 = cljs.core.seq.call(null,features);
var chunk__67666 = null;
var count__67667 = (0);
var i__67668 = (0);
while(true){
if((i__67668 < count__67667)){
var feature = cljs.core._nth.call(null,chunk__67666,i__67668);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67672 = seq__67665;
var G__67673 = chunk__67666;
var G__67674 = count__67667;
var G__67675 = (i__67668 + (1));
seq__67665 = G__67672;
chunk__67666 = G__67673;
count__67667 = G__67674;
i__67668 = G__67675;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67665);
if(temp__6753__auto__){
var seq__67665__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67665__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__67665__$1);
var G__67676 = cljs.core.chunk_rest.call(null,seq__67665__$1);
var G__67677 = c__28186__auto__;
var G__67678 = cljs.core.count.call(null,c__28186__auto__);
var G__67679 = (0);
seq__67665 = G__67676;
chunk__67666 = G__67677;
count__67667 = G__67678;
i__67668 = G__67679;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67665__$1);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67680 = cljs.core.next.call(null,seq__67665__$1);
var G__67681 = null;
var G__67682 = (0);
var G__67683 = (0);
seq__67665 = G__67680;
chunk__67666 = G__67681;
count__67667 = G__67682;
i__67668 = G__67683;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.disable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.disable_feature_BANG_.cljs$lang$applyTo = (function (seq67664){
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67664));
});

devtools.core.single_feature_available_QMARK_ = (function devtools$core$single_feature_available_QMARK_(feature){
var G__67685 = (((feature instanceof cljs.core.Keyword))?feature.fqn:null);
switch (G__67685) {
case "custom-formatters":
return devtools.custom_formatters.available_QMARK_.call(null);

break;
case "dirac":
return devtools.dirac.available_QMARK_.call(null);

break;
case "sanity-hints":
return devtools.sanity_hints.available_QMARK_.call(null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(feature)].join('')));

}
});
devtools.core.feature_available_QMARK_ = (function devtools$core$feature_available_QMARK_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67688 = arguments.length;
var i__28497__auto___67689 = (0);
while(true){
if((i__28497__auto___67689 < len__28496__auto___67688)){
args__28503__auto__.push((arguments[i__28497__auto___67689]));

var G__67690 = (i__28497__auto___67689 + (1));
i__28497__auto___67689 = G__67690;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
return cljs.core.every_QMARK_.call(null,devtools.core.single_feature_available_QMARK_,features);
});

devtools.core.feature_available_QMARK_.cljs$lang$maxFixedArity = (0);

devtools.core.feature_available_QMARK_.cljs$lang$applyTo = (function (seq67687){
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67687));
});

devtools.core.enable_BANG_ = (function devtools$core$enable_BANG_(){
return console.warn([cljs.core.str("devtools.core/enable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});
devtools.core.disable_BANG_ = (function devtools$core$disable_BANG_(){
return console.warn([cljs.core.str("devtools.core/disable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});

//# sourceMappingURL=core.js.map?rel=1481754442484