// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27280__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27280__auto__){
return or__27280__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27280__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__70124_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__70124_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__70129 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__70130 = null;
var count__70131 = (0);
var i__70132 = (0);
while(true){
if((i__70132 < count__70131)){
var n = cljs.core._nth.call(null,chunk__70130,i__70132);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__70133 = seq__70129;
var G__70134 = chunk__70130;
var G__70135 = count__70131;
var G__70136 = (i__70132 + (1));
seq__70129 = G__70133;
chunk__70130 = G__70134;
count__70131 = G__70135;
i__70132 = G__70136;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__70129);
if(temp__6753__auto__){
var seq__70129__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70129__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__70129__$1);
var G__70137 = cljs.core.chunk_rest.call(null,seq__70129__$1);
var G__70138 = c__28186__auto__;
var G__70139 = cljs.core.count.call(null,c__28186__auto__);
var G__70140 = (0);
seq__70129 = G__70137;
chunk__70130 = G__70138;
count__70131 = G__70139;
i__70132 = G__70140;
continue;
} else {
var n = cljs.core.first.call(null,seq__70129__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__70141 = cljs.core.next.call(null,seq__70129__$1);
var G__70142 = null;
var G__70143 = (0);
var G__70144 = (0);
seq__70129 = G__70141;
chunk__70130 = G__70142;
count__70131 = G__70143;
i__70132 = G__70144;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__70195_70206 = cljs.core.seq.call(null,deps);
var chunk__70196_70207 = null;
var count__70197_70208 = (0);
var i__70198_70209 = (0);
while(true){
if((i__70198_70209 < count__70197_70208)){
var dep_70210 = cljs.core._nth.call(null,chunk__70196_70207,i__70198_70209);
topo_sort_helper_STAR_.call(null,dep_70210,(depth + (1)),state);

var G__70211 = seq__70195_70206;
var G__70212 = chunk__70196_70207;
var G__70213 = count__70197_70208;
var G__70214 = (i__70198_70209 + (1));
seq__70195_70206 = G__70211;
chunk__70196_70207 = G__70212;
count__70197_70208 = G__70213;
i__70198_70209 = G__70214;
continue;
} else {
var temp__6753__auto___70215 = cljs.core.seq.call(null,seq__70195_70206);
if(temp__6753__auto___70215){
var seq__70195_70216__$1 = temp__6753__auto___70215;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70195_70216__$1)){
var c__28186__auto___70217 = cljs.core.chunk_first.call(null,seq__70195_70216__$1);
var G__70218 = cljs.core.chunk_rest.call(null,seq__70195_70216__$1);
var G__70219 = c__28186__auto___70217;
var G__70220 = cljs.core.count.call(null,c__28186__auto___70217);
var G__70221 = (0);
seq__70195_70206 = G__70218;
chunk__70196_70207 = G__70219;
count__70197_70208 = G__70220;
i__70198_70209 = G__70221;
continue;
} else {
var dep_70222 = cljs.core.first.call(null,seq__70195_70216__$1);
topo_sort_helper_STAR_.call(null,dep_70222,(depth + (1)),state);

var G__70223 = cljs.core.next.call(null,seq__70195_70216__$1);
var G__70224 = null;
var G__70225 = (0);
var G__70226 = (0);
seq__70195_70206 = G__70223;
chunk__70196_70207 = G__70224;
count__70197_70208 = G__70225;
i__70198_70209 = G__70226;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__70199){
var vec__70203 = p__70199;
var seq__70204 = cljs.core.seq.call(null,vec__70203);
var first__70205 = cljs.core.first.call(null,seq__70204);
var seq__70204__$1 = cljs.core.next.call(null,seq__70204);
var x = first__70205;
var xs = seq__70204__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__70203,seq__70204,first__70205,seq__70204__$1,x,xs,get_deps__$1){
return (function (p1__70145_SHARP_){
return clojure.set.difference.call(null,p1__70145_SHARP_,x);
});})(vec__70203,seq__70204,first__70205,seq__70204__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__70239 = cljs.core.seq.call(null,provides);
var chunk__70240 = null;
var count__70241 = (0);
var i__70242 = (0);
while(true){
if((i__70242 < count__70241)){
var prov = cljs.core._nth.call(null,chunk__70240,i__70242);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__70243_70251 = cljs.core.seq.call(null,requires);
var chunk__70244_70252 = null;
var count__70245_70253 = (0);
var i__70246_70254 = (0);
while(true){
if((i__70246_70254 < count__70245_70253)){
var req_70255 = cljs.core._nth.call(null,chunk__70244_70252,i__70246_70254);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70255,prov);

var G__70256 = seq__70243_70251;
var G__70257 = chunk__70244_70252;
var G__70258 = count__70245_70253;
var G__70259 = (i__70246_70254 + (1));
seq__70243_70251 = G__70256;
chunk__70244_70252 = G__70257;
count__70245_70253 = G__70258;
i__70246_70254 = G__70259;
continue;
} else {
var temp__6753__auto___70260 = cljs.core.seq.call(null,seq__70243_70251);
if(temp__6753__auto___70260){
var seq__70243_70261__$1 = temp__6753__auto___70260;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70243_70261__$1)){
var c__28186__auto___70262 = cljs.core.chunk_first.call(null,seq__70243_70261__$1);
var G__70263 = cljs.core.chunk_rest.call(null,seq__70243_70261__$1);
var G__70264 = c__28186__auto___70262;
var G__70265 = cljs.core.count.call(null,c__28186__auto___70262);
var G__70266 = (0);
seq__70243_70251 = G__70263;
chunk__70244_70252 = G__70264;
count__70245_70253 = G__70265;
i__70246_70254 = G__70266;
continue;
} else {
var req_70267 = cljs.core.first.call(null,seq__70243_70261__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70267,prov);

var G__70268 = cljs.core.next.call(null,seq__70243_70261__$1);
var G__70269 = null;
var G__70270 = (0);
var G__70271 = (0);
seq__70243_70251 = G__70268;
chunk__70244_70252 = G__70269;
count__70245_70253 = G__70270;
i__70246_70254 = G__70271;
continue;
}
} else {
}
}
break;
}

var G__70272 = seq__70239;
var G__70273 = chunk__70240;
var G__70274 = count__70241;
var G__70275 = (i__70242 + (1));
seq__70239 = G__70272;
chunk__70240 = G__70273;
count__70241 = G__70274;
i__70242 = G__70275;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__70239);
if(temp__6753__auto__){
var seq__70239__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70239__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__70239__$1);
var G__70276 = cljs.core.chunk_rest.call(null,seq__70239__$1);
var G__70277 = c__28186__auto__;
var G__70278 = cljs.core.count.call(null,c__28186__auto__);
var G__70279 = (0);
seq__70239 = G__70276;
chunk__70240 = G__70277;
count__70241 = G__70278;
i__70242 = G__70279;
continue;
} else {
var prov = cljs.core.first.call(null,seq__70239__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__70247_70280 = cljs.core.seq.call(null,requires);
var chunk__70248_70281 = null;
var count__70249_70282 = (0);
var i__70250_70283 = (0);
while(true){
if((i__70250_70283 < count__70249_70282)){
var req_70284 = cljs.core._nth.call(null,chunk__70248_70281,i__70250_70283);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70284,prov);

var G__70285 = seq__70247_70280;
var G__70286 = chunk__70248_70281;
var G__70287 = count__70249_70282;
var G__70288 = (i__70250_70283 + (1));
seq__70247_70280 = G__70285;
chunk__70248_70281 = G__70286;
count__70249_70282 = G__70287;
i__70250_70283 = G__70288;
continue;
} else {
var temp__6753__auto___70289__$1 = cljs.core.seq.call(null,seq__70247_70280);
if(temp__6753__auto___70289__$1){
var seq__70247_70290__$1 = temp__6753__auto___70289__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70247_70290__$1)){
var c__28186__auto___70291 = cljs.core.chunk_first.call(null,seq__70247_70290__$1);
var G__70292 = cljs.core.chunk_rest.call(null,seq__70247_70290__$1);
var G__70293 = c__28186__auto___70291;
var G__70294 = cljs.core.count.call(null,c__28186__auto___70291);
var G__70295 = (0);
seq__70247_70280 = G__70292;
chunk__70248_70281 = G__70293;
count__70249_70282 = G__70294;
i__70250_70283 = G__70295;
continue;
} else {
var req_70296 = cljs.core.first.call(null,seq__70247_70290__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70296,prov);

var G__70297 = cljs.core.next.call(null,seq__70247_70290__$1);
var G__70298 = null;
var G__70299 = (0);
var G__70300 = (0);
seq__70247_70280 = G__70297;
chunk__70248_70281 = G__70298;
count__70249_70282 = G__70299;
i__70250_70283 = G__70300;
continue;
}
} else {
}
}
break;
}

var G__70301 = cljs.core.next.call(null,seq__70239__$1);
var G__70302 = null;
var G__70303 = (0);
var G__70304 = (0);
seq__70239 = G__70301;
chunk__70240 = G__70302;
count__70241 = G__70303;
i__70242 = G__70304;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__70309_70313 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__70310_70314 = null;
var count__70311_70315 = (0);
var i__70312_70316 = (0);
while(true){
if((i__70312_70316 < count__70311_70315)){
var ns_70317 = cljs.core._nth.call(null,chunk__70310_70314,i__70312_70316);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_70317);

var G__70318 = seq__70309_70313;
var G__70319 = chunk__70310_70314;
var G__70320 = count__70311_70315;
var G__70321 = (i__70312_70316 + (1));
seq__70309_70313 = G__70318;
chunk__70310_70314 = G__70319;
count__70311_70315 = G__70320;
i__70312_70316 = G__70321;
continue;
} else {
var temp__6753__auto___70322 = cljs.core.seq.call(null,seq__70309_70313);
if(temp__6753__auto___70322){
var seq__70309_70323__$1 = temp__6753__auto___70322;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70309_70323__$1)){
var c__28186__auto___70324 = cljs.core.chunk_first.call(null,seq__70309_70323__$1);
var G__70325 = cljs.core.chunk_rest.call(null,seq__70309_70323__$1);
var G__70326 = c__28186__auto___70324;
var G__70327 = cljs.core.count.call(null,c__28186__auto___70324);
var G__70328 = (0);
seq__70309_70313 = G__70325;
chunk__70310_70314 = G__70326;
count__70311_70315 = G__70327;
i__70312_70316 = G__70328;
continue;
} else {
var ns_70329 = cljs.core.first.call(null,seq__70309_70323__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_70329);

var G__70330 = cljs.core.next.call(null,seq__70309_70323__$1);
var G__70331 = null;
var G__70332 = (0);
var G__70333 = (0);
seq__70309_70313 = G__70330;
chunk__70310_70314 = G__70331;
count__70311_70315 = G__70332;
i__70312_70316 = G__70333;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27280__auto__ = goog.require__;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__70334__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__70334 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70335__i = 0, G__70335__a = new Array(arguments.length -  0);
while (G__70335__i < G__70335__a.length) {G__70335__a[G__70335__i] = arguments[G__70335__i + 0]; ++G__70335__i;}
  args = new cljs.core.IndexedSeq(G__70335__a,0);
} 
return G__70334__delegate.call(this,args);};
G__70334.cljs$lang$maxFixedArity = 0;
G__70334.cljs$lang$applyTo = (function (arglist__70336){
var args = cljs.core.seq(arglist__70336);
return G__70334__delegate(args);
});
G__70334.cljs$core$IFn$_invoke$arity$variadic = G__70334__delegate;
return G__70334;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__70338 = cljs.core._EQ_;
var expr__70339 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__70338.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__70339))){
var path_parts = ((function (pred__70338,expr__70339){
return (function (p1__70337_SHARP_){
return clojure.string.split.call(null,p1__70337_SHARP_,/[\/\\]/);
});})(pred__70338,expr__70339))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__70338,expr__70339){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e70341){if((e70341 instanceof Error)){
var e = e70341;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e70341;

}
}})());
});
;})(path_parts,sep,root,pred__70338,expr__70339))
} else {
if(cljs.core.truth_(pred__70338.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__70339))){
return ((function (pred__70338,expr__70339){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__70338,expr__70339){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__70338,expr__70339))
);

return deferred.addErrback(((function (deferred,pred__70338,expr__70339){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__70338,expr__70339))
);
});
;})(pred__70338,expr__70339))
} else {
return ((function (pred__70338,expr__70339){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__70338,expr__70339))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__70342,callback){
var map__70345 = p__70342;
var map__70345__$1 = ((((!((map__70345 == null)))?((((map__70345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70345.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70345):map__70345);
var file_msg = map__70345__$1;
var request_url = cljs.core.get.call(null,map__70345__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__70345,map__70345__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__70345,map__70345__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_70369){
var state_val_70370 = (state_70369[(1)]);
if((state_val_70370 === (7))){
var inst_70365 = (state_70369[(2)]);
var state_70369__$1 = state_70369;
var statearr_70371_70391 = state_70369__$1;
(statearr_70371_70391[(2)] = inst_70365);

(statearr_70371_70391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (1))){
var state_70369__$1 = state_70369;
var statearr_70372_70392 = state_70369__$1;
(statearr_70372_70392[(2)] = null);

(statearr_70372_70392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (4))){
var inst_70349 = (state_70369[(7)]);
var inst_70349__$1 = (state_70369[(2)]);
var state_70369__$1 = (function (){var statearr_70373 = state_70369;
(statearr_70373[(7)] = inst_70349__$1);

return statearr_70373;
})();
if(cljs.core.truth_(inst_70349__$1)){
var statearr_70374_70393 = state_70369__$1;
(statearr_70374_70393[(1)] = (5));

} else {
var statearr_70375_70394 = state_70369__$1;
(statearr_70375_70394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (6))){
var state_70369__$1 = state_70369;
var statearr_70376_70395 = state_70369__$1;
(statearr_70376_70395[(2)] = null);

(statearr_70376_70395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (3))){
var inst_70367 = (state_70369[(2)]);
var state_70369__$1 = state_70369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70369__$1,inst_70367);
} else {
if((state_val_70370 === (2))){
var state_70369__$1 = state_70369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70369__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_70370 === (11))){
var inst_70361 = (state_70369[(2)]);
var state_70369__$1 = (function (){var statearr_70377 = state_70369;
(statearr_70377[(8)] = inst_70361);

return statearr_70377;
})();
var statearr_70378_70396 = state_70369__$1;
(statearr_70378_70396[(2)] = null);

(statearr_70378_70396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (9))){
var inst_70353 = (state_70369[(9)]);
var inst_70355 = (state_70369[(10)]);
var inst_70357 = inst_70355.call(null,inst_70353);
var state_70369__$1 = state_70369;
var statearr_70379_70397 = state_70369__$1;
(statearr_70379_70397[(2)] = inst_70357);

(statearr_70379_70397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (5))){
var inst_70349 = (state_70369[(7)]);
var inst_70351 = figwheel.client.file_reloading.blocking_load.call(null,inst_70349);
var state_70369__$1 = state_70369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70369__$1,(8),inst_70351);
} else {
if((state_val_70370 === (10))){
var inst_70353 = (state_70369[(9)]);
var inst_70359 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_70353);
var state_70369__$1 = state_70369;
var statearr_70380_70398 = state_70369__$1;
(statearr_70380_70398[(2)] = inst_70359);

(statearr_70380_70398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70370 === (8))){
var inst_70355 = (state_70369[(10)]);
var inst_70349 = (state_70369[(7)]);
var inst_70353 = (state_70369[(2)]);
var inst_70354 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_70355__$1 = cljs.core.get.call(null,inst_70354,inst_70349);
var state_70369__$1 = (function (){var statearr_70381 = state_70369;
(statearr_70381[(9)] = inst_70353);

(statearr_70381[(10)] = inst_70355__$1);

return statearr_70381;
})();
if(cljs.core.truth_(inst_70355__$1)){
var statearr_70382_70399 = state_70369__$1;
(statearr_70382_70399[(1)] = (9));

} else {
var statearr_70383_70400 = state_70369__$1;
(statearr_70383_70400[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$state_machine__41806__auto____0 = (function (){
var statearr_70387 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70387[(0)] = figwheel$client$file_reloading$state_machine__41806__auto__);

(statearr_70387[(1)] = (1));

return statearr_70387;
});
var figwheel$client$file_reloading$state_machine__41806__auto____1 = (function (state_70369){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e70388){if((e70388 instanceof Object)){
var ex__41809__auto__ = e70388;
var statearr_70389_70401 = state_70369;
(statearr_70389_70401[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70402 = state_70369;
state_70369 = G__70402;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__41806__auto__ = function(state_70369){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__41806__auto____1.call(this,state_70369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__41806__auto____0;
figwheel$client$file_reloading$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__41806__auto____1;
return figwheel$client$file_reloading$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_70390 = f__41823__auto__.call(null);
(statearr_70390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_70390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__70403,callback){
var map__70406 = p__70403;
var map__70406__$1 = ((((!((map__70406 == null)))?((((map__70406.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70406.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70406):map__70406);
var file_msg = map__70406__$1;
var namespace = cljs.core.get.call(null,map__70406__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__70406,map__70406__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__70406,map__70406__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__70408){
var map__70411 = p__70408;
var map__70411__$1 = ((((!((map__70411 == null)))?((((map__70411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70411.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70411):map__70411);
var file_msg = map__70411__$1;
var namespace = cljs.core.get.call(null,map__70411__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27268__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__27268__auto__){
var or__27280__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
var or__27280__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto____$1)){
return or__27280__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27268__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__70413,callback){
var map__70416 = p__70413;
var map__70416__$1 = ((((!((map__70416 == null)))?((((map__70416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70416):map__70416);
var file_msg = map__70416__$1;
var request_url = cljs.core.get.call(null,map__70416__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__70416__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__41822__auto___70520 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___70520,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___70520,out){
return (function (state_70502){
var state_val_70503 = (state_70502[(1)]);
if((state_val_70503 === (1))){
var inst_70476 = cljs.core.seq.call(null,files);
var inst_70477 = cljs.core.first.call(null,inst_70476);
var inst_70478 = cljs.core.next.call(null,inst_70476);
var inst_70479 = files;
var state_70502__$1 = (function (){var statearr_70504 = state_70502;
(statearr_70504[(7)] = inst_70479);

(statearr_70504[(8)] = inst_70478);

(statearr_70504[(9)] = inst_70477);

return statearr_70504;
})();
var statearr_70505_70521 = state_70502__$1;
(statearr_70505_70521[(2)] = null);

(statearr_70505_70521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (2))){
var inst_70479 = (state_70502[(7)]);
var inst_70485 = (state_70502[(10)]);
var inst_70484 = cljs.core.seq.call(null,inst_70479);
var inst_70485__$1 = cljs.core.first.call(null,inst_70484);
var inst_70486 = cljs.core.next.call(null,inst_70484);
var inst_70487 = (inst_70485__$1 == null);
var inst_70488 = cljs.core.not.call(null,inst_70487);
var state_70502__$1 = (function (){var statearr_70506 = state_70502;
(statearr_70506[(10)] = inst_70485__$1);

(statearr_70506[(11)] = inst_70486);

return statearr_70506;
})();
if(inst_70488){
var statearr_70507_70522 = state_70502__$1;
(statearr_70507_70522[(1)] = (4));

} else {
var statearr_70508_70523 = state_70502__$1;
(statearr_70508_70523[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (3))){
var inst_70500 = (state_70502[(2)]);
var state_70502__$1 = state_70502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70502__$1,inst_70500);
} else {
if((state_val_70503 === (4))){
var inst_70485 = (state_70502[(10)]);
var inst_70490 = figwheel.client.file_reloading.reload_js_file.call(null,inst_70485);
var state_70502__$1 = state_70502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70502__$1,(7),inst_70490);
} else {
if((state_val_70503 === (5))){
var inst_70496 = cljs.core.async.close_BANG_.call(null,out);
var state_70502__$1 = state_70502;
var statearr_70509_70524 = state_70502__$1;
(statearr_70509_70524[(2)] = inst_70496);

(statearr_70509_70524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (6))){
var inst_70498 = (state_70502[(2)]);
var state_70502__$1 = state_70502;
var statearr_70510_70525 = state_70502__$1;
(statearr_70510_70525[(2)] = inst_70498);

(statearr_70510_70525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70503 === (7))){
var inst_70486 = (state_70502[(11)]);
var inst_70492 = (state_70502[(2)]);
var inst_70493 = cljs.core.async.put_BANG_.call(null,out,inst_70492);
var inst_70479 = inst_70486;
var state_70502__$1 = (function (){var statearr_70511 = state_70502;
(statearr_70511[(7)] = inst_70479);

(statearr_70511[(12)] = inst_70493);

return statearr_70511;
})();
var statearr_70512_70526 = state_70502__$1;
(statearr_70512_70526[(2)] = null);

(statearr_70512_70526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__41822__auto___70520,out))
;
return ((function (switch__41805__auto__,c__41822__auto___70520,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0 = (function (){
var statearr_70516 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70516[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__);

(statearr_70516[(1)] = (1));

return statearr_70516;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1 = (function (state_70502){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e70517){if((e70517 instanceof Object)){
var ex__41809__auto__ = e70517;
var statearr_70518_70527 = state_70502;
(statearr_70518_70527[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70517;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70528 = state_70502;
state_70502 = G__70528;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__ = function(state_70502){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1.call(this,state_70502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___70520,out))
})();
var state__41824__auto__ = (function (){var statearr_70519 = f__41823__auto__.call(null);
(statearr_70519[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___70520);

return statearr_70519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___70520,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__70529,opts){
var map__70533 = p__70529;
var map__70533__$1 = ((((!((map__70533 == null)))?((((map__70533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70533.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70533):map__70533);
var eval_body = cljs.core.get.call(null,map__70533__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__70533__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27268__auto__ = eval_body;
if(cljs.core.truth_(and__27268__auto__)){
return typeof eval_body === 'string';
} else {
return and__27268__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e70535){var e = e70535;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__70536_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__70536_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__70545){
var vec__70546 = p__70545;
var k = cljs.core.nth.call(null,vec__70546,(0),null);
var v = cljs.core.nth.call(null,vec__70546,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__70549){
var vec__70550 = p__70549;
var k = cljs.core.nth.call(null,vec__70550,(0),null);
var v = cljs.core.nth.call(null,vec__70550,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__70556,p__70557){
var map__70805 = p__70556;
var map__70805__$1 = ((((!((map__70805 == null)))?((((map__70805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70805.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70805):map__70805);
var opts = map__70805__$1;
var before_jsload = cljs.core.get.call(null,map__70805__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__70805__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__70805__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__70806 = p__70557;
var map__70806__$1 = ((((!((map__70806 == null)))?((((map__70806.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70806.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70806):map__70806);
var msg = map__70806__$1;
var files = cljs.core.get.call(null,map__70806__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__70806__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__70806__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_70960){
var state_val_70961 = (state_70960[(1)]);
if((state_val_70961 === (7))){
var inst_70823 = (state_70960[(7)]);
var inst_70821 = (state_70960[(8)]);
var inst_70820 = (state_70960[(9)]);
var inst_70822 = (state_70960[(10)]);
var inst_70828 = cljs.core._nth.call(null,inst_70821,inst_70823);
var inst_70829 = figwheel.client.file_reloading.eval_body.call(null,inst_70828,opts);
var inst_70830 = (inst_70823 + (1));
var tmp70962 = inst_70821;
var tmp70963 = inst_70820;
var tmp70964 = inst_70822;
var inst_70820__$1 = tmp70963;
var inst_70821__$1 = tmp70962;
var inst_70822__$1 = tmp70964;
var inst_70823__$1 = inst_70830;
var state_70960__$1 = (function (){var statearr_70965 = state_70960;
(statearr_70965[(7)] = inst_70823__$1);

(statearr_70965[(11)] = inst_70829);

(statearr_70965[(8)] = inst_70821__$1);

(statearr_70965[(9)] = inst_70820__$1);

(statearr_70965[(10)] = inst_70822__$1);

return statearr_70965;
})();
var statearr_70966_71052 = state_70960__$1;
(statearr_70966_71052[(2)] = null);

(statearr_70966_71052[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (20))){
var inst_70863 = (state_70960[(12)]);
var inst_70871 = figwheel.client.file_reloading.sort_files.call(null,inst_70863);
var state_70960__$1 = state_70960;
var statearr_70967_71053 = state_70960__$1;
(statearr_70967_71053[(2)] = inst_70871);

(statearr_70967_71053[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (27))){
var state_70960__$1 = state_70960;
var statearr_70968_71054 = state_70960__$1;
(statearr_70968_71054[(2)] = null);

(statearr_70968_71054[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (1))){
var inst_70812 = (state_70960[(13)]);
var inst_70809 = before_jsload.call(null,files);
var inst_70810 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_70811 = (function (){return ((function (inst_70812,inst_70809,inst_70810,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70553_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__70553_SHARP_);
});
;})(inst_70812,inst_70809,inst_70810,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70812__$1 = cljs.core.filter.call(null,inst_70811,files);
var inst_70813 = cljs.core.not_empty.call(null,inst_70812__$1);
var state_70960__$1 = (function (){var statearr_70969 = state_70960;
(statearr_70969[(14)] = inst_70810);

(statearr_70969[(15)] = inst_70809);

(statearr_70969[(13)] = inst_70812__$1);

return statearr_70969;
})();
if(cljs.core.truth_(inst_70813)){
var statearr_70970_71055 = state_70960__$1;
(statearr_70970_71055[(1)] = (2));

} else {
var statearr_70971_71056 = state_70960__$1;
(statearr_70971_71056[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (24))){
var state_70960__$1 = state_70960;
var statearr_70972_71057 = state_70960__$1;
(statearr_70972_71057[(2)] = null);

(statearr_70972_71057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (39))){
var inst_70913 = (state_70960[(16)]);
var state_70960__$1 = state_70960;
var statearr_70973_71058 = state_70960__$1;
(statearr_70973_71058[(2)] = inst_70913);

(statearr_70973_71058[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (46))){
var inst_70955 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_70974_71059 = state_70960__$1;
(statearr_70974_71059[(2)] = inst_70955);

(statearr_70974_71059[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (4))){
var inst_70857 = (state_70960[(2)]);
var inst_70858 = cljs.core.List.EMPTY;
var inst_70859 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_70858);
var inst_70860 = (function (){return ((function (inst_70857,inst_70858,inst_70859,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70554_SHARP_){
var and__27268__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__70554_SHARP_);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__70554_SHARP_));
} else {
return and__27268__auto__;
}
});
;})(inst_70857,inst_70858,inst_70859,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70861 = cljs.core.filter.call(null,inst_70860,files);
var inst_70862 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_70863 = cljs.core.concat.call(null,inst_70861,inst_70862);
var state_70960__$1 = (function (){var statearr_70975 = state_70960;
(statearr_70975[(12)] = inst_70863);

(statearr_70975[(17)] = inst_70857);

(statearr_70975[(18)] = inst_70859);

return statearr_70975;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_70976_71060 = state_70960__$1;
(statearr_70976_71060[(1)] = (16));

} else {
var statearr_70977_71061 = state_70960__$1;
(statearr_70977_71061[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (15))){
var inst_70847 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_70978_71062 = state_70960__$1;
(statearr_70978_71062[(2)] = inst_70847);

(statearr_70978_71062[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (21))){
var inst_70873 = (state_70960[(19)]);
var inst_70873__$1 = (state_70960[(2)]);
var inst_70874 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_70873__$1);
var state_70960__$1 = (function (){var statearr_70979 = state_70960;
(statearr_70979[(19)] = inst_70873__$1);

return statearr_70979;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70960__$1,(22),inst_70874);
} else {
if((state_val_70961 === (31))){
var inst_70958 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70960__$1,inst_70958);
} else {
if((state_val_70961 === (32))){
var inst_70913 = (state_70960[(16)]);
var inst_70918 = inst_70913.cljs$lang$protocol_mask$partition0$;
var inst_70919 = (inst_70918 & (64));
var inst_70920 = inst_70913.cljs$core$ISeq$;
var inst_70921 = (cljs.core.PROTOCOL_SENTINEL === inst_70920);
var inst_70922 = (inst_70919) || (inst_70921);
var state_70960__$1 = state_70960;
if(cljs.core.truth_(inst_70922)){
var statearr_70980_71063 = state_70960__$1;
(statearr_70980_71063[(1)] = (35));

} else {
var statearr_70981_71064 = state_70960__$1;
(statearr_70981_71064[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (40))){
var inst_70935 = (state_70960[(20)]);
var inst_70934 = (state_70960[(2)]);
var inst_70935__$1 = cljs.core.get.call(null,inst_70934,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_70936 = cljs.core.get.call(null,inst_70934,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_70937 = cljs.core.not_empty.call(null,inst_70935__$1);
var state_70960__$1 = (function (){var statearr_70982 = state_70960;
(statearr_70982[(20)] = inst_70935__$1);

(statearr_70982[(21)] = inst_70936);

return statearr_70982;
})();
if(cljs.core.truth_(inst_70937)){
var statearr_70983_71065 = state_70960__$1;
(statearr_70983_71065[(1)] = (41));

} else {
var statearr_70984_71066 = state_70960__$1;
(statearr_70984_71066[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (33))){
var state_70960__$1 = state_70960;
var statearr_70985_71067 = state_70960__$1;
(statearr_70985_71067[(2)] = false);

(statearr_70985_71067[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (13))){
var inst_70833 = (state_70960[(22)]);
var inst_70837 = cljs.core.chunk_first.call(null,inst_70833);
var inst_70838 = cljs.core.chunk_rest.call(null,inst_70833);
var inst_70839 = cljs.core.count.call(null,inst_70837);
var inst_70820 = inst_70838;
var inst_70821 = inst_70837;
var inst_70822 = inst_70839;
var inst_70823 = (0);
var state_70960__$1 = (function (){var statearr_70986 = state_70960;
(statearr_70986[(7)] = inst_70823);

(statearr_70986[(8)] = inst_70821);

(statearr_70986[(9)] = inst_70820);

(statearr_70986[(10)] = inst_70822);

return statearr_70986;
})();
var statearr_70987_71068 = state_70960__$1;
(statearr_70987_71068[(2)] = null);

(statearr_70987_71068[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (22))){
var inst_70877 = (state_70960[(23)]);
var inst_70873 = (state_70960[(19)]);
var inst_70876 = (state_70960[(24)]);
var inst_70881 = (state_70960[(25)]);
var inst_70876__$1 = (state_70960[(2)]);
var inst_70877__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_70876__$1);
var inst_70878 = (function (){var all_files = inst_70873;
var res_SINGLEQUOTE_ = inst_70876__$1;
var res = inst_70877__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_70877,inst_70873,inst_70876,inst_70881,inst_70876__$1,inst_70877__$1,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70555_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__70555_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_70877,inst_70873,inst_70876,inst_70881,inst_70876__$1,inst_70877__$1,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70879 = cljs.core.filter.call(null,inst_70878,inst_70876__$1);
var inst_70880 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_70881__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_70880);
var inst_70882 = cljs.core.not_empty.call(null,inst_70881__$1);
var state_70960__$1 = (function (){var statearr_70988 = state_70960;
(statearr_70988[(26)] = inst_70879);

(statearr_70988[(23)] = inst_70877__$1);

(statearr_70988[(24)] = inst_70876__$1);

(statearr_70988[(25)] = inst_70881__$1);

return statearr_70988;
})();
if(cljs.core.truth_(inst_70882)){
var statearr_70989_71069 = state_70960__$1;
(statearr_70989_71069[(1)] = (23));

} else {
var statearr_70990_71070 = state_70960__$1;
(statearr_70990_71070[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (36))){
var state_70960__$1 = state_70960;
var statearr_70991_71071 = state_70960__$1;
(statearr_70991_71071[(2)] = false);

(statearr_70991_71071[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (41))){
var inst_70935 = (state_70960[(20)]);
var inst_70939 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_70940 = cljs.core.map.call(null,inst_70939,inst_70935);
var inst_70941 = cljs.core.pr_str.call(null,inst_70940);
var inst_70942 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_70941)].join('');
var inst_70943 = figwheel.client.utils.log.call(null,inst_70942);
var state_70960__$1 = state_70960;
var statearr_70992_71072 = state_70960__$1;
(statearr_70992_71072[(2)] = inst_70943);

(statearr_70992_71072[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (43))){
var inst_70936 = (state_70960[(21)]);
var inst_70946 = (state_70960[(2)]);
var inst_70947 = cljs.core.not_empty.call(null,inst_70936);
var state_70960__$1 = (function (){var statearr_70993 = state_70960;
(statearr_70993[(27)] = inst_70946);

return statearr_70993;
})();
if(cljs.core.truth_(inst_70947)){
var statearr_70994_71073 = state_70960__$1;
(statearr_70994_71073[(1)] = (44));

} else {
var statearr_70995_71074 = state_70960__$1;
(statearr_70995_71074[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (29))){
var inst_70879 = (state_70960[(26)]);
var inst_70877 = (state_70960[(23)]);
var inst_70873 = (state_70960[(19)]);
var inst_70876 = (state_70960[(24)]);
var inst_70881 = (state_70960[(25)]);
var inst_70913 = (state_70960[(16)]);
var inst_70909 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_70912 = (function (){var all_files = inst_70873;
var res_SINGLEQUOTE_ = inst_70876;
var res = inst_70877;
var files_not_loaded = inst_70879;
var dependencies_that_loaded = inst_70881;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70913,inst_70909,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70911){
var map__70996 = p__70911;
var map__70996__$1 = ((((!((map__70996 == null)))?((((map__70996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70996.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70996):map__70996);
var namespace = cljs.core.get.call(null,map__70996__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70913,inst_70909,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70913__$1 = cljs.core.group_by.call(null,inst_70912,inst_70879);
var inst_70915 = (inst_70913__$1 == null);
var inst_70916 = cljs.core.not.call(null,inst_70915);
var state_70960__$1 = (function (){var statearr_70998 = state_70960;
(statearr_70998[(28)] = inst_70909);

(statearr_70998[(16)] = inst_70913__$1);

return statearr_70998;
})();
if(inst_70916){
var statearr_70999_71075 = state_70960__$1;
(statearr_70999_71075[(1)] = (32));

} else {
var statearr_71000_71076 = state_70960__$1;
(statearr_71000_71076[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (44))){
var inst_70936 = (state_70960[(21)]);
var inst_70949 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_70936);
var inst_70950 = cljs.core.pr_str.call(null,inst_70949);
var inst_70951 = [cljs.core.str("not required: "),cljs.core.str(inst_70950)].join('');
var inst_70952 = figwheel.client.utils.log.call(null,inst_70951);
var state_70960__$1 = state_70960;
var statearr_71001_71077 = state_70960__$1;
(statearr_71001_71077[(2)] = inst_70952);

(statearr_71001_71077[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (6))){
var inst_70854 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_71002_71078 = state_70960__$1;
(statearr_71002_71078[(2)] = inst_70854);

(statearr_71002_71078[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (28))){
var inst_70879 = (state_70960[(26)]);
var inst_70906 = (state_70960[(2)]);
var inst_70907 = cljs.core.not_empty.call(null,inst_70879);
var state_70960__$1 = (function (){var statearr_71003 = state_70960;
(statearr_71003[(29)] = inst_70906);

return statearr_71003;
})();
if(cljs.core.truth_(inst_70907)){
var statearr_71004_71079 = state_70960__$1;
(statearr_71004_71079[(1)] = (29));

} else {
var statearr_71005_71080 = state_70960__$1;
(statearr_71005_71080[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (25))){
var inst_70877 = (state_70960[(23)]);
var inst_70893 = (state_70960[(2)]);
var inst_70894 = cljs.core.not_empty.call(null,inst_70877);
var state_70960__$1 = (function (){var statearr_71006 = state_70960;
(statearr_71006[(30)] = inst_70893);

return statearr_71006;
})();
if(cljs.core.truth_(inst_70894)){
var statearr_71007_71081 = state_70960__$1;
(statearr_71007_71081[(1)] = (26));

} else {
var statearr_71008_71082 = state_70960__$1;
(statearr_71008_71082[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (34))){
var inst_70929 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
if(cljs.core.truth_(inst_70929)){
var statearr_71009_71083 = state_70960__$1;
(statearr_71009_71083[(1)] = (38));

} else {
var statearr_71010_71084 = state_70960__$1;
(statearr_71010_71084[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (17))){
var state_70960__$1 = state_70960;
var statearr_71011_71085 = state_70960__$1;
(statearr_71011_71085[(2)] = recompile_dependents);

(statearr_71011_71085[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (3))){
var state_70960__$1 = state_70960;
var statearr_71012_71086 = state_70960__$1;
(statearr_71012_71086[(2)] = null);

(statearr_71012_71086[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (12))){
var inst_70850 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_71013_71087 = state_70960__$1;
(statearr_71013_71087[(2)] = inst_70850);

(statearr_71013_71087[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (2))){
var inst_70812 = (state_70960[(13)]);
var inst_70819 = cljs.core.seq.call(null,inst_70812);
var inst_70820 = inst_70819;
var inst_70821 = null;
var inst_70822 = (0);
var inst_70823 = (0);
var state_70960__$1 = (function (){var statearr_71014 = state_70960;
(statearr_71014[(7)] = inst_70823);

(statearr_71014[(8)] = inst_70821);

(statearr_71014[(9)] = inst_70820);

(statearr_71014[(10)] = inst_70822);

return statearr_71014;
})();
var statearr_71015_71088 = state_70960__$1;
(statearr_71015_71088[(2)] = null);

(statearr_71015_71088[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (23))){
var inst_70879 = (state_70960[(26)]);
var inst_70877 = (state_70960[(23)]);
var inst_70873 = (state_70960[(19)]);
var inst_70876 = (state_70960[(24)]);
var inst_70881 = (state_70960[(25)]);
var inst_70884 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_70886 = (function (){var all_files = inst_70873;
var res_SINGLEQUOTE_ = inst_70876;
var res = inst_70877;
var files_not_loaded = inst_70879;
var dependencies_that_loaded = inst_70881;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70884,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70885){
var map__71016 = p__70885;
var map__71016__$1 = ((((!((map__71016 == null)))?((((map__71016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71016.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71016):map__71016);
var request_url = cljs.core.get.call(null,map__71016__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70884,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70887 = cljs.core.reverse.call(null,inst_70881);
var inst_70888 = cljs.core.map.call(null,inst_70886,inst_70887);
var inst_70889 = cljs.core.pr_str.call(null,inst_70888);
var inst_70890 = figwheel.client.utils.log.call(null,inst_70889);
var state_70960__$1 = (function (){var statearr_71018 = state_70960;
(statearr_71018[(31)] = inst_70884);

return statearr_71018;
})();
var statearr_71019_71089 = state_70960__$1;
(statearr_71019_71089[(2)] = inst_70890);

(statearr_71019_71089[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (35))){
var state_70960__$1 = state_70960;
var statearr_71020_71090 = state_70960__$1;
(statearr_71020_71090[(2)] = true);

(statearr_71020_71090[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (19))){
var inst_70863 = (state_70960[(12)]);
var inst_70869 = figwheel.client.file_reloading.expand_files.call(null,inst_70863);
var state_70960__$1 = state_70960;
var statearr_71021_71091 = state_70960__$1;
(statearr_71021_71091[(2)] = inst_70869);

(statearr_71021_71091[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (11))){
var state_70960__$1 = state_70960;
var statearr_71022_71092 = state_70960__$1;
(statearr_71022_71092[(2)] = null);

(statearr_71022_71092[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (9))){
var inst_70852 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_71023_71093 = state_70960__$1;
(statearr_71023_71093[(2)] = inst_70852);

(statearr_71023_71093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (5))){
var inst_70823 = (state_70960[(7)]);
var inst_70822 = (state_70960[(10)]);
var inst_70825 = (inst_70823 < inst_70822);
var inst_70826 = inst_70825;
var state_70960__$1 = state_70960;
if(cljs.core.truth_(inst_70826)){
var statearr_71024_71094 = state_70960__$1;
(statearr_71024_71094[(1)] = (7));

} else {
var statearr_71025_71095 = state_70960__$1;
(statearr_71025_71095[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (14))){
var inst_70833 = (state_70960[(22)]);
var inst_70842 = cljs.core.first.call(null,inst_70833);
var inst_70843 = figwheel.client.file_reloading.eval_body.call(null,inst_70842,opts);
var inst_70844 = cljs.core.next.call(null,inst_70833);
var inst_70820 = inst_70844;
var inst_70821 = null;
var inst_70822 = (0);
var inst_70823 = (0);
var state_70960__$1 = (function (){var statearr_71026 = state_70960;
(statearr_71026[(32)] = inst_70843);

(statearr_71026[(7)] = inst_70823);

(statearr_71026[(8)] = inst_70821);

(statearr_71026[(9)] = inst_70820);

(statearr_71026[(10)] = inst_70822);

return statearr_71026;
})();
var statearr_71027_71096 = state_70960__$1;
(statearr_71027_71096[(2)] = null);

(statearr_71027_71096[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (45))){
var state_70960__$1 = state_70960;
var statearr_71028_71097 = state_70960__$1;
(statearr_71028_71097[(2)] = null);

(statearr_71028_71097[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (26))){
var inst_70879 = (state_70960[(26)]);
var inst_70877 = (state_70960[(23)]);
var inst_70873 = (state_70960[(19)]);
var inst_70876 = (state_70960[(24)]);
var inst_70881 = (state_70960[(25)]);
var inst_70896 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_70898 = (function (){var all_files = inst_70873;
var res_SINGLEQUOTE_ = inst_70876;
var res = inst_70877;
var files_not_loaded = inst_70879;
var dependencies_that_loaded = inst_70881;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70896,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70897){
var map__71029 = p__70897;
var map__71029__$1 = ((((!((map__71029 == null)))?((((map__71029.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71029.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71029):map__71029);
var namespace = cljs.core.get.call(null,map__71029__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__71029__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70896,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70899 = cljs.core.map.call(null,inst_70898,inst_70877);
var inst_70900 = cljs.core.pr_str.call(null,inst_70899);
var inst_70901 = figwheel.client.utils.log.call(null,inst_70900);
var inst_70902 = (function (){var all_files = inst_70873;
var res_SINGLEQUOTE_ = inst_70876;
var res = inst_70877;
var files_not_loaded = inst_70879;
var dependencies_that_loaded = inst_70881;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70896,inst_70898,inst_70899,inst_70900,inst_70901,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70879,inst_70877,inst_70873,inst_70876,inst_70881,inst_70896,inst_70898,inst_70899,inst_70900,inst_70901,state_val_70961,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70903 = setTimeout(inst_70902,(10));
var state_70960__$1 = (function (){var statearr_71031 = state_70960;
(statearr_71031[(33)] = inst_70901);

(statearr_71031[(34)] = inst_70896);

return statearr_71031;
})();
var statearr_71032_71098 = state_70960__$1;
(statearr_71032_71098[(2)] = inst_70903);

(statearr_71032_71098[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (16))){
var state_70960__$1 = state_70960;
var statearr_71033_71099 = state_70960__$1;
(statearr_71033_71099[(2)] = reload_dependents);

(statearr_71033_71099[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (38))){
var inst_70913 = (state_70960[(16)]);
var inst_70931 = cljs.core.apply.call(null,cljs.core.hash_map,inst_70913);
var state_70960__$1 = state_70960;
var statearr_71034_71100 = state_70960__$1;
(statearr_71034_71100[(2)] = inst_70931);

(statearr_71034_71100[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (30))){
var state_70960__$1 = state_70960;
var statearr_71035_71101 = state_70960__$1;
(statearr_71035_71101[(2)] = null);

(statearr_71035_71101[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (10))){
var inst_70833 = (state_70960[(22)]);
var inst_70835 = cljs.core.chunked_seq_QMARK_.call(null,inst_70833);
var state_70960__$1 = state_70960;
if(inst_70835){
var statearr_71036_71102 = state_70960__$1;
(statearr_71036_71102[(1)] = (13));

} else {
var statearr_71037_71103 = state_70960__$1;
(statearr_71037_71103[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (18))){
var inst_70867 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
if(cljs.core.truth_(inst_70867)){
var statearr_71038_71104 = state_70960__$1;
(statearr_71038_71104[(1)] = (19));

} else {
var statearr_71039_71105 = state_70960__$1;
(statearr_71039_71105[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (42))){
var state_70960__$1 = state_70960;
var statearr_71040_71106 = state_70960__$1;
(statearr_71040_71106[(2)] = null);

(statearr_71040_71106[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (37))){
var inst_70926 = (state_70960[(2)]);
var state_70960__$1 = state_70960;
var statearr_71041_71107 = state_70960__$1;
(statearr_71041_71107[(2)] = inst_70926);

(statearr_71041_71107[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70961 === (8))){
var inst_70833 = (state_70960[(22)]);
var inst_70820 = (state_70960[(9)]);
var inst_70833__$1 = cljs.core.seq.call(null,inst_70820);
var state_70960__$1 = (function (){var statearr_71042 = state_70960;
(statearr_71042[(22)] = inst_70833__$1);

return statearr_71042;
})();
if(inst_70833__$1){
var statearr_71043_71108 = state_70960__$1;
(statearr_71043_71108[(1)] = (10));

} else {
var statearr_71044_71109 = state_70960__$1;
(statearr_71044_71109[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__41805__auto__,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0 = (function (){
var statearr_71048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71048[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__);

(statearr_71048[(1)] = (1));

return statearr_71048;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1 = (function (state_70960){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e71049){if((e71049 instanceof Object)){
var ex__41809__auto__ = e71049;
var statearr_71050_71110 = state_70960;
(statearr_71050_71110[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71049;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71111 = state_70960;
state_70960 = G__71111;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__ = function(state_70960){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1.call(this,state_70960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__41824__auto__ = (function (){var statearr_71051 = f__41823__auto__.call(null);
(statearr_71051[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_71051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__,map__70805,map__70805__$1,opts,before_jsload,on_jsload,reload_dependents,map__70806,map__70806__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__41822__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__71114,link){
var map__71117 = p__71114;
var map__71117__$1 = ((((!((map__71117 == null)))?((((map__71117.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71117.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71117):map__71117);
var file = cljs.core.get.call(null,map__71117__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__71117,map__71117__$1,file){
return (function (p1__71112_SHARP_,p2__71113_SHARP_){
if(cljs.core._EQ_.call(null,p1__71112_SHARP_,p2__71113_SHARP_)){
return p1__71112_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__71117,map__71117__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__71123){
var map__71124 = p__71123;
var map__71124__$1 = ((((!((map__71124 == null)))?((((map__71124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71124.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71124):map__71124);
var match_length = cljs.core.get.call(null,map__71124__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__71124__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__71119_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__71119_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args71126 = [];
var len__28496__auto___71129 = arguments.length;
var i__28497__auto___71130 = (0);
while(true){
if((i__28497__auto___71130 < len__28496__auto___71129)){
args71126.push((arguments[i__28497__auto___71130]));

var G__71131 = (i__28497__auto___71130 + (1));
i__28497__auto___71130 = G__71131;
continue;
} else {
}
break;
}

var G__71128 = args71126.length;
switch (G__71128) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args71126.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__71133_SHARP_,p2__71134_SHARP_){
return cljs.core.assoc.call(null,p1__71133_SHARP_,cljs.core.get.call(null,p2__71134_SHARP_,key),p2__71134_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__71135){
var map__71138 = p__71135;
var map__71138__$1 = ((((!((map__71138 == null)))?((((map__71138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71138.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71138):map__71138);
var f_data = map__71138__$1;
var file = cljs.core.get.call(null,map__71138__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__71140,p__71141){
var map__71150 = p__71140;
var map__71150__$1 = ((((!((map__71150 == null)))?((((map__71150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71150):map__71150);
var opts = map__71150__$1;
var on_cssload = cljs.core.get.call(null,map__71150__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__71151 = p__71141;
var map__71151__$1 = ((((!((map__71151 == null)))?((((map__71151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71151.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71151):map__71151);
var files_msg = map__71151__$1;
var files = cljs.core.get.call(null,map__71151__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__71154_71158 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__71155_71159 = null;
var count__71156_71160 = (0);
var i__71157_71161 = (0);
while(true){
if((i__71157_71161 < count__71156_71160)){
var f_71162 = cljs.core._nth.call(null,chunk__71155_71159,i__71157_71161);
figwheel.client.file_reloading.reload_css_file.call(null,f_71162);

var G__71163 = seq__71154_71158;
var G__71164 = chunk__71155_71159;
var G__71165 = count__71156_71160;
var G__71166 = (i__71157_71161 + (1));
seq__71154_71158 = G__71163;
chunk__71155_71159 = G__71164;
count__71156_71160 = G__71165;
i__71157_71161 = G__71166;
continue;
} else {
var temp__6753__auto___71167 = cljs.core.seq.call(null,seq__71154_71158);
if(temp__6753__auto___71167){
var seq__71154_71168__$1 = temp__6753__auto___71167;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71154_71168__$1)){
var c__28186__auto___71169 = cljs.core.chunk_first.call(null,seq__71154_71168__$1);
var G__71170 = cljs.core.chunk_rest.call(null,seq__71154_71168__$1);
var G__71171 = c__28186__auto___71169;
var G__71172 = cljs.core.count.call(null,c__28186__auto___71169);
var G__71173 = (0);
seq__71154_71158 = G__71170;
chunk__71155_71159 = G__71171;
count__71156_71160 = G__71172;
i__71157_71161 = G__71173;
continue;
} else {
var f_71174 = cljs.core.first.call(null,seq__71154_71168__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_71174);

var G__71175 = cljs.core.next.call(null,seq__71154_71168__$1);
var G__71176 = null;
var G__71177 = (0);
var G__71178 = (0);
seq__71154_71158 = G__71175;
chunk__71155_71159 = G__71176;
count__71156_71160 = G__71177;
i__71157_71161 = G__71178;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__71150,map__71150__$1,opts,on_cssload,map__71151,map__71151__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__71150,map__71150__$1,opts,on_cssload,map__71151,map__71151__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1481754446448