// Compiled by ClojureScript 1.9.293 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy.core.recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__59649 = h;
G__59649.setUseFragment(false);

G__59649.setPathPrefix("");

G__59649.setEnabled(true);

return G__59649;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str(location.pathname),cljs.core.str(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str(path_prefix),cljs.core.str(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args59650 = [];
var len__28496__auto___59653 = arguments.length;
var i__28497__auto___59654 = (0);
while(true){
if((i__28497__auto___59654 < len__28496__auto___59653)){
args59650.push((arguments[i__28497__auto___59654]));

var G__59655 = (i__28497__auto___59654 + (1));
i__28497__auto___59654 = G__59655;
continue;
} else {
}
break;
}

var G__59652 = args59650.length;
switch (G__59652) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59650.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;


/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args59657 = [];
var len__28496__auto___59663 = arguments.length;
var i__28497__auto___59664 = (0);
while(true){
if((i__28497__auto___59664 < len__28496__auto___59663)){
args59657.push((arguments[i__28497__auto___59664]));

var G__59665 = (i__28497__auto___59664 + (1));
i__28497__auto___59664 = G__59665;
continue;
} else {
}
break;
}

var G__59659 = args59657.length;
switch (G__59659) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59657.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token);
} else {
var m__27994__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token,title);
} else {
var m__27994__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args59660 = [];
var len__28496__auto___59667 = arguments.length;
var i__28497__auto___59668 = (0);
while(true){
if((i__28497__auto___59668 < len__28496__auto___59667)){
args59660.push((arguments[i__28497__auto___59668]));

var G__59669 = (i__28497__auto___59668 + (1));
i__28497__auto___59668 = G__59669;
continue;
} else {
}
break;
}

var G__59662 = args59660.length;
switch (G__59662) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59660.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token);
} else {
var m__27994__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token,title);
} else {
var m__27994__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.get_token[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (cljs.core.some_QMARK_.call(null,cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(location.origin),cljs.core.str(".*$")].join('')),[cljs.core.str(uri)].join('')))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str(path),cljs.core.str("?"),cljs.core.str(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__28503__auto__ = [];
var len__28496__auto___59684 = arguments.length;
var i__28497__auto___59685 = (0);
while(true){
if((i__28497__auto___59685 < len__28496__auto___59684)){
args__28503__auto__.push((arguments[i__28497__auto___59685]));

var G__59686 = (i__28497__auto___59685 + (1));
i__28497__auto___59685 = G__59686;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__59674){
var map__59675 = p__59674;
var map__59675__$1 = ((((!((map__59675 == null)))?((((map__59675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59675.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59675):map__59675);
var processable_url_QMARK_ = cljs.core.get.call(null,map__59675__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__59675__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core59677 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core59677 = (function (dispatch_fn,match_fn,p__59674,map__59675,processable_url_QMARK_,identity_fn,history,event_keys,meta59678){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__59674 = p__59674;
this.map__59675 = map__59675;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta59678 = meta59678;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

pushy.core.t_pushy$core59677.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_59679,meta59678__$1){
var self__ = this;
var _59679__$1 = this;
return (new pushy.core.t_pushy$core59677(self__.dispatch_fn,self__.match_fn,self__.p__59674,self__.map__59675,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta59678__$1));
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_59679){
var self__ = this;
var _59679__$1 = this;
return self__.meta59678;
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$ = cljs.core.PROTOCOL_SENTINEL;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__6753__auto__)){
var match = temp__6753__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
));

var temp__6753__auto___59687 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__6753__auto___59687)){
var match_59688 = temp__6753__auto___59687;
self__.dispatch_fn.call(null,match_59688);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__6753__auto__)){
var el = temp__6753__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__27268__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__27268__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__27268__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__6751__auto___59689 = el.title;
if(cljs.core.truth_(temp__6751__auto___59689)){
var title_59690 = temp__6751__auto___59689;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_59690);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core59677.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__59680_59691 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__59681_59692 = null;
var count__59682_59693 = (0);
var i__59683_59694 = (0);
while(true){
if((i__59683_59694 < count__59682_59693)){
var key_59695 = cljs.core._nth.call(null,chunk__59681_59692,i__59683_59694);
goog.events.unlistenByKey(key_59695);

var G__59696 = seq__59680_59691;
var G__59697 = chunk__59681_59692;
var G__59698 = count__59682_59693;
var G__59699 = (i__59683_59694 + (1));
seq__59680_59691 = G__59696;
chunk__59681_59692 = G__59697;
count__59682_59693 = G__59698;
i__59683_59694 = G__59699;
continue;
} else {
var temp__6753__auto___59700 = cljs.core.seq.call(null,seq__59680_59691);
if(temp__6753__auto___59700){
var seq__59680_59701__$1 = temp__6753__auto___59700;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__59680_59701__$1)){
var c__28186__auto___59702 = cljs.core.chunk_first.call(null,seq__59680_59701__$1);
var G__59703 = cljs.core.chunk_rest.call(null,seq__59680_59701__$1);
var G__59704 = c__28186__auto___59702;
var G__59705 = cljs.core.count.call(null,c__28186__auto___59702);
var G__59706 = (0);
seq__59680_59691 = G__59703;
chunk__59681_59692 = G__59704;
count__59682_59693 = G__59705;
i__59683_59694 = G__59706;
continue;
} else {
var key_59707 = cljs.core.first.call(null,seq__59680_59701__$1);
goog.events.unlistenByKey(key_59707);

var G__59708 = cljs.core.next.call(null,seq__59680_59701__$1);
var G__59709 = null;
var G__59710 = (0);
var G__59711 = (0);
seq__59680_59691 = G__59708;
chunk__59681_59692 = G__59709;
count__59682_59693 = G__59710;
i__59683_59694 = G__59711;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core59677.getBasis = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__59674","p__59674",639983668,null),new cljs.core.Symbol(null,"map__59675","map__59675",274067324,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta59678","meta59678",-33691547,null)], null);
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core59677.cljs$lang$type = true;

pushy.core.t_pushy$core59677.cljs$lang$ctorStr = "pushy.core/t_pushy$core59677";

pushy.core.t_pushy$core59677.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"pushy.core/t_pushy$core59677");
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core59677 = ((function (history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core59677(dispatch_fn__$1,match_fn__$1,p__59674__$1,map__59675__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta59678){
return (new pushy.core.t_pushy$core59677(dispatch_fn__$1,match_fn__$1,p__59674__$1,map__59675__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta59678));
});})(history,event_keys,map__59675,map__59675__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core59677(dispatch_fn,match_fn,p__59674,map__59675__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq59671){
var G__59672 = cljs.core.first.call(null,seq59671);
var seq59671__$1 = cljs.core.next.call(null,seq59671);
var G__59673 = cljs.core.first.call(null,seq59671__$1);
var seq59671__$2 = cljs.core.next.call(null,seq59671__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__59672,G__59673,seq59671__$2);
});

/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args59712 = [];
var len__28496__auto___59715 = arguments.length;
var i__28497__auto___59716 = (0);
while(true){
if((i__28497__auto___59716 < len__28496__auto___59715)){
args59712.push((arguments[i__28497__auto___59716]));

var G__59717 = (i__28497__auto___59716 + (1));
i__28497__auto___59716 = G__59717;
continue;
} else {
}
break;
}

var G__59714 = args59712.length;
switch (G__59714) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59712.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;

pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args59719 = [];
var len__28496__auto___59722 = arguments.length;
var i__28497__auto___59723 = (0);
while(true){
if((i__28497__auto___59723 < len__28496__auto___59722)){
args59719.push((arguments[i__28497__auto___59723]));

var G__59724 = (i__28497__auto___59723 + (1));
i__28497__auto___59723 = G__59724;
continue;
} else {
}
break;
}

var G__59721 = args59719.length;
switch (G__59721) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59719.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1481754435805