// Compiled by ClojureScript 1.9.293 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
goog.require('clojure.string');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__65711__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__65708 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__65709 = cljs.core.seq.call(null,vec__65708);
var first__65710 = cljs.core.first.call(null,seq__65709);
var seq__65709__$1 = cljs.core.next.call(null,seq__65709);
var tag = first__65710;
var body = seq__65709__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__65711 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__65712__i = 0, G__65712__a = new Array(arguments.length -  0);
while (G__65712__i < G__65712__a.length) {G__65712__a[G__65712__i] = arguments[G__65712__i + 0]; ++G__65712__i;}
  args = new cljs.core.IndexedSeq(G__65712__a,0);
} 
return G__65711__delegate.call(this,args);};
G__65711.cljs$lang$maxFixedArity = 0;
G__65711.cljs$lang$applyTo = (function (arglist__65713){
var args = cljs.core.seq(arglist__65713);
return G__65711__delegate(args);
});
G__65711.cljs$core$IFn$_invoke$arity$variadic = G__65711__delegate;
return G__65711;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28137__auto__ = (function sablono$core$update_arglists_$_iter__65718(s__65719){
return (new cljs.core.LazySeq(null,(function (){
var s__65719__$1 = s__65719;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65719__$1);
if(temp__6753__auto__){
var s__65719__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65719__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65719__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65721 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65720 = (0);
while(true){
if((i__65720 < size__28136__auto__)){
var args = cljs.core._nth.call(null,c__28135__auto__,i__65720);
cljs.core.chunk_append.call(null,b__65721,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__65722 = (i__65720 + (1));
i__65720 = G__65722;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65721),sablono$core$update_arglists_$_iter__65718.call(null,cljs.core.chunk_rest.call(null,s__65719__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65721),null);
}
} else {
var args = cljs.core.first.call(null,s__65719__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__65718.call(null,cljs.core.rest.call(null,s__65719__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65728 = arguments.length;
var i__28497__auto___65729 = (0);
while(true){
if((i__28497__auto___65729 < len__28496__auto___65728)){
args__28503__auto__.push((arguments[i__28497__auto___65729]));

var G__65730 = (i__28497__auto___65729 + (1));
i__28497__auto___65729 = G__65730;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28137__auto__ = (function sablono$core$iter__65724(s__65725){
return (new cljs.core.LazySeq(null,(function (){
var s__65725__$1 = s__65725;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65725__$1);
if(temp__6753__auto__){
var s__65725__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65725__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65725__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65727 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65726 = (0);
while(true){
if((i__65726 < size__28136__auto__)){
var style = cljs.core._nth.call(null,c__28135__auto__,i__65726);
cljs.core.chunk_append.call(null,b__65727,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__65731 = (i__65726 + (1));
i__65726 = G__65731;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65727),sablono$core$iter__65724.call(null,cljs.core.chunk_rest.call(null,s__65725__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65727),null);
}
} else {
var style = cljs.core.first.call(null,s__65725__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__65724.call(null,cljs.core.rest.call(null,s__65725__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq65723){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65723));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to65732 = (function sablono$core$link_to65732(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65735 = arguments.length;
var i__28497__auto___65736 = (0);
while(true){
if((i__28497__auto___65736 < len__28496__auto___65735)){
args__28503__auto__.push((arguments[i__28497__auto___65736]));

var G__65737 = (i__28497__auto___65736 + (1));
i__28497__auto___65736 = G__65737;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to65732.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.link_to65732.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to65732.cljs$lang$maxFixedArity = (1);

sablono.core.link_to65732.cljs$lang$applyTo = (function (seq65733){
var G__65734 = cljs.core.first.call(null,seq65733);
var seq65733__$1 = cljs.core.next.call(null,seq65733);
return sablono.core.link_to65732.cljs$core$IFn$_invoke$arity$variadic(G__65734,seq65733__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to65732);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to65738 = (function sablono$core$mail_to65738(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65745 = arguments.length;
var i__28497__auto___65746 = (0);
while(true){
if((i__28497__auto___65746 < len__28496__auto___65745)){
args__28503__auto__.push((arguments[i__28497__auto___65746]));

var G__65747 = (i__28497__auto___65746 + (1));
i__28497__auto___65746 = G__65747;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to65738.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.mail_to65738.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__65741){
var vec__65742 = p__65741;
var content = cljs.core.nth.call(null,vec__65742,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__27280__auto__ = content;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to65738.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to65738.cljs$lang$applyTo = (function (seq65739){
var G__65740 = cljs.core.first.call(null,seq65739);
var seq65739__$1 = cljs.core.next.call(null,seq65739);
return sablono.core.mail_to65738.cljs$core$IFn$_invoke$arity$variadic(G__65740,seq65739__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to65738);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list65748 = (function sablono$core$unordered_list65748(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28137__auto__ = (function sablono$core$unordered_list65748_$_iter__65753(s__65754){
return (new cljs.core.LazySeq(null,(function (){
var s__65754__$1 = s__65754;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65754__$1);
if(temp__6753__auto__){
var s__65754__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65754__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65754__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65756 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65755 = (0);
while(true){
if((i__65755 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65755);
cljs.core.chunk_append.call(null,b__65756,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__65757 = (i__65755 + (1));
i__65755 = G__65757;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65756),sablono$core$unordered_list65748_$_iter__65753.call(null,cljs.core.chunk_rest.call(null,s__65754__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65756),null);
}
} else {
var x = cljs.core.first.call(null,s__65754__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list65748_$_iter__65753.call(null,cljs.core.rest.call(null,s__65754__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list65748);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list65758 = (function sablono$core$ordered_list65758(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28137__auto__ = (function sablono$core$ordered_list65758_$_iter__65763(s__65764){
return (new cljs.core.LazySeq(null,(function (){
var s__65764__$1 = s__65764;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65764__$1);
if(temp__6753__auto__){
var s__65764__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65764__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65764__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65766 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65765 = (0);
while(true){
if((i__65765 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65765);
cljs.core.chunk_append.call(null,b__65766,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__65767 = (i__65765 + (1));
i__65765 = G__65767;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65766),sablono$core$ordered_list65758_$_iter__65763.call(null,cljs.core.chunk_rest.call(null,s__65764__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65766),null);
}
} else {
var x = cljs.core.first.call(null,s__65764__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list65758_$_iter__65763.call(null,cljs.core.rest.call(null,s__65764__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list65758);
/**
 * Create an image element.
 */
sablono.core.image65768 = (function sablono$core$image65768(var_args){
var args65769 = [];
var len__28496__auto___65772 = arguments.length;
var i__28497__auto___65773 = (0);
while(true){
if((i__28497__auto___65773 < len__28496__auto___65772)){
args65769.push((arguments[i__28497__auto___65773]));

var G__65774 = (i__28497__auto___65773 + (1));
i__28497__auto___65773 = G__65774;
continue;
} else {
}
break;
}

var G__65771 = args65769.length;
switch (G__65771) {
case 1:
return sablono.core.image65768.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image65768.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65769.length)].join('')));

}
});

sablono.core.image65768.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image65768.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image65768.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image65768);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__65776_SHARP_,p2__65777_SHARP_){
return [cljs.core.str(p1__65776_SHARP_),cljs.core.str("["),cljs.core.str(p2__65777_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__65778_SHARP_,p2__65779_SHARP_){
return [cljs.core.str(p1__65778_SHARP_),cljs.core.str("-"),cljs.core.str(p2__65779_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field65780 = (function sablono$core$color_field65780(var_args){
var args65781 = [];
var len__28496__auto___65848 = arguments.length;
var i__28497__auto___65849 = (0);
while(true){
if((i__28497__auto___65849 < len__28496__auto___65848)){
args65781.push((arguments[i__28497__auto___65849]));

var G__65850 = (i__28497__auto___65849 + (1));
i__28497__auto___65849 = G__65850;
continue;
} else {
}
break;
}

var G__65783 = args65781.length;
switch (G__65783) {
case 1:
return sablono.core.color_field65780.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field65780.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65781.length)].join('')));

}
});

sablono.core.color_field65780.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.color_field65780.call(null,name__46586__auto__,null);
});

sablono.core.color_field65780.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.color_field65780.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field65780);

/**
 * Creates a date input field.
 */
sablono.core.date_field65784 = (function sablono$core$date_field65784(var_args){
var args65785 = [];
var len__28496__auto___65852 = arguments.length;
var i__28497__auto___65853 = (0);
while(true){
if((i__28497__auto___65853 < len__28496__auto___65852)){
args65785.push((arguments[i__28497__auto___65853]));

var G__65854 = (i__28497__auto___65853 + (1));
i__28497__auto___65853 = G__65854;
continue;
} else {
}
break;
}

var G__65787 = args65785.length;
switch (G__65787) {
case 1:
return sablono.core.date_field65784.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field65784.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65785.length)].join('')));

}
});

sablono.core.date_field65784.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.date_field65784.call(null,name__46586__auto__,null);
});

sablono.core.date_field65784.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.date_field65784.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field65784);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field65788 = (function sablono$core$datetime_field65788(var_args){
var args65789 = [];
var len__28496__auto___65856 = arguments.length;
var i__28497__auto___65857 = (0);
while(true){
if((i__28497__auto___65857 < len__28496__auto___65856)){
args65789.push((arguments[i__28497__auto___65857]));

var G__65858 = (i__28497__auto___65857 + (1));
i__28497__auto___65857 = G__65858;
continue;
} else {
}
break;
}

var G__65791 = args65789.length;
switch (G__65791) {
case 1:
return sablono.core.datetime_field65788.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field65788.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65789.length)].join('')));

}
});

sablono.core.datetime_field65788.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.datetime_field65788.call(null,name__46586__auto__,null);
});

sablono.core.datetime_field65788.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.datetime_field65788.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field65788);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field65792 = (function sablono$core$datetime_local_field65792(var_args){
var args65793 = [];
var len__28496__auto___65860 = arguments.length;
var i__28497__auto___65861 = (0);
while(true){
if((i__28497__auto___65861 < len__28496__auto___65860)){
args65793.push((arguments[i__28497__auto___65861]));

var G__65862 = (i__28497__auto___65861 + (1));
i__28497__auto___65861 = G__65862;
continue;
} else {
}
break;
}

var G__65795 = args65793.length;
switch (G__65795) {
case 1:
return sablono.core.datetime_local_field65792.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field65792.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65793.length)].join('')));

}
});

sablono.core.datetime_local_field65792.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.datetime_local_field65792.call(null,name__46586__auto__,null);
});

sablono.core.datetime_local_field65792.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.datetime_local_field65792.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field65792);

/**
 * Creates a email input field.
 */
sablono.core.email_field65796 = (function sablono$core$email_field65796(var_args){
var args65797 = [];
var len__28496__auto___65864 = arguments.length;
var i__28497__auto___65865 = (0);
while(true){
if((i__28497__auto___65865 < len__28496__auto___65864)){
args65797.push((arguments[i__28497__auto___65865]));

var G__65866 = (i__28497__auto___65865 + (1));
i__28497__auto___65865 = G__65866;
continue;
} else {
}
break;
}

var G__65799 = args65797.length;
switch (G__65799) {
case 1:
return sablono.core.email_field65796.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field65796.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65797.length)].join('')));

}
});

sablono.core.email_field65796.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.email_field65796.call(null,name__46586__auto__,null);
});

sablono.core.email_field65796.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.email_field65796.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field65796);

/**
 * Creates a file input field.
 */
sablono.core.file_field65800 = (function sablono$core$file_field65800(var_args){
var args65801 = [];
var len__28496__auto___65868 = arguments.length;
var i__28497__auto___65869 = (0);
while(true){
if((i__28497__auto___65869 < len__28496__auto___65868)){
args65801.push((arguments[i__28497__auto___65869]));

var G__65870 = (i__28497__auto___65869 + (1));
i__28497__auto___65869 = G__65870;
continue;
} else {
}
break;
}

var G__65803 = args65801.length;
switch (G__65803) {
case 1:
return sablono.core.file_field65800.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field65800.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65801.length)].join('')));

}
});

sablono.core.file_field65800.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.file_field65800.call(null,name__46586__auto__,null);
});

sablono.core.file_field65800.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.file_field65800.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field65800);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field65804 = (function sablono$core$hidden_field65804(var_args){
var args65805 = [];
var len__28496__auto___65872 = arguments.length;
var i__28497__auto___65873 = (0);
while(true){
if((i__28497__auto___65873 < len__28496__auto___65872)){
args65805.push((arguments[i__28497__auto___65873]));

var G__65874 = (i__28497__auto___65873 + (1));
i__28497__auto___65873 = G__65874;
continue;
} else {
}
break;
}

var G__65807 = args65805.length;
switch (G__65807) {
case 1:
return sablono.core.hidden_field65804.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field65804.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65805.length)].join('')));

}
});

sablono.core.hidden_field65804.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.hidden_field65804.call(null,name__46586__auto__,null);
});

sablono.core.hidden_field65804.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.hidden_field65804.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field65804);

/**
 * Creates a month input field.
 */
sablono.core.month_field65808 = (function sablono$core$month_field65808(var_args){
var args65809 = [];
var len__28496__auto___65876 = arguments.length;
var i__28497__auto___65877 = (0);
while(true){
if((i__28497__auto___65877 < len__28496__auto___65876)){
args65809.push((arguments[i__28497__auto___65877]));

var G__65878 = (i__28497__auto___65877 + (1));
i__28497__auto___65877 = G__65878;
continue;
} else {
}
break;
}

var G__65811 = args65809.length;
switch (G__65811) {
case 1:
return sablono.core.month_field65808.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field65808.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65809.length)].join('')));

}
});

sablono.core.month_field65808.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.month_field65808.call(null,name__46586__auto__,null);
});

sablono.core.month_field65808.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.month_field65808.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field65808);

/**
 * Creates a number input field.
 */
sablono.core.number_field65812 = (function sablono$core$number_field65812(var_args){
var args65813 = [];
var len__28496__auto___65880 = arguments.length;
var i__28497__auto___65881 = (0);
while(true){
if((i__28497__auto___65881 < len__28496__auto___65880)){
args65813.push((arguments[i__28497__auto___65881]));

var G__65882 = (i__28497__auto___65881 + (1));
i__28497__auto___65881 = G__65882;
continue;
} else {
}
break;
}

var G__65815 = args65813.length;
switch (G__65815) {
case 1:
return sablono.core.number_field65812.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field65812.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65813.length)].join('')));

}
});

sablono.core.number_field65812.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.number_field65812.call(null,name__46586__auto__,null);
});

sablono.core.number_field65812.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.number_field65812.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field65812);

/**
 * Creates a password input field.
 */
sablono.core.password_field65816 = (function sablono$core$password_field65816(var_args){
var args65817 = [];
var len__28496__auto___65884 = arguments.length;
var i__28497__auto___65885 = (0);
while(true){
if((i__28497__auto___65885 < len__28496__auto___65884)){
args65817.push((arguments[i__28497__auto___65885]));

var G__65886 = (i__28497__auto___65885 + (1));
i__28497__auto___65885 = G__65886;
continue;
} else {
}
break;
}

var G__65819 = args65817.length;
switch (G__65819) {
case 1:
return sablono.core.password_field65816.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field65816.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65817.length)].join('')));

}
});

sablono.core.password_field65816.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.password_field65816.call(null,name__46586__auto__,null);
});

sablono.core.password_field65816.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.password_field65816.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field65816);

/**
 * Creates a range input field.
 */
sablono.core.range_field65820 = (function sablono$core$range_field65820(var_args){
var args65821 = [];
var len__28496__auto___65888 = arguments.length;
var i__28497__auto___65889 = (0);
while(true){
if((i__28497__auto___65889 < len__28496__auto___65888)){
args65821.push((arguments[i__28497__auto___65889]));

var G__65890 = (i__28497__auto___65889 + (1));
i__28497__auto___65889 = G__65890;
continue;
} else {
}
break;
}

var G__65823 = args65821.length;
switch (G__65823) {
case 1:
return sablono.core.range_field65820.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field65820.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65821.length)].join('')));

}
});

sablono.core.range_field65820.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.range_field65820.call(null,name__46586__auto__,null);
});

sablono.core.range_field65820.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.range_field65820.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field65820);

/**
 * Creates a search input field.
 */
sablono.core.search_field65824 = (function sablono$core$search_field65824(var_args){
var args65825 = [];
var len__28496__auto___65892 = arguments.length;
var i__28497__auto___65893 = (0);
while(true){
if((i__28497__auto___65893 < len__28496__auto___65892)){
args65825.push((arguments[i__28497__auto___65893]));

var G__65894 = (i__28497__auto___65893 + (1));
i__28497__auto___65893 = G__65894;
continue;
} else {
}
break;
}

var G__65827 = args65825.length;
switch (G__65827) {
case 1:
return sablono.core.search_field65824.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field65824.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65825.length)].join('')));

}
});

sablono.core.search_field65824.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.search_field65824.call(null,name__46586__auto__,null);
});

sablono.core.search_field65824.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.search_field65824.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field65824);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field65828 = (function sablono$core$tel_field65828(var_args){
var args65829 = [];
var len__28496__auto___65896 = arguments.length;
var i__28497__auto___65897 = (0);
while(true){
if((i__28497__auto___65897 < len__28496__auto___65896)){
args65829.push((arguments[i__28497__auto___65897]));

var G__65898 = (i__28497__auto___65897 + (1));
i__28497__auto___65897 = G__65898;
continue;
} else {
}
break;
}

var G__65831 = args65829.length;
switch (G__65831) {
case 1:
return sablono.core.tel_field65828.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field65828.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65829.length)].join('')));

}
});

sablono.core.tel_field65828.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.tel_field65828.call(null,name__46586__auto__,null);
});

sablono.core.tel_field65828.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.tel_field65828.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field65828);

/**
 * Creates a text input field.
 */
sablono.core.text_field65832 = (function sablono$core$text_field65832(var_args){
var args65833 = [];
var len__28496__auto___65900 = arguments.length;
var i__28497__auto___65901 = (0);
while(true){
if((i__28497__auto___65901 < len__28496__auto___65900)){
args65833.push((arguments[i__28497__auto___65901]));

var G__65902 = (i__28497__auto___65901 + (1));
i__28497__auto___65901 = G__65902;
continue;
} else {
}
break;
}

var G__65835 = args65833.length;
switch (G__65835) {
case 1:
return sablono.core.text_field65832.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field65832.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65833.length)].join('')));

}
});

sablono.core.text_field65832.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.text_field65832.call(null,name__46586__auto__,null);
});

sablono.core.text_field65832.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.text_field65832.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field65832);

/**
 * Creates a time input field.
 */
sablono.core.time_field65836 = (function sablono$core$time_field65836(var_args){
var args65837 = [];
var len__28496__auto___65904 = arguments.length;
var i__28497__auto___65905 = (0);
while(true){
if((i__28497__auto___65905 < len__28496__auto___65904)){
args65837.push((arguments[i__28497__auto___65905]));

var G__65906 = (i__28497__auto___65905 + (1));
i__28497__auto___65905 = G__65906;
continue;
} else {
}
break;
}

var G__65839 = args65837.length;
switch (G__65839) {
case 1:
return sablono.core.time_field65836.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field65836.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65837.length)].join('')));

}
});

sablono.core.time_field65836.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.time_field65836.call(null,name__46586__auto__,null);
});

sablono.core.time_field65836.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.time_field65836.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field65836);

/**
 * Creates a url input field.
 */
sablono.core.url_field65840 = (function sablono$core$url_field65840(var_args){
var args65841 = [];
var len__28496__auto___65908 = arguments.length;
var i__28497__auto___65909 = (0);
while(true){
if((i__28497__auto___65909 < len__28496__auto___65908)){
args65841.push((arguments[i__28497__auto___65909]));

var G__65910 = (i__28497__auto___65909 + (1));
i__28497__auto___65909 = G__65910;
continue;
} else {
}
break;
}

var G__65843 = args65841.length;
switch (G__65843) {
case 1:
return sablono.core.url_field65840.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field65840.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65841.length)].join('')));

}
});

sablono.core.url_field65840.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.url_field65840.call(null,name__46586__auto__,null);
});

sablono.core.url_field65840.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.url_field65840.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field65840);

/**
 * Creates a week input field.
 */
sablono.core.week_field65844 = (function sablono$core$week_field65844(var_args){
var args65845 = [];
var len__28496__auto___65912 = arguments.length;
var i__28497__auto___65913 = (0);
while(true){
if((i__28497__auto___65913 < len__28496__auto___65912)){
args65845.push((arguments[i__28497__auto___65913]));

var G__65914 = (i__28497__auto___65913 + (1));
i__28497__auto___65913 = G__65914;
continue;
} else {
}
break;
}

var G__65847 = args65845.length;
switch (G__65847) {
case 1:
return sablono.core.week_field65844.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field65844.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65845.length)].join('')));

}
});

sablono.core.week_field65844.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.week_field65844.call(null,name__46586__auto__,null);
});

sablono.core.week_field65844.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.week_field65844.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field65844);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box65916 = (function sablono$core$check_box65916(var_args){
var args65917 = [];
var len__28496__auto___65920 = arguments.length;
var i__28497__auto___65921 = (0);
while(true){
if((i__28497__auto___65921 < len__28496__auto___65920)){
args65917.push((arguments[i__28497__auto___65921]));

var G__65922 = (i__28497__auto___65921 + (1));
i__28497__auto___65921 = G__65922;
continue;
} else {
}
break;
}

var G__65919 = args65917.length;
switch (G__65919) {
case 1:
return sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65917.length)].join('')));

}
});

sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box65916.call(null,name,null);
});

sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box65916.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box65916.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box65916.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box65916);
/**
 * Creates a radio button.
 */
sablono.core.radio_button65924 = (function sablono$core$radio_button65924(var_args){
var args65925 = [];
var len__28496__auto___65928 = arguments.length;
var i__28497__auto___65929 = (0);
while(true){
if((i__28497__auto___65929 < len__28496__auto___65928)){
args65925.push((arguments[i__28497__auto___65929]));

var G__65930 = (i__28497__auto___65929 + (1));
i__28497__auto___65929 = G__65930;
continue;
} else {
}
break;
}

var G__65927 = args65925.length;
switch (G__65927) {
case 1:
return sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65925.length)].join('')));

}
});

sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button65924.call(null,group,null);
});

sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button65924.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button65924.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button65924.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button65924);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options65932 = (function sablono$core$select_options65932(coll){
var iter__28137__auto__ = (function sablono$core$select_options65932_$_iter__65949(s__65950){
return (new cljs.core.LazySeq(null,(function (){
var s__65950__$1 = s__65950;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65950__$1);
if(temp__6753__auto__){
var s__65950__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65950__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65950__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65952 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65951 = (0);
while(true){
if((i__65951 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65951);
cljs.core.chunk_append.call(null,b__65952,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__65959 = x;
var text = cljs.core.nth.call(null,vec__65959,(0),null);
var val = cljs.core.nth.call(null,vec__65959,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__65959,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options65932.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__65965 = (i__65951 + (1));
i__65951 = G__65965;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65952),sablono$core$select_options65932_$_iter__65949.call(null,cljs.core.chunk_rest.call(null,s__65950__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65952),null);
}
} else {
var x = cljs.core.first.call(null,s__65950__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__65962 = x;
var text = cljs.core.nth.call(null,vec__65962,(0),null);
var val = cljs.core.nth.call(null,vec__65962,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__65962,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options65932.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options65932_$_iter__65949.call(null,cljs.core.rest.call(null,s__65950__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options65932);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down65966 = (function sablono$core$drop_down65966(var_args){
var args65967 = [];
var len__28496__auto___65970 = arguments.length;
var i__28497__auto___65971 = (0);
while(true){
if((i__28497__auto___65971 < len__28496__auto___65970)){
args65967.push((arguments[i__28497__auto___65971]));

var G__65972 = (i__28497__auto___65971 + (1));
i__28497__auto___65971 = G__65972;
continue;
} else {
}
break;
}

var G__65969 = args65967.length;
switch (G__65969) {
case 2:
return sablono.core.drop_down65966.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down65966.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65967.length)].join('')));

}
});

sablono.core.drop_down65966.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down65966.call(null,name,options,null);
});

sablono.core.drop_down65966.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down65966.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down65966);
/**
 * Creates a text area element.
 */
sablono.core.text_area65974 = (function sablono$core$text_area65974(var_args){
var args65975 = [];
var len__28496__auto___65978 = arguments.length;
var i__28497__auto___65979 = (0);
while(true){
if((i__28497__auto___65979 < len__28496__auto___65978)){
args65975.push((arguments[i__28497__auto___65979]));

var G__65980 = (i__28497__auto___65979 + (1));
i__28497__auto___65979 = G__65980;
continue;
} else {
}
break;
}

var G__65977 = args65975.length;
switch (G__65977) {
case 1:
return sablono.core.text_area65974.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area65974.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65975.length)].join('')));

}
});

sablono.core.text_area65974.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area65974.call(null,name,null);
});

sablono.core.text_area65974.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area65974.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area65974);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label65982 = (function sablono$core$label65982(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label65982);
/**
 * Creates a submit button.
 */
sablono.core.submit_button65983 = (function sablono$core$submit_button65983(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button65983);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button65984 = (function sablono$core$reset_button65984(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button65984);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to65985 = (function sablono$core$form_to65985(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65992 = arguments.length;
var i__28497__auto___65993 = (0);
while(true){
if((i__28497__auto___65993 < len__28496__auto___65992)){
args__28503__auto__.push((arguments[i__28497__auto___65993]));

var G__65994 = (i__28497__auto___65993 + (1));
i__28497__auto___65993 = G__65994;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to65985.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.form_to65985.cljs$core$IFn$_invoke$arity$variadic = (function (p__65988,body){
var vec__65989 = p__65988;
var method = cljs.core.nth.call(null,vec__65989,(0),null);
var action = cljs.core.nth.call(null,vec__65989,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to65985.cljs$lang$maxFixedArity = (1);

sablono.core.form_to65985.cljs$lang$applyTo = (function (seq65986){
var G__65987 = cljs.core.first.call(null,seq65986);
var seq65986__$1 = cljs.core.next.call(null,seq65986);
return sablono.core.form_to65985.cljs$core$IFn$_invoke$arity$variadic(G__65987,seq65986__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to65985);

//# sourceMappingURL=core.js.map?rel=1481754440618