// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('untangled.i18n.core');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.data_fetch');
goog.require('om.next');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__77733,query){
var map__77736 = p__77733;
var map__77736__$1 = ((((!((map__77736 == null)))?((((map__77736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77736.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77736):map__77736);
var reconciler = cljs.core.get.call(null,map__77736__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__77736,map__77736__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__77736,map__77736__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__30970__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30970__auto__){
return (function (){
var f__30971__auto__ = (function (){var switch__30903__auto__ = ((function (c__30970__auto__){
return (function (state_77753){
var state_val_77754 = (state_77753[(1)]);
if((state_val_77754 === (1))){
var state_77753__$1 = state_77753;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77753__$1,(2),q,v);
} else {
if((state_val_77754 === (2))){
var inst_77751 = (state_77753[(2)]);
var state_77753__$1 = state_77753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77753__$1,inst_77751);
} else {
return null;
}
}
});})(c__30970__auto__))
;
return ((function (switch__30903__auto__,c__30970__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__30904__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__30904__auto____0 = (function (){
var statearr_77758 = [null,null,null,null,null,null,null];
(statearr_77758[(0)] = untangled$client$impl$application$enqueue_$_state_machine__30904__auto__);

(statearr_77758[(1)] = (1));

return statearr_77758;
});
var untangled$client$impl$application$enqueue_$_state_machine__30904__auto____1 = (function (state_77753){
while(true){
var ret_value__30905__auto__ = (function (){try{while(true){
var result__30906__auto__ = switch__30903__auto__.call(null,state_77753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30906__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30906__auto__;
}
break;
}
}catch (e77759){if((e77759 instanceof Object)){
var ex__30907__auto__ = e77759;
var statearr_77760_77762 = state_77753;
(statearr_77760_77762[(5)] = ex__30907__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77753);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77763 = state_77753;
state_77753 = G__77763;
continue;
} else {
return ret_value__30905__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__30904__auto__ = function(state_77753){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__30904__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__30904__auto____1.call(this,state_77753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__30904__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__30904__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__30904__auto__;
})()
;})(switch__30903__auto__,c__30970__auto__))
})();
var state__30972__auto__ = (function (){var statearr_77761 = f__30971__auto__.call(null);
(statearr_77761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30970__auto__);

return statearr_77761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30972__auto__);
});})(c__30970__auto__))
);

return c__30970__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__77765,remote_tx_map,cb){
var map__77768 = p__77765;
var map__77768__$1 = ((((!((map__77768 == null)))?((((map__77768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77768.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77768):map__77768);
var app = map__77768__$1;
var queue = cljs.core.get.call(null,map__77768__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__77768,map__77768__$1,app,queue){
return (function (p1__77764_SHARP_){
return fallback.call(null,p1__77764_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__77768,map__77768__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__77772){
var map__77783 = p__77772;
var map__77783__$1 = ((((!((map__77783 == null)))?((((map__77783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77783.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77783):map__77783);
var queue = cljs.core.get.call(null,map__77783__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__77783__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__77783__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__77785_77793 = cljs.core.seq.call(null,parallel_payload);
var chunk__77786_77794 = null;
var count__77787_77795 = (0);
var i__77788_77796 = (0);
while(true){
if((i__77788_77796 < count__77787_77795)){
var map__77789_77797 = cljs.core._nth.call(null,chunk__77786_77794,i__77788_77796);
var map__77789_77798__$1 = ((((!((map__77789_77797 == null)))?((((map__77789_77797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77789_77797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77789_77797):map__77789_77797);
var query_77799 = cljs.core.get.call(null,map__77789_77798__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_77800 = cljs.core.get.call(null,map__77789_77798__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_77801 = cljs.core.get.call(null,map__77789_77798__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_77802 = cljs.core.get.call(null,map__77789_77798__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__77803 = ((function (seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,map__77789_77797,map__77789_77798__$1,query_77799,on_load_77800,on_error_77801,callback_args_77802,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking){
return (function (p1__77770_SHARP_){
return on_load_77800.call(null,p1__77770_SHARP_,callback_args_77802);
});})(seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,map__77789_77797,map__77789_77798__$1,query_77799,on_load_77800,on_error_77801,callback_args_77802,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__77804 = ((function (seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,on_load_SINGLEQUOTE__77803,map__77789_77797,map__77789_77798__$1,query_77799,on_load_77800,on_error_77801,callback_args_77802,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking){
return (function (p1__77771_SHARP_){
return on_error_77801.call(null,p1__77771_SHARP_,callback_args_77802);
});})(seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,on_load_SINGLEQUOTE__77803,map__77789_77797,map__77789_77798__$1,query_77799,on_load_77800,on_error_77801,callback_args_77802,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_77799,on_load_SINGLEQUOTE__77803,on_error_SINGLEQUOTE__77804);

var G__77805 = seq__77785_77793;
var G__77806 = chunk__77786_77794;
var G__77807 = count__77787_77795;
var G__77808 = (i__77788_77796 + (1));
seq__77785_77793 = G__77805;
chunk__77786_77794 = G__77806;
count__77787_77795 = G__77807;
i__77788_77796 = G__77808;
continue;
} else {
var temp__6753__auto___77809 = cljs.core.seq.call(null,seq__77785_77793);
if(temp__6753__auto___77809){
var seq__77785_77810__$1 = temp__6753__auto___77809;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__77785_77810__$1)){
var c__28186__auto___77811 = cljs.core.chunk_first.call(null,seq__77785_77810__$1);
var G__77812 = cljs.core.chunk_rest.call(null,seq__77785_77810__$1);
var G__77813 = c__28186__auto___77811;
var G__77814 = cljs.core.count.call(null,c__28186__auto___77811);
var G__77815 = (0);
seq__77785_77793 = G__77812;
chunk__77786_77794 = G__77813;
count__77787_77795 = G__77814;
i__77788_77796 = G__77815;
continue;
} else {
var map__77791_77816 = cljs.core.first.call(null,seq__77785_77810__$1);
var map__77791_77817__$1 = ((((!((map__77791_77816 == null)))?((((map__77791_77816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77791_77816.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77791_77816):map__77791_77816);
var query_77818 = cljs.core.get.call(null,map__77791_77817__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_77819 = cljs.core.get.call(null,map__77791_77817__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_77820 = cljs.core.get.call(null,map__77791_77817__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_77821 = cljs.core.get.call(null,map__77791_77817__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__77822 = ((function (seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,map__77791_77816,map__77791_77817__$1,query_77818,on_load_77819,on_error_77820,callback_args_77821,seq__77785_77810__$1,temp__6753__auto___77809,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking){
return (function (p1__77770_SHARP_){
return on_load_77819.call(null,p1__77770_SHARP_,callback_args_77821);
});})(seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,map__77791_77816,map__77791_77817__$1,query_77818,on_load_77819,on_error_77820,callback_args_77821,seq__77785_77810__$1,temp__6753__auto___77809,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__77823 = ((function (seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,on_load_SINGLEQUOTE__77822,map__77791_77816,map__77791_77817__$1,query_77818,on_load_77819,on_error_77820,callback_args_77821,seq__77785_77810__$1,temp__6753__auto___77809,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking){
return (function (p1__77771_SHARP_){
return on_error_77820.call(null,p1__77771_SHARP_,callback_args_77821);
});})(seq__77785_77793,chunk__77786_77794,count__77787_77795,i__77788_77796,on_load_SINGLEQUOTE__77822,map__77791_77816,map__77791_77817__$1,query_77818,on_load_77819,on_error_77820,callback_args_77821,seq__77785_77810__$1,temp__6753__auto___77809,parallel_payload,map__77783,map__77783__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_77818,on_load_SINGLEQUOTE__77822,on_error_SINGLEQUOTE__77823);

var G__77824 = cljs.core.next.call(null,seq__77785_77810__$1);
var G__77825 = null;
var G__77826 = (0);
var G__77827 = (0);
seq__77785_77793 = G__77824;
chunk__77786_77794 = G__77825;
count__77787_77795 = G__77826;
i__77788_77796 = G__77827;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__77828 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__77828;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__77829){
var map__77948 = p__77829;
var map__77948__$1 = ((((!((map__77948 == null)))?((((map__77948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77948):map__77948);
var networking = cljs.core.get.call(null,map__77948__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__77948__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__77948__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__77948,map__77948__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__77948,map__77948__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__30970__auto___78066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel){
return (function (){
var f__30971__auto__ = (function (){var switch__30903__auto__ = ((function (c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel){
return (function (state_77989){
var state_val_77990 = (state_77989[(1)]);
if((state_val_77990 === (1))){
var state_77989__$1 = state_77989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77989__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_77990 === (2))){
var inst_77987 = (state_77989[(2)]);
var state_77989__$1 = state_77989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77989__$1,inst_77987);
} else {
return null;
}
}
});})(c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel))
;
return ((function (switch__30903__auto__,c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____0 = (function (){
var statearr_77994 = [null,null,null,null,null,null,null];
(statearr_77994[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__);

(statearr_77994[(1)] = (1));

return statearr_77994;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____1 = (function (state_77989){
while(true){
var ret_value__30905__auto__ = (function (){try{while(true){
var result__30906__auto__ = switch__30903__auto__.call(null,state_77989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30906__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30906__auto__;
}
break;
}
}catch (e77995){if((e77995 instanceof Object)){
var ex__30907__auto__ = e77995;
var statearr_77996_78067 = state_77989;
(statearr_77996_78067[(5)] = ex__30907__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77995;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78068 = state_77989;
state_77989 = G__78068;
continue;
} else {
return ret_value__30905__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__ = function(state_77989){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____1.call(this,state_77989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__30904__auto__;
})()
;})(switch__30903__auto__,c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel))
})();
var state__30972__auto__ = (function (){var statearr_77997 = f__30971__auto__.call(null);
(statearr_77997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30970__auto___78066);

return statearr_77997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30972__auto__);
});})(c__30970__auto___78066,map__77948,map__77948__$1,networking,queue,response_channel))
);

}});
;})(map__77948,map__77948__$1,networking,queue,response_channel))
});})(map__77948,map__77948__$1,networking,queue,response_channel))
;
var c__30970__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel){
return (function (){
var f__30971__auto__ = (function (){var switch__30903__auto__ = ((function (c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel){
return (function (state_78039){
var state_val_78040 = (state_78039[(1)]);
if((state_val_78040 === (7))){
var inst_78018 = (state_78039[(2)]);
var state_78039__$1 = state_78039;
if(cljs.core.truth_(inst_78018)){
var statearr_78041_78069 = state_78039__$1;
(statearr_78041_78069[(1)] = (11));

} else {
var statearr_78042_78070 = state_78039__$1;
(statearr_78042_78070[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (1))){
var state_78039__$1 = state_78039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78039__$1,(2),queue);
} else {
if((state_val_78040 === (4))){
var inst_78037 = (state_78039[(2)]);
var state_78039__$1 = state_78039;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78039__$1,inst_78037);
} else {
if((state_val_78040 === (15))){
var inst_78034 = (state_78039[(2)]);
var inst_78000 = inst_78034;
var state_78039__$1 = (function (){var statearr_78043 = state_78039;
(statearr_78043[(7)] = inst_78000);

return statearr_78043;
})();
var statearr_78044_78071 = state_78039__$1;
(statearr_78044_78071[(2)] = null);

(statearr_78044_78071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (13))){
var inst_78023 = (state_78039[(2)]);
var inst_78024 = cljs.core.get.call(null,inst_78023,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_78025 = cljs.core.get.call(null,inst_78023,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_78026 = cljs.core.get.call(null,inst_78023,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_78027 = cljs.core.get.call(null,inst_78023,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_78028 = make_process_response.call(null,inst_78025,inst_78027);
var inst_78029 = make_process_response.call(null,inst_78026,inst_78027);
var inst_78030 = untangled.client.impl.application.real_send.call(null,networking,inst_78024,inst_78028,inst_78029);
var state_78039__$1 = (function (){var statearr_78045 = state_78039;
(statearr_78045[(8)] = inst_78030);

return statearr_78045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78039__$1,(14),response_channel);
} else {
if((state_val_78040 === (6))){
var state_78039__$1 = state_78039;
var statearr_78046_78072 = state_78039__$1;
(statearr_78046_78072[(2)] = false);

(statearr_78046_78072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (3))){
var inst_78000 = (state_78039[(7)]);
var inst_78004 = (inst_78000 == null);
var inst_78005 = cljs.core.not.call(null,inst_78004);
var state_78039__$1 = state_78039;
if(inst_78005){
var statearr_78047_78073 = state_78039__$1;
(statearr_78047_78073[(1)] = (5));

} else {
var statearr_78048_78074 = state_78039__$1;
(statearr_78048_78074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (12))){
var inst_78000 = (state_78039[(7)]);
var state_78039__$1 = state_78039;
var statearr_78049_78075 = state_78039__$1;
(statearr_78049_78075[(2)] = inst_78000);

(statearr_78049_78075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (2))){
var inst_77999 = (state_78039[(2)]);
var inst_78000 = inst_77999;
var state_78039__$1 = (function (){var statearr_78050 = state_78039;
(statearr_78050[(7)] = inst_78000);

return statearr_78050;
})();
var statearr_78051_78076 = state_78039__$1;
(statearr_78051_78076[(2)] = null);

(statearr_78051_78076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (11))){
var inst_78000 = (state_78039[(7)]);
var inst_78020 = cljs.core.apply.call(null,cljs.core.hash_map,inst_78000);
var state_78039__$1 = state_78039;
var statearr_78052_78077 = state_78039__$1;
(statearr_78052_78077[(2)] = inst_78020);

(statearr_78052_78077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (9))){
var state_78039__$1 = state_78039;
var statearr_78053_78078 = state_78039__$1;
(statearr_78053_78078[(2)] = false);

(statearr_78053_78078[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (5))){
var inst_78000 = (state_78039[(7)]);
var inst_78007 = inst_78000.cljs$lang$protocol_mask$partition0$;
var inst_78008 = (inst_78007 & (64));
var inst_78009 = inst_78000.cljs$core$ISeq$;
var inst_78010 = (cljs.core.PROTOCOL_SENTINEL === inst_78009);
var inst_78011 = (inst_78008) || (inst_78010);
var state_78039__$1 = state_78039;
if(cljs.core.truth_(inst_78011)){
var statearr_78054_78079 = state_78039__$1;
(statearr_78054_78079[(1)] = (8));

} else {
var statearr_78055_78080 = state_78039__$1;
(statearr_78055_78080[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (14))){
var inst_78032 = (state_78039[(2)]);
var state_78039__$1 = (function (){var statearr_78056 = state_78039;
(statearr_78056[(9)] = inst_78032);

return statearr_78056;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78039__$1,(15),queue);
} else {
if((state_val_78040 === (10))){
var inst_78015 = (state_78039[(2)]);
var state_78039__$1 = state_78039;
var statearr_78057_78081 = state_78039__$1;
(statearr_78057_78081[(2)] = inst_78015);

(statearr_78057_78081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78040 === (8))){
var state_78039__$1 = state_78039;
var statearr_78058_78082 = state_78039__$1;
(statearr_78058_78082[(2)] = true);

(statearr_78058_78082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel))
;
return ((function (switch__30903__auto__,c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____0 = (function (){
var statearr_78062 = [null,null,null,null,null,null,null,null,null,null];
(statearr_78062[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__);

(statearr_78062[(1)] = (1));

return statearr_78062;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____1 = (function (state_78039){
while(true){
var ret_value__30905__auto__ = (function (){try{while(true){
var result__30906__auto__ = switch__30903__auto__.call(null,state_78039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30906__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30906__auto__;
}
break;
}
}catch (e78063){if((e78063 instanceof Object)){
var ex__30907__auto__ = e78063;
var statearr_78064_78083 = state_78039;
(statearr_78064_78083[(5)] = ex__30907__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78063;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78084 = state_78039;
state_78039 = G__78084;
continue;
} else {
return ret_value__30905__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__ = function(state_78039){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____1.call(this,state_78039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__30904__auto__;
})()
;})(switch__30903__auto__,c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel))
})();
var state__30972__auto__ = (function (){var statearr_78065 = f__30971__auto__.call(null);
(statearr_78065[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30970__auto__);

return statearr_78065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30972__auto__);
});})(c__30970__auto__,map__77948,map__77948__$1,networking,queue,response_channel))
);

return c__30970__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__78089){
var vec__78090 = p__78089;
var k = cljs.core.nth.call(null,vec__78090,(0),null);
var v = cljs.core.nth.call(null,vec__78090,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__78097){
var vec__78098 = p__78097;
var k = cljs.core.nth.call(null,vec__78098,(0),null);
var v = cljs.core.nth.call(null,vec__78098,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__78105){
var vec__78106 = p__78105;
var k = cljs.core.nth.call(null,vec__78106,(0),null);
var v = cljs.core.nth.call(null,vec__78106,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__78117){
var vec__78118 = p__78117;
var k = cljs.core.nth.call(null,vec__78118,(0),null);
var _ = cljs.core.nth.call(null,vec__78118,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__78121){
var vec__78122 = p__78121;
var k = cljs.core.nth.call(null,vec__78122,(0),null);
var v = cljs.core.nth.call(null,vec__78122,(1),null);
if(cljs.core.truth_((function (){var and__27268__auto__ = mutation_merge;
if(cljs.core.truth_(and__27268__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__27268__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__78125,initial_state,parser,p__78126){
var map__78131 = p__78125;
var map__78131__$1 = ((((!((map__78131 == null)))?((((map__78131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__78131.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__78131):map__78131);
var app = map__78131__$1;
var queue = cljs.core.get.call(null,map__78131__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__78131__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__78132 = p__78126;
var map__78132__$1 = ((((!((map__78132 == null)))?((((map__78132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__78132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__78132):map__78132);
var pathopt = cljs.core.get.call(null,map__78132__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__78132__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__78132__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = ((cljs.core._EQ_.call(null,cljs.core.Atom,cljs.core.type.call(null,initial_state)))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__78131,map__78131__$1,app,queue,mutation_merge,map__78132,map__78132__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core._EQ_.call(null,cljs.core.Atom,cljs.core.type.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__78135_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__78135_SHARP_)){
return cljs.core.partial.call(null,p1__78135_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1481822319333