// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.protocol_support');
goog.require('cljs.core');
goog.require('om.dom');
goog.require('untangled_spec.core');
goog.require('cljs.test');
goog.require('untangled.client.core');
goog.require('clojure.walk');
goog.require('om.next');
/**
 * Is the given keyword a seed data tempid keyword (namespaced to `tempid`)?
 */
untangled.client.impl.protocol_support.tempid_QMARK_ = (function untangled$client$impl$protocol_support$tempid_QMARK_(kw){
return ((kw instanceof cljs.core.Keyword)) && (cljs.core._EQ_.call(null,"om.tempid",cljs.core.namespace.call(null,kw)));
});
/**
 * Rewrite tempid keywords in the given state using the tid->rid map. Leaves the keyword alone if the map
 * does not contain an entry for it.
 */
untangled.client.impl.protocol_support.rewrite_tempids = (function untangled$client$impl$protocol_support$rewrite_tempids(var_args){
var args__28503__auto__ = [];
var len__28496__auto___142006 = arguments.length;
var i__28497__auto___142007 = (0);
while(true){
if((i__28497__auto___142007 < len__28496__auto___142006)){
args__28503__auto__.push((arguments[i__28497__auto___142007]));

var G__142008 = (i__28497__auto___142007 + (1));
i__28497__auto___142007 = G__142008;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic = (function (state,tid__GT_rid,p__142002){
var vec__142003 = p__142002;
var pred = cljs.core.nth.call(null,vec__142003,(0),null);
return clojure.walk.prewalk.call(null,((function (vec__142003,pred){
return (function (p1__141998_SHARP_){
if(cljs.core.truth_((function (){var or__27280__auto__ = pred;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.client.impl.protocol_support.tempid_QMARK_;
}
})().call(null,p1__141998_SHARP_))){
return cljs.core.get.call(null,tid__GT_rid,p1__141998_SHARP_,p1__141998_SHARP_);
} else {
return p1__141998_SHARP_;
}
});})(vec__142003,pred))
,state);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$maxFixedArity = (2);

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$applyTo = (function (seq141999){
var G__142000 = cljs.core.first.call(null,seq141999);
var seq141999__$1 = cljs.core.next.call(null,seq141999);
var G__142001 = cljs.core.first.call(null,seq141999__$1);
var seq141999__$2 = cljs.core.next.call(null,seq141999__$1);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic(G__142000,G__142001,seq141999__$2);
});

/**
 * Checks that `new-state` includes the `delta`, where `delta` is a map keyed by data path (as in get-in). The
 * values of `delta` are literal values to verify at that path (nil means the path should be missing).
 */
untangled.client.impl.protocol_support.check_delta = (function untangled$client$impl$protocol_support$check_delta(new_state,delta){
if(cljs.core.empty_QMARK_.call(null,delta)){
throw cljs.core.ex_info.call(null,"Cannot have empty :merge-delta",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-state","new-state",-490349212),new_state], null));
} else {
var seq__142023 = cljs.core.seq.call(null,delta);
var chunk__142024 = null;
var count__142025 = (0);
var i__142026 = (0);
while(true){
if((i__142026 < count__142025)){
var vec__142027 = cljs.core._nth.call(null,chunk__142024,i__142026);
var key_path = cljs.core.nth.call(null,vec__142027,(0),null);
var value = cljs.core.nth.call(null,vec__142027,(1),null);
var behavior_string_142037 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_142038__$1 = (function (){var or__27280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_142037);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_142037], null));

if((value_142038__$1 instanceof RegExp)){
try{var values__37526__auto___142039 = (function (){var x__28209__auto__ = value_142038__$1;
return cljs.core._conj.call(null,(function (){var x__28209__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto____$1);
})(),x__28209__auto__);
})();
var result__37527__auto___142040 = cljs.core.apply.call(null,cljs.core.re_matches,values__37526__auto___142039);
if(cljs.core.truth_(result__37527__auto___142040)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__37526__auto___142039),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28209__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__37526__auto___142039);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e142030){var t__37564__auto___142041 = e142030;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142041,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__43682__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__43683__auto__ = value_142038__$1;
var result__43684__auto__ = cljs.core._EQ_.call(null,exp__43683__auto__,act__43682__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__43684__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__43683__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__43682__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e142031){var t__37564__auto___142042 = e142031;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142042,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_142037], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__142043 = seq__142023;
var G__142044 = chunk__142024;
var G__142045 = count__142025;
var G__142046 = (i__142026 + (1));
seq__142023 = G__142043;
chunk__142024 = G__142044;
count__142025 = G__142045;
i__142026 = G__142046;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__142023);
if(temp__6753__auto__){
var seq__142023__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__142023__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__142023__$1);
var G__142047 = cljs.core.chunk_rest.call(null,seq__142023__$1);
var G__142048 = c__28186__auto__;
var G__142049 = cljs.core.count.call(null,c__28186__auto__);
var G__142050 = (0);
seq__142023 = G__142047;
chunk__142024 = G__142048;
count__142025 = G__142049;
i__142026 = G__142050;
continue;
} else {
var vec__142032 = cljs.core.first.call(null,seq__142023__$1);
var key_path = cljs.core.nth.call(null,vec__142032,(0),null);
var value = cljs.core.nth.call(null,vec__142032,(1),null);
var behavior_string_142051 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_142052__$1 = (function (){var or__27280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_142051);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_142051], null));

if((value_142052__$1 instanceof RegExp)){
try{var values__37526__auto___142053 = (function (){var x__28209__auto__ = value_142052__$1;
return cljs.core._conj.call(null,(function (){var x__28209__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto____$1);
})(),x__28209__auto__);
})();
var result__37527__auto___142054 = cljs.core.apply.call(null,cljs.core.re_matches,values__37526__auto___142053);
if(cljs.core.truth_(result__37527__auto___142054)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__37526__auto___142053),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28209__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__37526__auto___142053);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e142035){var t__37564__auto___142055 = e142035;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142055,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__43682__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__43683__auto__ = value_142052__$1;
var result__43684__auto__ = cljs.core._EQ_.call(null,exp__43683__auto__,act__43682__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__43684__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__43683__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__43682__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e142036){var t__37564__auto___142056 = e142036;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142056,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_142051], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__142057 = cljs.core.next.call(null,seq__142023__$1);
var G__142058 = null;
var G__142059 = (0);
var G__142060 = (0);
seq__142023 = G__142057;
chunk__142024 = G__142058;
count__142025 = G__142059;
i__142026 = G__142060;
continue;
}
} else {
return null;
}
}
break;
}
}
});
untangled.client.impl.protocol_support.with_behavior = (function untangled$client$impl$protocol_support$with_behavior(behavior_string,value){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cps","value","cps/value",307453219),value,new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882),behavior_string], null);
});
untangled.client.impl.protocol_support.allocate_tempids = (function untangled$client$impl$protocol_support$allocate_tempids(tx){
var allocated_ids = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
clojure.walk.prewalk.call(null,((function (allocated_ids){
return (function (v){
if(cljs.core.truth_(untangled.client.impl.protocol_support.tempid_QMARK_.call(null,v))){
cljs.core.swap_BANG_.call(null,allocated_ids,cljs.core.conj,v);
} else {
}

return v;
});})(allocated_ids))
,tx);

return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (allocated_ids){
return (function (p1__142061_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__142061_SHARP_,om.next.tempid.call(null)],null));
});})(allocated_ids))
,cljs.core.deref.call(null,allocated_ids)));
});
/**
 * @constructor
 */
untangled.client.impl.protocol_support.Root = (function untangled$client$impl$protocol_support$Root(){
var this__41646__auto__ = this;
React.Component.apply(this__41646__auto__,arguments);

if(!((this__41646__auto__.initLocalState == null))){
this__41646__auto__.state = this__41646__auto__.initLocalState();
} else {
this__41646__auto__.state = {};
}

return this__41646__auto__;
});

untangled.client.impl.protocol_support.Root.prototype = goog.object.clone(React.Component.prototype);

var x142066_142076 = untangled.client.impl.protocol_support.Root.prototype;
x142066_142076.componentWillUpdate = ((function (x142066_142076){
return (function (next_props__41501__auto__,next_state__41502__auto__){
var this__41500__auto__ = this;
if(((!((this__41500__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__41500__auto__.om$next$Ident$)))?true:false):false)){
var ident__41504__auto___142077 = om.next.ident.call(null,this__41500__auto__,om.next.props.call(null,this__41500__auto__));
var next_ident__41505__auto___142078 = om.next.ident.call(null,this__41500__auto__,om.next._next_props.call(null,next_props__41501__auto__,this__41500__auto__));
if(cljs.core.not_EQ_.call(null,ident__41504__auto___142077,next_ident__41505__auto___142078)){
var idxr__41506__auto___142079 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__41500__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__41506__auto___142079 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__41506__auto___142079),((function (idxr__41506__auto___142079,ident__41504__auto___142077,next_ident__41505__auto___142078,this__41500__auto__,x142066_142076){
return (function (indexes__41507__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__41507__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__41504__auto___142077], null),cljs.core.disj,this__41500__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__41505__auto___142078], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__41500__auto__);
});})(idxr__41506__auto___142079,ident__41504__auto___142077,next_ident__41505__auto___142078,this__41500__auto__,x142066_142076))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__41500__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__41500__auto__);
});})(x142066_142076))
;

x142066_142076.shouldComponentUpdate = ((function (x142066_142076){
return (function (next_props__41501__auto__,next_state__41502__auto__){
var this__41500__auto__ = this;
var next_children__41503__auto__ = next_props__41501__auto__.children;
var next_props__41501__auto____$1 = goog.object.get(next_props__41501__auto__,"omcljs$value");
var next_props__41501__auto____$2 = (function (){var G__142068 = next_props__41501__auto____$1;
if((next_props__41501__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__142068);
} else {
return G__142068;
}
})();
var or__27280__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__41500__auto__),next_props__41501__auto____$2);
if(or__27280__auto__){
return or__27280__auto__;
} else {
var or__27280__auto____$1 = (function (){var and__27268__auto__ = this__41500__auto__.state;
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__41500__auto__.state,"omcljs$state"),goog.object.get(next_state__41502__auto__,"omcljs$state"));
} else {
return and__27268__auto__;
}
})();
if(cljs.core.truth_(or__27280__auto____$1)){
return or__27280__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__41500__auto__.props.children,next_children__41503__auto__);
}
}
});})(x142066_142076))
;

x142066_142076.componentWillUnmount = ((function (x142066_142076){
return (function (){
var this__41500__auto__ = this;
var r__41511__auto__ = om.next.get_reconciler.call(null,this__41500__auto__);
var cfg__41512__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__41511__auto__);
var st__41513__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__41512__auto__);
var indexer__41510__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__41512__auto__);
if(cljs.core.truth_((function (){var and__27268__auto__ = !((st__41513__auto__ == null));
if(and__27268__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__41513__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__41500__auto__], null));
} else {
return and__27268__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__41513__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__41500__auto__);
} else {
}

if((indexer__41510__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__41510__auto__,this__41500__auto__);
}
});})(x142066_142076))
;

x142066_142076.componentDidUpdate = ((function (x142066_142076){
return (function (prev_props__41508__auto__,prev_state__41509__auto__){
var this__41500__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__41500__auto__);
});})(x142066_142076))
;

x142066_142076.isMounted = ((function (x142066_142076){
return (function (){
var this__41500__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__41500__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x142066_142076))
;

x142066_142076.componentWillMount = ((function (x142066_142076){
return (function (){
var this__41500__auto__ = this;
var indexer__41510__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__41500__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__41510__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__41510__auto__,this__41500__auto__);
}
});})(x142066_142076))
;

x142066_142076.render = ((function (x142066_142076){
return (function (){
var this__41499__auto__ = this;
var this$ = this__41499__auto__;
var _STAR_reconciler_STAR_142069 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_142070 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_142071 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_142072 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_142073 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__41499__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__41499__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__41499__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__41499__auto__);

om.next._STAR_parent_STAR_ = this__41499__auto__;

try{return om.dom.div.call(null,null,"if you see this something is wrong");
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_142073;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_142072;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_142071;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_142070;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_142069;
}});})(x142066_142076))
;


untangled.client.impl.protocol_support.Root.prototype.constructor = untangled.client.impl.protocol_support.Root;

untangled.client.impl.protocol_support.Root.prototype.constructor.displayName = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.prototype.om$isComponent = true;

var x142074_142080 = untangled.client.impl.protocol_support.Root;
/** @nocollapse */
x142074_142080.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x142074_142080.om$next$IQuery$query$arity$1 = ((function (x142074_142080){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x142074_142080))
;


var x142075_142081 = untangled.client.impl.protocol_support.Root.prototype;

x142075_142081.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x142075_142081.om$next$IQuery$query$arity$1 = ((function (x142075_142081){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x142075_142081))
;


untangled.client.impl.protocol_support.Root.cljs$lang$type = true;

untangled.client.impl.protocol_support.Root.cljs$lang$ctorStr = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.cljs$lang$ctorPrWriter = (function (this__41649__auto__,writer__41650__auto__,opt__41651__auto__){
return cljs.core._write.call(null,writer__41650__auto__,"untangled.client.impl.protocol-support/Root");
});
untangled.client.impl.protocol_support.init_testing = (function untangled$client$impl$protocol_support$init_testing(){
return untangled.client.core.mount.call(null,untangled.client.core.new_untangled_test_client.call(null),untangled.client.impl.protocol_support.Root,"invisible-specs");
});

//# sourceMappingURL=protocol_support.js.map?rel=1481826792435