// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.logging');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('om.next');
goog.require('goog.log');
goog.require('goog.debug.Logger.Level');
untangled.client.logging.set_level = (function untangled$client$logging$set_level(log_level){

return om.next._STAR_logger_STAR_.setLevel(goog.debug.Logger.Level.getPredefinedLevel((function (){var G__61470 = (((log_level instanceof cljs.core.Keyword))?log_level.fqn:null);
switch (G__61470) {
case "all":
return "ALL";

break;
case "debug":
return "FINE";

break;
case "info":
return "INFO";

break;
case "warn":
return "WARNING";

break;
case "error":
return "SEVERE";

break;
case "none":
return "OFF";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(log_level)].join('')));

}
})()));
});
/**
 * Include a pretty-printed cljs value as a string with the given text message.
 */
untangled.client.logging.value_message = (function untangled$client$logging$value_message(msg,val){
return [cljs.core.str(msg),cljs.core.str(":\n"),cljs.core.str((function (){var sb__28367__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_61474_61476 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_61475_61477 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_61474_61476,_STAR_print_fn_STAR_61475_61477,sb__28367__auto__){
return (function (x__28368__auto__){
return sb__28367__auto__.append(x__28368__auto__);
});})(_STAR_print_newline_STAR_61474_61476,_STAR_print_fn_STAR_61475_61477,sb__28367__auto__))
;

try{cljs.pprint.pprint.call(null,val);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_61475_61477;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_61474_61476;
}
return [cljs.core.str(sb__28367__auto__)].join('');
})())].join('');
});
/**
 * Print a debug message to the Om logger which includes a value.
 *   Returns the value (like identity) so it can be harmlessly nested in expressions.
 */
untangled.client.logging.debug = (function untangled$client$logging$debug(var_args){
var args61478 = [];
var len__28496__auto___61481 = arguments.length;
var i__28497__auto___61482 = (0);
while(true){
if((i__28497__auto___61482 < len__28496__auto___61481)){
args61478.push((arguments[i__28497__auto___61482]));

var G__61483 = (i__28497__auto___61482 + (1));
i__28497__auto___61482 = G__61483;
continue;
} else {
}
break;
}

var G__61480 = args61478.length;
switch (G__61480) {
case 1:
return untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61478.length)].join('')));

}
});

untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$1 = (function (value){
goog.log.fine(om.next._STAR_logger_STAR_,untangled.client.logging.value_message.call(null,"DEBUG",value));

return value;
});

untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$2 = (function (msg,value){
goog.log.fine(om.next._STAR_logger_STAR_,untangled.client.logging.value_message.call(null,msg,value));

return value;
});

untangled.client.logging.debug.cljs$lang$maxFixedArity = 2;

/**
 * output an INFO level message to the Om logger
 */
untangled.client.logging.info = (function untangled$client$logging$info(var_args){
var args__28503__auto__ = [];
var len__28496__auto___61486 = arguments.length;
var i__28497__auto___61487 = (0);
while(true){
if((i__28497__auto___61487 < len__28496__auto___61486)){
args__28503__auto__.push((arguments[i__28497__auto___61487]));

var G__61488 = (i__28497__auto___61487 + (1));
i__28497__auto___61487 = G__61488;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.info(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.info.cljs$lang$maxFixedArity = (0);

untangled.client.logging.info.cljs$lang$applyTo = (function (seq61485){
return untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq61485));
});

/**
 * output a WARNING level message to the Om logger
 */
untangled.client.logging.warn = (function untangled$client$logging$warn(var_args){
var args__28503__auto__ = [];
var len__28496__auto___61490 = arguments.length;
var i__28497__auto___61491 = (0);
while(true){
if((i__28497__auto___61491 < len__28496__auto___61490)){
args__28503__auto__.push((arguments[i__28497__auto___61491]));

var G__61492 = (i__28497__auto___61491 + (1));
i__28497__auto___61491 = G__61492;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.warning(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.warn.cljs$lang$maxFixedArity = (0);

untangled.client.logging.warn.cljs$lang$applyTo = (function (seq61489){
return untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq61489));
});

/**
 * output an ERROR level message to the Om logger
 */
untangled.client.logging.error = (function untangled$client$logging$error(var_args){
var args__28503__auto__ = [];
var len__28496__auto___61494 = arguments.length;
var i__28497__auto___61495 = (0);
while(true){
if((i__28497__auto___61495 < len__28496__auto___61494)){
args__28503__auto__.push((arguments[i__28497__auto___61495]));

var G__61496 = (i__28497__auto___61495 + (1));
i__28497__auto___61495 = G__61496;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.error(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.error.cljs$lang$maxFixedArity = (0);

untangled.client.logging.error.cljs$lang$applyTo = (function (seq61493){
return untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq61493));
});


//# sourceMappingURL=logging.js.map?rel=1481754437835