// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.protocol_support');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('untangled.client.impl.protocol_support');
goog.require('untangled_spec.core');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.tempid');
goog.require('om.next');
/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to the optimistic update for transactions going to the server
 *   `ui-tx`: the om transaction that modifies the app state prior to receiving a server response
 *   `optimistic-delta`: the expected changes to the app state after executing ui-tx. See Protocol Testing README for how
 *   to build this properly.
 */
untangled.client.protocol_support.check_optimistic_update = (function untangled$client$protocol_support$check_optimistic_update(var_args){
var args__28503__auto__ = [];
var len__28496__auto___142094 = arguments.length;
var i__28497__auto___142095 = (0);
while(true){
if((i__28497__auto___142095 < len__28496__auto___142094)){
args__28503__auto__.push((arguments[i__28497__auto___142095]));

var G__142096 = (i__28497__auto___142095 + (1));
i__28497__auto___142095 = G__142096;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic = (function (p__142086,p__142087){
var map__142088 = p__142086;
var map__142088__$1 = ((((!((map__142088 == null)))?((((map__142088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142088):map__142088);
var data = map__142088__$1;
var initial_ui_state = cljs.core.get.call(null,map__142088__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__142088__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var optimistic_delta = cljs.core.get.call(null,map__142088__$1,new cljs.core.Keyword(null,"optimistic-delta","optimistic-delta",-2118700684));
var map__142089 = p__142087;
var map__142089__$1 = ((((!((map__142089 == null)))?((((map__142089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142089.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142089):map__142089);
var env = cljs.core.get.call(null,map__142089__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("state not allowed in the env argument"),cljs.core.str("\n"),cljs.core.str("(not (:state env))")].join('')));
}

cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Optimistic Updates");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));

var map__142092_142097 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__142092_142098__$1 = ((((!((map__142092_142097 == null)))?((((map__142092_142097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142092_142097.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142092_142097):map__142092_142097);
var parser_142099 = cljs.core.get.call(null,map__142092_142098__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_142100 = cljs.core.atom.call(null,initial_ui_state);
var parse_142101 = cljs.core.partial.call(null,parser_142099,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_142100], null),env));
var tempid_map_142102 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_142103__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_142102);
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"trigger correct state transitions");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));

parse_142101.call(null,ui_tx_142103__$1);

untangled.client.impl.protocol_support.check_delta.call(null,untangled.client.impl.protocol_support.rewrite_tempids.call(null,cljs.core.deref.call(null,state_142100),clojure.set.map_invert.call(null,tempid_map_142102),om.tempid.tempid_QMARK_),optimistic_delta);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_optimistic_update.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_optimistic_update.cljs$lang$applyTo = (function (seq142084){
var G__142085 = cljs.core.first.call(null,seq142084);
var seq142084__$1 = cljs.core.next.call(null,seq142084);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic(G__142085,seq142084__$1);
});

/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to sending the server transaction
 *   `ui-tx`: the om transaction that modifies the app state locally
 *   `server-tx`: the server transaction corresponding to ui-tx
 */
untangled.client.protocol_support.check_server_tx = (function untangled$client$protocol_support$check_server_tx(var_args){
var args__28503__auto__ = [];
var len__28496__auto___142115 = arguments.length;
var i__28497__auto___142116 = (0);
while(true){
if((i__28497__auto___142116 < len__28496__auto___142115)){
args__28503__auto__.push((arguments[i__28497__auto___142116]));

var G__142117 = (i__28497__auto___142116 + (1));
i__28497__auto___142116 = G__142117;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic = (function (p__142106,p__142107){
var map__142108 = p__142106;
var map__142108__$1 = ((((!((map__142108 == null)))?((((map__142108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142108.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142108):map__142108);
var initial_ui_state = cljs.core.get.call(null,map__142108__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__142108__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var server_tx = cljs.core.get.call(null,map__142108__$1,new cljs.core.Keyword(null,"server-tx","server-tx",-1146708246));
var map__142109 = p__142107;
var map__142109__$1 = ((((!((map__142109 == null)))?((((map__142109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142109):map__142109);
var env = cljs.core.get.call(null,map__142109__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Client Remoting");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));

var map__142112_142118 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__142112_142119__$1 = ((((!((map__142112_142118 == null)))?((((map__142112_142118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142112_142118.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142112_142118):map__142112_142118);
var parser_142120 = cljs.core.get.call(null,map__142112_142119__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_142121 = cljs.core.atom.call(null,initial_ui_state);
var parse_142122 = cljs.core.partial.call(null,parser_142120,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_142121], null),env));
var tempid_map_142123 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_142124__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_142123);
parse_142122.call(null,ui_tx_142124__$1);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

try{cljs.test.do_report.call(null,(function (){var act__43682__auto__ = untangled.client.impl.protocol_support.rewrite_tempids.call(null,untangled.client.impl.om_plumbing.strip_ui.call(null,untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,parse_142122.call(null,ui_tx_142124__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576)))),clojure.set.map_invert.call(null,tempid_map_142123),om.tempid.tempid_QMARK_);
var exp__43683__auto__ = server_tx;
var result__43684__auto__ = cljs.core._EQ_.call(null,exp__43683__auto__,act__43682__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__43684__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__43683__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__43682__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null);
})());
}catch (e142114){var t__37564__auto___142125 = e142114;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"server-tx","server-tx",493823281,null),cljs.core.list(new cljs.core.Symbol(null,"->","->",-2139605430,null),cljs.core.list(new cljs.core.Symbol(null,"parse","parse",478366908,null),new cljs.core.Symbol(null,"ui-tx","ui-tx",62864806,null),new cljs.core.Keyword(null,"remote","remote",-1593576576)),new cljs.core.Symbol("plumbing","remove-loads-and-fallbacks","plumbing/remove-loads-and-fallbacks",-474759113,null),new cljs.core.Symbol("plumbing","strip-ui","plumbing/strip-ui",-2004815259,null),cljs.core.list(new cljs.core.Symbol("impl","rewrite-tempids","impl/rewrite-tempids",-1005245316,null),cljs.core.list(new cljs.core.Symbol("set","map-invert","set/map-invert",1259038818,null),new cljs.core.Symbol(null,"tempid-map","tempid-map",-1148551297,null)),new cljs.core.Symbol("omt","tempid?","omt/tempid?",2034821487,null)))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142125,new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null));
}
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_server_tx.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_server_tx.cljs$lang$applyTo = (function (seq142104){
var G__142105 = cljs.core.first.call(null,seq142104);
var seq142104__$1 = cljs.core.next.call(null,seq142104);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic(G__142105,seq142104__$1);
});

/**
 * Takes a map containing:
 *   `response`: the exact data the server sends back to the client
 *   `pre-response-state`: normalized state prior to receiving `response`
 *   `server-tx`: the transaction originally sent to the server, yielding `response`
 *   `merge-delta`: the delta between `pre-response-state` and its integration with `response`
 */
untangled.client.protocol_support.check_response_from_server = (function untangled$client$protocol_support$check_response_from_server(p__142126){
var map__142132 = p__142126;
var map__142132__$1 = ((((!((map__142132 == null)))?((((map__142132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142132):map__142132);
var response = cljs.core.get.call(null,map__142132__$1,new cljs.core.Keyword(null,"response","response",-1068424192));
var pre_response_state = cljs.core.get.call(null,map__142132__$1,new cljs.core.Keyword(null,"pre-response-state","pre-response-state",696272294));
var ui_tx = cljs.core.get.call(null,map__142132__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var merge_delta = cljs.core.get.call(null,map__142132__$1,new cljs.core.Keyword(null,"merge-delta","merge-delta",-1454035297));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Server response merged with app state");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));

var map__142134_142137 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__142134_142138__$1 = ((((!((map__142134_142137 == null)))?((((map__142134_142137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__142134_142137.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__142134_142137):map__142134_142137);
var reconciler_142139 = cljs.core.get.call(null,map__142134_142138__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state_142140 = om.next.app_state.call(null,reconciler_142139);
cljs.core.reset_BANG_.call(null,state_142140,pre_response_state);

om.next.merge_BANG_.call(null,reconciler_142139,response,ui_tx);

if(cljs.core.truth_(merge_delta)){
untangled.client.impl.protocol_support.check_delta.call(null,cljs.core.deref.call(null,state_142140),merge_delta);
} else {
try{cljs.test.do_report.call(null,(function (){var act__43682__auto__ = cljs.core.deref.call(null,state_142140);
var exp__43683__auto__ = pre_response_state;
var result__43684__auto__ = cljs.core._EQ_.call(null,exp__43683__auto__,act__43682__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__43684__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__43683__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__43682__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null);
})());
}catch (e142136){var t__37564__auto___142141 = e142136;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"pre-response-state","pre-response-state",-1958163475,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"state","state",-348086572,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__37564__auto___142141,new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null));
}}

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});
untangled.client.protocol_support.with_behavior = untangled.client.impl.protocol_support.with_behavior;

//# sourceMappingURL=protocol_support.js.map?rel=1481826792505