// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled_spec.async');
goog.require('cljs.core');
goog.require('cljs.pprint');

/**
 * @interface
 */
untangled_spec.async.IAsyncQueue = function(){};

/**
 * Returns the current time on the simulated clock, in ms
 */
untangled_spec.async.current_time = (function untangled_spec$async$current_time(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$current_time$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$current_time$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (untangled_spec.async.current_time[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (untangled_spec.async.current_time["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.current-time",this$);
}
}
}
});

/**
 * Returns the first event on the queue
 */
untangled_spec.async.peek_event = (function untangled_spec$async$peek_event(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (untangled_spec.async.peek_event[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (untangled_spec.async.peek_event["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.peek-event",this$);
}
}
}
});

/**
 * Move the clock forward by the specified number of ms, triggering events (even those added by interstitial triggers) in the correct order up to (and including) events that coincide with the final time.
 */
untangled_spec.async.advance_clock = (function untangled_spec$async$advance_clock(this$,ms){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 == null)))){
return this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2(this$,ms);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (untangled_spec.async.advance_clock[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,ms);
} else {
var m__27994__auto____$1 = (untangled_spec.async.advance_clock["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,ms);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.advance-clock",this$);
}
}
}
});

/**
 * Schedule an event which should occur at some time in the future (offset from now).
 */
untangled_spec.async.schedule_event = (function untangled_spec$async$schedule_event(this$,ms_from_now,fn_to_call){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 == null)))){
return this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3(this$,ms_from_now,fn_to_call);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (untangled_spec.async.schedule_event[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,ms_from_now,fn_to_call);
} else {
var m__27994__auto____$1 = (untangled_spec.async.schedule_event["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,ms_from_now,fn_to_call);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.schedule-event",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.Event = (function (abs_time,fn_to_call,__meta,__extmap,__hash){
this.abs_time = abs_time;
this.fn_to_call = fn_to_call;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k55728,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__55730 = (((k55728 instanceof cljs.core.Keyword))?k55728.fqn:null);
switch (G__55730) {
case "abs-time":
return self__.abs_time;

break;
case "fn-to-call":
return self__.fn_to_call;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55728,else__27953__auto__);

}
});


untangled_spec.async.Event.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#untangled-spec.async.Event{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.Event.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55727){
var self__ = this;
var G__55727__$1 = this;
return (new cljs.core.RecordIter((0),G__55727__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.async.Event.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


untangled_spec.async.Event.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.async.Event.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


untangled_spec.async.Event.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.async.Event.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


untangled_spec.async.Event.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__55727){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__55731 = cljs.core.keyword_identical_QMARK_;
var expr__55732 = k__27958__auto__;
if(cljs.core.truth_(pred__55731.call(null,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),expr__55732))){
return (new untangled_spec.async.Event(G__55727,self__.fn_to_call,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55731.call(null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),expr__55732))){
return (new untangled_spec.async.Event(self__.abs_time,G__55727,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__55727),null));
}
}
});


untangled_spec.async.Event.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__55727){
var self__ = this;
var this__27949__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,G__55727,self__.__extmap,self__.__hash));
});


untangled_spec.async.Event.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

untangled_spec.async.Event.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"abs-time","abs-time",1700019601,null),new cljs.core.Symbol(null,"fn-to-call","fn-to-call",1043613154,null)], null);
});

untangled_spec.async.Event.cljs$lang$type = true;

untangled_spec.async.Event.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/Event");
});

untangled_spec.async.Event.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"untangled-spec.async/Event");
});

untangled_spec.async.__GT_Event = (function untangled_spec$async$__GT_Event(abs_time,fn_to_call){
return (new untangled_spec.async.Event(abs_time,fn_to_call,null,null,null));
});

untangled_spec.async.map__GT_Event = (function untangled_spec$async$map__GT_Event(G__55729){
return (new untangled_spec.async.Event(new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(G__55729),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(G__55729),null,cljs.core.dissoc.call(null,G__55729,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)),null));
});

/**
 * Triggers the first event in the queue (runs it), and removes it from the queue.
 */
untangled_spec.async.process_first_event_BANG_ = (function untangled_spec$async$process_first_event_BANG_(queue){
var temp__6751__auto__ = untangled_spec.async.peek_event.call(null,queue);
if(cljs.core.truth_(temp__6751__auto__)){
var evt = temp__6751__auto__;
new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(evt).call(null);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(queue),((function (evt,temp__6751__auto__){
return (function (p1__55735_SHARP_){
return cljs.core.dissoc.call(null,p1__55735_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt));
});})(evt,temp__6751__auto__))
);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled_spec.async.IAsyncQueue}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.AsyncQueue = (function (schedule,now,__meta,__extmap,__hash){
this.schedule = schedule;
this.now = now;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k55738,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__55740 = (((k55738 instanceof cljs.core.Keyword))?k55738.fqn:null);
switch (G__55740) {
case "schedule":
return self__.schedule;

break;
case "now":
return self__.now;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55738,else__27953__auto__);

}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#untangled-spec.async.AsyncQueue{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55737){
var self__ = this;
var G__55737__$1 = this;
return (new cljs.core.RecordIter((0),G__55737__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$current_time$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1));
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$peek_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1))));
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 = (function (this$,ms){
var self__ = this;
var this$__$1 = this;
var stop_time = (ms + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var evt_55745 = untangled_spec.async.peek_event.call(null,this$__$1);
while(true){
var now_55746__$1 = (function (){var or__27280__auto__ = new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt_55745);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return (stop_time + (1));
}
})();
if((now_55746__$1 <= stop_time)){
cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),now_55746__$1);

untangled_spec.async.process_first_event_BANG_.call(null,this$__$1);

var G__55747 = untangled_spec.async.peek_event.call(null,this$__$1);
evt_55745 = G__55747;
continue;
} else {
}
break;
}

return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),stop_time);
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 = (function (this$,ms_from_now,fn_to_call){
var self__ = this;
var this$__$1 = this;
var tm = (ms_from_now + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var event = (new untangled_spec.async.Event(tm,fn_to_call,null,null,null));
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1)),tm)){
throw cljs.core.ex_info.call(null,[cljs.core.str("Schedule already contains an event "),cljs.core.str(ms_from_now),cljs.core.str("ms from 'now' which would generate an indeterminant ordering for your events. Please offset your submission time a bit")].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1),((function (tm,event,this$__$1){
return (function (p1__55736_SHARP_){
return cljs.core.assoc.call(null,p1__55736_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(event),event);
});})(tm,event,this$__$1))
);
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schedule","schedule",349275266),null,new cljs.core.Keyword(null,"now","now",-1650525531),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__55737){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__55741 = cljs.core.keyword_identical_QMARK_;
var expr__55742 = k__27958__auto__;
if(cljs.core.truth_(pred__55741.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266),expr__55742))){
return (new untangled_spec.async.AsyncQueue(G__55737,self__.now,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55741.call(null,new cljs.core.Keyword(null,"now","now",-1650525531),expr__55742))){
return (new untangled_spec.async.AsyncQueue(self__.schedule,G__55737,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__55737),null));
}
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__55737){
var self__ = this;
var this__27949__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,G__55737,self__.__extmap,self__.__hash));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

untangled_spec.async.AsyncQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schedule","schedule",1989806793,null),new cljs.core.Symbol(null,"now","now",-9994004,null)], null);
});

untangled_spec.async.AsyncQueue.cljs$lang$type = true;

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.__GT_AsyncQueue = (function untangled_spec$async$__GT_AsyncQueue(schedule,now){
return (new untangled_spec.async.AsyncQueue(schedule,now,null,null,null));
});

untangled_spec.async.map__GT_AsyncQueue = (function untangled_spec$async$map__GT_AsyncQueue(G__55739){
return (new untangled_spec.async.AsyncQueue(new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(G__55739),new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(G__55739),null,cljs.core.dissoc.call(null,G__55739,new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)),null));
});

/**
 * Build an asynchronous event simulation queue.
 */
untangled_spec.async.make_async_queue = (function untangled_spec$async$make_async_queue(){
return (new untangled_spec.async.AsyncQueue(cljs.core.atom.call(null,cljs.core.sorted_map.call(null)),cljs.core.atom.call(null,(0)),null,null,null));
});

//# sourceMappingURL=async.js.map?rel=1481754427369