// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.protocol_support');
goog.require('cljs.core');
goog.require('om.dom');
goog.require('untangled_spec.core');
goog.require('cljs.test');
goog.require('untangled.client.core');
goog.require('clojure.walk');
goog.require('om.next');
/**
 * Is the given keyword a seed data tempid keyword (namespaced to `tempid`)?
 */
untangled.client.impl.protocol_support.tempid_QMARK_ = (function untangled$client$impl$protocol_support$tempid_QMARK_(kw){
return ((kw instanceof cljs.core.Keyword)) && (cljs.core._EQ_.call(null,"om.tempid",cljs.core.namespace.call(null,kw)));
});
/**
 * Rewrite tempid keywords in the given state using the tid->rid map. Leaves the keyword alone if the map
 * does not contain an entry for it.
 */
untangled.client.impl.protocol_support.rewrite_tempids = (function untangled$client$impl$protocol_support$rewrite_tempids(var_args){
var args__11898__auto__ = [];
var len__11895__auto___23046 = arguments.length;
var i__11896__auto___23047 = (0);
while(true){
if((i__11896__auto___23047 < len__11895__auto___23046)){
args__11898__auto__.push((arguments[i__11896__auto___23047]));

var G__23048 = (i__11896__auto___23047 + (1));
i__11896__auto___23047 = G__23048;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((2) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((2)),(0),null)):null);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__11899__auto__);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic = (function (state,tid__GT_rid,p__23042){
var vec__23043 = p__23042;
var pred = cljs.core.nth.call(null,vec__23043,(0),null);
return clojure.walk.prewalk.call(null,((function (vec__23043,pred){
return (function (p1__23038_SHARP_){
if(cljs.core.truth_((function (){var or__11247__auto__ = pred;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return untangled.client.impl.protocol_support.tempid_QMARK_;
}
})().call(null,p1__23038_SHARP_))){
return cljs.core.get.call(null,tid__GT_rid,p1__23038_SHARP_,p1__23038_SHARP_);
} else {
return p1__23038_SHARP_;
}
});})(vec__23043,pred))
,state);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$maxFixedArity = (2);

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$applyTo = (function (seq23039){
var G__23040 = cljs.core.first.call(null,seq23039);
var seq23039__$1 = cljs.core.next.call(null,seq23039);
var G__23041 = cljs.core.first.call(null,seq23039__$1);
var seq23039__$2 = cljs.core.next.call(null,seq23039__$1);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic(G__23040,G__23041,seq23039__$2);
});

/**
 * Checks that `new-state` includes the `delta`, where `delta` is a map keyed by data path (as in get-in). The
 * values of `delta` are literal values to verify at that path (nil means the path should be missing).
 */
untangled.client.impl.protocol_support.check_delta = (function untangled$client$impl$protocol_support$check_delta(new_state,delta){
if(cljs.core.empty_QMARK_.call(null,delta)){
throw cljs.core.ex_info.call(null,"Cannot have empty :merge-delta",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-state","new-state",-490349212),new_state], null));
} else {
var seq__23063 = cljs.core.seq.call(null,delta);
var chunk__23064 = null;
var count__23065 = (0);
var i__23066 = (0);
while(true){
if((i__23066 < count__23065)){
var vec__23067 = cljs.core._nth.call(null,chunk__23064,i__23066);
var key_path = cljs.core.nth.call(null,vec__23067,(0),null);
var value = cljs.core.nth.call(null,vec__23067,(1),null);
var behavior_string_23077 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_23078__$1 = (function (){var or__11247__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_23077);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_23077], null));

if((value_23078__$1 instanceof RegExp)){
try{var values__2771__auto___23079 = (function (){var x__11736__auto__ = value_23078__$1;
return cljs.core._conj.call(null,(function (){var x__11736__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto____$1);
})(),x__11736__auto__);
})();
var result__2772__auto___23080 = cljs.core.apply.call(null,cljs.core.re_matches,values__2771__auto___23079);
if(cljs.core.truth_(result__2772__auto___23080)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__2771__auto___23079),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__11736__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__2771__auto___23079);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e23070){var t__2809__auto___23081 = e23070;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23081,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__727__auto__ = value_23078__$1;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e23071){var t__2809__auto___23082 = e23071;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23082,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_23077], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__23083 = seq__23063;
var G__23084 = chunk__23064;
var G__23085 = count__23065;
var G__23086 = (i__23066 + (1));
seq__23063 = G__23083;
chunk__23064 = G__23084;
count__23065 = G__23085;
i__23066 = G__23086;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__23063);
if(temp__6753__auto__){
var seq__23063__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23063__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__23063__$1);
var G__23087 = cljs.core.chunk_rest.call(null,seq__23063__$1);
var G__23088 = c__11725__auto__;
var G__23089 = cljs.core.count.call(null,c__11725__auto__);
var G__23090 = (0);
seq__23063 = G__23087;
chunk__23064 = G__23088;
count__23065 = G__23089;
i__23066 = G__23090;
continue;
} else {
var vec__23072 = cljs.core.first.call(null,seq__23063__$1);
var key_path = cljs.core.nth.call(null,vec__23072,(0),null);
var value = cljs.core.nth.call(null,vec__23072,(1),null);
var behavior_string_23091 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_23092__$1 = (function (){var or__11247__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_23091);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_23091], null));

if((value_23092__$1 instanceof RegExp)){
try{var values__2771__auto___23093 = (function (){var x__11736__auto__ = value_23092__$1;
return cljs.core._conj.call(null,(function (){var x__11736__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto____$1);
})(),x__11736__auto__);
})();
var result__2772__auto___23094 = cljs.core.apply.call(null,cljs.core.re_matches,values__2771__auto___23093);
if(cljs.core.truth_(result__2772__auto___23094)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__2771__auto___23093),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__11736__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__2771__auto___23093);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e23075){var t__2809__auto___23095 = e23075;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23095,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__727__auto__ = value_23092__$1;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e23076){var t__2809__auto___23096 = e23076;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23096,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_23091], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__23097 = cljs.core.next.call(null,seq__23063__$1);
var G__23098 = null;
var G__23099 = (0);
var G__23100 = (0);
seq__23063 = G__23097;
chunk__23064 = G__23098;
count__23065 = G__23099;
i__23066 = G__23100;
continue;
}
} else {
return null;
}
}
break;
}
}
});
untangled.client.impl.protocol_support.with_behavior = (function untangled$client$impl$protocol_support$with_behavior(behavior_string,value){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cps","value","cps/value",307453219),value,new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882),behavior_string], null);
});
untangled.client.impl.protocol_support.allocate_tempids = (function untangled$client$impl$protocol_support$allocate_tempids(tx){
var allocated_ids = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
clojure.walk.prewalk.call(null,((function (allocated_ids){
return (function (v){
if(cljs.core.truth_(untangled.client.impl.protocol_support.tempid_QMARK_.call(null,v))){
cljs.core.swap_BANG_.call(null,allocated_ids,cljs.core.conj,v);
} else {
}

return v;
});})(allocated_ids))
,tx);

return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (allocated_ids){
return (function (p1__23101_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__23101_SHARP_,om.next.tempid.call(null)],null));
});})(allocated_ids))
,cljs.core.deref.call(null,allocated_ids)));
});
/**
 * @constructor
 */
untangled.client.impl.protocol_support.Root = (function untangled$client$impl$protocol_support$Root(){
var this__23820__auto__ = this;
React.Component.apply(this__23820__auto__,arguments);

if(!((this__23820__auto__.initLocalState == null))){
this__23820__auto__.state = this__23820__auto__.initLocalState();
} else {
this__23820__auto__.state = {};
}

return this__23820__auto__;
});

untangled.client.impl.protocol_support.Root.prototype = goog.object.clone(React.Component.prototype);

var x23106_23116 = untangled.client.impl.protocol_support.Root.prototype;
x23106_23116.componentWillUpdate = ((function (x23106_23116){
return (function (next_props__23679__auto__,next_state__23680__auto__){
var this__23678__auto__ = this;
if(((!((this__23678__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__23678__auto__.om$next$Ident$)))?true:false):false)){
var ident__23682__auto___23117 = om.next.ident.call(null,this__23678__auto__,om.next.props.call(null,this__23678__auto__));
var next_ident__23683__auto___23118 = om.next.ident.call(null,this__23678__auto__,om.next._next_props.call(null,next_props__23679__auto__,this__23678__auto__));
if(cljs.core.not_EQ_.call(null,ident__23682__auto___23117,next_ident__23683__auto___23118)){
var idxr__23684__auto___23119 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__23678__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__23684__auto___23119 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__23684__auto___23119),((function (idxr__23684__auto___23119,ident__23682__auto___23117,next_ident__23683__auto___23118,this__23678__auto__,x23106_23116){
return (function (indexes__23685__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__23685__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__23682__auto___23117], null),cljs.core.disj,this__23678__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__23683__auto___23118], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__23678__auto__);
});})(idxr__23684__auto___23119,ident__23682__auto___23117,next_ident__23683__auto___23118,this__23678__auto__,x23106_23116))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__23678__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__23678__auto__);
});})(x23106_23116))
;

x23106_23116.shouldComponentUpdate = ((function (x23106_23116){
return (function (next_props__23679__auto__,next_state__23680__auto__){
var this__23678__auto__ = this;
var next_children__23681__auto__ = next_props__23679__auto__.children;
var next_props__23679__auto____$1 = goog.object.get(next_props__23679__auto__,"omcljs$value");
var next_props__23679__auto____$2 = (function (){var G__23108 = next_props__23679__auto____$1;
if((next_props__23679__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__23108);
} else {
return G__23108;
}
})();
var or__11247__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__23678__auto__),next_props__23679__auto____$2);
if(or__11247__auto__){
return or__11247__auto__;
} else {
var or__11247__auto____$1 = (function (){var and__11239__auto__ = this__23678__auto__.state;
if(cljs.core.truth_(and__11239__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__23678__auto__.state,"omcljs$state"),goog.object.get(next_state__23680__auto__,"omcljs$state"));
} else {
return and__11239__auto__;
}
})();
if(cljs.core.truth_(or__11247__auto____$1)){
return or__11247__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__23678__auto__.props.children,next_children__23681__auto__);
}
}
});})(x23106_23116))
;

x23106_23116.componentWillUnmount = ((function (x23106_23116){
return (function (){
var this__23678__auto__ = this;
var r__23689__auto__ = om.next.get_reconciler.call(null,this__23678__auto__);
var cfg__23690__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__23689__auto__);
var st__23691__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__23690__auto__);
var indexer__23688__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__23690__auto__);
if(cljs.core.truth_((function (){var and__11239__auto__ = !((st__23691__auto__ == null));
if(and__11239__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__23691__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__23678__auto__], null));
} else {
return and__11239__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__23691__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__23678__auto__);
} else {
}

if((indexer__23688__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__23688__auto__,this__23678__auto__);
}
});})(x23106_23116))
;

x23106_23116.componentDidUpdate = ((function (x23106_23116){
return (function (prev_props__23686__auto__,prev_state__23687__auto__){
var this__23678__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__23678__auto__);
});})(x23106_23116))
;

x23106_23116.isMounted = ((function (x23106_23116){
return (function (){
var this__23678__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__23678__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x23106_23116))
;

x23106_23116.componentWillMount = ((function (x23106_23116){
return (function (){
var this__23678__auto__ = this;
var indexer__23688__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__23678__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__23688__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__23688__auto__,this__23678__auto__);
}
});})(x23106_23116))
;

x23106_23116.render = ((function (x23106_23116){
return (function (){
var this__23677__auto__ = this;
var this$ = this__23677__auto__;
var _STAR_reconciler_STAR_23109 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_23110 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_23111 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_23112 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_23113 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__23677__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__23677__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__23677__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__23677__auto__);

om.next._STAR_parent_STAR_ = this__23677__auto__;

try{return om.dom.div.call(null,null,"if you see this something is wrong");
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_23113;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_23112;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_23111;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_23110;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_23109;
}});})(x23106_23116))
;


untangled.client.impl.protocol_support.Root.prototype.constructor = untangled.client.impl.protocol_support.Root;

untangled.client.impl.protocol_support.Root.prototype.constructor.displayName = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.prototype.om$isComponent = true;

var x23114_23120 = untangled.client.impl.protocol_support.Root;
/** @nocollapse */
x23114_23120.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x23114_23120.om$next$IQuery$query$arity$1 = ((function (x23114_23120){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x23114_23120))
;


var x23115_23121 = untangled.client.impl.protocol_support.Root.prototype;

x23115_23121.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x23115_23121.om$next$IQuery$query$arity$1 = ((function (x23115_23121){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x23115_23121))
;


untangled.client.impl.protocol_support.Root.cljs$lang$type = true;

untangled.client.impl.protocol_support.Root.cljs$lang$ctorStr = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.cljs$lang$ctorPrWriter = (function (this__23823__auto__,writer__23824__auto__,opt__23825__auto__){
return cljs.core._write.call(null,writer__23824__auto__,"untangled.client.impl.protocol-support/Root");
});
untangled.client.impl.protocol_support.init_testing = (function untangled$client$impl$protocol_support$init_testing(){
return untangled.client.core.mount.call(null,untangled.client.core.new_untangled_test_client.call(null),untangled.client.impl.protocol_support.Root,"invisible-specs");
});

//# sourceMappingURL=protocol_support.js.map?rel=1485292056253