// Compiled by ClojureScript 1.9.293 {}
goog.provide('bidi.bidi');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.Uri');
bidi.bidi.url_encode = (function bidi$bidi$url_encode(string){
var G__84919 = string;
var G__84919__$1 = (((G__84919 == null))?null:[cljs.core.str(G__84919)].join(''));
var G__84919__$2 = (((G__84919__$1 == null))?null:encodeURIComponent(G__84919__$1));
if((G__84919__$2 == null)){
return null;
} else {
return G__84919__$2.replace("+","%20");
}
});
bidi.bidi.url_decode = (function bidi$bidi$url_decode(string){
var G__84921 = string;
var G__84921__$1 = (((G__84921 == null))?null:[cljs.core.str(G__84921)].join(''));
if((G__84921__$1 == null)){
return null;
} else {
return decodeURIComponent(G__84921__$1);
}
});
/**
 * Function for creating a UUID of the appropriate type for the platform.
 * Note that this function should _only_ be used in route patterns as, at least
 * in the case of ClojureScript, it does not validate that the input string is
 * actually a valid UUID (this is handled by the route matching logic).
 */
bidi.bidi.uuid = (function bidi$bidi$uuid(s){
return (new cljs.core.UUID(s));
});

/**
 * @interface
 */
bidi.bidi.ParameterEncoding = function(){};

bidi.bidi.encode_parameter = (function bidi$bidi$encode_parameter(_){
if((!((_ == null))) && (!((_.bidi$bidi$ParameterEncoding$encode_parameter$arity$1 == null)))){
return _.bidi$bidi$ParameterEncoding$encode_parameter$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.encode_parameter[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.encode_parameter["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"ParameterEncoding.encode-parameter",_);
}
}
}
});

(bidi.bidi.ParameterEncoding["string"] = true);

(bidi.bidi.encode_parameter["string"] = (function (s){
return s;
}));

(bidi.bidi.ParameterEncoding["number"] = true);

(bidi.bidi.encode_parameter["number"] = (function (s){
return s;
}));


cljs.core.UUID.prototype.bidi$bidi$ParameterEncoding$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.UUID.prototype.bidi$bidi$ParameterEncoding$encode_parameter$arity$1 = (function (s){
var s__$1 = this;
return [cljs.core.str(s__$1)].join('');
});


cljs.core.Keyword.prototype.bidi$bidi$ParameterEncoding$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.bidi$bidi$ParameterEncoding$encode_parameter$arity$1 = (function (k){
var k__$1 = this;
return bidi.bidi.url_encode.call(null,[cljs.core.str(cljs.core.namespace.call(null,k__$1)),cljs.core.str((cljs.core.truth_(cljs.core.namespace.call(null,k__$1))?"/":null)),cljs.core.str(cljs.core.name.call(null,k__$1))].join(''));
});

/**
 * @interface
 */
bidi.bidi.PatternSegment = function(){};

bidi.bidi.segment_regex_group = (function bidi$bidi$segment_regex_group(_){
if((!((_ == null))) && (!((_.bidi$bidi$PatternSegment$segment_regex_group$arity$1 == null)))){
return _.bidi$bidi$PatternSegment$segment_regex_group$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.segment_regex_group[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.segment_regex_group["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PatternSegment.segment-regex-group",_);
}
}
}
});

bidi.bidi.param_key = (function bidi$bidi$param_key(_){
if((!((_ == null))) && (!((_.bidi$bidi$PatternSegment$param_key$arity$1 == null)))){
return _.bidi$bidi$PatternSegment$param_key$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.param_key[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.param_key["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PatternSegment.param-key",_);
}
}
}
});

bidi.bidi.transform_param = (function bidi$bidi$transform_param(_){
if((!((_ == null))) && (!((_.bidi$bidi$PatternSegment$transform_param$arity$1 == null)))){
return _.bidi$bidi$PatternSegment$transform_param$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.transform_param[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.transform_param["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"PatternSegment.transform-param",_);
}
}
}
});

bidi.bidi.unmatch_segment = (function bidi$bidi$unmatch_segment(_,params){
if((!((_ == null))) && (!((_.bidi$bidi$PatternSegment$unmatch_segment$arity$2 == null)))){
return _.bidi$bidi$PatternSegment$unmatch_segment$arity$2(_,params);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.unmatch_segment[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,params);
} else {
var m__27994__auto____$1 = (bidi.bidi.unmatch_segment["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,params);
} else {
throw cljs.core.missing_protocol.call(null,"PatternSegment.unmatch-segment",_);
}
}
}
});

bidi.bidi.matches_QMARK_ = (function bidi$bidi$matches_QMARK_(_,s){
if((!((_ == null))) && (!((_.bidi$bidi$PatternSegment$matches_QMARK_$arity$2 == null)))){
return _.bidi$bidi$PatternSegment$matches_QMARK_$arity$2(_,s);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.matches_QMARK_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,s);
} else {
var m__27994__auto____$1 = (bidi.bidi.matches_QMARK_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,s);
} else {
throw cljs.core.missing_protocol.call(null,"PatternSegment.matches?",_);
}
}
}
});

(bidi.bidi.PatternSegment["string"] = true);

(bidi.bidi.segment_regex_group["string"] = (function (this$){
return this$;
}));

(bidi.bidi.param_key["string"] = (function (_){
return null;
}));

(bidi.bidi.transform_param["string"] = (function (_){
return cljs.core.identity;
}));

(bidi.bidi.unmatch_segment["string"] = (function (this$,_){
return this$;
}));


RegExp.prototype.bidi$bidi$PatternSegment$ = cljs.core.PROTOCOL_SENTINEL;


RegExp.prototype.bidi$bidi$PatternSegment$segment_regex_group$arity$1 = (function (this$){
var this$__$1 = this;
return (this$__$1["source"]);
});


RegExp.prototype.bidi$bidi$PatternSegment$param_key$arity$1 = (function (_){
var ___$1 = this;
return null;
});


RegExp.prototype.bidi$bidi$PatternSegment$transform_param$arity$1 = (function (_){
var ___$1 = this;
return cljs.core.identity;
});


RegExp.prototype.bidi$bidi$PatternSegment$matches_QMARK_$arity$2 = (function (this$,s){
var this$__$1 = this;
return cljs.core.re_matches.call(null,this$__$1,[cljs.core.str(s)].join(''));
});


cljs.core.PersistentVector.prototype.bidi$bidi$PatternSegment$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentVector.prototype.bidi$bidi$PatternSegment$segment_regex_group$arity$1 = (function (this$){
var this$__$1 = this;
return bidi.bidi.segment_regex_group.call(null,cljs.core.first.call(null,this$__$1));
});


cljs.core.PersistentVector.prototype.bidi$bidi$PatternSegment$param_key$arity$1 = (function (this$){
var this$__$1 = this;
var k = cljs.core.second.call(null,this$__$1);
if((k instanceof cljs.core.Keyword)){
return k;
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("If a PatternSegment is represented by a vector, the second\n                               element must be the keyword associated with the pattern: "),cljs.core.str(this$__$1)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});


cljs.core.PersistentVector.prototype.bidi$bidi$PatternSegment$transform_param$arity$1 = (function (this$){
var this$__$1 = this;
return bidi.bidi.transform_param.call(null,cljs.core.first.call(null,this$__$1));
});


cljs.core.PersistentVector.prototype.bidi$bidi$PatternSegment$unmatch_segment$arity$2 = (function (this$,params){
var this$__$1 = this;
var k = cljs.core.second.call(null,this$__$1);
if(!((k instanceof cljs.core.Keyword))){
throw cljs.core.ex_info.call(null,[cljs.core.str("If a PatternSegment is represented by a vector, the second element\n                               must be the key associated with the pattern: "),cljs.core.str(this$__$1)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

var temp__6751__auto__ = cljs.core.get.call(null,params,k);
if(cljs.core.truth_(temp__6751__auto__)){
var v = temp__6751__auto__;
if(cljs.core.truth_(bidi.bidi.matches_QMARK_.call(null,cljs.core.first.call(null,this$__$1),v))){
return bidi.bidi.encode_parameter.call(null,v);
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Parameter value of "),cljs.core.str(v),cljs.core.str(" (key "),cljs.core.str(k),cljs.core.str(") "),cljs.core.str("is not compatible with the route pattern "),cljs.core.str(this$__$1)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("No parameter found in params for key "),cljs.core.str(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});


cljs.core.Keyword.prototype.bidi$bidi$PatternSegment$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.bidi$bidi$PatternSegment$segment_regex_group$arity$1 = (function (_){
var ___$1 = this;
return "[A-Za-z0-9\\-\\_\\.]+";
});


cljs.core.Keyword.prototype.bidi$bidi$PatternSegment$param_key$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});


cljs.core.Keyword.prototype.bidi$bidi$PatternSegment$transform_param$arity$1 = (function (_){
var ___$1 = this;
return cljs.core.identity;
});


cljs.core.Keyword.prototype.bidi$bidi$PatternSegment$unmatch_segment$arity$2 = (function (this$,params){
var this$__$1 = this;
var temp__6751__auto__ = this$__$1.call(null,params);
if(cljs.core.truth_(temp__6751__auto__)){
var v = temp__6751__auto__;
return bidi.bidi.encode_parameter.call(null,v);
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Cannot form URI without a value given for "),cljs.core.str(this$__$1),cljs.core.str(" parameter")].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});

(bidi.bidi.PatternSegment["function"] = true);

(bidi.bidi.segment_regex_group["function"] = (function (this$){
var pred__84925 = cljs.core._EQ_;
var expr__84926 = this$;
if(cljs.core.truth_(pred__84925.call(null,cljs.core.keyword,expr__84926))){
return "[A-Za-z]+[A-Za-z0-9\\*\\+\\!\\-\\_\\?\\.]*(?:%2F[A-Za-z]+[A-Za-z0-9\\*\\+\\!\\-\\_\\?\\.]*)?";
} else {
if(cljs.core.truth_(pred__84925.call(null,cljs.core.long$,expr__84926))){
return "-?\\d{1,19}";
} else {
if(cljs.core.truth_(pred__84925.call(null,bidi.bidi.uuid,expr__84926))){
return "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}";
} else {
if(cljs.core.truth_(pred__84925.call(null,new cljs.core.Keyword(null,"otherwise","otherwise",-1127537137),expr__84926))){
throw cljs.core.ex_info.call(null,[cljs.core.str("Unidentified function qualifier to pattern segment: "),cljs.core.str(this$)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__84926)].join('')));
}
}
}
}
}));

(bidi.bidi.transform_param["function"] = (function (this$){
var pred__84928 = cljs.core._EQ_;
var expr__84929 = this$;
if(cljs.core.truth_(pred__84928.call(null,cljs.core.keyword,expr__84929))){
return cljs.core.comp.call(null,cljs.core.keyword,bidi.bidi.url_decode);
} else {
if(cljs.core.truth_(pred__84928.call(null,cljs.core.long$,expr__84929))){
return ((function (pred__84928,expr__84929){
return (function (p1__84923_SHARP_){
return Number(p1__84923_SHARP_);
});
;})(pred__84928,expr__84929))
} else {
if(cljs.core.truth_(pred__84928.call(null,bidi.bidi.uuid,expr__84929))){
return bidi.bidi.uuid;
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Unrecognized function "),cljs.core.str(this$)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
}
}
}));

(bidi.bidi.matches_QMARK_["function"] = (function (this$,s){
var pred__84931 = cljs.core._EQ_;
var expr__84932 = this$;
if(cljs.core.truth_(pred__84931.call(null,cljs.core.keyword,expr__84932))){
return (s instanceof cljs.core.Keyword);
} else {
if(cljs.core.truth_(pred__84931.call(null,cljs.core.long$,expr__84932))){
return cljs.core.not.call(null,isNaN(s));
} else {
if(cljs.core.truth_(pred__84931.call(null,bidi.bidi.uuid,expr__84932))){
return (s instanceof cljs.core.UUID);
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__84932)].join('')));
}
}
}
}));

/**
 * @interface
 */
bidi.bidi.Pattern = function(){};

bidi.bidi.match_pattern = (function bidi$bidi$match_pattern(_,path){
if((!((_ == null))) && (!((_.bidi$bidi$Pattern$match_pattern$arity$2 == null)))){
return _.bidi$bidi$Pattern$match_pattern$arity$2(_,path);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.match_pattern[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,path);
} else {
var m__27994__auto____$1 = (bidi.bidi.match_pattern["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,path);
} else {
throw cljs.core.missing_protocol.call(null,"Pattern.match-pattern",_);
}
}
}
});

bidi.bidi.unmatch_pattern = (function bidi$bidi$unmatch_pattern(_,m){
if((!((_ == null))) && (!((_.bidi$bidi$Pattern$unmatch_pattern$arity$2 == null)))){
return _.bidi$bidi$Pattern$unmatch_pattern$arity$2(_,m);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.unmatch_pattern[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,m);
} else {
var m__27994__auto____$1 = (bidi.bidi.unmatch_pattern["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,m);
} else {
throw cljs.core.missing_protocol.call(null,"Pattern.unmatch-pattern",_);
}
}
}
});


/**
 * @interface
 */
bidi.bidi.Matched = function(){};

bidi.bidi.resolve_handler = (function bidi$bidi$resolve_handler(_,m){
if((!((_ == null))) && (!((_.bidi$bidi$Matched$resolve_handler$arity$2 == null)))){
return _.bidi$bidi$Matched$resolve_handler$arity$2(_,m);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.resolve_handler[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,m);
} else {
var m__27994__auto____$1 = (bidi.bidi.resolve_handler["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,m);
} else {
throw cljs.core.missing_protocol.call(null,"Matched.resolve-handler",_);
}
}
}
});

bidi.bidi.unresolve_handler = (function bidi$bidi$unresolve_handler(_,m){
if((!((_ == null))) && (!((_.bidi$bidi$Matched$unresolve_handler$arity$2 == null)))){
return _.bidi$bidi$Matched$unresolve_handler$arity$2(_,m);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.unresolve_handler[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,m);
} else {
var m__27994__auto____$1 = (bidi.bidi.unresolve_handler["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,m);
} else {
throw cljs.core.missing_protocol.call(null,"Matched.unresolve-handler",_);
}
}
}
});

bidi.bidi.just_path = (function bidi$bidi$just_path(path){
var uri_string = [cljs.core.str("file:///"),cljs.core.str(path)].join('');
return cljs.core.subs.call(null,(new goog.Uri(uri_string)).getPath(),(1));
});
/**
 * A pair contains a pattern to match (either fully or partially) and an
 *   expression yielding a handler. The second parameter is a map
 *   containing state, including the remaining path.
 */
bidi.bidi.match_pair = (function bidi$bidi$match_pair(p__84934,orig_env){
var vec__84938 = p__84934;
var pattern = cljs.core.nth.call(null,vec__84938,(0),null);
var matched = cljs.core.nth.call(null,vec__84938,(1),null);
var env = cljs.core.update.call(null,orig_env,new cljs.core.Keyword(null,"remainder","remainder",1046186872),bidi.bidi.just_path);
var temp__6753__auto__ = bidi.bidi.match_pattern.call(null,pattern,env);
if(cljs.core.truth_(temp__6753__auto__)){
var match_result = temp__6753__auto__;
return bidi.bidi.resolve_handler.call(null,matched,cljs.core.merge.call(null,env,match_result));
} else {
return null;
}
});
/**
 * Match the beginning of the :remainder value in m. If matched, update
 *   the :remainder value in m with the path that remains after matching.
 */
bidi.bidi.match_beginning = (function bidi$bidi$match_beginning(regex_pattern,env){
var temp__6753__auto__ = cljs.core.last.call(null,cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str(regex_pattern),cljs.core.str("(.*)")].join('')),new cljs.core.Keyword(null,"remainder","remainder",1046186872).cljs$core$IFn$_invoke$arity$1(env)));
if(cljs.core.truth_(temp__6753__auto__)){
var path = temp__6753__auto__;
return cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"remainder","remainder",1046186872),path);
} else {
return null;
}
});
bidi.bidi.succeed = (function bidi$bidi$succeed(handler,m){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"remainder","remainder",1046186872).cljs$core$IFn$_invoke$arity$1(m),"")){
return cljs.core.merge.call(null,cljs.core.dissoc.call(null,m,new cljs.core.Keyword(null,"remainder","remainder",1046186872)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
} else {
return null;
}
});
(bidi.bidi.Pattern["string"] = true);

(bidi.bidi.match_pattern["string"] = (function (this$,env){
return bidi.bidi.match_beginning.call(null,[cljs.core.str("("),cljs.core.str(bidi.bidi.segment_regex_group.call(null,this$)),cljs.core.str(")")].join(''),env);
}));

(bidi.bidi.unmatch_pattern["string"] = (function (this$,_){
return this$;
}));


RegExp.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


RegExp.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,env){
var this$__$1 = this;
return bidi.bidi.match_beginning.call(null,[cljs.core.str("("),cljs.core.str(bidi.bidi.segment_regex_group.call(null,this$__$1)),cljs.core.str(")")].join(''),env);
});


RegExp.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (this$,m){
var this$__$1 = this;
var p = this$__$1.pattern();
return bidi.bidi.unmatch_pattern.call(null,clojure.string.replace.call(null,p,/\\\\/,""),m);
});

(bidi.bidi.Pattern["boolean"] = true);

(bidi.bidi.match_pattern["boolean"] = (function (this$,env){
if(this$){
return cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"remainder","remainder",1046186872),"");
} else {
return null;
}
}));

(bidi.bidi.unmatch_pattern["boolean"] = (function (this$,_){
if(this$){
return "";
} else {
return null;
}
}));


cljs.core.PersistentVector.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentVector.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,env){
var this$__$1 = this;
var temp__6753__auto__ = (function (){var _PERCENT_ = this$__$1;
var _PERCENT___$1 = cljs.core.map.call(null,bidi.bidi.segment_regex_group,_PERCENT_);
var _PERCENT___$2 = cljs.core.map.call(null,((function (_PERCENT_,_PERCENT___$1,this$__$1){
return (function (x){
return [cljs.core.str("("),cljs.core.str(x),cljs.core.str(")")].join('');
});})(_PERCENT_,_PERCENT___$1,this$__$1))
,_PERCENT___$1);
var _PERCENT___$3 = cljs.core.reduce.call(null,cljs.core.str,_PERCENT___$2);
var _PERCENT___$4 = [cljs.core.str(_PERCENT___$3),cljs.core.str("(.*)")].join('');
var _PERCENT___$5 = cljs.core.re_pattern.call(null,_PERCENT___$4);
var _PERCENT___$6 = cljs.core.re_matches.call(null,_PERCENT___$5,new cljs.core.Keyword(null,"remainder","remainder",1046186872).cljs$core$IFn$_invoke$arity$1(env));
return cljs.core.next.call(null,_PERCENT___$6);
})();
if(temp__6753__auto__){
var groups = temp__6753__auto__;
var params = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.first,cljs.core.map.call(null,cljs.core.vector,cljs.core.map.call(null,bidi.bidi.param_key,this$__$1),cljs.core.map.call(null,cljs.core.apply,cljs.core.map.call(null,bidi.bidi.transform_param,this$__$1),cljs.core.map.call(null,cljs.core.list,cljs.core.butlast.call(null,groups))))));
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remainder","remainder",1046186872)], null),cljs.core.last.call(null,groups)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"route-params","route-params",2111411055)], null),cljs.core.merge,params);
} else {
return null;
}
});


cljs.core.PersistentVector.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,((function (this$__$1){
return (function (p1__84941_SHARP_){
return bidi.bidi.unmatch_segment.call(null,p1__84941_SHARP_,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(m));
});})(this$__$1))
,this$__$1));
});


cljs.core.Keyword.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,env){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,this$__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(env))){
return env;
} else {
return null;
}
});


cljs.core.Keyword.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (_,___$1){
var ___$2 = this;
return "";
});


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,env){
var this$__$1 = this;
if(cljs.core.every_QMARK_.call(null,((function (this$__$1){
return (function (p__84944){
var vec__84945 = p__84944;
var k = cljs.core.nth.call(null,vec__84945,(0),null);
var v = cljs.core.nth.call(null,vec__84945,(1),null);
if((cljs.core.fn_QMARK_.call(null,v)) || (cljs.core.set_QMARK_.call(null,v))){
return v.call(null,cljs.core.get.call(null,env,k));
} else {
return cljs.core._EQ_.call(null,v,cljs.core.get.call(null,env,k));

}
});})(this$__$1))
,cljs.core.seq.call(null,this$__$1))){
return env;
} else {
return null;
}
});


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (_,___$1){
var ___$2 = this;
return "";
});


cljs.core.PersistentHashMap.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashMap.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,env){
var this$__$1 = this;
if(cljs.core.every_QMARK_.call(null,((function (this$__$1){
return (function (p__84948){
var vec__84949 = p__84948;
var k = cljs.core.nth.call(null,vec__84949,(0),null);
var v = cljs.core.nth.call(null,vec__84949,(1),null);
if((cljs.core.fn_QMARK_.call(null,v)) || (cljs.core.set_QMARK_.call(null,v))){
return v.call(null,cljs.core.get.call(null,env,k));
} else {
return cljs.core._EQ_.call(null,v,cljs.core.get.call(null,env,k));

}
});})(this$__$1))
,cljs.core.seq.call(null,this$__$1))){
return env;
} else {
return null;
}
});


cljs.core.PersistentHashMap.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (_,___$1){
var ___$2 = this;
return "";
});


cljs.core.PersistentHashSet.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,s){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84942_SHARP_){
return bidi.bidi.match_pattern.call(null,p1__84942_SHARP_,s);
});})(this$__$1))
,cljs.core.sort_by.call(null,cljs.core.count,cljs.core._GT_,this$__$1));
});


cljs.core.PersistentHashSet.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (this$,s){
var this$__$1 = this;
return bidi.bidi.unmatch_pattern.call(null,cljs.core.first.call(null,this$__$1),s);
});


cljs.core.PersistentTreeSet.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentTreeSet.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,s){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84943_SHARP_){
return bidi.bidi.match_pattern.call(null,p1__84943_SHARP_,s);
});})(this$__$1))
,cljs.core.sort_by.call(null,cljs.core.count,cljs.core._GT_,this$__$1));
});


cljs.core.PersistentTreeSet.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (this$,s){
var this$__$1 = this;
return bidi.bidi.unmatch_pattern.call(null,cljs.core.first.call(null,this$__$1),s);
});
bidi.bidi.unmatch_pair = (function bidi$bidi$unmatch_pair(v,m){
var temp__6753__auto__ = bidi.bidi.unresolve_handler.call(null,cljs.core.second.call(null,v),m);
if(cljs.core.truth_(temp__6753__auto__)){
var r = temp__6753__auto__;
return [cljs.core.str(bidi.bidi.unmatch_pattern.call(null,cljs.core.first.call(null,v),m)),cljs.core.str(r)].join('');
} else {
return null;
}
});
(bidi.bidi.Matched["null"] = true);

(bidi.bidi.resolve_handler["null"] = (function (this$,m){
return null;
}));

(bidi.bidi.unresolve_handler["null"] = (function (this$,m){
return null;
}));


cljs.core.PersistentVector.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentVector.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84952_SHARP_){
return bidi.bidi.match_pair.call(null,p1__84952_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentVector.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84953_SHARP_){
return bidi.bidi.unmatch_pair.call(null,p1__84953_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84956_SHARP_){
return bidi.bidi.match_pair.call(null,p1__84956_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentArrayMap.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84957_SHARP_){
return bidi.bidi.unmatch_pair.call(null,p1__84957_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.List.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.List.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84954_SHARP_){
return bidi.bidi.match_pair.call(null,p1__84954_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.List.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84955_SHARP_){
return bidi.bidi.unmatch_pair.call(null,p1__84955_SHARP_,m);
});})(this$__$1))
,this$__$1);
});

(bidi.bidi.Matched["string"] = true);

(bidi.bidi.unresolve_handler["string"] = (function (_,___$1){
return null;
}));


cljs.core.Symbol.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Symbol.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return bidi.bidi.succeed.call(null,this$__$1,m);
});


cljs.core.Symbol.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,this$__$1,new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m))){
return "";
} else {
return null;
}
});

(bidi.bidi.Matched["function"] = true);

(bidi.bidi.resolve_handler["function"] = (function (this$,m){
return bidi.bidi.succeed.call(null,this$,m);
}));

(bidi.bidi.unresolve_handler["function"] = (function (this$,m){
if(cljs.core._EQ_.call(null,this$,new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m))){
return "";
} else {
return null;
}
}));


cljs.core.PersistentHashMap.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashMap.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84958_SHARP_){
return bidi.bidi.match_pair.call(null,p1__84958_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentHashMap.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84959_SHARP_){
return bidi.bidi.unmatch_pair.call(null,p1__84959_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.LazySeq.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.LazySeq.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84960_SHARP_){
return bidi.bidi.match_pair.call(null,p1__84960_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.LazySeq.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__84961_SHARP_){
return bidi.bidi.unmatch_pair.call(null,p1__84961_SHARP_,m);
});})(this$__$1))
,this$__$1);
});


cljs.core.Keyword.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
return bidi.bidi.succeed.call(null,this$__$1,m);
});


cljs.core.Keyword.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,this$__$1,new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m))){
return "";
} else {
return null;
}
});
bidi.bidi.match_route_STAR_ = (function bidi$bidi$match_route_STAR_(route,path,options){
return cljs.core.dissoc.call(null,bidi.bidi.match_pair.call(null,route,cljs.core.assoc.call(null,options,new cljs.core.Keyword(null,"remainder","remainder",1046186872),path,new cljs.core.Keyword(null,"route","route",329891309),route)),new cljs.core.Keyword(null,"route","route",329891309));
});
/**
 * Given a route definition data structure and a path, return the
 *   handler, if any, that matches the path.
 */
bidi.bidi.match_route = (function bidi$bidi$match_route(var_args){
var args__28503__auto__ = [];
var len__28496__auto___84968 = arguments.length;
var i__28497__auto___84969 = (0);
while(true){
if((i__28497__auto___84969 < len__28496__auto___84968)){
args__28503__auto__.push((arguments[i__28497__auto___84969]));

var G__84970 = (i__28497__auto___84969 + (1));
i__28497__auto___84969 = G__84970;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return bidi.bidi.match_route.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

bidi.bidi.match_route.cljs$core$IFn$_invoke$arity$variadic = (function (route,path,p__84965){
var map__84966 = p__84965;
var map__84966__$1 = ((((!((map__84966 == null)))?((((map__84966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__84966.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__84966):map__84966);
var options = map__84966__$1;
return bidi.bidi.match_route_STAR_.call(null,route,path,options);
});

bidi.bidi.match_route.cljs$lang$maxFixedArity = (2);

bidi.bidi.match_route.cljs$lang$applyTo = (function (seq84962){
var G__84963 = cljs.core.first.call(null,seq84962);
var seq84962__$1 = cljs.core.next.call(null,seq84962);
var G__84964 = cljs.core.first.call(null,seq84962__$1);
var seq84962__$2 = cljs.core.next.call(null,seq84962__$1);
return bidi.bidi.match_route.cljs$core$IFn$_invoke$arity$variadic(G__84963,G__84964,seq84962__$2);
});

/**
 * Given a route definition data structure, a handler and an option map, return a
 *   path that would route to the handler. The map must contain the values to any
 *   parameters required to create the path, and extra values are silently ignored.
 */
bidi.bidi.path_for = (function bidi$bidi$path_for(var_args){
var args__28503__auto__ = [];
var len__28496__auto___84977 = arguments.length;
var i__28497__auto___84978 = (0);
while(true){
if((i__28497__auto___84978 < len__28496__auto___84977)){
args__28503__auto__.push((arguments[i__28497__auto___84978]));

var G__84979 = (i__28497__auto___84978 + (1));
i__28497__auto___84978 = G__84979;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return bidi.bidi.path_for.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

bidi.bidi.path_for.cljs$core$IFn$_invoke$arity$variadic = (function (route,handler,p__84974){
var map__84975 = p__84974;
var map__84975__$1 = ((((!((map__84975 == null)))?((((map__84975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__84975.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__84975):map__84975);
var params = map__84975__$1;
if((handler == null)){
throw cljs.core.ex_info.call(null,"Cannot form URI from a nil handler",cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return bidi.bidi.unmatch_pair.call(null,route,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"handler","handler",-195596612),handler,new cljs.core.Keyword(null,"params","params",710516235),params], null));
});

bidi.bidi.path_for.cljs$lang$maxFixedArity = (2);

bidi.bidi.path_for.cljs$lang$applyTo = (function (seq84971){
var G__84972 = cljs.core.first.call(null,seq84971);
var seq84971__$1 = cljs.core.next.call(null,seq84971);
var G__84973 = cljs.core.first.call(null,seq84971__$1);
var seq84971__$2 = cljs.core.next.call(null,seq84971__$1);
return bidi.bidi.path_for.cljs$core$IFn$_invoke$arity$variadic(G__84972,G__84973,seq84971__$2);
});


/**
 * @interface
 */
bidi.bidi.Matches = function(){};

/**
 * A protocol used in the expansion of possible matches that the pattern can match. This is used to gather all possible routes using route-seq below.
 */
bidi.bidi.matches = (function bidi$bidi$matches(_){
if((!((_ == null))) && (!((_.bidi$bidi$Matches$matches$arity$1 == null)))){
return _.bidi$bidi$Matches$matches$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.matches[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.matches["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Matches.matches",_);
}
}
}
});

(bidi.bidi.Matches["_"] = true);

(bidi.bidi.matches["_"] = (function (this$){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null);
}));


cljs.core.PersistentHashSet.prototype.bidi$bidi$Matches$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.bidi$bidi$Matches$matches$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});


cljs.core.PersistentTreeSet.prototype.bidi$bidi$Matches$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentTreeSet.prototype.bidi$bidi$Matches$matches$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bidi.bidi.Route = (function (handler,path,__meta,__extmap,__hash){
this.handler = handler;
this.path = path;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

bidi.bidi.Route.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


bidi.bidi.Route.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k84981,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__84983 = (((k84981 instanceof cljs.core.Keyword))?k84981.fqn:null);
switch (G__84983) {
case "handler":
return self__.handler;

break;
case "path":
return self__.path;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k84981,else__27953__auto__);

}
});


bidi.bidi.Route.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#bidi.bidi.Route{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


bidi.bidi.Route.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.Route.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__84980){
var self__ = this;
var G__84980__$1 = this;
return (new cljs.core.RecordIter((0),G__84980__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"path","path",-188191168)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


bidi.bidi.Route.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


bidi.bidi.Route.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new bidi.bidi.Route(self__.handler,self__.path,self__.__meta,self__.__extmap,self__.__hash));
});


bidi.bidi.Route.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


bidi.bidi.Route.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


bidi.bidi.Route.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


bidi.bidi.Route.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new bidi.bidi.Route(self__.handler,self__.path,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


bidi.bidi.Route.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__84980){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__84984 = cljs.core.keyword_identical_QMARK_;
var expr__84985 = k__27958__auto__;
if(cljs.core.truth_(pred__84984.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__84985))){
return (new bidi.bidi.Route(G__84980,self__.path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__84984.call(null,new cljs.core.Keyword(null,"path","path",-188191168),expr__84985))){
return (new bidi.bidi.Route(self__.handler,G__84980,self__.__meta,self__.__extmap,null));
} else {
return (new bidi.bidi.Route(self__.handler,self__.path,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__84980),null));
}
}
});


bidi.bidi.Route.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


bidi.bidi.Route.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__84980){
var self__ = this;
var this__27949__auto____$1 = this;
return (new bidi.bidi.Route(self__.handler,self__.path,G__84980,self__.__extmap,self__.__hash));
});


bidi.bidi.Route.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

bidi.bidi.Route.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null);
});

bidi.bidi.Route.cljs$lang$type = true;

bidi.bidi.Route.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bidi.bidi/Route");
});

bidi.bidi.Route.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"bidi.bidi/Route");
});

bidi.bidi.__GT_Route = (function bidi$bidi$__GT_Route(handler,path){
return (new bidi.bidi.Route(handler,path,null,null,null));
});

bidi.bidi.map__GT_Route = (function bidi$bidi$map__GT_Route(G__84982){
return (new bidi.bidi.Route(new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__84982),new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(G__84982),null,cljs.core.dissoc.call(null,G__84982,new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"path","path",-188191168)),null));
});


/**
 * @interface
 */
bidi.bidi.RouteSeq = function(){};

/**
 * Return a sequence of leaves
 */
bidi.bidi.gather = (function bidi$bidi$gather(_,context){
if((!((_ == null))) && (!((_.bidi$bidi$RouteSeq$gather$arity$2 == null)))){
return _.bidi$bidi$RouteSeq$gather$arity$2(_,context);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.gather[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_,context);
} else {
var m__27994__auto____$1 = (bidi.bidi.gather["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_,context);
} else {
throw cljs.core.missing_protocol.call(null,"RouteSeq.gather",_);
}
}
}
});

bidi.bidi.route_seq = (function bidi$bidi$route_seq(var_args){
var args84988 = [];
var len__28496__auto___84999 = arguments.length;
var i__28497__auto___85000 = (0);
while(true){
if((i__28497__auto___85000 < len__28496__auto___84999)){
args84988.push((arguments[i__28497__auto___85000]));

var G__85001 = (i__28497__auto___85000 + (1));
i__28497__auto___85000 = G__85001;
continue;
} else {
}
break;
}

var G__84990 = args84988.length;
switch (G__84990) {
case 2:
return bidi.bidi.route_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return bidi.bidi.route_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args84988.length)].join('')));

}
});

bidi.bidi.route_seq.cljs$core$IFn$_invoke$arity$2 = (function (p__84991,ctx){
var vec__84992 = p__84991;
var pattern = cljs.core.nth.call(null,vec__84992,(0),null);
var matched = cljs.core.nth.call(null,vec__84992,(1),null);
return cljs.core.mapcat.call(null,cljs.core.identity,(function (){var iter__28137__auto__ = ((function (vec__84992,pattern,matched){
return (function bidi$bidi$iter__84995(s__84996){
return (new cljs.core.LazySeq(null,((function (vec__84992,pattern,matched){
return (function (){
var s__84996__$1 = s__84996;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__84996__$1);
if(temp__6753__auto__){
var s__84996__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__84996__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__84996__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__84998 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__84997 = (0);
while(true){
if((i__84997 < size__28136__auto__)){
var p = cljs.core._nth.call(null,c__28135__auto__,i__84997);
cljs.core.chunk_append.call(null,b__84998,bidi.bidi.gather.call(null,matched,cljs.core.update_in.call(null,ctx,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),p)));

var G__85003 = (i__84997 + (1));
i__84997 = G__85003;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__84998),bidi$bidi$iter__84995.call(null,cljs.core.chunk_rest.call(null,s__84996__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__84998),null);
}
} else {
var p = cljs.core.first.call(null,s__84996__$2);
return cljs.core.cons.call(null,bidi.bidi.gather.call(null,matched,cljs.core.update_in.call(null,ctx,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),p)),bidi$bidi$iter__84995.call(null,cljs.core.rest.call(null,s__84996__$2)));
}
} else {
return null;
}
break;
}
});})(vec__84992,pattern,matched))
,null,null));
});})(vec__84992,pattern,matched))
;
return iter__28137__auto__.call(null,bidi.bidi.matches.call(null,pattern));
})());
});

bidi.bidi.route_seq.cljs$core$IFn$_invoke$arity$1 = (function (route){
return bidi.bidi.route_seq.call(null,route,cljs.core.PersistentArrayMap.EMPTY);
});

bidi.bidi.route_seq.cljs$lang$maxFixedArity = 2;


cljs.core.PersistentVector.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentVector.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var this$__$1 = this;
return cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p1__85004_SHARP_){
return bidi.bidi.route_seq.call(null,p1__85004_SHARP_,context);
});})(this$__$1))
,this$__$1);
});


cljs.core.List.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.List.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var this$__$1 = this;
return cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p1__85005_SHARP_){
return bidi.bidi.route_seq.call(null,p1__85005_SHARP_,context);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentArrayMap.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentArrayMap.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var this$__$1 = this;
return cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p1__85006_SHARP_){
return bidi.bidi.route_seq.call(null,p1__85006_SHARP_,context);
});})(this$__$1))
,this$__$1);
});


cljs.core.PersistentHashMap.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashMap.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var this$__$1 = this;
return cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p1__85007_SHARP_){
return bidi.bidi.route_seq.call(null,p1__85007_SHARP_,context);
});})(this$__$1))
,this$__$1);
});


cljs.core.LazySeq.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.LazySeq.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var this$__$1 = this;
return cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p1__85008_SHARP_){
return bidi.bidi.route_seq.call(null,p1__85008_SHARP_,context);
});})(this$__$1))
,this$__$1);
});

(bidi.bidi.RouteSeq["_"] = true);

(bidi.bidi.gather["_"] = (function (this$,context){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bidi.bidi.map__GT_Route.call(null,cljs.core.assoc.call(null,context,new cljs.core.Keyword(null,"handler","handler",-195596612),this$))], null);
}));

/**
 * @interface
 */
bidi.bidi.RouteProvider = function(){};

/**
 * Provide a bidi route structure. Returns a vector pair,
 *   the first element is the pattern, the second element is the matched
 *   route or routes.
 */
bidi.bidi.routes = (function bidi$bidi$routes(_){
if((!((_ == null))) && (!((_.bidi$bidi$RouteProvider$routes$arity$1 == null)))){
return _.bidi$bidi$RouteProvider$routes$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (bidi.bidi.routes[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (bidi.bidi.routes["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"RouteProvider.routes",_);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {bidi.bidi.Matches}
 * @implements {cljs.core.ICounted}
 * @implements {bidi.bidi.Pattern}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bidi.bidi.Alternates = (function (alts,__meta,__extmap,__hash){
this.alts = alts;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

bidi.bidi.Alternates.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


bidi.bidi.Alternates.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k85011,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__85013 = (((k85011 instanceof cljs.core.Keyword))?k85011.fqn:null);
switch (G__85013) {
case "alts":
return self__.alts;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k85011,else__27953__auto__);

}
});


bidi.bidi.Alternates.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#bidi.bidi.Alternates{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"alts","alts",647552416),self__.alts],null))], null),self__.__extmap));
});


bidi.bidi.Alternates.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.Alternates.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85010){
var self__ = this;
var G__85010__$1 = this;
return (new cljs.core.RecordIter((0),G__85010__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alts","alts",647552416)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


bidi.bidi.Alternates.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


bidi.bidi.Alternates.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new bidi.bidi.Alternates(self__.alts,self__.__meta,self__.__extmap,self__.__hash));
});


bidi.bidi.Alternates.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});


bidi.bidi.Alternates.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


bidi.bidi.Alternates.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


bidi.bidi.Alternates.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"alts","alts",647552416),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new bidi.bidi.Alternates(self__.alts,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


bidi.bidi.Alternates.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__85010){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__85014 = cljs.core.keyword_identical_QMARK_;
var expr__85015 = k__27958__auto__;
if(cljs.core.truth_(pred__85014.call(null,new cljs.core.Keyword(null,"alts","alts",647552416),expr__85015))){
return (new bidi.bidi.Alternates(G__85010,self__.__meta,self__.__extmap,null));
} else {
return (new bidi.bidi.Alternates(self__.alts,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__85010),null));
}
});


bidi.bidi.Alternates.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"alts","alts",647552416),self__.alts],null))], null),self__.__extmap));
});


bidi.bidi.Alternates.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__85010){
var self__ = this;
var this__27949__auto____$1 = this;
return (new bidi.bidi.Alternates(self__.alts,G__85010,self__.__extmap,self__.__hash));
});


bidi.bidi.Alternates.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});


bidi.bidi.Alternates.prototype.bidi$bidi$Matches$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.Alternates.prototype.bidi$bidi$Matches$matches$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.alts;
});


bidi.bidi.Alternates.prototype.bidi$bidi$Pattern$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.Alternates.prototype.bidi$bidi$Pattern$match_pattern$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
return cljs.core.some.call(null,((function (this$__$1){
return (function (p1__85009_SHARP_){
return bidi.bidi.match_pattern.call(null,p1__85009_SHARP_,m);
});})(this$__$1))
,cljs.core.sort_by.call(null,cljs.core.count,cljs.core._GT_,self__.alts));
});


bidi.bidi.Alternates.prototype.bidi$bidi$Pattern$unmatch_pattern$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
return bidi.bidi.unmatch_pattern.call(null,cljs.core.first.call(null,self__.alts),m);
});

bidi.bidi.Alternates.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"alts","alts",-2006883353,null)], null);
});

bidi.bidi.Alternates.cljs$lang$type = true;

bidi.bidi.Alternates.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bidi.bidi/Alternates");
});

bidi.bidi.Alternates.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"bidi.bidi/Alternates");
});

bidi.bidi.__GT_Alternates = (function bidi$bidi$__GT_Alternates(alts){
return (new bidi.bidi.Alternates(alts,null,null,null));
});

bidi.bidi.map__GT_Alternates = (function bidi$bidi$map__GT_Alternates(G__85012){
return (new bidi.bidi.Alternates(new cljs.core.Keyword(null,"alts","alts",647552416).cljs$core$IFn$_invoke$arity$1(G__85012),null,cljs.core.dissoc.call(null,G__85012,new cljs.core.Keyword(null,"alts","alts",647552416)),null));
});

bidi.bidi.alts = (function bidi$bidi$alts(var_args){
var args__28503__auto__ = [];
var len__28496__auto___85019 = arguments.length;
var i__28497__auto___85020 = (0);
while(true){
if((i__28497__auto___85020 < len__28496__auto___85019)){
args__28503__auto__.push((arguments[i__28497__auto___85020]));

var G__85021 = (i__28497__auto___85020 + (1));
i__28497__auto___85020 = G__85021;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return bidi.bidi.alts.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

bidi.bidi.alts.cljs$core$IFn$_invoke$arity$variadic = (function (alts){
return bidi.bidi.__GT_Alternates.call(null,alts);
});

bidi.bidi.alts.cljs$lang$maxFixedArity = (0);

bidi.bidi.alts.cljs$lang$applyTo = (function (seq85018){
return bidi.bidi.alts.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq85018));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {bidi.bidi.Matched}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {bidi.bidi.RouteSeq}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bidi.bidi.TaggedMatch = (function (matched,tag,__meta,__extmap,__hash){
this.matched = matched;
this.tag = tag;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

bidi.bidi.TaggedMatch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


bidi.bidi.TaggedMatch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k85023,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__85025 = (((k85023 instanceof cljs.core.Keyword))?k85023.fqn:null);
switch (G__85025) {
case "matched":
return self__.matched;

break;
case "tag":
return self__.tag;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k85023,else__27953__auto__);

}
});


bidi.bidi.TaggedMatch.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.TaggedMatch.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (this$,context){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bidi.bidi.map__GT_Route.call(null,cljs.core.assoc.call(null,context,new cljs.core.Keyword(null,"handler","handler",-195596612),self__.matched,new cljs.core.Keyword(null,"tag","tag",-1290361223),self__.tag))], null);
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#bidi.bidi.TaggedMatch{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"matched","matched",-975207164),self__.matched],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tag","tag",-1290361223),self__.tag],null))], null),self__.__extmap));
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.TaggedMatch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85022){
var self__ = this;
var G__85022__$1 = this;
return (new cljs.core.RecordIter((0),G__85022__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"matched","matched",-975207164),new cljs.core.Keyword(null,"tag","tag",-1290361223)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


bidi.bidi.TaggedMatch.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.TaggedMatch.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
return bidi.bidi.resolve_handler.call(null,self__.matched,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"tag","tag",-1290361223),self__.tag));
});


bidi.bidi.TaggedMatch.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
if((new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m) instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,self__.tag,new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m))){
return "";
} else {
return null;
}
} else {
return bidi.bidi.unresolve_handler.call(null,self__.matched,m);
}
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


bidi.bidi.TaggedMatch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new bidi.bidi.TaggedMatch(self__.matched,self__.tag,self__.__meta,self__.__extmap,self__.__hash));
});


bidi.bidi.TaggedMatch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"matched","matched",-975207164),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new bidi.bidi.TaggedMatch(self__.matched,self__.tag,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__85022){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__85026 = cljs.core.keyword_identical_QMARK_;
var expr__85027 = k__27958__auto__;
if(cljs.core.truth_(pred__85026.call(null,new cljs.core.Keyword(null,"matched","matched",-975207164),expr__85027))){
return (new bidi.bidi.TaggedMatch(G__85022,self__.tag,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85026.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),expr__85027))){
return (new bidi.bidi.TaggedMatch(self__.matched,G__85022,self__.__meta,self__.__extmap,null));
} else {
return (new bidi.bidi.TaggedMatch(self__.matched,self__.tag,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__85022),null));
}
}
});


bidi.bidi.TaggedMatch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"matched","matched",-975207164),self__.matched],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tag","tag",-1290361223),self__.tag],null))], null),self__.__extmap));
});


bidi.bidi.TaggedMatch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__85022){
var self__ = this;
var this__27949__auto____$1 = this;
return (new bidi.bidi.TaggedMatch(self__.matched,self__.tag,G__85022,self__.__extmap,self__.__hash));
});


bidi.bidi.TaggedMatch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

bidi.bidi.TaggedMatch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"matched","matched",665324363,null),new cljs.core.Symbol(null,"tag","tag",350170304,null)], null);
});

bidi.bidi.TaggedMatch.cljs$lang$type = true;

bidi.bidi.TaggedMatch.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bidi.bidi/TaggedMatch");
});

bidi.bidi.TaggedMatch.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"bidi.bidi/TaggedMatch");
});

bidi.bidi.__GT_TaggedMatch = (function bidi$bidi$__GT_TaggedMatch(matched,tag){
return (new bidi.bidi.TaggedMatch(matched,tag,null,null,null));
});

bidi.bidi.map__GT_TaggedMatch = (function bidi$bidi$map__GT_TaggedMatch(G__85024){
return (new bidi.bidi.TaggedMatch(new cljs.core.Keyword(null,"matched","matched",-975207164).cljs$core$IFn$_invoke$arity$1(G__85024),new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(G__85024),null,cljs.core.dissoc.call(null,G__85024,new cljs.core.Keyword(null,"matched","matched",-975207164),new cljs.core.Keyword(null,"tag","tag",-1290361223)),null));
});

bidi.bidi.tag = (function bidi$bidi$tag(matched,tag){
return bidi.bidi.__GT_TaggedMatch.call(null,matched,tag);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {bidi.bidi.Matched}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bidi.bidi.IdentifiableHandler = (function (id,handler,__meta,__extmap,__hash){
this.id = id;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

bidi.bidi.IdentifiableHandler.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k85031,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__85033 = (((k85031 instanceof cljs.core.Keyword))?k85031.fqn:null);
switch (G__85033) {
case "id":
return self__.id;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k85031,else__27953__auto__);

}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#bidi.bidi.IdentifiableHandler{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85030){
var self__ = this;
var G__85030__$1 = this;
return (new cljs.core.RecordIter((0),G__85030__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


bidi.bidi.IdentifiableHandler.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.IdentifiableHandler.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
return bidi.bidi.resolve_handler.call(null,self__.handler,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"id","id",-1388402092),self__.id));
});


bidi.bidi.IdentifiableHandler.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (this$,m){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.id)){
if(cljs.core._EQ_.call(null,self__.id,new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(m))){
return "";
} else {
return bidi.bidi.unresolve_handler.call(null,self__.handler,m);
}
} else {
return null;
}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new bidi.bidi.IdentifiableHandler(self__.id,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new bidi.bidi.IdentifiableHandler(self__.id,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__85030){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__85034 = cljs.core.keyword_identical_QMARK_;
var expr__85035 = k__27958__auto__;
if(cljs.core.truth_(pred__85034.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__85035))){
return (new bidi.bidi.IdentifiableHandler(G__85030,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85034.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__85035))){
return (new bidi.bidi.IdentifiableHandler(self__.id,G__85030,self__.__meta,self__.__extmap,null));
} else {
return (new bidi.bidi.IdentifiableHandler(self__.id,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__85030),null));
}
}
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__85030){
var self__ = this;
var this__27949__auto____$1 = this;
return (new bidi.bidi.IdentifiableHandler(self__.id,self__.handler,G__85030,self__.__extmap,self__.__hash));
});


bidi.bidi.IdentifiableHandler.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

bidi.bidi.IdentifiableHandler.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
});

bidi.bidi.IdentifiableHandler.cljs$lang$type = true;

bidi.bidi.IdentifiableHandler.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bidi.bidi/IdentifiableHandler");
});

bidi.bidi.IdentifiableHandler.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"bidi.bidi/IdentifiableHandler");
});

bidi.bidi.__GT_IdentifiableHandler = (function bidi$bidi$__GT_IdentifiableHandler(id,handler){
return (new bidi.bidi.IdentifiableHandler(id,handler,null,null,null));
});

bidi.bidi.map__GT_IdentifiableHandler = (function bidi$bidi$map__GT_IdentifiableHandler(G__85032){
return (new bidi.bidi.IdentifiableHandler(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__85032),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__85032),null,cljs.core.dissoc.call(null,G__85032,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"handler","handler",-195596612)),null));
});

bidi.bidi.handler = (function bidi$bidi$handler(var_args){
var args85038 = [];
var len__28496__auto___85041 = arguments.length;
var i__28497__auto___85042 = (0);
while(true){
if((i__28497__auto___85042 < len__28496__auto___85041)){
args85038.push((arguments[i__28497__auto___85042]));

var G__85043 = (i__28497__auto___85042 + (1));
i__28497__auto___85042 = G__85043;
continue;
} else {
}
break;
}

var G__85040 = args85038.length;
switch (G__85040) {
case 2:
return bidi.bidi.handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return bidi.bidi.handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args85038.length)].join('')));

}
});

bidi.bidi.handler.cljs$core$IFn$_invoke$arity$2 = (function (k,handler){
return bidi.bidi.__GT_IdentifiableHandler.call(null,k,handler);
});

bidi.bidi.handler.cljs$core$IFn$_invoke$arity$1 = (function (handler){
return bidi.bidi.__GT_IdentifiableHandler.call(null,null,handler);
});

bidi.bidi.handler.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {bidi.bidi.Matched}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {bidi.bidi.RouteSeq}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bidi.bidi.RoutesContext = (function (routes,context,__meta,__extmap,__hash){
this.routes = routes;
this.context = context;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

bidi.bidi.RoutesContext.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__27950__auto__,k__27951__auto__){
var self__ = this;
var this__27950__auto____$1 = this;
return cljs.core._lookup.call(null,this__27950__auto____$1,k__27951__auto__,null);
});


bidi.bidi.RoutesContext.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__27952__auto__,k85046,else__27953__auto__){
var self__ = this;
var this__27952__auto____$1 = this;
var G__85048 = (((k85046 instanceof cljs.core.Keyword))?k85046.fqn:null);
switch (G__85048) {
case "routes":
return self__.routes;

break;
case "context":
return self__.context;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k85046,else__27953__auto__);

}
});


bidi.bidi.RoutesContext.prototype.bidi$bidi$RouteSeq$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.RoutesContext.prototype.bidi$bidi$RouteSeq$gather$arity$2 = (function (_,context__$1){
var self__ = this;
var ___$1 = this;
return bidi.bidi.gather.call(null,self__.routes,context__$1);
});


bidi.bidi.RoutesContext.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__27964__auto__,writer__27965__auto__,opts__27966__auto__){
var self__ = this;
var this__27964__auto____$1 = this;
var pr_pair__27967__auto__ = ((function (this__27964__auto____$1){
return (function (keyval__27968__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,cljs.core.pr_writer,""," ","",opts__27966__auto__,keyval__27968__auto__);
});})(this__27964__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__27965__auto__,pr_pair__27967__auto__,"#bidi.bidi.RoutesContext{",", ","}",opts__27966__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"routes","routes",457900162),self__.routes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"context","context",-830191113),self__.context],null))], null),self__.__extmap));
});


bidi.bidi.RoutesContext.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.RoutesContext.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85045){
var self__ = this;
var G__85045__$1 = this;
return (new cljs.core.RecordIter((0),G__85045__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"routes","routes",457900162),new cljs.core.Keyword(null,"context","context",-830191113)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


bidi.bidi.RoutesContext.prototype.bidi$bidi$Matched$ = cljs.core.PROTOCOL_SENTINEL;


bidi.bidi.RoutesContext.prototype.bidi$bidi$Matched$resolve_handler$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
var temp__6753__auto__ = bidi.bidi.resolve_handler.call(null,self__.routes,m);
if(cljs.core.truth_(temp__6753__auto__)){
var m__$1 = temp__6753__auto__;
return cljs.core.merge.call(null,self__.context,m__$1);
} else {
return null;
}
});


bidi.bidi.RoutesContext.prototype.bidi$bidi$Matched$unresolve_handler$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return bidi.bidi.unresolve_handler.call(null,self__.routes,m);
});


bidi.bidi.RoutesContext.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__27948__auto__){
var self__ = this;
var this__27948__auto____$1 = this;
return self__.__meta;
});


bidi.bidi.RoutesContext.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__27944__auto__){
var self__ = this;
var this__27944__auto____$1 = this;
return (new bidi.bidi.RoutesContext(self__.routes,self__.context,self__.__meta,self__.__extmap,self__.__hash));
});


bidi.bidi.RoutesContext.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__27954__auto__){
var self__ = this;
var this__27954__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


bidi.bidi.RoutesContext.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__27945__auto__){
var self__ = this;
var this__27945__auto____$1 = this;
var h__27717__auto__ = self__.__hash;
if(!((h__27717__auto__ == null))){
return h__27717__auto__;
} else {
var h__27717__auto____$1 = cljs.core.hash_imap.call(null,this__27945__auto____$1);
self__.__hash = h__27717__auto____$1;

return h__27717__auto____$1;
}
});


bidi.bidi.RoutesContext.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__27946__auto__,other__27947__auto__){
var self__ = this;
var this__27946__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27268__auto__ = other__27947__auto__;
if(cljs.core.truth_(and__27268__auto__)){
var and__27268__auto____$1 = (this__27946__auto____$1.constructor === other__27947__auto__.constructor);
if(and__27268__auto____$1){
return cljs.core.equiv_map.call(null,this__27946__auto____$1,other__27947__auto__);
} else {
return and__27268__auto____$1;
}
} else {
return and__27268__auto__;
}
})())){
return true;
} else {
return false;
}
});


bidi.bidi.RoutesContext.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__27959__auto__,k__27960__auto__){
var self__ = this;
var this__27959__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"routes","routes",457900162),null,new cljs.core.Keyword(null,"context","context",-830191113),null], null), null),k__27960__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__27959__auto____$1),self__.__meta),k__27960__auto__);
} else {
return (new bidi.bidi.RoutesContext(self__.routes,self__.context,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__27960__auto__)),null));
}
});


bidi.bidi.RoutesContext.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__27957__auto__,k__27958__auto__,G__85045){
var self__ = this;
var this__27957__auto____$1 = this;
var pred__85049 = cljs.core.keyword_identical_QMARK_;
var expr__85050 = k__27958__auto__;
if(cljs.core.truth_(pred__85049.call(null,new cljs.core.Keyword(null,"routes","routes",457900162),expr__85050))){
return (new bidi.bidi.RoutesContext(G__85045,self__.context,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85049.call(null,new cljs.core.Keyword(null,"context","context",-830191113),expr__85050))){
return (new bidi.bidi.RoutesContext(self__.routes,G__85045,self__.__meta,self__.__extmap,null));
} else {
return (new bidi.bidi.RoutesContext(self__.routes,self__.context,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__27958__auto__,G__85045),null));
}
}
});


bidi.bidi.RoutesContext.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__27962__auto__){
var self__ = this;
var this__27962__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"routes","routes",457900162),self__.routes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"context","context",-830191113),self__.context],null))], null),self__.__extmap));
});


bidi.bidi.RoutesContext.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__27949__auto__,G__85045){
var self__ = this;
var this__27949__auto____$1 = this;
return (new bidi.bidi.RoutesContext(self__.routes,self__.context,G__85045,self__.__extmap,self__.__hash));
});


bidi.bidi.RoutesContext.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__27955__auto__,entry__27956__auto__){
var self__ = this;
var this__27955__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__27956__auto__)){
return cljs.core._assoc.call(null,this__27955__auto____$1,cljs.core._nth.call(null,entry__27956__auto__,(0)),cljs.core._nth.call(null,entry__27956__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__27955__auto____$1,entry__27956__auto__);
}
});

bidi.bidi.RoutesContext.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"routes","routes",2098431689,null),new cljs.core.Symbol(null,"context","context",810340414,null)], null);
});

bidi.bidi.RoutesContext.cljs$lang$type = true;

bidi.bidi.RoutesContext.cljs$lang$ctorPrSeq = (function (this__27986__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bidi.bidi/RoutesContext");
});

bidi.bidi.RoutesContext.cljs$lang$ctorPrWriter = (function (this__27986__auto__,writer__27987__auto__){
return cljs.core._write.call(null,writer__27987__auto__,"bidi.bidi/RoutesContext");
});

bidi.bidi.__GT_RoutesContext = (function bidi$bidi$__GT_RoutesContext(routes,context){
return (new bidi.bidi.RoutesContext(routes,context,null,null,null));
});

bidi.bidi.map__GT_RoutesContext = (function bidi$bidi$map__GT_RoutesContext(G__85047){
return (new bidi.bidi.RoutesContext(new cljs.core.Keyword(null,"routes","routes",457900162).cljs$core$IFn$_invoke$arity$1(G__85047),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(G__85047),null,cljs.core.dissoc.call(null,G__85047,new cljs.core.Keyword(null,"routes","routes",457900162),new cljs.core.Keyword(null,"context","context",-830191113)),null));
});

/**
 * Wrap a Matched such that a successful match will merge the given
 *   context with the match-context. The merge is such that where there
 *   is a conflict, the inner sub-tree overrides the outer container.
 */
bidi.bidi.routes_context = (function bidi$bidi$routes_context(routes,context){
return bidi.bidi.__GT_RoutesContext.call(null,routes,context);
});
bidi.bidi.compile_route = (function bidi$bidi$compile_route(route){
return route;
});

//# sourceMappingURL=bidi.js.map?rel=1483479066643