// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27280__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27280__auto__){
return or__27280__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27280__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__98801_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__98801_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__98806 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__98807 = null;
var count__98808 = (0);
var i__98809 = (0);
while(true){
if((i__98809 < count__98808)){
var n = cljs.core._nth.call(null,chunk__98807,i__98809);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__98810 = seq__98806;
var G__98811 = chunk__98807;
var G__98812 = count__98808;
var G__98813 = (i__98809 + (1));
seq__98806 = G__98810;
chunk__98807 = G__98811;
count__98808 = G__98812;
i__98809 = G__98813;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__98806);
if(temp__6753__auto__){
var seq__98806__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98806__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__98806__$1);
var G__98814 = cljs.core.chunk_rest.call(null,seq__98806__$1);
var G__98815 = c__28186__auto__;
var G__98816 = cljs.core.count.call(null,c__28186__auto__);
var G__98817 = (0);
seq__98806 = G__98814;
chunk__98807 = G__98815;
count__98808 = G__98816;
i__98809 = G__98817;
continue;
} else {
var n = cljs.core.first.call(null,seq__98806__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__98818 = cljs.core.next.call(null,seq__98806__$1);
var G__98819 = null;
var G__98820 = (0);
var G__98821 = (0);
seq__98806 = G__98818;
chunk__98807 = G__98819;
count__98808 = G__98820;
i__98809 = G__98821;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__98872_98883 = cljs.core.seq.call(null,deps);
var chunk__98873_98884 = null;
var count__98874_98885 = (0);
var i__98875_98886 = (0);
while(true){
if((i__98875_98886 < count__98874_98885)){
var dep_98887 = cljs.core._nth.call(null,chunk__98873_98884,i__98875_98886);
topo_sort_helper_STAR_.call(null,dep_98887,(depth + (1)),state);

var G__98888 = seq__98872_98883;
var G__98889 = chunk__98873_98884;
var G__98890 = count__98874_98885;
var G__98891 = (i__98875_98886 + (1));
seq__98872_98883 = G__98888;
chunk__98873_98884 = G__98889;
count__98874_98885 = G__98890;
i__98875_98886 = G__98891;
continue;
} else {
var temp__6753__auto___98892 = cljs.core.seq.call(null,seq__98872_98883);
if(temp__6753__auto___98892){
var seq__98872_98893__$1 = temp__6753__auto___98892;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98872_98893__$1)){
var c__28186__auto___98894 = cljs.core.chunk_first.call(null,seq__98872_98893__$1);
var G__98895 = cljs.core.chunk_rest.call(null,seq__98872_98893__$1);
var G__98896 = c__28186__auto___98894;
var G__98897 = cljs.core.count.call(null,c__28186__auto___98894);
var G__98898 = (0);
seq__98872_98883 = G__98895;
chunk__98873_98884 = G__98896;
count__98874_98885 = G__98897;
i__98875_98886 = G__98898;
continue;
} else {
var dep_98899 = cljs.core.first.call(null,seq__98872_98893__$1);
topo_sort_helper_STAR_.call(null,dep_98899,(depth + (1)),state);

var G__98900 = cljs.core.next.call(null,seq__98872_98893__$1);
var G__98901 = null;
var G__98902 = (0);
var G__98903 = (0);
seq__98872_98883 = G__98900;
chunk__98873_98884 = G__98901;
count__98874_98885 = G__98902;
i__98875_98886 = G__98903;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__98876){
var vec__98880 = p__98876;
var seq__98881 = cljs.core.seq.call(null,vec__98880);
var first__98882 = cljs.core.first.call(null,seq__98881);
var seq__98881__$1 = cljs.core.next.call(null,seq__98881);
var x = first__98882;
var xs = seq__98881__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__98880,seq__98881,first__98882,seq__98881__$1,x,xs,get_deps__$1){
return (function (p1__98822_SHARP_){
return clojure.set.difference.call(null,p1__98822_SHARP_,x);
});})(vec__98880,seq__98881,first__98882,seq__98881__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__98916 = cljs.core.seq.call(null,provides);
var chunk__98917 = null;
var count__98918 = (0);
var i__98919 = (0);
while(true){
if((i__98919 < count__98918)){
var prov = cljs.core._nth.call(null,chunk__98917,i__98919);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__98920_98928 = cljs.core.seq.call(null,requires);
var chunk__98921_98929 = null;
var count__98922_98930 = (0);
var i__98923_98931 = (0);
while(true){
if((i__98923_98931 < count__98922_98930)){
var req_98932 = cljs.core._nth.call(null,chunk__98921_98929,i__98923_98931);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_98932,prov);

var G__98933 = seq__98920_98928;
var G__98934 = chunk__98921_98929;
var G__98935 = count__98922_98930;
var G__98936 = (i__98923_98931 + (1));
seq__98920_98928 = G__98933;
chunk__98921_98929 = G__98934;
count__98922_98930 = G__98935;
i__98923_98931 = G__98936;
continue;
} else {
var temp__6753__auto___98937 = cljs.core.seq.call(null,seq__98920_98928);
if(temp__6753__auto___98937){
var seq__98920_98938__$1 = temp__6753__auto___98937;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98920_98938__$1)){
var c__28186__auto___98939 = cljs.core.chunk_first.call(null,seq__98920_98938__$1);
var G__98940 = cljs.core.chunk_rest.call(null,seq__98920_98938__$1);
var G__98941 = c__28186__auto___98939;
var G__98942 = cljs.core.count.call(null,c__28186__auto___98939);
var G__98943 = (0);
seq__98920_98928 = G__98940;
chunk__98921_98929 = G__98941;
count__98922_98930 = G__98942;
i__98923_98931 = G__98943;
continue;
} else {
var req_98944 = cljs.core.first.call(null,seq__98920_98938__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_98944,prov);

var G__98945 = cljs.core.next.call(null,seq__98920_98938__$1);
var G__98946 = null;
var G__98947 = (0);
var G__98948 = (0);
seq__98920_98928 = G__98945;
chunk__98921_98929 = G__98946;
count__98922_98930 = G__98947;
i__98923_98931 = G__98948;
continue;
}
} else {
}
}
break;
}

var G__98949 = seq__98916;
var G__98950 = chunk__98917;
var G__98951 = count__98918;
var G__98952 = (i__98919 + (1));
seq__98916 = G__98949;
chunk__98917 = G__98950;
count__98918 = G__98951;
i__98919 = G__98952;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__98916);
if(temp__6753__auto__){
var seq__98916__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98916__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__98916__$1);
var G__98953 = cljs.core.chunk_rest.call(null,seq__98916__$1);
var G__98954 = c__28186__auto__;
var G__98955 = cljs.core.count.call(null,c__28186__auto__);
var G__98956 = (0);
seq__98916 = G__98953;
chunk__98917 = G__98954;
count__98918 = G__98955;
i__98919 = G__98956;
continue;
} else {
var prov = cljs.core.first.call(null,seq__98916__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__98924_98957 = cljs.core.seq.call(null,requires);
var chunk__98925_98958 = null;
var count__98926_98959 = (0);
var i__98927_98960 = (0);
while(true){
if((i__98927_98960 < count__98926_98959)){
var req_98961 = cljs.core._nth.call(null,chunk__98925_98958,i__98927_98960);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_98961,prov);

var G__98962 = seq__98924_98957;
var G__98963 = chunk__98925_98958;
var G__98964 = count__98926_98959;
var G__98965 = (i__98927_98960 + (1));
seq__98924_98957 = G__98962;
chunk__98925_98958 = G__98963;
count__98926_98959 = G__98964;
i__98927_98960 = G__98965;
continue;
} else {
var temp__6753__auto___98966__$1 = cljs.core.seq.call(null,seq__98924_98957);
if(temp__6753__auto___98966__$1){
var seq__98924_98967__$1 = temp__6753__auto___98966__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98924_98967__$1)){
var c__28186__auto___98968 = cljs.core.chunk_first.call(null,seq__98924_98967__$1);
var G__98969 = cljs.core.chunk_rest.call(null,seq__98924_98967__$1);
var G__98970 = c__28186__auto___98968;
var G__98971 = cljs.core.count.call(null,c__28186__auto___98968);
var G__98972 = (0);
seq__98924_98957 = G__98969;
chunk__98925_98958 = G__98970;
count__98926_98959 = G__98971;
i__98927_98960 = G__98972;
continue;
} else {
var req_98973 = cljs.core.first.call(null,seq__98924_98967__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_98973,prov);

var G__98974 = cljs.core.next.call(null,seq__98924_98967__$1);
var G__98975 = null;
var G__98976 = (0);
var G__98977 = (0);
seq__98924_98957 = G__98974;
chunk__98925_98958 = G__98975;
count__98926_98959 = G__98976;
i__98927_98960 = G__98977;
continue;
}
} else {
}
}
break;
}

var G__98978 = cljs.core.next.call(null,seq__98916__$1);
var G__98979 = null;
var G__98980 = (0);
var G__98981 = (0);
seq__98916 = G__98978;
chunk__98917 = G__98979;
count__98918 = G__98980;
i__98919 = G__98981;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__98986_98990 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__98987_98991 = null;
var count__98988_98992 = (0);
var i__98989_98993 = (0);
while(true){
if((i__98989_98993 < count__98988_98992)){
var ns_98994 = cljs.core._nth.call(null,chunk__98987_98991,i__98989_98993);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_98994);

var G__98995 = seq__98986_98990;
var G__98996 = chunk__98987_98991;
var G__98997 = count__98988_98992;
var G__98998 = (i__98989_98993 + (1));
seq__98986_98990 = G__98995;
chunk__98987_98991 = G__98996;
count__98988_98992 = G__98997;
i__98989_98993 = G__98998;
continue;
} else {
var temp__6753__auto___98999 = cljs.core.seq.call(null,seq__98986_98990);
if(temp__6753__auto___98999){
var seq__98986_99000__$1 = temp__6753__auto___98999;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__98986_99000__$1)){
var c__28186__auto___99001 = cljs.core.chunk_first.call(null,seq__98986_99000__$1);
var G__99002 = cljs.core.chunk_rest.call(null,seq__98986_99000__$1);
var G__99003 = c__28186__auto___99001;
var G__99004 = cljs.core.count.call(null,c__28186__auto___99001);
var G__99005 = (0);
seq__98986_98990 = G__99002;
chunk__98987_98991 = G__99003;
count__98988_98992 = G__99004;
i__98989_98993 = G__99005;
continue;
} else {
var ns_99006 = cljs.core.first.call(null,seq__98986_99000__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_99006);

var G__99007 = cljs.core.next.call(null,seq__98986_99000__$1);
var G__99008 = null;
var G__99009 = (0);
var G__99010 = (0);
seq__98986_98990 = G__99007;
chunk__98987_98991 = G__99008;
count__98988_98992 = G__99009;
i__98989_98993 = G__99010;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27280__auto__ = goog.require__;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__99011__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__99011 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__99012__i = 0, G__99012__a = new Array(arguments.length -  0);
while (G__99012__i < G__99012__a.length) {G__99012__a[G__99012__i] = arguments[G__99012__i + 0]; ++G__99012__i;}
  args = new cljs.core.IndexedSeq(G__99012__a,0);
} 
return G__99011__delegate.call(this,args);};
G__99011.cljs$lang$maxFixedArity = 0;
G__99011.cljs$lang$applyTo = (function (arglist__99013){
var args = cljs.core.seq(arglist__99013);
return G__99011__delegate(args);
});
G__99011.cljs$core$IFn$_invoke$arity$variadic = G__99011__delegate;
return G__99011;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__99015 = cljs.core._EQ_;
var expr__99016 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__99015.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__99016))){
var path_parts = ((function (pred__99015,expr__99016){
return (function (p1__99014_SHARP_){
return clojure.string.split.call(null,p1__99014_SHARP_,/[\/\\]/);
});})(pred__99015,expr__99016))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__99015,expr__99016){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e99018){if((e99018 instanceof Error)){
var e = e99018;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e99018;

}
}})());
});
;})(path_parts,sep,root,pred__99015,expr__99016))
} else {
if(cljs.core.truth_(pred__99015.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__99016))){
return ((function (pred__99015,expr__99016){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__99015,expr__99016){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__99015,expr__99016))
);

return deferred.addErrback(((function (deferred,pred__99015,expr__99016){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__99015,expr__99016))
);
});
;})(pred__99015,expr__99016))
} else {
return ((function (pred__99015,expr__99016){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__99015,expr__99016))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__99019,callback){
var map__99022 = p__99019;
var map__99022__$1 = ((((!((map__99022 == null)))?((((map__99022.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99022.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99022):map__99022);
var file_msg = map__99022__$1;
var request_url = cljs.core.get.call(null,map__99022__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__99022,map__99022__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__99022,map__99022__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__){
return (function (state_99046){
var state_val_99047 = (state_99046[(1)]);
if((state_val_99047 === (7))){
var inst_99042 = (state_99046[(2)]);
var state_99046__$1 = state_99046;
var statearr_99048_99068 = state_99046__$1;
(statearr_99048_99068[(2)] = inst_99042);

(statearr_99048_99068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (1))){
var state_99046__$1 = state_99046;
var statearr_99049_99069 = state_99046__$1;
(statearr_99049_99069[(2)] = null);

(statearr_99049_99069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (4))){
var inst_99026 = (state_99046[(7)]);
var inst_99026__$1 = (state_99046[(2)]);
var state_99046__$1 = (function (){var statearr_99050 = state_99046;
(statearr_99050[(7)] = inst_99026__$1);

return statearr_99050;
})();
if(cljs.core.truth_(inst_99026__$1)){
var statearr_99051_99070 = state_99046__$1;
(statearr_99051_99070[(1)] = (5));

} else {
var statearr_99052_99071 = state_99046__$1;
(statearr_99052_99071[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (6))){
var state_99046__$1 = state_99046;
var statearr_99053_99072 = state_99046__$1;
(statearr_99053_99072[(2)] = null);

(statearr_99053_99072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (3))){
var inst_99044 = (state_99046[(2)]);
var state_99046__$1 = state_99046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_99046__$1,inst_99044);
} else {
if((state_val_99047 === (2))){
var state_99046__$1 = state_99046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_99046__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_99047 === (11))){
var inst_99038 = (state_99046[(2)]);
var state_99046__$1 = (function (){var statearr_99054 = state_99046;
(statearr_99054[(8)] = inst_99038);

return statearr_99054;
})();
var statearr_99055_99073 = state_99046__$1;
(statearr_99055_99073[(2)] = null);

(statearr_99055_99073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (9))){
var inst_99030 = (state_99046[(9)]);
var inst_99032 = (state_99046[(10)]);
var inst_99034 = inst_99032.call(null,inst_99030);
var state_99046__$1 = state_99046;
var statearr_99056_99074 = state_99046__$1;
(statearr_99056_99074[(2)] = inst_99034);

(statearr_99056_99074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (5))){
var inst_99026 = (state_99046[(7)]);
var inst_99028 = figwheel.client.file_reloading.blocking_load.call(null,inst_99026);
var state_99046__$1 = state_99046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_99046__$1,(8),inst_99028);
} else {
if((state_val_99047 === (10))){
var inst_99030 = (state_99046[(9)]);
var inst_99036 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_99030);
var state_99046__$1 = state_99046;
var statearr_99057_99075 = state_99046__$1;
(statearr_99057_99075[(2)] = inst_99036);

(statearr_99057_99075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99047 === (8))){
var inst_99026 = (state_99046[(7)]);
var inst_99032 = (state_99046[(10)]);
var inst_99030 = (state_99046[(2)]);
var inst_99031 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_99032__$1 = cljs.core.get.call(null,inst_99031,inst_99026);
var state_99046__$1 = (function (){var statearr_99058 = state_99046;
(statearr_99058[(9)] = inst_99030);

(statearr_99058[(10)] = inst_99032__$1);

return statearr_99058;
})();
if(cljs.core.truth_(inst_99032__$1)){
var statearr_99059_99076 = state_99046__$1;
(statearr_99059_99076[(1)] = (9));

} else {
var statearr_99060_99077 = state_99046__$1;
(statearr_99060_99077[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__))
;
return ((function (switch__41860__auto__,c__41974__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__41861__auto__ = null;
var figwheel$client$file_reloading$state_machine__41861__auto____0 = (function (){
var statearr_99064 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_99064[(0)] = figwheel$client$file_reloading$state_machine__41861__auto__);

(statearr_99064[(1)] = (1));

return statearr_99064;
});
var figwheel$client$file_reloading$state_machine__41861__auto____1 = (function (state_99046){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_99046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e99065){if((e99065 instanceof Object)){
var ex__41864__auto__ = e99065;
var statearr_99066_99078 = state_99046;
(statearr_99066_99078[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_99046);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e99065;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__99079 = state_99046;
state_99046 = G__99079;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__41861__auto__ = function(state_99046){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__41861__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__41861__auto____1.call(this,state_99046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__41861__auto____0;
figwheel$client$file_reloading$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__41861__auto____1;
return figwheel$client$file_reloading$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__))
})();
var state__41976__auto__ = (function (){var statearr_99067 = f__41975__auto__.call(null);
(statearr_99067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_99067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__))
);

return c__41974__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__99080,callback){
var map__99083 = p__99080;
var map__99083__$1 = ((((!((map__99083 == null)))?((((map__99083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99083.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99083):map__99083);
var file_msg = map__99083__$1;
var namespace = cljs.core.get.call(null,map__99083__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__99083,map__99083__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__99083,map__99083__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__99085){
var map__99088 = p__99085;
var map__99088__$1 = ((((!((map__99088 == null)))?((((map__99088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99088):map__99088);
var file_msg = map__99088__$1;
var namespace = cljs.core.get.call(null,map__99088__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27268__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__27268__auto__){
var or__27280__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
var or__27280__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto____$1)){
return or__27280__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27268__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__99090,callback){
var map__99093 = p__99090;
var map__99093__$1 = ((((!((map__99093 == null)))?((((map__99093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99093.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99093):map__99093);
var file_msg = map__99093__$1;
var request_url = cljs.core.get.call(null,map__99093__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__99093__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__41974__auto___99197 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___99197,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___99197,out){
return (function (state_99179){
var state_val_99180 = (state_99179[(1)]);
if((state_val_99180 === (1))){
var inst_99153 = cljs.core.seq.call(null,files);
var inst_99154 = cljs.core.first.call(null,inst_99153);
var inst_99155 = cljs.core.next.call(null,inst_99153);
var inst_99156 = files;
var state_99179__$1 = (function (){var statearr_99181 = state_99179;
(statearr_99181[(7)] = inst_99155);

(statearr_99181[(8)] = inst_99156);

(statearr_99181[(9)] = inst_99154);

return statearr_99181;
})();
var statearr_99182_99198 = state_99179__$1;
(statearr_99182_99198[(2)] = null);

(statearr_99182_99198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99180 === (2))){
var inst_99156 = (state_99179[(8)]);
var inst_99162 = (state_99179[(10)]);
var inst_99161 = cljs.core.seq.call(null,inst_99156);
var inst_99162__$1 = cljs.core.first.call(null,inst_99161);
var inst_99163 = cljs.core.next.call(null,inst_99161);
var inst_99164 = (inst_99162__$1 == null);
var inst_99165 = cljs.core.not.call(null,inst_99164);
var state_99179__$1 = (function (){var statearr_99183 = state_99179;
(statearr_99183[(11)] = inst_99163);

(statearr_99183[(10)] = inst_99162__$1);

return statearr_99183;
})();
if(inst_99165){
var statearr_99184_99199 = state_99179__$1;
(statearr_99184_99199[(1)] = (4));

} else {
var statearr_99185_99200 = state_99179__$1;
(statearr_99185_99200[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99180 === (3))){
var inst_99177 = (state_99179[(2)]);
var state_99179__$1 = state_99179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_99179__$1,inst_99177);
} else {
if((state_val_99180 === (4))){
var inst_99162 = (state_99179[(10)]);
var inst_99167 = figwheel.client.file_reloading.reload_js_file.call(null,inst_99162);
var state_99179__$1 = state_99179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_99179__$1,(7),inst_99167);
} else {
if((state_val_99180 === (5))){
var inst_99173 = cljs.core.async.close_BANG_.call(null,out);
var state_99179__$1 = state_99179;
var statearr_99186_99201 = state_99179__$1;
(statearr_99186_99201[(2)] = inst_99173);

(statearr_99186_99201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99180 === (6))){
var inst_99175 = (state_99179[(2)]);
var state_99179__$1 = state_99179;
var statearr_99187_99202 = state_99179__$1;
(statearr_99187_99202[(2)] = inst_99175);

(statearr_99187_99202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99180 === (7))){
var inst_99163 = (state_99179[(11)]);
var inst_99169 = (state_99179[(2)]);
var inst_99170 = cljs.core.async.put_BANG_.call(null,out,inst_99169);
var inst_99156 = inst_99163;
var state_99179__$1 = (function (){var statearr_99188 = state_99179;
(statearr_99188[(8)] = inst_99156);

(statearr_99188[(12)] = inst_99170);

return statearr_99188;
})();
var statearr_99189_99203 = state_99179__$1;
(statearr_99189_99203[(2)] = null);

(statearr_99189_99203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__41974__auto___99197,out))
;
return ((function (switch__41860__auto__,c__41974__auto___99197,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____0 = (function (){
var statearr_99193 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99193[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__);

(statearr_99193[(1)] = (1));

return statearr_99193;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____1 = (function (state_99179){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_99179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e99194){if((e99194 instanceof Object)){
var ex__41864__auto__ = e99194;
var statearr_99195_99204 = state_99179;
(statearr_99195_99204[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_99179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e99194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__99205 = state_99179;
state_99179 = G__99205;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__ = function(state_99179){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____1.call(this,state_99179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___99197,out))
})();
var state__41976__auto__ = (function (){var statearr_99196 = f__41975__auto__.call(null);
(statearr_99196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___99197);

return statearr_99196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___99197,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__99206,opts){
var map__99210 = p__99206;
var map__99210__$1 = ((((!((map__99210 == null)))?((((map__99210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99210.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99210):map__99210);
var eval_body = cljs.core.get.call(null,map__99210__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__99210__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27268__auto__ = eval_body;
if(cljs.core.truth_(and__27268__auto__)){
return typeof eval_body === 'string';
} else {
return and__27268__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e99212){var e = e99212;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__99213_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__99213_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__99222){
var vec__99223 = p__99222;
var k = cljs.core.nth.call(null,vec__99223,(0),null);
var v = cljs.core.nth.call(null,vec__99223,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__99226){
var vec__99227 = p__99226;
var k = cljs.core.nth.call(null,vec__99227,(0),null);
var v = cljs.core.nth.call(null,vec__99227,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__99233,p__99234){
var map__99482 = p__99233;
var map__99482__$1 = ((((!((map__99482 == null)))?((((map__99482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99482.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99482):map__99482);
var opts = map__99482__$1;
var before_jsload = cljs.core.get.call(null,map__99482__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__99482__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__99482__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__99483 = p__99234;
var map__99483__$1 = ((((!((map__99483 == null)))?((((map__99483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99483.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99483):map__99483);
var msg = map__99483__$1;
var files = cljs.core.get.call(null,map__99483__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__99483__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__99483__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_99637){
var state_val_99638 = (state_99637[(1)]);
if((state_val_99638 === (7))){
var inst_99500 = (state_99637[(7)]);
var inst_99498 = (state_99637[(8)]);
var inst_99499 = (state_99637[(9)]);
var inst_99497 = (state_99637[(10)]);
var inst_99505 = cljs.core._nth.call(null,inst_99498,inst_99500);
var inst_99506 = figwheel.client.file_reloading.eval_body.call(null,inst_99505,opts);
var inst_99507 = (inst_99500 + (1));
var tmp99639 = inst_99498;
var tmp99640 = inst_99499;
var tmp99641 = inst_99497;
var inst_99497__$1 = tmp99641;
var inst_99498__$1 = tmp99639;
var inst_99499__$1 = tmp99640;
var inst_99500__$1 = inst_99507;
var state_99637__$1 = (function (){var statearr_99642 = state_99637;
(statearr_99642[(7)] = inst_99500__$1);

(statearr_99642[(8)] = inst_99498__$1);

(statearr_99642[(11)] = inst_99506);

(statearr_99642[(9)] = inst_99499__$1);

(statearr_99642[(10)] = inst_99497__$1);

return statearr_99642;
})();
var statearr_99643_99729 = state_99637__$1;
(statearr_99643_99729[(2)] = null);

(statearr_99643_99729[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (20))){
var inst_99540 = (state_99637[(12)]);
var inst_99548 = figwheel.client.file_reloading.sort_files.call(null,inst_99540);
var state_99637__$1 = state_99637;
var statearr_99644_99730 = state_99637__$1;
(statearr_99644_99730[(2)] = inst_99548);

(statearr_99644_99730[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (27))){
var state_99637__$1 = state_99637;
var statearr_99645_99731 = state_99637__$1;
(statearr_99645_99731[(2)] = null);

(statearr_99645_99731[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (1))){
var inst_99489 = (state_99637[(13)]);
var inst_99486 = before_jsload.call(null,files);
var inst_99487 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_99488 = (function (){return ((function (inst_99489,inst_99486,inst_99487,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__99230_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__99230_SHARP_);
});
;})(inst_99489,inst_99486,inst_99487,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99489__$1 = cljs.core.filter.call(null,inst_99488,files);
var inst_99490 = cljs.core.not_empty.call(null,inst_99489__$1);
var state_99637__$1 = (function (){var statearr_99646 = state_99637;
(statearr_99646[(14)] = inst_99487);

(statearr_99646[(15)] = inst_99486);

(statearr_99646[(13)] = inst_99489__$1);

return statearr_99646;
})();
if(cljs.core.truth_(inst_99490)){
var statearr_99647_99732 = state_99637__$1;
(statearr_99647_99732[(1)] = (2));

} else {
var statearr_99648_99733 = state_99637__$1;
(statearr_99648_99733[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (24))){
var state_99637__$1 = state_99637;
var statearr_99649_99734 = state_99637__$1;
(statearr_99649_99734[(2)] = null);

(statearr_99649_99734[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (39))){
var inst_99590 = (state_99637[(16)]);
var state_99637__$1 = state_99637;
var statearr_99650_99735 = state_99637__$1;
(statearr_99650_99735[(2)] = inst_99590);

(statearr_99650_99735[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (46))){
var inst_99632 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99651_99736 = state_99637__$1;
(statearr_99651_99736[(2)] = inst_99632);

(statearr_99651_99736[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (4))){
var inst_99534 = (state_99637[(2)]);
var inst_99535 = cljs.core.List.EMPTY;
var inst_99536 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_99535);
var inst_99537 = (function (){return ((function (inst_99534,inst_99535,inst_99536,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__99231_SHARP_){
var and__27268__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__99231_SHARP_);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__99231_SHARP_));
} else {
return and__27268__auto__;
}
});
;})(inst_99534,inst_99535,inst_99536,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99538 = cljs.core.filter.call(null,inst_99537,files);
var inst_99539 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_99540 = cljs.core.concat.call(null,inst_99538,inst_99539);
var state_99637__$1 = (function (){var statearr_99652 = state_99637;
(statearr_99652[(12)] = inst_99540);

(statearr_99652[(17)] = inst_99534);

(statearr_99652[(18)] = inst_99536);

return statearr_99652;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_99653_99737 = state_99637__$1;
(statearr_99653_99737[(1)] = (16));

} else {
var statearr_99654_99738 = state_99637__$1;
(statearr_99654_99738[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (15))){
var inst_99524 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99655_99739 = state_99637__$1;
(statearr_99655_99739[(2)] = inst_99524);

(statearr_99655_99739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (21))){
var inst_99550 = (state_99637[(19)]);
var inst_99550__$1 = (state_99637[(2)]);
var inst_99551 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_99550__$1);
var state_99637__$1 = (function (){var statearr_99656 = state_99637;
(statearr_99656[(19)] = inst_99550__$1);

return statearr_99656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_99637__$1,(22),inst_99551);
} else {
if((state_val_99638 === (31))){
var inst_99635 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_99637__$1,inst_99635);
} else {
if((state_val_99638 === (32))){
var inst_99590 = (state_99637[(16)]);
var inst_99595 = inst_99590.cljs$lang$protocol_mask$partition0$;
var inst_99596 = (inst_99595 & (64));
var inst_99597 = inst_99590.cljs$core$ISeq$;
var inst_99598 = (cljs.core.PROTOCOL_SENTINEL === inst_99597);
var inst_99599 = (inst_99596) || (inst_99598);
var state_99637__$1 = state_99637;
if(cljs.core.truth_(inst_99599)){
var statearr_99657_99740 = state_99637__$1;
(statearr_99657_99740[(1)] = (35));

} else {
var statearr_99658_99741 = state_99637__$1;
(statearr_99658_99741[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (40))){
var inst_99612 = (state_99637[(20)]);
var inst_99611 = (state_99637[(2)]);
var inst_99612__$1 = cljs.core.get.call(null,inst_99611,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_99613 = cljs.core.get.call(null,inst_99611,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_99614 = cljs.core.not_empty.call(null,inst_99612__$1);
var state_99637__$1 = (function (){var statearr_99659 = state_99637;
(statearr_99659[(20)] = inst_99612__$1);

(statearr_99659[(21)] = inst_99613);

return statearr_99659;
})();
if(cljs.core.truth_(inst_99614)){
var statearr_99660_99742 = state_99637__$1;
(statearr_99660_99742[(1)] = (41));

} else {
var statearr_99661_99743 = state_99637__$1;
(statearr_99661_99743[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (33))){
var state_99637__$1 = state_99637;
var statearr_99662_99744 = state_99637__$1;
(statearr_99662_99744[(2)] = false);

(statearr_99662_99744[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (13))){
var inst_99510 = (state_99637[(22)]);
var inst_99514 = cljs.core.chunk_first.call(null,inst_99510);
var inst_99515 = cljs.core.chunk_rest.call(null,inst_99510);
var inst_99516 = cljs.core.count.call(null,inst_99514);
var inst_99497 = inst_99515;
var inst_99498 = inst_99514;
var inst_99499 = inst_99516;
var inst_99500 = (0);
var state_99637__$1 = (function (){var statearr_99663 = state_99637;
(statearr_99663[(7)] = inst_99500);

(statearr_99663[(8)] = inst_99498);

(statearr_99663[(9)] = inst_99499);

(statearr_99663[(10)] = inst_99497);

return statearr_99663;
})();
var statearr_99664_99745 = state_99637__$1;
(statearr_99664_99745[(2)] = null);

(statearr_99664_99745[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (22))){
var inst_99550 = (state_99637[(19)]);
var inst_99553 = (state_99637[(23)]);
var inst_99554 = (state_99637[(24)]);
var inst_99558 = (state_99637[(25)]);
var inst_99553__$1 = (state_99637[(2)]);
var inst_99554__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_99553__$1);
var inst_99555 = (function (){var all_files = inst_99550;
var res_SINGLEQUOTE_ = inst_99553__$1;
var res = inst_99554__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_99550,inst_99553,inst_99554,inst_99558,inst_99553__$1,inst_99554__$1,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__99232_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__99232_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_99550,inst_99553,inst_99554,inst_99558,inst_99553__$1,inst_99554__$1,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99556 = cljs.core.filter.call(null,inst_99555,inst_99553__$1);
var inst_99557 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_99558__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_99557);
var inst_99559 = cljs.core.not_empty.call(null,inst_99558__$1);
var state_99637__$1 = (function (){var statearr_99665 = state_99637;
(statearr_99665[(23)] = inst_99553__$1);

(statearr_99665[(26)] = inst_99556);

(statearr_99665[(24)] = inst_99554__$1);

(statearr_99665[(25)] = inst_99558__$1);

return statearr_99665;
})();
if(cljs.core.truth_(inst_99559)){
var statearr_99666_99746 = state_99637__$1;
(statearr_99666_99746[(1)] = (23));

} else {
var statearr_99667_99747 = state_99637__$1;
(statearr_99667_99747[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (36))){
var state_99637__$1 = state_99637;
var statearr_99668_99748 = state_99637__$1;
(statearr_99668_99748[(2)] = false);

(statearr_99668_99748[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (41))){
var inst_99612 = (state_99637[(20)]);
var inst_99616 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_99617 = cljs.core.map.call(null,inst_99616,inst_99612);
var inst_99618 = cljs.core.pr_str.call(null,inst_99617);
var inst_99619 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_99618)].join('');
var inst_99620 = figwheel.client.utils.log.call(null,inst_99619);
var state_99637__$1 = state_99637;
var statearr_99669_99749 = state_99637__$1;
(statearr_99669_99749[(2)] = inst_99620);

(statearr_99669_99749[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (43))){
var inst_99613 = (state_99637[(21)]);
var inst_99623 = (state_99637[(2)]);
var inst_99624 = cljs.core.not_empty.call(null,inst_99613);
var state_99637__$1 = (function (){var statearr_99670 = state_99637;
(statearr_99670[(27)] = inst_99623);

return statearr_99670;
})();
if(cljs.core.truth_(inst_99624)){
var statearr_99671_99750 = state_99637__$1;
(statearr_99671_99750[(1)] = (44));

} else {
var statearr_99672_99751 = state_99637__$1;
(statearr_99672_99751[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (29))){
var inst_99550 = (state_99637[(19)]);
var inst_99553 = (state_99637[(23)]);
var inst_99556 = (state_99637[(26)]);
var inst_99554 = (state_99637[(24)]);
var inst_99558 = (state_99637[(25)]);
var inst_99590 = (state_99637[(16)]);
var inst_99586 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_99589 = (function (){var all_files = inst_99550;
var res_SINGLEQUOTE_ = inst_99553;
var res = inst_99554;
var files_not_loaded = inst_99556;
var dependencies_that_loaded = inst_99558;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99590,inst_99586,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__99588){
var map__99673 = p__99588;
var map__99673__$1 = ((((!((map__99673 == null)))?((((map__99673.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99673.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99673):map__99673);
var namespace = cljs.core.get.call(null,map__99673__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99590,inst_99586,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99590__$1 = cljs.core.group_by.call(null,inst_99589,inst_99556);
var inst_99592 = (inst_99590__$1 == null);
var inst_99593 = cljs.core.not.call(null,inst_99592);
var state_99637__$1 = (function (){var statearr_99675 = state_99637;
(statearr_99675[(28)] = inst_99586);

(statearr_99675[(16)] = inst_99590__$1);

return statearr_99675;
})();
if(inst_99593){
var statearr_99676_99752 = state_99637__$1;
(statearr_99676_99752[(1)] = (32));

} else {
var statearr_99677_99753 = state_99637__$1;
(statearr_99677_99753[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (44))){
var inst_99613 = (state_99637[(21)]);
var inst_99626 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_99613);
var inst_99627 = cljs.core.pr_str.call(null,inst_99626);
var inst_99628 = [cljs.core.str("not required: "),cljs.core.str(inst_99627)].join('');
var inst_99629 = figwheel.client.utils.log.call(null,inst_99628);
var state_99637__$1 = state_99637;
var statearr_99678_99754 = state_99637__$1;
(statearr_99678_99754[(2)] = inst_99629);

(statearr_99678_99754[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (6))){
var inst_99531 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99679_99755 = state_99637__$1;
(statearr_99679_99755[(2)] = inst_99531);

(statearr_99679_99755[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (28))){
var inst_99556 = (state_99637[(26)]);
var inst_99583 = (state_99637[(2)]);
var inst_99584 = cljs.core.not_empty.call(null,inst_99556);
var state_99637__$1 = (function (){var statearr_99680 = state_99637;
(statearr_99680[(29)] = inst_99583);

return statearr_99680;
})();
if(cljs.core.truth_(inst_99584)){
var statearr_99681_99756 = state_99637__$1;
(statearr_99681_99756[(1)] = (29));

} else {
var statearr_99682_99757 = state_99637__$1;
(statearr_99682_99757[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (25))){
var inst_99554 = (state_99637[(24)]);
var inst_99570 = (state_99637[(2)]);
var inst_99571 = cljs.core.not_empty.call(null,inst_99554);
var state_99637__$1 = (function (){var statearr_99683 = state_99637;
(statearr_99683[(30)] = inst_99570);

return statearr_99683;
})();
if(cljs.core.truth_(inst_99571)){
var statearr_99684_99758 = state_99637__$1;
(statearr_99684_99758[(1)] = (26));

} else {
var statearr_99685_99759 = state_99637__$1;
(statearr_99685_99759[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (34))){
var inst_99606 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
if(cljs.core.truth_(inst_99606)){
var statearr_99686_99760 = state_99637__$1;
(statearr_99686_99760[(1)] = (38));

} else {
var statearr_99687_99761 = state_99637__$1;
(statearr_99687_99761[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (17))){
var state_99637__$1 = state_99637;
var statearr_99688_99762 = state_99637__$1;
(statearr_99688_99762[(2)] = recompile_dependents);

(statearr_99688_99762[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (3))){
var state_99637__$1 = state_99637;
var statearr_99689_99763 = state_99637__$1;
(statearr_99689_99763[(2)] = null);

(statearr_99689_99763[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (12))){
var inst_99527 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99690_99764 = state_99637__$1;
(statearr_99690_99764[(2)] = inst_99527);

(statearr_99690_99764[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (2))){
var inst_99489 = (state_99637[(13)]);
var inst_99496 = cljs.core.seq.call(null,inst_99489);
var inst_99497 = inst_99496;
var inst_99498 = null;
var inst_99499 = (0);
var inst_99500 = (0);
var state_99637__$1 = (function (){var statearr_99691 = state_99637;
(statearr_99691[(7)] = inst_99500);

(statearr_99691[(8)] = inst_99498);

(statearr_99691[(9)] = inst_99499);

(statearr_99691[(10)] = inst_99497);

return statearr_99691;
})();
var statearr_99692_99765 = state_99637__$1;
(statearr_99692_99765[(2)] = null);

(statearr_99692_99765[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (23))){
var inst_99550 = (state_99637[(19)]);
var inst_99553 = (state_99637[(23)]);
var inst_99556 = (state_99637[(26)]);
var inst_99554 = (state_99637[(24)]);
var inst_99558 = (state_99637[(25)]);
var inst_99561 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_99563 = (function (){var all_files = inst_99550;
var res_SINGLEQUOTE_ = inst_99553;
var res = inst_99554;
var files_not_loaded = inst_99556;
var dependencies_that_loaded = inst_99558;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99561,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__99562){
var map__99693 = p__99562;
var map__99693__$1 = ((((!((map__99693 == null)))?((((map__99693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99693.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99693):map__99693);
var request_url = cljs.core.get.call(null,map__99693__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99561,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99564 = cljs.core.reverse.call(null,inst_99558);
var inst_99565 = cljs.core.map.call(null,inst_99563,inst_99564);
var inst_99566 = cljs.core.pr_str.call(null,inst_99565);
var inst_99567 = figwheel.client.utils.log.call(null,inst_99566);
var state_99637__$1 = (function (){var statearr_99695 = state_99637;
(statearr_99695[(31)] = inst_99561);

return statearr_99695;
})();
var statearr_99696_99766 = state_99637__$1;
(statearr_99696_99766[(2)] = inst_99567);

(statearr_99696_99766[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (35))){
var state_99637__$1 = state_99637;
var statearr_99697_99767 = state_99637__$1;
(statearr_99697_99767[(2)] = true);

(statearr_99697_99767[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (19))){
var inst_99540 = (state_99637[(12)]);
var inst_99546 = figwheel.client.file_reloading.expand_files.call(null,inst_99540);
var state_99637__$1 = state_99637;
var statearr_99698_99768 = state_99637__$1;
(statearr_99698_99768[(2)] = inst_99546);

(statearr_99698_99768[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (11))){
var state_99637__$1 = state_99637;
var statearr_99699_99769 = state_99637__$1;
(statearr_99699_99769[(2)] = null);

(statearr_99699_99769[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (9))){
var inst_99529 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99700_99770 = state_99637__$1;
(statearr_99700_99770[(2)] = inst_99529);

(statearr_99700_99770[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (5))){
var inst_99500 = (state_99637[(7)]);
var inst_99499 = (state_99637[(9)]);
var inst_99502 = (inst_99500 < inst_99499);
var inst_99503 = inst_99502;
var state_99637__$1 = state_99637;
if(cljs.core.truth_(inst_99503)){
var statearr_99701_99771 = state_99637__$1;
(statearr_99701_99771[(1)] = (7));

} else {
var statearr_99702_99772 = state_99637__$1;
(statearr_99702_99772[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (14))){
var inst_99510 = (state_99637[(22)]);
var inst_99519 = cljs.core.first.call(null,inst_99510);
var inst_99520 = figwheel.client.file_reloading.eval_body.call(null,inst_99519,opts);
var inst_99521 = cljs.core.next.call(null,inst_99510);
var inst_99497 = inst_99521;
var inst_99498 = null;
var inst_99499 = (0);
var inst_99500 = (0);
var state_99637__$1 = (function (){var statearr_99703 = state_99637;
(statearr_99703[(7)] = inst_99500);

(statearr_99703[(8)] = inst_99498);

(statearr_99703[(9)] = inst_99499);

(statearr_99703[(32)] = inst_99520);

(statearr_99703[(10)] = inst_99497);

return statearr_99703;
})();
var statearr_99704_99773 = state_99637__$1;
(statearr_99704_99773[(2)] = null);

(statearr_99704_99773[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (45))){
var state_99637__$1 = state_99637;
var statearr_99705_99774 = state_99637__$1;
(statearr_99705_99774[(2)] = null);

(statearr_99705_99774[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (26))){
var inst_99550 = (state_99637[(19)]);
var inst_99553 = (state_99637[(23)]);
var inst_99556 = (state_99637[(26)]);
var inst_99554 = (state_99637[(24)]);
var inst_99558 = (state_99637[(25)]);
var inst_99573 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_99575 = (function (){var all_files = inst_99550;
var res_SINGLEQUOTE_ = inst_99553;
var res = inst_99554;
var files_not_loaded = inst_99556;
var dependencies_that_loaded = inst_99558;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99573,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__99574){
var map__99706 = p__99574;
var map__99706__$1 = ((((!((map__99706 == null)))?((((map__99706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99706.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99706):map__99706);
var namespace = cljs.core.get.call(null,map__99706__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__99706__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99573,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99576 = cljs.core.map.call(null,inst_99575,inst_99554);
var inst_99577 = cljs.core.pr_str.call(null,inst_99576);
var inst_99578 = figwheel.client.utils.log.call(null,inst_99577);
var inst_99579 = (function (){var all_files = inst_99550;
var res_SINGLEQUOTE_ = inst_99553;
var res = inst_99554;
var files_not_loaded = inst_99556;
var dependencies_that_loaded = inst_99558;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99573,inst_99575,inst_99576,inst_99577,inst_99578,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_99550,inst_99553,inst_99556,inst_99554,inst_99558,inst_99573,inst_99575,inst_99576,inst_99577,inst_99578,state_val_99638,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_99580 = setTimeout(inst_99579,(10));
var state_99637__$1 = (function (){var statearr_99708 = state_99637;
(statearr_99708[(33)] = inst_99573);

(statearr_99708[(34)] = inst_99578);

return statearr_99708;
})();
var statearr_99709_99775 = state_99637__$1;
(statearr_99709_99775[(2)] = inst_99580);

(statearr_99709_99775[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (16))){
var state_99637__$1 = state_99637;
var statearr_99710_99776 = state_99637__$1;
(statearr_99710_99776[(2)] = reload_dependents);

(statearr_99710_99776[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (38))){
var inst_99590 = (state_99637[(16)]);
var inst_99608 = cljs.core.apply.call(null,cljs.core.hash_map,inst_99590);
var state_99637__$1 = state_99637;
var statearr_99711_99777 = state_99637__$1;
(statearr_99711_99777[(2)] = inst_99608);

(statearr_99711_99777[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (30))){
var state_99637__$1 = state_99637;
var statearr_99712_99778 = state_99637__$1;
(statearr_99712_99778[(2)] = null);

(statearr_99712_99778[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (10))){
var inst_99510 = (state_99637[(22)]);
var inst_99512 = cljs.core.chunked_seq_QMARK_.call(null,inst_99510);
var state_99637__$1 = state_99637;
if(inst_99512){
var statearr_99713_99779 = state_99637__$1;
(statearr_99713_99779[(1)] = (13));

} else {
var statearr_99714_99780 = state_99637__$1;
(statearr_99714_99780[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (18))){
var inst_99544 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
if(cljs.core.truth_(inst_99544)){
var statearr_99715_99781 = state_99637__$1;
(statearr_99715_99781[(1)] = (19));

} else {
var statearr_99716_99782 = state_99637__$1;
(statearr_99716_99782[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (42))){
var state_99637__$1 = state_99637;
var statearr_99717_99783 = state_99637__$1;
(statearr_99717_99783[(2)] = null);

(statearr_99717_99783[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (37))){
var inst_99603 = (state_99637[(2)]);
var state_99637__$1 = state_99637;
var statearr_99718_99784 = state_99637__$1;
(statearr_99718_99784[(2)] = inst_99603);

(statearr_99718_99784[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_99638 === (8))){
var inst_99510 = (state_99637[(22)]);
var inst_99497 = (state_99637[(10)]);
var inst_99510__$1 = cljs.core.seq.call(null,inst_99497);
var state_99637__$1 = (function (){var statearr_99719 = state_99637;
(statearr_99719[(22)] = inst_99510__$1);

return statearr_99719;
})();
if(inst_99510__$1){
var statearr_99720_99785 = state_99637__$1;
(statearr_99720_99785[(1)] = (10));

} else {
var statearr_99721_99786 = state_99637__$1;
(statearr_99721_99786[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__41860__auto__,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____0 = (function (){
var statearr_99725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99725[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__);

(statearr_99725[(1)] = (1));

return statearr_99725;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____1 = (function (state_99637){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_99637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e99726){if((e99726 instanceof Object)){
var ex__41864__auto__ = e99726;
var statearr_99727_99787 = state_99637;
(statearr_99727_99787[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_99637);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e99726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__99788 = state_99637;
state_99637 = G__99788;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__ = function(state_99637){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____1.call(this,state_99637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__41976__auto__ = (function (){var statearr_99728 = f__41975__auto__.call(null);
(statearr_99728[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_99728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__,map__99482,map__99482__$1,opts,before_jsload,on_jsload,reload_dependents,map__99483,map__99483__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__41974__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__99791,link){
var map__99794 = p__99791;
var map__99794__$1 = ((((!((map__99794 == null)))?((((map__99794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99794.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99794):map__99794);
var file = cljs.core.get.call(null,map__99794__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__99794,map__99794__$1,file){
return (function (p1__99789_SHARP_,p2__99790_SHARP_){
if(cljs.core._EQ_.call(null,p1__99789_SHARP_,p2__99790_SHARP_)){
return p1__99789_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__99794,map__99794__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__99800){
var map__99801 = p__99800;
var map__99801__$1 = ((((!((map__99801 == null)))?((((map__99801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99801.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99801):map__99801);
var match_length = cljs.core.get.call(null,map__99801__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__99801__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__99796_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__99796_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args99803 = [];
var len__28496__auto___99806 = arguments.length;
var i__28497__auto___99807 = (0);
while(true){
if((i__28497__auto___99807 < len__28496__auto___99806)){
args99803.push((arguments[i__28497__auto___99807]));

var G__99808 = (i__28497__auto___99807 + (1));
i__28497__auto___99807 = G__99808;
continue;
} else {
}
break;
}

var G__99805 = args99803.length;
switch (G__99805) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args99803.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__99810_SHARP_,p2__99811_SHARP_){
return cljs.core.assoc.call(null,p1__99810_SHARP_,cljs.core.get.call(null,p2__99811_SHARP_,key),p2__99811_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__99812){
var map__99815 = p__99812;
var map__99815__$1 = ((((!((map__99815 == null)))?((((map__99815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99815.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99815):map__99815);
var f_data = map__99815__$1;
var file = cljs.core.get.call(null,map__99815__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__99817,p__99818){
var map__99827 = p__99817;
var map__99827__$1 = ((((!((map__99827 == null)))?((((map__99827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99827.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99827):map__99827);
var opts = map__99827__$1;
var on_cssload = cljs.core.get.call(null,map__99827__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__99828 = p__99818;
var map__99828__$1 = ((((!((map__99828 == null)))?((((map__99828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99828.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99828):map__99828);
var files_msg = map__99828__$1;
var files = cljs.core.get.call(null,map__99828__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__99831_99835 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__99832_99836 = null;
var count__99833_99837 = (0);
var i__99834_99838 = (0);
while(true){
if((i__99834_99838 < count__99833_99837)){
var f_99839 = cljs.core._nth.call(null,chunk__99832_99836,i__99834_99838);
figwheel.client.file_reloading.reload_css_file.call(null,f_99839);

var G__99840 = seq__99831_99835;
var G__99841 = chunk__99832_99836;
var G__99842 = count__99833_99837;
var G__99843 = (i__99834_99838 + (1));
seq__99831_99835 = G__99840;
chunk__99832_99836 = G__99841;
count__99833_99837 = G__99842;
i__99834_99838 = G__99843;
continue;
} else {
var temp__6753__auto___99844 = cljs.core.seq.call(null,seq__99831_99835);
if(temp__6753__auto___99844){
var seq__99831_99845__$1 = temp__6753__auto___99844;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__99831_99845__$1)){
var c__28186__auto___99846 = cljs.core.chunk_first.call(null,seq__99831_99845__$1);
var G__99847 = cljs.core.chunk_rest.call(null,seq__99831_99845__$1);
var G__99848 = c__28186__auto___99846;
var G__99849 = cljs.core.count.call(null,c__28186__auto___99846);
var G__99850 = (0);
seq__99831_99835 = G__99847;
chunk__99832_99836 = G__99848;
count__99833_99837 = G__99849;
i__99834_99838 = G__99850;
continue;
} else {
var f_99851 = cljs.core.first.call(null,seq__99831_99845__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_99851);

var G__99852 = cljs.core.next.call(null,seq__99831_99845__$1);
var G__99853 = null;
var G__99854 = (0);
var G__99855 = (0);
seq__99831_99835 = G__99852;
chunk__99832_99836 = G__99853;
count__99833_99837 = G__99854;
i__99834_99838 = G__99855;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__99827,map__99827__$1,opts,on_cssload,map__99828,map__99828__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__99827,map__99827__$1,opts,on_cssload,map__99828,map__99828__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1483479084874