// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.protocol_support');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('untangled.client.impl.protocol_support');
goog.require('untangled_spec.core');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.tempid');
goog.require('om.next');
/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to the optimistic update for transactions going to the server
 *   `ui-tx`: the om transaction that modifies the app state prior to receiving a server response
 *   `optimistic-delta`: the expected changes to the app state after executing ui-tx. See Protocol Testing README for how
 *   to build this properly.
 */
untangled.client.protocol_support.check_optimistic_update = (function untangled$client$protocol_support$check_optimistic_update(var_args){
var args__11898__auto__ = [];
var len__11895__auto___23134 = arguments.length;
var i__11896__auto___23135 = (0);
while(true){
if((i__11896__auto___23135 < len__11895__auto___23134)){
args__11898__auto__.push((arguments[i__11896__auto___23135]));

var G__23136 = (i__11896__auto___23135 + (1));
i__11896__auto___23135 = G__23136;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((1) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11899__auto__);
});

untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic = (function (p__23126,p__23127){
var map__23128 = p__23126;
var map__23128__$1 = ((((!((map__23128 == null)))?((((map__23128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23128.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23128):map__23128);
var data = map__23128__$1;
var initial_ui_state = cljs.core.get.call(null,map__23128__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__23128__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var optimistic_delta = cljs.core.get.call(null,map__23128__$1,new cljs.core.Keyword(null,"optimistic-delta","optimistic-delta",-2118700684));
var map__23129 = p__23127;
var map__23129__$1 = ((((!((map__23129 == null)))?((((map__23129.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23129.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23129):map__23129);
var env = cljs.core.get.call(null,map__23129__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("state not allowed in the env argument"),cljs.core.str("\n"),cljs.core.str("(not (:state env))")].join('')));
}

cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Optimistic Updates");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));

var map__23132_23137 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__23132_23138__$1 = ((((!((map__23132_23137 == null)))?((((map__23132_23137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23132_23137.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23132_23137):map__23132_23137);
var parser_23139 = cljs.core.get.call(null,map__23132_23138__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_23140 = cljs.core.atom.call(null,initial_ui_state);
var parse_23141 = cljs.core.partial.call(null,parser_23139,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_23140], null),env));
var tempid_map_23142 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_23143__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_23142);
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"trigger correct state transitions");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));

parse_23141.call(null,ui_tx_23143__$1);

untangled.client.impl.protocol_support.check_delta.call(null,untangled.client.impl.protocol_support.rewrite_tempids.call(null,cljs.core.deref.call(null,state_23140),clojure.set.map_invert.call(null,tempid_map_23142),om.tempid.tempid_QMARK_),optimistic_delta);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_optimistic_update.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_optimistic_update.cljs$lang$applyTo = (function (seq23124){
var G__23125 = cljs.core.first.call(null,seq23124);
var seq23124__$1 = cljs.core.next.call(null,seq23124);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic(G__23125,seq23124__$1);
});

/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to sending the server transaction
 *   `ui-tx`: the om transaction that modifies the app state locally
 *   `server-tx`: the server transaction corresponding to ui-tx
 */
untangled.client.protocol_support.check_server_tx = (function untangled$client$protocol_support$check_server_tx(var_args){
var args__11898__auto__ = [];
var len__11895__auto___23155 = arguments.length;
var i__11896__auto___23156 = (0);
while(true){
if((i__11896__auto___23156 < len__11895__auto___23155)){
args__11898__auto__.push((arguments[i__11896__auto___23156]));

var G__23157 = (i__11896__auto___23156 + (1));
i__11896__auto___23156 = G__23157;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((1) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11899__auto__);
});

untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic = (function (p__23146,p__23147){
var map__23148 = p__23146;
var map__23148__$1 = ((((!((map__23148 == null)))?((((map__23148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23148):map__23148);
var initial_ui_state = cljs.core.get.call(null,map__23148__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__23148__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var server_tx = cljs.core.get.call(null,map__23148__$1,new cljs.core.Keyword(null,"server-tx","server-tx",-1146708246));
var map__23149 = p__23147;
var map__23149__$1 = ((((!((map__23149 == null)))?((((map__23149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23149.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23149):map__23149);
var env = cljs.core.get.call(null,map__23149__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Client Remoting");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));

var map__23152_23158 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__23152_23159__$1 = ((((!((map__23152_23158 == null)))?((((map__23152_23158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23152_23158.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23152_23158):map__23152_23158);
var parser_23160 = cljs.core.get.call(null,map__23152_23159__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_23161 = cljs.core.atom.call(null,initial_ui_state);
var parse_23162 = cljs.core.partial.call(null,parser_23160,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_23161], null),env));
var tempid_map_23163 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_23164__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_23163);
parse_23162.call(null,ui_tx_23164__$1);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = untangled.client.impl.protocol_support.rewrite_tempids.call(null,untangled.client.impl.om_plumbing.strip_ui.call(null,untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,parse_23162.call(null,ui_tx_23164__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576)))),clojure.set.map_invert.call(null,tempid_map_23163),om.tempid.tempid_QMARK_);
var exp__727__auto__ = server_tx;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null);
})());
}catch (e23154){var t__2809__auto___23165 = e23154;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"server-tx","server-tx",493823281,null),cljs.core.list(new cljs.core.Symbol(null,"->","->",-2139605430,null),cljs.core.list(new cljs.core.Symbol(null,"parse","parse",478366908,null),new cljs.core.Symbol(null,"ui-tx","ui-tx",62864806,null),new cljs.core.Keyword(null,"remote","remote",-1593576576)),new cljs.core.Symbol("plumbing","remove-loads-and-fallbacks","plumbing/remove-loads-and-fallbacks",-474759113,null),new cljs.core.Symbol("plumbing","strip-ui","plumbing/strip-ui",-2004815259,null),cljs.core.list(new cljs.core.Symbol("impl","rewrite-tempids","impl/rewrite-tempids",-1005245316,null),cljs.core.list(new cljs.core.Symbol("set","map-invert","set/map-invert",1259038818,null),new cljs.core.Symbol(null,"tempid-map","tempid-map",-1148551297,null)),new cljs.core.Symbol("omt","tempid?","omt/tempid?",2034821487,null)))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23165,new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null));
}
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_server_tx.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_server_tx.cljs$lang$applyTo = (function (seq23144){
var G__23145 = cljs.core.first.call(null,seq23144);
var seq23144__$1 = cljs.core.next.call(null,seq23144);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic(G__23145,seq23144__$1);
});

/**
 * Takes a map containing:
 *   `response`: the exact data the server sends back to the client
 *   `pre-response-state`: normalized state prior to receiving `response`
 *   `server-tx`: the transaction originally sent to the server, yielding `response`
 *   `merge-delta`: the delta between `pre-response-state` and its integration with `response`
 */
untangled.client.protocol_support.check_response_from_server = (function untangled$client$protocol_support$check_response_from_server(p__23166){
var map__23172 = p__23166;
var map__23172__$1 = ((((!((map__23172 == null)))?((((map__23172.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23172.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23172):map__23172);
var response = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"response","response",-1068424192));
var pre_response_state = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"pre-response-state","pre-response-state",696272294));
var ui_tx = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var merge_delta = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"merge-delta","merge-delta",-1454035297));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Server response merged with app state");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));

var map__23174_23177 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__23174_23178__$1 = ((((!((map__23174_23177 == null)))?((((map__23174_23177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23174_23177.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23174_23177):map__23174_23177);
var reconciler_23179 = cljs.core.get.call(null,map__23174_23178__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state_23180 = om.next.app_state.call(null,reconciler_23179);
cljs.core.reset_BANG_.call(null,state_23180,pre_response_state);

om.next.merge_BANG_.call(null,reconciler_23179,response,ui_tx);

if(cljs.core.truth_(merge_delta)){
untangled.client.impl.protocol_support.check_delta.call(null,cljs.core.deref.call(null,state_23180),merge_delta);
} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.deref.call(null,state_23180);
var exp__727__auto__ = pre_response_state;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null);
})());
}catch (e23176){var t__2809__auto___23181 = e23176;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"pre-response-state","pre-response-state",-1958163475,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"state","state",-348086572,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__2809__auto___23181,new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null));
}}

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});
untangled.client.protocol_support.with_behavior = untangled.client.impl.protocol_support.with_behavior;

//# sourceMappingURL=protocol_support.js.map?rel=1485292056314