// Compiled by ClojureScript 1.9.293 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy.core.recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__88800 = h;
G__88800.setUseFragment(false);

G__88800.setPathPrefix("");

G__88800.setEnabled(true);

return G__88800;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str(location.pathname),cljs.core.str(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str(path_prefix),cljs.core.str(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args88801 = [];
var len__28496__auto___88804 = arguments.length;
var i__28497__auto___88805 = (0);
while(true){
if((i__28497__auto___88805 < len__28496__auto___88804)){
args88801.push((arguments[i__28497__auto___88805]));

var G__88806 = (i__28497__auto___88805 + (1));
i__28497__auto___88805 = G__88806;
continue;
} else {
}
break;
}

var G__88803 = args88801.length;
switch (G__88803) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args88801.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;


/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args88808 = [];
var len__28496__auto___88814 = arguments.length;
var i__28497__auto___88815 = (0);
while(true){
if((i__28497__auto___88815 < len__28496__auto___88814)){
args88808.push((arguments[i__28497__auto___88815]));

var G__88816 = (i__28497__auto___88815 + (1));
i__28497__auto___88815 = G__88816;
continue;
} else {
}
break;
}

var G__88810 = args88808.length;
switch (G__88810) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args88808.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token);
} else {
var m__27994__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token,title);
} else {
var m__27994__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args88811 = [];
var len__28496__auto___88818 = arguments.length;
var i__28497__auto___88819 = (0);
while(true){
if((i__28497__auto___88819 < len__28496__auto___88818)){
args88811.push((arguments[i__28497__auto___88819]));

var G__88820 = (i__28497__auto___88819 + (1));
i__28497__auto___88819 = G__88820;
continue;
} else {
}
break;
}

var G__88813 = args88811.length;
switch (G__88813) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args88811.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token);
} else {
var m__27994__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$,token,title);
} else {
var m__27994__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.get_token[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__27993__auto__ = (((this$ == null))?null:this$);
var m__27994__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,this$);
} else {
var m__27994__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (cljs.core.some_QMARK_.call(null,cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(location.origin),cljs.core.str(".*$")].join('')),[cljs.core.str(uri)].join('')))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str(path),cljs.core.str("?"),cljs.core.str(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__28503__auto__ = [];
var len__28496__auto___88835 = arguments.length;
var i__28497__auto___88836 = (0);
while(true){
if((i__28497__auto___88836 < len__28496__auto___88835)){
args__28503__auto__.push((arguments[i__28497__auto___88836]));

var G__88837 = (i__28497__auto___88836 + (1));
i__28497__auto___88836 = G__88837;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__88825){
var map__88826 = p__88825;
var map__88826__$1 = ((((!((map__88826 == null)))?((((map__88826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88826.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88826):map__88826);
var processable_url_QMARK_ = cljs.core.get.call(null,map__88826__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__88826__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core88828 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core88828 = (function (dispatch_fn,match_fn,p__88825,map__88826,processable_url_QMARK_,identity_fn,history,event_keys,meta88829){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__88825 = p__88825;
this.map__88826 = map__88826;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta88829 = meta88829;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

pushy.core.t_pushy$core88828.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_88830,meta88829__$1){
var self__ = this;
var _88830__$1 = this;
return (new pushy.core.t_pushy$core88828(self__.dispatch_fn,self__.match_fn,self__.p__88825,self__.map__88826,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta88829__$1));
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_88830){
var self__ = this;
var _88830__$1 = this;
return self__.meta88829;
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$ = cljs.core.PROTOCOL_SENTINEL;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__6753__auto__)){
var match = temp__6753__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
));

var temp__6753__auto___88838 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__6753__auto___88838)){
var match_88839 = temp__6753__auto___88838;
self__.dispatch_fn.call(null,match_88839);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__6753__auto__)){
var el = temp__6753__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__27268__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__27268__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__27268__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__6751__auto___88840 = el.title;
if(cljs.core.truth_(temp__6751__auto___88840)){
var title_88841 = temp__6751__auto___88840;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_88841);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core88828.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__88831_88842 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__88832_88843 = null;
var count__88833_88844 = (0);
var i__88834_88845 = (0);
while(true){
if((i__88834_88845 < count__88833_88844)){
var key_88846 = cljs.core._nth.call(null,chunk__88832_88843,i__88834_88845);
goog.events.unlistenByKey(key_88846);

var G__88847 = seq__88831_88842;
var G__88848 = chunk__88832_88843;
var G__88849 = count__88833_88844;
var G__88850 = (i__88834_88845 + (1));
seq__88831_88842 = G__88847;
chunk__88832_88843 = G__88848;
count__88833_88844 = G__88849;
i__88834_88845 = G__88850;
continue;
} else {
var temp__6753__auto___88851 = cljs.core.seq.call(null,seq__88831_88842);
if(temp__6753__auto___88851){
var seq__88831_88852__$1 = temp__6753__auto___88851;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88831_88852__$1)){
var c__28186__auto___88853 = cljs.core.chunk_first.call(null,seq__88831_88852__$1);
var G__88854 = cljs.core.chunk_rest.call(null,seq__88831_88852__$1);
var G__88855 = c__28186__auto___88853;
var G__88856 = cljs.core.count.call(null,c__28186__auto___88853);
var G__88857 = (0);
seq__88831_88842 = G__88854;
chunk__88832_88843 = G__88855;
count__88833_88844 = G__88856;
i__88834_88845 = G__88857;
continue;
} else {
var key_88858 = cljs.core.first.call(null,seq__88831_88852__$1);
goog.events.unlistenByKey(key_88858);

var G__88859 = cljs.core.next.call(null,seq__88831_88852__$1);
var G__88860 = null;
var G__88861 = (0);
var G__88862 = (0);
seq__88831_88842 = G__88859;
chunk__88832_88843 = G__88860;
count__88833_88844 = G__88861;
i__88834_88845 = G__88862;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core88828.getBasis = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__88825","p__88825",-530527427,null),new cljs.core.Symbol(null,"map__88826","map__88826",753215844,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta88829","meta88829",-519076730,null)], null);
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core88828.cljs$lang$type = true;

pushy.core.t_pushy$core88828.cljs$lang$ctorStr = "pushy.core/t_pushy$core88828";

pushy.core.t_pushy$core88828.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"pushy.core/t_pushy$core88828");
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core88828 = ((function (history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core88828(dispatch_fn__$1,match_fn__$1,p__88825__$1,map__88826__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta88829){
return (new pushy.core.t_pushy$core88828(dispatch_fn__$1,match_fn__$1,p__88825__$1,map__88826__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta88829));
});})(history,event_keys,map__88826,map__88826__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core88828(dispatch_fn,match_fn,p__88825,map__88826__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq88822){
var G__88823 = cljs.core.first.call(null,seq88822);
var seq88822__$1 = cljs.core.next.call(null,seq88822);
var G__88824 = cljs.core.first.call(null,seq88822__$1);
var seq88822__$2 = cljs.core.next.call(null,seq88822__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__88823,G__88824,seq88822__$2);
});

/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args88863 = [];
var len__28496__auto___88866 = arguments.length;
var i__28497__auto___88867 = (0);
while(true){
if((i__28497__auto___88867 < len__28496__auto___88866)){
args88863.push((arguments[i__28497__auto___88867]));

var G__88868 = (i__28497__auto___88867 + (1));
i__28497__auto___88867 = G__88868;
continue;
} else {
}
break;
}

var G__88865 = args88863.length;
switch (G__88865) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args88863.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;

pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args88870 = [];
var len__28496__auto___88873 = arguments.length;
var i__28497__auto___88874 = (0);
while(true){
if((i__28497__auto___88874 < len__28496__auto___88873)){
args88870.push((arguments[i__28497__auto___88874]));

var G__88875 = (i__28497__auto___88874 + (1));
i__28497__auto___88874 = G__88875;
continue;
} else {
}
break;
}

var G__88872 = args88870.length;
switch (G__88872) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args88870.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1483479074895