// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.data_fetch');
goog.require('cljs.core');
goog.require('cljs_uuid_utils.core');
goog.require('clojure.set');
goog.require('untangled.client.logging');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.next.impl.parser');
goog.require('om.next.protocols');
goog.require('untangled.dom');
goog.require('untangled.client.mutations');
goog.require('om.util');
goog.require('om.next');
goog.require('clojure.walk');








/**
 * Test if the given bit of state is a data fetch state-tracking marker
 */
untangled.client.impl.data_fetch.data_state_QMARK_ = (function untangled$client$impl$data_fetch$data_state_QMARK_(state){
return cljs.core.contains_QMARK_.call(null,state,new cljs.core.Keyword("untangled.client.impl.data-fetch","type","untangled.client.impl.data-fetch/type",1691369040));
});
var is_kind_QMARK_ = (function untangled$client$impl$data_fetch$is_kind_QMARK_(state,type){
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_state_QMARK_.call(null,state))){
return cljs.core._EQ_.call(null,type,new cljs.core.Keyword("untangled.client.impl.data-fetch","type","untangled.client.impl.data-fetch/type",1691369040).cljs$core$IFn$_invoke$arity$1(state));
} else {
return false;
}
});
/**
 * Test if the given item is a data state marker that is in the ready state
 */
untangled.client.impl.data_fetch.ready_QMARK_ = (function untangled$client$impl$data_fetch$ready_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795));
});

/**
 * Test if the given item is a data state marker in the loading state
 */
untangled.client.impl.data_fetch.loading_QMARK_ = (function untangled$client$impl$data_fetch$loading_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189));
});

/**
 * Test if the given item is a data state marker in the failed state
 */
untangled.client.impl.data_fetch.failed_QMARK_ = (function untangled$client$impl$data_fetch$failed_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762));
});
/**
 * Place load markers in the app state at their data paths so that UI rendering can see them.
 */
untangled.client.impl.data_fetch.place_load_markers = (function untangled$client$impl$data_fetch$place_load_markers(state_atom,items_to_load){
var seq__22078 = cljs.core.seq.call(null,items_to_load);
var chunk__22079 = null;
var count__22080 = (0);
var i__22081 = (0);
while(true){
if((i__22081 < count__22080)){
var item = cljs.core._nth.call(null,chunk__22079,i__22081);
var i_22082 = untangled.client.impl.data_fetch.set_loading_BANG_.call(null,item);
var place_marker_22083 = ((function (seq__22078,chunk__22079,count__22080,i__22081,i_22082,item){
return (function (state){
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,i_22082))){
return cljs.core.assoc_in.call(null,state,untangled.client.impl.data_fetch.data_path.call(null,i_22082),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),i_22082], null));
} else {
return state;
}
});})(seq__22078,chunk__22079,count__22080,i__22081,i_22082,item))
;
cljs.core.swap_BANG_.call(null,state_atom,((function (seq__22078,chunk__22079,count__22080,i__22081,i_22082,place_marker_22083,item){
return (function (s){
return cljs.core.update.call(null,place_marker_22083.call(null,s),new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),untangled.client.impl.data_fetch.data_uuid.call(null,i_22082));
});})(seq__22078,chunk__22079,count__22080,i__22081,i_22082,place_marker_22083,item))
);

var G__22084 = seq__22078;
var G__22085 = chunk__22079;
var G__22086 = count__22080;
var G__22087 = (i__22081 + (1));
seq__22078 = G__22084;
chunk__22079 = G__22085;
count__22080 = G__22086;
i__22081 = G__22087;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22078);
if(temp__6753__auto__){
var seq__22078__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22078__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22078__$1);
var G__22088 = cljs.core.chunk_rest.call(null,seq__22078__$1);
var G__22089 = c__11725__auto__;
var G__22090 = cljs.core.count.call(null,c__11725__auto__);
var G__22091 = (0);
seq__22078 = G__22088;
chunk__22079 = G__22089;
count__22080 = G__22090;
i__22081 = G__22091;
continue;
} else {
var item = cljs.core.first.call(null,seq__22078__$1);
var i_22092 = untangled.client.impl.data_fetch.set_loading_BANG_.call(null,item);
var place_marker_22093 = ((function (seq__22078,chunk__22079,count__22080,i__22081,i_22092,item,seq__22078__$1,temp__6753__auto__){
return (function (state){
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,i_22092))){
return cljs.core.assoc_in.call(null,state,untangled.client.impl.data_fetch.data_path.call(null,i_22092),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),i_22092], null));
} else {
return state;
}
});})(seq__22078,chunk__22079,count__22080,i__22081,i_22092,item,seq__22078__$1,temp__6753__auto__))
;
cljs.core.swap_BANG_.call(null,state_atom,((function (seq__22078,chunk__22079,count__22080,i__22081,i_22092,place_marker_22093,item,seq__22078__$1,temp__6753__auto__){
return (function (s){
return cljs.core.update.call(null,place_marker_22093.call(null,s),new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),untangled.client.impl.data_fetch.data_uuid.call(null,i_22092));
});})(seq__22078,chunk__22079,count__22080,i__22081,i_22092,place_marker_22093,item,seq__22078__$1,temp__6753__auto__))
);

var G__22094 = cljs.core.next.call(null,seq__22078__$1);
var G__22095 = null;
var G__22096 = (0);
var G__22097 = (0);
seq__22078 = G__22094;
chunk__22079 = G__22095;
count__22080 = G__22096;
i__22081 = G__22097;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and return maps with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `callback-args` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
untangled.client.impl.data_fetch.mark_parallel_loading = (function untangled$client$impl$data_fetch$mark_parallel_loading(reconciler){
var state = om.next.app_state.call(null,reconciler);
var queued_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824));
var items_to_load = cljs.core.filter.call(null,new cljs.core.Keyword("untangled.client.impl.data-fetch","parallel","untangled.client.impl.data-fetch/parallel",-1305867292),queued_items);
if(cljs.core.empty_QMARK_.call(null,items_to_load)){
return null;
} else {
untangled.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),true,new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824),cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.Keyword("untangled.client.impl.data-fetch","parallel","untangled.client.impl.data-fetch/parallel",-1305867292)),queued_items));

var iter__11680__auto__ = ((function (state,queued_items,items_to_load){
return (function untangled$client$impl$data_fetch$mark_parallel_loading_$_iter__22102(s__22103){
return (new cljs.core.LazySeq(null,((function (state,queued_items,items_to_load){
return (function (){
var s__22103__$1 = s__22103;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__22103__$1);
if(temp__6753__auto__){
var s__22103__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22103__$2)){
var c__11678__auto__ = cljs.core.chunk_first.call(null,s__22103__$2);
var size__11679__auto__ = cljs.core.count.call(null,c__11678__auto__);
var b__22105 = cljs.core.chunk_buffer.call(null,size__11679__auto__);
if((function (){var i__22104 = (0);
while(true){
if((i__22104 < size__11679__auto__)){
var item = cljs.core._nth.call(null,c__11678__auto__,i__22104);
cljs.core.chunk_append.call(null,b__22105,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),untangled.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),untangled.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),untangled.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"callback-args","callback-args",1117743591),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null));

var G__22106 = (i__22104 + (1));
i__22104 = G__22106;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22105),untangled$client$impl$data_fetch$mark_parallel_loading_$_iter__22102.call(null,cljs.core.chunk_rest.call(null,s__22103__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22105),null);
}
} else {
var item = cljs.core.first.call(null,s__22103__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),untangled.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),untangled.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),untangled.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"callback-args","callback-args",1117743591),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null),untangled$client$impl$data_fetch$mark_parallel_loading_$_iter__22102.call(null,cljs.core.rest.call(null,s__22103__$2)));
}
} else {
return null;
}
break;
}
});})(state,queued_items,items_to_load))
,null,null));
});})(state,queued_items,items_to_load))
;
return iter__11680__auto__.call(null,items_to_load);
}
});
/**
 * Returns a lazy sequence of the elements of coll with dupes removed.
 * An element is a duplicate IFF (keys-fn element) has key collision with any prior element
 * to come before it. E.g. (dedupe-by identity [[:a] [:b] [:a] [:a :c]]) => [[:a] [:b]]
 * Returns a stateful transducer when no collection is provided.
 */
untangled.client.impl.data_fetch.dedupe_by = (function untangled$client$impl$data_fetch$dedupe_by(var_args){
var args22107 = [];
var len__11895__auto___22110 = arguments.length;
var i__11896__auto___22111 = (0);
while(true){
if((i__11896__auto___22111 < len__11895__auto___22110)){
args22107.push((arguments[i__11896__auto___22111]));

var G__22112 = (i__11896__auto___22111 + (1));
i__11896__auto___22111 = G__22112;
continue;
} else {
}
break;
}

var G__22109 = args22107.length;
switch (G__22109) {
case 1:
return untangled.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22107.length)].join('')));

}
});

untangled.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (keys_fn){
return (function (rf){
var keys_seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return ((function (keys_seen){
return (function() {
var G__22114 = null;
var G__22114__0 = (function (){
return rf.call(null);
});
var G__22114__1 = (function (result){
return rf.call(null,result);
});
var G__22114__2 = (function (result,input){
var input_keys = cljs.core.set.call(null,keys_fn.call(null,input));
if(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,cljs.core.deref.call(null,keys_seen),input_keys))){
cljs.core._vreset_BANG_.call(null,keys_seen,clojure.set.union.call(null,cljs.core._deref.call(null,keys_seen),input_keys));

return rf.call(null,result,input);
} else {
return result;
}
});
G__22114 = function(result,input){
switch(arguments.length){
case 0:
return G__22114__0.call(this);
case 1:
return G__22114__1.call(this,result);
case 2:
return G__22114__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22114.cljs$core$IFn$_invoke$arity$0 = G__22114__0;
G__22114.cljs$core$IFn$_invoke$arity$1 = G__22114__1;
G__22114.cljs$core$IFn$_invoke$arity$2 = G__22114__2;
return G__22114;
})()
;})(keys_seen))
});
});

untangled.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (keys_fn,coll){
return cljs.core.sequence.call(null,untangled.client.impl.data_fetch.dedupe_by.call(null,keys_fn),coll);
});

untangled.client.impl.data_fetch.dedupe_by.cljs$lang$maxFixedArity = 2;

untangled.client.impl.data_fetch.join_key_or_nil = (function untangled$client$impl$data_fetch$join_key_or_nil(expr){
if(cljs.core.truth_(om.util.join_QMARK_.call(null,expr))){
var join_key_or_ident = om.util.join_key.call(null,expr);
if(om.util.ident_QMARK_.call(null,join_key_or_ident)){
return cljs.core.first.call(null,join_key_or_ident);
} else {
return join_key_or_ident;
}
} else {
return null;
}
});
untangled.client.impl.data_fetch.split_items_ready_to_load = (function untangled$client$impl$data_fetch$split_items_ready_to_load(items_ready_to_load){
var items_to_load_now = cljs.core.set.call(null,untangled.client.impl.data_fetch.dedupe_by.call(null,(function (item){
return cljs.core.map.call(null,untangled.client.impl.data_fetch.join_key_or_nil,untangled.client.impl.data_fetch.data_query.call(null,item));
}),items_ready_to_load));
var items_to_defer = cljs.core.vec.call(null,cljs.core.remove.call(null,items_to_load_now,items_ready_to_load));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [items_to_load_now,items_to_defer], null);
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and returns a map with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `callback-args` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
untangled.client.impl.data_fetch.mark_loading = (function untangled$client$impl$data_fetch$mark_loading(reconciler){
var state = om.next.app_state.call(null,reconciler);
var items_ready_to_load = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824));
var vec__22118 = untangled.client.impl.data_fetch.split_items_ready_to_load.call(null,items_ready_to_load);
var items_to_load_now = cljs.core.nth.call(null,vec__22118,(0),null);
var items_to_defer = cljs.core.nth.call(null,vec__22118,(1),null);
if(cljs.core.empty_QMARK_.call(null,items_to_load_now)){
return null;
} else {
untangled.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load_now);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),true,new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824),items_to_defer);

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),untangled.client.impl.data_fetch.full_query.call(null,items_to_load_now),new cljs.core.Keyword(null,"on-load","on-load",1415151594),untangled.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),untangled.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"callback-args","callback-args",1117743591),items_to_load_now], null);
}
});
untangled.client.impl.data_fetch.valid_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ready","ready",1086465795),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"failed","failed",-1397425762),null], null), null);
/**
 * This is just a testing function -- using ready-state as public interface and call the
 *   `set-{type}!` functions to change it as needed.
 */
untangled.client.impl.data_fetch.make_data_state = (function untangled$client$impl$data_fetch$make_data_state(var_args){
var args22121 = [];
var len__11895__auto___22124 = arguments.length;
var i__11896__auto___22125 = (0);
while(true){
if((i__11896__auto___22125 < len__11895__auto___22124)){
args22121.push((arguments[i__11896__auto___22125]));

var G__22126 = (i__11896__auto___22125 + (1));
i__11896__auto___22125 = G__22126;
continue;
} else {
}
break;
}

var G__22123 = args22121.length;
switch (G__22123) {
case 1:
return untangled.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22121.length)].join('')));

}
});

untangled.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1 = (function (type){
return untangled.client.impl.data_fetch.make_data_state.call(null,type,cljs.core.PersistentArrayMap.EMPTY);
});

untangled.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2 = (function (type,params){
if(cljs.core.truth_(cljs.core.get.call(null,untangled.client.impl.data_fetch.valid_types,type))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("untangled.client.impl.data-fetch","type","untangled.client.impl.data-fetch/type",1691369040),type,new cljs.core.Keyword("untangled.client.impl.data-fetch","params","untangled.client.impl.data-fetch/params",194531151),params], null);
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("INVALID DATA STATE TYPE: "),cljs.core.str(type)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});

untangled.client.impl.data_fetch.make_data_state.cljs$lang$maxFixedArity = 2;

/**
 * Get the query for items that are ready to load into the given app state. Can be called any number of times
 *   (side effect free).
 */
untangled.client.impl.data_fetch.get_ready_query = (function untangled$client$impl$data_fetch$get_ready_query(state){
var items_to_load = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824));
if(cljs.core.empty_QMARK_.call(null,items_to_load)){
return null;
} else {
return om.next.impl.parser.expr__GT_ast.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"items-to-load","items-to-load",-1811352068),cljs.core.vec.call(null,cljs.core.mapcat.call(null,untangled.client.impl.data_fetch.data_query,items_to_load))], null));
}
});
/**
 * Remove items from a query (AST) that have a key listed in the elision-set
 */
untangled.client.impl.data_fetch.elide_ast_nodes = (function untangled$client$impl$data_fetch$elide_ast_nodes(p__22129,elision_set){
var map__22132 = p__22129;
var map__22132__$1 = ((((!((map__22132 == null)))?((((map__22132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22132):map__22132);
var ast = map__22132__$1;
var key = cljs.core.get.call(null,map__22132__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var union_key = cljs.core.get.call(null,map__22132__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var children = cljs.core.get.call(null,map__22132__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var union_elision_QMARK_ = cljs.core.contains_QMARK_.call(null,elision_set,union_key);
if((union_elision_QMARK_) || (cljs.core.contains_QMARK_.call(null,elision_set,key))){
return null;
} else {
if((union_elision_QMARK_) && ((cljs.core.count.call(null,children) <= (2)))){
untangled.client.logging.warn.call(null,"Om unions are not designed to be used with fewer than two children. Check your calls to Untangled\n        load functions where the :without set contains ",cljs.core.pr_str.call(null,union_key));
} else {
}

return cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"children","children",-940561982),((function (union_elision_QMARK_,map__22132,map__22132__$1,ast,key,union_key,children){
return (function (c){
return cljs.core.vec.call(null,cljs.core.keep.call(null,((function (union_elision_QMARK_,map__22132,map__22132__$1,ast,key,union_key,children){
return (function (p1__22128_SHARP_){
return untangled.client.impl.data_fetch.elide_ast_nodes.call(null,p1__22128_SHARP_,elision_set);
});})(union_elision_QMARK_,map__22132,map__22132__$1,ast,key,union_key,children))
,c));
});})(union_elision_QMARK_,map__22132,map__22132__$1,ast,key,union_key,children))
);
}
});
/**
 * Inject parameters into elements of the top-level query.
 * 
 *   `params` is a map from keyword (on the query in the AST) to parameter maps. So, given the AST for this query:
 * 
 *   ```
 *   [:a :b :c]
 *   ```
 * 
 *   and a `params` of `{:a {:x 1} :c {:y 2}}` you'll get an AST representing:
 * 
 *   ```
 *   [(:a {:x 1}) :b (:c {:y 2})]
 *   ```
 *   
 */
untangled.client.impl.data_fetch.inject_query_params = (function untangled$client$impl$data_fetch$inject_query_params(ast,params){
var top_level_keys = cljs.core.set.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast)));
var param_keys = cljs.core.set.call(null,cljs.core.keys.call(null,params));
var unknown_keys = clojure.set.difference.call(null,param_keys,top_level_keys);
if(!(cljs.core.empty_QMARK_.call(null,unknown_keys))){
untangled.client.logging.error.call(null,[cljs.core.str("Error: You attempted to add parameters for "),cljs.core.str(cljs.core.pr_str.call(null,unknown_keys)),cljs.core.str(" to top-level key(s) of "),cljs.core.str(cljs.core.pr_str.call(null,om.next.ast__GT_query.call(null,ast)))].join(''));
} else {
}

return cljs.core.update_in.call(null,ast,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"children","children",-940561982)], null),((function (top_level_keys,param_keys,unknown_keys){
return (function (p1__22134_SHARP_){
return cljs.core.map.call(null,((function (top_level_keys,param_keys,unknown_keys){
return (function (c){
var temp__6751__auto__ = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(c));
if(cljs.core.truth_(temp__6751__auto__)){
var new_params = temp__6751__auto__;
return cljs.core.update.call(null,c,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge,new_params);
} else {
return c;
}
});})(top_level_keys,param_keys,unknown_keys))
,p1__22134_SHARP_);
});})(top_level_keys,param_keys,unknown_keys))
);
});
/**
 * Generate a ready-to-load state with all of the necessary details to do
 *   remoting and merging.
 */
untangled.client.impl.data_fetch.ready_state = (function untangled$client$impl$data_fetch$ready_state(p__22135){
var map__22139 = p__22135;
var map__22139__$1 = ((((!((map__22139 == null)))?((((map__22139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22139.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22139):map__22139);
var target = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"target","target",253001721));
var query = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var refresh = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128));
var fallback = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"marker","marker",865118313),true);
var params = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"params","params",710516235));
var field = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var post_mutation = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY);
var ident = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"ident","ident",-742346));
var post_mutation_params = cljs.core.get.call(null,map__22139__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
if(cljs.core.truth_((function (){var or__11247__auto__ = field;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return query;
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("You must supply a query or a field/ident pair"),cljs.core.str("\n"),cljs.core.str("(or field query)")].join('')));
}

if(cljs.core.truth_((function (){var or__11247__auto__ = cljs.core.not.call(null,field);
if(or__11247__auto__){
return or__11247__auto__;
} else {
var and__11239__auto__ = field;
if(cljs.core.truth_(and__11239__auto__)){
return om.util.ident_QMARK_.call(null,ident);
} else {
return and__11239__auto__;
}
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Field requires ident"),cljs.core.str("\n"),cljs.core.str("(or (not field) (and field (util/ident? ident)))")].join('')));
}

var old_ast = om.next.query__GT_ast.call(null,query);
var ast = (function (){var G__22141 = old_ast;
var G__22141__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,without))?untangled.client.impl.data_fetch.elide_ast_nodes.call(null,G__22141,without):G__22141);
if(cljs.core.truth_(params)){
return untangled.client.impl.data_fetch.inject_query_params.call(null,G__22141__$1,params);
} else {
return G__22141__$1;
}
})();
var query_field = cljs.core.first.call(null,query);
var key = (cljs.core.truth_(om.util.join_QMARK_.call(null,query_field))?om.util.join_key.call(null,query_field):query_field);
var query_SINGLEQUOTE_ = om.next.ast__GT_query.call(null,ast);
if((cljs.core.not.call(null,field)) || (cljs.core._EQ_.call(null,field,key))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Component fetch query does not match supplied field."),cljs.core.str("\n"),cljs.core.str("(or (not field) (= field key))")].join('')));
}

return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation","untangled.client.impl.data-fetch/post-mutation",1595291971),new cljs.core.Keyword("untangled.client.impl.data-fetch","parallel","untangled.client.impl.data-fetch/parallel",-1305867292),new cljs.core.Keyword("untangled.client.impl.data-fetch","marker","untangled.client.impl.data-fetch/marker",-1816209083),new cljs.core.Keyword("untangled.client.impl.data-fetch","type","untangled.client.impl.data-fetch/type",1691369040),new cljs.core.Keyword("untangled.client.impl.data-fetch","ident","untangled.client.impl.data-fetch/ident",-550298382),new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation-params","untangled.client.impl.data-fetch/post-mutation-params",1847417555),new cljs.core.Keyword("untangled.client.impl.data-fetch","fallback","untangled.client.impl.data-fetch/fallback",1294531829),new cljs.core.Keyword("untangled.client.impl.data-fetch","query","untangled.client.impl.data-fetch/query",-1838118122),new cljs.core.Keyword("untangled.client.impl.data-fetch","field","untangled.client.impl.data-fetch/field",-635694536),new cljs.core.Keyword("untangled.client.impl.data-fetch","refresh","untangled.client.impl.data-fetch/refresh",-1831820519),new cljs.core.Keyword("untangled.client.impl.data-fetch","target","untangled.client.impl.data-fetch/target",-271110083),new cljs.core.Keyword("untangled.client.impl.data-fetch","uuid","untangled.client.impl.data-fetch/uuid",1591853213)],[post_mutation,parallel,marker,new cljs.core.Keyword(null,"ready","ready",1086465795),ident,post_mutation_params,fallback,query_SINGLEQUOTE_,field,refresh,target,cljs_uuid_utils.core.uuid_string.call(null,cljs_uuid_utils.core.make_random_squuid.call(null))]);
});
/**
 * Place a ready-to-load marker into the application state. This should be done from
 *   a mutate function that is abstractly loading something. This is intended for internal use.
 * 
 *   See the `load-data` and `load-field` functions in `untangled.client.data-fetch` for the public API.
 */
untangled.client.impl.data_fetch.mark_ready = (function untangled$client$impl$data_fetch$mark_ready(p__22142){
var map__22145 = p__22142;
var map__22145__$1 = ((((!((map__22145 == null)))?((((map__22145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22145):map__22145);
var config = map__22145__$1;
var state = cljs.core.get.call(null,map__22145__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword("om.next","ready-to-load","om.next/ready-to-load",-274898824),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),untangled.client.impl.data_fetch.ready_state.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"marker","marker",865118313),true,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY], null),config)));
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
untangled.client.impl.data_fetch.data_target = (function untangled$client$impl$data_fetch$data_target(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","target","untangled.client.impl.data-fetch/target",-271110083).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
untangled.client.impl.data_fetch.data_ident = (function untangled$client$impl$data_fetch$data_ident(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","ident","untangled.client.impl.data-fetch/ident",-550298382).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the query that will be sent to the server as a result of the given data state marker
 */
untangled.client.impl.data_fetch.data_query = (function untangled$client$impl$data_fetch$data_query(state){
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_ident.call(null,state))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.fromArray([untangled.client.impl.data_fetch.data_ident.call(null,state),new cljs.core.Keyword("untangled.client.impl.data-fetch","query","untangled.client.impl.data-fetch/query",-1838118122).cljs$core$IFn$_invoke$arity$1(state)], true, false)], null);
} else {
return new cljs.core.Keyword("untangled.client.impl.data-fetch","query","untangled.client.impl.data-fetch/query",-1838118122).cljs$core$IFn$_invoke$arity$1(state);
}
});
/**
 * Get the target field (if any) from the data state marker
 */
untangled.client.impl.data_fetch.data_field = (function untangled$client$impl$data_fetch$data_field(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","field","untangled.client.impl.data-fetch/field",-635694536).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the UUID of the data fetch
 */
untangled.client.impl.data_fetch.data_uuid = (function untangled$client$impl$data_fetch$data_uuid(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","uuid","untangled.client.impl.data-fetch/uuid",1591853213).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Test if the user desires a copy of the state marker to appear in the app state at the data path of the target data.
 */
untangled.client.impl.data_fetch.data_marker_QMARK_ = (function untangled$client$impl$data_fetch$data_marker_QMARK_(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","marker","untangled.client.impl.data-fetch/marker",-1816209083).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the list of query keywords that should be refreshed (re-rendered) when this load completes.
 */
untangled.client.impl.data_fetch.data_refresh = (function untangled$client$impl$data_fetch$data_refresh(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","refresh","untangled.client.impl.data-fetch/refresh",-1831820519).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the 'primary' query key of the data fetch. This is defined as the first keyword of the overall query (which might
 *   be a simple prop or join key for example)
 */
untangled.client.impl.data_fetch.data_query_key = (function untangled$client$impl$data_fetch$data_query_key(state){
var ast = om.next.query__GT_ast.call(null,new cljs.core.Keyword("untangled.client.impl.data-fetch","query","untangled.client.impl.data-fetch/query",-1838118122).cljs$core$IFn$_invoke$arity$1(state));
var node = cljs.core.first.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast));
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(node);
});
/**
 * Get the app-state database path of the target of the load that the given data state marker is trying to load.
 */
untangled.client.impl.data_fetch.data_path = (function untangled$client$impl$data_fetch$data_path(state){
var target = untangled.client.impl.data_fetch.data_target.call(null,state);
if(cljs.core.truth_((function (){var and__11239__auto__ = cljs.core.vector_QMARK_.call(null,target);
if(and__11239__auto__){
return cljs.core.not_empty.call(null,target);
} else {
return and__11239__auto__;
}
})())){
return target;
} else {
if((cljs.core.vector_QMARK_.call(null,untangled.client.impl.data_fetch.data_ident.call(null,state))) && ((untangled.client.impl.data_fetch.data_field.call(null,state) instanceof cljs.core.Keyword))){
return cljs.core.conj.call(null,untangled.client.impl.data_fetch.data_ident.call(null,state),untangled.client.impl.data_fetch.data_field.call(null,state));
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [untangled.client.impl.data_fetch.data_query_key.call(null,state)], null);

}
}
});
/**
 * Get the parameters that the user wants to add to the first join/keyword of the data fetch query.
 */
untangled.client.impl.data_fetch.data_params = (function untangled$client$impl$data_fetch$data_params(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","params","untangled.client.impl.data-fetch/params",194531151).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the keywords that should be (recursively) removed from the query that will be sent to the server.
 */
untangled.client.impl.data_fetch.data_exclusions = (function untangled$client$impl$data_fetch$data_exclusions(state){
return new cljs.core.Keyword("untangled.client.impl.data-fetch","without","untangled.client.impl.data-fetch/without",716864332).cljs$core$IFn$_invoke$arity$1(state);
});
var set_type = (function untangled$client$impl$data_fetch$set_type(state,type,params){
return cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("untangled.client.impl.data-fetch","type","untangled.client.impl.data-fetch/type",1691369040),type,new cljs.core.Keyword("untangled.client.impl.data-fetch","params","untangled.client.impl.data-fetch/params",194531151),params], null));
});
/**
 * Returns a state (based on the input state) that is in the 'ready' to load state.
 */
untangled.client.impl.data_fetch.set_ready_BANG_ = (function untangled$client$impl$data_fetch$set_ready_BANG_(var_args){
var args22147 = [];
var len__11895__auto___22156 = arguments.length;
var i__11896__auto___22157 = (0);
while(true){
if((i__11896__auto___22157 < len__11895__auto___22156)){
args22147.push((arguments[i__11896__auto___22157]));

var G__22158 = (i__11896__auto___22157 + (1));
i__11896__auto___22157 = G__22158;
continue;
} else {
}
break;
}

var G__22149 = args22147.length;
switch (G__22149) {
case 1:
return untangled.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22147.length)].join('')));

}
});

untangled.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return untangled.client.impl.data_fetch.set_ready_BANG_.call(null,state,null);
});

untangled.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795),params);
});

untangled.client.impl.data_fetch.set_ready_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the loading state (and ensures that it has a UUID)
 */
untangled.client.impl.data_fetch.set_loading_BANG_ = (function untangled$client$impl$data_fetch$set_loading_BANG_(var_args){
var args22150 = [];
var len__11895__auto___22160 = arguments.length;
var i__11896__auto___22161 = (0);
while(true){
if((i__11896__auto___22161 < len__11895__auto___22160)){
args22150.push((arguments[i__11896__auto___22161]));

var G__22162 = (i__11896__auto___22161 + (1));
i__11896__auto___22161 = G__22162;
continue;
} else {
}
break;
}

var G__22152 = args22150.length;
switch (G__22152) {
case 1:
return untangled.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22150.length)].join('')));

}
});

untangled.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return untangled.client.impl.data_fetch.set_loading_BANG_.call(null,state,null);
});

untangled.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
var rv = set_type.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189),params);
return cljs.core.with_meta.call(null,rv,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),rv], null));
});

untangled.client.impl.data_fetch.set_loading_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the error state
 */
untangled.client.impl.data_fetch.set_failed_BANG_ = (function untangled$client$impl$data_fetch$set_failed_BANG_(var_args){
var args22153 = [];
var len__11895__auto___22164 = arguments.length;
var i__11896__auto___22165 = (0);
while(true){
if((i__11896__auto___22165 < len__11895__auto___22164)){
args22153.push((arguments[i__11896__auto___22165]));

var G__22166 = (i__11896__auto___22165 + (1));
i__11896__auto___22165 = G__22166;
continue;
} else {
}
break;
}

var G__22155 = args22153.length;
switch (G__22155) {
case 1:
return untangled.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22153.length)].join('')));

}
});

untangled.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return untangled.client.impl.data_fetch.set_failed_BANG_.call(null,state,null);
});

untangled.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762),params);
});

untangled.client.impl.data_fetch.set_failed_BANG_.cljs$lang$maxFixedArity = 2;

/**
 * Composes together the queries of a sequence of data states into a single query.
 */
untangled.client.impl.data_fetch.full_query = (function untangled$client$impl$data_fetch$full_query(items){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (item){
return untangled.client.impl.data_fetch.data_query.call(null,item);
}),items));
});
untangled.client.impl.data_fetch.set_global_loading = (function untangled$client$impl$data_fetch$set_global_loading(reconciler){

var state_atom = om.next.app_state.call(null,reconciler);
var loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state_atom),new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825))));
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_);
});
/**
 * For items that are manually targeted, move them in app state from their result location to their target location.
 */
untangled.client.impl.data_fetch.relocate_targeted_results = (function untangled$client$impl$data_fetch$relocate_targeted_results(state_atom,items){
var seq__22172 = cljs.core.seq.call(null,items);
var chunk__22173 = null;
var count__22174 = (0);
var i__22175 = (0);
while(true){
if((i__22175 < count__22174)){
var item = cljs.core._nth.call(null,chunk__22173,i__22175);
var default_target_22176 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [untangled.client.impl.data_fetch.data_query_key.call(null,item)], null);
var field_target_22177 = cljs.core.conj.call(null,(function (){var or__11247__auto__ = untangled.client.impl.data_fetch.data_ident.call(null,item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),new cljs.core.Keyword("untangled.client.impl.data-fetch","field","untangled.client.impl.data-fetch/field",-635694536).cljs$core$IFn$_invoke$arity$1(item));
var explicit_target_22178 = (function (){var or__11247__auto__ = new cljs.core.Keyword("untangled.client.impl.data-fetch","target","untangled.client.impl.data-fetch/target",-271110083).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var relocate_QMARK__22179 = (function (){var and__11239__auto__ = cljs.core.not_empty.call(null,explicit_target_22178);
if(cljs.core.truth_(and__11239__auto__)){
return (cljs.core.not_EQ_.call(null,explicit_target_22178,field_target_22177)) && (cljs.core.not_EQ_.call(null,explicit_target_22178,default_target_22176));
} else {
return and__11239__auto__;
}
})();
if(cljs.core.truth_(relocate_QMARK__22179)){
var value_22180 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state_atom),default_target_22176);
cljs.core.swap_BANG_.call(null,state_atom,((function (seq__22172,chunk__22173,count__22174,i__22175,value_22180,default_target_22176,field_target_22177,explicit_target_22178,relocate_QMARK__22179,item){
return (function (m){
return cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,m,untangled.client.impl.data_fetch.data_query_key.call(null,item)),explicit_target_22178,value_22180);
});})(seq__22172,chunk__22173,count__22174,i__22175,value_22180,default_target_22176,field_target_22177,explicit_target_22178,relocate_QMARK__22179,item))
);
} else {
}

var G__22181 = seq__22172;
var G__22182 = chunk__22173;
var G__22183 = count__22174;
var G__22184 = (i__22175 + (1));
seq__22172 = G__22181;
chunk__22173 = G__22182;
count__22174 = G__22183;
i__22175 = G__22184;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22172);
if(temp__6753__auto__){
var seq__22172__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22172__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22172__$1);
var G__22185 = cljs.core.chunk_rest.call(null,seq__22172__$1);
var G__22186 = c__11725__auto__;
var G__22187 = cljs.core.count.call(null,c__11725__auto__);
var G__22188 = (0);
seq__22172 = G__22185;
chunk__22173 = G__22186;
count__22174 = G__22187;
i__22175 = G__22188;
continue;
} else {
var item = cljs.core.first.call(null,seq__22172__$1);
var default_target_22189 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [untangled.client.impl.data_fetch.data_query_key.call(null,item)], null);
var field_target_22190 = cljs.core.conj.call(null,(function (){var or__11247__auto__ = untangled.client.impl.data_fetch.data_ident.call(null,item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),new cljs.core.Keyword("untangled.client.impl.data-fetch","field","untangled.client.impl.data-fetch/field",-635694536).cljs$core$IFn$_invoke$arity$1(item));
var explicit_target_22191 = (function (){var or__11247__auto__ = new cljs.core.Keyword("untangled.client.impl.data-fetch","target","untangled.client.impl.data-fetch/target",-271110083).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var relocate_QMARK__22192 = (function (){var and__11239__auto__ = cljs.core.not_empty.call(null,explicit_target_22191);
if(cljs.core.truth_(and__11239__auto__)){
return (cljs.core.not_EQ_.call(null,explicit_target_22191,field_target_22190)) && (cljs.core.not_EQ_.call(null,explicit_target_22191,default_target_22189));
} else {
return and__11239__auto__;
}
})();
if(cljs.core.truth_(relocate_QMARK__22192)){
var value_22193 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state_atom),default_target_22189);
cljs.core.swap_BANG_.call(null,state_atom,((function (seq__22172,chunk__22173,count__22174,i__22175,value_22193,default_target_22189,field_target_22190,explicit_target_22191,relocate_QMARK__22192,item,seq__22172__$1,temp__6753__auto__){
return (function (m){
return cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,m,untangled.client.impl.data_fetch.data_query_key.call(null,item)),explicit_target_22191,value_22193);
});})(seq__22172,chunk__22173,count__22174,i__22175,value_22193,default_target_22189,field_target_22190,explicit_target_22191,relocate_QMARK__22192,item,seq__22172__$1,temp__6753__auto__))
);
} else {
}

var G__22194 = cljs.core.next.call(null,seq__22172__$1);
var G__22195 = null;
var G__22196 = (0);
var G__22197 = (0);
seq__22172 = G__22194;
chunk__22173 = G__22195;
count__22174 = G__22196;
i__22175 = G__22197;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Generates a callback that processes all of the post-processing steps once a remote load has completed. This includes:
 * 
 *   - Marking the items that were queries for but not returned as 'missing' (see documentation on mark and sweep of db)
 *   - Refreshing elements of the UI that were included in the data fetch :refresh option
 *   - Removing loading markers related to the executed loads that were not overwritten by incoming data
 *   - Merging the incoming data into the normalized database
 *   - Running post-mutations for any fetches that completed
 *   - Updating the global loading marker
 *   - Forcing a global re-render if post-mutations ran (may change in future versions)
 *   
 */
untangled.client.impl.data_fetch.loaded_callback = (function untangled$client$impl$data_fetch$loaded_callback(reconciler){
return (function (response,items){
var query = untangled.client.impl.data_fetch.full_query.call(null,items);
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,untangled.client.impl.data_fetch.set_loading_BANG_,items));
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,untangled.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var marked_response = untangled.client.impl.om_plumbing.mark_missing.call(null,response,query);
var app_state = om.next.app_state.call(null,reconciler);
var ran_mutations = cljs.core.atom.call(null,false);
var remove_markers = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (){
var seq__22210 = cljs.core.seq.call(null,loading_items);
var chunk__22211 = null;
var count__22212 = (0);
var i__22213 = (0);
while(true){
if((i__22213 < count__22212)){
var item = cljs.core._nth.call(null,chunk__22211,i__22213);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__22210,chunk__22211,count__22212,i__22213,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__22214 = s;
var G__22214__$1 = cljs.core.update.call(null,G__22214,new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.disj,untangled.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return cljs.core.assoc_in.call(null,G__22214__$1,untangled.client.impl.data_fetch.data_path.call(null,item),null);
} else {
return G__22214__$1;
}
});})(seq__22210,chunk__22211,count__22212,i__22213,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__22222 = seq__22210;
var G__22223 = chunk__22211;
var G__22224 = count__22212;
var G__22225 = (i__22213 + (1));
seq__22210 = G__22222;
chunk__22211 = G__22223;
count__22212 = G__22224;
i__22213 = G__22225;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22210);
if(temp__6753__auto__){
var seq__22210__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22210__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22210__$1);
var G__22226 = cljs.core.chunk_rest.call(null,seq__22210__$1);
var G__22227 = c__11725__auto__;
var G__22228 = cljs.core.count.call(null,c__11725__auto__);
var G__22229 = (0);
seq__22210 = G__22226;
chunk__22211 = G__22227;
count__22212 = G__22228;
i__22213 = G__22229;
continue;
} else {
var item = cljs.core.first.call(null,seq__22210__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__22210,chunk__22211,count__22212,i__22213,item,seq__22210__$1,temp__6753__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__22215 = s;
var G__22215__$1 = cljs.core.update.call(null,G__22215,new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.disj,untangled.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return cljs.core.assoc_in.call(null,G__22215__$1,untangled.client.impl.data_fetch.data_path.call(null,item),null);
} else {
return G__22215__$1;
}
});})(seq__22210,chunk__22211,count__22212,i__22213,item,seq__22210__$1,temp__6753__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__22230 = cljs.core.next.call(null,seq__22210__$1);
var G__22231 = null;
var G__22232 = (0);
var G__22233 = (0);
seq__22210 = G__22230;
chunk__22211 = G__22231;
count__22212 = G__22232;
i__22213 = G__22233;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
;
var run_post_mutations = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers){
return (function (){
var seq__22216 = cljs.core.seq.call(null,loading_items);
var chunk__22217 = null;
var count__22218 = (0);
var i__22219 = (0);
while(true){
if((i__22219 < count__22218)){
var item = cljs.core._nth.call(null,chunk__22217,i__22219);
var temp__6753__auto___22234 = new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation","untangled.client.impl.data-fetch/post-mutation",1595291971).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__6753__auto___22234)){
var mutation_symbol_22235 = temp__6753__auto___22234;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_22236 = (function (){var or__11247__auto__ = new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation-params","untangled.client.impl.data-fetch/post-mutation-params",1847417555).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var G__22220_22237 = untangled.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),om.next.app_state.call(null,reconciler)], null),mutation_symbol_22235,params_22236);
var G__22220_22238__$1 = (((G__22220_22237 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__22220_22237));
if((G__22220_22238__$1 == null)){
} else {
cljs.core.apply.call(null,G__22220_22238__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__22239 = seq__22216;
var G__22240 = chunk__22217;
var G__22241 = count__22218;
var G__22242 = (i__22219 + (1));
seq__22216 = G__22239;
chunk__22217 = G__22240;
count__22218 = G__22241;
i__22219 = G__22242;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22216);
if(temp__6753__auto__){
var seq__22216__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22216__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22216__$1);
var G__22243 = cljs.core.chunk_rest.call(null,seq__22216__$1);
var G__22244 = c__11725__auto__;
var G__22245 = cljs.core.count.call(null,c__11725__auto__);
var G__22246 = (0);
seq__22216 = G__22243;
chunk__22217 = G__22244;
count__22218 = G__22245;
i__22219 = G__22246;
continue;
} else {
var item = cljs.core.first.call(null,seq__22216__$1);
var temp__6753__auto___22247__$1 = new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation","untangled.client.impl.data-fetch/post-mutation",1595291971).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__6753__auto___22247__$1)){
var mutation_symbol_22248 = temp__6753__auto___22247__$1;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_22249 = (function (){var or__11247__auto__ = new cljs.core.Keyword("untangled.client.impl.data-fetch","post-mutation-params","untangled.client.impl.data-fetch/post-mutation-params",1847417555).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var G__22221_22250 = untangled.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),om.next.app_state.call(null,reconciler)], null),mutation_symbol_22248,params_22249);
var G__22221_22251__$1 = (((G__22221_22250 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__22221_22250));
if((G__22221_22251__$1 == null)){
} else {
cljs.core.apply.call(null,G__22221_22251__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__22252 = cljs.core.next.call(null,seq__22216__$1);
var G__22253 = null;
var G__22254 = (0);
var G__22255 = (0);
seq__22216 = G__22252;
chunk__22217 = G__22253;
count__22218 = G__22254;
i__22219 = G__22255;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers))
;
remove_markers.call(null);

om.next.merge_BANG_.call(null,reconciler,marked_response,query);

untangled.client.impl.data_fetch.relocate_targeted_results.call(null,app_state,loading_items);

run_post_mutations.call(null);

untangled.client.impl.data_fetch.set_global_loading.call(null,reconciler);

if(cljs.core.contains_QMARK_.call(null,refresh_set,new cljs.core.Keyword("untangled","force-root","untangled/force-root",513707319))){
return untangled.dom.force_render.call(null,reconciler);
} else {
return untangled.dom.force_render.call(null,reconciler,to_refresh);
}
});
});
/**
 * Generates a callback that is used whenever a hard server error occurs (status code 400+ or network error).
 * 
 *   The generated callback:
 * 
 *   - Replaces affected loading markers with error markers (if :marker is true on the load item)
 *   - Runs fallbacks associated with the loads
 *   - Sets the global error marker (:untangled/server-error)
 *   - Refreshes UI
 *   
 */
untangled.client.impl.data_fetch.error_callback = (function untangled$client$impl$data_fetch$error_callback(reconciler){
return (function (error,items){
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,untangled.client.impl.data_fetch.set_loading_BANG_,items));
var app_state = om.next.app_state.call(null,reconciler);
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,untangled.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var ran_fallbacks = cljs.core.atom.call(null,false);
var mark_errors = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (){
cljs.core.swap_BANG_.call(null,app_state,cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var seq__22268 = cljs.core.seq.call(null,loading_items);
var chunk__22269 = null;
var count__22270 = (0);
var i__22271 = (0);
while(true){
if((i__22271 < count__22270)){
var item = cljs.core._nth.call(null,chunk__22269,i__22271);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__22268,chunk__22269,count__22270,i__22271,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__22272 = s;
var G__22272__$1 = (cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__22272,cljs.core.conj.call(null,untangled.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),untangled.client.impl.data_fetch.set_failed_BANG_,error):G__22272);
return cljs.core.update.call(null,G__22272__$1,new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.disj,untangled.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__22268,chunk__22269,count__22270,i__22271,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__22280 = seq__22268;
var G__22281 = chunk__22269;
var G__22282 = count__22270;
var G__22283 = (i__22271 + (1));
seq__22268 = G__22280;
chunk__22269 = G__22281;
count__22270 = G__22282;
i__22271 = G__22283;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22268);
if(temp__6753__auto__){
var seq__22268__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22268__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22268__$1);
var G__22284 = cljs.core.chunk_rest.call(null,seq__22268__$1);
var G__22285 = c__11725__auto__;
var G__22286 = cljs.core.count.call(null,c__11725__auto__);
var G__22287 = (0);
seq__22268 = G__22284;
chunk__22269 = G__22285;
count__22270 = G__22286;
i__22271 = G__22287;
continue;
} else {
var item = cljs.core.first.call(null,seq__22268__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__22268,chunk__22269,count__22270,i__22271,item,seq__22268__$1,temp__6753__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__22273 = s;
var G__22273__$1 = (cljs.core.truth_(untangled.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__22273,cljs.core.conj.call(null,untangled.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),untangled.client.impl.data_fetch.set_failed_BANG_,error):G__22273);
return cljs.core.update.call(null,G__22273__$1,new cljs.core.Keyword("untangled","loads-in-progress","untangled/loads-in-progress",-1826138825),cljs.core.disj,untangled.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__22268,chunk__22269,count__22270,i__22271,item,seq__22268__$1,temp__6753__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__22288 = cljs.core.next.call(null,seq__22268__$1);
var G__22289 = null;
var G__22290 = (0);
var G__22291 = (0);
seq__22268 = G__22288;
chunk__22269 = G__22289;
count__22270 = G__22290;
i__22271 = G__22291;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
;
var run_fallbacks = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors){
return (function (){
var seq__22274 = cljs.core.seq.call(null,loading_items);
var chunk__22275 = null;
var count__22276 = (0);
var i__22277 = (0);
while(true){
if((i__22277 < count__22276)){
var item = cljs.core._nth.call(null,chunk__22275,i__22277);
var temp__6753__auto___22292 = new cljs.core.Keyword("untangled.client.impl.data-fetch","fallback","untangled.client.impl.data-fetch/fallback",1294531829).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__6753__auto___22292)){
var fallback_symbol_22293 = temp__6753__auto___22292;
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__22278_22294 = untangled.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),app_state], null),fallback_symbol_22293,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__22278_22295__$1 = (((G__22278_22294 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__22278_22294));
if((G__22278_22295__$1 == null)){
} else {
cljs.core.apply.call(null,G__22278_22295__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__22296 = seq__22274;
var G__22297 = chunk__22275;
var G__22298 = count__22276;
var G__22299 = (i__22277 + (1));
seq__22274 = G__22296;
chunk__22275 = G__22297;
count__22276 = G__22298;
i__22277 = G__22299;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__22274);
if(temp__6753__auto__){
var seq__22274__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22274__$1)){
var c__11725__auto__ = cljs.core.chunk_first.call(null,seq__22274__$1);
var G__22300 = cljs.core.chunk_rest.call(null,seq__22274__$1);
var G__22301 = c__11725__auto__;
var G__22302 = cljs.core.count.call(null,c__11725__auto__);
var G__22303 = (0);
seq__22274 = G__22300;
chunk__22275 = G__22301;
count__22276 = G__22302;
i__22277 = G__22303;
continue;
} else {
var item = cljs.core.first.call(null,seq__22274__$1);
var temp__6753__auto___22304__$1 = new cljs.core.Keyword("untangled.client.impl.data-fetch","fallback","untangled.client.impl.data-fetch/fallback",1294531829).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__6753__auto___22304__$1)){
var fallback_symbol_22305 = temp__6753__auto___22304__$1;
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__22279_22306 = untangled.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),app_state], null),fallback_symbol_22305,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__22279_22307__$1 = (((G__22279_22306 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__22279_22306));
if((G__22279_22307__$1 == null)){
} else {
cljs.core.apply.call(null,G__22279_22307__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__22308 = cljs.core.next.call(null,seq__22274__$1);
var G__22309 = null;
var G__22310 = (0);
var G__22311 = (0);
seq__22274 = G__22308;
chunk__22275 = G__22309;
count__22276 = G__22310;
i__22277 = G__22311;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors))
;
mark_errors.call(null);

om.next.merge_BANG_.call(null,reconciler,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),untangled.dom.unique_key.call(null)], null));

run_fallbacks.call(null);

untangled.client.impl.data_fetch.set_global_loading.call(null,reconciler);

if(cljs.core.contains_QMARK_.call(null,refresh_set,new cljs.core.Keyword("untangled","force-root","untangled/force-root",513707319))){
return untangled.dom.force_render.call(null,reconciler);
} else {
return untangled.dom.force_render.call(null,reconciler,to_refresh);
}
});
});

//# sourceMappingURL=data_fetch.js.map?rel=1485292055651