// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.logging');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('om.next');
goog.require('goog.log');
goog.require('goog.debug.Logger.Level');
untangled.client.logging.set_level = (function untangled$client$logging$set_level(log_level){

return om.next._STAR_logger_STAR_.setLevel(goog.debug.Logger.Level.getPredefinedLevel((function (){var G__21864 = (((log_level instanceof cljs.core.Keyword))?log_level.fqn:null);
switch (G__21864) {
case "all":
return "ALL";

break;
case "debug":
return "FINE";

break;
case "info":
return "INFO";

break;
case "warn":
return "WARNING";

break;
case "error":
return "SEVERE";

break;
case "none":
return "OFF";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(log_level)].join('')));

}
})()));
});
/**
 * Include a pretty-printed cljs value as a string with the given text message.
 */
untangled.client.logging.value_message = (function untangled$client$logging$value_message(msg,val){
return [cljs.core.str(msg),cljs.core.str(":\n"),cljs.core.str((function (){var sb__11834__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_21868_21870 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_21869_21871 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_21868_21870,_STAR_print_fn_STAR_21869_21871,sb__11834__auto__){
return (function (x__11835__auto__){
return sb__11834__auto__.append(x__11835__auto__);
});})(_STAR_print_newline_STAR_21868_21870,_STAR_print_fn_STAR_21869_21871,sb__11834__auto__))
;

try{cljs.pprint.pprint.call(null,val);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_21869_21871;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_21868_21870;
}
return [cljs.core.str(sb__11834__auto__)].join('');
})())].join('');
});
/**
 * Print a debug message to the Om logger which includes a value.
 *        Returns the value (like identity) so it can be harmlessly nested in expressions.
 */
untangled.client.logging.debug = (function untangled$client$logging$debug(var_args){
var args21872 = [];
var len__11895__auto___21875 = arguments.length;
var i__11896__auto___21876 = (0);
while(true){
if((i__11896__auto___21876 < len__11895__auto___21875)){
args21872.push((arguments[i__11896__auto___21876]));

var G__21877 = (i__11896__auto___21876 + (1));
i__11896__auto___21876 = G__21877;
continue;
} else {
}
break;
}

var G__21874 = args21872.length;
switch (G__21874) {
case 1:
return untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21872.length)].join('')));

}
});

untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$1 = (function (value){
goog.log.fine(om.next._STAR_logger_STAR_,untangled.client.logging.value_message.call(null,"DEBUG",value));

return value;
});

untangled.client.logging.debug.cljs$core$IFn$_invoke$arity$2 = (function (msg,value){
goog.log.fine(om.next._STAR_logger_STAR_,untangled.client.logging.value_message.call(null,msg,value));

return value;
});

untangled.client.logging.debug.cljs$lang$maxFixedArity = 2;

/**
 * output an INFO level message to the Om logger
 */
untangled.client.logging.info = (function untangled$client$logging$info(var_args){
var args__11898__auto__ = [];
var len__11895__auto___21880 = arguments.length;
var i__11896__auto___21881 = (0);
while(true){
if((i__11896__auto___21881 < len__11895__auto___21880)){
args__11898__auto__.push((arguments[i__11896__auto___21881]));

var G__21882 = (i__11896__auto___21881 + (1));
i__11896__auto___21881 = G__21882;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((0) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(argseq__11899__auto__);
});

untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.info(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.info.cljs$lang$maxFixedArity = (0);

untangled.client.logging.info.cljs$lang$applyTo = (function (seq21879){
return untangled.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21879));
});

/**
 * output a WARNING level message to the Om logger
 */
untangled.client.logging.warn = (function untangled$client$logging$warn(var_args){
var args__11898__auto__ = [];
var len__11895__auto___21884 = arguments.length;
var i__11896__auto___21885 = (0);
while(true){
if((i__11896__auto___21885 < len__11895__auto___21884)){
args__11898__auto__.push((arguments[i__11896__auto___21885]));

var G__21886 = (i__11896__auto___21885 + (1));
i__11896__auto___21885 = G__21886;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((0) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(argseq__11899__auto__);
});

untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.warning(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.warn.cljs$lang$maxFixedArity = (0);

untangled.client.logging.warn.cljs$lang$applyTo = (function (seq21883){
return untangled.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21883));
});

/**
 * output an ERROR level message to the Om logger
 */
untangled.client.logging.error = (function untangled$client$logging$error(var_args){
var args__11898__auto__ = [];
var len__11895__auto___21888 = arguments.length;
var i__11896__auto___21889 = (0);
while(true){
if((i__11896__auto___21889 < len__11895__auto___21888)){
args__11898__auto__.push((arguments[i__11896__auto___21889]));

var G__21890 = (i__11896__auto___21889 + (1));
i__11896__auto___21889 = G__21890;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((0) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((0)),(0),null)):null);
return untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(argseq__11899__auto__);
});

untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.error(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

untangled.client.logging.error.cljs$lang$maxFixedArity = (0);

untangled.client.logging.error.cljs$lang$applyTo = (function (seq21887){
return untangled.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21887));
});


//# sourceMappingURL=logging.js.map?rel=1485292055083