// Compiled by ClojureScript 1.9.293 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');

cljs.core.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});

cljs.core.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});


com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

goog.math.Long.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;


goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});


com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});


com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

goog.math.Long.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;


goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});


com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});


com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;


com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__87372_87376 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__87373_87377 = null;
var count__87374_87378 = (0);
var i__87375_87379 = (0);
while(true){
if((i__87375_87379 < count__87374_87378)){
var k_87380 = cljs.core._nth.call(null,chunk__87373_87377,i__87375_87379);
var v_87381 = (b[k_87380]);
(a[k_87380] = v_87381);

var G__87382 = seq__87372_87376;
var G__87383 = chunk__87373_87377;
var G__87384 = count__87374_87378;
var G__87385 = (i__87375_87379 + (1));
seq__87372_87376 = G__87382;
chunk__87373_87377 = G__87383;
count__87374_87378 = G__87384;
i__87375_87379 = G__87385;
continue;
} else {
var temp__6753__auto___87386 = cljs.core.seq.call(null,seq__87372_87376);
if(temp__6753__auto___87386){
var seq__87372_87387__$1 = temp__6753__auto___87386;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__87372_87387__$1)){
var c__28186__auto___87388 = cljs.core.chunk_first.call(null,seq__87372_87387__$1);
var G__87389 = cljs.core.chunk_rest.call(null,seq__87372_87387__$1);
var G__87390 = c__28186__auto___87388;
var G__87391 = cljs.core.count.call(null,c__28186__auto___87388);
var G__87392 = (0);
seq__87372_87376 = G__87389;
chunk__87373_87377 = G__87390;
count__87374_87378 = G__87391;
i__87375_87379 = G__87392;
continue;
} else {
var k_87393 = cljs.core.first.call(null,seq__87372_87387__$1);
var v_87394 = (b[k_87393]);
(a[k_87393] = v_87394);

var G__87395 = cljs.core.next.call(null,seq__87372_87387__$1);
var G__87396 = null;
var G__87397 = (0);
var G__87398 = (0);
seq__87372_87376 = G__87395;
chunk__87373_87377 = G__87396;
count__87374_87378 = G__87397;
i__87375_87379 = G__87398;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args87399 = [];
var len__28496__auto___87402 = arguments.length;
var i__28497__auto___87403 = (0);
while(true){
if((i__28497__auto___87403 < len__28496__auto___87402)){
args87399.push((arguments[i__28497__auto___87403]));

var G__87404 = (i__28497__auto___87403 + (1));
i__28497__auto___87403 = G__87404;
continue;
} else {
}
break;
}

var G__87401 = args87399.length;
switch (G__87401) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args87399.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__87406 = (i + (2));
var G__87407 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__87406;
ret = G__87407;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__87408_87412 = cljs.core.seq.call(null,v);
var chunk__87409_87413 = null;
var count__87410_87414 = (0);
var i__87411_87415 = (0);
while(true){
if((i__87411_87415 < count__87410_87414)){
var x_87416 = cljs.core._nth.call(null,chunk__87409_87413,i__87411_87415);
ret.push(x_87416);

var G__87417 = seq__87408_87412;
var G__87418 = chunk__87409_87413;
var G__87419 = count__87410_87414;
var G__87420 = (i__87411_87415 + (1));
seq__87408_87412 = G__87417;
chunk__87409_87413 = G__87418;
count__87410_87414 = G__87419;
i__87411_87415 = G__87420;
continue;
} else {
var temp__6753__auto___87421 = cljs.core.seq.call(null,seq__87408_87412);
if(temp__6753__auto___87421){
var seq__87408_87422__$1 = temp__6753__auto___87421;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__87408_87422__$1)){
var c__28186__auto___87423 = cljs.core.chunk_first.call(null,seq__87408_87422__$1);
var G__87424 = cljs.core.chunk_rest.call(null,seq__87408_87422__$1);
var G__87425 = c__28186__auto___87423;
var G__87426 = cljs.core.count.call(null,c__28186__auto___87423);
var G__87427 = (0);
seq__87408_87412 = G__87424;
chunk__87409_87413 = G__87425;
count__87410_87414 = G__87426;
i__87411_87415 = G__87427;
continue;
} else {
var x_87428 = cljs.core.first.call(null,seq__87408_87422__$1);
ret.push(x_87428);

var G__87429 = cljs.core.next.call(null,seq__87408_87422__$1);
var G__87430 = null;
var G__87431 = (0);
var G__87432 = (0);
seq__87408_87412 = G__87429;
chunk__87409_87413 = G__87430;
count__87410_87414 = G__87431;
i__87411_87415 = G__87432;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__87433_87437 = cljs.core.seq.call(null,v);
var chunk__87434_87438 = null;
var count__87435_87439 = (0);
var i__87436_87440 = (0);
while(true){
if((i__87436_87440 < count__87435_87439)){
var x_87441 = cljs.core._nth.call(null,chunk__87434_87438,i__87436_87440);
ret.push(x_87441);

var G__87442 = seq__87433_87437;
var G__87443 = chunk__87434_87438;
var G__87444 = count__87435_87439;
var G__87445 = (i__87436_87440 + (1));
seq__87433_87437 = G__87442;
chunk__87434_87438 = G__87443;
count__87435_87439 = G__87444;
i__87436_87440 = G__87445;
continue;
} else {
var temp__6753__auto___87446 = cljs.core.seq.call(null,seq__87433_87437);
if(temp__6753__auto___87446){
var seq__87433_87447__$1 = temp__6753__auto___87446;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__87433_87447__$1)){
var c__28186__auto___87448 = cljs.core.chunk_first.call(null,seq__87433_87447__$1);
var G__87449 = cljs.core.chunk_rest.call(null,seq__87433_87447__$1);
var G__87450 = c__28186__auto___87448;
var G__87451 = cljs.core.count.call(null,c__28186__auto___87448);
var G__87452 = (0);
seq__87433_87437 = G__87449;
chunk__87434_87438 = G__87450;
count__87435_87439 = G__87451;
i__87436_87440 = G__87452;
continue;
} else {
var x_87453 = cljs.core.first.call(null,seq__87433_87447__$1);
ret.push(x_87453);

var G__87454 = cljs.core.next.call(null,seq__87433_87447__$1);
var G__87455 = null;
var G__87456 = (0);
var G__87457 = (0);
seq__87433_87437 = G__87454;
chunk__87434_87438 = G__87455;
count__87435_87439 = G__87456;
i__87436_87440 = G__87457;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__87458_87462 = cljs.core.seq.call(null,v);
var chunk__87459_87463 = null;
var count__87460_87464 = (0);
var i__87461_87465 = (0);
while(true){
if((i__87461_87465 < count__87460_87464)){
var x_87466 = cljs.core._nth.call(null,chunk__87459_87463,i__87461_87465);
ret.push(x_87466);

var G__87467 = seq__87458_87462;
var G__87468 = chunk__87459_87463;
var G__87469 = count__87460_87464;
var G__87470 = (i__87461_87465 + (1));
seq__87458_87462 = G__87467;
chunk__87459_87463 = G__87468;
count__87460_87464 = G__87469;
i__87461_87465 = G__87470;
continue;
} else {
var temp__6753__auto___87471 = cljs.core.seq.call(null,seq__87458_87462);
if(temp__6753__auto___87471){
var seq__87458_87472__$1 = temp__6753__auto___87471;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__87458_87472__$1)){
var c__28186__auto___87473 = cljs.core.chunk_first.call(null,seq__87458_87472__$1);
var G__87474 = cljs.core.chunk_rest.call(null,seq__87458_87472__$1);
var G__87475 = c__28186__auto___87473;
var G__87476 = cljs.core.count.call(null,c__28186__auto___87473);
var G__87477 = (0);
seq__87458_87462 = G__87474;
chunk__87459_87463 = G__87475;
count__87460_87464 = G__87476;
i__87461_87465 = G__87477;
continue;
} else {
var x_87478 = cljs.core.first.call(null,seq__87458_87472__$1);
ret.push(x_87478);

var G__87479 = cljs.core.next.call(null,seq__87458_87472__$1);
var G__87480 = null;
var G__87481 = (0);
var G__87482 = (0);
seq__87458_87462 = G__87479;
chunk__87459_87463 = G__87480;
count__87460_87464 = G__87481;
i__87461_87465 = G__87482;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args87483 = [];
var len__28496__auto___87498 = arguments.length;
var i__28497__auto___87499 = (0);
while(true){
if((i__28497__auto___87499 < len__28496__auto___87498)){
args87483.push((arguments[i__28497__auto___87499]));

var G__87500 = (i__28497__auto___87499 + (1));
i__28497__auto___87499 = G__87500;
continue;
} else {
}
break;
}

var G__87485 = args87483.length;
switch (G__87485) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args87483.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__87486 = obj;
G__87486.push(kfn.call(null,k),vfn.call(null,v));

return G__87486;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x87487 = cljs.core.clone.call(null,handlers);
x87487.forEach = ((function (x87487,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__87488 = cljs.core.seq.call(null,coll);
var chunk__87489 = null;
var count__87490 = (0);
var i__87491 = (0);
while(true){
if((i__87491 < count__87490)){
var vec__87492 = cljs.core._nth.call(null,chunk__87489,i__87491);
var k = cljs.core.nth.call(null,vec__87492,(0),null);
var v = cljs.core.nth.call(null,vec__87492,(1),null);
f.call(null,v,k);

var G__87502 = seq__87488;
var G__87503 = chunk__87489;
var G__87504 = count__87490;
var G__87505 = (i__87491 + (1));
seq__87488 = G__87502;
chunk__87489 = G__87503;
count__87490 = G__87504;
i__87491 = G__87505;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__87488);
if(temp__6753__auto__){
var seq__87488__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__87488__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__87488__$1);
var G__87506 = cljs.core.chunk_rest.call(null,seq__87488__$1);
var G__87507 = c__28186__auto__;
var G__87508 = cljs.core.count.call(null,c__28186__auto__);
var G__87509 = (0);
seq__87488 = G__87506;
chunk__87489 = G__87507;
count__87490 = G__87508;
i__87491 = G__87509;
continue;
} else {
var vec__87495 = cljs.core.first.call(null,seq__87488__$1);
var k = cljs.core.nth.call(null,vec__87495,(0),null);
var v = cljs.core.nth.call(null,vec__87495,(1),null);
f.call(null,v,k);

var G__87510 = cljs.core.next.call(null,seq__87488__$1);
var G__87511 = null;
var G__87512 = (0);
var G__87513 = (0);
seq__87488 = G__87510;
chunk__87489 = G__87511;
count__87490 = G__87512;
i__87491 = G__87513;
continue;
}
} else {
return null;
}
}
break;
}
});})(x87487,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x87487;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args87514 = [];
var len__28496__auto___87520 = arguments.length;
var i__28497__auto___87521 = (0);
while(true){
if((i__28497__auto___87521 < len__28496__auto___87520)){
args87514.push((arguments[i__28497__auto___87521]));

var G__87522 = (i__28497__auto___87521 + (1));
i__28497__auto___87521 = G__87522;
continue;
} else {
}
break;
}

var G__87516 = args87514.length;
switch (G__87516) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args87514.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit87517 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit87517 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta87518){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta87518 = meta87518;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cognitect.transit.t_cognitect$transit87517.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_87519,meta87518__$1){
var self__ = this;
var _87519__$1 = this;
return (new cognitect.transit.t_cognitect$transit87517(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta87518__$1));
});


cognitect.transit.t_cognitect$transit87517.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_87519){
var self__ = this;
var _87519__$1 = this;
return self__.meta87518;
});

cognitect.transit.t_cognitect$transit87517.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit87517.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit87517.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit87517.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit87517.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta87518","meta87518",-773315314,null)], null);
});

cognitect.transit.t_cognitect$transit87517.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit87517.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit87517";

cognitect.transit.t_cognitect$transit87517.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cognitect.transit/t_cognitect$transit87517");
});

cognitect.transit.__GT_t_cognitect$transit87517 = (function cognitect$transit$__GT_t_cognitect$transit87517(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta87518){
return (new cognitect.transit.t_cognitect$transit87517(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta87518));
});

}

return (new cognitect.transit.t_cognitect$transit87517(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__27280__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1483479068837