// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('untangled.i18n.core');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.util');
goog.require('untangled.client.impl.data_fetch');
goog.require('om.next');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__220063,query){
var map__220066 = p__220063;
var map__220066__$1 = ((((!((map__220066 == null)))?((((map__220066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220066.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220066):map__220066);
var reconciler = cljs.core.get.call(null,map__220066__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__220066,map__220066__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__220066,map__220066__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__){
return (function (state_220083){
var state_val_220084 = (state_220083[(1)]);
if((state_val_220084 === (1))){
var state_220083__$1 = state_220083;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_220083__$1,(2),q,v);
} else {
if((state_val_220084 === (2))){
var inst_220081 = (state_220083[(2)]);
var state_220083__$1 = state_220083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_220083__$1,inst_220081);
} else {
return null;
}
}
});})(c__41974__auto__))
;
return ((function (switch__41860__auto__,c__41974__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__41861__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__41861__auto____0 = (function (){
var statearr_220088 = [null,null,null,null,null,null,null];
(statearr_220088[(0)] = untangled$client$impl$application$enqueue_$_state_machine__41861__auto__);

(statearr_220088[(1)] = (1));

return statearr_220088;
});
var untangled$client$impl$application$enqueue_$_state_machine__41861__auto____1 = (function (state_220083){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_220083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e220089){if((e220089 instanceof Object)){
var ex__41864__auto__ = e220089;
var statearr_220090_220092 = state_220083;
(statearr_220090_220092[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_220083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e220089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__220093 = state_220083;
state_220083 = G__220093;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__41861__auto__ = function(state_220083){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__41861__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__41861__auto____1.call(this,state_220083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__41861__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__41861__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__))
})();
var state__41976__auto__ = (function (){var statearr_220091 = f__41975__auto__.call(null);
(statearr_220091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_220091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__))
);

return c__41974__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__220095,remote_tx_map,cb){
var map__220098 = p__220095;
var map__220098__$1 = ((((!((map__220098 == null)))?((((map__220098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220098.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220098):map__220098);
var app = map__220098__$1;
var queue = cljs.core.get.call(null,map__220098__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__220098,map__220098__$1,app,queue){
return (function (p1__220094_SHARP_){
return fallback.call(null,p1__220094_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__220098,map__220098__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__220102){
var map__220113 = p__220102;
var map__220113__$1 = ((((!((map__220113 == null)))?((((map__220113.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220113.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220113):map__220113);
var queue = cljs.core.get.call(null,map__220113__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__220113__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__220113__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__220115_220123 = cljs.core.seq.call(null,parallel_payload);
var chunk__220116_220124 = null;
var count__220117_220125 = (0);
var i__220118_220126 = (0);
while(true){
if((i__220118_220126 < count__220117_220125)){
var map__220119_220127 = cljs.core._nth.call(null,chunk__220116_220124,i__220118_220126);
var map__220119_220128__$1 = ((((!((map__220119_220127 == null)))?((((map__220119_220127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220119_220127.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220119_220127):map__220119_220127);
var query_220129 = cljs.core.get.call(null,map__220119_220128__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_220130 = cljs.core.get.call(null,map__220119_220128__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_220131 = cljs.core.get.call(null,map__220119_220128__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_220132 = cljs.core.get.call(null,map__220119_220128__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__220133 = ((function (seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,map__220119_220127,map__220119_220128__$1,query_220129,on_load_220130,on_error_220131,callback_args_220132,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking){
return (function (p1__220100_SHARP_){
return on_load_220130.call(null,p1__220100_SHARP_,callback_args_220132);
});})(seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,map__220119_220127,map__220119_220128__$1,query_220129,on_load_220130,on_error_220131,callback_args_220132,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__220134 = ((function (seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,on_load_SINGLEQUOTE__220133,map__220119_220127,map__220119_220128__$1,query_220129,on_load_220130,on_error_220131,callback_args_220132,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking){
return (function (p1__220101_SHARP_){
return on_error_220131.call(null,p1__220101_SHARP_,callback_args_220132);
});})(seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,on_load_SINGLEQUOTE__220133,map__220119_220127,map__220119_220128__$1,query_220129,on_load_220130,on_error_220131,callback_args_220132,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_220129,on_load_SINGLEQUOTE__220133,on_error_SINGLEQUOTE__220134);

var G__220135 = seq__220115_220123;
var G__220136 = chunk__220116_220124;
var G__220137 = count__220117_220125;
var G__220138 = (i__220118_220126 + (1));
seq__220115_220123 = G__220135;
chunk__220116_220124 = G__220136;
count__220117_220125 = G__220137;
i__220118_220126 = G__220138;
continue;
} else {
var temp__6753__auto___220139 = cljs.core.seq.call(null,seq__220115_220123);
if(temp__6753__auto___220139){
var seq__220115_220140__$1 = temp__6753__auto___220139;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__220115_220140__$1)){
var c__28186__auto___220141 = cljs.core.chunk_first.call(null,seq__220115_220140__$1);
var G__220142 = cljs.core.chunk_rest.call(null,seq__220115_220140__$1);
var G__220143 = c__28186__auto___220141;
var G__220144 = cljs.core.count.call(null,c__28186__auto___220141);
var G__220145 = (0);
seq__220115_220123 = G__220142;
chunk__220116_220124 = G__220143;
count__220117_220125 = G__220144;
i__220118_220126 = G__220145;
continue;
} else {
var map__220121_220146 = cljs.core.first.call(null,seq__220115_220140__$1);
var map__220121_220147__$1 = ((((!((map__220121_220146 == null)))?((((map__220121_220146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220121_220146.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220121_220146):map__220121_220146);
var query_220148 = cljs.core.get.call(null,map__220121_220147__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_220149 = cljs.core.get.call(null,map__220121_220147__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_220150 = cljs.core.get.call(null,map__220121_220147__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_220151 = cljs.core.get.call(null,map__220121_220147__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__220152 = ((function (seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,map__220121_220146,map__220121_220147__$1,query_220148,on_load_220149,on_error_220150,callback_args_220151,seq__220115_220140__$1,temp__6753__auto___220139,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking){
return (function (p1__220100_SHARP_){
return on_load_220149.call(null,p1__220100_SHARP_,callback_args_220151);
});})(seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,map__220121_220146,map__220121_220147__$1,query_220148,on_load_220149,on_error_220150,callback_args_220151,seq__220115_220140__$1,temp__6753__auto___220139,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__220153 = ((function (seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,on_load_SINGLEQUOTE__220152,map__220121_220146,map__220121_220147__$1,query_220148,on_load_220149,on_error_220150,callback_args_220151,seq__220115_220140__$1,temp__6753__auto___220139,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking){
return (function (p1__220101_SHARP_){
return on_error_220150.call(null,p1__220101_SHARP_,callback_args_220151);
});})(seq__220115_220123,chunk__220116_220124,count__220117_220125,i__220118_220126,on_load_SINGLEQUOTE__220152,map__220121_220146,map__220121_220147__$1,query_220148,on_load_220149,on_error_220150,callback_args_220151,seq__220115_220140__$1,temp__6753__auto___220139,parallel_payload,map__220113,map__220113__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_220148,on_load_SINGLEQUOTE__220152,on_error_SINGLEQUOTE__220153);

var G__220154 = cljs.core.next.call(null,seq__220115_220140__$1);
var G__220155 = null;
var G__220156 = (0);
var G__220157 = (0);
seq__220115_220123 = G__220154;
chunk__220116_220124 = G__220155;
count__220117_220125 = G__220156;
i__220118_220126 = G__220157;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__220158 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__220158;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__220159){
var map__220278 = p__220159;
var map__220278__$1 = ((((!((map__220278 == null)))?((((map__220278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220278.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220278):map__220278);
var networking = cljs.core.get.call(null,map__220278__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__220278__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__220278__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__220278,map__220278__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__220278,map__220278__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__41974__auto___220396 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel){
return (function (state_220319){
var state_val_220320 = (state_220319[(1)]);
if((state_val_220320 === (1))){
var state_220319__$1 = state_220319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_220319__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_220320 === (2))){
var inst_220317 = (state_220319[(2)]);
var state_220319__$1 = state_220319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_220319__$1,inst_220317);
} else {
return null;
}
}
});})(c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel))
;
return ((function (switch__41860__auto__,c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____0 = (function (){
var statearr_220324 = [null,null,null,null,null,null,null];
(statearr_220324[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__);

(statearr_220324[(1)] = (1));

return statearr_220324;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____1 = (function (state_220319){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_220319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e220325){if((e220325 instanceof Object)){
var ex__41864__auto__ = e220325;
var statearr_220326_220397 = state_220319;
(statearr_220326_220397[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_220319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e220325;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__220398 = state_220319;
state_220319 = G__220398;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__ = function(state_220319){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____1.call(this,state_220319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel))
})();
var state__41976__auto__ = (function (){var statearr_220327 = f__41975__auto__.call(null);
(statearr_220327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___220396);

return statearr_220327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___220396,map__220278,map__220278__$1,networking,queue,response_channel))
);

}});
;})(map__220278,map__220278__$1,networking,queue,response_channel))
});})(map__220278,map__220278__$1,networking,queue,response_channel))
;
var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel){
return (function (state_220369){
var state_val_220370 = (state_220369[(1)]);
if((state_val_220370 === (7))){
var inst_220348 = (state_220369[(2)]);
var state_220369__$1 = state_220369;
if(cljs.core.truth_(inst_220348)){
var statearr_220371_220399 = state_220369__$1;
(statearr_220371_220399[(1)] = (11));

} else {
var statearr_220372_220400 = state_220369__$1;
(statearr_220372_220400[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (1))){
var state_220369__$1 = state_220369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_220369__$1,(2),queue);
} else {
if((state_val_220370 === (4))){
var inst_220367 = (state_220369[(2)]);
var state_220369__$1 = state_220369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_220369__$1,inst_220367);
} else {
if((state_val_220370 === (15))){
var inst_220364 = (state_220369[(2)]);
var inst_220330 = inst_220364;
var state_220369__$1 = (function (){var statearr_220373 = state_220369;
(statearr_220373[(7)] = inst_220330);

return statearr_220373;
})();
var statearr_220374_220401 = state_220369__$1;
(statearr_220374_220401[(2)] = null);

(statearr_220374_220401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (13))){
var inst_220353 = (state_220369[(2)]);
var inst_220354 = cljs.core.get.call(null,inst_220353,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_220355 = cljs.core.get.call(null,inst_220353,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_220356 = cljs.core.get.call(null,inst_220353,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_220357 = cljs.core.get.call(null,inst_220353,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_220358 = make_process_response.call(null,inst_220355,inst_220357);
var inst_220359 = make_process_response.call(null,inst_220356,inst_220357);
var inst_220360 = untangled.client.impl.application.real_send.call(null,networking,inst_220354,inst_220358,inst_220359);
var state_220369__$1 = (function (){var statearr_220375 = state_220369;
(statearr_220375[(8)] = inst_220360);

return statearr_220375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_220369__$1,(14),response_channel);
} else {
if((state_val_220370 === (6))){
var state_220369__$1 = state_220369;
var statearr_220376_220402 = state_220369__$1;
(statearr_220376_220402[(2)] = false);

(statearr_220376_220402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (3))){
var inst_220330 = (state_220369[(7)]);
var inst_220334 = (inst_220330 == null);
var inst_220335 = cljs.core.not.call(null,inst_220334);
var state_220369__$1 = state_220369;
if(inst_220335){
var statearr_220377_220403 = state_220369__$1;
(statearr_220377_220403[(1)] = (5));

} else {
var statearr_220378_220404 = state_220369__$1;
(statearr_220378_220404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (12))){
var inst_220330 = (state_220369[(7)]);
var state_220369__$1 = state_220369;
var statearr_220379_220405 = state_220369__$1;
(statearr_220379_220405[(2)] = inst_220330);

(statearr_220379_220405[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (2))){
var inst_220329 = (state_220369[(2)]);
var inst_220330 = inst_220329;
var state_220369__$1 = (function (){var statearr_220380 = state_220369;
(statearr_220380[(7)] = inst_220330);

return statearr_220380;
})();
var statearr_220381_220406 = state_220369__$1;
(statearr_220381_220406[(2)] = null);

(statearr_220381_220406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (11))){
var inst_220330 = (state_220369[(7)]);
var inst_220350 = cljs.core.apply.call(null,cljs.core.hash_map,inst_220330);
var state_220369__$1 = state_220369;
var statearr_220382_220407 = state_220369__$1;
(statearr_220382_220407[(2)] = inst_220350);

(statearr_220382_220407[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (9))){
var state_220369__$1 = state_220369;
var statearr_220383_220408 = state_220369__$1;
(statearr_220383_220408[(2)] = false);

(statearr_220383_220408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (5))){
var inst_220330 = (state_220369[(7)]);
var inst_220337 = inst_220330.cljs$lang$protocol_mask$partition0$;
var inst_220338 = (inst_220337 & (64));
var inst_220339 = inst_220330.cljs$core$ISeq$;
var inst_220340 = (cljs.core.PROTOCOL_SENTINEL === inst_220339);
var inst_220341 = (inst_220338) || (inst_220340);
var state_220369__$1 = state_220369;
if(cljs.core.truth_(inst_220341)){
var statearr_220384_220409 = state_220369__$1;
(statearr_220384_220409[(1)] = (8));

} else {
var statearr_220385_220410 = state_220369__$1;
(statearr_220385_220410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (14))){
var inst_220362 = (state_220369[(2)]);
var state_220369__$1 = (function (){var statearr_220386 = state_220369;
(statearr_220386[(9)] = inst_220362);

return statearr_220386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_220369__$1,(15),queue);
} else {
if((state_val_220370 === (10))){
var inst_220345 = (state_220369[(2)]);
var state_220369__$1 = state_220369;
var statearr_220387_220411 = state_220369__$1;
(statearr_220387_220411[(2)] = inst_220345);

(statearr_220387_220411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_220370 === (8))){
var state_220369__$1 = state_220369;
var statearr_220388_220412 = state_220369__$1;
(statearr_220388_220412[(2)] = true);

(statearr_220388_220412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel))
;
return ((function (switch__41860__auto__,c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____0 = (function (){
var statearr_220392 = [null,null,null,null,null,null,null,null,null,null];
(statearr_220392[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__);

(statearr_220392[(1)] = (1));

return statearr_220392;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____1 = (function (state_220369){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_220369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e220393){if((e220393 instanceof Object)){
var ex__41864__auto__ = e220393;
var statearr_220394_220413 = state_220369;
(statearr_220394_220413[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_220369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e220393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__220414 = state_220369;
state_220369 = G__220414;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__ = function(state_220369){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____1.call(this,state_220369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel))
})();
var state__41976__auto__ = (function (){var statearr_220395 = f__41975__auto__.call(null);
(statearr_220395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_220395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__,map__220278,map__220278__$1,networking,queue,response_channel))
);

return c__41974__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__220419){
var vec__220420 = p__220419;
var k = cljs.core.nth.call(null,vec__220420,(0),null);
var v = cljs.core.nth.call(null,vec__220420,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__220427){
var vec__220428 = p__220427;
var k = cljs.core.nth.call(null,vec__220428,(0),null);
var v = cljs.core.nth.call(null,vec__220428,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__220435){
var vec__220436 = p__220435;
var k = cljs.core.nth.call(null,vec__220436,(0),null);
var v = cljs.core.nth.call(null,vec__220436,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__220447){
var vec__220448 = p__220447;
var k = cljs.core.nth.call(null,vec__220448,(0),null);
var _ = cljs.core.nth.call(null,vec__220448,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__220451){
var vec__220452 = p__220451;
var k = cljs.core.nth.call(null,vec__220452,(0),null);
var v = cljs.core.nth.call(null,vec__220452,(1),null);
if(cljs.core.truth_((function (){var and__27268__auto__ = mutation_merge;
if(cljs.core.truth_(and__27268__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__27268__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__220455,initial_state,parser,p__220456){
var map__220461 = p__220455;
var map__220461__$1 = ((((!((map__220461 == null)))?((((map__220461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220461.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220461):map__220461);
var app = map__220461__$1;
var queue = cljs.core.get.call(null,map__220461__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__220461__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__220462 = p__220456;
var map__220462__$1 = ((((!((map__220462 == null)))?((((map__220462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220462.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220462):map__220462);
var pathopt = cljs.core.get.call(null,map__220462__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__220462__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__220462__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = (cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,initial_state))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__220461,map__220461__$1,app,queue,mutation_merge,map__220462,map__220462__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__220465_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__220465_SHARP_)){
return cljs.core.partial.call(null,p1__220465_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1483481837872