// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.protocol_support');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('untangled.client.impl.protocol_support');
goog.require('untangled_spec.core');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.tempid');
goog.require('om.next');
/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to the optimistic update for transactions going to the server
 *   `ui-tx`: the om transaction that modifies the app state prior to receiving a server response
 *   `optimistic-delta`: the expected changes to the app state after executing ui-tx. See Protocol Testing README for how
 *   to build this properly.
 */
untangled.client.protocol_support.check_optimistic_update = (function untangled$client$protocol_support$check_optimistic_update(var_args){
var args__28503__auto__ = [];
var len__28496__auto___220881 = arguments.length;
var i__28497__auto___220882 = (0);
while(true){
if((i__28497__auto___220882 < len__28496__auto___220881)){
args__28503__auto__.push((arguments[i__28497__auto___220882]));

var G__220883 = (i__28497__auto___220882 + (1));
i__28497__auto___220882 = G__220883;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic = (function (p__220873,p__220874){
var map__220875 = p__220873;
var map__220875__$1 = ((((!((map__220875 == null)))?((((map__220875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220875.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220875):map__220875);
var data = map__220875__$1;
var initial_ui_state = cljs.core.get.call(null,map__220875__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__220875__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var optimistic_delta = cljs.core.get.call(null,map__220875__$1,new cljs.core.Keyword(null,"optimistic-delta","optimistic-delta",-2118700684));
var map__220876 = p__220874;
var map__220876__$1 = ((((!((map__220876 == null)))?((((map__220876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220876):map__220876);
var env = cljs.core.get.call(null,map__220876__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("state not allowed in the env argument"),cljs.core.str("\n"),cljs.core.str("(not (:state env))")].join('')));
}

cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Optimistic Updates");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));

var map__220879_220884 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__220879_220885__$1 = ((((!((map__220879_220884 == null)))?((((map__220879_220884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220879_220884.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220879_220884):map__220879_220884);
var parser_220886 = cljs.core.get.call(null,map__220879_220885__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_220887 = cljs.core.atom.call(null,initial_ui_state);
var parse_220888 = cljs.core.partial.call(null,parser_220886,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_220887], null),env));
var tempid_map_220889 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_220890__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_220889);
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"trigger correct state transitions");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));

parse_220888.call(null,ui_tx_220890__$1);

untangled.client.impl.protocol_support.check_delta.call(null,untangled.client.impl.protocol_support.rewrite_tempids.call(null,cljs.core.deref.call(null,state_220887),clojure.set.map_invert.call(null,tempid_map_220889),om.tempid.tempid_QMARK_),optimistic_delta);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_optimistic_update.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_optimistic_update.cljs$lang$applyTo = (function (seq220871){
var G__220872 = cljs.core.first.call(null,seq220871);
var seq220871__$1 = cljs.core.next.call(null,seq220871);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic(G__220872,seq220871__$1);
});

/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to sending the server transaction
 *   `ui-tx`: the om transaction that modifies the app state locally
 *   `server-tx`: the server transaction corresponding to ui-tx
 */
untangled.client.protocol_support.check_server_tx = (function untangled$client$protocol_support$check_server_tx(var_args){
var args__28503__auto__ = [];
var len__28496__auto___220902 = arguments.length;
var i__28497__auto___220903 = (0);
while(true){
if((i__28497__auto___220903 < len__28496__auto___220902)){
args__28503__auto__.push((arguments[i__28497__auto___220903]));

var G__220904 = (i__28497__auto___220903 + (1));
i__28497__auto___220903 = G__220904;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic = (function (p__220893,p__220894){
var map__220895 = p__220893;
var map__220895__$1 = ((((!((map__220895 == null)))?((((map__220895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220895.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220895):map__220895);
var initial_ui_state = cljs.core.get.call(null,map__220895__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__220895__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var server_tx = cljs.core.get.call(null,map__220895__$1,new cljs.core.Keyword(null,"server-tx","server-tx",-1146708246));
var map__220896 = p__220894;
var map__220896__$1 = ((((!((map__220896 == null)))?((((map__220896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220896.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220896):map__220896);
var env = cljs.core.get.call(null,map__220896__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Client Remoting");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));

var map__220899_220905 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__220899_220906__$1 = ((((!((map__220899_220905 == null)))?((((map__220899_220905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220899_220905.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220899_220905):map__220899_220905);
var parser_220907 = cljs.core.get.call(null,map__220899_220906__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_220908 = cljs.core.atom.call(null,initial_ui_state);
var parse_220909 = cljs.core.partial.call(null,parser_220907,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_220908], null),env));
var tempid_map_220910 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_220911__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_220910);
parse_220909.call(null,ui_tx_220911__$1);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

try{cljs.test.do_report.call(null,(function (){var act__38294__auto__ = untangled.client.impl.protocol_support.rewrite_tempids.call(null,untangled.client.impl.om_plumbing.strip_ui.call(null,untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,parse_220909.call(null,ui_tx_220911__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576)))),clojure.set.map_invert.call(null,tempid_map_220910),om.tempid.tempid_QMARK_);
var exp__38295__auto__ = server_tx;
var result__38296__auto__ = cljs.core._EQ_.call(null,exp__38295__auto__,act__38294__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__38296__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__38295__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__38294__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null);
})());
}catch (e220901){var t__32383__auto___220912 = e220901;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"server-tx","server-tx",493823281,null),cljs.core.list(new cljs.core.Symbol(null,"->","->",-2139605430,null),cljs.core.list(new cljs.core.Symbol(null,"parse","parse",478366908,null),new cljs.core.Symbol(null,"ui-tx","ui-tx",62864806,null),new cljs.core.Keyword(null,"remote","remote",-1593576576)),new cljs.core.Symbol("plumbing","remove-loads-and-fallbacks","plumbing/remove-loads-and-fallbacks",-474759113,null),new cljs.core.Symbol("plumbing","strip-ui","plumbing/strip-ui",-2004815259,null),cljs.core.list(new cljs.core.Symbol("impl","rewrite-tempids","impl/rewrite-tempids",-1005245316,null),cljs.core.list(new cljs.core.Symbol("set","map-invert","set/map-invert",1259038818,null),new cljs.core.Symbol(null,"tempid-map","tempid-map",-1148551297,null)),new cljs.core.Symbol("omt","tempid?","omt/tempid?",2034821487,null)))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32383__auto___220912,new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null));
}
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_server_tx.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_server_tx.cljs$lang$applyTo = (function (seq220891){
var G__220892 = cljs.core.first.call(null,seq220891);
var seq220891__$1 = cljs.core.next.call(null,seq220891);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic(G__220892,seq220891__$1);
});

/**
 * Takes a map containing:
 *   `response`: the exact data the server sends back to the client
 *   `pre-response-state`: normalized state prior to receiving `response`
 *   `server-tx`: the transaction originally sent to the server, yielding `response`
 *   `merge-delta`: the delta between `pre-response-state` and its integration with `response`
 */
untangled.client.protocol_support.check_response_from_server = (function untangled$client$protocol_support$check_response_from_server(p__220913){
var map__220919 = p__220913;
var map__220919__$1 = ((((!((map__220919 == null)))?((((map__220919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220919):map__220919);
var response = cljs.core.get.call(null,map__220919__$1,new cljs.core.Keyword(null,"response","response",-1068424192));
var pre_response_state = cljs.core.get.call(null,map__220919__$1,new cljs.core.Keyword(null,"pre-response-state","pre-response-state",696272294));
var ui_tx = cljs.core.get.call(null,map__220919__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var merge_delta = cljs.core.get.call(null,map__220919__$1,new cljs.core.Keyword(null,"merge-delta","merge-delta",-1454035297));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Server response merged with app state");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));

var map__220921_220924 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__220921_220925__$1 = ((((!((map__220921_220924 == null)))?((((map__220921_220924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__220921_220924.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__220921_220924):map__220921_220924);
var reconciler_220926 = cljs.core.get.call(null,map__220921_220925__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state_220927 = om.next.app_state.call(null,reconciler_220926);
cljs.core.reset_BANG_.call(null,state_220927,pre_response_state);

om.next.merge_BANG_.call(null,reconciler_220926,response,ui_tx);

if(cljs.core.truth_(merge_delta)){
untangled.client.impl.protocol_support.check_delta.call(null,cljs.core.deref.call(null,state_220927),merge_delta);
} else {
try{cljs.test.do_report.call(null,(function (){var act__38294__auto__ = cljs.core.deref.call(null,state_220927);
var exp__38295__auto__ = pre_response_state;
var result__38296__auto__ = cljs.core._EQ_.call(null,exp__38295__auto__,act__38294__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__38296__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__38295__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__38294__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null);
})());
}catch (e220923){var t__32383__auto___220928 = e220923;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"pre-response-state","pre-response-state",-1958163475,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"state","state",-348086572,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32383__auto___220928,new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null));
}}

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});
untangled.client.protocol_support.with_behavior = untangled.client.impl.protocol_support.with_behavior;

//# sourceMappingURL=protocol_support.js.map?rel=1483481838426