// Compiled by ClojureScript 1.9.456 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args48292 = [];
var len__11929__auto___48298 = arguments.length;
var i__11930__auto___48299 = (0);
while(true){
if((i__11930__auto___48299 < len__11929__auto___48298)){
args48292.push((arguments[i__11930__auto___48299]));

var G__48300 = (i__11930__auto___48299 + (1));
i__11930__auto___48299 = G__48300;
continue;
} else {
}
break;
}

var G__48294 = args48292.length;
switch (G__48294) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48292.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async48295 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48295 = (function (f,blockable,meta48296){
this.f = f;
this.blockable = blockable;
this.meta48296 = meta48296;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48297,meta48296__$1){
var self__ = this;
var _48297__$1 = this;
return (new cljs.core.async.t_cljs$core$async48295(self__.f,self__.blockable,meta48296__$1));
});


cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48297){
var self__ = this;
var _48297__$1 = this;
return self__.meta48296;
});


cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async48295.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async48295.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta48296","meta48296",1457494218,null)], null);
});

cljs.core.async.t_cljs$core$async48295.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48295.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48295";

cljs.core.async.t_cljs$core$async48295.cljs$lang$ctorPrWriter = (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async48295");
});

cljs.core.async.__GT_t_cljs$core$async48295 = (function cljs$core$async$__GT_t_cljs$core$async48295(f__$1,blockable__$1,meta48296){
return (new cljs.core.async.t_cljs$core$async48295(f__$1,blockable__$1,meta48296));
});

}

return (new cljs.core.async.t_cljs$core$async48295(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args48304 = [];
var len__11929__auto___48307 = arguments.length;
var i__11930__auto___48308 = (0);
while(true){
if((i__11930__auto___48308 < len__11929__auto___48307)){
args48304.push((arguments[i__11930__auto___48308]));

var G__48309 = (i__11930__auto___48308 + (1));
i__11930__auto___48308 = G__48309;
continue;
} else {
}
break;
}

var G__48306 = args48304.length;
switch (G__48306) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48304.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args48311 = [];
var len__11929__auto___48314 = arguments.length;
var i__11930__auto___48315 = (0);
while(true){
if((i__11930__auto___48315 < len__11929__auto___48314)){
args48311.push((arguments[i__11930__auto___48315]));

var G__48316 = (i__11930__auto___48315 + (1));
i__11930__auto___48315 = G__48316;
continue;
} else {
}
break;
}

var G__48313 = args48311.length;
switch (G__48313) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48311.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args48318 = [];
var len__11929__auto___48321 = arguments.length;
var i__11930__auto___48322 = (0);
while(true){
if((i__11930__auto___48322 < len__11929__auto___48321)){
args48318.push((arguments[i__11930__auto___48322]));

var G__48323 = (i__11930__auto___48322 + (1));
i__11930__auto___48322 = G__48323;
continue;
} else {
}
break;
}

var G__48320 = args48318.length;
switch (G__48320) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48318.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_48325 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_48325);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_48325,ret){
return (function (){
return fn1.call(null,val_48325);
});})(val_48325,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args48326 = [];
var len__11929__auto___48329 = arguments.length;
var i__11930__auto___48330 = (0);
while(true){
if((i__11930__auto___48330 < len__11929__auto___48329)){
args48326.push((arguments[i__11930__auto___48330]));

var G__48331 = (i__11930__auto___48330 + (1));
i__11930__auto___48330 = G__48331;
continue;
} else {
}
break;
}

var G__48328 = args48326.length;
switch (G__48328) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48326.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__11821__auto___48333 = n;
var x_48334 = (0);
while(true){
if((x_48334 < n__11821__auto___48333)){
(a[x_48334] = (0));

var G__48335 = (x_48334 + (1));
x_48334 = G__48335;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__48336 = (i + (1));
i = G__48336;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async48340 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48340 = (function (flag,meta48341){
this.flag = flag;
this.meta48341 = meta48341;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_48342,meta48341__$1){
var self__ = this;
var _48342__$1 = this;
return (new cljs.core.async.t_cljs$core$async48340(self__.flag,meta48341__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_48342){
var self__ = this;
var _48342__$1 = this;
return self__.meta48341;
});})(flag))
;


cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async48340.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async48340.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta48341","meta48341",-1355204909,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async48340.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48340.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48340";

cljs.core.async.t_cljs$core$async48340.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async48340");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async48340 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async48340(flag__$1,meta48341){
return (new cljs.core.async.t_cljs$core$async48340(flag__$1,meta48341));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async48340(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async48346 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48346 = (function (flag,cb,meta48347){
this.flag = flag;
this.cb = cb;
this.meta48347 = meta48347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48348,meta48347__$1){
var self__ = this;
var _48348__$1 = this;
return (new cljs.core.async.t_cljs$core$async48346(self__.flag,self__.cb,meta48347__$1));
});


cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48348){
var self__ = this;
var _48348__$1 = this;
return self__.meta48347;
});


cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async48346.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async48346.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta48347","meta48347",339544306,null)], null);
});

cljs.core.async.t_cljs$core$async48346.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48346.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48346";

cljs.core.async.t_cljs$core$async48346.cljs$lang$ctorPrWriter = (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async48346");
});

cljs.core.async.__GT_t_cljs$core$async48346 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async48346(flag__$1,cb__$1,meta48347){
return (new cljs.core.async.t_cljs$core$async48346(flag__$1,cb__$1,meta48347));
});

}

return (new cljs.core.async.t_cljs$core$async48346(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__48349_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__48349_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__48350_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__48350_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__11280__auto__ = wport;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48351 = (i + (1));
i = G__48351;
continue;
}
} else {
return null;
}
break;
}
})();
var or__11280__auto__ = ret;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__11272__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__11272__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__11272__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___48357 = arguments.length;
var i__11930__auto___48358 = (0);
while(true){
if((i__11930__auto___48358 < len__11929__auto___48357)){
args__11932__auto__.push((arguments[i__11930__auto___48358]));

var G__48359 = (i__11930__auto___48358 + (1));
i__11930__auto___48358 = G__48359;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__48354){
var map__48355 = p__48354;
var map__48355__$1 = ((((!((map__48355 == null)))?((((map__48355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48355.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48355):map__48355);
var opts = map__48355__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq48352){
var G__48353 = cljs.core.first.call(null,seq48352);
var seq48352__$1 = cljs.core.next.call(null,seq48352);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48353,seq48352__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args48360 = [];
var len__11929__auto___48410 = arguments.length;
var i__11930__auto___48411 = (0);
while(true){
if((i__11930__auto___48411 < len__11929__auto___48410)){
args48360.push((arguments[i__11930__auto___48411]));

var G__48412 = (i__11930__auto___48411 + (1));
i__11930__auto___48411 = G__48412;
continue;
} else {
}
break;
}

var G__48362 = args48360.length;
switch (G__48362) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48360.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__2597__auto___48414 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___48414){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___48414){
return (function (state_48386){
var state_val_48387 = (state_48386[(1)]);
if((state_val_48387 === (7))){
var inst_48382 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48388_48415 = state_48386__$1;
(statearr_48388_48415[(2)] = inst_48382);

(statearr_48388_48415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (1))){
var state_48386__$1 = state_48386;
var statearr_48389_48416 = state_48386__$1;
(statearr_48389_48416[(2)] = null);

(statearr_48389_48416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (4))){
var inst_48365 = (state_48386[(7)]);
var inst_48365__$1 = (state_48386[(2)]);
var inst_48366 = (inst_48365__$1 == null);
var state_48386__$1 = (function (){var statearr_48390 = state_48386;
(statearr_48390[(7)] = inst_48365__$1);

return statearr_48390;
})();
if(cljs.core.truth_(inst_48366)){
var statearr_48391_48417 = state_48386__$1;
(statearr_48391_48417[(1)] = (5));

} else {
var statearr_48392_48418 = state_48386__$1;
(statearr_48392_48418[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (13))){
var state_48386__$1 = state_48386;
var statearr_48393_48419 = state_48386__$1;
(statearr_48393_48419[(2)] = null);

(statearr_48393_48419[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (6))){
var inst_48365 = (state_48386[(7)]);
var state_48386__$1 = state_48386;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48386__$1,(11),to,inst_48365);
} else {
if((state_val_48387 === (3))){
var inst_48384 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48386__$1,inst_48384);
} else {
if((state_val_48387 === (12))){
var state_48386__$1 = state_48386;
var statearr_48394_48420 = state_48386__$1;
(statearr_48394_48420[(2)] = null);

(statearr_48394_48420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (2))){
var state_48386__$1 = state_48386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48386__$1,(4),from);
} else {
if((state_val_48387 === (11))){
var inst_48375 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
if(cljs.core.truth_(inst_48375)){
var statearr_48395_48421 = state_48386__$1;
(statearr_48395_48421[(1)] = (12));

} else {
var statearr_48396_48422 = state_48386__$1;
(statearr_48396_48422[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (9))){
var state_48386__$1 = state_48386;
var statearr_48397_48423 = state_48386__$1;
(statearr_48397_48423[(2)] = null);

(statearr_48397_48423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (5))){
var state_48386__$1 = state_48386;
if(cljs.core.truth_(close_QMARK_)){
var statearr_48398_48424 = state_48386__$1;
(statearr_48398_48424[(1)] = (8));

} else {
var statearr_48399_48425 = state_48386__$1;
(statearr_48399_48425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (14))){
var inst_48380 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48400_48426 = state_48386__$1;
(statearr_48400_48426[(2)] = inst_48380);

(statearr_48400_48426[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (10))){
var inst_48372 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48401_48427 = state_48386__$1;
(statearr_48401_48427[(2)] = inst_48372);

(statearr_48401_48427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (8))){
var inst_48369 = cljs.core.async.close_BANG_.call(null,to);
var state_48386__$1 = state_48386;
var statearr_48402_48428 = state_48386__$1;
(statearr_48402_48428[(2)] = inst_48369);

(statearr_48402_48428[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___48414))
;
return ((function (switch__2483__auto__,c__2597__auto___48414){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_48406 = [null,null,null,null,null,null,null,null];
(statearr_48406[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_48406[(1)] = (1));

return statearr_48406;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_48386){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48407){if((e48407 instanceof Object)){
var ex__2487__auto__ = e48407;
var statearr_48408_48429 = state_48386;
(statearr_48408_48429[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48430 = state_48386;
state_48386 = G__48430;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_48386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_48386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___48414))
})();
var state__2599__auto__ = (function (){var statearr_48409 = f__2598__auto__.call(null);
(statearr_48409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48414);

return statearr_48409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___48414))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__48618){
var vec__48619 = p__48618;
var v = cljs.core.nth.call(null,vec__48619,(0),null);
var p = cljs.core.nth.call(null,vec__48619,(1),null);
var job = vec__48619;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__2597__auto___48805 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results){
return (function (state_48626){
var state_val_48627 = (state_48626[(1)]);
if((state_val_48627 === (1))){
var state_48626__$1 = state_48626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48626__$1,(2),res,v);
} else {
if((state_val_48627 === (2))){
var inst_48623 = (state_48626[(2)]);
var inst_48624 = cljs.core.async.close_BANG_.call(null,res);
var state_48626__$1 = (function (){var statearr_48628 = state_48626;
(statearr_48628[(7)] = inst_48623);

return statearr_48628;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48626__$1,inst_48624);
} else {
return null;
}
}
});})(c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results))
;
return ((function (switch__2483__auto__,c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_48632 = [null,null,null,null,null,null,null,null];
(statearr_48632[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__);

(statearr_48632[(1)] = (1));

return statearr_48632;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1 = (function (state_48626){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48633){if((e48633 instanceof Object)){
var ex__2487__auto__ = e48633;
var statearr_48634_48806 = state_48626;
(statearr_48634_48806[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48633;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48807 = state_48626;
state_48626 = G__48807;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = function(state_48626){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1.call(this,state_48626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results))
})();
var state__2599__auto__ = (function (){var statearr_48635 = f__2598__auto__.call(null);
(statearr_48635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48805);

return statearr_48635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___48805,res,vec__48619,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__48636){
var vec__48637 = p__48636;
var v = cljs.core.nth.call(null,vec__48637,(0),null);
var p = cljs.core.nth.call(null,vec__48637,(1),null);
var job = vec__48637;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__11821__auto___48808 = n;
var __48809 = (0);
while(true){
if((__48809 < n__11821__auto___48808)){
var G__48640_48810 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__48640_48810) {
case "compute":
var c__2597__auto___48812 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__48809,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (__48809,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function (state_48653){
var state_val_48654 = (state_48653[(1)]);
if((state_val_48654 === (1))){
var state_48653__$1 = state_48653;
var statearr_48655_48813 = state_48653__$1;
(statearr_48655_48813[(2)] = null);

(statearr_48655_48813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48654 === (2))){
var state_48653__$1 = state_48653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48653__$1,(4),jobs);
} else {
if((state_val_48654 === (3))){
var inst_48651 = (state_48653[(2)]);
var state_48653__$1 = state_48653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48653__$1,inst_48651);
} else {
if((state_val_48654 === (4))){
var inst_48643 = (state_48653[(2)]);
var inst_48644 = process.call(null,inst_48643);
var state_48653__$1 = state_48653;
if(cljs.core.truth_(inst_48644)){
var statearr_48656_48814 = state_48653__$1;
(statearr_48656_48814[(1)] = (5));

} else {
var statearr_48657_48815 = state_48653__$1;
(statearr_48657_48815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48654 === (5))){
var state_48653__$1 = state_48653;
var statearr_48658_48816 = state_48653__$1;
(statearr_48658_48816[(2)] = null);

(statearr_48658_48816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48654 === (6))){
var state_48653__$1 = state_48653;
var statearr_48659_48817 = state_48653__$1;
(statearr_48659_48817[(2)] = null);

(statearr_48659_48817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48654 === (7))){
var inst_48649 = (state_48653[(2)]);
var state_48653__$1 = state_48653;
var statearr_48660_48818 = state_48653__$1;
(statearr_48660_48818[(2)] = inst_48649);

(statearr_48660_48818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48809,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
;
return ((function (__48809,switch__2483__auto__,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_48664 = [null,null,null,null,null,null,null];
(statearr_48664[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__);

(statearr_48664[(1)] = (1));

return statearr_48664;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1 = (function (state_48653){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48665){if((e48665 instanceof Object)){
var ex__2487__auto__ = e48665;
var statearr_48666_48819 = state_48653;
(statearr_48666_48819[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48820 = state_48653;
state_48653 = G__48820;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = function(state_48653){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1.call(this,state_48653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__;
})()
;})(__48809,switch__2483__auto__,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
})();
var state__2599__auto__ = (function (){var statearr_48667 = f__2598__auto__.call(null);
(statearr_48667[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48812);

return statearr_48667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(__48809,c__2597__auto___48812,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
);


break;
case "async":
var c__2597__auto___48821 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__48809,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (__48809,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function (state_48680){
var state_val_48681 = (state_48680[(1)]);
if((state_val_48681 === (1))){
var state_48680__$1 = state_48680;
var statearr_48682_48822 = state_48680__$1;
(statearr_48682_48822[(2)] = null);

(statearr_48682_48822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48681 === (2))){
var state_48680__$1 = state_48680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48680__$1,(4),jobs);
} else {
if((state_val_48681 === (3))){
var inst_48678 = (state_48680[(2)]);
var state_48680__$1 = state_48680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48680__$1,inst_48678);
} else {
if((state_val_48681 === (4))){
var inst_48670 = (state_48680[(2)]);
var inst_48671 = async.call(null,inst_48670);
var state_48680__$1 = state_48680;
if(cljs.core.truth_(inst_48671)){
var statearr_48683_48823 = state_48680__$1;
(statearr_48683_48823[(1)] = (5));

} else {
var statearr_48684_48824 = state_48680__$1;
(statearr_48684_48824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48681 === (5))){
var state_48680__$1 = state_48680;
var statearr_48685_48825 = state_48680__$1;
(statearr_48685_48825[(2)] = null);

(statearr_48685_48825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48681 === (6))){
var state_48680__$1 = state_48680;
var statearr_48686_48826 = state_48680__$1;
(statearr_48686_48826[(2)] = null);

(statearr_48686_48826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48681 === (7))){
var inst_48676 = (state_48680[(2)]);
var state_48680__$1 = state_48680;
var statearr_48687_48827 = state_48680__$1;
(statearr_48687_48827[(2)] = inst_48676);

(statearr_48687_48827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48809,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
;
return ((function (__48809,switch__2483__auto__,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_48691 = [null,null,null,null,null,null,null];
(statearr_48691[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__);

(statearr_48691[(1)] = (1));

return statearr_48691;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1 = (function (state_48680){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48692){if((e48692 instanceof Object)){
var ex__2487__auto__ = e48692;
var statearr_48693_48828 = state_48680;
(statearr_48693_48828[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48692;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48829 = state_48680;
state_48680 = G__48829;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = function(state_48680){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1.call(this,state_48680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__;
})()
;})(__48809,switch__2483__auto__,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
})();
var state__2599__auto__ = (function (){var statearr_48694 = f__2598__auto__.call(null);
(statearr_48694[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48821);

return statearr_48694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(__48809,c__2597__auto___48821,G__48640_48810,n__11821__auto___48808,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__48830 = (__48809 + (1));
__48809 = G__48830;
continue;
} else {
}
break;
}

var c__2597__auto___48831 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___48831,jobs,results,process,async){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___48831,jobs,results,process,async){
return (function (state_48716){
var state_val_48717 = (state_48716[(1)]);
if((state_val_48717 === (1))){
var state_48716__$1 = state_48716;
var statearr_48718_48832 = state_48716__$1;
(statearr_48718_48832[(2)] = null);

(statearr_48718_48832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48717 === (2))){
var state_48716__$1 = state_48716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48716__$1,(4),from);
} else {
if((state_val_48717 === (3))){
var inst_48714 = (state_48716[(2)]);
var state_48716__$1 = state_48716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48716__$1,inst_48714);
} else {
if((state_val_48717 === (4))){
var inst_48697 = (state_48716[(7)]);
var inst_48697__$1 = (state_48716[(2)]);
var inst_48698 = (inst_48697__$1 == null);
var state_48716__$1 = (function (){var statearr_48719 = state_48716;
(statearr_48719[(7)] = inst_48697__$1);

return statearr_48719;
})();
if(cljs.core.truth_(inst_48698)){
var statearr_48720_48833 = state_48716__$1;
(statearr_48720_48833[(1)] = (5));

} else {
var statearr_48721_48834 = state_48716__$1;
(statearr_48721_48834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48717 === (5))){
var inst_48700 = cljs.core.async.close_BANG_.call(null,jobs);
var state_48716__$1 = state_48716;
var statearr_48722_48835 = state_48716__$1;
(statearr_48722_48835[(2)] = inst_48700);

(statearr_48722_48835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48717 === (6))){
var inst_48697 = (state_48716[(7)]);
var inst_48702 = (state_48716[(8)]);
var inst_48702__$1 = cljs.core.async.chan.call(null,(1));
var inst_48703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48704 = [inst_48697,inst_48702__$1];
var inst_48705 = (new cljs.core.PersistentVector(null,2,(5),inst_48703,inst_48704,null));
var state_48716__$1 = (function (){var statearr_48723 = state_48716;
(statearr_48723[(8)] = inst_48702__$1);

return statearr_48723;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48716__$1,(8),jobs,inst_48705);
} else {
if((state_val_48717 === (7))){
var inst_48712 = (state_48716[(2)]);
var state_48716__$1 = state_48716;
var statearr_48724_48836 = state_48716__$1;
(statearr_48724_48836[(2)] = inst_48712);

(statearr_48724_48836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48717 === (8))){
var inst_48702 = (state_48716[(8)]);
var inst_48707 = (state_48716[(2)]);
var state_48716__$1 = (function (){var statearr_48725 = state_48716;
(statearr_48725[(9)] = inst_48707);

return statearr_48725;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48716__$1,(9),results,inst_48702);
} else {
if((state_val_48717 === (9))){
var inst_48709 = (state_48716[(2)]);
var state_48716__$1 = (function (){var statearr_48726 = state_48716;
(statearr_48726[(10)] = inst_48709);

return statearr_48726;
})();
var statearr_48727_48837 = state_48716__$1;
(statearr_48727_48837[(2)] = null);

(statearr_48727_48837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___48831,jobs,results,process,async))
;
return ((function (switch__2483__auto__,c__2597__auto___48831,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_48731 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48731[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__);

(statearr_48731[(1)] = (1));

return statearr_48731;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1 = (function (state_48716){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48732){if((e48732 instanceof Object)){
var ex__2487__auto__ = e48732;
var statearr_48733_48838 = state_48716;
(statearr_48733_48838[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48716);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48732;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48839 = state_48716;
state_48716 = G__48839;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = function(state_48716){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1.call(this,state_48716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___48831,jobs,results,process,async))
})();
var state__2599__auto__ = (function (){var statearr_48734 = f__2598__auto__.call(null);
(statearr_48734[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48831);

return statearr_48734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___48831,jobs,results,process,async))
);


var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__,jobs,results,process,async){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__,jobs,results,process,async){
return (function (state_48772){
var state_val_48773 = (state_48772[(1)]);
if((state_val_48773 === (7))){
var inst_48768 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48774_48840 = state_48772__$1;
(statearr_48774_48840[(2)] = inst_48768);

(statearr_48774_48840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (20))){
var state_48772__$1 = state_48772;
var statearr_48775_48841 = state_48772__$1;
(statearr_48775_48841[(2)] = null);

(statearr_48775_48841[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (1))){
var state_48772__$1 = state_48772;
var statearr_48776_48842 = state_48772__$1;
(statearr_48776_48842[(2)] = null);

(statearr_48776_48842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (4))){
var inst_48737 = (state_48772[(7)]);
var inst_48737__$1 = (state_48772[(2)]);
var inst_48738 = (inst_48737__$1 == null);
var state_48772__$1 = (function (){var statearr_48777 = state_48772;
(statearr_48777[(7)] = inst_48737__$1);

return statearr_48777;
})();
if(cljs.core.truth_(inst_48738)){
var statearr_48778_48843 = state_48772__$1;
(statearr_48778_48843[(1)] = (5));

} else {
var statearr_48779_48844 = state_48772__$1;
(statearr_48779_48844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (15))){
var inst_48750 = (state_48772[(8)]);
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48772__$1,(18),to,inst_48750);
} else {
if((state_val_48773 === (21))){
var inst_48763 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48780_48845 = state_48772__$1;
(statearr_48780_48845[(2)] = inst_48763);

(statearr_48780_48845[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (13))){
var inst_48765 = (state_48772[(2)]);
var state_48772__$1 = (function (){var statearr_48781 = state_48772;
(statearr_48781[(9)] = inst_48765);

return statearr_48781;
})();
var statearr_48782_48846 = state_48772__$1;
(statearr_48782_48846[(2)] = null);

(statearr_48782_48846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (6))){
var inst_48737 = (state_48772[(7)]);
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48772__$1,(11),inst_48737);
} else {
if((state_val_48773 === (17))){
var inst_48758 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
if(cljs.core.truth_(inst_48758)){
var statearr_48783_48847 = state_48772__$1;
(statearr_48783_48847[(1)] = (19));

} else {
var statearr_48784_48848 = state_48772__$1;
(statearr_48784_48848[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (3))){
var inst_48770 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48772__$1,inst_48770);
} else {
if((state_val_48773 === (12))){
var inst_48747 = (state_48772[(10)]);
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48772__$1,(14),inst_48747);
} else {
if((state_val_48773 === (2))){
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48772__$1,(4),results);
} else {
if((state_val_48773 === (19))){
var state_48772__$1 = state_48772;
var statearr_48785_48849 = state_48772__$1;
(statearr_48785_48849[(2)] = null);

(statearr_48785_48849[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (11))){
var inst_48747 = (state_48772[(2)]);
var state_48772__$1 = (function (){var statearr_48786 = state_48772;
(statearr_48786[(10)] = inst_48747);

return statearr_48786;
})();
var statearr_48787_48850 = state_48772__$1;
(statearr_48787_48850[(2)] = null);

(statearr_48787_48850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (9))){
var state_48772__$1 = state_48772;
var statearr_48788_48851 = state_48772__$1;
(statearr_48788_48851[(2)] = null);

(statearr_48788_48851[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (5))){
var state_48772__$1 = state_48772;
if(cljs.core.truth_(close_QMARK_)){
var statearr_48789_48852 = state_48772__$1;
(statearr_48789_48852[(1)] = (8));

} else {
var statearr_48790_48853 = state_48772__$1;
(statearr_48790_48853[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (14))){
var inst_48752 = (state_48772[(11)]);
var inst_48750 = (state_48772[(8)]);
var inst_48750__$1 = (state_48772[(2)]);
var inst_48751 = (inst_48750__$1 == null);
var inst_48752__$1 = cljs.core.not.call(null,inst_48751);
var state_48772__$1 = (function (){var statearr_48791 = state_48772;
(statearr_48791[(11)] = inst_48752__$1);

(statearr_48791[(8)] = inst_48750__$1);

return statearr_48791;
})();
if(inst_48752__$1){
var statearr_48792_48854 = state_48772__$1;
(statearr_48792_48854[(1)] = (15));

} else {
var statearr_48793_48855 = state_48772__$1;
(statearr_48793_48855[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (16))){
var inst_48752 = (state_48772[(11)]);
var state_48772__$1 = state_48772;
var statearr_48794_48856 = state_48772__$1;
(statearr_48794_48856[(2)] = inst_48752);

(statearr_48794_48856[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (10))){
var inst_48744 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48795_48857 = state_48772__$1;
(statearr_48795_48857[(2)] = inst_48744);

(statearr_48795_48857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (18))){
var inst_48755 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48796_48858 = state_48772__$1;
(statearr_48796_48858[(2)] = inst_48755);

(statearr_48796_48858[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (8))){
var inst_48741 = cljs.core.async.close_BANG_.call(null,to);
var state_48772__$1 = state_48772;
var statearr_48797_48859 = state_48772__$1;
(statearr_48797_48859[(2)] = inst_48741);

(statearr_48797_48859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__,jobs,results,process,async))
;
return ((function (switch__2483__auto__,c__2597__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_48801 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48801[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__);

(statearr_48801[(1)] = (1));

return statearr_48801;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1 = (function (state_48772){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48802){if((e48802 instanceof Object)){
var ex__2487__auto__ = e48802;
var statearr_48803_48860 = state_48772;
(statearr_48803_48860[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48802;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48861 = state_48772;
state_48772 = G__48861;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__ = function(state_48772){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1.call(this,state_48772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__,jobs,results,process,async))
})();
var state__2599__auto__ = (function (){var statearr_48804 = f__2598__auto__.call(null);
(statearr_48804[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_48804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__,jobs,results,process,async))
);

return c__2597__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args48862 = [];
var len__11929__auto___48865 = arguments.length;
var i__11930__auto___48866 = (0);
while(true){
if((i__11930__auto___48866 < len__11929__auto___48865)){
args48862.push((arguments[i__11930__auto___48866]));

var G__48867 = (i__11930__auto___48866 + (1));
i__11930__auto___48866 = G__48867;
continue;
} else {
}
break;
}

var G__48864 = args48862.length;
switch (G__48864) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48862.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args48869 = [];
var len__11929__auto___48872 = arguments.length;
var i__11930__auto___48873 = (0);
while(true){
if((i__11930__auto___48873 < len__11929__auto___48872)){
args48869.push((arguments[i__11930__auto___48873]));

var G__48874 = (i__11930__auto___48873 + (1));
i__11930__auto___48873 = G__48874;
continue;
} else {
}
break;
}

var G__48871 = args48869.length;
switch (G__48871) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48869.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args48876 = [];
var len__11929__auto___48929 = arguments.length;
var i__11930__auto___48930 = (0);
while(true){
if((i__11930__auto___48930 < len__11929__auto___48929)){
args48876.push((arguments[i__11930__auto___48930]));

var G__48931 = (i__11930__auto___48930 + (1));
i__11930__auto___48930 = G__48931;
continue;
} else {
}
break;
}

var G__48878 = args48876.length;
switch (G__48878) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48876.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__2597__auto___48933 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___48933,tc,fc){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___48933,tc,fc){
return (function (state_48904){
var state_val_48905 = (state_48904[(1)]);
if((state_val_48905 === (7))){
var inst_48900 = (state_48904[(2)]);
var state_48904__$1 = state_48904;
var statearr_48906_48934 = state_48904__$1;
(statearr_48906_48934[(2)] = inst_48900);

(statearr_48906_48934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (1))){
var state_48904__$1 = state_48904;
var statearr_48907_48935 = state_48904__$1;
(statearr_48907_48935[(2)] = null);

(statearr_48907_48935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (4))){
var inst_48881 = (state_48904[(7)]);
var inst_48881__$1 = (state_48904[(2)]);
var inst_48882 = (inst_48881__$1 == null);
var state_48904__$1 = (function (){var statearr_48908 = state_48904;
(statearr_48908[(7)] = inst_48881__$1);

return statearr_48908;
})();
if(cljs.core.truth_(inst_48882)){
var statearr_48909_48936 = state_48904__$1;
(statearr_48909_48936[(1)] = (5));

} else {
var statearr_48910_48937 = state_48904__$1;
(statearr_48910_48937[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (13))){
var state_48904__$1 = state_48904;
var statearr_48911_48938 = state_48904__$1;
(statearr_48911_48938[(2)] = null);

(statearr_48911_48938[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (6))){
var inst_48881 = (state_48904[(7)]);
var inst_48887 = p.call(null,inst_48881);
var state_48904__$1 = state_48904;
if(cljs.core.truth_(inst_48887)){
var statearr_48912_48939 = state_48904__$1;
(statearr_48912_48939[(1)] = (9));

} else {
var statearr_48913_48940 = state_48904__$1;
(statearr_48913_48940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (3))){
var inst_48902 = (state_48904[(2)]);
var state_48904__$1 = state_48904;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48904__$1,inst_48902);
} else {
if((state_val_48905 === (12))){
var state_48904__$1 = state_48904;
var statearr_48914_48941 = state_48904__$1;
(statearr_48914_48941[(2)] = null);

(statearr_48914_48941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (2))){
var state_48904__$1 = state_48904;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48904__$1,(4),ch);
} else {
if((state_val_48905 === (11))){
var inst_48881 = (state_48904[(7)]);
var inst_48891 = (state_48904[(2)]);
var state_48904__$1 = state_48904;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48904__$1,(8),inst_48891,inst_48881);
} else {
if((state_val_48905 === (9))){
var state_48904__$1 = state_48904;
var statearr_48915_48942 = state_48904__$1;
(statearr_48915_48942[(2)] = tc);

(statearr_48915_48942[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (5))){
var inst_48884 = cljs.core.async.close_BANG_.call(null,tc);
var inst_48885 = cljs.core.async.close_BANG_.call(null,fc);
var state_48904__$1 = (function (){var statearr_48916 = state_48904;
(statearr_48916[(8)] = inst_48884);

return statearr_48916;
})();
var statearr_48917_48943 = state_48904__$1;
(statearr_48917_48943[(2)] = inst_48885);

(statearr_48917_48943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (14))){
var inst_48898 = (state_48904[(2)]);
var state_48904__$1 = state_48904;
var statearr_48918_48944 = state_48904__$1;
(statearr_48918_48944[(2)] = inst_48898);

(statearr_48918_48944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (10))){
var state_48904__$1 = state_48904;
var statearr_48919_48945 = state_48904__$1;
(statearr_48919_48945[(2)] = fc);

(statearr_48919_48945[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48905 === (8))){
var inst_48893 = (state_48904[(2)]);
var state_48904__$1 = state_48904;
if(cljs.core.truth_(inst_48893)){
var statearr_48920_48946 = state_48904__$1;
(statearr_48920_48946[(1)] = (12));

} else {
var statearr_48921_48947 = state_48904__$1;
(statearr_48921_48947[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___48933,tc,fc))
;
return ((function (switch__2483__auto__,c__2597__auto___48933,tc,fc){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_48925 = [null,null,null,null,null,null,null,null,null];
(statearr_48925[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_48925[(1)] = (1));

return statearr_48925;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_48904){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_48904);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e48926){if((e48926 instanceof Object)){
var ex__2487__auto__ = e48926;
var statearr_48927_48948 = state_48904;
(statearr_48927_48948[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48949 = state_48904;
state_48904 = G__48949;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_48904){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_48904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___48933,tc,fc))
})();
var state__2599__auto__ = (function (){var statearr_48928 = f__2598__auto__.call(null);
(statearr_48928[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___48933);

return statearr_48928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___48933,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_49013){
var state_val_49014 = (state_49013[(1)]);
if((state_val_49014 === (7))){
var inst_49009 = (state_49013[(2)]);
var state_49013__$1 = state_49013;
var statearr_49015_49036 = state_49013__$1;
(statearr_49015_49036[(2)] = inst_49009);

(statearr_49015_49036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (1))){
var inst_48993 = init;
var state_49013__$1 = (function (){var statearr_49016 = state_49013;
(statearr_49016[(7)] = inst_48993);

return statearr_49016;
})();
var statearr_49017_49037 = state_49013__$1;
(statearr_49017_49037[(2)] = null);

(statearr_49017_49037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (4))){
var inst_48996 = (state_49013[(8)]);
var inst_48996__$1 = (state_49013[(2)]);
var inst_48997 = (inst_48996__$1 == null);
var state_49013__$1 = (function (){var statearr_49018 = state_49013;
(statearr_49018[(8)] = inst_48996__$1);

return statearr_49018;
})();
if(cljs.core.truth_(inst_48997)){
var statearr_49019_49038 = state_49013__$1;
(statearr_49019_49038[(1)] = (5));

} else {
var statearr_49020_49039 = state_49013__$1;
(statearr_49020_49039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (6))){
var inst_48993 = (state_49013[(7)]);
var inst_49000 = (state_49013[(9)]);
var inst_48996 = (state_49013[(8)]);
var inst_49000__$1 = f.call(null,inst_48993,inst_48996);
var inst_49001 = cljs.core.reduced_QMARK_.call(null,inst_49000__$1);
var state_49013__$1 = (function (){var statearr_49021 = state_49013;
(statearr_49021[(9)] = inst_49000__$1);

return statearr_49021;
})();
if(inst_49001){
var statearr_49022_49040 = state_49013__$1;
(statearr_49022_49040[(1)] = (8));

} else {
var statearr_49023_49041 = state_49013__$1;
(statearr_49023_49041[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (3))){
var inst_49011 = (state_49013[(2)]);
var state_49013__$1 = state_49013;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49013__$1,inst_49011);
} else {
if((state_val_49014 === (2))){
var state_49013__$1 = state_49013;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49013__$1,(4),ch);
} else {
if((state_val_49014 === (9))){
var inst_49000 = (state_49013[(9)]);
var inst_48993 = inst_49000;
var state_49013__$1 = (function (){var statearr_49024 = state_49013;
(statearr_49024[(7)] = inst_48993);

return statearr_49024;
})();
var statearr_49025_49042 = state_49013__$1;
(statearr_49025_49042[(2)] = null);

(statearr_49025_49042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (5))){
var inst_48993 = (state_49013[(7)]);
var state_49013__$1 = state_49013;
var statearr_49026_49043 = state_49013__$1;
(statearr_49026_49043[(2)] = inst_48993);

(statearr_49026_49043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (10))){
var inst_49007 = (state_49013[(2)]);
var state_49013__$1 = state_49013;
var statearr_49027_49044 = state_49013__$1;
(statearr_49027_49044[(2)] = inst_49007);

(statearr_49027_49044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49014 === (8))){
var inst_49000 = (state_49013[(9)]);
var inst_49003 = cljs.core.deref.call(null,inst_49000);
var state_49013__$1 = state_49013;
var statearr_49028_49045 = state_49013__$1;
(statearr_49028_49045[(2)] = inst_49003);

(statearr_49028_49045[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__2484__auto__ = null;
var cljs$core$async$reduce_$_state_machine__2484__auto____0 = (function (){
var statearr_49032 = [null,null,null,null,null,null,null,null,null,null];
(statearr_49032[(0)] = cljs$core$async$reduce_$_state_machine__2484__auto__);

(statearr_49032[(1)] = (1));

return statearr_49032;
});
var cljs$core$async$reduce_$_state_machine__2484__auto____1 = (function (state_49013){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_49013);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e49033){if((e49033 instanceof Object)){
var ex__2487__auto__ = e49033;
var statearr_49034_49046 = state_49013;
(statearr_49034_49046[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49047 = state_49013;
state_49013 = G__49047;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__2484__auto__ = function(state_49013){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__2484__auto____1.call(this,state_49013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__2484__auto____0;
cljs$core$async$reduce_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__2484__auto____1;
return cljs$core$async$reduce_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_49035 = f__2598__auto__.call(null);
(statearr_49035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_49035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args49048 = [];
var len__11929__auto___49100 = arguments.length;
var i__11930__auto___49101 = (0);
while(true){
if((i__11930__auto___49101 < len__11929__auto___49100)){
args49048.push((arguments[i__11930__auto___49101]));

var G__49102 = (i__11930__auto___49101 + (1));
i__11930__auto___49101 = G__49102;
continue;
} else {
}
break;
}

var G__49050 = args49048.length;
switch (G__49050) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49048.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_49075){
var state_val_49076 = (state_49075[(1)]);
if((state_val_49076 === (7))){
var inst_49057 = (state_49075[(2)]);
var state_49075__$1 = state_49075;
var statearr_49077_49104 = state_49075__$1;
(statearr_49077_49104[(2)] = inst_49057);

(statearr_49077_49104[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (1))){
var inst_49051 = cljs.core.seq.call(null,coll);
var inst_49052 = inst_49051;
var state_49075__$1 = (function (){var statearr_49078 = state_49075;
(statearr_49078[(7)] = inst_49052);

return statearr_49078;
})();
var statearr_49079_49105 = state_49075__$1;
(statearr_49079_49105[(2)] = null);

(statearr_49079_49105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (4))){
var inst_49052 = (state_49075[(7)]);
var inst_49055 = cljs.core.first.call(null,inst_49052);
var state_49075__$1 = state_49075;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49075__$1,(7),ch,inst_49055);
} else {
if((state_val_49076 === (13))){
var inst_49069 = (state_49075[(2)]);
var state_49075__$1 = state_49075;
var statearr_49080_49106 = state_49075__$1;
(statearr_49080_49106[(2)] = inst_49069);

(statearr_49080_49106[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (6))){
var inst_49060 = (state_49075[(2)]);
var state_49075__$1 = state_49075;
if(cljs.core.truth_(inst_49060)){
var statearr_49081_49107 = state_49075__$1;
(statearr_49081_49107[(1)] = (8));

} else {
var statearr_49082_49108 = state_49075__$1;
(statearr_49082_49108[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (3))){
var inst_49073 = (state_49075[(2)]);
var state_49075__$1 = state_49075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49075__$1,inst_49073);
} else {
if((state_val_49076 === (12))){
var state_49075__$1 = state_49075;
var statearr_49083_49109 = state_49075__$1;
(statearr_49083_49109[(2)] = null);

(statearr_49083_49109[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (2))){
var inst_49052 = (state_49075[(7)]);
var state_49075__$1 = state_49075;
if(cljs.core.truth_(inst_49052)){
var statearr_49084_49110 = state_49075__$1;
(statearr_49084_49110[(1)] = (4));

} else {
var statearr_49085_49111 = state_49075__$1;
(statearr_49085_49111[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (11))){
var inst_49066 = cljs.core.async.close_BANG_.call(null,ch);
var state_49075__$1 = state_49075;
var statearr_49086_49112 = state_49075__$1;
(statearr_49086_49112[(2)] = inst_49066);

(statearr_49086_49112[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (9))){
var state_49075__$1 = state_49075;
if(cljs.core.truth_(close_QMARK_)){
var statearr_49087_49113 = state_49075__$1;
(statearr_49087_49113[(1)] = (11));

} else {
var statearr_49088_49114 = state_49075__$1;
(statearr_49088_49114[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (5))){
var inst_49052 = (state_49075[(7)]);
var state_49075__$1 = state_49075;
var statearr_49089_49115 = state_49075__$1;
(statearr_49089_49115[(2)] = inst_49052);

(statearr_49089_49115[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (10))){
var inst_49071 = (state_49075[(2)]);
var state_49075__$1 = state_49075;
var statearr_49090_49116 = state_49075__$1;
(statearr_49090_49116[(2)] = inst_49071);

(statearr_49090_49116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49076 === (8))){
var inst_49052 = (state_49075[(7)]);
var inst_49062 = cljs.core.next.call(null,inst_49052);
var inst_49052__$1 = inst_49062;
var state_49075__$1 = (function (){var statearr_49091 = state_49075;
(statearr_49091[(7)] = inst_49052__$1);

return statearr_49091;
})();
var statearr_49092_49117 = state_49075__$1;
(statearr_49092_49117[(2)] = null);

(statearr_49092_49117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_49096 = [null,null,null,null,null,null,null,null];
(statearr_49096[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_49096[(1)] = (1));

return statearr_49096;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_49075){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_49075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e49097){if((e49097 instanceof Object)){
var ex__2487__auto__ = e49097;
var statearr_49098_49118 = state_49075;
(statearr_49098_49118[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49119 = state_49075;
state_49075 = G__49119;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_49075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_49075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_49099 = f__2598__auto__.call(null);
(statearr_49099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_49099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__11610__auto__ = (((_ == null))?null:_);
var m__11611__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,_);
} else {
var m__11611__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__11611__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,ch);
} else {
var m__11611__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m);
} else {
var m__11611__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async49345 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49345 = (function (ch,cs,meta49346){
this.ch = ch;
this.cs = cs;
this.meta49346 = meta49346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_49347,meta49346__$1){
var self__ = this;
var _49347__$1 = this;
return (new cljs.core.async.t_cljs$core$async49345(self__.ch,self__.cs,meta49346__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_49347){
var self__ = this;
var _49347__$1 = this;
return self__.meta49346;
});})(cs))
;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async49345.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async49345.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta49346","meta49346",1693509457,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async49345.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async49345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49345";

cljs.core.async.t_cljs$core$async49345.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async49345");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async49345 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async49345(ch__$1,cs__$1,meta49346){
return (new cljs.core.async.t_cljs$core$async49345(ch__$1,cs__$1,meta49346));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async49345(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__2597__auto___49570 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___49570,cs,m,dchan,dctr,done){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___49570,cs,m,dchan,dctr,done){
return (function (state_49482){
var state_val_49483 = (state_49482[(1)]);
if((state_val_49483 === (7))){
var inst_49478 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49484_49571 = state_49482__$1;
(statearr_49484_49571[(2)] = inst_49478);

(statearr_49484_49571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (20))){
var inst_49381 = (state_49482[(7)]);
var inst_49393 = cljs.core.first.call(null,inst_49381);
var inst_49394 = cljs.core.nth.call(null,inst_49393,(0),null);
var inst_49395 = cljs.core.nth.call(null,inst_49393,(1),null);
var state_49482__$1 = (function (){var statearr_49485 = state_49482;
(statearr_49485[(8)] = inst_49394);

return statearr_49485;
})();
if(cljs.core.truth_(inst_49395)){
var statearr_49486_49572 = state_49482__$1;
(statearr_49486_49572[(1)] = (22));

} else {
var statearr_49487_49573 = state_49482__$1;
(statearr_49487_49573[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (27))){
var inst_49350 = (state_49482[(9)]);
var inst_49425 = (state_49482[(10)]);
var inst_49430 = (state_49482[(11)]);
var inst_49423 = (state_49482[(12)]);
var inst_49430__$1 = cljs.core._nth.call(null,inst_49423,inst_49425);
var inst_49431 = cljs.core.async.put_BANG_.call(null,inst_49430__$1,inst_49350,done);
var state_49482__$1 = (function (){var statearr_49488 = state_49482;
(statearr_49488[(11)] = inst_49430__$1);

return statearr_49488;
})();
if(cljs.core.truth_(inst_49431)){
var statearr_49489_49574 = state_49482__$1;
(statearr_49489_49574[(1)] = (30));

} else {
var statearr_49490_49575 = state_49482__$1;
(statearr_49490_49575[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (1))){
var state_49482__$1 = state_49482;
var statearr_49491_49576 = state_49482__$1;
(statearr_49491_49576[(2)] = null);

(statearr_49491_49576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (24))){
var inst_49381 = (state_49482[(7)]);
var inst_49400 = (state_49482[(2)]);
var inst_49401 = cljs.core.next.call(null,inst_49381);
var inst_49359 = inst_49401;
var inst_49360 = null;
var inst_49361 = (0);
var inst_49362 = (0);
var state_49482__$1 = (function (){var statearr_49492 = state_49482;
(statearr_49492[(13)] = inst_49361);

(statearr_49492[(14)] = inst_49362);

(statearr_49492[(15)] = inst_49360);

(statearr_49492[(16)] = inst_49359);

(statearr_49492[(17)] = inst_49400);

return statearr_49492;
})();
var statearr_49493_49577 = state_49482__$1;
(statearr_49493_49577[(2)] = null);

(statearr_49493_49577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (39))){
var state_49482__$1 = state_49482;
var statearr_49497_49578 = state_49482__$1;
(statearr_49497_49578[(2)] = null);

(statearr_49497_49578[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (4))){
var inst_49350 = (state_49482[(9)]);
var inst_49350__$1 = (state_49482[(2)]);
var inst_49351 = (inst_49350__$1 == null);
var state_49482__$1 = (function (){var statearr_49498 = state_49482;
(statearr_49498[(9)] = inst_49350__$1);

return statearr_49498;
})();
if(cljs.core.truth_(inst_49351)){
var statearr_49499_49579 = state_49482__$1;
(statearr_49499_49579[(1)] = (5));

} else {
var statearr_49500_49580 = state_49482__$1;
(statearr_49500_49580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (15))){
var inst_49361 = (state_49482[(13)]);
var inst_49362 = (state_49482[(14)]);
var inst_49360 = (state_49482[(15)]);
var inst_49359 = (state_49482[(16)]);
var inst_49377 = (state_49482[(2)]);
var inst_49378 = (inst_49362 + (1));
var tmp49494 = inst_49361;
var tmp49495 = inst_49360;
var tmp49496 = inst_49359;
var inst_49359__$1 = tmp49496;
var inst_49360__$1 = tmp49495;
var inst_49361__$1 = tmp49494;
var inst_49362__$1 = inst_49378;
var state_49482__$1 = (function (){var statearr_49501 = state_49482;
(statearr_49501[(13)] = inst_49361__$1);

(statearr_49501[(14)] = inst_49362__$1);

(statearr_49501[(15)] = inst_49360__$1);

(statearr_49501[(18)] = inst_49377);

(statearr_49501[(16)] = inst_49359__$1);

return statearr_49501;
})();
var statearr_49502_49581 = state_49482__$1;
(statearr_49502_49581[(2)] = null);

(statearr_49502_49581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (21))){
var inst_49404 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49506_49582 = state_49482__$1;
(statearr_49506_49582[(2)] = inst_49404);

(statearr_49506_49582[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (31))){
var inst_49430 = (state_49482[(11)]);
var inst_49434 = done.call(null,null);
var inst_49435 = cljs.core.async.untap_STAR_.call(null,m,inst_49430);
var state_49482__$1 = (function (){var statearr_49507 = state_49482;
(statearr_49507[(19)] = inst_49434);

return statearr_49507;
})();
var statearr_49508_49583 = state_49482__$1;
(statearr_49508_49583[(2)] = inst_49435);

(statearr_49508_49583[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (32))){
var inst_49424 = (state_49482[(20)]);
var inst_49425 = (state_49482[(10)]);
var inst_49422 = (state_49482[(21)]);
var inst_49423 = (state_49482[(12)]);
var inst_49437 = (state_49482[(2)]);
var inst_49438 = (inst_49425 + (1));
var tmp49503 = inst_49424;
var tmp49504 = inst_49422;
var tmp49505 = inst_49423;
var inst_49422__$1 = tmp49504;
var inst_49423__$1 = tmp49505;
var inst_49424__$1 = tmp49503;
var inst_49425__$1 = inst_49438;
var state_49482__$1 = (function (){var statearr_49509 = state_49482;
(statearr_49509[(20)] = inst_49424__$1);

(statearr_49509[(10)] = inst_49425__$1);

(statearr_49509[(22)] = inst_49437);

(statearr_49509[(21)] = inst_49422__$1);

(statearr_49509[(12)] = inst_49423__$1);

return statearr_49509;
})();
var statearr_49510_49584 = state_49482__$1;
(statearr_49510_49584[(2)] = null);

(statearr_49510_49584[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (40))){
var inst_49450 = (state_49482[(23)]);
var inst_49454 = done.call(null,null);
var inst_49455 = cljs.core.async.untap_STAR_.call(null,m,inst_49450);
var state_49482__$1 = (function (){var statearr_49511 = state_49482;
(statearr_49511[(24)] = inst_49454);

return statearr_49511;
})();
var statearr_49512_49585 = state_49482__$1;
(statearr_49512_49585[(2)] = inst_49455);

(statearr_49512_49585[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (33))){
var inst_49441 = (state_49482[(25)]);
var inst_49443 = cljs.core.chunked_seq_QMARK_.call(null,inst_49441);
var state_49482__$1 = state_49482;
if(inst_49443){
var statearr_49513_49586 = state_49482__$1;
(statearr_49513_49586[(1)] = (36));

} else {
var statearr_49514_49587 = state_49482__$1;
(statearr_49514_49587[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (13))){
var inst_49371 = (state_49482[(26)]);
var inst_49374 = cljs.core.async.close_BANG_.call(null,inst_49371);
var state_49482__$1 = state_49482;
var statearr_49515_49588 = state_49482__$1;
(statearr_49515_49588[(2)] = inst_49374);

(statearr_49515_49588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (22))){
var inst_49394 = (state_49482[(8)]);
var inst_49397 = cljs.core.async.close_BANG_.call(null,inst_49394);
var state_49482__$1 = state_49482;
var statearr_49516_49589 = state_49482__$1;
(statearr_49516_49589[(2)] = inst_49397);

(statearr_49516_49589[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (36))){
var inst_49441 = (state_49482[(25)]);
var inst_49445 = cljs.core.chunk_first.call(null,inst_49441);
var inst_49446 = cljs.core.chunk_rest.call(null,inst_49441);
var inst_49447 = cljs.core.count.call(null,inst_49445);
var inst_49422 = inst_49446;
var inst_49423 = inst_49445;
var inst_49424 = inst_49447;
var inst_49425 = (0);
var state_49482__$1 = (function (){var statearr_49517 = state_49482;
(statearr_49517[(20)] = inst_49424);

(statearr_49517[(10)] = inst_49425);

(statearr_49517[(21)] = inst_49422);

(statearr_49517[(12)] = inst_49423);

return statearr_49517;
})();
var statearr_49518_49590 = state_49482__$1;
(statearr_49518_49590[(2)] = null);

(statearr_49518_49590[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (41))){
var inst_49441 = (state_49482[(25)]);
var inst_49457 = (state_49482[(2)]);
var inst_49458 = cljs.core.next.call(null,inst_49441);
var inst_49422 = inst_49458;
var inst_49423 = null;
var inst_49424 = (0);
var inst_49425 = (0);
var state_49482__$1 = (function (){var statearr_49519 = state_49482;
(statearr_49519[(20)] = inst_49424);

(statearr_49519[(10)] = inst_49425);

(statearr_49519[(21)] = inst_49422);

(statearr_49519[(27)] = inst_49457);

(statearr_49519[(12)] = inst_49423);

return statearr_49519;
})();
var statearr_49520_49591 = state_49482__$1;
(statearr_49520_49591[(2)] = null);

(statearr_49520_49591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (43))){
var state_49482__$1 = state_49482;
var statearr_49521_49592 = state_49482__$1;
(statearr_49521_49592[(2)] = null);

(statearr_49521_49592[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (29))){
var inst_49466 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49522_49593 = state_49482__$1;
(statearr_49522_49593[(2)] = inst_49466);

(statearr_49522_49593[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (44))){
var inst_49475 = (state_49482[(2)]);
var state_49482__$1 = (function (){var statearr_49523 = state_49482;
(statearr_49523[(28)] = inst_49475);

return statearr_49523;
})();
var statearr_49524_49594 = state_49482__$1;
(statearr_49524_49594[(2)] = null);

(statearr_49524_49594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (6))){
var inst_49414 = (state_49482[(29)]);
var inst_49413 = cljs.core.deref.call(null,cs);
var inst_49414__$1 = cljs.core.keys.call(null,inst_49413);
var inst_49415 = cljs.core.count.call(null,inst_49414__$1);
var inst_49416 = cljs.core.reset_BANG_.call(null,dctr,inst_49415);
var inst_49421 = cljs.core.seq.call(null,inst_49414__$1);
var inst_49422 = inst_49421;
var inst_49423 = null;
var inst_49424 = (0);
var inst_49425 = (0);
var state_49482__$1 = (function (){var statearr_49525 = state_49482;
(statearr_49525[(20)] = inst_49424);

(statearr_49525[(10)] = inst_49425);

(statearr_49525[(30)] = inst_49416);

(statearr_49525[(21)] = inst_49422);

(statearr_49525[(29)] = inst_49414__$1);

(statearr_49525[(12)] = inst_49423);

return statearr_49525;
})();
var statearr_49526_49595 = state_49482__$1;
(statearr_49526_49595[(2)] = null);

(statearr_49526_49595[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (28))){
var inst_49441 = (state_49482[(25)]);
var inst_49422 = (state_49482[(21)]);
var inst_49441__$1 = cljs.core.seq.call(null,inst_49422);
var state_49482__$1 = (function (){var statearr_49527 = state_49482;
(statearr_49527[(25)] = inst_49441__$1);

return statearr_49527;
})();
if(inst_49441__$1){
var statearr_49528_49596 = state_49482__$1;
(statearr_49528_49596[(1)] = (33));

} else {
var statearr_49529_49597 = state_49482__$1;
(statearr_49529_49597[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (25))){
var inst_49424 = (state_49482[(20)]);
var inst_49425 = (state_49482[(10)]);
var inst_49427 = (inst_49425 < inst_49424);
var inst_49428 = inst_49427;
var state_49482__$1 = state_49482;
if(cljs.core.truth_(inst_49428)){
var statearr_49530_49598 = state_49482__$1;
(statearr_49530_49598[(1)] = (27));

} else {
var statearr_49531_49599 = state_49482__$1;
(statearr_49531_49599[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (34))){
var state_49482__$1 = state_49482;
var statearr_49532_49600 = state_49482__$1;
(statearr_49532_49600[(2)] = null);

(statearr_49532_49600[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (17))){
var state_49482__$1 = state_49482;
var statearr_49533_49601 = state_49482__$1;
(statearr_49533_49601[(2)] = null);

(statearr_49533_49601[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (3))){
var inst_49480 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49482__$1,inst_49480);
} else {
if((state_val_49483 === (12))){
var inst_49409 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49534_49602 = state_49482__$1;
(statearr_49534_49602[(2)] = inst_49409);

(statearr_49534_49602[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (2))){
var state_49482__$1 = state_49482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49482__$1,(4),ch);
} else {
if((state_val_49483 === (23))){
var state_49482__$1 = state_49482;
var statearr_49535_49603 = state_49482__$1;
(statearr_49535_49603[(2)] = null);

(statearr_49535_49603[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (35))){
var inst_49464 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49536_49604 = state_49482__$1;
(statearr_49536_49604[(2)] = inst_49464);

(statearr_49536_49604[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (19))){
var inst_49381 = (state_49482[(7)]);
var inst_49385 = cljs.core.chunk_first.call(null,inst_49381);
var inst_49386 = cljs.core.chunk_rest.call(null,inst_49381);
var inst_49387 = cljs.core.count.call(null,inst_49385);
var inst_49359 = inst_49386;
var inst_49360 = inst_49385;
var inst_49361 = inst_49387;
var inst_49362 = (0);
var state_49482__$1 = (function (){var statearr_49537 = state_49482;
(statearr_49537[(13)] = inst_49361);

(statearr_49537[(14)] = inst_49362);

(statearr_49537[(15)] = inst_49360);

(statearr_49537[(16)] = inst_49359);

return statearr_49537;
})();
var statearr_49538_49605 = state_49482__$1;
(statearr_49538_49605[(2)] = null);

(statearr_49538_49605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (11))){
var inst_49381 = (state_49482[(7)]);
var inst_49359 = (state_49482[(16)]);
var inst_49381__$1 = cljs.core.seq.call(null,inst_49359);
var state_49482__$1 = (function (){var statearr_49539 = state_49482;
(statearr_49539[(7)] = inst_49381__$1);

return statearr_49539;
})();
if(inst_49381__$1){
var statearr_49540_49606 = state_49482__$1;
(statearr_49540_49606[(1)] = (16));

} else {
var statearr_49541_49607 = state_49482__$1;
(statearr_49541_49607[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (9))){
var inst_49411 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49542_49608 = state_49482__$1;
(statearr_49542_49608[(2)] = inst_49411);

(statearr_49542_49608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (5))){
var inst_49357 = cljs.core.deref.call(null,cs);
var inst_49358 = cljs.core.seq.call(null,inst_49357);
var inst_49359 = inst_49358;
var inst_49360 = null;
var inst_49361 = (0);
var inst_49362 = (0);
var state_49482__$1 = (function (){var statearr_49543 = state_49482;
(statearr_49543[(13)] = inst_49361);

(statearr_49543[(14)] = inst_49362);

(statearr_49543[(15)] = inst_49360);

(statearr_49543[(16)] = inst_49359);

return statearr_49543;
})();
var statearr_49544_49609 = state_49482__$1;
(statearr_49544_49609[(2)] = null);

(statearr_49544_49609[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (14))){
var state_49482__$1 = state_49482;
var statearr_49545_49610 = state_49482__$1;
(statearr_49545_49610[(2)] = null);

(statearr_49545_49610[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (45))){
var inst_49472 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49546_49611 = state_49482__$1;
(statearr_49546_49611[(2)] = inst_49472);

(statearr_49546_49611[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (26))){
var inst_49414 = (state_49482[(29)]);
var inst_49468 = (state_49482[(2)]);
var inst_49469 = cljs.core.seq.call(null,inst_49414);
var state_49482__$1 = (function (){var statearr_49547 = state_49482;
(statearr_49547[(31)] = inst_49468);

return statearr_49547;
})();
if(inst_49469){
var statearr_49548_49612 = state_49482__$1;
(statearr_49548_49612[(1)] = (42));

} else {
var statearr_49549_49613 = state_49482__$1;
(statearr_49549_49613[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (16))){
var inst_49381 = (state_49482[(7)]);
var inst_49383 = cljs.core.chunked_seq_QMARK_.call(null,inst_49381);
var state_49482__$1 = state_49482;
if(inst_49383){
var statearr_49550_49614 = state_49482__$1;
(statearr_49550_49614[(1)] = (19));

} else {
var statearr_49551_49615 = state_49482__$1;
(statearr_49551_49615[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (38))){
var inst_49461 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49552_49616 = state_49482__$1;
(statearr_49552_49616[(2)] = inst_49461);

(statearr_49552_49616[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (30))){
var state_49482__$1 = state_49482;
var statearr_49553_49617 = state_49482__$1;
(statearr_49553_49617[(2)] = null);

(statearr_49553_49617[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (10))){
var inst_49362 = (state_49482[(14)]);
var inst_49360 = (state_49482[(15)]);
var inst_49370 = cljs.core._nth.call(null,inst_49360,inst_49362);
var inst_49371 = cljs.core.nth.call(null,inst_49370,(0),null);
var inst_49372 = cljs.core.nth.call(null,inst_49370,(1),null);
var state_49482__$1 = (function (){var statearr_49554 = state_49482;
(statearr_49554[(26)] = inst_49371);

return statearr_49554;
})();
if(cljs.core.truth_(inst_49372)){
var statearr_49555_49618 = state_49482__$1;
(statearr_49555_49618[(1)] = (13));

} else {
var statearr_49556_49619 = state_49482__$1;
(statearr_49556_49619[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (18))){
var inst_49407 = (state_49482[(2)]);
var state_49482__$1 = state_49482;
var statearr_49557_49620 = state_49482__$1;
(statearr_49557_49620[(2)] = inst_49407);

(statearr_49557_49620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (42))){
var state_49482__$1 = state_49482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49482__$1,(45),dchan);
} else {
if((state_val_49483 === (37))){
var inst_49350 = (state_49482[(9)]);
var inst_49441 = (state_49482[(25)]);
var inst_49450 = (state_49482[(23)]);
var inst_49450__$1 = cljs.core.first.call(null,inst_49441);
var inst_49451 = cljs.core.async.put_BANG_.call(null,inst_49450__$1,inst_49350,done);
var state_49482__$1 = (function (){var statearr_49558 = state_49482;
(statearr_49558[(23)] = inst_49450__$1);

return statearr_49558;
})();
if(cljs.core.truth_(inst_49451)){
var statearr_49559_49621 = state_49482__$1;
(statearr_49559_49621[(1)] = (39));

} else {
var statearr_49560_49622 = state_49482__$1;
(statearr_49560_49622[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49483 === (8))){
var inst_49361 = (state_49482[(13)]);
var inst_49362 = (state_49482[(14)]);
var inst_49364 = (inst_49362 < inst_49361);
var inst_49365 = inst_49364;
var state_49482__$1 = state_49482;
if(cljs.core.truth_(inst_49365)){
var statearr_49561_49623 = state_49482__$1;
(statearr_49561_49623[(1)] = (10));

} else {
var statearr_49562_49624 = state_49482__$1;
(statearr_49562_49624[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___49570,cs,m,dchan,dctr,done))
;
return ((function (switch__2483__auto__,c__2597__auto___49570,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__2484__auto__ = null;
var cljs$core$async$mult_$_state_machine__2484__auto____0 = (function (){
var statearr_49566 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49566[(0)] = cljs$core$async$mult_$_state_machine__2484__auto__);

(statearr_49566[(1)] = (1));

return statearr_49566;
});
var cljs$core$async$mult_$_state_machine__2484__auto____1 = (function (state_49482){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_49482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e49567){if((e49567 instanceof Object)){
var ex__2487__auto__ = e49567;
var statearr_49568_49625 = state_49482;
(statearr_49568_49625[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49626 = state_49482;
state_49482 = G__49626;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__2484__auto__ = function(state_49482){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__2484__auto____1.call(this,state_49482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__2484__auto____0;
cljs$core$async$mult_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__2484__auto____1;
return cljs$core$async$mult_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___49570,cs,m,dchan,dctr,done))
})();
var state__2599__auto__ = (function (){var statearr_49569 = f__2598__auto__.call(null);
(statearr_49569[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___49570);

return statearr_49569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___49570,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args49627 = [];
var len__11929__auto___49630 = arguments.length;
var i__11930__auto___49631 = (0);
while(true){
if((i__11930__auto___49631 < len__11929__auto___49630)){
args49627.push((arguments[i__11930__auto___49631]));

var G__49632 = (i__11930__auto___49631 + (1));
i__11930__auto___49631 = G__49632;
continue;
} else {
}
break;
}

var G__49629 = args49627.length;
switch (G__49629) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49627.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,ch);
} else {
var m__11611__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,ch);
} else {
var m__11611__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m);
} else {
var m__11611__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,state_map);
} else {
var m__11611__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__11610__auto__ = (((m == null))?null:m);
var m__11611__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,m,mode);
} else {
var m__11611__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___49644 = arguments.length;
var i__11930__auto___49645 = (0);
while(true){
if((i__11930__auto___49645 < len__11929__auto___49644)){
args__11932__auto__.push((arguments[i__11930__auto___49645]));

var G__49646 = (i__11930__auto___49645 + (1));
i__11930__auto___49645 = G__49646;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((3) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__11933__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__49638){
var map__49639 = p__49638;
var map__49639__$1 = ((((!((map__49639 == null)))?((((map__49639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49639.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49639):map__49639);
var opts = map__49639__$1;
var statearr_49641_49647 = state;
(statearr_49641_49647[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__49639,map__49639__$1,opts){
return (function (val){
var statearr_49642_49648 = state;
(statearr_49642_49648[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__49639,map__49639__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_49643_49649 = state;
(statearr_49643_49649[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq49634){
var G__49635 = cljs.core.first.call(null,seq49634);
var seq49634__$1 = cljs.core.next.call(null,seq49634);
var G__49636 = cljs.core.first.call(null,seq49634__$1);
var seq49634__$2 = cljs.core.next.call(null,seq49634__$1);
var G__49637 = cljs.core.first.call(null,seq49634__$2);
var seq49634__$3 = cljs.core.next.call(null,seq49634__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__49635,G__49636,G__49637,seq49634__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async49817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49817 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta49818){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta49818 = meta49818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_49819,meta49818__$1){
var self__ = this;
var _49819__$1 = this;
return (new cljs.core.async.t_cljs$core$async49817(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta49818__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_49819){
var self__ = this;
var _49819__$1 = this;
return self__.meta49818;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async49817.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async49817.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta49818","meta49818",-1663181050,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async49817.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async49817.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49817";

cljs.core.async.t_cljs$core$async49817.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async49817");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async49817 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async49817(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta49818){
return (new cljs.core.async.t_cljs$core$async49817(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta49818));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async49817(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2597__auto___49984 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_49921){
var state_val_49922 = (state_49921[(1)]);
if((state_val_49922 === (7))){
var inst_49836 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
var statearr_49923_49985 = state_49921__$1;
(statearr_49923_49985[(2)] = inst_49836);

(statearr_49923_49985[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (20))){
var inst_49848 = (state_49921[(7)]);
var state_49921__$1 = state_49921;
var statearr_49924_49986 = state_49921__$1;
(statearr_49924_49986[(2)] = inst_49848);

(statearr_49924_49986[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (27))){
var state_49921__$1 = state_49921;
var statearr_49925_49987 = state_49921__$1;
(statearr_49925_49987[(2)] = null);

(statearr_49925_49987[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (1))){
var inst_49823 = (state_49921[(8)]);
var inst_49823__$1 = calc_state.call(null);
var inst_49825 = (inst_49823__$1 == null);
var inst_49826 = cljs.core.not.call(null,inst_49825);
var state_49921__$1 = (function (){var statearr_49926 = state_49921;
(statearr_49926[(8)] = inst_49823__$1);

return statearr_49926;
})();
if(inst_49826){
var statearr_49927_49988 = state_49921__$1;
(statearr_49927_49988[(1)] = (2));

} else {
var statearr_49928_49989 = state_49921__$1;
(statearr_49928_49989[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (24))){
var inst_49895 = (state_49921[(9)]);
var inst_49881 = (state_49921[(10)]);
var inst_49872 = (state_49921[(11)]);
var inst_49895__$1 = inst_49872.call(null,inst_49881);
var state_49921__$1 = (function (){var statearr_49929 = state_49921;
(statearr_49929[(9)] = inst_49895__$1);

return statearr_49929;
})();
if(cljs.core.truth_(inst_49895__$1)){
var statearr_49930_49990 = state_49921__$1;
(statearr_49930_49990[(1)] = (29));

} else {
var statearr_49931_49991 = state_49921__$1;
(statearr_49931_49991[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (4))){
var inst_49839 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49839)){
var statearr_49932_49992 = state_49921__$1;
(statearr_49932_49992[(1)] = (8));

} else {
var statearr_49933_49993 = state_49921__$1;
(statearr_49933_49993[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (15))){
var inst_49866 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49866)){
var statearr_49934_49994 = state_49921__$1;
(statearr_49934_49994[(1)] = (19));

} else {
var statearr_49935_49995 = state_49921__$1;
(statearr_49935_49995[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (21))){
var inst_49871 = (state_49921[(12)]);
var inst_49871__$1 = (state_49921[(2)]);
var inst_49872 = cljs.core.get.call(null,inst_49871__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_49873 = cljs.core.get.call(null,inst_49871__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_49874 = cljs.core.get.call(null,inst_49871__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_49921__$1 = (function (){var statearr_49936 = state_49921;
(statearr_49936[(12)] = inst_49871__$1);

(statearr_49936[(11)] = inst_49872);

(statearr_49936[(13)] = inst_49873);

return statearr_49936;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_49921__$1,(22),inst_49874);
} else {
if((state_val_49922 === (31))){
var inst_49903 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49903)){
var statearr_49937_49996 = state_49921__$1;
(statearr_49937_49996[(1)] = (32));

} else {
var statearr_49938_49997 = state_49921__$1;
(statearr_49938_49997[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (32))){
var inst_49880 = (state_49921[(14)]);
var state_49921__$1 = state_49921;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49921__$1,(35),out,inst_49880);
} else {
if((state_val_49922 === (33))){
var inst_49871 = (state_49921[(12)]);
var inst_49848 = inst_49871;
var state_49921__$1 = (function (){var statearr_49939 = state_49921;
(statearr_49939[(7)] = inst_49848);

return statearr_49939;
})();
var statearr_49940_49998 = state_49921__$1;
(statearr_49940_49998[(2)] = null);

(statearr_49940_49998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (13))){
var inst_49848 = (state_49921[(7)]);
var inst_49855 = inst_49848.cljs$lang$protocol_mask$partition0$;
var inst_49856 = (inst_49855 & (64));
var inst_49857 = inst_49848.cljs$core$ISeq$;
var inst_49858 = (cljs.core.PROTOCOL_SENTINEL === inst_49857);
var inst_49859 = (inst_49856) || (inst_49858);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49859)){
var statearr_49941_49999 = state_49921__$1;
(statearr_49941_49999[(1)] = (16));

} else {
var statearr_49942_50000 = state_49921__$1;
(statearr_49942_50000[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (22))){
var inst_49880 = (state_49921[(14)]);
var inst_49881 = (state_49921[(10)]);
var inst_49879 = (state_49921[(2)]);
var inst_49880__$1 = cljs.core.nth.call(null,inst_49879,(0),null);
var inst_49881__$1 = cljs.core.nth.call(null,inst_49879,(1),null);
var inst_49882 = (inst_49880__$1 == null);
var inst_49883 = cljs.core._EQ_.call(null,inst_49881__$1,change);
var inst_49884 = (inst_49882) || (inst_49883);
var state_49921__$1 = (function (){var statearr_49943 = state_49921;
(statearr_49943[(14)] = inst_49880__$1);

(statearr_49943[(10)] = inst_49881__$1);

return statearr_49943;
})();
if(cljs.core.truth_(inst_49884)){
var statearr_49944_50001 = state_49921__$1;
(statearr_49944_50001[(1)] = (23));

} else {
var statearr_49945_50002 = state_49921__$1;
(statearr_49945_50002[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (36))){
var inst_49871 = (state_49921[(12)]);
var inst_49848 = inst_49871;
var state_49921__$1 = (function (){var statearr_49946 = state_49921;
(statearr_49946[(7)] = inst_49848);

return statearr_49946;
})();
var statearr_49947_50003 = state_49921__$1;
(statearr_49947_50003[(2)] = null);

(statearr_49947_50003[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (29))){
var inst_49895 = (state_49921[(9)]);
var state_49921__$1 = state_49921;
var statearr_49948_50004 = state_49921__$1;
(statearr_49948_50004[(2)] = inst_49895);

(statearr_49948_50004[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (6))){
var state_49921__$1 = state_49921;
var statearr_49949_50005 = state_49921__$1;
(statearr_49949_50005[(2)] = false);

(statearr_49949_50005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (28))){
var inst_49891 = (state_49921[(2)]);
var inst_49892 = calc_state.call(null);
var inst_49848 = inst_49892;
var state_49921__$1 = (function (){var statearr_49950 = state_49921;
(statearr_49950[(7)] = inst_49848);

(statearr_49950[(15)] = inst_49891);

return statearr_49950;
})();
var statearr_49951_50006 = state_49921__$1;
(statearr_49951_50006[(2)] = null);

(statearr_49951_50006[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (25))){
var inst_49917 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
var statearr_49952_50007 = state_49921__$1;
(statearr_49952_50007[(2)] = inst_49917);

(statearr_49952_50007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (34))){
var inst_49915 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
var statearr_49953_50008 = state_49921__$1;
(statearr_49953_50008[(2)] = inst_49915);

(statearr_49953_50008[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (17))){
var state_49921__$1 = state_49921;
var statearr_49954_50009 = state_49921__$1;
(statearr_49954_50009[(2)] = false);

(statearr_49954_50009[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (3))){
var state_49921__$1 = state_49921;
var statearr_49955_50010 = state_49921__$1;
(statearr_49955_50010[(2)] = false);

(statearr_49955_50010[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (12))){
var inst_49919 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49921__$1,inst_49919);
} else {
if((state_val_49922 === (2))){
var inst_49823 = (state_49921[(8)]);
var inst_49828 = inst_49823.cljs$lang$protocol_mask$partition0$;
var inst_49829 = (inst_49828 & (64));
var inst_49830 = inst_49823.cljs$core$ISeq$;
var inst_49831 = (cljs.core.PROTOCOL_SENTINEL === inst_49830);
var inst_49832 = (inst_49829) || (inst_49831);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49832)){
var statearr_49956_50011 = state_49921__$1;
(statearr_49956_50011[(1)] = (5));

} else {
var statearr_49957_50012 = state_49921__$1;
(statearr_49957_50012[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (23))){
var inst_49880 = (state_49921[(14)]);
var inst_49886 = (inst_49880 == null);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49886)){
var statearr_49958_50013 = state_49921__$1;
(statearr_49958_50013[(1)] = (26));

} else {
var statearr_49959_50014 = state_49921__$1;
(statearr_49959_50014[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (35))){
var inst_49906 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
if(cljs.core.truth_(inst_49906)){
var statearr_49960_50015 = state_49921__$1;
(statearr_49960_50015[(1)] = (36));

} else {
var statearr_49961_50016 = state_49921__$1;
(statearr_49961_50016[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (19))){
var inst_49848 = (state_49921[(7)]);
var inst_49868 = cljs.core.apply.call(null,cljs.core.hash_map,inst_49848);
var state_49921__$1 = state_49921;
var statearr_49962_50017 = state_49921__$1;
(statearr_49962_50017[(2)] = inst_49868);

(statearr_49962_50017[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (11))){
var inst_49848 = (state_49921[(7)]);
var inst_49852 = (inst_49848 == null);
var inst_49853 = cljs.core.not.call(null,inst_49852);
var state_49921__$1 = state_49921;
if(inst_49853){
var statearr_49963_50018 = state_49921__$1;
(statearr_49963_50018[(1)] = (13));

} else {
var statearr_49964_50019 = state_49921__$1;
(statearr_49964_50019[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (9))){
var inst_49823 = (state_49921[(8)]);
var state_49921__$1 = state_49921;
var statearr_49965_50020 = state_49921__$1;
(statearr_49965_50020[(2)] = inst_49823);

(statearr_49965_50020[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (5))){
var state_49921__$1 = state_49921;
var statearr_49966_50021 = state_49921__$1;
(statearr_49966_50021[(2)] = true);

(statearr_49966_50021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (14))){
var state_49921__$1 = state_49921;
var statearr_49967_50022 = state_49921__$1;
(statearr_49967_50022[(2)] = false);

(statearr_49967_50022[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (26))){
var inst_49881 = (state_49921[(10)]);
var inst_49888 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_49881);
var state_49921__$1 = state_49921;
var statearr_49968_50023 = state_49921__$1;
(statearr_49968_50023[(2)] = inst_49888);

(statearr_49968_50023[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (16))){
var state_49921__$1 = state_49921;
var statearr_49969_50024 = state_49921__$1;
(statearr_49969_50024[(2)] = true);

(statearr_49969_50024[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (38))){
var inst_49911 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
var statearr_49970_50025 = state_49921__$1;
(statearr_49970_50025[(2)] = inst_49911);

(statearr_49970_50025[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (30))){
var inst_49881 = (state_49921[(10)]);
var inst_49872 = (state_49921[(11)]);
var inst_49873 = (state_49921[(13)]);
var inst_49898 = cljs.core.empty_QMARK_.call(null,inst_49872);
var inst_49899 = inst_49873.call(null,inst_49881);
var inst_49900 = cljs.core.not.call(null,inst_49899);
var inst_49901 = (inst_49898) && (inst_49900);
var state_49921__$1 = state_49921;
var statearr_49971_50026 = state_49921__$1;
(statearr_49971_50026[(2)] = inst_49901);

(statearr_49971_50026[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (10))){
var inst_49823 = (state_49921[(8)]);
var inst_49844 = (state_49921[(2)]);
var inst_49845 = cljs.core.get.call(null,inst_49844,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_49846 = cljs.core.get.call(null,inst_49844,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_49847 = cljs.core.get.call(null,inst_49844,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_49848 = inst_49823;
var state_49921__$1 = (function (){var statearr_49972 = state_49921;
(statearr_49972[(16)] = inst_49845);

(statearr_49972[(17)] = inst_49846);

(statearr_49972[(7)] = inst_49848);

(statearr_49972[(18)] = inst_49847);

return statearr_49972;
})();
var statearr_49973_50027 = state_49921__$1;
(statearr_49973_50027[(2)] = null);

(statearr_49973_50027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (18))){
var inst_49863 = (state_49921[(2)]);
var state_49921__$1 = state_49921;
var statearr_49974_50028 = state_49921__$1;
(statearr_49974_50028[(2)] = inst_49863);

(statearr_49974_50028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (37))){
var state_49921__$1 = state_49921;
var statearr_49975_50029 = state_49921__$1;
(statearr_49975_50029[(2)] = null);

(statearr_49975_50029[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49922 === (8))){
var inst_49823 = (state_49921[(8)]);
var inst_49841 = cljs.core.apply.call(null,cljs.core.hash_map,inst_49823);
var state_49921__$1 = state_49921;
var statearr_49976_50030 = state_49921__$1;
(statearr_49976_50030[(2)] = inst_49841);

(statearr_49976_50030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__2483__auto__,c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__2484__auto__ = null;
var cljs$core$async$mix_$_state_machine__2484__auto____0 = (function (){
var statearr_49980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49980[(0)] = cljs$core$async$mix_$_state_machine__2484__auto__);

(statearr_49980[(1)] = (1));

return statearr_49980;
});
var cljs$core$async$mix_$_state_machine__2484__auto____1 = (function (state_49921){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_49921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e49981){if((e49981 instanceof Object)){
var ex__2487__auto__ = e49981;
var statearr_49982_50031 = state_49921;
(statearr_49982_50031[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49981;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50032 = state_49921;
state_49921 = G__50032;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__2484__auto__ = function(state_49921){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__2484__auto____1.call(this,state_49921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__2484__auto____0;
cljs$core$async$mix_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__2484__auto____1;
return cljs$core$async$mix_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__2599__auto__ = (function (){var statearr_49983 = f__2598__auto__.call(null);
(statearr_49983[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___49984);

return statearr_49983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___49984,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__11610__auto__ = (((p == null))?null:p);
var m__11611__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__11611__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__11610__auto__ = (((p == null))?null:p);
var m__11611__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,p,v,ch);
} else {
var m__11611__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args50033 = [];
var len__11929__auto___50036 = arguments.length;
var i__11930__auto___50037 = (0);
while(true){
if((i__11930__auto___50037 < len__11929__auto___50036)){
args50033.push((arguments[i__11930__auto___50037]));

var G__50038 = (i__11930__auto___50037 + (1));
i__11930__auto___50037 = G__50038;
continue;
} else {
}
break;
}

var G__50035 = args50033.length;
switch (G__50035) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50033.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__11610__auto__ = (((p == null))?null:p);
var m__11611__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,p);
} else {
var m__11611__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__11610__auto__ = (((p == null))?null:p);
var m__11611__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,p,v);
} else {
var m__11611__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args50041 = [];
var len__11929__auto___50166 = arguments.length;
var i__11930__auto___50167 = (0);
while(true){
if((i__11930__auto___50167 < len__11929__auto___50166)){
args50041.push((arguments[i__11930__auto___50167]));

var G__50168 = (i__11930__auto___50167 + (1));
i__11930__auto___50167 = G__50168;
continue;
} else {
}
break;
}

var G__50043 = args50041.length;
switch (G__50043) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50041.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__11280__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__11280__auto__,mults){
return (function (p1__50040_SHARP_){
if(cljs.core.truth_(p1__50040_SHARP_.call(null,topic))){
return p1__50040_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__50040_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__11280__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async50044 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50044 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta50045){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta50045 = meta50045;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_50046,meta50045__$1){
var self__ = this;
var _50046__$1 = this;
return (new cljs.core.async.t_cljs$core$async50044(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta50045__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_50046){
var self__ = this;
var _50046__$1 = this;
return self__.meta50045;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async50044.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async50044.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta50045","meta50045",-597270550,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async50044.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50044.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50044";

cljs.core.async.t_cljs$core$async50044.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async50044");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async50044 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async50044(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta50045){
return (new cljs.core.async.t_cljs$core$async50044(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta50045));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async50044(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2597__auto___50170 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50170,mults,ensure_mult,p){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50170,mults,ensure_mult,p){
return (function (state_50118){
var state_val_50119 = (state_50118[(1)]);
if((state_val_50119 === (7))){
var inst_50114 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50120_50171 = state_50118__$1;
(statearr_50120_50171[(2)] = inst_50114);

(statearr_50120_50171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (20))){
var state_50118__$1 = state_50118;
var statearr_50121_50172 = state_50118__$1;
(statearr_50121_50172[(2)] = null);

(statearr_50121_50172[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (1))){
var state_50118__$1 = state_50118;
var statearr_50122_50173 = state_50118__$1;
(statearr_50122_50173[(2)] = null);

(statearr_50122_50173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (24))){
var inst_50097 = (state_50118[(7)]);
var inst_50106 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_50097);
var state_50118__$1 = state_50118;
var statearr_50123_50174 = state_50118__$1;
(statearr_50123_50174[(2)] = inst_50106);

(statearr_50123_50174[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (4))){
var inst_50049 = (state_50118[(8)]);
var inst_50049__$1 = (state_50118[(2)]);
var inst_50050 = (inst_50049__$1 == null);
var state_50118__$1 = (function (){var statearr_50124 = state_50118;
(statearr_50124[(8)] = inst_50049__$1);

return statearr_50124;
})();
if(cljs.core.truth_(inst_50050)){
var statearr_50125_50175 = state_50118__$1;
(statearr_50125_50175[(1)] = (5));

} else {
var statearr_50126_50176 = state_50118__$1;
(statearr_50126_50176[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (15))){
var inst_50091 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50127_50177 = state_50118__$1;
(statearr_50127_50177[(2)] = inst_50091);

(statearr_50127_50177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (21))){
var inst_50111 = (state_50118[(2)]);
var state_50118__$1 = (function (){var statearr_50128 = state_50118;
(statearr_50128[(9)] = inst_50111);

return statearr_50128;
})();
var statearr_50129_50178 = state_50118__$1;
(statearr_50129_50178[(2)] = null);

(statearr_50129_50178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (13))){
var inst_50073 = (state_50118[(10)]);
var inst_50075 = cljs.core.chunked_seq_QMARK_.call(null,inst_50073);
var state_50118__$1 = state_50118;
if(inst_50075){
var statearr_50130_50179 = state_50118__$1;
(statearr_50130_50179[(1)] = (16));

} else {
var statearr_50131_50180 = state_50118__$1;
(statearr_50131_50180[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (22))){
var inst_50103 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
if(cljs.core.truth_(inst_50103)){
var statearr_50132_50181 = state_50118__$1;
(statearr_50132_50181[(1)] = (23));

} else {
var statearr_50133_50182 = state_50118__$1;
(statearr_50133_50182[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (6))){
var inst_50097 = (state_50118[(7)]);
var inst_50099 = (state_50118[(11)]);
var inst_50049 = (state_50118[(8)]);
var inst_50097__$1 = topic_fn.call(null,inst_50049);
var inst_50098 = cljs.core.deref.call(null,mults);
var inst_50099__$1 = cljs.core.get.call(null,inst_50098,inst_50097__$1);
var state_50118__$1 = (function (){var statearr_50134 = state_50118;
(statearr_50134[(7)] = inst_50097__$1);

(statearr_50134[(11)] = inst_50099__$1);

return statearr_50134;
})();
if(cljs.core.truth_(inst_50099__$1)){
var statearr_50135_50183 = state_50118__$1;
(statearr_50135_50183[(1)] = (19));

} else {
var statearr_50136_50184 = state_50118__$1;
(statearr_50136_50184[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (25))){
var inst_50108 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50137_50185 = state_50118__$1;
(statearr_50137_50185[(2)] = inst_50108);

(statearr_50137_50185[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (17))){
var inst_50073 = (state_50118[(10)]);
var inst_50082 = cljs.core.first.call(null,inst_50073);
var inst_50083 = cljs.core.async.muxch_STAR_.call(null,inst_50082);
var inst_50084 = cljs.core.async.close_BANG_.call(null,inst_50083);
var inst_50085 = cljs.core.next.call(null,inst_50073);
var inst_50059 = inst_50085;
var inst_50060 = null;
var inst_50061 = (0);
var inst_50062 = (0);
var state_50118__$1 = (function (){var statearr_50138 = state_50118;
(statearr_50138[(12)] = inst_50084);

(statearr_50138[(13)] = inst_50061);

(statearr_50138[(14)] = inst_50059);

(statearr_50138[(15)] = inst_50062);

(statearr_50138[(16)] = inst_50060);

return statearr_50138;
})();
var statearr_50139_50186 = state_50118__$1;
(statearr_50139_50186[(2)] = null);

(statearr_50139_50186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (3))){
var inst_50116 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50118__$1,inst_50116);
} else {
if((state_val_50119 === (12))){
var inst_50093 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50140_50187 = state_50118__$1;
(statearr_50140_50187[(2)] = inst_50093);

(statearr_50140_50187[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (2))){
var state_50118__$1 = state_50118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50118__$1,(4),ch);
} else {
if((state_val_50119 === (23))){
var state_50118__$1 = state_50118;
var statearr_50141_50188 = state_50118__$1;
(statearr_50141_50188[(2)] = null);

(statearr_50141_50188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (19))){
var inst_50099 = (state_50118[(11)]);
var inst_50049 = (state_50118[(8)]);
var inst_50101 = cljs.core.async.muxch_STAR_.call(null,inst_50099);
var state_50118__$1 = state_50118;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50118__$1,(22),inst_50101,inst_50049);
} else {
if((state_val_50119 === (11))){
var inst_50059 = (state_50118[(14)]);
var inst_50073 = (state_50118[(10)]);
var inst_50073__$1 = cljs.core.seq.call(null,inst_50059);
var state_50118__$1 = (function (){var statearr_50142 = state_50118;
(statearr_50142[(10)] = inst_50073__$1);

return statearr_50142;
})();
if(inst_50073__$1){
var statearr_50143_50189 = state_50118__$1;
(statearr_50143_50189[(1)] = (13));

} else {
var statearr_50144_50190 = state_50118__$1;
(statearr_50144_50190[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (9))){
var inst_50095 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50145_50191 = state_50118__$1;
(statearr_50145_50191[(2)] = inst_50095);

(statearr_50145_50191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (5))){
var inst_50056 = cljs.core.deref.call(null,mults);
var inst_50057 = cljs.core.vals.call(null,inst_50056);
var inst_50058 = cljs.core.seq.call(null,inst_50057);
var inst_50059 = inst_50058;
var inst_50060 = null;
var inst_50061 = (0);
var inst_50062 = (0);
var state_50118__$1 = (function (){var statearr_50146 = state_50118;
(statearr_50146[(13)] = inst_50061);

(statearr_50146[(14)] = inst_50059);

(statearr_50146[(15)] = inst_50062);

(statearr_50146[(16)] = inst_50060);

return statearr_50146;
})();
var statearr_50147_50192 = state_50118__$1;
(statearr_50147_50192[(2)] = null);

(statearr_50147_50192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (14))){
var state_50118__$1 = state_50118;
var statearr_50151_50193 = state_50118__$1;
(statearr_50151_50193[(2)] = null);

(statearr_50151_50193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (16))){
var inst_50073 = (state_50118[(10)]);
var inst_50077 = cljs.core.chunk_first.call(null,inst_50073);
var inst_50078 = cljs.core.chunk_rest.call(null,inst_50073);
var inst_50079 = cljs.core.count.call(null,inst_50077);
var inst_50059 = inst_50078;
var inst_50060 = inst_50077;
var inst_50061 = inst_50079;
var inst_50062 = (0);
var state_50118__$1 = (function (){var statearr_50152 = state_50118;
(statearr_50152[(13)] = inst_50061);

(statearr_50152[(14)] = inst_50059);

(statearr_50152[(15)] = inst_50062);

(statearr_50152[(16)] = inst_50060);

return statearr_50152;
})();
var statearr_50153_50194 = state_50118__$1;
(statearr_50153_50194[(2)] = null);

(statearr_50153_50194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (10))){
var inst_50061 = (state_50118[(13)]);
var inst_50059 = (state_50118[(14)]);
var inst_50062 = (state_50118[(15)]);
var inst_50060 = (state_50118[(16)]);
var inst_50067 = cljs.core._nth.call(null,inst_50060,inst_50062);
var inst_50068 = cljs.core.async.muxch_STAR_.call(null,inst_50067);
var inst_50069 = cljs.core.async.close_BANG_.call(null,inst_50068);
var inst_50070 = (inst_50062 + (1));
var tmp50148 = inst_50061;
var tmp50149 = inst_50059;
var tmp50150 = inst_50060;
var inst_50059__$1 = tmp50149;
var inst_50060__$1 = tmp50150;
var inst_50061__$1 = tmp50148;
var inst_50062__$1 = inst_50070;
var state_50118__$1 = (function (){var statearr_50154 = state_50118;
(statearr_50154[(17)] = inst_50069);

(statearr_50154[(13)] = inst_50061__$1);

(statearr_50154[(14)] = inst_50059__$1);

(statearr_50154[(15)] = inst_50062__$1);

(statearr_50154[(16)] = inst_50060__$1);

return statearr_50154;
})();
var statearr_50155_50195 = state_50118__$1;
(statearr_50155_50195[(2)] = null);

(statearr_50155_50195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (18))){
var inst_50088 = (state_50118[(2)]);
var state_50118__$1 = state_50118;
var statearr_50156_50196 = state_50118__$1;
(statearr_50156_50196[(2)] = inst_50088);

(statearr_50156_50196[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50119 === (8))){
var inst_50061 = (state_50118[(13)]);
var inst_50062 = (state_50118[(15)]);
var inst_50064 = (inst_50062 < inst_50061);
var inst_50065 = inst_50064;
var state_50118__$1 = state_50118;
if(cljs.core.truth_(inst_50065)){
var statearr_50157_50197 = state_50118__$1;
(statearr_50157_50197[(1)] = (10));

} else {
var statearr_50158_50198 = state_50118__$1;
(statearr_50158_50198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50170,mults,ensure_mult,p))
;
return ((function (switch__2483__auto__,c__2597__auto___50170,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50162 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50162[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50162[(1)] = (1));

return statearr_50162;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50118){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50163){if((e50163 instanceof Object)){
var ex__2487__auto__ = e50163;
var statearr_50164_50199 = state_50118;
(statearr_50164_50199[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50163;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50200 = state_50118;
state_50118 = G__50200;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50118){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50170,mults,ensure_mult,p))
})();
var state__2599__auto__ = (function (){var statearr_50165 = f__2598__auto__.call(null);
(statearr_50165[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50170);

return statearr_50165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50170,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args50201 = [];
var len__11929__auto___50204 = arguments.length;
var i__11930__auto___50205 = (0);
while(true){
if((i__11930__auto___50205 < len__11929__auto___50204)){
args50201.push((arguments[i__11930__auto___50205]));

var G__50206 = (i__11930__auto___50205 + (1));
i__11930__auto___50205 = G__50206;
continue;
} else {
}
break;
}

var G__50203 = args50201.length;
switch (G__50203) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50201.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args50208 = [];
var len__11929__auto___50211 = arguments.length;
var i__11930__auto___50212 = (0);
while(true){
if((i__11930__auto___50212 < len__11929__auto___50211)){
args50208.push((arguments[i__11930__auto___50212]));

var G__50213 = (i__11930__auto___50212 + (1));
i__11930__auto___50212 = G__50213;
continue;
} else {
}
break;
}

var G__50210 = args50208.length;
switch (G__50210) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50208.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args50215 = [];
var len__11929__auto___50286 = arguments.length;
var i__11930__auto___50287 = (0);
while(true){
if((i__11930__auto___50287 < len__11929__auto___50286)){
args50215.push((arguments[i__11930__auto___50287]));

var G__50288 = (i__11930__auto___50287 + (1));
i__11930__auto___50287 = G__50288;
continue;
} else {
}
break;
}

var G__50217 = args50215.length;
switch (G__50217) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50215.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__2597__auto___50290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_50256){
var state_val_50257 = (state_50256[(1)]);
if((state_val_50257 === (7))){
var state_50256__$1 = state_50256;
var statearr_50258_50291 = state_50256__$1;
(statearr_50258_50291[(2)] = null);

(statearr_50258_50291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (1))){
var state_50256__$1 = state_50256;
var statearr_50259_50292 = state_50256__$1;
(statearr_50259_50292[(2)] = null);

(statearr_50259_50292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (4))){
var inst_50220 = (state_50256[(7)]);
var inst_50222 = (inst_50220 < cnt);
var state_50256__$1 = state_50256;
if(cljs.core.truth_(inst_50222)){
var statearr_50260_50293 = state_50256__$1;
(statearr_50260_50293[(1)] = (6));

} else {
var statearr_50261_50294 = state_50256__$1;
(statearr_50261_50294[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (15))){
var inst_50252 = (state_50256[(2)]);
var state_50256__$1 = state_50256;
var statearr_50262_50295 = state_50256__$1;
(statearr_50262_50295[(2)] = inst_50252);

(statearr_50262_50295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (13))){
var inst_50245 = cljs.core.async.close_BANG_.call(null,out);
var state_50256__$1 = state_50256;
var statearr_50263_50296 = state_50256__$1;
(statearr_50263_50296[(2)] = inst_50245);

(statearr_50263_50296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (6))){
var state_50256__$1 = state_50256;
var statearr_50264_50297 = state_50256__$1;
(statearr_50264_50297[(2)] = null);

(statearr_50264_50297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (3))){
var inst_50254 = (state_50256[(2)]);
var state_50256__$1 = state_50256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50256__$1,inst_50254);
} else {
if((state_val_50257 === (12))){
var inst_50242 = (state_50256[(8)]);
var inst_50242__$1 = (state_50256[(2)]);
var inst_50243 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_50242__$1);
var state_50256__$1 = (function (){var statearr_50265 = state_50256;
(statearr_50265[(8)] = inst_50242__$1);

return statearr_50265;
})();
if(cljs.core.truth_(inst_50243)){
var statearr_50266_50298 = state_50256__$1;
(statearr_50266_50298[(1)] = (13));

} else {
var statearr_50267_50299 = state_50256__$1;
(statearr_50267_50299[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (2))){
var inst_50219 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_50220 = (0);
var state_50256__$1 = (function (){var statearr_50268 = state_50256;
(statearr_50268[(7)] = inst_50220);

(statearr_50268[(9)] = inst_50219);

return statearr_50268;
})();
var statearr_50269_50300 = state_50256__$1;
(statearr_50269_50300[(2)] = null);

(statearr_50269_50300[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (11))){
var inst_50220 = (state_50256[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_50256,(10),Object,null,(9));
var inst_50229 = chs__$1.call(null,inst_50220);
var inst_50230 = done.call(null,inst_50220);
var inst_50231 = cljs.core.async.take_BANG_.call(null,inst_50229,inst_50230);
var state_50256__$1 = state_50256;
var statearr_50270_50301 = state_50256__$1;
(statearr_50270_50301[(2)] = inst_50231);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50256__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (9))){
var inst_50220 = (state_50256[(7)]);
var inst_50233 = (state_50256[(2)]);
var inst_50234 = (inst_50220 + (1));
var inst_50220__$1 = inst_50234;
var state_50256__$1 = (function (){var statearr_50271 = state_50256;
(statearr_50271[(7)] = inst_50220__$1);

(statearr_50271[(10)] = inst_50233);

return statearr_50271;
})();
var statearr_50272_50302 = state_50256__$1;
(statearr_50272_50302[(2)] = null);

(statearr_50272_50302[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (5))){
var inst_50240 = (state_50256[(2)]);
var state_50256__$1 = (function (){var statearr_50273 = state_50256;
(statearr_50273[(11)] = inst_50240);

return statearr_50273;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50256__$1,(12),dchan);
} else {
if((state_val_50257 === (14))){
var inst_50242 = (state_50256[(8)]);
var inst_50247 = cljs.core.apply.call(null,f,inst_50242);
var state_50256__$1 = state_50256;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50256__$1,(16),out,inst_50247);
} else {
if((state_val_50257 === (16))){
var inst_50249 = (state_50256[(2)]);
var state_50256__$1 = (function (){var statearr_50274 = state_50256;
(statearr_50274[(12)] = inst_50249);

return statearr_50274;
})();
var statearr_50275_50303 = state_50256__$1;
(statearr_50275_50303[(2)] = null);

(statearr_50275_50303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (10))){
var inst_50224 = (state_50256[(2)]);
var inst_50225 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_50256__$1 = (function (){var statearr_50276 = state_50256;
(statearr_50276[(13)] = inst_50224);

return statearr_50276;
})();
var statearr_50277_50304 = state_50256__$1;
(statearr_50277_50304[(2)] = inst_50225);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50256__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50257 === (8))){
var inst_50238 = (state_50256[(2)]);
var state_50256__$1 = state_50256;
var statearr_50278_50305 = state_50256__$1;
(statearr_50278_50305[(2)] = inst_50238);

(statearr_50278_50305[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__2483__auto__,c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50282[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50282[(1)] = (1));

return statearr_50282;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50256){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50283){if((e50283 instanceof Object)){
var ex__2487__auto__ = e50283;
var statearr_50284_50306 = state_50256;
(statearr_50284_50306[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50256);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50307 = state_50256;
state_50256 = G__50307;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50256){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__2599__auto__ = (function (){var statearr_50285 = f__2598__auto__.call(null);
(statearr_50285[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50290);

return statearr_50285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50290,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args50309 = [];
var len__11929__auto___50367 = arguments.length;
var i__11930__auto___50368 = (0);
while(true){
if((i__11930__auto___50368 < len__11929__auto___50367)){
args50309.push((arguments[i__11930__auto___50368]));

var G__50369 = (i__11930__auto___50368 + (1));
i__11930__auto___50368 = G__50369;
continue;
} else {
}
break;
}

var G__50311 = args50309.length;
switch (G__50311) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50309.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___50371 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50371,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50371,out){
return (function (state_50343){
var state_val_50344 = (state_50343[(1)]);
if((state_val_50344 === (7))){
var inst_50323 = (state_50343[(7)]);
var inst_50322 = (state_50343[(8)]);
var inst_50322__$1 = (state_50343[(2)]);
var inst_50323__$1 = cljs.core.nth.call(null,inst_50322__$1,(0),null);
var inst_50324 = cljs.core.nth.call(null,inst_50322__$1,(1),null);
var inst_50325 = (inst_50323__$1 == null);
var state_50343__$1 = (function (){var statearr_50345 = state_50343;
(statearr_50345[(9)] = inst_50324);

(statearr_50345[(7)] = inst_50323__$1);

(statearr_50345[(8)] = inst_50322__$1);

return statearr_50345;
})();
if(cljs.core.truth_(inst_50325)){
var statearr_50346_50372 = state_50343__$1;
(statearr_50346_50372[(1)] = (8));

} else {
var statearr_50347_50373 = state_50343__$1;
(statearr_50347_50373[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (1))){
var inst_50312 = cljs.core.vec.call(null,chs);
var inst_50313 = inst_50312;
var state_50343__$1 = (function (){var statearr_50348 = state_50343;
(statearr_50348[(10)] = inst_50313);

return statearr_50348;
})();
var statearr_50349_50374 = state_50343__$1;
(statearr_50349_50374[(2)] = null);

(statearr_50349_50374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (4))){
var inst_50313 = (state_50343[(10)]);
var state_50343__$1 = state_50343;
return cljs.core.async.ioc_alts_BANG_.call(null,state_50343__$1,(7),inst_50313);
} else {
if((state_val_50344 === (6))){
var inst_50339 = (state_50343[(2)]);
var state_50343__$1 = state_50343;
var statearr_50350_50375 = state_50343__$1;
(statearr_50350_50375[(2)] = inst_50339);

(statearr_50350_50375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (3))){
var inst_50341 = (state_50343[(2)]);
var state_50343__$1 = state_50343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50343__$1,inst_50341);
} else {
if((state_val_50344 === (2))){
var inst_50313 = (state_50343[(10)]);
var inst_50315 = cljs.core.count.call(null,inst_50313);
var inst_50316 = (inst_50315 > (0));
var state_50343__$1 = state_50343;
if(cljs.core.truth_(inst_50316)){
var statearr_50352_50376 = state_50343__$1;
(statearr_50352_50376[(1)] = (4));

} else {
var statearr_50353_50377 = state_50343__$1;
(statearr_50353_50377[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (11))){
var inst_50313 = (state_50343[(10)]);
var inst_50332 = (state_50343[(2)]);
var tmp50351 = inst_50313;
var inst_50313__$1 = tmp50351;
var state_50343__$1 = (function (){var statearr_50354 = state_50343;
(statearr_50354[(10)] = inst_50313__$1);

(statearr_50354[(11)] = inst_50332);

return statearr_50354;
})();
var statearr_50355_50378 = state_50343__$1;
(statearr_50355_50378[(2)] = null);

(statearr_50355_50378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (9))){
var inst_50323 = (state_50343[(7)]);
var state_50343__$1 = state_50343;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50343__$1,(11),out,inst_50323);
} else {
if((state_val_50344 === (5))){
var inst_50337 = cljs.core.async.close_BANG_.call(null,out);
var state_50343__$1 = state_50343;
var statearr_50356_50379 = state_50343__$1;
(statearr_50356_50379[(2)] = inst_50337);

(statearr_50356_50379[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (10))){
var inst_50335 = (state_50343[(2)]);
var state_50343__$1 = state_50343;
var statearr_50357_50380 = state_50343__$1;
(statearr_50357_50380[(2)] = inst_50335);

(statearr_50357_50380[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50344 === (8))){
var inst_50313 = (state_50343[(10)]);
var inst_50324 = (state_50343[(9)]);
var inst_50323 = (state_50343[(7)]);
var inst_50322 = (state_50343[(8)]);
var inst_50327 = (function (){var cs = inst_50313;
var vec__50318 = inst_50322;
var v = inst_50323;
var c = inst_50324;
return ((function (cs,vec__50318,v,c,inst_50313,inst_50324,inst_50323,inst_50322,state_val_50344,c__2597__auto___50371,out){
return (function (p1__50308_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__50308_SHARP_);
});
;})(cs,vec__50318,v,c,inst_50313,inst_50324,inst_50323,inst_50322,state_val_50344,c__2597__auto___50371,out))
})();
var inst_50328 = cljs.core.filterv.call(null,inst_50327,inst_50313);
var inst_50313__$1 = inst_50328;
var state_50343__$1 = (function (){var statearr_50358 = state_50343;
(statearr_50358[(10)] = inst_50313__$1);

return statearr_50358;
})();
var statearr_50359_50381 = state_50343__$1;
(statearr_50359_50381[(2)] = null);

(statearr_50359_50381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50371,out))
;
return ((function (switch__2483__auto__,c__2597__auto___50371,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50363 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50363[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50363[(1)] = (1));

return statearr_50363;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50343){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50364){if((e50364 instanceof Object)){
var ex__2487__auto__ = e50364;
var statearr_50365_50382 = state_50343;
(statearr_50365_50382[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50364;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50383 = state_50343;
state_50343 = G__50383;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50343){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50371,out))
})();
var state__2599__auto__ = (function (){var statearr_50366 = f__2598__auto__.call(null);
(statearr_50366[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50371);

return statearr_50366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50371,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args50384 = [];
var len__11929__auto___50433 = arguments.length;
var i__11930__auto___50434 = (0);
while(true){
if((i__11930__auto___50434 < len__11929__auto___50433)){
args50384.push((arguments[i__11930__auto___50434]));

var G__50435 = (i__11930__auto___50434 + (1));
i__11930__auto___50434 = G__50435;
continue;
} else {
}
break;
}

var G__50386 = args50384.length;
switch (G__50386) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50384.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___50437 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50437,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50437,out){
return (function (state_50410){
var state_val_50411 = (state_50410[(1)]);
if((state_val_50411 === (7))){
var inst_50392 = (state_50410[(7)]);
var inst_50392__$1 = (state_50410[(2)]);
var inst_50393 = (inst_50392__$1 == null);
var inst_50394 = cljs.core.not.call(null,inst_50393);
var state_50410__$1 = (function (){var statearr_50412 = state_50410;
(statearr_50412[(7)] = inst_50392__$1);

return statearr_50412;
})();
if(inst_50394){
var statearr_50413_50438 = state_50410__$1;
(statearr_50413_50438[(1)] = (8));

} else {
var statearr_50414_50439 = state_50410__$1;
(statearr_50414_50439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (1))){
var inst_50387 = (0);
var state_50410__$1 = (function (){var statearr_50415 = state_50410;
(statearr_50415[(8)] = inst_50387);

return statearr_50415;
})();
var statearr_50416_50440 = state_50410__$1;
(statearr_50416_50440[(2)] = null);

(statearr_50416_50440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (4))){
var state_50410__$1 = state_50410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50410__$1,(7),ch);
} else {
if((state_val_50411 === (6))){
var inst_50405 = (state_50410[(2)]);
var state_50410__$1 = state_50410;
var statearr_50417_50441 = state_50410__$1;
(statearr_50417_50441[(2)] = inst_50405);

(statearr_50417_50441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (3))){
var inst_50407 = (state_50410[(2)]);
var inst_50408 = cljs.core.async.close_BANG_.call(null,out);
var state_50410__$1 = (function (){var statearr_50418 = state_50410;
(statearr_50418[(9)] = inst_50407);

return statearr_50418;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50410__$1,inst_50408);
} else {
if((state_val_50411 === (2))){
var inst_50387 = (state_50410[(8)]);
var inst_50389 = (inst_50387 < n);
var state_50410__$1 = state_50410;
if(cljs.core.truth_(inst_50389)){
var statearr_50419_50442 = state_50410__$1;
(statearr_50419_50442[(1)] = (4));

} else {
var statearr_50420_50443 = state_50410__$1;
(statearr_50420_50443[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (11))){
var inst_50387 = (state_50410[(8)]);
var inst_50397 = (state_50410[(2)]);
var inst_50398 = (inst_50387 + (1));
var inst_50387__$1 = inst_50398;
var state_50410__$1 = (function (){var statearr_50421 = state_50410;
(statearr_50421[(10)] = inst_50397);

(statearr_50421[(8)] = inst_50387__$1);

return statearr_50421;
})();
var statearr_50422_50444 = state_50410__$1;
(statearr_50422_50444[(2)] = null);

(statearr_50422_50444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (9))){
var state_50410__$1 = state_50410;
var statearr_50423_50445 = state_50410__$1;
(statearr_50423_50445[(2)] = null);

(statearr_50423_50445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (5))){
var state_50410__$1 = state_50410;
var statearr_50424_50446 = state_50410__$1;
(statearr_50424_50446[(2)] = null);

(statearr_50424_50446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (10))){
var inst_50402 = (state_50410[(2)]);
var state_50410__$1 = state_50410;
var statearr_50425_50447 = state_50410__$1;
(statearr_50425_50447[(2)] = inst_50402);

(statearr_50425_50447[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50411 === (8))){
var inst_50392 = (state_50410[(7)]);
var state_50410__$1 = state_50410;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50410__$1,(11),out,inst_50392);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50437,out))
;
return ((function (switch__2483__auto__,c__2597__auto___50437,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50429 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50429[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50429[(1)] = (1));

return statearr_50429;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50410){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50430){if((e50430 instanceof Object)){
var ex__2487__auto__ = e50430;
var statearr_50431_50448 = state_50410;
(statearr_50431_50448[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50410);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50449 = state_50410;
state_50410 = G__50449;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50410){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50437,out))
})();
var state__2599__auto__ = (function (){var statearr_50432 = f__2598__auto__.call(null);
(statearr_50432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50437);

return statearr_50432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50437,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async50457 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50457 = (function (f,ch,meta50458){
this.f = f;
this.ch = ch;
this.meta50458 = meta50458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50459,meta50458__$1){
var self__ = this;
var _50459__$1 = this;
return (new cljs.core.async.t_cljs$core$async50457(self__.f,self__.ch,meta50458__$1));
});


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50459){
var self__ = this;
var _50459__$1 = this;
return self__.meta50458;
});


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async50460 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50460 = (function (f,ch,meta50458,_,fn1,meta50461){
this.f = f;
this.ch = ch;
this.meta50458 = meta50458;
this._ = _;
this.fn1 = fn1;
this.meta50461 = meta50461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_50462,meta50461__$1){
var self__ = this;
var _50462__$1 = this;
return (new cljs.core.async.t_cljs$core$async50460(self__.f,self__.ch,self__.meta50458,self__._,self__.fn1,meta50461__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_50462){
var self__ = this;
var _50462__$1 = this;
return self__.meta50461;
});})(___$1))
;


cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async50460.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__50450_SHARP_){
return f1.call(null,(((p1__50450_SHARP_ == null))?null:self__.f.call(null,p1__50450_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async50460.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta50458","meta50458",465017699,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async50457","cljs.core.async/t_cljs$core$async50457",847003607,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta50461","meta50461",1961071573,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async50460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50460";

cljs.core.async.t_cljs$core$async50460.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async50460");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async50460 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async50460(f__$1,ch__$1,meta50458__$1,___$2,fn1__$1,meta50461){
return (new cljs.core.async.t_cljs$core$async50460(f__$1,ch__$1,meta50458__$1,___$2,fn1__$1,meta50461));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async50460(self__.f,self__.ch,self__.meta50458,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__11272__auto__ = ret;
if(cljs.core.truth_(and__11272__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__11272__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50457.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async50457.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta50458","meta50458",465017699,null)], null);
});

cljs.core.async.t_cljs$core$async50457.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50457.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50457";

cljs.core.async.t_cljs$core$async50457.cljs$lang$ctorPrWriter = (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async50457");
});

cljs.core.async.__GT_t_cljs$core$async50457 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async50457(f__$1,ch__$1,meta50458){
return (new cljs.core.async.t_cljs$core$async50457(f__$1,ch__$1,meta50458));
});

}

return (new cljs.core.async.t_cljs$core$async50457(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async50466 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50466 = (function (f,ch,meta50467){
this.f = f;
this.ch = ch;
this.meta50467 = meta50467;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50468,meta50467__$1){
var self__ = this;
var _50468__$1 = this;
return (new cljs.core.async.t_cljs$core$async50466(self__.f,self__.ch,meta50467__$1));
});


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50468){
var self__ = this;
var _50468__$1 = this;
return self__.meta50467;
});


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50466.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async50466.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta50467","meta50467",-1848794391,null)], null);
});

cljs.core.async.t_cljs$core$async50466.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50466.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50466";

cljs.core.async.t_cljs$core$async50466.cljs$lang$ctorPrWriter = (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async50466");
});

cljs.core.async.__GT_t_cljs$core$async50466 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async50466(f__$1,ch__$1,meta50467){
return (new cljs.core.async.t_cljs$core$async50466(f__$1,ch__$1,meta50467));
});

}

return (new cljs.core.async.t_cljs$core$async50466(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async50472 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50472 = (function (p,ch,meta50473){
this.p = p;
this.ch = ch;
this.meta50473 = meta50473;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50474,meta50473__$1){
var self__ = this;
var _50474__$1 = this;
return (new cljs.core.async.t_cljs$core$async50472(self__.p,self__.ch,meta50473__$1));
});


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50474){
var self__ = this;
var _50474__$1 = this;
return self__.meta50473;
});


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async50472.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async50472.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta50473","meta50473",521572506,null)], null);
});

cljs.core.async.t_cljs$core$async50472.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50472.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50472";

cljs.core.async.t_cljs$core$async50472.cljs$lang$ctorPrWriter = (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"cljs.core.async/t_cljs$core$async50472");
});

cljs.core.async.__GT_t_cljs$core$async50472 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async50472(p__$1,ch__$1,meta50473){
return (new cljs.core.async.t_cljs$core$async50472(p__$1,ch__$1,meta50473));
});

}

return (new cljs.core.async.t_cljs$core$async50472(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args50475 = [];
var len__11929__auto___50519 = arguments.length;
var i__11930__auto___50520 = (0);
while(true){
if((i__11930__auto___50520 < len__11929__auto___50519)){
args50475.push((arguments[i__11930__auto___50520]));

var G__50521 = (i__11930__auto___50520 + (1));
i__11930__auto___50520 = G__50521;
continue;
} else {
}
break;
}

var G__50477 = args50475.length;
switch (G__50477) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50475.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___50523 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50523,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50523,out){
return (function (state_50498){
var state_val_50499 = (state_50498[(1)]);
if((state_val_50499 === (7))){
var inst_50494 = (state_50498[(2)]);
var state_50498__$1 = state_50498;
var statearr_50500_50524 = state_50498__$1;
(statearr_50500_50524[(2)] = inst_50494);

(statearr_50500_50524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (1))){
var state_50498__$1 = state_50498;
var statearr_50501_50525 = state_50498__$1;
(statearr_50501_50525[(2)] = null);

(statearr_50501_50525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (4))){
var inst_50480 = (state_50498[(7)]);
var inst_50480__$1 = (state_50498[(2)]);
var inst_50481 = (inst_50480__$1 == null);
var state_50498__$1 = (function (){var statearr_50502 = state_50498;
(statearr_50502[(7)] = inst_50480__$1);

return statearr_50502;
})();
if(cljs.core.truth_(inst_50481)){
var statearr_50503_50526 = state_50498__$1;
(statearr_50503_50526[(1)] = (5));

} else {
var statearr_50504_50527 = state_50498__$1;
(statearr_50504_50527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (6))){
var inst_50480 = (state_50498[(7)]);
var inst_50485 = p.call(null,inst_50480);
var state_50498__$1 = state_50498;
if(cljs.core.truth_(inst_50485)){
var statearr_50505_50528 = state_50498__$1;
(statearr_50505_50528[(1)] = (8));

} else {
var statearr_50506_50529 = state_50498__$1;
(statearr_50506_50529[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (3))){
var inst_50496 = (state_50498[(2)]);
var state_50498__$1 = state_50498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50498__$1,inst_50496);
} else {
if((state_val_50499 === (2))){
var state_50498__$1 = state_50498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50498__$1,(4),ch);
} else {
if((state_val_50499 === (11))){
var inst_50488 = (state_50498[(2)]);
var state_50498__$1 = state_50498;
var statearr_50507_50530 = state_50498__$1;
(statearr_50507_50530[(2)] = inst_50488);

(statearr_50507_50530[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (9))){
var state_50498__$1 = state_50498;
var statearr_50508_50531 = state_50498__$1;
(statearr_50508_50531[(2)] = null);

(statearr_50508_50531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (5))){
var inst_50483 = cljs.core.async.close_BANG_.call(null,out);
var state_50498__$1 = state_50498;
var statearr_50509_50532 = state_50498__$1;
(statearr_50509_50532[(2)] = inst_50483);

(statearr_50509_50532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (10))){
var inst_50491 = (state_50498[(2)]);
var state_50498__$1 = (function (){var statearr_50510 = state_50498;
(statearr_50510[(8)] = inst_50491);

return statearr_50510;
})();
var statearr_50511_50533 = state_50498__$1;
(statearr_50511_50533[(2)] = null);

(statearr_50511_50533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50499 === (8))){
var inst_50480 = (state_50498[(7)]);
var state_50498__$1 = state_50498;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50498__$1,(11),out,inst_50480);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50523,out))
;
return ((function (switch__2483__auto__,c__2597__auto___50523,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50515 = [null,null,null,null,null,null,null,null,null];
(statearr_50515[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50515[(1)] = (1));

return statearr_50515;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50498){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50516){if((e50516 instanceof Object)){
var ex__2487__auto__ = e50516;
var statearr_50517_50534 = state_50498;
(statearr_50517_50534[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50498);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50516;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50535 = state_50498;
state_50498 = G__50535;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50498){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50523,out))
})();
var state__2599__auto__ = (function (){var statearr_50518 = f__2598__auto__.call(null);
(statearr_50518[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50523);

return statearr_50518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50523,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args50536 = [];
var len__11929__auto___50539 = arguments.length;
var i__11930__auto___50540 = (0);
while(true){
if((i__11930__auto___50540 < len__11929__auto___50539)){
args50536.push((arguments[i__11930__auto___50540]));

var G__50541 = (i__11930__auto___50540 + (1));
i__11930__auto___50540 = G__50541;
continue;
} else {
}
break;
}

var G__50538 = args50536.length;
switch (G__50538) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50536.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_50708){
var state_val_50709 = (state_50708[(1)]);
if((state_val_50709 === (7))){
var inst_50704 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
var statearr_50710_50751 = state_50708__$1;
(statearr_50710_50751[(2)] = inst_50704);

(statearr_50710_50751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (20))){
var inst_50674 = (state_50708[(7)]);
var inst_50685 = (state_50708[(2)]);
var inst_50686 = cljs.core.next.call(null,inst_50674);
var inst_50660 = inst_50686;
var inst_50661 = null;
var inst_50662 = (0);
var inst_50663 = (0);
var state_50708__$1 = (function (){var statearr_50711 = state_50708;
(statearr_50711[(8)] = inst_50661);

(statearr_50711[(9)] = inst_50660);

(statearr_50711[(10)] = inst_50662);

(statearr_50711[(11)] = inst_50663);

(statearr_50711[(12)] = inst_50685);

return statearr_50711;
})();
var statearr_50712_50752 = state_50708__$1;
(statearr_50712_50752[(2)] = null);

(statearr_50712_50752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (1))){
var state_50708__$1 = state_50708;
var statearr_50713_50753 = state_50708__$1;
(statearr_50713_50753[(2)] = null);

(statearr_50713_50753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (4))){
var inst_50649 = (state_50708[(13)]);
var inst_50649__$1 = (state_50708[(2)]);
var inst_50650 = (inst_50649__$1 == null);
var state_50708__$1 = (function (){var statearr_50714 = state_50708;
(statearr_50714[(13)] = inst_50649__$1);

return statearr_50714;
})();
if(cljs.core.truth_(inst_50650)){
var statearr_50715_50754 = state_50708__$1;
(statearr_50715_50754[(1)] = (5));

} else {
var statearr_50716_50755 = state_50708__$1;
(statearr_50716_50755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (15))){
var state_50708__$1 = state_50708;
var statearr_50720_50756 = state_50708__$1;
(statearr_50720_50756[(2)] = null);

(statearr_50720_50756[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (21))){
var state_50708__$1 = state_50708;
var statearr_50721_50757 = state_50708__$1;
(statearr_50721_50757[(2)] = null);

(statearr_50721_50757[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (13))){
var inst_50661 = (state_50708[(8)]);
var inst_50660 = (state_50708[(9)]);
var inst_50662 = (state_50708[(10)]);
var inst_50663 = (state_50708[(11)]);
var inst_50670 = (state_50708[(2)]);
var inst_50671 = (inst_50663 + (1));
var tmp50717 = inst_50661;
var tmp50718 = inst_50660;
var tmp50719 = inst_50662;
var inst_50660__$1 = tmp50718;
var inst_50661__$1 = tmp50717;
var inst_50662__$1 = tmp50719;
var inst_50663__$1 = inst_50671;
var state_50708__$1 = (function (){var statearr_50722 = state_50708;
(statearr_50722[(8)] = inst_50661__$1);

(statearr_50722[(9)] = inst_50660__$1);

(statearr_50722[(10)] = inst_50662__$1);

(statearr_50722[(11)] = inst_50663__$1);

(statearr_50722[(14)] = inst_50670);

return statearr_50722;
})();
var statearr_50723_50758 = state_50708__$1;
(statearr_50723_50758[(2)] = null);

(statearr_50723_50758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (22))){
var state_50708__$1 = state_50708;
var statearr_50724_50759 = state_50708__$1;
(statearr_50724_50759[(2)] = null);

(statearr_50724_50759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (6))){
var inst_50649 = (state_50708[(13)]);
var inst_50658 = f.call(null,inst_50649);
var inst_50659 = cljs.core.seq.call(null,inst_50658);
var inst_50660 = inst_50659;
var inst_50661 = null;
var inst_50662 = (0);
var inst_50663 = (0);
var state_50708__$1 = (function (){var statearr_50725 = state_50708;
(statearr_50725[(8)] = inst_50661);

(statearr_50725[(9)] = inst_50660);

(statearr_50725[(10)] = inst_50662);

(statearr_50725[(11)] = inst_50663);

return statearr_50725;
})();
var statearr_50726_50760 = state_50708__$1;
(statearr_50726_50760[(2)] = null);

(statearr_50726_50760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (17))){
var inst_50674 = (state_50708[(7)]);
var inst_50678 = cljs.core.chunk_first.call(null,inst_50674);
var inst_50679 = cljs.core.chunk_rest.call(null,inst_50674);
var inst_50680 = cljs.core.count.call(null,inst_50678);
var inst_50660 = inst_50679;
var inst_50661 = inst_50678;
var inst_50662 = inst_50680;
var inst_50663 = (0);
var state_50708__$1 = (function (){var statearr_50727 = state_50708;
(statearr_50727[(8)] = inst_50661);

(statearr_50727[(9)] = inst_50660);

(statearr_50727[(10)] = inst_50662);

(statearr_50727[(11)] = inst_50663);

return statearr_50727;
})();
var statearr_50728_50761 = state_50708__$1;
(statearr_50728_50761[(2)] = null);

(statearr_50728_50761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (3))){
var inst_50706 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50708__$1,inst_50706);
} else {
if((state_val_50709 === (12))){
var inst_50694 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
var statearr_50729_50762 = state_50708__$1;
(statearr_50729_50762[(2)] = inst_50694);

(statearr_50729_50762[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (2))){
var state_50708__$1 = state_50708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50708__$1,(4),in$);
} else {
if((state_val_50709 === (23))){
var inst_50702 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
var statearr_50730_50763 = state_50708__$1;
(statearr_50730_50763[(2)] = inst_50702);

(statearr_50730_50763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (19))){
var inst_50689 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
var statearr_50731_50764 = state_50708__$1;
(statearr_50731_50764[(2)] = inst_50689);

(statearr_50731_50764[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (11))){
var inst_50674 = (state_50708[(7)]);
var inst_50660 = (state_50708[(9)]);
var inst_50674__$1 = cljs.core.seq.call(null,inst_50660);
var state_50708__$1 = (function (){var statearr_50732 = state_50708;
(statearr_50732[(7)] = inst_50674__$1);

return statearr_50732;
})();
if(inst_50674__$1){
var statearr_50733_50765 = state_50708__$1;
(statearr_50733_50765[(1)] = (14));

} else {
var statearr_50734_50766 = state_50708__$1;
(statearr_50734_50766[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (9))){
var inst_50696 = (state_50708[(2)]);
var inst_50697 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_50708__$1 = (function (){var statearr_50735 = state_50708;
(statearr_50735[(15)] = inst_50696);

return statearr_50735;
})();
if(cljs.core.truth_(inst_50697)){
var statearr_50736_50767 = state_50708__$1;
(statearr_50736_50767[(1)] = (21));

} else {
var statearr_50737_50768 = state_50708__$1;
(statearr_50737_50768[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (5))){
var inst_50652 = cljs.core.async.close_BANG_.call(null,out);
var state_50708__$1 = state_50708;
var statearr_50738_50769 = state_50708__$1;
(statearr_50738_50769[(2)] = inst_50652);

(statearr_50738_50769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (14))){
var inst_50674 = (state_50708[(7)]);
var inst_50676 = cljs.core.chunked_seq_QMARK_.call(null,inst_50674);
var state_50708__$1 = state_50708;
if(inst_50676){
var statearr_50739_50770 = state_50708__$1;
(statearr_50739_50770[(1)] = (17));

} else {
var statearr_50740_50771 = state_50708__$1;
(statearr_50740_50771[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (16))){
var inst_50692 = (state_50708[(2)]);
var state_50708__$1 = state_50708;
var statearr_50741_50772 = state_50708__$1;
(statearr_50741_50772[(2)] = inst_50692);

(statearr_50741_50772[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50709 === (10))){
var inst_50661 = (state_50708[(8)]);
var inst_50663 = (state_50708[(11)]);
var inst_50668 = cljs.core._nth.call(null,inst_50661,inst_50663);
var state_50708__$1 = state_50708;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50708__$1,(13),out,inst_50668);
} else {
if((state_val_50709 === (18))){
var inst_50674 = (state_50708[(7)]);
var inst_50683 = cljs.core.first.call(null,inst_50674);
var state_50708__$1 = state_50708;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50708__$1,(20),out,inst_50683);
} else {
if((state_val_50709 === (8))){
var inst_50662 = (state_50708[(10)]);
var inst_50663 = (state_50708[(11)]);
var inst_50665 = (inst_50663 < inst_50662);
var inst_50666 = inst_50665;
var state_50708__$1 = state_50708;
if(cljs.core.truth_(inst_50666)){
var statearr_50742_50773 = state_50708__$1;
(statearr_50742_50773[(1)] = (10));

} else {
var statearr_50743_50774 = state_50708__$1;
(statearr_50743_50774[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____0 = (function (){
var statearr_50747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50747[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__);

(statearr_50747[(1)] = (1));

return statearr_50747;
});
var cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____1 = (function (state_50708){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50748){if((e50748 instanceof Object)){
var ex__2487__auto__ = e50748;
var statearr_50749_50775 = state_50708;
(statearr_50749_50775[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50708);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50748;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50776 = state_50708;
state_50708 = G__50776;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__ = function(state_50708){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____1.call(this,state_50708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__2484__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_50750 = f__2598__auto__.call(null);
(statearr_50750[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_50750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args50777 = [];
var len__11929__auto___50780 = arguments.length;
var i__11930__auto___50781 = (0);
while(true){
if((i__11930__auto___50781 < len__11929__auto___50780)){
args50777.push((arguments[i__11930__auto___50781]));

var G__50782 = (i__11930__auto___50781 + (1));
i__11930__auto___50781 = G__50782;
continue;
} else {
}
break;
}

var G__50779 = args50777.length;
switch (G__50779) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50777.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args50784 = [];
var len__11929__auto___50787 = arguments.length;
var i__11930__auto___50788 = (0);
while(true){
if((i__11930__auto___50788 < len__11929__auto___50787)){
args50784.push((arguments[i__11930__auto___50788]));

var G__50789 = (i__11930__auto___50788 + (1));
i__11930__auto___50788 = G__50789;
continue;
} else {
}
break;
}

var G__50786 = args50784.length;
switch (G__50786) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50784.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args50791 = [];
var len__11929__auto___50842 = arguments.length;
var i__11930__auto___50843 = (0);
while(true){
if((i__11930__auto___50843 < len__11929__auto___50842)){
args50791.push((arguments[i__11930__auto___50843]));

var G__50844 = (i__11930__auto___50843 + (1));
i__11930__auto___50843 = G__50844;
continue;
} else {
}
break;
}

var G__50793 = args50791.length;
switch (G__50793) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50791.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___50846 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50846,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50846,out){
return (function (state_50817){
var state_val_50818 = (state_50817[(1)]);
if((state_val_50818 === (7))){
var inst_50812 = (state_50817[(2)]);
var state_50817__$1 = state_50817;
var statearr_50819_50847 = state_50817__$1;
(statearr_50819_50847[(2)] = inst_50812);

(statearr_50819_50847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (1))){
var inst_50794 = null;
var state_50817__$1 = (function (){var statearr_50820 = state_50817;
(statearr_50820[(7)] = inst_50794);

return statearr_50820;
})();
var statearr_50821_50848 = state_50817__$1;
(statearr_50821_50848[(2)] = null);

(statearr_50821_50848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (4))){
var inst_50797 = (state_50817[(8)]);
var inst_50797__$1 = (state_50817[(2)]);
var inst_50798 = (inst_50797__$1 == null);
var inst_50799 = cljs.core.not.call(null,inst_50798);
var state_50817__$1 = (function (){var statearr_50822 = state_50817;
(statearr_50822[(8)] = inst_50797__$1);

return statearr_50822;
})();
if(inst_50799){
var statearr_50823_50849 = state_50817__$1;
(statearr_50823_50849[(1)] = (5));

} else {
var statearr_50824_50850 = state_50817__$1;
(statearr_50824_50850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (6))){
var state_50817__$1 = state_50817;
var statearr_50825_50851 = state_50817__$1;
(statearr_50825_50851[(2)] = null);

(statearr_50825_50851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (3))){
var inst_50814 = (state_50817[(2)]);
var inst_50815 = cljs.core.async.close_BANG_.call(null,out);
var state_50817__$1 = (function (){var statearr_50826 = state_50817;
(statearr_50826[(9)] = inst_50814);

return statearr_50826;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50817__$1,inst_50815);
} else {
if((state_val_50818 === (2))){
var state_50817__$1 = state_50817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50817__$1,(4),ch);
} else {
if((state_val_50818 === (11))){
var inst_50797 = (state_50817[(8)]);
var inst_50806 = (state_50817[(2)]);
var inst_50794 = inst_50797;
var state_50817__$1 = (function (){var statearr_50827 = state_50817;
(statearr_50827[(10)] = inst_50806);

(statearr_50827[(7)] = inst_50794);

return statearr_50827;
})();
var statearr_50828_50852 = state_50817__$1;
(statearr_50828_50852[(2)] = null);

(statearr_50828_50852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (9))){
var inst_50797 = (state_50817[(8)]);
var state_50817__$1 = state_50817;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50817__$1,(11),out,inst_50797);
} else {
if((state_val_50818 === (5))){
var inst_50797 = (state_50817[(8)]);
var inst_50794 = (state_50817[(7)]);
var inst_50801 = cljs.core._EQ_.call(null,inst_50797,inst_50794);
var state_50817__$1 = state_50817;
if(inst_50801){
var statearr_50830_50853 = state_50817__$1;
(statearr_50830_50853[(1)] = (8));

} else {
var statearr_50831_50854 = state_50817__$1;
(statearr_50831_50854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (10))){
var inst_50809 = (state_50817[(2)]);
var state_50817__$1 = state_50817;
var statearr_50832_50855 = state_50817__$1;
(statearr_50832_50855[(2)] = inst_50809);

(statearr_50832_50855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50818 === (8))){
var inst_50794 = (state_50817[(7)]);
var tmp50829 = inst_50794;
var inst_50794__$1 = tmp50829;
var state_50817__$1 = (function (){var statearr_50833 = state_50817;
(statearr_50833[(7)] = inst_50794__$1);

return statearr_50833;
})();
var statearr_50834_50856 = state_50817__$1;
(statearr_50834_50856[(2)] = null);

(statearr_50834_50856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50846,out))
;
return ((function (switch__2483__auto__,c__2597__auto___50846,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50838 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50838[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50838[(1)] = (1));

return statearr_50838;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50817){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50839){if((e50839 instanceof Object)){
var ex__2487__auto__ = e50839;
var statearr_50840_50857 = state_50817;
(statearr_50840_50857[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50817);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50858 = state_50817;
state_50817 = G__50858;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50817){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50846,out))
})();
var state__2599__auto__ = (function (){var statearr_50841 = f__2598__auto__.call(null);
(statearr_50841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50846);

return statearr_50841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50846,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args50859 = [];
var len__11929__auto___50929 = arguments.length;
var i__11930__auto___50930 = (0);
while(true){
if((i__11930__auto___50930 < len__11929__auto___50929)){
args50859.push((arguments[i__11930__auto___50930]));

var G__50931 = (i__11930__auto___50930 + (1));
i__11930__auto___50930 = G__50931;
continue;
} else {
}
break;
}

var G__50861 = args50859.length;
switch (G__50861) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50859.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___50933 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___50933,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___50933,out){
return (function (state_50899){
var state_val_50900 = (state_50899[(1)]);
if((state_val_50900 === (7))){
var inst_50895 = (state_50899[(2)]);
var state_50899__$1 = state_50899;
var statearr_50901_50934 = state_50899__$1;
(statearr_50901_50934[(2)] = inst_50895);

(statearr_50901_50934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (1))){
var inst_50862 = (new Array(n));
var inst_50863 = inst_50862;
var inst_50864 = (0);
var state_50899__$1 = (function (){var statearr_50902 = state_50899;
(statearr_50902[(7)] = inst_50863);

(statearr_50902[(8)] = inst_50864);

return statearr_50902;
})();
var statearr_50903_50935 = state_50899__$1;
(statearr_50903_50935[(2)] = null);

(statearr_50903_50935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (4))){
var inst_50867 = (state_50899[(9)]);
var inst_50867__$1 = (state_50899[(2)]);
var inst_50868 = (inst_50867__$1 == null);
var inst_50869 = cljs.core.not.call(null,inst_50868);
var state_50899__$1 = (function (){var statearr_50904 = state_50899;
(statearr_50904[(9)] = inst_50867__$1);

return statearr_50904;
})();
if(inst_50869){
var statearr_50905_50936 = state_50899__$1;
(statearr_50905_50936[(1)] = (5));

} else {
var statearr_50906_50937 = state_50899__$1;
(statearr_50906_50937[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (15))){
var inst_50889 = (state_50899[(2)]);
var state_50899__$1 = state_50899;
var statearr_50907_50938 = state_50899__$1;
(statearr_50907_50938[(2)] = inst_50889);

(statearr_50907_50938[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (13))){
var state_50899__$1 = state_50899;
var statearr_50908_50939 = state_50899__$1;
(statearr_50908_50939[(2)] = null);

(statearr_50908_50939[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (6))){
var inst_50864 = (state_50899[(8)]);
var inst_50885 = (inst_50864 > (0));
var state_50899__$1 = state_50899;
if(cljs.core.truth_(inst_50885)){
var statearr_50909_50940 = state_50899__$1;
(statearr_50909_50940[(1)] = (12));

} else {
var statearr_50910_50941 = state_50899__$1;
(statearr_50910_50941[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (3))){
var inst_50897 = (state_50899[(2)]);
var state_50899__$1 = state_50899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50899__$1,inst_50897);
} else {
if((state_val_50900 === (12))){
var inst_50863 = (state_50899[(7)]);
var inst_50887 = cljs.core.vec.call(null,inst_50863);
var state_50899__$1 = state_50899;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50899__$1,(15),out,inst_50887);
} else {
if((state_val_50900 === (2))){
var state_50899__$1 = state_50899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50899__$1,(4),ch);
} else {
if((state_val_50900 === (11))){
var inst_50879 = (state_50899[(2)]);
var inst_50880 = (new Array(n));
var inst_50863 = inst_50880;
var inst_50864 = (0);
var state_50899__$1 = (function (){var statearr_50911 = state_50899;
(statearr_50911[(10)] = inst_50879);

(statearr_50911[(7)] = inst_50863);

(statearr_50911[(8)] = inst_50864);

return statearr_50911;
})();
var statearr_50912_50942 = state_50899__$1;
(statearr_50912_50942[(2)] = null);

(statearr_50912_50942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (9))){
var inst_50863 = (state_50899[(7)]);
var inst_50877 = cljs.core.vec.call(null,inst_50863);
var state_50899__$1 = state_50899;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50899__$1,(11),out,inst_50877);
} else {
if((state_val_50900 === (5))){
var inst_50872 = (state_50899[(11)]);
var inst_50863 = (state_50899[(7)]);
var inst_50864 = (state_50899[(8)]);
var inst_50867 = (state_50899[(9)]);
var inst_50871 = (inst_50863[inst_50864] = inst_50867);
var inst_50872__$1 = (inst_50864 + (1));
var inst_50873 = (inst_50872__$1 < n);
var state_50899__$1 = (function (){var statearr_50913 = state_50899;
(statearr_50913[(11)] = inst_50872__$1);

(statearr_50913[(12)] = inst_50871);

return statearr_50913;
})();
if(cljs.core.truth_(inst_50873)){
var statearr_50914_50943 = state_50899__$1;
(statearr_50914_50943[(1)] = (8));

} else {
var statearr_50915_50944 = state_50899__$1;
(statearr_50915_50944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (14))){
var inst_50892 = (state_50899[(2)]);
var inst_50893 = cljs.core.async.close_BANG_.call(null,out);
var state_50899__$1 = (function (){var statearr_50917 = state_50899;
(statearr_50917[(13)] = inst_50892);

return statearr_50917;
})();
var statearr_50918_50945 = state_50899__$1;
(statearr_50918_50945[(2)] = inst_50893);

(statearr_50918_50945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (10))){
var inst_50883 = (state_50899[(2)]);
var state_50899__$1 = state_50899;
var statearr_50919_50946 = state_50899__$1;
(statearr_50919_50946[(2)] = inst_50883);

(statearr_50919_50946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50900 === (8))){
var inst_50872 = (state_50899[(11)]);
var inst_50863 = (state_50899[(7)]);
var tmp50916 = inst_50863;
var inst_50863__$1 = tmp50916;
var inst_50864 = inst_50872;
var state_50899__$1 = (function (){var statearr_50920 = state_50899;
(statearr_50920[(7)] = inst_50863__$1);

(statearr_50920[(8)] = inst_50864);

return statearr_50920;
})();
var statearr_50921_50947 = state_50899__$1;
(statearr_50921_50947[(2)] = null);

(statearr_50921_50947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___50933,out))
;
return ((function (switch__2483__auto__,c__2597__auto___50933,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_50925 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50925[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_50925[(1)] = (1));

return statearr_50925;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50899){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e50926){if((e50926 instanceof Object)){
var ex__2487__auto__ = e50926;
var statearr_50927_50948 = state_50899;
(statearr_50927_50948[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50899);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50949 = state_50899;
state_50899 = G__50949;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50899){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___50933,out))
})();
var state__2599__auto__ = (function (){var statearr_50928 = f__2598__auto__.call(null);
(statearr_50928[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___50933);

return statearr_50928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___50933,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args50950 = [];
var len__11929__auto___51024 = arguments.length;
var i__11930__auto___51025 = (0);
while(true){
if((i__11930__auto___51025 < len__11929__auto___51024)){
args50950.push((arguments[i__11930__auto___51025]));

var G__51026 = (i__11930__auto___51025 + (1));
i__11930__auto___51025 = G__51026;
continue;
} else {
}
break;
}

var G__50952 = args50950.length;
switch (G__50952) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50950.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2597__auto___51028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___51028,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___51028,out){
return (function (state_50994){
var state_val_50995 = (state_50994[(1)]);
if((state_val_50995 === (7))){
var inst_50990 = (state_50994[(2)]);
var state_50994__$1 = state_50994;
var statearr_50996_51029 = state_50994__$1;
(statearr_50996_51029[(2)] = inst_50990);

(statearr_50996_51029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (1))){
var inst_50953 = [];
var inst_50954 = inst_50953;
var inst_50955 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_50994__$1 = (function (){var statearr_50997 = state_50994;
(statearr_50997[(7)] = inst_50955);

(statearr_50997[(8)] = inst_50954);

return statearr_50997;
})();
var statearr_50998_51030 = state_50994__$1;
(statearr_50998_51030[(2)] = null);

(statearr_50998_51030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (4))){
var inst_50958 = (state_50994[(9)]);
var inst_50958__$1 = (state_50994[(2)]);
var inst_50959 = (inst_50958__$1 == null);
var inst_50960 = cljs.core.not.call(null,inst_50959);
var state_50994__$1 = (function (){var statearr_50999 = state_50994;
(statearr_50999[(9)] = inst_50958__$1);

return statearr_50999;
})();
if(inst_50960){
var statearr_51000_51031 = state_50994__$1;
(statearr_51000_51031[(1)] = (5));

} else {
var statearr_51001_51032 = state_50994__$1;
(statearr_51001_51032[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (15))){
var inst_50984 = (state_50994[(2)]);
var state_50994__$1 = state_50994;
var statearr_51002_51033 = state_50994__$1;
(statearr_51002_51033[(2)] = inst_50984);

(statearr_51002_51033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (13))){
var state_50994__$1 = state_50994;
var statearr_51003_51034 = state_50994__$1;
(statearr_51003_51034[(2)] = null);

(statearr_51003_51034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (6))){
var inst_50954 = (state_50994[(8)]);
var inst_50979 = inst_50954.length;
var inst_50980 = (inst_50979 > (0));
var state_50994__$1 = state_50994;
if(cljs.core.truth_(inst_50980)){
var statearr_51004_51035 = state_50994__$1;
(statearr_51004_51035[(1)] = (12));

} else {
var statearr_51005_51036 = state_50994__$1;
(statearr_51005_51036[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (3))){
var inst_50992 = (state_50994[(2)]);
var state_50994__$1 = state_50994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50994__$1,inst_50992);
} else {
if((state_val_50995 === (12))){
var inst_50954 = (state_50994[(8)]);
var inst_50982 = cljs.core.vec.call(null,inst_50954);
var state_50994__$1 = state_50994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50994__$1,(15),out,inst_50982);
} else {
if((state_val_50995 === (2))){
var state_50994__$1 = state_50994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50994__$1,(4),ch);
} else {
if((state_val_50995 === (11))){
var inst_50958 = (state_50994[(9)]);
var inst_50962 = (state_50994[(10)]);
var inst_50972 = (state_50994[(2)]);
var inst_50973 = [];
var inst_50974 = inst_50973.push(inst_50958);
var inst_50954 = inst_50973;
var inst_50955 = inst_50962;
var state_50994__$1 = (function (){var statearr_51006 = state_50994;
(statearr_51006[(11)] = inst_50972);

(statearr_51006[(12)] = inst_50974);

(statearr_51006[(7)] = inst_50955);

(statearr_51006[(8)] = inst_50954);

return statearr_51006;
})();
var statearr_51007_51037 = state_50994__$1;
(statearr_51007_51037[(2)] = null);

(statearr_51007_51037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (9))){
var inst_50954 = (state_50994[(8)]);
var inst_50970 = cljs.core.vec.call(null,inst_50954);
var state_50994__$1 = state_50994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50994__$1,(11),out,inst_50970);
} else {
if((state_val_50995 === (5))){
var inst_50958 = (state_50994[(9)]);
var inst_50962 = (state_50994[(10)]);
var inst_50955 = (state_50994[(7)]);
var inst_50962__$1 = f.call(null,inst_50958);
var inst_50963 = cljs.core._EQ_.call(null,inst_50962__$1,inst_50955);
var inst_50964 = cljs.core.keyword_identical_QMARK_.call(null,inst_50955,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_50965 = (inst_50963) || (inst_50964);
var state_50994__$1 = (function (){var statearr_51008 = state_50994;
(statearr_51008[(10)] = inst_50962__$1);

return statearr_51008;
})();
if(cljs.core.truth_(inst_50965)){
var statearr_51009_51038 = state_50994__$1;
(statearr_51009_51038[(1)] = (8));

} else {
var statearr_51010_51039 = state_50994__$1;
(statearr_51010_51039[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (14))){
var inst_50987 = (state_50994[(2)]);
var inst_50988 = cljs.core.async.close_BANG_.call(null,out);
var state_50994__$1 = (function (){var statearr_51012 = state_50994;
(statearr_51012[(13)] = inst_50987);

return statearr_51012;
})();
var statearr_51013_51040 = state_50994__$1;
(statearr_51013_51040[(2)] = inst_50988);

(statearr_51013_51040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (10))){
var inst_50977 = (state_50994[(2)]);
var state_50994__$1 = state_50994;
var statearr_51014_51041 = state_50994__$1;
(statearr_51014_51041[(2)] = inst_50977);

(statearr_51014_51041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50995 === (8))){
var inst_50958 = (state_50994[(9)]);
var inst_50962 = (state_50994[(10)]);
var inst_50954 = (state_50994[(8)]);
var inst_50967 = inst_50954.push(inst_50958);
var tmp51011 = inst_50954;
var inst_50954__$1 = tmp51011;
var inst_50955 = inst_50962;
var state_50994__$1 = (function (){var statearr_51015 = state_50994;
(statearr_51015[(14)] = inst_50967);

(statearr_51015[(7)] = inst_50955);

(statearr_51015[(8)] = inst_50954__$1);

return statearr_51015;
})();
var statearr_51016_51042 = state_50994__$1;
(statearr_51016_51042[(2)] = null);

(statearr_51016_51042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___51028,out))
;
return ((function (switch__2483__auto__,c__2597__auto___51028,out){
return (function() {
var cljs$core$async$state_machine__2484__auto__ = null;
var cljs$core$async$state_machine__2484__auto____0 = (function (){
var statearr_51020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51020[(0)] = cljs$core$async$state_machine__2484__auto__);

(statearr_51020[(1)] = (1));

return statearr_51020;
});
var cljs$core$async$state_machine__2484__auto____1 = (function (state_50994){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_50994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e51021){if((e51021 instanceof Object)){
var ex__2487__auto__ = e51021;
var statearr_51022_51043 = state_50994;
(statearr_51022_51043[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50994);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51021;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51044 = state_50994;
state_50994 = G__51044;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
cljs$core$async$state_machine__2484__auto__ = function(state_50994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2484__auto____1.call(this,state_50994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2484__auto____0;
cljs$core$async$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2484__auto____1;
return cljs$core$async$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___51028,out))
})();
var state__2599__auto__ = (function (){var statearr_51023 = f__2598__auto__.call(null);
(statearr_51023[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___51028);

return statearr_51023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___51028,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1486495664655