// Compiled by ClojureScript 1.9.456 {}
goog.provide('devtools.core');
goog.require('cljs.core');
goog.require('devtools.prefs');
goog.require('devtools.sanity_hints');
goog.require('devtools.custom_formatters');
goog.require('devtools.dirac');
goog.require('devtools.util');
goog.require('goog.userAgent');
devtools.core.known_features = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779),new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327),new cljs.core.Keyword(null,"dirac","dirac",1785994033),new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649),new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858),new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)], null);
devtools.core.missing_feature_warning = (function devtools$core$missing_feature_warning(feature,known_features){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No such feature '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(feature),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' is currently available in cljs-devtools. "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("List of supported features:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.keys.call(null,known_features))].join('');
});
devtools.core.warn_feature_not_available = (function devtools$core$warn_feature_not_available(feature){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Feature '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,feature)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' cannot be installed. Unsupported browser "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.userAgent.getUserAgentString()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".")].join(''));
});
devtools.core.install_BANG_ = (function devtools$core$install_BANG_(){
devtools.util.display_banner.call(null,"Installing cljs-devtools:",devtools.core.known_features);

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327)))){
if(cljs.core.truth_(devtools.custom_formatters.available_QMARK_.call(null))){
devtools.custom_formatters.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)))){
if(cljs.core.truth_(devtools.sanity_hints.available_QMARK_.call(null))){
devtools.sanity_hints.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649)))){
if(cljs.core.truth_(devtools.dirac.available_QMARK_.call(null))){
return devtools.dirac.install_BANG_.call(null);
} else {
return devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"dirac","dirac",1785994033));
}
} else {
return null;
}
});
devtools.core.uninstall_BANG_ = (function devtools$core$uninstall_BANG_(){
devtools.custom_formatters.uninstall_BANG_.call(null);

devtools.sanity_hints.uninstall_BANG_.call(null);

return devtools.dirac.uninstall_BANG_.call(null);
});
devtools.core.set_prefs_BANG_ = (function devtools$core$set_prefs_BANG_(new_prefs){
return devtools.prefs.set_prefs_BANG_.call(null,new_prefs);
});
devtools.core.get_prefs = (function devtools$core$get_prefs(){
return devtools.prefs.get_prefs.call(null);
});
devtools.core.set_pref_BANG_ = (function devtools$core$set_pref_BANG_(pref,val){
return devtools.prefs.set_pref_BANG_.call(null,pref,val);
});
devtools.core.set_single_feature_BANG_ = (function devtools$core$set_single_feature_BANG_(feature,val){
var temp__6751__auto__ = feature.call(null,devtools.core.known_features);
if(cljs.core.truth_(temp__6751__auto__)){
var feature_installation_key = temp__6751__auto__;
return devtools.core.set_pref_BANG_.call(null,feature_installation_key,val);
} else {
return console.warn(devtools.core.missing_feature_warning.call(null,feature,devtools.core.known_features));
}
});
devtools.core.enable_single_feature_BANG_ = (function devtools$core$enable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,true);
});
devtools.core.disable_single_feature_BANG_ = (function devtools$core$disable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,false);
});
devtools.core.enable_feature_BANG_ = (function devtools$core$enable_feature_BANG_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___67334 = arguments.length;
var i__11930__auto___67335 = (0);
while(true){
if((i__11930__auto___67335 < len__11929__auto___67334)){
args__11932__auto__.push((arguments[i__11930__auto___67335]));

var G__67336 = (i__11930__auto___67335 + (1));
i__11930__auto___67335 = G__67336;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67330 = cljs.core.seq.call(null,features);
var chunk__67331 = null;
var count__67332 = (0);
var i__67333 = (0);
while(true){
if((i__67333 < count__67332)){
var feature = cljs.core._nth.call(null,chunk__67331,i__67333);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67337 = seq__67330;
var G__67338 = chunk__67331;
var G__67339 = count__67332;
var G__67340 = (i__67333 + (1));
seq__67330 = G__67337;
chunk__67331 = G__67338;
count__67332 = G__67339;
i__67333 = G__67340;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67330);
if(temp__6753__auto__){
var seq__67330__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67330__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__67330__$1);
var G__67341 = cljs.core.chunk_rest.call(null,seq__67330__$1);
var G__67342 = c__11759__auto__;
var G__67343 = cljs.core.count.call(null,c__11759__auto__);
var G__67344 = (0);
seq__67330 = G__67341;
chunk__67331 = G__67342;
count__67332 = G__67343;
i__67333 = G__67344;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67330__$1);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67345 = cljs.core.next.call(null,seq__67330__$1);
var G__67346 = null;
var G__67347 = (0);
var G__67348 = (0);
seq__67330 = G__67345;
chunk__67331 = G__67346;
count__67332 = G__67347;
i__67333 = G__67348;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.enable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.enable_feature_BANG_.cljs$lang$applyTo = (function (seq67329){
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67329));
});

devtools.core.disable_feature_BANG_ = (function devtools$core$disable_feature_BANG_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___67354 = arguments.length;
var i__11930__auto___67355 = (0);
while(true){
if((i__11930__auto___67355 < len__11929__auto___67354)){
args__11932__auto__.push((arguments[i__11930__auto___67355]));

var G__67356 = (i__11930__auto___67355 + (1));
i__11930__auto___67355 = G__67356;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67350 = cljs.core.seq.call(null,features);
var chunk__67351 = null;
var count__67352 = (0);
var i__67353 = (0);
while(true){
if((i__67353 < count__67352)){
var feature = cljs.core._nth.call(null,chunk__67351,i__67353);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67357 = seq__67350;
var G__67358 = chunk__67351;
var G__67359 = count__67352;
var G__67360 = (i__67353 + (1));
seq__67350 = G__67357;
chunk__67351 = G__67358;
count__67352 = G__67359;
i__67353 = G__67360;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67350);
if(temp__6753__auto__){
var seq__67350__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67350__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__67350__$1);
var G__67361 = cljs.core.chunk_rest.call(null,seq__67350__$1);
var G__67362 = c__11759__auto__;
var G__67363 = cljs.core.count.call(null,c__11759__auto__);
var G__67364 = (0);
seq__67350 = G__67361;
chunk__67351 = G__67362;
count__67352 = G__67363;
i__67353 = G__67364;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67350__$1);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67365 = cljs.core.next.call(null,seq__67350__$1);
var G__67366 = null;
var G__67367 = (0);
var G__67368 = (0);
seq__67350 = G__67365;
chunk__67351 = G__67366;
count__67352 = G__67367;
i__67353 = G__67368;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.disable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.disable_feature_BANG_.cljs$lang$applyTo = (function (seq67349){
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67349));
});

devtools.core.single_feature_available_QMARK_ = (function devtools$core$single_feature_available_QMARK_(feature){
var G__67370 = (((feature instanceof cljs.core.Keyword))?feature.fqn:null);
switch (G__67370) {
case "custom-formatters":
return devtools.custom_formatters.available_QMARK_.call(null);

break;
case "dirac":
return devtools.dirac.available_QMARK_.call(null);

break;
case "sanity-hints":
return devtools.sanity_hints.available_QMARK_.call(null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(feature)].join('')));

}
});
devtools.core.feature_available_QMARK_ = (function devtools$core$feature_available_QMARK_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___67373 = arguments.length;
var i__11930__auto___67374 = (0);
while(true){
if((i__11930__auto___67374 < len__11929__auto___67373)){
args__11932__auto__.push((arguments[i__11930__auto___67374]));

var G__67375 = (i__11930__auto___67374 + (1));
i__11930__auto___67374 = G__67375;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
return cljs.core.every_QMARK_.call(null,devtools.core.single_feature_available_QMARK_,features);
});

devtools.core.feature_available_QMARK_.cljs$lang$maxFixedArity = (0);

devtools.core.feature_available_QMARK_.cljs$lang$applyTo = (function (seq67372){
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67372));
});

devtools.core.enable_BANG_ = (function devtools$core$enable_BANG_(){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("devtools.core/enable! was deprecated "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("and has no effect in current version of cljs-devtools "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=> remove the call")].join(''));
});
devtools.core.disable_BANG_ = (function devtools$core$disable_BANG_(){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("devtools.core/disable! was deprecated "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("and has no effect in current version of cljs-devtools "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=> remove the call")].join(''));
});

//# sourceMappingURL=core.js.map?rel=1486495687817