// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args55407 = [];
var len__11929__auto___55410 = arguments.length;
var i__11930__auto___55411 = (0);
while(true){
if((i__11930__auto___55411 < len__11929__auto___55410)){
args55407.push((arguments[i__11930__auto___55411]));

var G__55412 = (i__11930__auto___55411 + (1));
i__11930__auto___55411 = G__55412;
continue;
} else {
}
break;
}

var G__55409 = args55407.length;
switch (G__55409) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args55407.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__11932__auto__ = [];
var len__11929__auto___55415 = arguments.length;
var i__11930__auto___55416 = (0);
while(true){
if((i__11930__auto___55416 < len__11929__auto___55415)){
args__11932__auto__.push((arguments[i__11930__auto___55416]));

var G__55417 = (i__11930__auto___55416 + (1));
i__11930__auto___55416 = G__55417;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq55414){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55414));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__11932__auto__ = [];
var len__11929__auto___55419 = arguments.length;
var i__11930__auto___55420 = (0);
while(true){
if((i__11930__auto___55420 < len__11929__auto___55419)){
args__11932__auto__.push((arguments[i__11930__auto___55420]));

var G__55421 = (i__11930__auto___55420 + (1));
i__11930__auto___55420 = G__55421;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq55418){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55418));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__55422){
var map__55425 = p__55422;
var map__55425__$1 = ((((!((map__55425 == null)))?((((map__55425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55425.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55425):map__55425);
var message = cljs.core.get.call(null,map__55425__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__55425__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__11280__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__11272__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__11272__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__11272__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__2597__auto___55587 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___55587,ch){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___55587,ch){
return (function (state_55556){
var state_val_55557 = (state_55556[(1)]);
if((state_val_55557 === (7))){
var inst_55552 = (state_55556[(2)]);
var state_55556__$1 = state_55556;
var statearr_55558_55588 = state_55556__$1;
(statearr_55558_55588[(2)] = inst_55552);

(statearr_55558_55588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (1))){
var state_55556__$1 = state_55556;
var statearr_55559_55589 = state_55556__$1;
(statearr_55559_55589[(2)] = null);

(statearr_55559_55589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (4))){
var inst_55509 = (state_55556[(7)]);
var inst_55509__$1 = (state_55556[(2)]);
var state_55556__$1 = (function (){var statearr_55560 = state_55556;
(statearr_55560[(7)] = inst_55509__$1);

return statearr_55560;
})();
if(cljs.core.truth_(inst_55509__$1)){
var statearr_55561_55590 = state_55556__$1;
(statearr_55561_55590[(1)] = (5));

} else {
var statearr_55562_55591 = state_55556__$1;
(statearr_55562_55591[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (15))){
var inst_55516 = (state_55556[(8)]);
var inst_55531 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_55516);
var inst_55532 = cljs.core.first.call(null,inst_55531);
var inst_55533 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_55532);
var inst_55534 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55533)].join('');
var inst_55535 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_55534);
var state_55556__$1 = state_55556;
var statearr_55563_55592 = state_55556__$1;
(statearr_55563_55592[(2)] = inst_55535);

(statearr_55563_55592[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (13))){
var inst_55540 = (state_55556[(2)]);
var state_55556__$1 = state_55556;
var statearr_55564_55593 = state_55556__$1;
(statearr_55564_55593[(2)] = inst_55540);

(statearr_55564_55593[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (6))){
var state_55556__$1 = state_55556;
var statearr_55565_55594 = state_55556__$1;
(statearr_55565_55594[(2)] = null);

(statearr_55565_55594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (17))){
var inst_55538 = (state_55556[(2)]);
var state_55556__$1 = state_55556;
var statearr_55566_55595 = state_55556__$1;
(statearr_55566_55595[(2)] = inst_55538);

(statearr_55566_55595[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (3))){
var inst_55554 = (state_55556[(2)]);
var state_55556__$1 = state_55556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55556__$1,inst_55554);
} else {
if((state_val_55557 === (12))){
var inst_55515 = (state_55556[(9)]);
var inst_55529 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_55515,opts);
var state_55556__$1 = state_55556;
if(cljs.core.truth_(inst_55529)){
var statearr_55567_55596 = state_55556__$1;
(statearr_55567_55596[(1)] = (15));

} else {
var statearr_55568_55597 = state_55556__$1;
(statearr_55568_55597[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (2))){
var state_55556__$1 = state_55556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55556__$1,(4),ch);
} else {
if((state_val_55557 === (11))){
var inst_55516 = (state_55556[(8)]);
var inst_55521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55522 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_55516);
var inst_55523 = cljs.core.async.timeout.call(null,(1000));
var inst_55524 = [inst_55522,inst_55523];
var inst_55525 = (new cljs.core.PersistentVector(null,2,(5),inst_55521,inst_55524,null));
var state_55556__$1 = state_55556;
return cljs.core.async.ioc_alts_BANG_.call(null,state_55556__$1,(14),inst_55525);
} else {
if((state_val_55557 === (9))){
var inst_55516 = (state_55556[(8)]);
var inst_55542 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_55543 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_55516);
var inst_55544 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_55543);
var inst_55545 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55544)].join('');
var inst_55546 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_55545);
var state_55556__$1 = (function (){var statearr_55569 = state_55556;
(statearr_55569[(10)] = inst_55542);

return statearr_55569;
})();
var statearr_55570_55598 = state_55556__$1;
(statearr_55570_55598[(2)] = inst_55546);

(statearr_55570_55598[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (5))){
var inst_55509 = (state_55556[(7)]);
var inst_55511 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_55512 = (new cljs.core.PersistentArrayMap(null,2,inst_55511,null));
var inst_55513 = (new cljs.core.PersistentHashSet(null,inst_55512,null));
var inst_55514 = figwheel.client.focus_msgs.call(null,inst_55513,inst_55509);
var inst_55515 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_55514);
var inst_55516 = cljs.core.first.call(null,inst_55514);
var inst_55517 = figwheel.client.autoload_QMARK_.call(null);
var state_55556__$1 = (function (){var statearr_55571 = state_55556;
(statearr_55571[(8)] = inst_55516);

(statearr_55571[(9)] = inst_55515);

return statearr_55571;
})();
if(cljs.core.truth_(inst_55517)){
var statearr_55572_55599 = state_55556__$1;
(statearr_55572_55599[(1)] = (8));

} else {
var statearr_55573_55600 = state_55556__$1;
(statearr_55573_55600[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (14))){
var inst_55527 = (state_55556[(2)]);
var state_55556__$1 = state_55556;
var statearr_55574_55601 = state_55556__$1;
(statearr_55574_55601[(2)] = inst_55527);

(statearr_55574_55601[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (16))){
var state_55556__$1 = state_55556;
var statearr_55575_55602 = state_55556__$1;
(statearr_55575_55602[(2)] = null);

(statearr_55575_55602[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (10))){
var inst_55548 = (state_55556[(2)]);
var state_55556__$1 = (function (){var statearr_55576 = state_55556;
(statearr_55576[(11)] = inst_55548);

return statearr_55576;
})();
var statearr_55577_55603 = state_55556__$1;
(statearr_55577_55603[(2)] = null);

(statearr_55577_55603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55557 === (8))){
var inst_55515 = (state_55556[(9)]);
var inst_55519 = figwheel.client.reload_file_state_QMARK_.call(null,inst_55515,opts);
var state_55556__$1 = state_55556;
if(cljs.core.truth_(inst_55519)){
var statearr_55578_55604 = state_55556__$1;
(statearr_55578_55604[(1)] = (11));

} else {
var statearr_55579_55605 = state_55556__$1;
(statearr_55579_55605[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto___55587,ch))
;
return ((function (switch__2483__auto__,c__2597__auto___55587,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____0 = (function (){
var statearr_55583 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55583[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__);

(statearr_55583[(1)] = (1));

return statearr_55583;
});
var figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____1 = (function (state_55556){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_55556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e55584){if((e55584 instanceof Object)){
var ex__2487__auto__ = e55584;
var statearr_55585_55606 = state_55556;
(statearr_55585_55606[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55556);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55607 = state_55556;
state_55556 = G__55607;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__ = function(state_55556){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____1.call(this,state_55556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__2484__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___55587,ch))
})();
var state__2599__auto__ = (function (){var statearr_55586 = f__2598__auto__.call(null);
(statearr_55586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___55587);

return statearr_55586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___55587,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__55608_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__55608_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_55611 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_55611){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e55610){if((e55610 instanceof Error)){
var e = e55610;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_55611], null));
} else {
var e = e55610;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_55611))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__55612){
var map__55621 = p__55612;
var map__55621__$1 = ((((!((map__55621 == null)))?((((map__55621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55621.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55621):map__55621);
var opts = map__55621__$1;
var build_id = cljs.core.get.call(null,map__55621__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__55621,map__55621__$1,opts,build_id){
return (function (p__55623){
var vec__55624 = p__55623;
var seq__55625 = cljs.core.seq.call(null,vec__55624);
var first__55626 = cljs.core.first.call(null,seq__55625);
var seq__55625__$1 = cljs.core.next.call(null,seq__55625);
var map__55627 = first__55626;
var map__55627__$1 = ((((!((map__55627 == null)))?((((map__55627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55627.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55627):map__55627);
var msg = map__55627__$1;
var msg_name = cljs.core.get.call(null,map__55627__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55625__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__55624,seq__55625,first__55626,seq__55625__$1,map__55627,map__55627__$1,msg,msg_name,_,map__55621,map__55621__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__55624,seq__55625,first__55626,seq__55625__$1,map__55627,map__55627__$1,msg,msg_name,_,map__55621,map__55621__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__55621,map__55621__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__55635){
var vec__55636 = p__55635;
var seq__55637 = cljs.core.seq.call(null,vec__55636);
var first__55638 = cljs.core.first.call(null,seq__55637);
var seq__55637__$1 = cljs.core.next.call(null,seq__55637);
var map__55639 = first__55638;
var map__55639__$1 = ((((!((map__55639 == null)))?((((map__55639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55639.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55639):map__55639);
var msg = map__55639__$1;
var msg_name = cljs.core.get.call(null,map__55639__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55637__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__55641){
var map__55653 = p__55641;
var map__55653__$1 = ((((!((map__55653 == null)))?((((map__55653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55653.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55653):map__55653);
var on_compile_warning = cljs.core.get.call(null,map__55653__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__55653__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__55653,map__55653__$1,on_compile_warning,on_compile_fail){
return (function (p__55655){
var vec__55656 = p__55655;
var seq__55657 = cljs.core.seq.call(null,vec__55656);
var first__55658 = cljs.core.first.call(null,seq__55657);
var seq__55657__$1 = cljs.core.next.call(null,seq__55657);
var map__55659 = first__55658;
var map__55659__$1 = ((((!((map__55659 == null)))?((((map__55659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55659.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55659):map__55659);
var msg = map__55659__$1;
var msg_name = cljs.core.get.call(null,map__55659__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55657__$1;
var pred__55661 = cljs.core._EQ_;
var expr__55662 = msg_name;
if(cljs.core.truth_(pred__55661.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__55662))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__55661.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__55662))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__55653,map__55653__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__,msg_hist,msg_names,msg){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__,msg_hist,msg_names,msg){
return (function (state_55890){
var state_val_55891 = (state_55890[(1)]);
if((state_val_55891 === (7))){
var inst_55810 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55810)){
var statearr_55892_55942 = state_55890__$1;
(statearr_55892_55942[(1)] = (8));

} else {
var statearr_55893_55943 = state_55890__$1;
(statearr_55893_55943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (20))){
var inst_55884 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55894_55944 = state_55890__$1;
(statearr_55894_55944[(2)] = inst_55884);

(statearr_55894_55944[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (27))){
var inst_55880 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55895_55945 = state_55890__$1;
(statearr_55895_55945[(2)] = inst_55880);

(statearr_55895_55945[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (1))){
var inst_55803 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55803)){
var statearr_55896_55946 = state_55890__$1;
(statearr_55896_55946[(1)] = (2));

} else {
var statearr_55897_55947 = state_55890__$1;
(statearr_55897_55947[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (24))){
var inst_55882 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55898_55948 = state_55890__$1;
(statearr_55898_55948[(2)] = inst_55882);

(statearr_55898_55948[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (4))){
var inst_55888 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55890__$1,inst_55888);
} else {
if((state_val_55891 === (15))){
var inst_55886 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55899_55949 = state_55890__$1;
(statearr_55899_55949[(2)] = inst_55886);

(statearr_55899_55949[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (21))){
var inst_55839 = (state_55890[(2)]);
var inst_55840 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55841 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55840);
var state_55890__$1 = (function (){var statearr_55900 = state_55890;
(statearr_55900[(7)] = inst_55839);

return statearr_55900;
})();
var statearr_55901_55950 = state_55890__$1;
(statearr_55901_55950[(2)] = inst_55841);

(statearr_55901_55950[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (31))){
var inst_55869 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55869)){
var statearr_55902_55951 = state_55890__$1;
(statearr_55902_55951[(1)] = (34));

} else {
var statearr_55903_55952 = state_55890__$1;
(statearr_55903_55952[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (32))){
var inst_55878 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55904_55953 = state_55890__$1;
(statearr_55904_55953[(2)] = inst_55878);

(statearr_55904_55953[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (33))){
var inst_55865 = (state_55890[(2)]);
var inst_55866 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55867 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55866);
var state_55890__$1 = (function (){var statearr_55905 = state_55890;
(statearr_55905[(8)] = inst_55865);

return statearr_55905;
})();
var statearr_55906_55954 = state_55890__$1;
(statearr_55906_55954[(2)] = inst_55867);

(statearr_55906_55954[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (13))){
var inst_55824 = figwheel.client.heads_up.clear.call(null);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(16),inst_55824);
} else {
if((state_val_55891 === (22))){
var inst_55845 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55846 = figwheel.client.heads_up.append_warning_message.call(null,inst_55845);
var state_55890__$1 = state_55890;
var statearr_55907_55955 = state_55890__$1;
(statearr_55907_55955[(2)] = inst_55846);

(statearr_55907_55955[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (36))){
var inst_55876 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55908_55956 = state_55890__$1;
(statearr_55908_55956[(2)] = inst_55876);

(statearr_55908_55956[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (29))){
var inst_55856 = (state_55890[(2)]);
var inst_55857 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55858 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55857);
var state_55890__$1 = (function (){var statearr_55909 = state_55890;
(statearr_55909[(9)] = inst_55856);

return statearr_55909;
})();
var statearr_55910_55957 = state_55890__$1;
(statearr_55910_55957[(2)] = inst_55858);

(statearr_55910_55957[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (6))){
var inst_55805 = (state_55890[(10)]);
var state_55890__$1 = state_55890;
var statearr_55911_55958 = state_55890__$1;
(statearr_55911_55958[(2)] = inst_55805);

(statearr_55911_55958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (28))){
var inst_55852 = (state_55890[(2)]);
var inst_55853 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55854 = figwheel.client.heads_up.display_warning.call(null,inst_55853);
var state_55890__$1 = (function (){var statearr_55912 = state_55890;
(statearr_55912[(11)] = inst_55852);

return statearr_55912;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(29),inst_55854);
} else {
if((state_val_55891 === (25))){
var inst_55850 = figwheel.client.heads_up.clear.call(null);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(28),inst_55850);
} else {
if((state_val_55891 === (34))){
var inst_55871 = figwheel.client.heads_up.flash_loaded.call(null);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(37),inst_55871);
} else {
if((state_val_55891 === (17))){
var inst_55830 = (state_55890[(2)]);
var inst_55831 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55832 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55831);
var state_55890__$1 = (function (){var statearr_55913 = state_55890;
(statearr_55913[(12)] = inst_55830);

return statearr_55913;
})();
var statearr_55914_55959 = state_55890__$1;
(statearr_55914_55959[(2)] = inst_55832);

(statearr_55914_55959[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (3))){
var inst_55822 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55822)){
var statearr_55915_55960 = state_55890__$1;
(statearr_55915_55960[(1)] = (13));

} else {
var statearr_55916_55961 = state_55890__$1;
(statearr_55916_55961[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (12))){
var inst_55818 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55917_55962 = state_55890__$1;
(statearr_55917_55962[(2)] = inst_55818);

(statearr_55917_55962[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (2))){
var inst_55805 = (state_55890[(10)]);
var inst_55805__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_55890__$1 = (function (){var statearr_55918 = state_55890;
(statearr_55918[(10)] = inst_55805__$1);

return statearr_55918;
})();
if(cljs.core.truth_(inst_55805__$1)){
var statearr_55919_55963 = state_55890__$1;
(statearr_55919_55963[(1)] = (5));

} else {
var statearr_55920_55964 = state_55890__$1;
(statearr_55920_55964[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (23))){
var inst_55848 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55848)){
var statearr_55921_55965 = state_55890__$1;
(statearr_55921_55965[(1)] = (25));

} else {
var statearr_55922_55966 = state_55890__$1;
(statearr_55922_55966[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (35))){
var state_55890__$1 = state_55890;
var statearr_55923_55967 = state_55890__$1;
(statearr_55923_55967[(2)] = null);

(statearr_55923_55967[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (19))){
var inst_55843 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55843)){
var statearr_55924_55968 = state_55890__$1;
(statearr_55924_55968[(1)] = (22));

} else {
var statearr_55925_55969 = state_55890__$1;
(statearr_55925_55969[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (11))){
var inst_55814 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55926_55970 = state_55890__$1;
(statearr_55926_55970[(2)] = inst_55814);

(statearr_55926_55970[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (9))){
var inst_55816 = figwheel.client.heads_up.clear.call(null);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(12),inst_55816);
} else {
if((state_val_55891 === (5))){
var inst_55807 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_55890__$1 = state_55890;
var statearr_55927_55971 = state_55890__$1;
(statearr_55927_55971[(2)] = inst_55807);

(statearr_55927_55971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (14))){
var inst_55834 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55834)){
var statearr_55928_55972 = state_55890__$1;
(statearr_55928_55972[(1)] = (18));

} else {
var statearr_55929_55973 = state_55890__$1;
(statearr_55929_55973[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (26))){
var inst_55860 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55860)){
var statearr_55930_55974 = state_55890__$1;
(statearr_55930_55974[(1)] = (30));

} else {
var statearr_55931_55975 = state_55890__$1;
(statearr_55931_55975[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (16))){
var inst_55826 = (state_55890[(2)]);
var inst_55827 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55828 = figwheel.client.heads_up.display_exception.call(null,inst_55827);
var state_55890__$1 = (function (){var statearr_55932 = state_55890;
(statearr_55932[(13)] = inst_55826);

return statearr_55932;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(17),inst_55828);
} else {
if((state_val_55891 === (30))){
var inst_55862 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55863 = figwheel.client.heads_up.display_warning.call(null,inst_55862);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(33),inst_55863);
} else {
if((state_val_55891 === (10))){
var inst_55820 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55933_55976 = state_55890__$1;
(statearr_55933_55976[(2)] = inst_55820);

(statearr_55933_55976[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (18))){
var inst_55836 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55837 = figwheel.client.heads_up.display_exception.call(null,inst_55836);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(21),inst_55837);
} else {
if((state_val_55891 === (37))){
var inst_55873 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55934_55977 = state_55890__$1;
(statearr_55934_55977[(2)] = inst_55873);

(statearr_55934_55977[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (8))){
var inst_55812 = figwheel.client.heads_up.flash_loaded.call(null);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(11),inst_55812);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__2483__auto__,c__2597__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____0 = (function (){
var statearr_55938 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55938[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__);

(statearr_55938[(1)] = (1));

return statearr_55938;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____1 = (function (state_55890){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_55890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e55939){if((e55939 instanceof Object)){
var ex__2487__auto__ = e55939;
var statearr_55940_55978 = state_55890;
(statearr_55940_55978[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55890);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55979 = state_55890;
state_55890 = G__55979;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__ = function(state_55890){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____1.call(this,state_55890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__,msg_hist,msg_names,msg))
})();
var state__2599__auto__ = (function (){var statearr_55941 = f__2598__auto__.call(null);
(statearr_55941[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_55941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__,msg_hist,msg_names,msg))
);

return c__2597__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__2597__auto___56042 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___56042,ch){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___56042,ch){
return (function (state_56025){
var state_val_56026 = (state_56025[(1)]);
if((state_val_56026 === (1))){
var state_56025__$1 = state_56025;
var statearr_56027_56043 = state_56025__$1;
(statearr_56027_56043[(2)] = null);

(statearr_56027_56043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (2))){
var state_56025__$1 = state_56025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56025__$1,(4),ch);
} else {
if((state_val_56026 === (3))){
var inst_56023 = (state_56025[(2)]);
var state_56025__$1 = state_56025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56025__$1,inst_56023);
} else {
if((state_val_56026 === (4))){
var inst_56013 = (state_56025[(7)]);
var inst_56013__$1 = (state_56025[(2)]);
var state_56025__$1 = (function (){var statearr_56028 = state_56025;
(statearr_56028[(7)] = inst_56013__$1);

return statearr_56028;
})();
if(cljs.core.truth_(inst_56013__$1)){
var statearr_56029_56044 = state_56025__$1;
(statearr_56029_56044[(1)] = (5));

} else {
var statearr_56030_56045 = state_56025__$1;
(statearr_56030_56045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (5))){
var inst_56013 = (state_56025[(7)]);
var inst_56015 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_56013);
var state_56025__$1 = state_56025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56025__$1,(8),inst_56015);
} else {
if((state_val_56026 === (6))){
var state_56025__$1 = state_56025;
var statearr_56031_56046 = state_56025__$1;
(statearr_56031_56046[(2)] = null);

(statearr_56031_56046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (7))){
var inst_56021 = (state_56025[(2)]);
var state_56025__$1 = state_56025;
var statearr_56032_56047 = state_56025__$1;
(statearr_56032_56047[(2)] = inst_56021);

(statearr_56032_56047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (8))){
var inst_56017 = (state_56025[(2)]);
var state_56025__$1 = (function (){var statearr_56033 = state_56025;
(statearr_56033[(8)] = inst_56017);

return statearr_56033;
})();
var statearr_56034_56048 = state_56025__$1;
(statearr_56034_56048[(2)] = null);

(statearr_56034_56048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__2597__auto___56042,ch))
;
return ((function (switch__2483__auto__,c__2597__auto___56042,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__2484__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__2484__auto____0 = (function (){
var statearr_56038 = [null,null,null,null,null,null,null,null,null];
(statearr_56038[(0)] = figwheel$client$heads_up_plugin_$_state_machine__2484__auto__);

(statearr_56038[(1)] = (1));

return statearr_56038;
});
var figwheel$client$heads_up_plugin_$_state_machine__2484__auto____1 = (function (state_56025){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_56025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e56039){if((e56039 instanceof Object)){
var ex__2487__auto__ = e56039;
var statearr_56040_56049 = state_56025;
(statearr_56040_56049[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56025);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56050 = state_56025;
state_56025 = G__56050;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__2484__auto__ = function(state_56025){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__2484__auto____1.call(this,state_56025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__2484__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__2484__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___56042,ch))
})();
var state__2599__auto__ = (function (){var statearr_56041 = f__2598__auto__.call(null);
(statearr_56041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___56042);

return statearr_56041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___56042,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_56071){
var state_val_56072 = (state_56071[(1)]);
if((state_val_56072 === (1))){
var inst_56066 = cljs.core.async.timeout.call(null,(3000));
var state_56071__$1 = state_56071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56071__$1,(2),inst_56066);
} else {
if((state_val_56072 === (2))){
var inst_56068 = (state_56071[(2)]);
var inst_56069 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_56071__$1 = (function (){var statearr_56073 = state_56071;
(statearr_56073[(7)] = inst_56068);

return statearr_56073;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56071__$1,inst_56069);
} else {
return null;
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____0 = (function (){
var statearr_56077 = [null,null,null,null,null,null,null,null];
(statearr_56077[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__);

(statearr_56077[(1)] = (1));

return statearr_56077;
});
var figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____1 = (function (state_56071){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_56071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e56078){if((e56078 instanceof Object)){
var ex__2487__auto__ = e56078;
var statearr_56079_56081 = state_56071;
(statearr_56079_56081[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56071);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56078;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56082 = state_56071;
state_56071 = G__56082;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__ = function(state_56071){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____1.call(this,state_56071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__2484__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_56080 = f__2598__auto__.call(null);
(statearr_56080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_56080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__,figwheel_version,temp__6753__auto__){
return (function (state_56105){
var state_val_56106 = (state_56105[(1)]);
if((state_val_56106 === (1))){
var inst_56099 = cljs.core.async.timeout.call(null,(2000));
var state_56105__$1 = state_56105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56105__$1,(2),inst_56099);
} else {
if((state_val_56106 === (2))){
var inst_56101 = (state_56105[(2)]);
var inst_56102 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_56103 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_56102);
var state_56105__$1 = (function (){var statearr_56107 = state_56105;
(statearr_56107[(7)] = inst_56101);

return statearr_56107;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56105__$1,inst_56103);
} else {
return null;
}
}
});})(c__2597__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____0 = (function (){
var statearr_56111 = [null,null,null,null,null,null,null,null];
(statearr_56111[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__);

(statearr_56111[(1)] = (1));

return statearr_56111;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____1 = (function (state_56105){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_56105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e56112){if((e56112 instanceof Object)){
var ex__2487__auto__ = e56112;
var statearr_56113_56115 = state_56105;
(statearr_56113_56115[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56105);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56116 = state_56105;
state_56105 = G__56116;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__ = function(state_56105){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____1.call(this,state_56105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__,figwheel_version,temp__6753__auto__))
})();
var state__2599__auto__ = (function (){var statearr_56114 = f__2598__auto__.call(null);
(statearr_56114[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_56114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__,figwheel_version,temp__6753__auto__))
);

return c__2597__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__56117){
var map__56121 = p__56117;
var map__56121__$1 = ((((!((map__56121 == null)))?((((map__56121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56121.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56121):map__56121);
var file = cljs.core.get.call(null,map__56121__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__56121__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__56121__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__56123 = "";
var G__56123__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56123),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__56123);
var G__56123__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56123__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__56123__$1);
if(cljs.core.truth_((function (){var and__11272__auto__ = line;
if(cljs.core.truth_(and__11272__auto__)){
return column;
} else {
return and__11272__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56123__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__56123__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__56124){
var map__56131 = p__56124;
var map__56131__$1 = ((((!((map__56131 == null)))?((((map__56131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56131.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56131):map__56131);
var ed = map__56131__$1;
var formatted_exception = cljs.core.get.call(null,map__56131__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__56131__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__56131__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__56133_56137 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__56134_56138 = null;
var count__56135_56139 = (0);
var i__56136_56140 = (0);
while(true){
if((i__56136_56140 < count__56135_56139)){
var msg_56141 = cljs.core._nth.call(null,chunk__56134_56138,i__56136_56140);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_56141);

var G__56142 = seq__56133_56137;
var G__56143 = chunk__56134_56138;
var G__56144 = count__56135_56139;
var G__56145 = (i__56136_56140 + (1));
seq__56133_56137 = G__56142;
chunk__56134_56138 = G__56143;
count__56135_56139 = G__56144;
i__56136_56140 = G__56145;
continue;
} else {
var temp__6753__auto___56146 = cljs.core.seq.call(null,seq__56133_56137);
if(temp__6753__auto___56146){
var seq__56133_56147__$1 = temp__6753__auto___56146;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56133_56147__$1)){
var c__11759__auto___56148 = cljs.core.chunk_first.call(null,seq__56133_56147__$1);
var G__56149 = cljs.core.chunk_rest.call(null,seq__56133_56147__$1);
var G__56150 = c__11759__auto___56148;
var G__56151 = cljs.core.count.call(null,c__11759__auto___56148);
var G__56152 = (0);
seq__56133_56137 = G__56149;
chunk__56134_56138 = G__56150;
count__56135_56139 = G__56151;
i__56136_56140 = G__56152;
continue;
} else {
var msg_56153 = cljs.core.first.call(null,seq__56133_56147__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_56153);

var G__56154 = cljs.core.next.call(null,seq__56133_56147__$1);
var G__56155 = null;
var G__56156 = (0);
var G__56157 = (0);
seq__56133_56137 = G__56154;
chunk__56134_56138 = G__56155;
count__56135_56139 = G__56156;
i__56136_56140 = G__56157;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__56158){
var map__56161 = p__56158;
var map__56161__$1 = ((((!((map__56161 == null)))?((((map__56161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56161):map__56161);
var w = map__56161__$1;
var message = cljs.core.get.call(null,map__56161__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/cards/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/cards/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__11272__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__11272__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__11272__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__56173 = cljs.core.seq.call(null,plugins);
var chunk__56174 = null;
var count__56175 = (0);
var i__56176 = (0);
while(true){
if((i__56176 < count__56175)){
var vec__56177 = cljs.core._nth.call(null,chunk__56174,i__56176);
var k = cljs.core.nth.call(null,vec__56177,(0),null);
var plugin = cljs.core.nth.call(null,vec__56177,(1),null);
if(cljs.core.truth_(plugin)){
var pl_56183 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__56173,chunk__56174,count__56175,i__56176,pl_56183,vec__56177,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_56183.call(null,msg_hist);
});})(seq__56173,chunk__56174,count__56175,i__56176,pl_56183,vec__56177,k,plugin))
);
} else {
}

var G__56184 = seq__56173;
var G__56185 = chunk__56174;
var G__56186 = count__56175;
var G__56187 = (i__56176 + (1));
seq__56173 = G__56184;
chunk__56174 = G__56185;
count__56175 = G__56186;
i__56176 = G__56187;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__56173);
if(temp__6753__auto__){
var seq__56173__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56173__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__56173__$1);
var G__56188 = cljs.core.chunk_rest.call(null,seq__56173__$1);
var G__56189 = c__11759__auto__;
var G__56190 = cljs.core.count.call(null,c__11759__auto__);
var G__56191 = (0);
seq__56173 = G__56188;
chunk__56174 = G__56189;
count__56175 = G__56190;
i__56176 = G__56191;
continue;
} else {
var vec__56180 = cljs.core.first.call(null,seq__56173__$1);
var k = cljs.core.nth.call(null,vec__56180,(0),null);
var plugin = cljs.core.nth.call(null,vec__56180,(1),null);
if(cljs.core.truth_(plugin)){
var pl_56192 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__56173,chunk__56174,count__56175,i__56176,pl_56192,vec__56180,k,plugin,seq__56173__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_56192.call(null,msg_hist);
});})(seq__56173,chunk__56174,count__56175,i__56176,pl_56192,vec__56180,k,plugin,seq__56173__$1,temp__6753__auto__))
);
} else {
}

var G__56193 = cljs.core.next.call(null,seq__56173__$1);
var G__56194 = null;
var G__56195 = (0);
var G__56196 = (0);
seq__56173 = G__56193;
chunk__56174 = G__56194;
count__56175 = G__56195;
i__56176 = G__56196;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args56197 = [];
var len__11929__auto___56204 = arguments.length;
var i__11930__auto___56205 = (0);
while(true){
if((i__11930__auto___56205 < len__11929__auto___56204)){
args56197.push((arguments[i__11930__auto___56205]));

var G__56206 = (i__11930__auto___56205 + (1));
i__11930__auto___56205 = G__56206;
continue;
} else {
}
break;
}

var G__56199 = args56197.length;
switch (G__56199) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args56197.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__56200_56208 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__56201_56209 = null;
var count__56202_56210 = (0);
var i__56203_56211 = (0);
while(true){
if((i__56203_56211 < count__56202_56210)){
var msg_56212 = cljs.core._nth.call(null,chunk__56201_56209,i__56203_56211);
figwheel.client.socket.handle_incoming_message.call(null,msg_56212);

var G__56213 = seq__56200_56208;
var G__56214 = chunk__56201_56209;
var G__56215 = count__56202_56210;
var G__56216 = (i__56203_56211 + (1));
seq__56200_56208 = G__56213;
chunk__56201_56209 = G__56214;
count__56202_56210 = G__56215;
i__56203_56211 = G__56216;
continue;
} else {
var temp__6753__auto___56217 = cljs.core.seq.call(null,seq__56200_56208);
if(temp__6753__auto___56217){
var seq__56200_56218__$1 = temp__6753__auto___56217;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56200_56218__$1)){
var c__11759__auto___56219 = cljs.core.chunk_first.call(null,seq__56200_56218__$1);
var G__56220 = cljs.core.chunk_rest.call(null,seq__56200_56218__$1);
var G__56221 = c__11759__auto___56219;
var G__56222 = cljs.core.count.call(null,c__11759__auto___56219);
var G__56223 = (0);
seq__56200_56208 = G__56220;
chunk__56201_56209 = G__56221;
count__56202_56210 = G__56222;
i__56203_56211 = G__56223;
continue;
} else {
var msg_56224 = cljs.core.first.call(null,seq__56200_56218__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_56224);

var G__56225 = cljs.core.next.call(null,seq__56200_56218__$1);
var G__56226 = null;
var G__56227 = (0);
var G__56228 = (0);
seq__56200_56208 = G__56225;
chunk__56201_56209 = G__56226;
count__56202_56210 = G__56227;
i__56203_56211 = G__56228;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__11932__auto__ = [];
var len__11929__auto___56233 = arguments.length;
var i__11930__auto___56234 = (0);
while(true){
if((i__11930__auto___56234 < len__11929__auto___56233)){
args__11932__auto__.push((arguments[i__11930__auto___56234]));

var G__56235 = (i__11930__auto___56234 + (1));
i__11930__auto___56234 = G__56235;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__56230){
var map__56231 = p__56230;
var map__56231__$1 = ((((!((map__56231 == null)))?((((map__56231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56231):map__56231);
var opts = map__56231__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq56229){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq56229));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e56237){if((e56237 instanceof Error)){
var e = e56237;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e56237;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__56241){
var map__56242 = p__56241;
var map__56242__$1 = ((((!((map__56242 == null)))?((((map__56242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56242.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56242):map__56242);
var msg_name = cljs.core.get.call(null,map__56242__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1486495667943