// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__11280__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__11280__auto__){
return or__11280__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__11280__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__52839_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__52839_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__52844 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__52845 = null;
var count__52846 = (0);
var i__52847 = (0);
while(true){
if((i__52847 < count__52846)){
var n = cljs.core._nth.call(null,chunk__52845,i__52847);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__52848 = seq__52844;
var G__52849 = chunk__52845;
var G__52850 = count__52846;
var G__52851 = (i__52847 + (1));
seq__52844 = G__52848;
chunk__52845 = G__52849;
count__52846 = G__52850;
i__52847 = G__52851;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__52844);
if(temp__6753__auto__){
var seq__52844__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52844__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__52844__$1);
var G__52852 = cljs.core.chunk_rest.call(null,seq__52844__$1);
var G__52853 = c__11759__auto__;
var G__52854 = cljs.core.count.call(null,c__11759__auto__);
var G__52855 = (0);
seq__52844 = G__52852;
chunk__52845 = G__52853;
count__52846 = G__52854;
i__52847 = G__52855;
continue;
} else {
var n = cljs.core.first.call(null,seq__52844__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__52856 = cljs.core.next.call(null,seq__52844__$1);
var G__52857 = null;
var G__52858 = (0);
var G__52859 = (0);
seq__52844 = G__52856;
chunk__52845 = G__52857;
count__52846 = G__52858;
i__52847 = G__52859;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__52910_52921 = cljs.core.seq.call(null,deps);
var chunk__52911_52922 = null;
var count__52912_52923 = (0);
var i__52913_52924 = (0);
while(true){
if((i__52913_52924 < count__52912_52923)){
var dep_52925 = cljs.core._nth.call(null,chunk__52911_52922,i__52913_52924);
topo_sort_helper_STAR_.call(null,dep_52925,(depth + (1)),state);

var G__52926 = seq__52910_52921;
var G__52927 = chunk__52911_52922;
var G__52928 = count__52912_52923;
var G__52929 = (i__52913_52924 + (1));
seq__52910_52921 = G__52926;
chunk__52911_52922 = G__52927;
count__52912_52923 = G__52928;
i__52913_52924 = G__52929;
continue;
} else {
var temp__6753__auto___52930 = cljs.core.seq.call(null,seq__52910_52921);
if(temp__6753__auto___52930){
var seq__52910_52931__$1 = temp__6753__auto___52930;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52910_52931__$1)){
var c__11759__auto___52932 = cljs.core.chunk_first.call(null,seq__52910_52931__$1);
var G__52933 = cljs.core.chunk_rest.call(null,seq__52910_52931__$1);
var G__52934 = c__11759__auto___52932;
var G__52935 = cljs.core.count.call(null,c__11759__auto___52932);
var G__52936 = (0);
seq__52910_52921 = G__52933;
chunk__52911_52922 = G__52934;
count__52912_52923 = G__52935;
i__52913_52924 = G__52936;
continue;
} else {
var dep_52937 = cljs.core.first.call(null,seq__52910_52931__$1);
topo_sort_helper_STAR_.call(null,dep_52937,(depth + (1)),state);

var G__52938 = cljs.core.next.call(null,seq__52910_52931__$1);
var G__52939 = null;
var G__52940 = (0);
var G__52941 = (0);
seq__52910_52921 = G__52938;
chunk__52911_52922 = G__52939;
count__52912_52923 = G__52940;
i__52913_52924 = G__52941;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__52914){
var vec__52918 = p__52914;
var seq__52919 = cljs.core.seq.call(null,vec__52918);
var first__52920 = cljs.core.first.call(null,seq__52919);
var seq__52919__$1 = cljs.core.next.call(null,seq__52919);
var x = first__52920;
var xs = seq__52919__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__52918,seq__52919,first__52920,seq__52919__$1,x,xs,get_deps__$1){
return (function (p1__52860_SHARP_){
return clojure.set.difference.call(null,p1__52860_SHARP_,x);
});})(vec__52918,seq__52919,first__52920,seq__52919__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__52954 = cljs.core.seq.call(null,provides);
var chunk__52955 = null;
var count__52956 = (0);
var i__52957 = (0);
while(true){
if((i__52957 < count__52956)){
var prov = cljs.core._nth.call(null,chunk__52955,i__52957);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__52958_52966 = cljs.core.seq.call(null,requires);
var chunk__52959_52967 = null;
var count__52960_52968 = (0);
var i__52961_52969 = (0);
while(true){
if((i__52961_52969 < count__52960_52968)){
var req_52970 = cljs.core._nth.call(null,chunk__52959_52967,i__52961_52969);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_52970,prov);

var G__52971 = seq__52958_52966;
var G__52972 = chunk__52959_52967;
var G__52973 = count__52960_52968;
var G__52974 = (i__52961_52969 + (1));
seq__52958_52966 = G__52971;
chunk__52959_52967 = G__52972;
count__52960_52968 = G__52973;
i__52961_52969 = G__52974;
continue;
} else {
var temp__6753__auto___52975 = cljs.core.seq.call(null,seq__52958_52966);
if(temp__6753__auto___52975){
var seq__52958_52976__$1 = temp__6753__auto___52975;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52958_52976__$1)){
var c__11759__auto___52977 = cljs.core.chunk_first.call(null,seq__52958_52976__$1);
var G__52978 = cljs.core.chunk_rest.call(null,seq__52958_52976__$1);
var G__52979 = c__11759__auto___52977;
var G__52980 = cljs.core.count.call(null,c__11759__auto___52977);
var G__52981 = (0);
seq__52958_52966 = G__52978;
chunk__52959_52967 = G__52979;
count__52960_52968 = G__52980;
i__52961_52969 = G__52981;
continue;
} else {
var req_52982 = cljs.core.first.call(null,seq__52958_52976__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_52982,prov);

var G__52983 = cljs.core.next.call(null,seq__52958_52976__$1);
var G__52984 = null;
var G__52985 = (0);
var G__52986 = (0);
seq__52958_52966 = G__52983;
chunk__52959_52967 = G__52984;
count__52960_52968 = G__52985;
i__52961_52969 = G__52986;
continue;
}
} else {
}
}
break;
}

var G__52987 = seq__52954;
var G__52988 = chunk__52955;
var G__52989 = count__52956;
var G__52990 = (i__52957 + (1));
seq__52954 = G__52987;
chunk__52955 = G__52988;
count__52956 = G__52989;
i__52957 = G__52990;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__52954);
if(temp__6753__auto__){
var seq__52954__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52954__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__52954__$1);
var G__52991 = cljs.core.chunk_rest.call(null,seq__52954__$1);
var G__52992 = c__11759__auto__;
var G__52993 = cljs.core.count.call(null,c__11759__auto__);
var G__52994 = (0);
seq__52954 = G__52991;
chunk__52955 = G__52992;
count__52956 = G__52993;
i__52957 = G__52994;
continue;
} else {
var prov = cljs.core.first.call(null,seq__52954__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__52962_52995 = cljs.core.seq.call(null,requires);
var chunk__52963_52996 = null;
var count__52964_52997 = (0);
var i__52965_52998 = (0);
while(true){
if((i__52965_52998 < count__52964_52997)){
var req_52999 = cljs.core._nth.call(null,chunk__52963_52996,i__52965_52998);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_52999,prov);

var G__53000 = seq__52962_52995;
var G__53001 = chunk__52963_52996;
var G__53002 = count__52964_52997;
var G__53003 = (i__52965_52998 + (1));
seq__52962_52995 = G__53000;
chunk__52963_52996 = G__53001;
count__52964_52997 = G__53002;
i__52965_52998 = G__53003;
continue;
} else {
var temp__6753__auto___53004__$1 = cljs.core.seq.call(null,seq__52962_52995);
if(temp__6753__auto___53004__$1){
var seq__52962_53005__$1 = temp__6753__auto___53004__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52962_53005__$1)){
var c__11759__auto___53006 = cljs.core.chunk_first.call(null,seq__52962_53005__$1);
var G__53007 = cljs.core.chunk_rest.call(null,seq__52962_53005__$1);
var G__53008 = c__11759__auto___53006;
var G__53009 = cljs.core.count.call(null,c__11759__auto___53006);
var G__53010 = (0);
seq__52962_52995 = G__53007;
chunk__52963_52996 = G__53008;
count__52964_52997 = G__53009;
i__52965_52998 = G__53010;
continue;
} else {
var req_53011 = cljs.core.first.call(null,seq__52962_53005__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_53011,prov);

var G__53012 = cljs.core.next.call(null,seq__52962_53005__$1);
var G__53013 = null;
var G__53014 = (0);
var G__53015 = (0);
seq__52962_52995 = G__53012;
chunk__52963_52996 = G__53013;
count__52964_52997 = G__53014;
i__52965_52998 = G__53015;
continue;
}
} else {
}
}
break;
}

var G__53016 = cljs.core.next.call(null,seq__52954__$1);
var G__53017 = null;
var G__53018 = (0);
var G__53019 = (0);
seq__52954 = G__53016;
chunk__52955 = G__53017;
count__52956 = G__53018;
i__52957 = G__53019;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__53024_53028 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__53025_53029 = null;
var count__53026_53030 = (0);
var i__53027_53031 = (0);
while(true){
if((i__53027_53031 < count__53026_53030)){
var ns_53032 = cljs.core._nth.call(null,chunk__53025_53029,i__53027_53031);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_53032);

var G__53033 = seq__53024_53028;
var G__53034 = chunk__53025_53029;
var G__53035 = count__53026_53030;
var G__53036 = (i__53027_53031 + (1));
seq__53024_53028 = G__53033;
chunk__53025_53029 = G__53034;
count__53026_53030 = G__53035;
i__53027_53031 = G__53036;
continue;
} else {
var temp__6753__auto___53037 = cljs.core.seq.call(null,seq__53024_53028);
if(temp__6753__auto___53037){
var seq__53024_53038__$1 = temp__6753__auto___53037;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53024_53038__$1)){
var c__11759__auto___53039 = cljs.core.chunk_first.call(null,seq__53024_53038__$1);
var G__53040 = cljs.core.chunk_rest.call(null,seq__53024_53038__$1);
var G__53041 = c__11759__auto___53039;
var G__53042 = cljs.core.count.call(null,c__11759__auto___53039);
var G__53043 = (0);
seq__53024_53028 = G__53040;
chunk__53025_53029 = G__53041;
count__53026_53030 = G__53042;
i__53027_53031 = G__53043;
continue;
} else {
var ns_53044 = cljs.core.first.call(null,seq__53024_53038__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_53044);

var G__53045 = cljs.core.next.call(null,seq__53024_53038__$1);
var G__53046 = null;
var G__53047 = (0);
var G__53048 = (0);
seq__53024_53028 = G__53045;
chunk__53025_53029 = G__53046;
count__53026_53030 = G__53047;
i__53027_53031 = G__53048;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__11280__auto__ = goog.require__;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__53049__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__53049 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__53050__i = 0, G__53050__a = new Array(arguments.length -  0);
while (G__53050__i < G__53050__a.length) {G__53050__a[G__53050__i] = arguments[G__53050__i + 0]; ++G__53050__i;}
  args = new cljs.core.IndexedSeq(G__53050__a,0);
} 
return G__53049__delegate.call(this,args);};
G__53049.cljs$lang$maxFixedArity = 0;
G__53049.cljs$lang$applyTo = (function (arglist__53051){
var args = cljs.core.seq(arglist__53051);
return G__53049__delegate(args);
});
G__53049.cljs$core$IFn$_invoke$arity$variadic = G__53049__delegate;
return G__53049;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__53052 = cljs.core._EQ_;
var expr__53053 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__53052.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__53053))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__53052,expr__53053){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__53052,expr__53053))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__53052,expr__53053){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e53055){if((e53055 instanceof Error)){
var e = e53055;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e53055;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__53052,expr__53053))
} else {
if(cljs.core.truth_(pred__53052.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__53053))){
return ((function (pred__53052,expr__53053){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__53052,expr__53053){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__53052,expr__53053))
);

return deferred.addErrback(((function (deferred,pred__53052,expr__53053){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__53052,expr__53053))
);
});
;})(pred__53052,expr__53053))
} else {
if(cljs.core.truth_(pred__53052.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__53053))){
return ((function (pred__53052,expr__53053){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e53056){if((e53056 instanceof Error)){
var e = e53056;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e53056;

}
}})());
});
;})(pred__53052,expr__53053))
} else {
return ((function (pred__53052,expr__53053){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__53052,expr__53053))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__53057,callback){
var map__53060 = p__53057;
var map__53060__$1 = ((((!((map__53060 == null)))?((((map__53060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53060.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53060):map__53060);
var file_msg = map__53060__$1;
var request_url = cljs.core.get.call(null,map__53060__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__53060,map__53060__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__53060,map__53060__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_53084){
var state_val_53085 = (state_53084[(1)]);
if((state_val_53085 === (7))){
var inst_53080 = (state_53084[(2)]);
var state_53084__$1 = state_53084;
var statearr_53086_53106 = state_53084__$1;
(statearr_53086_53106[(2)] = inst_53080);

(statearr_53086_53106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (1))){
var state_53084__$1 = state_53084;
var statearr_53087_53107 = state_53084__$1;
(statearr_53087_53107[(2)] = null);

(statearr_53087_53107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (4))){
var inst_53064 = (state_53084[(7)]);
var inst_53064__$1 = (state_53084[(2)]);
var state_53084__$1 = (function (){var statearr_53088 = state_53084;
(statearr_53088[(7)] = inst_53064__$1);

return statearr_53088;
})();
if(cljs.core.truth_(inst_53064__$1)){
var statearr_53089_53108 = state_53084__$1;
(statearr_53089_53108[(1)] = (5));

} else {
var statearr_53090_53109 = state_53084__$1;
(statearr_53090_53109[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (6))){
var state_53084__$1 = state_53084;
var statearr_53091_53110 = state_53084__$1;
(statearr_53091_53110[(2)] = null);

(statearr_53091_53110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (3))){
var inst_53082 = (state_53084[(2)]);
var state_53084__$1 = state_53084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53084__$1,inst_53082);
} else {
if((state_val_53085 === (2))){
var state_53084__$1 = state_53084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53084__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_53085 === (11))){
var inst_53076 = (state_53084[(2)]);
var state_53084__$1 = (function (){var statearr_53092 = state_53084;
(statearr_53092[(8)] = inst_53076);

return statearr_53092;
})();
var statearr_53093_53111 = state_53084__$1;
(statearr_53093_53111[(2)] = null);

(statearr_53093_53111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (9))){
var inst_53068 = (state_53084[(9)]);
var inst_53070 = (state_53084[(10)]);
var inst_53072 = inst_53070.call(null,inst_53068);
var state_53084__$1 = state_53084;
var statearr_53094_53112 = state_53084__$1;
(statearr_53094_53112[(2)] = inst_53072);

(statearr_53094_53112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (5))){
var inst_53064 = (state_53084[(7)]);
var inst_53066 = figwheel.client.file_reloading.blocking_load.call(null,inst_53064);
var state_53084__$1 = state_53084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53084__$1,(8),inst_53066);
} else {
if((state_val_53085 === (10))){
var inst_53068 = (state_53084[(9)]);
var inst_53074 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_53068);
var state_53084__$1 = state_53084;
var statearr_53095_53113 = state_53084__$1;
(statearr_53095_53113[(2)] = inst_53074);

(statearr_53095_53113[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53085 === (8))){
var inst_53064 = (state_53084[(7)]);
var inst_53070 = (state_53084[(10)]);
var inst_53068 = (state_53084[(2)]);
var inst_53069 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_53070__$1 = cljs.core.get.call(null,inst_53069,inst_53064);
var state_53084__$1 = (function (){var statearr_53096 = state_53084;
(statearr_53096[(9)] = inst_53068);

(statearr_53096[(10)] = inst_53070__$1);

return statearr_53096;
})();
if(cljs.core.truth_(inst_53070__$1)){
var statearr_53097_53114 = state_53084__$1;
(statearr_53097_53114[(1)] = (9));

} else {
var statearr_53098_53115 = state_53084__$1;
(statearr_53098_53115[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__2484__auto__ = null;
var figwheel$client$file_reloading$state_machine__2484__auto____0 = (function (){
var statearr_53102 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53102[(0)] = figwheel$client$file_reloading$state_machine__2484__auto__);

(statearr_53102[(1)] = (1));

return statearr_53102;
});
var figwheel$client$file_reloading$state_machine__2484__auto____1 = (function (state_53084){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_53084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e53103){if((e53103 instanceof Object)){
var ex__2487__auto__ = e53103;
var statearr_53104_53116 = state_53084;
(statearr_53104_53116[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53084);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53103;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53117 = state_53084;
state_53084 = G__53117;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__2484__auto__ = function(state_53084){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__2484__auto____1.call(this,state_53084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__2484__auto____0;
figwheel$client$file_reloading$state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__2484__auto____1;
return figwheel$client$file_reloading$state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_53105 = f__2598__auto__.call(null);
(statearr_53105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_53105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__53118,callback){
var map__53121 = p__53118;
var map__53121__$1 = ((((!((map__53121 == null)))?((((map__53121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53121.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53121):map__53121);
var file_msg = map__53121__$1;
var namespace = cljs.core.get.call(null,map__53121__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__53121,map__53121__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__53121,map__53121__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__53123){
var map__53126 = p__53123;
var map__53126__$1 = ((((!((map__53126 == null)))?((((map__53126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53126.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53126):map__53126);
var file_msg = map__53126__$1;
var namespace = cljs.core.get.call(null,map__53126__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__53128){
var map__53131 = p__53128;
var map__53131__$1 = ((((!((map__53131 == null)))?((((map__53131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53131.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53131):map__53131);
var file_msg = map__53131__$1;
var namespace = cljs.core.get.call(null,map__53131__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__11272__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__11272__auto__){
var or__11280__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
var or__11280__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__11280__auto____$1)){
return or__11280__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__11272__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__53133,callback){
var map__53136 = p__53133;
var map__53136__$1 = ((((!((map__53136 == null)))?((((map__53136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53136.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53136):map__53136);
var file_msg = map__53136__$1;
var request_url = cljs.core.get.call(null,map__53136__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__53136__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__2597__auto___53240 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___53240,out){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___53240,out){
return (function (state_53222){
var state_val_53223 = (state_53222[(1)]);
if((state_val_53223 === (1))){
var inst_53196 = cljs.core.seq.call(null,files);
var inst_53197 = cljs.core.first.call(null,inst_53196);
var inst_53198 = cljs.core.next.call(null,inst_53196);
var inst_53199 = files;
var state_53222__$1 = (function (){var statearr_53224 = state_53222;
(statearr_53224[(7)] = inst_53198);

(statearr_53224[(8)] = inst_53197);

(statearr_53224[(9)] = inst_53199);

return statearr_53224;
})();
var statearr_53225_53241 = state_53222__$1;
(statearr_53225_53241[(2)] = null);

(statearr_53225_53241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53223 === (2))){
var inst_53205 = (state_53222[(10)]);
var inst_53199 = (state_53222[(9)]);
var inst_53204 = cljs.core.seq.call(null,inst_53199);
var inst_53205__$1 = cljs.core.first.call(null,inst_53204);
var inst_53206 = cljs.core.next.call(null,inst_53204);
var inst_53207 = (inst_53205__$1 == null);
var inst_53208 = cljs.core.not.call(null,inst_53207);
var state_53222__$1 = (function (){var statearr_53226 = state_53222;
(statearr_53226[(10)] = inst_53205__$1);

(statearr_53226[(11)] = inst_53206);

return statearr_53226;
})();
if(inst_53208){
var statearr_53227_53242 = state_53222__$1;
(statearr_53227_53242[(1)] = (4));

} else {
var statearr_53228_53243 = state_53222__$1;
(statearr_53228_53243[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53223 === (3))){
var inst_53220 = (state_53222[(2)]);
var state_53222__$1 = state_53222;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53222__$1,inst_53220);
} else {
if((state_val_53223 === (4))){
var inst_53205 = (state_53222[(10)]);
var inst_53210 = figwheel.client.file_reloading.reload_js_file.call(null,inst_53205);
var state_53222__$1 = state_53222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53222__$1,(7),inst_53210);
} else {
if((state_val_53223 === (5))){
var inst_53216 = cljs.core.async.close_BANG_.call(null,out);
var state_53222__$1 = state_53222;
var statearr_53229_53244 = state_53222__$1;
(statearr_53229_53244[(2)] = inst_53216);

(statearr_53229_53244[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53223 === (6))){
var inst_53218 = (state_53222[(2)]);
var state_53222__$1 = state_53222;
var statearr_53230_53245 = state_53222__$1;
(statearr_53230_53245[(2)] = inst_53218);

(statearr_53230_53245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53223 === (7))){
var inst_53206 = (state_53222[(11)]);
var inst_53212 = (state_53222[(2)]);
var inst_53213 = cljs.core.async.put_BANG_.call(null,out,inst_53212);
var inst_53199 = inst_53206;
var state_53222__$1 = (function (){var statearr_53231 = state_53222;
(statearr_53231[(12)] = inst_53213);

(statearr_53231[(9)] = inst_53199);

return statearr_53231;
})();
var statearr_53232_53246 = state_53222__$1;
(statearr_53232_53246[(2)] = null);

(statearr_53232_53246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2597__auto___53240,out))
;
return ((function (switch__2483__auto__,c__2597__auto___53240,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____0 = (function (){
var statearr_53236 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53236[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__);

(statearr_53236[(1)] = (1));

return statearr_53236;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____1 = (function (state_53222){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_53222);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e53237){if((e53237 instanceof Object)){
var ex__2487__auto__ = e53237;
var statearr_53238_53247 = state_53222;
(statearr_53238_53247[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53222);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53237;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53248 = state_53222;
state_53222 = G__53248;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__ = function(state_53222){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____1.call(this,state_53222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___53240,out))
})();
var state__2599__auto__ = (function (){var statearr_53239 = f__2598__auto__.call(null);
(statearr_53239[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___53240);

return statearr_53239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___53240,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__53249,opts){
var map__53253 = p__53249;
var map__53253__$1 = ((((!((map__53253 == null)))?((((map__53253.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53253.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53253):map__53253);
var eval_body = cljs.core.get.call(null,map__53253__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__53253__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__11272__auto__ = eval_body;
if(cljs.core.truth_(and__11272__auto__)){
return typeof eval_body === 'string';
} else {
return and__11272__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e53255){var e = e53255;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__53256_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__53256_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__53265){
var vec__53266 = p__53265;
var k = cljs.core.nth.call(null,vec__53266,(0),null);
var v = cljs.core.nth.call(null,vec__53266,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__53269){
var vec__53270 = p__53269;
var k = cljs.core.nth.call(null,vec__53270,(0),null);
var v = cljs.core.nth.call(null,vec__53270,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__53276,p__53277){
var map__53525 = p__53276;
var map__53525__$1 = ((((!((map__53525 == null)))?((((map__53525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53525.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53525):map__53525);
var opts = map__53525__$1;
var before_jsload = cljs.core.get.call(null,map__53525__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__53525__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__53525__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__53526 = p__53277;
var map__53526__$1 = ((((!((map__53526 == null)))?((((map__53526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53526.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53526):map__53526);
var msg = map__53526__$1;
var files = cljs.core.get.call(null,map__53526__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__53526__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__53526__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_53680){
var state_val_53681 = (state_53680[(1)]);
if((state_val_53681 === (7))){
var inst_53541 = (state_53680[(7)]);
var inst_53543 = (state_53680[(8)]);
var inst_53542 = (state_53680[(9)]);
var inst_53540 = (state_53680[(10)]);
var inst_53548 = cljs.core._nth.call(null,inst_53541,inst_53543);
var inst_53549 = figwheel.client.file_reloading.eval_body.call(null,inst_53548,opts);
var inst_53550 = (inst_53543 + (1));
var tmp53682 = inst_53541;
var tmp53683 = inst_53542;
var tmp53684 = inst_53540;
var inst_53540__$1 = tmp53684;
var inst_53541__$1 = tmp53682;
var inst_53542__$1 = tmp53683;
var inst_53543__$1 = inst_53550;
var state_53680__$1 = (function (){var statearr_53685 = state_53680;
(statearr_53685[(7)] = inst_53541__$1);

(statearr_53685[(8)] = inst_53543__$1);

(statearr_53685[(11)] = inst_53549);

(statearr_53685[(9)] = inst_53542__$1);

(statearr_53685[(10)] = inst_53540__$1);

return statearr_53685;
})();
var statearr_53686_53772 = state_53680__$1;
(statearr_53686_53772[(2)] = null);

(statearr_53686_53772[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (20))){
var inst_53583 = (state_53680[(12)]);
var inst_53591 = figwheel.client.file_reloading.sort_files.call(null,inst_53583);
var state_53680__$1 = state_53680;
var statearr_53687_53773 = state_53680__$1;
(statearr_53687_53773[(2)] = inst_53591);

(statearr_53687_53773[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (27))){
var state_53680__$1 = state_53680;
var statearr_53688_53774 = state_53680__$1;
(statearr_53688_53774[(2)] = null);

(statearr_53688_53774[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (1))){
var inst_53532 = (state_53680[(13)]);
var inst_53529 = before_jsload.call(null,files);
var inst_53530 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_53531 = (function (){return ((function (inst_53532,inst_53529,inst_53530,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__53273_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__53273_SHARP_);
});
;})(inst_53532,inst_53529,inst_53530,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53532__$1 = cljs.core.filter.call(null,inst_53531,files);
var inst_53533 = cljs.core.not_empty.call(null,inst_53532__$1);
var state_53680__$1 = (function (){var statearr_53689 = state_53680;
(statearr_53689[(14)] = inst_53530);

(statearr_53689[(15)] = inst_53529);

(statearr_53689[(13)] = inst_53532__$1);

return statearr_53689;
})();
if(cljs.core.truth_(inst_53533)){
var statearr_53690_53775 = state_53680__$1;
(statearr_53690_53775[(1)] = (2));

} else {
var statearr_53691_53776 = state_53680__$1;
(statearr_53691_53776[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (24))){
var state_53680__$1 = state_53680;
var statearr_53692_53777 = state_53680__$1;
(statearr_53692_53777[(2)] = null);

(statearr_53692_53777[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (39))){
var inst_53633 = (state_53680[(16)]);
var state_53680__$1 = state_53680;
var statearr_53693_53778 = state_53680__$1;
(statearr_53693_53778[(2)] = inst_53633);

(statearr_53693_53778[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (46))){
var inst_53675 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53694_53779 = state_53680__$1;
(statearr_53694_53779[(2)] = inst_53675);

(statearr_53694_53779[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (4))){
var inst_53577 = (state_53680[(2)]);
var inst_53578 = cljs.core.List.EMPTY;
var inst_53579 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_53578);
var inst_53580 = (function (){return ((function (inst_53577,inst_53578,inst_53579,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__53274_SHARP_){
var and__11272__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__53274_SHARP_);
if(cljs.core.truth_(and__11272__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__53274_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__53274_SHARP_)));
} else {
return and__11272__auto__;
}
});
;})(inst_53577,inst_53578,inst_53579,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53581 = cljs.core.filter.call(null,inst_53580,files);
var inst_53582 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_53583 = cljs.core.concat.call(null,inst_53581,inst_53582);
var state_53680__$1 = (function (){var statearr_53695 = state_53680;
(statearr_53695[(12)] = inst_53583);

(statearr_53695[(17)] = inst_53579);

(statearr_53695[(18)] = inst_53577);

return statearr_53695;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_53696_53780 = state_53680__$1;
(statearr_53696_53780[(1)] = (16));

} else {
var statearr_53697_53781 = state_53680__$1;
(statearr_53697_53781[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (15))){
var inst_53567 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53698_53782 = state_53680__$1;
(statearr_53698_53782[(2)] = inst_53567);

(statearr_53698_53782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (21))){
var inst_53593 = (state_53680[(19)]);
var inst_53593__$1 = (state_53680[(2)]);
var inst_53594 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_53593__$1);
var state_53680__$1 = (function (){var statearr_53699 = state_53680;
(statearr_53699[(19)] = inst_53593__$1);

return statearr_53699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53680__$1,(22),inst_53594);
} else {
if((state_val_53681 === (31))){
var inst_53678 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53680__$1,inst_53678);
} else {
if((state_val_53681 === (32))){
var inst_53633 = (state_53680[(16)]);
var inst_53638 = inst_53633.cljs$lang$protocol_mask$partition0$;
var inst_53639 = (inst_53638 & (64));
var inst_53640 = inst_53633.cljs$core$ISeq$;
var inst_53641 = (cljs.core.PROTOCOL_SENTINEL === inst_53640);
var inst_53642 = (inst_53639) || (inst_53641);
var state_53680__$1 = state_53680;
if(cljs.core.truth_(inst_53642)){
var statearr_53700_53783 = state_53680__$1;
(statearr_53700_53783[(1)] = (35));

} else {
var statearr_53701_53784 = state_53680__$1;
(statearr_53701_53784[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (40))){
var inst_53655 = (state_53680[(20)]);
var inst_53654 = (state_53680[(2)]);
var inst_53655__$1 = cljs.core.get.call(null,inst_53654,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_53656 = cljs.core.get.call(null,inst_53654,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_53657 = cljs.core.not_empty.call(null,inst_53655__$1);
var state_53680__$1 = (function (){var statearr_53702 = state_53680;
(statearr_53702[(20)] = inst_53655__$1);

(statearr_53702[(21)] = inst_53656);

return statearr_53702;
})();
if(cljs.core.truth_(inst_53657)){
var statearr_53703_53785 = state_53680__$1;
(statearr_53703_53785[(1)] = (41));

} else {
var statearr_53704_53786 = state_53680__$1;
(statearr_53704_53786[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (33))){
var state_53680__$1 = state_53680;
var statearr_53705_53787 = state_53680__$1;
(statearr_53705_53787[(2)] = false);

(statearr_53705_53787[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (13))){
var inst_53553 = (state_53680[(22)]);
var inst_53557 = cljs.core.chunk_first.call(null,inst_53553);
var inst_53558 = cljs.core.chunk_rest.call(null,inst_53553);
var inst_53559 = cljs.core.count.call(null,inst_53557);
var inst_53540 = inst_53558;
var inst_53541 = inst_53557;
var inst_53542 = inst_53559;
var inst_53543 = (0);
var state_53680__$1 = (function (){var statearr_53706 = state_53680;
(statearr_53706[(7)] = inst_53541);

(statearr_53706[(8)] = inst_53543);

(statearr_53706[(9)] = inst_53542);

(statearr_53706[(10)] = inst_53540);

return statearr_53706;
})();
var statearr_53707_53788 = state_53680__$1;
(statearr_53707_53788[(2)] = null);

(statearr_53707_53788[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (22))){
var inst_53601 = (state_53680[(23)]);
var inst_53597 = (state_53680[(24)]);
var inst_53596 = (state_53680[(25)]);
var inst_53593 = (state_53680[(19)]);
var inst_53596__$1 = (state_53680[(2)]);
var inst_53597__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_53596__$1);
var inst_53598 = (function (){var all_files = inst_53593;
var res_SINGLEQUOTE_ = inst_53596__$1;
var res = inst_53597__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_53601,inst_53597,inst_53596,inst_53593,inst_53596__$1,inst_53597__$1,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__53275_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__53275_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_53601,inst_53597,inst_53596,inst_53593,inst_53596__$1,inst_53597__$1,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53599 = cljs.core.filter.call(null,inst_53598,inst_53596__$1);
var inst_53600 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_53601__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_53600);
var inst_53602 = cljs.core.not_empty.call(null,inst_53601__$1);
var state_53680__$1 = (function (){var statearr_53708 = state_53680;
(statearr_53708[(23)] = inst_53601__$1);

(statearr_53708[(24)] = inst_53597__$1);

(statearr_53708[(25)] = inst_53596__$1);

(statearr_53708[(26)] = inst_53599);

return statearr_53708;
})();
if(cljs.core.truth_(inst_53602)){
var statearr_53709_53789 = state_53680__$1;
(statearr_53709_53789[(1)] = (23));

} else {
var statearr_53710_53790 = state_53680__$1;
(statearr_53710_53790[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (36))){
var state_53680__$1 = state_53680;
var statearr_53711_53791 = state_53680__$1;
(statearr_53711_53791[(2)] = false);

(statearr_53711_53791[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (41))){
var inst_53655 = (state_53680[(20)]);
var inst_53659 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_53660 = cljs.core.map.call(null,inst_53659,inst_53655);
var inst_53661 = cljs.core.pr_str.call(null,inst_53660);
var inst_53662 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53661)].join('');
var inst_53663 = figwheel.client.utils.log.call(null,inst_53662);
var state_53680__$1 = state_53680;
var statearr_53712_53792 = state_53680__$1;
(statearr_53712_53792[(2)] = inst_53663);

(statearr_53712_53792[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (43))){
var inst_53656 = (state_53680[(21)]);
var inst_53666 = (state_53680[(2)]);
var inst_53667 = cljs.core.not_empty.call(null,inst_53656);
var state_53680__$1 = (function (){var statearr_53713 = state_53680;
(statearr_53713[(27)] = inst_53666);

return statearr_53713;
})();
if(cljs.core.truth_(inst_53667)){
var statearr_53714_53793 = state_53680__$1;
(statearr_53714_53793[(1)] = (44));

} else {
var statearr_53715_53794 = state_53680__$1;
(statearr_53715_53794[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (29))){
var inst_53601 = (state_53680[(23)]);
var inst_53597 = (state_53680[(24)]);
var inst_53596 = (state_53680[(25)]);
var inst_53599 = (state_53680[(26)]);
var inst_53633 = (state_53680[(16)]);
var inst_53593 = (state_53680[(19)]);
var inst_53629 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_53632 = (function (){var all_files = inst_53593;
var res_SINGLEQUOTE_ = inst_53596;
var res = inst_53597;
var files_not_loaded = inst_53599;
var dependencies_that_loaded = inst_53601;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53633,inst_53593,inst_53629,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__53631){
var map__53716 = p__53631;
var map__53716__$1 = ((((!((map__53716 == null)))?((((map__53716.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53716.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53716):map__53716);
var namespace = cljs.core.get.call(null,map__53716__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53633,inst_53593,inst_53629,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53633__$1 = cljs.core.group_by.call(null,inst_53632,inst_53599);
var inst_53635 = (inst_53633__$1 == null);
var inst_53636 = cljs.core.not.call(null,inst_53635);
var state_53680__$1 = (function (){var statearr_53718 = state_53680;
(statearr_53718[(28)] = inst_53629);

(statearr_53718[(16)] = inst_53633__$1);

return statearr_53718;
})();
if(inst_53636){
var statearr_53719_53795 = state_53680__$1;
(statearr_53719_53795[(1)] = (32));

} else {
var statearr_53720_53796 = state_53680__$1;
(statearr_53720_53796[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (44))){
var inst_53656 = (state_53680[(21)]);
var inst_53669 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_53656);
var inst_53670 = cljs.core.pr_str.call(null,inst_53669);
var inst_53671 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53670)].join('');
var inst_53672 = figwheel.client.utils.log.call(null,inst_53671);
var state_53680__$1 = state_53680;
var statearr_53721_53797 = state_53680__$1;
(statearr_53721_53797[(2)] = inst_53672);

(statearr_53721_53797[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (6))){
var inst_53574 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53722_53798 = state_53680__$1;
(statearr_53722_53798[(2)] = inst_53574);

(statearr_53722_53798[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (28))){
var inst_53599 = (state_53680[(26)]);
var inst_53626 = (state_53680[(2)]);
var inst_53627 = cljs.core.not_empty.call(null,inst_53599);
var state_53680__$1 = (function (){var statearr_53723 = state_53680;
(statearr_53723[(29)] = inst_53626);

return statearr_53723;
})();
if(cljs.core.truth_(inst_53627)){
var statearr_53724_53799 = state_53680__$1;
(statearr_53724_53799[(1)] = (29));

} else {
var statearr_53725_53800 = state_53680__$1;
(statearr_53725_53800[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (25))){
var inst_53597 = (state_53680[(24)]);
var inst_53613 = (state_53680[(2)]);
var inst_53614 = cljs.core.not_empty.call(null,inst_53597);
var state_53680__$1 = (function (){var statearr_53726 = state_53680;
(statearr_53726[(30)] = inst_53613);

return statearr_53726;
})();
if(cljs.core.truth_(inst_53614)){
var statearr_53727_53801 = state_53680__$1;
(statearr_53727_53801[(1)] = (26));

} else {
var statearr_53728_53802 = state_53680__$1;
(statearr_53728_53802[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (34))){
var inst_53649 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
if(cljs.core.truth_(inst_53649)){
var statearr_53729_53803 = state_53680__$1;
(statearr_53729_53803[(1)] = (38));

} else {
var statearr_53730_53804 = state_53680__$1;
(statearr_53730_53804[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (17))){
var state_53680__$1 = state_53680;
var statearr_53731_53805 = state_53680__$1;
(statearr_53731_53805[(2)] = recompile_dependents);

(statearr_53731_53805[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (3))){
var state_53680__$1 = state_53680;
var statearr_53732_53806 = state_53680__$1;
(statearr_53732_53806[(2)] = null);

(statearr_53732_53806[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (12))){
var inst_53570 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53733_53807 = state_53680__$1;
(statearr_53733_53807[(2)] = inst_53570);

(statearr_53733_53807[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (2))){
var inst_53532 = (state_53680[(13)]);
var inst_53539 = cljs.core.seq.call(null,inst_53532);
var inst_53540 = inst_53539;
var inst_53541 = null;
var inst_53542 = (0);
var inst_53543 = (0);
var state_53680__$1 = (function (){var statearr_53734 = state_53680;
(statearr_53734[(7)] = inst_53541);

(statearr_53734[(8)] = inst_53543);

(statearr_53734[(9)] = inst_53542);

(statearr_53734[(10)] = inst_53540);

return statearr_53734;
})();
var statearr_53735_53808 = state_53680__$1;
(statearr_53735_53808[(2)] = null);

(statearr_53735_53808[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (23))){
var inst_53601 = (state_53680[(23)]);
var inst_53597 = (state_53680[(24)]);
var inst_53596 = (state_53680[(25)]);
var inst_53599 = (state_53680[(26)]);
var inst_53593 = (state_53680[(19)]);
var inst_53604 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_53606 = (function (){var all_files = inst_53593;
var res_SINGLEQUOTE_ = inst_53596;
var res = inst_53597;
var files_not_loaded = inst_53599;
var dependencies_that_loaded = inst_53601;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53604,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__53605){
var map__53736 = p__53605;
var map__53736__$1 = ((((!((map__53736 == null)))?((((map__53736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53736.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53736):map__53736);
var request_url = cljs.core.get.call(null,map__53736__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53604,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53607 = cljs.core.reverse.call(null,inst_53601);
var inst_53608 = cljs.core.map.call(null,inst_53606,inst_53607);
var inst_53609 = cljs.core.pr_str.call(null,inst_53608);
var inst_53610 = figwheel.client.utils.log.call(null,inst_53609);
var state_53680__$1 = (function (){var statearr_53738 = state_53680;
(statearr_53738[(31)] = inst_53604);

return statearr_53738;
})();
var statearr_53739_53809 = state_53680__$1;
(statearr_53739_53809[(2)] = inst_53610);

(statearr_53739_53809[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (35))){
var state_53680__$1 = state_53680;
var statearr_53740_53810 = state_53680__$1;
(statearr_53740_53810[(2)] = true);

(statearr_53740_53810[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (19))){
var inst_53583 = (state_53680[(12)]);
var inst_53589 = figwheel.client.file_reloading.expand_files.call(null,inst_53583);
var state_53680__$1 = state_53680;
var statearr_53741_53811 = state_53680__$1;
(statearr_53741_53811[(2)] = inst_53589);

(statearr_53741_53811[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (11))){
var state_53680__$1 = state_53680;
var statearr_53742_53812 = state_53680__$1;
(statearr_53742_53812[(2)] = null);

(statearr_53742_53812[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (9))){
var inst_53572 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53743_53813 = state_53680__$1;
(statearr_53743_53813[(2)] = inst_53572);

(statearr_53743_53813[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (5))){
var inst_53543 = (state_53680[(8)]);
var inst_53542 = (state_53680[(9)]);
var inst_53545 = (inst_53543 < inst_53542);
var inst_53546 = inst_53545;
var state_53680__$1 = state_53680;
if(cljs.core.truth_(inst_53546)){
var statearr_53744_53814 = state_53680__$1;
(statearr_53744_53814[(1)] = (7));

} else {
var statearr_53745_53815 = state_53680__$1;
(statearr_53745_53815[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (14))){
var inst_53553 = (state_53680[(22)]);
var inst_53562 = cljs.core.first.call(null,inst_53553);
var inst_53563 = figwheel.client.file_reloading.eval_body.call(null,inst_53562,opts);
var inst_53564 = cljs.core.next.call(null,inst_53553);
var inst_53540 = inst_53564;
var inst_53541 = null;
var inst_53542 = (0);
var inst_53543 = (0);
var state_53680__$1 = (function (){var statearr_53746 = state_53680;
(statearr_53746[(7)] = inst_53541);

(statearr_53746[(8)] = inst_53543);

(statearr_53746[(9)] = inst_53542);

(statearr_53746[(10)] = inst_53540);

(statearr_53746[(32)] = inst_53563);

return statearr_53746;
})();
var statearr_53747_53816 = state_53680__$1;
(statearr_53747_53816[(2)] = null);

(statearr_53747_53816[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (45))){
var state_53680__$1 = state_53680;
var statearr_53748_53817 = state_53680__$1;
(statearr_53748_53817[(2)] = null);

(statearr_53748_53817[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (26))){
var inst_53601 = (state_53680[(23)]);
var inst_53597 = (state_53680[(24)]);
var inst_53596 = (state_53680[(25)]);
var inst_53599 = (state_53680[(26)]);
var inst_53593 = (state_53680[(19)]);
var inst_53616 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_53618 = (function (){var all_files = inst_53593;
var res_SINGLEQUOTE_ = inst_53596;
var res = inst_53597;
var files_not_loaded = inst_53599;
var dependencies_that_loaded = inst_53601;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53616,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__53617){
var map__53749 = p__53617;
var map__53749__$1 = ((((!((map__53749 == null)))?((((map__53749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53749.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53749):map__53749);
var namespace = cljs.core.get.call(null,map__53749__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__53749__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53616,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53619 = cljs.core.map.call(null,inst_53618,inst_53597);
var inst_53620 = cljs.core.pr_str.call(null,inst_53619);
var inst_53621 = figwheel.client.utils.log.call(null,inst_53620);
var inst_53622 = (function (){var all_files = inst_53593;
var res_SINGLEQUOTE_ = inst_53596;
var res = inst_53597;
var files_not_loaded = inst_53599;
var dependencies_that_loaded = inst_53601;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53616,inst_53618,inst_53619,inst_53620,inst_53621,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_53601,inst_53597,inst_53596,inst_53599,inst_53593,inst_53616,inst_53618,inst_53619,inst_53620,inst_53621,state_val_53681,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_53623 = setTimeout(inst_53622,(10));
var state_53680__$1 = (function (){var statearr_53751 = state_53680;
(statearr_53751[(33)] = inst_53621);

(statearr_53751[(34)] = inst_53616);

return statearr_53751;
})();
var statearr_53752_53818 = state_53680__$1;
(statearr_53752_53818[(2)] = inst_53623);

(statearr_53752_53818[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (16))){
var state_53680__$1 = state_53680;
var statearr_53753_53819 = state_53680__$1;
(statearr_53753_53819[(2)] = reload_dependents);

(statearr_53753_53819[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (38))){
var inst_53633 = (state_53680[(16)]);
var inst_53651 = cljs.core.apply.call(null,cljs.core.hash_map,inst_53633);
var state_53680__$1 = state_53680;
var statearr_53754_53820 = state_53680__$1;
(statearr_53754_53820[(2)] = inst_53651);

(statearr_53754_53820[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (30))){
var state_53680__$1 = state_53680;
var statearr_53755_53821 = state_53680__$1;
(statearr_53755_53821[(2)] = null);

(statearr_53755_53821[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (10))){
var inst_53553 = (state_53680[(22)]);
var inst_53555 = cljs.core.chunked_seq_QMARK_.call(null,inst_53553);
var state_53680__$1 = state_53680;
if(inst_53555){
var statearr_53756_53822 = state_53680__$1;
(statearr_53756_53822[(1)] = (13));

} else {
var statearr_53757_53823 = state_53680__$1;
(statearr_53757_53823[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (18))){
var inst_53587 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
if(cljs.core.truth_(inst_53587)){
var statearr_53758_53824 = state_53680__$1;
(statearr_53758_53824[(1)] = (19));

} else {
var statearr_53759_53825 = state_53680__$1;
(statearr_53759_53825[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (42))){
var state_53680__$1 = state_53680;
var statearr_53760_53826 = state_53680__$1;
(statearr_53760_53826[(2)] = null);

(statearr_53760_53826[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (37))){
var inst_53646 = (state_53680[(2)]);
var state_53680__$1 = state_53680;
var statearr_53761_53827 = state_53680__$1;
(statearr_53761_53827[(2)] = inst_53646);

(statearr_53761_53827[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53681 === (8))){
var inst_53553 = (state_53680[(22)]);
var inst_53540 = (state_53680[(10)]);
var inst_53553__$1 = cljs.core.seq.call(null,inst_53540);
var state_53680__$1 = (function (){var statearr_53762 = state_53680;
(statearr_53762[(22)] = inst_53553__$1);

return statearr_53762;
})();
if(inst_53553__$1){
var statearr_53763_53828 = state_53680__$1;
(statearr_53763_53828[(1)] = (10));

} else {
var statearr_53764_53829 = state_53680__$1;
(statearr_53764_53829[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__2483__auto__,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____0 = (function (){
var statearr_53768 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53768[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__);

(statearr_53768[(1)] = (1));

return statearr_53768;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____1 = (function (state_53680){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_53680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e53769){if((e53769 instanceof Object)){
var ex__2487__auto__ = e53769;
var statearr_53770_53830 = state_53680;
(statearr_53770_53830[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53831 = state_53680;
state_53680 = G__53831;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__ = function(state_53680){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____1.call(this,state_53680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__2599__auto__ = (function (){var statearr_53771 = f__2598__auto__.call(null);
(statearr_53771[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_53771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__,map__53525,map__53525__$1,opts,before_jsload,on_jsload,reload_dependents,map__53526,map__53526__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__2597__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__53834,link){
var map__53837 = p__53834;
var map__53837__$1 = ((((!((map__53837 == null)))?((((map__53837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53837.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53837):map__53837);
var file = cljs.core.get.call(null,map__53837__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__53837,map__53837__$1,file){
return (function (p1__53832_SHARP_,p2__53833_SHARP_){
if(cljs.core._EQ_.call(null,p1__53832_SHARP_,p2__53833_SHARP_)){
return p1__53832_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__53837,map__53837__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__53843){
var map__53844 = p__53843;
var map__53844__$1 = ((((!((map__53844 == null)))?((((map__53844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53844.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53844):map__53844);
var match_length = cljs.core.get.call(null,map__53844__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__53844__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__53839_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__53839_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__53846_SHARP_,p2__53847_SHARP_){
return cljs.core.assoc.call(null,p1__53846_SHARP_,cljs.core.get.call(null,p2__53847_SHARP_,key),p2__53847_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_53848 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_53848);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_53848);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__53849,p__53850){
var map__53855 = p__53849;
var map__53855__$1 = ((((!((map__53855 == null)))?((((map__53855.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53855.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53855):map__53855);
var on_cssload = cljs.core.get.call(null,map__53855__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__53856 = p__53850;
var map__53856__$1 = ((((!((map__53856 == null)))?((((map__53856.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53856.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53856):map__53856);
var files_msg = map__53856__$1;
var files = cljs.core.get.call(null,map__53856__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1486495666454