// Compiled by ClojureScript 1.9.456 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy.core.recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__61187 = h;
G__61187.setUseFragment(false);

G__61187.setPathPrefix("");

G__61187.setEnabled(true);

return G__61187;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.pathname),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args61188 = [];
var len__11929__auto___61191 = arguments.length;
var i__11930__auto___61192 = (0);
while(true){
if((i__11930__auto___61192 < len__11929__auto___61191)){
args61188.push((arguments[i__11930__auto___61192]));

var G__61193 = (i__11930__auto___61192 + (1));
i__11930__auto___61192 = G__61193;
continue;
} else {
}
break;
}

var G__61190 = args61188.length;
switch (G__61190) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args61188.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;


/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args61195 = [];
var len__11929__auto___61201 = arguments.length;
var i__11930__auto___61202 = (0);
while(true){
if((i__11930__auto___61202 < len__11929__auto___61201)){
args61195.push((arguments[i__11930__auto___61202]));

var G__61203 = (i__11930__auto___61202 + (1));
i__11930__auto___61202 = G__61203;
continue;
} else {
}
break;
}

var G__61197 = args61195.length;
switch (G__61197) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args61195.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,token);
} else {
var m__11611__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,token,title);
} else {
var m__11611__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args61198 = [];
var len__11929__auto___61205 = arguments.length;
var i__11930__auto___61206 = (0);
while(true){
if((i__11930__auto___61206 < len__11929__auto___61205)){
args61198.push((arguments[i__11930__auto___61206]));

var G__61207 = (i__11930__auto___61206 + (1));
i__11930__auto___61206 = G__61207;
continue;
} else {
}
break;
}

var G__61200 = args61198.length;
switch (G__61200) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args61198.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,token);
} else {
var m__11611__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,token,title);
} else {
var m__11611__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.get_token[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$);
} else {
var m__11611__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$);
} else {
var m__11611__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$);
} else {
var m__11611__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (!((cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.origin),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*$")].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri)].join('')) == null))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__11932__auto__ = [];
var len__11929__auto___61222 = arguments.length;
var i__11930__auto___61223 = (0);
while(true){
if((i__11930__auto___61223 < len__11929__auto___61222)){
args__11932__auto__.push((arguments[i__11930__auto___61223]));

var G__61224 = (i__11930__auto___61223 + (1));
i__11930__auto___61223 = G__61224;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((2) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__11933__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__61212){
var map__61213 = p__61212;
var map__61213__$1 = ((((!((map__61213 == null)))?((((map__61213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61213.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61213):map__61213);
var processable_url_QMARK_ = cljs.core.get.call(null,map__61213__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__61213__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core61215 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core61215 = (function (dispatch_fn,match_fn,p__61212,map__61213,processable_url_QMARK_,identity_fn,history,event_keys,meta61216){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__61212 = p__61212;
this.map__61213 = map__61213;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta61216 = meta61216;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

pushy.core.t_pushy$core61215.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_61217,meta61216__$1){
var self__ = this;
var _61217__$1 = this;
return (new pushy.core.t_pushy$core61215(self__.dispatch_fn,self__.match_fn,self__.p__61212,self__.map__61213,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta61216__$1));
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_61217){
var self__ = this;
var _61217__$1 = this;
return self__.meta61216;
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$ = cljs.core.PROTOCOL_SENTINEL;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__6753__auto__)){
var match = temp__6753__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
));

var temp__6753__auto___61225 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__6753__auto___61225)){
var match_61226 = temp__6753__auto___61225;
self__.dispatch_fn.call(null,match_61226);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__6753__auto__)){
var el = temp__6753__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__11272__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__11272__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__11272__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__6751__auto___61227 = el.title;
if(cljs.core.truth_(temp__6751__auto___61227)){
var title_61228 = temp__6751__auto___61227;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_61228);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core61215.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__61218_61229 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__61219_61230 = null;
var count__61220_61231 = (0);
var i__61221_61232 = (0);
while(true){
if((i__61221_61232 < count__61220_61231)){
var key_61233 = cljs.core._nth.call(null,chunk__61219_61230,i__61221_61232);
goog.events.unlistenByKey(key_61233);

var G__61234 = seq__61218_61229;
var G__61235 = chunk__61219_61230;
var G__61236 = count__61220_61231;
var G__61237 = (i__61221_61232 + (1));
seq__61218_61229 = G__61234;
chunk__61219_61230 = G__61235;
count__61220_61231 = G__61236;
i__61221_61232 = G__61237;
continue;
} else {
var temp__6753__auto___61238 = cljs.core.seq.call(null,seq__61218_61229);
if(temp__6753__auto___61238){
var seq__61218_61239__$1 = temp__6753__auto___61238;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61218_61239__$1)){
var c__11759__auto___61240 = cljs.core.chunk_first.call(null,seq__61218_61239__$1);
var G__61241 = cljs.core.chunk_rest.call(null,seq__61218_61239__$1);
var G__61242 = c__11759__auto___61240;
var G__61243 = cljs.core.count.call(null,c__11759__auto___61240);
var G__61244 = (0);
seq__61218_61229 = G__61241;
chunk__61219_61230 = G__61242;
count__61220_61231 = G__61243;
i__61221_61232 = G__61244;
continue;
} else {
var key_61245 = cljs.core.first.call(null,seq__61218_61239__$1);
goog.events.unlistenByKey(key_61245);

var G__61246 = cljs.core.next.call(null,seq__61218_61239__$1);
var G__61247 = null;
var G__61248 = (0);
var G__61249 = (0);
seq__61218_61229 = G__61246;
chunk__61219_61230 = G__61247;
count__61220_61231 = G__61248;
i__61221_61232 = G__61249;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core61215.getBasis = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__61212","p__61212",-738423771,null),new cljs.core.Symbol(null,"map__61213","map__61213",-726107963,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta61216","meta61216",-395608609,null)], null);
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core61215.cljs$lang$type = true;

pushy.core.t_pushy$core61215.cljs$lang$ctorStr = "pushy.core/t_pushy$core61215";

pushy.core.t_pushy$core61215.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function (this__11557__auto__,writer__11558__auto__,opt__11559__auto__){
return cljs.core._write.call(null,writer__11558__auto__,"pushy.core/t_pushy$core61215");
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core61215 = ((function (history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core61215(dispatch_fn__$1,match_fn__$1,p__61212__$1,map__61213__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta61216){
return (new pushy.core.t_pushy$core61215(dispatch_fn__$1,match_fn__$1,p__61212__$1,map__61213__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta61216));
});})(history,event_keys,map__61213,map__61213__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core61215(dispatch_fn,match_fn,p__61212,map__61213__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq61209){
var G__61210 = cljs.core.first.call(null,seq61209);
var seq61209__$1 = cljs.core.next.call(null,seq61209);
var G__61211 = cljs.core.first.call(null,seq61209__$1);
var seq61209__$2 = cljs.core.next.call(null,seq61209__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__61210,G__61211,seq61209__$2);
});

/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args61250 = [];
var len__11929__auto___61253 = arguments.length;
var i__11930__auto___61254 = (0);
while(true){
if((i__11930__auto___61254 < len__11929__auto___61253)){
args61250.push((arguments[i__11930__auto___61254]));

var G__61255 = (i__11930__auto___61254 + (1));
i__11930__auto___61254 = G__61255;
continue;
} else {
}
break;
}

var G__61252 = args61250.length;
switch (G__61252) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args61250.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;

pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args61257 = [];
var len__11929__auto___61260 = arguments.length;
var i__11930__auto___61261 = (0);
while(true){
if((i__11930__auto___61261 < len__11929__auto___61260)){
args61257.push((arguments[i__11930__auto___61261]));

var G__61262 = (i__11930__auto___61261 + (1));
i__11930__auto___61261 = G__61262;
continue;
} else {
}
break;
}

var G__61259 = args61257.length;
switch (G__61259) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args61257.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1486495679859