// Compiled by ClojureScript 1.9.456 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__63151__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__63148 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__63149 = cljs.core.seq.call(null,vec__63148);
var first__63150 = cljs.core.first.call(null,seq__63149);
var seq__63149__$1 = cljs.core.next.call(null,seq__63149);
var tag = first__63150;
var body = seq__63149__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__63151 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__63152__i = 0, G__63152__a = new Array(arguments.length -  0);
while (G__63152__i < G__63152__a.length) {G__63152__a[G__63152__i] = arguments[G__63152__i + 0]; ++G__63152__i;}
  args = new cljs.core.IndexedSeq(G__63152__a,0);
} 
return G__63151__delegate.call(this,args);};
G__63151.cljs$lang$maxFixedArity = 0;
G__63151.cljs$lang$applyTo = (function (arglist__63153){
var args = cljs.core.seq(arglist__63153);
return G__63151__delegate(args);
});
G__63151.cljs$core$IFn$_invoke$arity$variadic = G__63151__delegate;
return G__63151;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__11714__auto__ = (function sablono$core$update_arglists_$_iter__63158(s__63159){
return (new cljs.core.LazySeq(null,(function (){
var s__63159__$1 = s__63159;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__63159__$1);
if(temp__6753__auto__){
var s__63159__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63159__$2)){
var c__11712__auto__ = cljs.core.chunk_first.call(null,s__63159__$2);
var size__11713__auto__ = cljs.core.count.call(null,c__11712__auto__);
var b__63161 = cljs.core.chunk_buffer.call(null,size__11713__auto__);
if((function (){var i__63160 = (0);
while(true){
if((i__63160 < size__11713__auto__)){
var args = cljs.core._nth.call(null,c__11712__auto__,i__63160);
cljs.core.chunk_append.call(null,b__63161,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__63162 = (i__63160 + (1));
i__63160 = G__63162;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63161),sablono$core$update_arglists_$_iter__63158.call(null,cljs.core.chunk_rest.call(null,s__63159__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63161),null);
}
} else {
var args = cljs.core.first.call(null,s__63159__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__63158.call(null,cljs.core.rest.call(null,s__63159__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__11714__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63168 = arguments.length;
var i__11930__auto___63169 = (0);
while(true){
if((i__11930__auto___63169 < len__11929__auto___63168)){
args__11932__auto__.push((arguments[i__11930__auto___63169]));

var G__63170 = (i__11930__auto___63169 + (1));
i__11930__auto___63169 = G__63170;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((0) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__11933__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__11714__auto__ = (function sablono$core$iter__63164(s__63165){
return (new cljs.core.LazySeq(null,(function (){
var s__63165__$1 = s__63165;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__63165__$1);
if(temp__6753__auto__){
var s__63165__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63165__$2)){
var c__11712__auto__ = cljs.core.chunk_first.call(null,s__63165__$2);
var size__11713__auto__ = cljs.core.count.call(null,c__11712__auto__);
var b__63167 = cljs.core.chunk_buffer.call(null,size__11713__auto__);
if((function (){var i__63166 = (0);
while(true){
if((i__63166 < size__11713__auto__)){
var style = cljs.core._nth.call(null,c__11712__auto__,i__63166);
cljs.core.chunk_append.call(null,b__63167,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__63171 = (i__63166 + (1));
i__63166 = G__63171;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63167),sablono$core$iter__63164.call(null,cljs.core.chunk_rest.call(null,s__63165__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63167),null);
}
} else {
var style = cljs.core.first.call(null,s__63165__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__63164.call(null,cljs.core.rest.call(null,s__63165__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__11714__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq63163){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq63163));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to63172 = (function sablono$core$link_to63172(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63175 = arguments.length;
var i__11930__auto___63176 = (0);
while(true){
if((i__11930__auto___63176 < len__11929__auto___63175)){
args__11932__auto__.push((arguments[i__11930__auto___63176]));

var G__63177 = (i__11930__auto___63176 + (1));
i__11930__auto___63176 = G__63177;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to63172.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

sablono.core.link_to63172.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to63172.cljs$lang$maxFixedArity = (1);

sablono.core.link_to63172.cljs$lang$applyTo = (function (seq63173){
var G__63174 = cljs.core.first.call(null,seq63173);
var seq63173__$1 = cljs.core.next.call(null,seq63173);
return sablono.core.link_to63172.cljs$core$IFn$_invoke$arity$variadic(G__63174,seq63173__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to63172);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to63178 = (function sablono$core$mail_to63178(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63185 = arguments.length;
var i__11930__auto___63186 = (0);
while(true){
if((i__11930__auto___63186 < len__11929__auto___63185)){
args__11932__auto__.push((arguments[i__11930__auto___63186]));

var G__63187 = (i__11930__auto___63186 + (1));
i__11930__auto___63186 = G__63187;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to63178.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

sablono.core.mail_to63178.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__63181){
var vec__63182 = p__63181;
var content = cljs.core.nth.call(null,vec__63182,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__11280__auto__ = content;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to63178.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to63178.cljs$lang$applyTo = (function (seq63179){
var G__63180 = cljs.core.first.call(null,seq63179);
var seq63179__$1 = cljs.core.next.call(null,seq63179);
return sablono.core.mail_to63178.cljs$core$IFn$_invoke$arity$variadic(G__63180,seq63179__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to63178);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list63188 = (function sablono$core$unordered_list63188(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__11714__auto__ = (function sablono$core$unordered_list63188_$_iter__63193(s__63194){
return (new cljs.core.LazySeq(null,(function (){
var s__63194__$1 = s__63194;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__63194__$1);
if(temp__6753__auto__){
var s__63194__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63194__$2)){
var c__11712__auto__ = cljs.core.chunk_first.call(null,s__63194__$2);
var size__11713__auto__ = cljs.core.count.call(null,c__11712__auto__);
var b__63196 = cljs.core.chunk_buffer.call(null,size__11713__auto__);
if((function (){var i__63195 = (0);
while(true){
if((i__63195 < size__11713__auto__)){
var x = cljs.core._nth.call(null,c__11712__auto__,i__63195);
cljs.core.chunk_append.call(null,b__63196,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__63197 = (i__63195 + (1));
i__63195 = G__63197;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63196),sablono$core$unordered_list63188_$_iter__63193.call(null,cljs.core.chunk_rest.call(null,s__63194__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63196),null);
}
} else {
var x = cljs.core.first.call(null,s__63194__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list63188_$_iter__63193.call(null,cljs.core.rest.call(null,s__63194__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__11714__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list63188);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list63198 = (function sablono$core$ordered_list63198(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__11714__auto__ = (function sablono$core$ordered_list63198_$_iter__63203(s__63204){
return (new cljs.core.LazySeq(null,(function (){
var s__63204__$1 = s__63204;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__63204__$1);
if(temp__6753__auto__){
var s__63204__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63204__$2)){
var c__11712__auto__ = cljs.core.chunk_first.call(null,s__63204__$2);
var size__11713__auto__ = cljs.core.count.call(null,c__11712__auto__);
var b__63206 = cljs.core.chunk_buffer.call(null,size__11713__auto__);
if((function (){var i__63205 = (0);
while(true){
if((i__63205 < size__11713__auto__)){
var x = cljs.core._nth.call(null,c__11712__auto__,i__63205);
cljs.core.chunk_append.call(null,b__63206,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__63207 = (i__63205 + (1));
i__63205 = G__63207;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63206),sablono$core$ordered_list63198_$_iter__63203.call(null,cljs.core.chunk_rest.call(null,s__63204__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63206),null);
}
} else {
var x = cljs.core.first.call(null,s__63204__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list63198_$_iter__63203.call(null,cljs.core.rest.call(null,s__63204__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__11714__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list63198);
/**
 * Create an image element.
 */
sablono.core.image63208 = (function sablono$core$image63208(var_args){
var args63209 = [];
var len__11929__auto___63212 = arguments.length;
var i__11930__auto___63213 = (0);
while(true){
if((i__11930__auto___63213 < len__11929__auto___63212)){
args63209.push((arguments[i__11930__auto___63213]));

var G__63214 = (i__11930__auto___63213 + (1));
i__11930__auto___63213 = G__63214;
continue;
} else {
}
break;
}

var G__63211 = args63209.length;
switch (G__63211) {
case 1:
return sablono.core.image63208.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image63208.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63209.length)].join('')));

}
});

sablono.core.image63208.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image63208.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image63208.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image63208);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__63216_SHARP_,p2__63217_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__63216_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__63217_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__63218_SHARP_,p2__63219_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__63218_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__63219_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__11280__auto__ = value;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field63220 = (function sablono$core$color_field63220(var_args){
var args63221 = [];
var len__11929__auto___63288 = arguments.length;
var i__11930__auto___63289 = (0);
while(true){
if((i__11930__auto___63289 < len__11929__auto___63288)){
args63221.push((arguments[i__11930__auto___63289]));

var G__63290 = (i__11930__auto___63289 + (1));
i__11930__auto___63289 = G__63290;
continue;
} else {
}
break;
}

var G__63223 = args63221.length;
switch (G__63223) {
case 1:
return sablono.core.color_field63220.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field63220.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63221.length)].join('')));

}
});

sablono.core.color_field63220.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.color_field63220.call(null,name__19069__auto__,null);
});

sablono.core.color_field63220.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.color_field63220.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field63220);

/**
 * Creates a date input field.
 */
sablono.core.date_field63224 = (function sablono$core$date_field63224(var_args){
var args63225 = [];
var len__11929__auto___63292 = arguments.length;
var i__11930__auto___63293 = (0);
while(true){
if((i__11930__auto___63293 < len__11929__auto___63292)){
args63225.push((arguments[i__11930__auto___63293]));

var G__63294 = (i__11930__auto___63293 + (1));
i__11930__auto___63293 = G__63294;
continue;
} else {
}
break;
}

var G__63227 = args63225.length;
switch (G__63227) {
case 1:
return sablono.core.date_field63224.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field63224.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63225.length)].join('')));

}
});

sablono.core.date_field63224.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.date_field63224.call(null,name__19069__auto__,null);
});

sablono.core.date_field63224.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.date_field63224.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field63224);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field63228 = (function sablono$core$datetime_field63228(var_args){
var args63229 = [];
var len__11929__auto___63296 = arguments.length;
var i__11930__auto___63297 = (0);
while(true){
if((i__11930__auto___63297 < len__11929__auto___63296)){
args63229.push((arguments[i__11930__auto___63297]));

var G__63298 = (i__11930__auto___63297 + (1));
i__11930__auto___63297 = G__63298;
continue;
} else {
}
break;
}

var G__63231 = args63229.length;
switch (G__63231) {
case 1:
return sablono.core.datetime_field63228.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field63228.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63229.length)].join('')));

}
});

sablono.core.datetime_field63228.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.datetime_field63228.call(null,name__19069__auto__,null);
});

sablono.core.datetime_field63228.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.datetime_field63228.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field63228);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field63232 = (function sablono$core$datetime_local_field63232(var_args){
var args63233 = [];
var len__11929__auto___63300 = arguments.length;
var i__11930__auto___63301 = (0);
while(true){
if((i__11930__auto___63301 < len__11929__auto___63300)){
args63233.push((arguments[i__11930__auto___63301]));

var G__63302 = (i__11930__auto___63301 + (1));
i__11930__auto___63301 = G__63302;
continue;
} else {
}
break;
}

var G__63235 = args63233.length;
switch (G__63235) {
case 1:
return sablono.core.datetime_local_field63232.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field63232.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63233.length)].join('')));

}
});

sablono.core.datetime_local_field63232.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.datetime_local_field63232.call(null,name__19069__auto__,null);
});

sablono.core.datetime_local_field63232.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.datetime_local_field63232.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field63232);

/**
 * Creates a email input field.
 */
sablono.core.email_field63236 = (function sablono$core$email_field63236(var_args){
var args63237 = [];
var len__11929__auto___63304 = arguments.length;
var i__11930__auto___63305 = (0);
while(true){
if((i__11930__auto___63305 < len__11929__auto___63304)){
args63237.push((arguments[i__11930__auto___63305]));

var G__63306 = (i__11930__auto___63305 + (1));
i__11930__auto___63305 = G__63306;
continue;
} else {
}
break;
}

var G__63239 = args63237.length;
switch (G__63239) {
case 1:
return sablono.core.email_field63236.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field63236.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63237.length)].join('')));

}
});

sablono.core.email_field63236.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.email_field63236.call(null,name__19069__auto__,null);
});

sablono.core.email_field63236.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.email_field63236.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field63236);

/**
 * Creates a file input field.
 */
sablono.core.file_field63240 = (function sablono$core$file_field63240(var_args){
var args63241 = [];
var len__11929__auto___63308 = arguments.length;
var i__11930__auto___63309 = (0);
while(true){
if((i__11930__auto___63309 < len__11929__auto___63308)){
args63241.push((arguments[i__11930__auto___63309]));

var G__63310 = (i__11930__auto___63309 + (1));
i__11930__auto___63309 = G__63310;
continue;
} else {
}
break;
}

var G__63243 = args63241.length;
switch (G__63243) {
case 1:
return sablono.core.file_field63240.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field63240.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63241.length)].join('')));

}
});

sablono.core.file_field63240.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.file_field63240.call(null,name__19069__auto__,null);
});

sablono.core.file_field63240.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.file_field63240.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field63240);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field63244 = (function sablono$core$hidden_field63244(var_args){
var args63245 = [];
var len__11929__auto___63312 = arguments.length;
var i__11930__auto___63313 = (0);
while(true){
if((i__11930__auto___63313 < len__11929__auto___63312)){
args63245.push((arguments[i__11930__auto___63313]));

var G__63314 = (i__11930__auto___63313 + (1));
i__11930__auto___63313 = G__63314;
continue;
} else {
}
break;
}

var G__63247 = args63245.length;
switch (G__63247) {
case 1:
return sablono.core.hidden_field63244.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field63244.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63245.length)].join('')));

}
});

sablono.core.hidden_field63244.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.hidden_field63244.call(null,name__19069__auto__,null);
});

sablono.core.hidden_field63244.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.hidden_field63244.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field63244);

/**
 * Creates a month input field.
 */
sablono.core.month_field63248 = (function sablono$core$month_field63248(var_args){
var args63249 = [];
var len__11929__auto___63316 = arguments.length;
var i__11930__auto___63317 = (0);
while(true){
if((i__11930__auto___63317 < len__11929__auto___63316)){
args63249.push((arguments[i__11930__auto___63317]));

var G__63318 = (i__11930__auto___63317 + (1));
i__11930__auto___63317 = G__63318;
continue;
} else {
}
break;
}

var G__63251 = args63249.length;
switch (G__63251) {
case 1:
return sablono.core.month_field63248.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field63248.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63249.length)].join('')));

}
});

sablono.core.month_field63248.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.month_field63248.call(null,name__19069__auto__,null);
});

sablono.core.month_field63248.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.month_field63248.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field63248);

/**
 * Creates a number input field.
 */
sablono.core.number_field63252 = (function sablono$core$number_field63252(var_args){
var args63253 = [];
var len__11929__auto___63320 = arguments.length;
var i__11930__auto___63321 = (0);
while(true){
if((i__11930__auto___63321 < len__11929__auto___63320)){
args63253.push((arguments[i__11930__auto___63321]));

var G__63322 = (i__11930__auto___63321 + (1));
i__11930__auto___63321 = G__63322;
continue;
} else {
}
break;
}

var G__63255 = args63253.length;
switch (G__63255) {
case 1:
return sablono.core.number_field63252.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field63252.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63253.length)].join('')));

}
});

sablono.core.number_field63252.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.number_field63252.call(null,name__19069__auto__,null);
});

sablono.core.number_field63252.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.number_field63252.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field63252);

/**
 * Creates a password input field.
 */
sablono.core.password_field63256 = (function sablono$core$password_field63256(var_args){
var args63257 = [];
var len__11929__auto___63324 = arguments.length;
var i__11930__auto___63325 = (0);
while(true){
if((i__11930__auto___63325 < len__11929__auto___63324)){
args63257.push((arguments[i__11930__auto___63325]));

var G__63326 = (i__11930__auto___63325 + (1));
i__11930__auto___63325 = G__63326;
continue;
} else {
}
break;
}

var G__63259 = args63257.length;
switch (G__63259) {
case 1:
return sablono.core.password_field63256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field63256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63257.length)].join('')));

}
});

sablono.core.password_field63256.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.password_field63256.call(null,name__19069__auto__,null);
});

sablono.core.password_field63256.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.password_field63256.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field63256);

/**
 * Creates a range input field.
 */
sablono.core.range_field63260 = (function sablono$core$range_field63260(var_args){
var args63261 = [];
var len__11929__auto___63328 = arguments.length;
var i__11930__auto___63329 = (0);
while(true){
if((i__11930__auto___63329 < len__11929__auto___63328)){
args63261.push((arguments[i__11930__auto___63329]));

var G__63330 = (i__11930__auto___63329 + (1));
i__11930__auto___63329 = G__63330;
continue;
} else {
}
break;
}

var G__63263 = args63261.length;
switch (G__63263) {
case 1:
return sablono.core.range_field63260.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field63260.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63261.length)].join('')));

}
});

sablono.core.range_field63260.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.range_field63260.call(null,name__19069__auto__,null);
});

sablono.core.range_field63260.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.range_field63260.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field63260);

/**
 * Creates a search input field.
 */
sablono.core.search_field63264 = (function sablono$core$search_field63264(var_args){
var args63265 = [];
var len__11929__auto___63332 = arguments.length;
var i__11930__auto___63333 = (0);
while(true){
if((i__11930__auto___63333 < len__11929__auto___63332)){
args63265.push((arguments[i__11930__auto___63333]));

var G__63334 = (i__11930__auto___63333 + (1));
i__11930__auto___63333 = G__63334;
continue;
} else {
}
break;
}

var G__63267 = args63265.length;
switch (G__63267) {
case 1:
return sablono.core.search_field63264.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field63264.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63265.length)].join('')));

}
});

sablono.core.search_field63264.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.search_field63264.call(null,name__19069__auto__,null);
});

sablono.core.search_field63264.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.search_field63264.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field63264);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field63268 = (function sablono$core$tel_field63268(var_args){
var args63269 = [];
var len__11929__auto___63336 = arguments.length;
var i__11930__auto___63337 = (0);
while(true){
if((i__11930__auto___63337 < len__11929__auto___63336)){
args63269.push((arguments[i__11930__auto___63337]));

var G__63338 = (i__11930__auto___63337 + (1));
i__11930__auto___63337 = G__63338;
continue;
} else {
}
break;
}

var G__63271 = args63269.length;
switch (G__63271) {
case 1:
return sablono.core.tel_field63268.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field63268.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63269.length)].join('')));

}
});

sablono.core.tel_field63268.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.tel_field63268.call(null,name__19069__auto__,null);
});

sablono.core.tel_field63268.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.tel_field63268.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field63268);

/**
 * Creates a text input field.
 */
sablono.core.text_field63272 = (function sablono$core$text_field63272(var_args){
var args63273 = [];
var len__11929__auto___63340 = arguments.length;
var i__11930__auto___63341 = (0);
while(true){
if((i__11930__auto___63341 < len__11929__auto___63340)){
args63273.push((arguments[i__11930__auto___63341]));

var G__63342 = (i__11930__auto___63341 + (1));
i__11930__auto___63341 = G__63342;
continue;
} else {
}
break;
}

var G__63275 = args63273.length;
switch (G__63275) {
case 1:
return sablono.core.text_field63272.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field63272.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63273.length)].join('')));

}
});

sablono.core.text_field63272.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.text_field63272.call(null,name__19069__auto__,null);
});

sablono.core.text_field63272.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.text_field63272.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field63272);

/**
 * Creates a time input field.
 */
sablono.core.time_field63276 = (function sablono$core$time_field63276(var_args){
var args63277 = [];
var len__11929__auto___63344 = arguments.length;
var i__11930__auto___63345 = (0);
while(true){
if((i__11930__auto___63345 < len__11929__auto___63344)){
args63277.push((arguments[i__11930__auto___63345]));

var G__63346 = (i__11930__auto___63345 + (1));
i__11930__auto___63345 = G__63346;
continue;
} else {
}
break;
}

var G__63279 = args63277.length;
switch (G__63279) {
case 1:
return sablono.core.time_field63276.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field63276.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63277.length)].join('')));

}
});

sablono.core.time_field63276.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.time_field63276.call(null,name__19069__auto__,null);
});

sablono.core.time_field63276.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.time_field63276.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field63276);

/**
 * Creates a url input field.
 */
sablono.core.url_field63280 = (function sablono$core$url_field63280(var_args){
var args63281 = [];
var len__11929__auto___63348 = arguments.length;
var i__11930__auto___63349 = (0);
while(true){
if((i__11930__auto___63349 < len__11929__auto___63348)){
args63281.push((arguments[i__11930__auto___63349]));

var G__63350 = (i__11930__auto___63349 + (1));
i__11930__auto___63349 = G__63350;
continue;
} else {
}
break;
}

var G__63283 = args63281.length;
switch (G__63283) {
case 1:
return sablono.core.url_field63280.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field63280.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63281.length)].join('')));

}
});

sablono.core.url_field63280.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.url_field63280.call(null,name__19069__auto__,null);
});

sablono.core.url_field63280.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.url_field63280.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field63280);

/**
 * Creates a week input field.
 */
sablono.core.week_field63284 = (function sablono$core$week_field63284(var_args){
var args63285 = [];
var len__11929__auto___63352 = arguments.length;
var i__11930__auto___63353 = (0);
while(true){
if((i__11930__auto___63353 < len__11929__auto___63352)){
args63285.push((arguments[i__11930__auto___63353]));

var G__63354 = (i__11930__auto___63353 + (1));
i__11930__auto___63353 = G__63354;
continue;
} else {
}
break;
}

var G__63287 = args63285.length;
switch (G__63287) {
case 1:
return sablono.core.week_field63284.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field63284.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63285.length)].join('')));

}
});

sablono.core.week_field63284.cljs$core$IFn$_invoke$arity$1 = (function (name__19069__auto__){
return sablono.core.week_field63284.call(null,name__19069__auto__,null);
});

sablono.core.week_field63284.cljs$core$IFn$_invoke$arity$2 = (function (name__19069__auto__,value__19070__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19069__auto__,value__19070__auto__);
});

sablono.core.week_field63284.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field63284);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box63356 = (function sablono$core$check_box63356(var_args){
var args63357 = [];
var len__11929__auto___63360 = arguments.length;
var i__11930__auto___63361 = (0);
while(true){
if((i__11930__auto___63361 < len__11929__auto___63360)){
args63357.push((arguments[i__11930__auto___63361]));

var G__63362 = (i__11930__auto___63361 + (1));
i__11930__auto___63361 = G__63362;
continue;
} else {
}
break;
}

var G__63359 = args63357.length;
switch (G__63359) {
case 1:
return sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63357.length)].join('')));

}
});

sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box63356.call(null,name,null);
});

sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box63356.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box63356.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__11280__auto__ = value;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box63356.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box63356);
/**
 * Creates a radio button.
 */
sablono.core.radio_button63364 = (function sablono$core$radio_button63364(var_args){
var args63365 = [];
var len__11929__auto___63368 = arguments.length;
var i__11930__auto___63369 = (0);
while(true){
if((i__11930__auto___63369 < len__11929__auto___63368)){
args63365.push((arguments[i__11930__auto___63369]));

var G__63370 = (i__11930__auto___63369 + (1));
i__11930__auto___63369 = G__63370;
continue;
} else {
}
break;
}

var G__63367 = args63365.length;
switch (G__63367) {
case 1:
return sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63365.length)].join('')));

}
});

sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button63364.call(null,group,null);
});

sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button63364.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button63364.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__11280__auto__ = value;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button63364.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button63364);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options63372 = (function sablono$core$select_options63372(coll){
var iter__11714__auto__ = (function sablono$core$select_options63372_$_iter__63389(s__63390){
return (new cljs.core.LazySeq(null,(function (){
var s__63390__$1 = s__63390;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__63390__$1);
if(temp__6753__auto__){
var s__63390__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__63390__$2)){
var c__11712__auto__ = cljs.core.chunk_first.call(null,s__63390__$2);
var size__11713__auto__ = cljs.core.count.call(null,c__11712__auto__);
var b__63392 = cljs.core.chunk_buffer.call(null,size__11713__auto__);
if((function (){var i__63391 = (0);
while(true){
if((i__63391 < size__11713__auto__)){
var x = cljs.core._nth.call(null,c__11712__auto__,i__63391);
cljs.core.chunk_append.call(null,b__63392,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__63399 = x;
var text = cljs.core.nth.call(null,vec__63399,(0),null);
var val = cljs.core.nth.call(null,vec__63399,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__63399,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options63372.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__63405 = (i__63391 + (1));
i__63391 = G__63405;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63392),sablono$core$select_options63372_$_iter__63389.call(null,cljs.core.chunk_rest.call(null,s__63390__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__63392),null);
}
} else {
var x = cljs.core.first.call(null,s__63390__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__63402 = x;
var text = cljs.core.nth.call(null,vec__63402,(0),null);
var val = cljs.core.nth.call(null,vec__63402,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__63402,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options63372.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options63372_$_iter__63389.call(null,cljs.core.rest.call(null,s__63390__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__11714__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options63372);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down63406 = (function sablono$core$drop_down63406(var_args){
var args63407 = [];
var len__11929__auto___63410 = arguments.length;
var i__11930__auto___63411 = (0);
while(true){
if((i__11930__auto___63411 < len__11929__auto___63410)){
args63407.push((arguments[i__11930__auto___63411]));

var G__63412 = (i__11930__auto___63411 + (1));
i__11930__auto___63411 = G__63412;
continue;
} else {
}
break;
}

var G__63409 = args63407.length;
switch (G__63409) {
case 2:
return sablono.core.drop_down63406.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down63406.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63407.length)].join('')));

}
});

sablono.core.drop_down63406.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down63406.call(null,name,options,null);
});

sablono.core.drop_down63406.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down63406.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down63406);
/**
 * Creates a text area element.
 */
sablono.core.text_area63414 = (function sablono$core$text_area63414(var_args){
var args63415 = [];
var len__11929__auto___63418 = arguments.length;
var i__11930__auto___63419 = (0);
while(true){
if((i__11930__auto___63419 < len__11929__auto___63418)){
args63415.push((arguments[i__11930__auto___63419]));

var G__63420 = (i__11930__auto___63419 + (1));
i__11930__auto___63419 = G__63420;
continue;
} else {
}
break;
}

var G__63417 = args63415.length;
switch (G__63417) {
case 1:
return sablono.core.text_area63414.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area63414.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args63415.length)].join('')));

}
});

sablono.core.text_area63414.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area63414.call(null,name,null);
});

sablono.core.text_area63414.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__11280__auto__ = value;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area63414.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area63414);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label63422 = (function sablono$core$label63422(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label63422);
/**
 * Creates a submit button.
 */
sablono.core.submit_button63423 = (function sablono$core$submit_button63423(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button63423);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button63424 = (function sablono$core$reset_button63424(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button63424);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to63425 = (function sablono$core$form_to63425(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63432 = arguments.length;
var i__11930__auto___63433 = (0);
while(true){
if((i__11930__auto___63433 < len__11929__auto___63432)){
args__11932__auto__.push((arguments[i__11930__auto___63433]));

var G__63434 = (i__11930__auto___63433 + (1));
i__11930__auto___63433 = G__63434;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to63425.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

sablono.core.form_to63425.cljs$core$IFn$_invoke$arity$variadic = (function (p__63428,body){
var vec__63429 = p__63428;
var method = cljs.core.nth.call(null,vec__63429,(0),null);
var action = cljs.core.nth.call(null,vec__63429,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to63425.cljs$lang$maxFixedArity = (1);

sablono.core.form_to63425.cljs$lang$applyTo = (function (seq63426){
var G__63427 = cljs.core.first.call(null,seq63426);
var seq63426__$1 = cljs.core.next.call(null,seq63426);
return sablono.core.form_to63425.cljs$core$IFn$_invoke$arity$variadic(G__63427,seq63426__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to63425);

//# sourceMappingURL=core.js.map?rel=1486495682383