// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('om.next');
goog.require('untangled.client.impl.data_fetch');
goog.require('untangled.client.impl.util');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('untangled.i18n.core');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__62275,query){
var map__62278 = p__62275;
var map__62278__$1 = ((((!((map__62278 == null)))?((((map__62278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62278.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62278):map__62278);
var reconciler = cljs.core.get.call(null,map__62278__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__62278,map__62278__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__62278,map__62278__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__){
return (function (state_62295){
var state_val_62296 = (state_62295[(1)]);
if((state_val_62296 === (1))){
var state_62295__$1 = state_62295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62295__$1,(2),q,v);
} else {
if((state_val_62296 === (2))){
var inst_62293 = (state_62295[(2)]);
var state_62295__$1 = state_62295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62295__$1,inst_62293);
} else {
return null;
}
}
});})(c__2597__auto__))
;
return ((function (switch__2483__auto__,c__2597__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__2484__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__2484__auto____0 = (function (){
var statearr_62300 = [null,null,null,null,null,null,null];
(statearr_62300[(0)] = untangled$client$impl$application$enqueue_$_state_machine__2484__auto__);

(statearr_62300[(1)] = (1));

return statearr_62300;
});
var untangled$client$impl$application$enqueue_$_state_machine__2484__auto____1 = (function (state_62295){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_62295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e62301){if((e62301 instanceof Object)){
var ex__2487__auto__ = e62301;
var statearr_62302_62304 = state_62295;
(statearr_62302_62304[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62295);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62301;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62305 = state_62295;
state_62295 = G__62305;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__2484__auto__ = function(state_62295){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__2484__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__2484__auto____1.call(this,state_62295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__2484__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__2484__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__))
})();
var state__2599__auto__ = (function (){var statearr_62303 = f__2598__auto__.call(null);
(statearr_62303[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_62303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__))
);

return c__2597__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__62307,remote_tx_map,cb){
var map__62310 = p__62307;
var map__62310__$1 = ((((!((map__62310 == null)))?((((map__62310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62310.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62310):map__62310);
var app = map__62310__$1;
var queue = cljs.core.get.call(null,map__62310__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__62310,map__62310__$1,app,queue){
return (function (p1__62306_SHARP_){
return fallback.call(null,p1__62306_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__62310,map__62310__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__62314){
var map__62325 = p__62314;
var map__62325__$1 = ((((!((map__62325 == null)))?((((map__62325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62325):map__62325);
var queue = cljs.core.get.call(null,map__62325__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__62325__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__62325__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__62327_62335 = cljs.core.seq.call(null,parallel_payload);
var chunk__62328_62336 = null;
var count__62329_62337 = (0);
var i__62330_62338 = (0);
while(true){
if((i__62330_62338 < count__62329_62337)){
var map__62331_62339 = cljs.core._nth.call(null,chunk__62328_62336,i__62330_62338);
var map__62331_62340__$1 = ((((!((map__62331_62339 == null)))?((((map__62331_62339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62331_62339.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62331_62339):map__62331_62339);
var query_62341 = cljs.core.get.call(null,map__62331_62340__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_62342 = cljs.core.get.call(null,map__62331_62340__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_62343 = cljs.core.get.call(null,map__62331_62340__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_62344 = cljs.core.get.call(null,map__62331_62340__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__62345 = ((function (seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,map__62331_62339,map__62331_62340__$1,query_62341,on_load_62342,on_error_62343,callback_args_62344,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking){
return (function (p1__62312_SHARP_){
return on_load_62342.call(null,p1__62312_SHARP_,callback_args_62344);
});})(seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,map__62331_62339,map__62331_62340__$1,query_62341,on_load_62342,on_error_62343,callback_args_62344,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__62346 = ((function (seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,on_load_SINGLEQUOTE__62345,map__62331_62339,map__62331_62340__$1,query_62341,on_load_62342,on_error_62343,callback_args_62344,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking){
return (function (p1__62313_SHARP_){
return on_error_62343.call(null,p1__62313_SHARP_,callback_args_62344);
});})(seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,on_load_SINGLEQUOTE__62345,map__62331_62339,map__62331_62340__$1,query_62341,on_load_62342,on_error_62343,callback_args_62344,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_62341,on_load_SINGLEQUOTE__62345,on_error_SINGLEQUOTE__62346);

var G__62347 = seq__62327_62335;
var G__62348 = chunk__62328_62336;
var G__62349 = count__62329_62337;
var G__62350 = (i__62330_62338 + (1));
seq__62327_62335 = G__62347;
chunk__62328_62336 = G__62348;
count__62329_62337 = G__62349;
i__62330_62338 = G__62350;
continue;
} else {
var temp__6753__auto___62351 = cljs.core.seq.call(null,seq__62327_62335);
if(temp__6753__auto___62351){
var seq__62327_62352__$1 = temp__6753__auto___62351;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62327_62352__$1)){
var c__11759__auto___62353 = cljs.core.chunk_first.call(null,seq__62327_62352__$1);
var G__62354 = cljs.core.chunk_rest.call(null,seq__62327_62352__$1);
var G__62355 = c__11759__auto___62353;
var G__62356 = cljs.core.count.call(null,c__11759__auto___62353);
var G__62357 = (0);
seq__62327_62335 = G__62354;
chunk__62328_62336 = G__62355;
count__62329_62337 = G__62356;
i__62330_62338 = G__62357;
continue;
} else {
var map__62333_62358 = cljs.core.first.call(null,seq__62327_62352__$1);
var map__62333_62359__$1 = ((((!((map__62333_62358 == null)))?((((map__62333_62358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62333_62358.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62333_62358):map__62333_62358);
var query_62360 = cljs.core.get.call(null,map__62333_62359__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_62361 = cljs.core.get.call(null,map__62333_62359__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_62362 = cljs.core.get.call(null,map__62333_62359__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_62363 = cljs.core.get.call(null,map__62333_62359__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__62364 = ((function (seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,map__62333_62358,map__62333_62359__$1,query_62360,on_load_62361,on_error_62362,callback_args_62363,seq__62327_62352__$1,temp__6753__auto___62351,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking){
return (function (p1__62312_SHARP_){
return on_load_62361.call(null,p1__62312_SHARP_,callback_args_62363);
});})(seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,map__62333_62358,map__62333_62359__$1,query_62360,on_load_62361,on_error_62362,callback_args_62363,seq__62327_62352__$1,temp__6753__auto___62351,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__62365 = ((function (seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,on_load_SINGLEQUOTE__62364,map__62333_62358,map__62333_62359__$1,query_62360,on_load_62361,on_error_62362,callback_args_62363,seq__62327_62352__$1,temp__6753__auto___62351,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking){
return (function (p1__62313_SHARP_){
return on_error_62362.call(null,p1__62313_SHARP_,callback_args_62363);
});})(seq__62327_62335,chunk__62328_62336,count__62329_62337,i__62330_62338,on_load_SINGLEQUOTE__62364,map__62333_62358,map__62333_62359__$1,query_62360,on_load_62361,on_error_62362,callback_args_62363,seq__62327_62352__$1,temp__6753__auto___62351,parallel_payload,map__62325,map__62325__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_62360,on_load_SINGLEQUOTE__62364,on_error_SINGLEQUOTE__62365);

var G__62366 = cljs.core.next.call(null,seq__62327_62352__$1);
var G__62367 = null;
var G__62368 = (0);
var G__62369 = (0);
seq__62327_62335 = G__62366;
chunk__62328_62336 = G__62367;
count__62329_62337 = G__62368;
i__62330_62338 = G__62369;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__62370 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__62370;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__62371){
var map__62490 = p__62371;
var map__62490__$1 = ((((!((map__62490 == null)))?((((map__62490.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62490.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62490):map__62490);
var networking = cljs.core.get.call(null,map__62490__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__62490__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__62490__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__62490,map__62490__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__62490,map__62490__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__2597__auto___62608 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel){
return (function (state_62531){
var state_val_62532 = (state_62531[(1)]);
if((state_val_62532 === (1))){
var state_62531__$1 = state_62531;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62531__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_62532 === (2))){
var inst_62529 = (state_62531[(2)]);
var state_62531__$1 = state_62531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62531__$1,inst_62529);
} else {
return null;
}
}
});})(c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel))
;
return ((function (switch__2483__auto__,c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____0 = (function (){
var statearr_62536 = [null,null,null,null,null,null,null];
(statearr_62536[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__);

(statearr_62536[(1)] = (1));

return statearr_62536;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____1 = (function (state_62531){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_62531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e62537){if((e62537 instanceof Object)){
var ex__2487__auto__ = e62537;
var statearr_62538_62609 = state_62531;
(statearr_62538_62609[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62531);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62610 = state_62531;
state_62531 = G__62610;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__ = function(state_62531){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____1.call(this,state_62531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel))
})();
var state__2599__auto__ = (function (){var statearr_62539 = f__2598__auto__.call(null);
(statearr_62539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto___62608);

return statearr_62539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto___62608,map__62490,map__62490__$1,networking,queue,response_channel))
);

}});
;})(map__62490,map__62490__$1,networking,queue,response_channel))
});})(map__62490,map__62490__$1,networking,queue,response_channel))
;
var c__2597__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel){
return (function (){
var f__2598__auto__ = (function (){var switch__2483__auto__ = ((function (c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel){
return (function (state_62581){
var state_val_62582 = (state_62581[(1)]);
if((state_val_62582 === (7))){
var inst_62560 = (state_62581[(2)]);
var state_62581__$1 = state_62581;
if(cljs.core.truth_(inst_62560)){
var statearr_62583_62611 = state_62581__$1;
(statearr_62583_62611[(1)] = (11));

} else {
var statearr_62584_62612 = state_62581__$1;
(statearr_62584_62612[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (1))){
var state_62581__$1 = state_62581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62581__$1,(2),queue);
} else {
if((state_val_62582 === (4))){
var inst_62579 = (state_62581[(2)]);
var state_62581__$1 = state_62581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62581__$1,inst_62579);
} else {
if((state_val_62582 === (15))){
var inst_62576 = (state_62581[(2)]);
var inst_62542 = inst_62576;
var state_62581__$1 = (function (){var statearr_62585 = state_62581;
(statearr_62585[(7)] = inst_62542);

return statearr_62585;
})();
var statearr_62586_62613 = state_62581__$1;
(statearr_62586_62613[(2)] = null);

(statearr_62586_62613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (13))){
var inst_62565 = (state_62581[(2)]);
var inst_62566 = cljs.core.get.call(null,inst_62565,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_62567 = cljs.core.get.call(null,inst_62565,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_62568 = cljs.core.get.call(null,inst_62565,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_62569 = cljs.core.get.call(null,inst_62565,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_62570 = make_process_response.call(null,inst_62567,inst_62569);
var inst_62571 = make_process_response.call(null,inst_62568,inst_62569);
var inst_62572 = untangled.client.impl.application.real_send.call(null,networking,inst_62566,inst_62570,inst_62571);
var state_62581__$1 = (function (){var statearr_62587 = state_62581;
(statearr_62587[(8)] = inst_62572);

return statearr_62587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62581__$1,(14),response_channel);
} else {
if((state_val_62582 === (6))){
var state_62581__$1 = state_62581;
var statearr_62588_62614 = state_62581__$1;
(statearr_62588_62614[(2)] = false);

(statearr_62588_62614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (3))){
var inst_62542 = (state_62581[(7)]);
var inst_62546 = (inst_62542 == null);
var inst_62547 = cljs.core.not.call(null,inst_62546);
var state_62581__$1 = state_62581;
if(inst_62547){
var statearr_62589_62615 = state_62581__$1;
(statearr_62589_62615[(1)] = (5));

} else {
var statearr_62590_62616 = state_62581__$1;
(statearr_62590_62616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (12))){
var inst_62542 = (state_62581[(7)]);
var state_62581__$1 = state_62581;
var statearr_62591_62617 = state_62581__$1;
(statearr_62591_62617[(2)] = inst_62542);

(statearr_62591_62617[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (2))){
var inst_62541 = (state_62581[(2)]);
var inst_62542 = inst_62541;
var state_62581__$1 = (function (){var statearr_62592 = state_62581;
(statearr_62592[(7)] = inst_62542);

return statearr_62592;
})();
var statearr_62593_62618 = state_62581__$1;
(statearr_62593_62618[(2)] = null);

(statearr_62593_62618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (11))){
var inst_62542 = (state_62581[(7)]);
var inst_62562 = cljs.core.apply.call(null,cljs.core.hash_map,inst_62542);
var state_62581__$1 = state_62581;
var statearr_62594_62619 = state_62581__$1;
(statearr_62594_62619[(2)] = inst_62562);

(statearr_62594_62619[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (9))){
var state_62581__$1 = state_62581;
var statearr_62595_62620 = state_62581__$1;
(statearr_62595_62620[(2)] = false);

(statearr_62595_62620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (5))){
var inst_62542 = (state_62581[(7)]);
var inst_62549 = inst_62542.cljs$lang$protocol_mask$partition0$;
var inst_62550 = (inst_62549 & (64));
var inst_62551 = inst_62542.cljs$core$ISeq$;
var inst_62552 = (cljs.core.PROTOCOL_SENTINEL === inst_62551);
var inst_62553 = (inst_62550) || (inst_62552);
var state_62581__$1 = state_62581;
if(cljs.core.truth_(inst_62553)){
var statearr_62596_62621 = state_62581__$1;
(statearr_62596_62621[(1)] = (8));

} else {
var statearr_62597_62622 = state_62581__$1;
(statearr_62597_62622[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (14))){
var inst_62574 = (state_62581[(2)]);
var state_62581__$1 = (function (){var statearr_62598 = state_62581;
(statearr_62598[(9)] = inst_62574);

return statearr_62598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62581__$1,(15),queue);
} else {
if((state_val_62582 === (10))){
var inst_62557 = (state_62581[(2)]);
var state_62581__$1 = state_62581;
var statearr_62599_62623 = state_62581__$1;
(statearr_62599_62623[(2)] = inst_62557);

(statearr_62599_62623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (8))){
var state_62581__$1 = state_62581;
var statearr_62600_62624 = state_62581__$1;
(statearr_62600_62624[(2)] = true);

(statearr_62600_62624[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel))
;
return ((function (switch__2483__auto__,c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____0 = (function (){
var statearr_62604 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62604[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__);

(statearr_62604[(1)] = (1));

return statearr_62604;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____1 = (function (state_62581){
while(true){
var ret_value__2485__auto__ = (function (){try{while(true){
var result__2486__auto__ = switch__2483__auto__.call(null,state_62581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2486__auto__;
}
break;
}
}catch (e62605){if((e62605 instanceof Object)){
var ex__2487__auto__ = e62605;
var statearr_62606_62625 = state_62581;
(statearr_62606_62625[(5)] = ex__2487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62626 = state_62581;
state_62581 = G__62626;
continue;
} else {
return ret_value__2485__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__ = function(state_62581){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____1.call(this,state_62581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__2484__auto__;
})()
;})(switch__2483__auto__,c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel))
})();
var state__2599__auto__ = (function (){var statearr_62607 = f__2598__auto__.call(null);
(statearr_62607[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__2597__auto__);

return statearr_62607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2599__auto__);
});})(c__2597__auto__,map__62490,map__62490__$1,networking,queue,response_channel))
);

return c__2597__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__62631){
var vec__62632 = p__62631;
var k = cljs.core.nth.call(null,vec__62632,(0),null);
var v = cljs.core.nth.call(null,vec__62632,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__62639){
var vec__62640 = p__62639;
var k = cljs.core.nth.call(null,vec__62640,(0),null);
var v = cljs.core.nth.call(null,vec__62640,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__62647){
var vec__62648 = p__62647;
var k = cljs.core.nth.call(null,vec__62648,(0),null);
var v = cljs.core.nth.call(null,vec__62648,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__62659){
var vec__62660 = p__62659;
var k = cljs.core.nth.call(null,vec__62660,(0),null);
var _ = cljs.core.nth.call(null,vec__62660,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__62663){
var vec__62664 = p__62663;
var k = cljs.core.nth.call(null,vec__62664,(0),null);
var v = cljs.core.nth.call(null,vec__62664,(1),null);
if(cljs.core.truth_((function (){var and__11272__auto__ = mutation_merge;
if(cljs.core.truth_(and__11272__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__11272__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__62667,initial_state,parser,p__62668){
var map__62673 = p__62667;
var map__62673__$1 = ((((!((map__62673 == null)))?((((map__62673.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62673.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62673):map__62673);
var app = map__62673__$1;
var queue = cljs.core.get.call(null,map__62673__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__62673__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__62674 = p__62668;
var map__62674__$1 = ((((!((map__62674 == null)))?((((map__62674.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62674.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62674):map__62674);
var pathopt = cljs.core.get.call(null,map__62674__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__62674__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__62674__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__11280__auto__ = migrate;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = (cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,initial_state))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__11280__auto__ = migrate;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__62673,map__62673__$1,app,queue,mutation_merge,map__62674,map__62674__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__62677_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__62677_SHARP_)){
return cljs.core.partial.call(null,p1__62677_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1486495681510