// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.impl.protocol_support');
goog.require('cljs.core');
goog.require('untangled_spec.core');
goog.require('cljs.test');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('om.dom');
goog.require('untangled.client.core');
/**
 * Is the given keyword a seed data tempid keyword (namespaced to `tempid`)?
 */
untangled.client.impl.protocol_support.tempid_QMARK_ = (function untangled$client$impl$protocol_support$tempid_QMARK_(kw){
return ((kw instanceof cljs.core.Keyword)) && (cljs.core._EQ_.call(null,"om.tempid",cljs.core.namespace.call(null,kw)));
});
/**
 * Rewrite tempid keywords in the given state using the tid->rid map. Leaves the keyword alone if the map
 * does not contain an entry for it.
 */
untangled.client.impl.protocol_support.rewrite_tempids = (function untangled$client$impl$protocol_support$rewrite_tempids(var_args){
var args__11932__auto__ = [];
var len__11929__auto___62941 = arguments.length;
var i__11930__auto___62942 = (0);
while(true){
if((i__11930__auto___62942 < len__11929__auto___62941)){
args__11932__auto__.push((arguments[i__11930__auto___62942]));

var G__62943 = (i__11930__auto___62942 + (1));
i__11930__auto___62942 = G__62943;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((2) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((2)),(0),null)):null);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__11933__auto__);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic = (function (state,tid__GT_rid,p__62937){
var vec__62938 = p__62937;
var pred = cljs.core.nth.call(null,vec__62938,(0),null);
return clojure.walk.prewalk.call(null,((function (vec__62938,pred){
return (function (p1__62933_SHARP_){
if(cljs.core.truth_((function (){var or__11280__auto__ = pred;
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return untangled.client.impl.protocol_support.tempid_QMARK_;
}
})().call(null,p1__62933_SHARP_))){
return cljs.core.get.call(null,tid__GT_rid,p1__62933_SHARP_,p1__62933_SHARP_);
} else {
return p1__62933_SHARP_;
}
});})(vec__62938,pred))
,state);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$maxFixedArity = (2);

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$applyTo = (function (seq62934){
var G__62935 = cljs.core.first.call(null,seq62934);
var seq62934__$1 = cljs.core.next.call(null,seq62934);
var G__62936 = cljs.core.first.call(null,seq62934__$1);
var seq62934__$2 = cljs.core.next.call(null,seq62934__$1);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic(G__62935,G__62936,seq62934__$2);
});

/**
 * Checks that `new-state` includes the `delta`, where `delta` is a map keyed by data path (as in get-in). The
 * values of `delta` are literal values to verify at that path (nil means the path should be missing).
 */
untangled.client.impl.protocol_support.check_delta = (function untangled$client$impl$protocol_support$check_delta(new_state,delta){
if(cljs.core.empty_QMARK_.call(null,delta)){
throw cljs.core.ex_info.call(null,"Cannot have empty :merge-delta",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-state","new-state",-490349212),new_state], null));
} else {
var seq__62958 = cljs.core.seq.call(null,delta);
var chunk__62959 = null;
var count__62960 = (0);
var i__62961 = (0);
while(true){
if((i__62961 < count__62960)){
var vec__62962 = cljs.core._nth.call(null,chunk__62959,i__62961);
var key_path = cljs.core.nth.call(null,vec__62962,(0),null);
var value = cljs.core.nth.call(null,vec__62962,(1),null);
var behavior_string_62972 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_62973__$1 = (function (){var or__11280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_62972);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_62972], null));

if((value_62973__$1 instanceof RegExp)){
try{var values__11148__auto___62974 = (function (){var x__11770__auto__ = value_62973__$1;
return cljs.core._conj.call(null,(function (){var x__11770__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11770__auto____$1);
})(),x__11770__auto__);
})();
var result__11149__auto___62975 = cljs.core.apply.call(null,cljs.core.re_matches,values__11148__auto___62974);
if(cljs.core.truth_(result__11149__auto___62975)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__11148__auto___62974),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__11770__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__11148__auto___62974);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11770__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e62965){var t__11186__auto___62976 = e62965;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___62976,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__727__auto__ = value_62973__$1;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e62966){var t__11186__auto___62977 = e62966;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___62977,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_62972], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__62978 = seq__62958;
var G__62979 = chunk__62959;
var G__62980 = count__62960;
var G__62981 = (i__62961 + (1));
seq__62958 = G__62978;
chunk__62959 = G__62979;
count__62960 = G__62980;
i__62961 = G__62981;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__62958);
if(temp__6753__auto__){
var seq__62958__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62958__$1)){
var c__11759__auto__ = cljs.core.chunk_first.call(null,seq__62958__$1);
var G__62982 = cljs.core.chunk_rest.call(null,seq__62958__$1);
var G__62983 = c__11759__auto__;
var G__62984 = cljs.core.count.call(null,c__11759__auto__);
var G__62985 = (0);
seq__62958 = G__62982;
chunk__62959 = G__62983;
count__62960 = G__62984;
i__62961 = G__62985;
continue;
} else {
var vec__62967 = cljs.core.first.call(null,seq__62958__$1);
var key_path = cljs.core.nth.call(null,vec__62967,(0),null);
var value = cljs.core.nth.call(null,vec__62967,(1),null);
var behavior_string_62986 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_62987__$1 = (function (){var or__11280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_62986);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_62986], null));

if((value_62987__$1 instanceof RegExp)){
try{var values__11148__auto___62988 = (function (){var x__11770__auto__ = value_62987__$1;
return cljs.core._conj.call(null,(function (){var x__11770__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11770__auto____$1);
})(),x__11770__auto__);
})();
var result__11149__auto___62989 = cljs.core.apply.call(null,cljs.core.re_matches,values__11148__auto___62988);
if(cljs.core.truth_(result__11149__auto___62989)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__11148__auto___62988),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__11770__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__11148__auto___62988);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11770__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e62970){var t__11186__auto___62990 = e62970;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___62990,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__727__auto__ = value_62987__$1;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e62971){var t__11186__auto___62991 = e62971;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___62991,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_62986], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__62992 = cljs.core.next.call(null,seq__62958__$1);
var G__62993 = null;
var G__62994 = (0);
var G__62995 = (0);
seq__62958 = G__62992;
chunk__62959 = G__62993;
count__62960 = G__62994;
i__62961 = G__62995;
continue;
}
} else {
return null;
}
}
break;
}
}
});
untangled.client.impl.protocol_support.with_behavior = (function untangled$client$impl$protocol_support$with_behavior(behavior_string,value){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cps","value","cps/value",307453219),value,new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882),behavior_string], null);
});
untangled.client.impl.protocol_support.allocate_tempids = (function untangled$client$impl$protocol_support$allocate_tempids(tx){
var allocated_ids = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
clojure.walk.prewalk.call(null,((function (allocated_ids){
return (function (v){
if(cljs.core.truth_(untangled.client.impl.protocol_support.tempid_QMARK_.call(null,v))){
cljs.core.swap_BANG_.call(null,allocated_ids,cljs.core.conj,v);
} else {
}

return v;
});})(allocated_ids))
,tx);

return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (allocated_ids){
return (function (p1__62996_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__62996_SHARP_,om.next.tempid.call(null)],null));
});})(allocated_ids))
,cljs.core.deref.call(null,allocated_ids)));
});
/**
 * @constructor
 */
untangled.client.impl.protocol_support.Root = (function untangled$client$impl$protocol_support$Root(){
var this__24130__auto__ = this;
React.Component.apply(this__24130__auto__,arguments);

if(!((this__24130__auto__.initLocalState == null))){
this__24130__auto__.state = this__24130__auto__.initLocalState();
} else {
this__24130__auto__.state = {};
}

return this__24130__auto__;
});

untangled.client.impl.protocol_support.Root.prototype = goog.object.clone(React.Component.prototype);

var x63001_63011 = untangled.client.impl.protocol_support.Root.prototype;
x63001_63011.componentWillUpdate = ((function (x63001_63011){
return (function (next_props__23989__auto__,next_state__23990__auto__){
var this__23988__auto__ = this;
if(((!((this__23988__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__23988__auto__.om$next$Ident$)))?true:false):false)){
var ident__23992__auto___63012 = om.next.ident.call(null,this__23988__auto__,om.next.props.call(null,this__23988__auto__));
var next_ident__23993__auto___63013 = om.next.ident.call(null,this__23988__auto__,om.next._next_props.call(null,next_props__23989__auto__,this__23988__auto__));
if(cljs.core.not_EQ_.call(null,ident__23992__auto___63012,next_ident__23993__auto___63013)){
var idxr__23994__auto___63014 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__23988__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__23994__auto___63014 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__23994__auto___63014),((function (idxr__23994__auto___63014,ident__23992__auto___63012,next_ident__23993__auto___63013,this__23988__auto__,x63001_63011){
return (function (indexes__23995__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__23995__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__23992__auto___63012], null),cljs.core.disj,this__23988__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__23993__auto___63013], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__23988__auto__);
});})(idxr__23994__auto___63014,ident__23992__auto___63012,next_ident__23993__auto___63013,this__23988__auto__,x63001_63011))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__23988__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__23988__auto__);
});})(x63001_63011))
;

x63001_63011.shouldComponentUpdate = ((function (x63001_63011){
return (function (next_props__23989__auto__,next_state__23990__auto__){
var this__23988__auto__ = this;
var next_children__23991__auto__ = next_props__23989__auto__.children;
var next_props__23989__auto____$1 = goog.object.get(next_props__23989__auto__,"omcljs$value");
var next_props__23989__auto____$2 = (function (){var G__63003 = next_props__23989__auto____$1;
if((next_props__23989__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__63003);
} else {
return G__63003;
}
})();
var or__11280__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__23988__auto__),next_props__23989__auto____$2);
if(or__11280__auto__){
return or__11280__auto__;
} else {
var or__11280__auto____$1 = (function (){var and__11272__auto__ = this__23988__auto__.state;
if(cljs.core.truth_(and__11272__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__23988__auto__.state,"omcljs$state"),goog.object.get(next_state__23990__auto__,"omcljs$state"));
} else {
return and__11272__auto__;
}
})();
if(cljs.core.truth_(or__11280__auto____$1)){
return or__11280__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__23988__auto__.props.children,next_children__23991__auto__);
}
}
});})(x63001_63011))
;

x63001_63011.componentWillUnmount = ((function (x63001_63011){
return (function (){
var this__23988__auto__ = this;
var r__23999__auto__ = om.next.get_reconciler.call(null,this__23988__auto__);
var cfg__24000__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__23999__auto__);
var st__24001__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__24000__auto__);
var indexer__23998__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__24000__auto__);
if(cljs.core.truth_((function (){var and__11272__auto__ = !((st__24001__auto__ == null));
if(and__11272__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__24001__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__23988__auto__], null));
} else {
return and__11272__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__24001__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__23988__auto__);
} else {
}

if((indexer__23998__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__23998__auto__,this__23988__auto__);
}
});})(x63001_63011))
;

x63001_63011.componentDidUpdate = ((function (x63001_63011){
return (function (prev_props__23996__auto__,prev_state__23997__auto__){
var this__23988__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__23988__auto__);
});})(x63001_63011))
;

x63001_63011.isMounted = ((function (x63001_63011){
return (function (){
var this__23988__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__23988__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x63001_63011))
;

x63001_63011.componentWillMount = ((function (x63001_63011){
return (function (){
var this__23988__auto__ = this;
var indexer__23998__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__23988__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__23998__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__23998__auto__,this__23988__auto__);
}
});})(x63001_63011))
;

x63001_63011.render = ((function (x63001_63011){
return (function (){
var this__23987__auto__ = this;
var this$ = this__23987__auto__;
var _STAR_reconciler_STAR_63004 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_63005 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_63006 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_63007 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_63008 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__23987__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__23987__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__23987__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__23987__auto__);

om.next._STAR_parent_STAR_ = this__23987__auto__;

try{return om.dom.div.call(null,null,"if you see this something is wrong");
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_63008;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_63007;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_63006;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_63005;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_63004;
}});})(x63001_63011))
;


untangled.client.impl.protocol_support.Root.prototype.constructor = untangled.client.impl.protocol_support.Root;

untangled.client.impl.protocol_support.Root.prototype.constructor.displayName = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.prototype.om$isComponent = true;

var x63009_63015 = untangled.client.impl.protocol_support.Root;
/** @nocollapse */
x63009_63015.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x63009_63015.om$next$IQuery$query$arity$1 = ((function (x63009_63015){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x63009_63015))
;


var x63010_63016 = untangled.client.impl.protocol_support.Root.prototype;

x63010_63016.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x63010_63016.om$next$IQuery$query$arity$1 = ((function (x63010_63016){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x63010_63016))
;


untangled.client.impl.protocol_support.Root.cljs$lang$type = true;

untangled.client.impl.protocol_support.Root.cljs$lang$ctorStr = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.cljs$lang$ctorPrWriter = (function (this__24133__auto__,writer__24134__auto__,opt__24135__auto__){
return cljs.core._write.call(null,writer__24134__auto__,"untangled.client.impl.protocol-support/Root");
});
untangled.client.impl.protocol_support.init_testing = (function untangled$client$impl$protocol_support$init_testing(){
return untangled.client.core.mount.call(null,untangled.client.core.new_untangled_test_client.call(null),untangled.client.impl.protocol_support.Root,"invisible-specs");
});

//# sourceMappingURL=protocol_support.js.map?rel=1486495681929