// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.protocol_support');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('untangled_spec.core');
goog.require('om.next');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.tempid');
goog.require('untangled.client.impl.protocol_support');
/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to the optimistic update for transactions going to the server
 *   `ui-tx`: the om transaction that modifies the app state prior to receiving a server response
 *   `optimistic-delta`: the expected changes to the app state after executing ui-tx. See Protocol Testing README for how
 *   to build this properly.
 */
untangled.client.protocol_support.check_optimistic_update = (function untangled$client$protocol_support$check_optimistic_update(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63029 = arguments.length;
var i__11930__auto___63030 = (0);
while(true){
if((i__11930__auto___63030 < len__11929__auto___63029)){
args__11932__auto__.push((arguments[i__11930__auto___63030]));

var G__63031 = (i__11930__auto___63030 + (1));
i__11930__auto___63030 = G__63031;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic = (function (p__63021,p__63022){
var map__63023 = p__63021;
var map__63023__$1 = ((((!((map__63023 == null)))?((((map__63023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63023.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63023):map__63023);
var data = map__63023__$1;
var initial_ui_state = cljs.core.get.call(null,map__63023__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__63023__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var optimistic_delta = cljs.core.get.call(null,map__63023__$1,new cljs.core.Keyword(null,"optimistic-delta","optimistic-delta",-2118700684));
var map__63024 = p__63022;
var map__63024__$1 = ((((!((map__63024 == null)))?((((map__63024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63024.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63024):map__63024);
var env = cljs.core.get.call(null,map__63024__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("state not allowed in the env argument"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(not (:state env))")].join('')));
}

cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Optimistic Updates");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));

var map__63027_63032 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__63027_63033__$1 = ((((!((map__63027_63032 == null)))?((((map__63027_63032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63027_63032.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63027_63032):map__63027_63032);
var parser_63034 = cljs.core.get.call(null,map__63027_63033__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_63035 = cljs.core.atom.call(null,initial_ui_state);
var parse_63036 = cljs.core.partial.call(null,parser_63034,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_63035], null),env));
var tempid_map_63037 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_63038__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_63037);
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"trigger correct state transitions");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));

parse_63036.call(null,ui_tx_63038__$1);

untangled.client.impl.protocol_support.check_delta.call(null,untangled.client.impl.protocol_support.rewrite_tempids.call(null,cljs.core.deref.call(null,state_63035),clojure.set.map_invert.call(null,tempid_map_63037),om.tempid.tempid_QMARK_),optimistic_delta);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_optimistic_update.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_optimistic_update.cljs$lang$applyTo = (function (seq63019){
var G__63020 = cljs.core.first.call(null,seq63019);
var seq63019__$1 = cljs.core.next.call(null,seq63019);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic(G__63020,seq63019__$1);
});

/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to sending the server transaction
 *   `ui-tx`: the om transaction that modifies the app state locally
 *   `server-tx`: the server transaction corresponding to ui-tx
 */
untangled.client.protocol_support.check_server_tx = (function untangled$client$protocol_support$check_server_tx(var_args){
var args__11932__auto__ = [];
var len__11929__auto___63050 = arguments.length;
var i__11930__auto___63051 = (0);
while(true){
if((i__11930__auto___63051 < len__11929__auto___63050)){
args__11932__auto__.push((arguments[i__11930__auto___63051]));

var G__63052 = (i__11930__auto___63051 + (1));
i__11930__auto___63051 = G__63052;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic = (function (p__63041,p__63042){
var map__63043 = p__63041;
var map__63043__$1 = ((((!((map__63043 == null)))?((((map__63043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63043):map__63043);
var initial_ui_state = cljs.core.get.call(null,map__63043__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__63043__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var server_tx = cljs.core.get.call(null,map__63043__$1,new cljs.core.Keyword(null,"server-tx","server-tx",-1146708246));
var map__63044 = p__63042;
var map__63044__$1 = ((((!((map__63044 == null)))?((((map__63044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63044.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63044):map__63044);
var env = cljs.core.get.call(null,map__63044__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Client Remoting");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));

var map__63047_63053 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__63047_63054__$1 = ((((!((map__63047_63053 == null)))?((((map__63047_63053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63047_63053.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63047_63053):map__63047_63053);
var parser_63055 = cljs.core.get.call(null,map__63047_63054__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_63056 = cljs.core.atom.call(null,initial_ui_state);
var parse_63057 = cljs.core.partial.call(null,parser_63055,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_63056], null),env));
var tempid_map_63058 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_63059__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_63058);
parse_63057.call(null,ui_tx_63059__$1);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = untangled.client.impl.protocol_support.rewrite_tempids.call(null,untangled.client.impl.om_plumbing.strip_ui.call(null,untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,parse_63057.call(null,ui_tx_63059__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576)))),clojure.set.map_invert.call(null,tempid_map_63058),om.tempid.tempid_QMARK_);
var exp__727__auto__ = server_tx;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null);
})());
}catch (e63049){var t__11186__auto___63060 = e63049;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"server-tx","server-tx",493823281,null),cljs.core.list(new cljs.core.Symbol(null,"->","->",-2139605430,null),cljs.core.list(new cljs.core.Symbol(null,"parse","parse",478366908,null),new cljs.core.Symbol(null,"ui-tx","ui-tx",62864806,null),new cljs.core.Keyword(null,"remote","remote",-1593576576)),new cljs.core.Symbol("plumbing","remove-loads-and-fallbacks","plumbing/remove-loads-and-fallbacks",-474759113,null),new cljs.core.Symbol("plumbing","strip-ui","plumbing/strip-ui",-2004815259,null),cljs.core.list(new cljs.core.Symbol("impl","rewrite-tempids","impl/rewrite-tempids",-1005245316,null),cljs.core.list(new cljs.core.Symbol("set","map-invert","set/map-invert",1259038818,null),new cljs.core.Symbol(null,"tempid-map","tempid-map",-1148551297,null)),new cljs.core.Symbol("omt","tempid?","omt/tempid?",2034821487,null)))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___63060,new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null));
}
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_server_tx.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_server_tx.cljs$lang$applyTo = (function (seq63039){
var G__63040 = cljs.core.first.call(null,seq63039);
var seq63039__$1 = cljs.core.next.call(null,seq63039);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic(G__63040,seq63039__$1);
});

/**
 * Takes a map containing:
 *   `response`: the exact data the server sends back to the client
 *   `pre-response-state`: normalized state prior to receiving `response`
 *   `server-tx`: the transaction originally sent to the server, yielding `response`
 *   `merge-delta`: the delta between `pre-response-state` and its integration with `response`
 */
untangled.client.protocol_support.check_response_from_server = (function untangled$client$protocol_support$check_response_from_server(p__63061){
var map__63067 = p__63061;
var map__63067__$1 = ((((!((map__63067 == null)))?((((map__63067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63067.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63067):map__63067);
var response = cljs.core.get.call(null,map__63067__$1,new cljs.core.Keyword(null,"response","response",-1068424192));
var pre_response_state = cljs.core.get.call(null,map__63067__$1,new cljs.core.Keyword(null,"pre-response-state","pre-response-state",696272294));
var ui_tx = cljs.core.get.call(null,map__63067__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var merge_delta = cljs.core.get.call(null,map__63067__$1,new cljs.core.Keyword(null,"merge-delta","merge-delta",-1454035297));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Server response merged with app state");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));

var map__63069_63072 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__63069_63073__$1 = ((((!((map__63069_63072 == null)))?((((map__63069_63072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63069_63072.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63069_63072):map__63069_63072);
var reconciler_63074 = cljs.core.get.call(null,map__63069_63073__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state_63075 = om.next.app_state.call(null,reconciler_63074);
cljs.core.reset_BANG_.call(null,state_63075,pre_response_state);

om.next.merge_BANG_.call(null,reconciler_63074,response,ui_tx);

if(cljs.core.truth_(merge_delta)){
untangled.client.impl.protocol_support.check_delta.call(null,cljs.core.deref.call(null,state_63075),merge_delta);
} else {
try{cljs.test.do_report.call(null,(function (){var act__726__auto__ = cljs.core.deref.call(null,state_63075);
var exp__727__auto__ = pre_response_state;
var result__728__auto__ = cljs.core._EQ_.call(null,exp__727__auto__,act__726__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__728__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__727__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__726__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null);
})());
}catch (e63071){var t__11186__auto___63076 = e63071;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"pre-response-state","pre-response-state",-1958163475,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"state","state",-348086572,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__11186__auto___63076,new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null));
}}

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});
untangled.client.protocol_support.with_behavior = untangled.client.impl.protocol_support.with_behavior;

//# sourceMappingURL=protocol_support.js.map?rel=1486495681995