// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.openid_client');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('goog.net.Cookies');
untangled.openid_client.params = (function untangled$openid_client$params(){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.rest.call(null,window.location.hash));
});
untangled.openid_client.get_tokens_from_cookies = (function untangled$openid_client$get_tokens_from_cookies(){
var cookies = (new goog.net.Cookies(document));
var cookie_keys = cookies.getKeys();
return cljs.core.reduce.call(null,((function (cookies,cookie_keys){
return (function (p1__67384_SHARP_,p2__67385_SHARP_){
return cljs.core.assoc.call(null,p1__67384_SHARP_,p2__67385_SHARP_,cookies.get(p2__67385_SHARP_));
});})(cookies,cookie_keys))
,cljs.core.PersistentArrayMap.EMPTY,cookie_keys);
});
untangled.openid_client.tokens_from_params = (function untangled$openid_client$tokens_from_params(params){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,(function (v){
var pairs = clojure.string.split.call(null,v,/=/);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.first.call(null,pairs),cljs.core.second.call(null,pairs)]);
}),clojure.string.split.call(null,params,/&/)));
});
untangled.openid_client.parse_claims = (function untangled$openid_client$parse_claims(token){
var G__67387 = token;
var G__67387__$1 = (((G__67387 == null))?null:clojure.string.split.call(null,G__67387,/\./));
var G__67387__$2 = (((G__67387__$1 == null))?null:cljs.core.second.call(null,G__67387__$1));
var G__67387__$3 = (((G__67387__$2 == null))?null:atob(G__67387__$2));
if((G__67387__$3 == null)){
return null;
} else {
return JSON.parse(G__67387__$3);
}
});
/**
 * Adds an Authorization header for each request based on the claims in the cookies or the url's hash fragments
 */
untangled.openid_client.add_auth_header = (function untangled$openid_client$add_auth_header(req){
var access_token = cljs.core.get.call(null,(function (){var or__11280__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
}
})(),"access_token");
return cljs.core.assoc_in.call(null,req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(access_token)].join(''));
});
/**
 * Installs openid information into the passed in untangled-client app's initial state,
 *   based on the token claims in the cookies or the url's hash fragments.
 */
untangled.openid_client.install_state_BANG_ = (function untangled$openid_client$install_state_BANG_(var_args){
var args__11932__auto__ = [];
var len__11929__auto___67394 = arguments.length;
var i__11930__auto___67395 = (0);
while(true){
if((i__11930__auto___67395 < len__11929__auto___67394)){
args__11932__auto__.push((arguments[i__11930__auto___67395]));

var G__67396 = (i__11930__auto___67395 + (1));
i__11930__auto___67395 = G__67396;
continue;
} else {
}
break;
}

var argseq__11933__auto__ = ((((1) < args__11932__auto__.length))?(new cljs.core.IndexedSeq(args__11932__auto__.slice((1)),(0),null)):null);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__11933__auto__);
});

untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (reconciler,p__67390){
var map__67391 = p__67390;
var map__67391__$1 = ((((!((map__67391 == null)))?((((map__67391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67391.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67391):map__67391);
var custom_state_fn = cljs.core.get.call(null,map__67391__$1,new cljs.core.Keyword(null,"custom-state-fn","custom-state-fn",1049325348),cljs.core.constantly.call(null,cljs.core.PersistentArrayMap.EMPTY));
var hash_tokens = untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
var tokens = (function (){var or__11280__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return hash_tokens;
}
})();
var id_claims = (function (){var G__67393 = tokens;
var G__67393__$1 = (((G__67393 == null))?null:cljs.core.get.call(null,G__67393,"id_token"));
var G__67393__$2 = (((G__67393__$1 == null))?null:untangled.openid_client.parse_claims.call(null,G__67393__$1));
var G__67393__$3 = (((G__67393__$2 == null))?null:cljs.core.js__GT_clj.call(null,G__67393__$2));
if((G__67393__$3 == null)){
return null;
} else {
return clojure.walk.keywordize_keys.call(null,G__67393__$3);
}
})();
if(cljs.core._EQ_.call(null,tokens,hash_tokens)){
(window.location["hash"] = "");
} else {
}

return cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.merge,cljs.core.merge.call(null,custom_state_fn.call(null,id_claims),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("openid","claims","openid/claims",498347492),id_claims,new cljs.core.Keyword("openid","access-token","openid/access-token",390035886),cljs.core.get.call(null,tokens,"access_token")], null)));
});

untangled.openid_client.install_state_BANG_.cljs$lang$maxFixedArity = (1);

untangled.openid_client.install_state_BANG_.cljs$lang$applyTo = (function (seq67388){
var G__67389 = cljs.core.first.call(null,seq67388);
var seq67388__$1 = cljs.core.next.call(null,seq67388);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__67389,seq67388__$1);
});


//# sourceMappingURL=openid_client.js.map?rel=1486495687876