// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.services.local_storage');
goog.require('cljs.core');
goog.require('cljs_uuid_utils.core');
goog.require('cljs.reader');
untangled.services.local_storage.similate_delay = (function untangled$services$local_storage$similate_delay(simulated_delay,async_fn){
if(cljs.core._EQ_.call(null,simulated_delay,(0))){
return async_fn.call(null);
} else {
return setTimeout(async_fn,simulated_delay);

}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled.services.asyncio.AsyncIo}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled.services.local_storage.LocalStorageIO = (function (async_report,simulated_delay,__meta,__extmap,__hash){
this.async_report = async_report;
this.simulated_delay = simulated_delay;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__11571__auto__,k__11572__auto__){
var self__ = this;
var this__11571__auto____$1 = this;
return this__11571__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__11572__auto__,null);
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__11573__auto__,k64841,else__11574__auto__){
var self__ = this;
var this__11573__auto____$1 = this;
var G__64843 = (((k64841 instanceof cljs.core.Keyword))?k64841.fqn:null);
switch (G__64843) {
case "async-report":
return self__.async_report;

break;
case "simulated-delay":
return self__.simulated_delay;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k64841,else__11574__auto__);

}
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__11585__auto__,writer__11586__auto__,opts__11587__auto__){
var self__ = this;
var this__11585__auto____$1 = this;
var pr_pair__11588__auto__ = ((function (this__11585__auto____$1){
return (function (keyval__11589__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,cljs.core.pr_writer,""," ","",opts__11587__auto__,keyval__11589__auto__);
});})(this__11585__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,pr_pair__11588__auto__,"#untangled.services.local-storage.LocalStorageIO{",", ","}",opts__11587__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-report","async-report",-858808276),self__.async_report],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606),self__.simulated_delay],null))], null),self__.__extmap));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__64840){
var self__ = this;
var G__64840__$1 = this;
return (new cljs.core.RecordIter((0),G__64840__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"async-report","async-report",-858808276),new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11569__auto__){
var self__ = this;
var this__11569__auto____$1 = this;
return self__.__meta;
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11565__auto__){
var self__ = this;
var this__11565__auto____$1 = this;
return (new untangled.services.local_storage.LocalStorageIO(self__.async_report,self__.simulated_delay,self__.__meta,self__.__extmap,self__.__hash));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__11575__auto__){
var self__ = this;
var this__11575__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11566__auto__){
var self__ = this;
var this__11566__auto____$1 = this;
var h__11382__auto__ = self__.__hash;
if(!((h__11382__auto__ == null))){
return h__11382__auto__;
} else {
var h__11382__auto____$1 = cljs.core.hash_imap.call(null,this__11566__auto____$1);
self__.__hash = h__11382__auto____$1;

return h__11382__auto____$1;
}
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__11567__auto__,other__11568__auto__){
var self__ = this;
var this__11567__auto____$1 = this;
if(cljs.core.truth_((function (){var and__11272__auto__ = other__11568__auto__;
if(cljs.core.truth_(and__11272__auto__)){
return ((this__11567__auto____$1.constructor === other__11568__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__11567__auto____$1,other__11568__auto__));
} else {
return and__11272__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled.services.local_storage.LocalStorageIO.prototype.untangled$services$asyncio$AsyncIo$ = cljs.core.PROTOCOL_SENTINEL;


untangled.services.local_storage.LocalStorageIO.prototype.untangled$services$asyncio$AsyncIo$save$arity$5 = (function (this$,uri,goodfn,errorfn,data){
var self__ = this;
var this$__$1 = this;
var id = (cljs.core.truth_(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(data))?new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(data):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_uuid_utils.core.uuid_string.call(null,cljs_uuid_utils.core.make_random_uuid.call(null)))].join(''));
var data_with_id = cljs.core.assoc.call(null,data,new cljs.core.Keyword(null,"id","id",-1388402092),id);
var str_current = localStorage.getItem(uri);
var current_data = (cljs.core.truth_(str_current)?cljs.reader.read_string.call(null,str_current):cljs.core.PersistentVector.EMPTY);
var item_removed_data = cljs.core.remove.call(null,((function (id,data_with_id,str_current,current_data,this$__$1){
return (function (p1__64836_SHARP_){
return cljs.core._EQ_.call(null,id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),p1__64836_SHARP_], null));
});})(id,data_with_id,str_current,current_data,this$__$1))
,current_data);
var updated_data = cljs.core.conj.call(null,item_removed_data,data_with_id);
return untangled.services.local_storage.similate_delay.call(null,self__.simulated_delay,((function (id,data_with_id,str_current,current_data,item_removed_data,updated_data,this$__$1){
return (function (){
localStorage.setItem(uri,cljs.core.pr_str.call(null,updated_data));

return goodfn.call(null,data_with_id);
});})(id,data_with_id,str_current,current_data,item_removed_data,updated_data,this$__$1))
);
});


untangled.services.local_storage.LocalStorageIO.prototype.untangled$services$asyncio$AsyncIo$delete$arity$5 = (function (this$,uri,goodfn,errorfn,id){
var self__ = this;
var this$__$1 = this;
var current_data = cljs.reader.read_string.call(null,localStorage.getItem(uri));
var data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (current_data,this$__$1){
return (function (p1__64837_SHARP_){
return cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(p1__64837_SHARP_));
});})(current_data,this$__$1))
,current_data));
if((data == null)){
return errorfn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"not-found","not-found",-629079980),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
} else {
var updated_data = cljs.core.remove.call(null,((function (current_data,data,this$__$1){
return (function (p1__64838_SHARP_){
return cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(p1__64838_SHARP_));
});})(current_data,data,this$__$1))
,current_data);
return untangled.services.local_storage.similate_delay.call(null,self__.simulated_delay,((function (updated_data,current_data,data,this$__$1){
return (function (){
localStorage.setItem(uri,cljs.core.pr_str.call(null,updated_data));

return goodfn.call(null,id);
});})(updated_data,current_data,data,this$__$1))
);
}
});


untangled.services.local_storage.LocalStorageIO.prototype.untangled$services$asyncio$AsyncIo$fetch$arity$5 = (function (this$,uri,goodfn,errorfn,id){
var self__ = this;
var this$__$1 = this;
var current_str = localStorage.getItem(uri);
var current_data = (((current_str == null))?cljs.core.PersistentVector.EMPTY:cljs.reader.read_string.call(null,current_str));
var data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (current_str,current_data,this$__$1){
return (function (p1__64839_SHARP_){
return cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(p1__64839_SHARP_));
});})(current_str,current_data,this$__$1))
,current_data));
if((data == null)){
return errorfn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"not-found","not-found",-629079980),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
} else {
return untangled.services.local_storage.similate_delay.call(null,self__.simulated_delay,((function (current_str,current_data,data,this$__$1){
return (function (){
return goodfn.call(null,data);
});})(current_str,current_data,data,this$__$1))
);
}
});


untangled.services.local_storage.LocalStorageIO.prototype.untangled$services$asyncio$AsyncIo$query$arity$4 = (function (this$,uri,goodfn,errorfn){
var self__ = this;
var this$__$1 = this;
var current_str = localStorage.getItem(uri);
var current_data = (((current_str == null))?cljs.core.PersistentVector.EMPTY:cljs.reader.read_string.call(null,current_str));
return untangled.services.local_storage.similate_delay.call(null,self__.simulated_delay,((function (current_str,current_data,this$__$1){
return (function (){
return goodfn.call(null,current_data);
});})(current_str,current_data,this$__$1))
);
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__11580__auto__,k__11581__auto__){
var self__ = this;
var this__11580__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606),null,new cljs.core.Keyword(null,"async-report","async-report",-858808276),null], null), null),k__11581__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__11580__auto____$1),self__.__meta),k__11581__auto__);
} else {
return (new untangled.services.local_storage.LocalStorageIO(self__.async_report,self__.simulated_delay,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__11581__auto__)),null));
}
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__11578__auto__,k__11579__auto__,G__64840){
var self__ = this;
var this__11578__auto____$1 = this;
var pred__64844 = cljs.core.keyword_identical_QMARK_;
var expr__64845 = k__11579__auto__;
if(cljs.core.truth_(pred__64844.call(null,new cljs.core.Keyword(null,"async-report","async-report",-858808276),expr__64845))){
return (new untangled.services.local_storage.LocalStorageIO(G__64840,self__.simulated_delay,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__64844.call(null,new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606),expr__64845))){
return (new untangled.services.local_storage.LocalStorageIO(self__.async_report,G__64840,self__.__meta,self__.__extmap,null));
} else {
return (new untangled.services.local_storage.LocalStorageIO(self__.async_report,self__.simulated_delay,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__11579__auto__,G__64840),null));
}
}
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__11583__auto__){
var self__ = this;
var this__11583__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-report","async-report",-858808276),self__.async_report],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606),self__.simulated_delay],null))], null),self__.__extmap));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__11570__auto__,G__64840){
var self__ = this;
var this__11570__auto____$1 = this;
return (new untangled.services.local_storage.LocalStorageIO(self__.async_report,self__.simulated_delay,G__64840,self__.__extmap,self__.__hash));
});


untangled.services.local_storage.LocalStorageIO.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__11576__auto__,entry__11577__auto__){
var self__ = this;
var this__11576__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__11577__auto__)){
return this__11576__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__11577__auto__,(0)),cljs.core._nth.call(null,entry__11577__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__11576__auto____$1,entry__11577__auto__);
}
});

untangled.services.local_storage.LocalStorageIO.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"async-report","async-report",781723251,null),new cljs.core.Symbol(null,"simulated-delay","simulated-delay",813790921,null)], null);
});

untangled.services.local_storage.LocalStorageIO.cljs$lang$type = true;

untangled.services.local_storage.LocalStorageIO.cljs$lang$ctorPrSeq = (function (this__11607__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled.services.local-storage/LocalStorageIO");
});

untangled.services.local_storage.LocalStorageIO.cljs$lang$ctorPrWriter = (function (this__11607__auto__,writer__11608__auto__){
return cljs.core._write.call(null,writer__11608__auto__,"untangled.services.local-storage/LocalStorageIO");
});

untangled.services.local_storage.__GT_LocalStorageIO = (function untangled$services$local_storage$__GT_LocalStorageIO(async_report,simulated_delay){
return (new untangled.services.local_storage.LocalStorageIO(async_report,simulated_delay,null,null,null));
});

untangled.services.local_storage.map__GT_LocalStorageIO = (function untangled$services$local_storage$map__GT_LocalStorageIO(G__64842){
return (new untangled.services.local_storage.LocalStorageIO(new cljs.core.Keyword(null,"async-report","async-report",-858808276).cljs$core$IFn$_invoke$arity$1(G__64842),new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606).cljs$core$IFn$_invoke$arity$1(G__64842),null,cljs.core.dissoc.call(null,G__64842,new cljs.core.Keyword(null,"async-report","async-report",-858808276),new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606)),null));
});

/**
 * Create a new local storage async io component:
 *   - async-report component to report async request processing information
 *   - simulated-delay time in milliseconds
 *   
 */
untangled.services.local_storage.new_local_storage = (function untangled$services$local_storage$new_local_storage(async_report,simulated_delay){
var localio = untangled.services.local_storage.map__GT_LocalStorageIO.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"async-report","async-report",-858808276),async_report,new cljs.core.Keyword(null,"simulated-delay","simulated-delay",-826740606),simulated_delay], null));
localStorage.clear();

return localio;
});

//# sourceMappingURL=local_storage.js.map?rel=1486495684166