// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled_spec.async');
goog.require('cljs.core');
goog.require('cljs.pprint');

/**
 * @interface
 */
untangled_spec.async.IAsyncQueue = function(){};

/**
 * Returns the current time on the simulated clock, in ms
 */
untangled_spec.async.current_time = (function untangled_spec$async$current_time(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$current_time$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$current_time$arity$1(this$);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (untangled_spec.async.current_time[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$);
} else {
var m__11611__auto____$1 = (untangled_spec.async.current_time["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.current-time",this$);
}
}
}
});

/**
 * Returns the first event on the queue
 */
untangled_spec.async.peek_event = (function untangled_spec$async$peek_event(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1(this$);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (untangled_spec.async.peek_event[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$);
} else {
var m__11611__auto____$1 = (untangled_spec.async.peek_event["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.peek-event",this$);
}
}
}
});

/**
 * Move the clock forward by the specified number of ms, triggering events (even those added by interstitial triggers) in the correct order up to (and including) events that coincide with the final time.
 */
untangled_spec.async.advance_clock = (function untangled_spec$async$advance_clock(this$,ms){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 == null)))){
return this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2(this$,ms);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (untangled_spec.async.advance_clock[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,ms);
} else {
var m__11611__auto____$1 = (untangled_spec.async.advance_clock["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,ms);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.advance-clock",this$);
}
}
}
});

/**
 * Schedule an event which should occur at some time in the future (offset from now).
 */
untangled_spec.async.schedule_event = (function untangled_spec$async$schedule_event(this$,ms_from_now,fn_to_call){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 == null)))){
return this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3(this$,ms_from_now,fn_to_call);
} else {
var x__11610__auto__ = (((this$ == null))?null:this$);
var m__11611__auto__ = (untangled_spec.async.schedule_event[goog.typeOf(x__11610__auto__)]);
if(!((m__11611__auto__ == null))){
return m__11611__auto__.call(null,this$,ms_from_now,fn_to_call);
} else {
var m__11611__auto____$1 = (untangled_spec.async.schedule_event["_"]);
if(!((m__11611__auto____$1 == null))){
return m__11611__auto____$1.call(null,this$,ms_from_now,fn_to_call);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.schedule-event",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.Event = (function (abs_time,fn_to_call,__meta,__extmap,__hash){
this.abs_time = abs_time;
this.fn_to_call = fn_to_call;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__11571__auto__,k__11572__auto__){
var self__ = this;
var this__11571__auto____$1 = this;
return this__11571__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__11572__auto__,null);
});


untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__11573__auto__,k56418,else__11574__auto__){
var self__ = this;
var this__11573__auto____$1 = this;
var G__56420 = (((k56418 instanceof cljs.core.Keyword))?k56418.fqn:null);
switch (G__56420) {
case "abs-time":
return self__.abs_time;

break;
case "fn-to-call":
return self__.fn_to_call;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56418,else__11574__auto__);

}
});


untangled_spec.async.Event.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__11585__auto__,writer__11586__auto__,opts__11587__auto__){
var self__ = this;
var this__11585__auto____$1 = this;
var pr_pair__11588__auto__ = ((function (this__11585__auto____$1){
return (function (keyval__11589__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,cljs.core.pr_writer,""," ","",opts__11587__auto__,keyval__11589__auto__);
});})(this__11585__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,pr_pair__11588__auto__,"#untangled-spec.async.Event{",", ","}",opts__11587__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.Event.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56417){
var self__ = this;
var G__56417__$1 = this;
return (new cljs.core.RecordIter((0),G__56417__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.async.Event.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11569__auto__){
var self__ = this;
var this__11569__auto____$1 = this;
return self__.__meta;
});


untangled_spec.async.Event.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11565__auto__){
var self__ = this;
var this__11565__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.async.Event.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__11575__auto__){
var self__ = this;
var this__11575__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11566__auto__){
var self__ = this;
var this__11566__auto____$1 = this;
var h__11382__auto__ = self__.__hash;
if(!((h__11382__auto__ == null))){
return h__11382__auto__;
} else {
var h__11382__auto____$1 = cljs.core.hash_imap.call(null,this__11566__auto____$1);
self__.__hash = h__11382__auto____$1;

return h__11382__auto____$1;
}
});


untangled_spec.async.Event.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__11567__auto__,other__11568__auto__){
var self__ = this;
var this__11567__auto____$1 = this;
if(cljs.core.truth_((function (){var and__11272__auto__ = other__11568__auto__;
if(cljs.core.truth_(and__11272__auto__)){
return ((this__11567__auto____$1.constructor === other__11568__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__11567__auto____$1,other__11568__auto__));
} else {
return and__11272__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.async.Event.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__11580__auto__,k__11581__auto__){
var self__ = this;
var this__11580__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),null], null), null),k__11581__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__11580__auto____$1),self__.__meta),k__11581__auto__);
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__11581__auto__)),null));
}
});


untangled_spec.async.Event.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__11578__auto__,k__11579__auto__,G__56417){
var self__ = this;
var this__11578__auto____$1 = this;
var pred__56421 = cljs.core.keyword_identical_QMARK_;
var expr__56422 = k__11579__auto__;
if(cljs.core.truth_(pred__56421.call(null,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),expr__56422))){
return (new untangled_spec.async.Event(G__56417,self__.fn_to_call,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56421.call(null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),expr__56422))){
return (new untangled_spec.async.Event(self__.abs_time,G__56417,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__11579__auto__,G__56417),null));
}
}
});


untangled_spec.async.Event.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__11583__auto__){
var self__ = this;
var this__11583__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


untangled_spec.async.Event.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__11570__auto__,G__56417){
var self__ = this;
var this__11570__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,G__56417,self__.__extmap,self__.__hash));
});


untangled_spec.async.Event.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__11576__auto__,entry__11577__auto__){
var self__ = this;
var this__11576__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__11577__auto__)){
return this__11576__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__11577__auto__,(0)),cljs.core._nth.call(null,entry__11577__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__11576__auto____$1,entry__11577__auto__);
}
});

untangled_spec.async.Event.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"abs-time","abs-time",1700019601,null),new cljs.core.Symbol(null,"fn-to-call","fn-to-call",1043613154,null)], null);
});

untangled_spec.async.Event.cljs$lang$type = true;

untangled_spec.async.Event.cljs$lang$ctorPrSeq = (function (this__11607__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/Event");
});

untangled_spec.async.Event.cljs$lang$ctorPrWriter = (function (this__11607__auto__,writer__11608__auto__){
return cljs.core._write.call(null,writer__11608__auto__,"untangled-spec.async/Event");
});

untangled_spec.async.__GT_Event = (function untangled_spec$async$__GT_Event(abs_time,fn_to_call){
return (new untangled_spec.async.Event(abs_time,fn_to_call,null,null,null));
});

untangled_spec.async.map__GT_Event = (function untangled_spec$async$map__GT_Event(G__56419){
return (new untangled_spec.async.Event(new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(G__56419),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(G__56419),null,cljs.core.dissoc.call(null,G__56419,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)),null));
});

/**
 * Triggers the first event in the queue (runs it), and removes it from the queue.
 */
untangled_spec.async.process_first_event_BANG_ = (function untangled_spec$async$process_first_event_BANG_(queue){
var temp__6751__auto__ = untangled_spec.async.peek_event.call(null,queue);
if(cljs.core.truth_(temp__6751__auto__)){
var evt = temp__6751__auto__;
new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(evt).call(null);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(queue),((function (evt,temp__6751__auto__){
return (function (p1__56425_SHARP_){
return cljs.core.dissoc.call(null,p1__56425_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt));
});})(evt,temp__6751__auto__))
);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled_spec.async.IAsyncQueue}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.AsyncQueue = (function (schedule,now,__meta,__extmap,__hash){
this.schedule = schedule;
this.now = now;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__11571__auto__,k__11572__auto__){
var self__ = this;
var this__11571__auto____$1 = this;
return this__11571__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__11572__auto__,null);
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__11573__auto__,k56428,else__11574__auto__){
var self__ = this;
var this__11573__auto____$1 = this;
var G__56430 = (((k56428 instanceof cljs.core.Keyword))?k56428.fqn:null);
switch (G__56430) {
case "schedule":
return self__.schedule;

break;
case "now":
return self__.now;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56428,else__11574__auto__);

}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__11585__auto__,writer__11586__auto__,opts__11587__auto__){
var self__ = this;
var this__11585__auto____$1 = this;
var pr_pair__11588__auto__ = ((function (this__11585__auto____$1){
return (function (keyval__11589__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,cljs.core.pr_writer,""," ","",opts__11587__auto__,keyval__11589__auto__);
});})(this__11585__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__11586__auto__,pr_pair__11588__auto__,"#untangled-spec.async.AsyncQueue{",", ","}",opts__11587__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56427){
var self__ = this;
var G__56427__$1 = this;
return (new cljs.core.RecordIter((0),G__56427__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11569__auto__){
var self__ = this;
var this__11569__auto____$1 = this;
return self__.__meta;
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11565__auto__){
var self__ = this;
var this__11565__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__11575__auto__){
var self__ = this;
var this__11575__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11566__auto__){
var self__ = this;
var this__11566__auto____$1 = this;
var h__11382__auto__ = self__.__hash;
if(!((h__11382__auto__ == null))){
return h__11382__auto__;
} else {
var h__11382__auto____$1 = cljs.core.hash_imap.call(null,this__11566__auto____$1);
self__.__hash = h__11382__auto____$1;

return h__11382__auto____$1;
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__11567__auto__,other__11568__auto__){
var self__ = this;
var this__11567__auto____$1 = this;
if(cljs.core.truth_((function (){var and__11272__auto__ = other__11568__auto__;
if(cljs.core.truth_(and__11272__auto__)){
return ((this__11567__auto____$1.constructor === other__11568__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__11567__auto____$1,other__11568__auto__));
} else {
return and__11272__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$current_time$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1));
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$peek_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1))));
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 = (function (this$,ms){
var self__ = this;
var this$__$1 = this;
var stop_time = (ms + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var evt_56435 = this$__$1.untangled_spec$async$IAsyncQueue$peek_event$arity$1(null);
while(true){
var now_56436__$1 = (function (){var or__11280__auto__ = new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt_56435);
if(cljs.core.truth_(or__11280__auto__)){
return or__11280__auto__;
} else {
return (stop_time + (1));
}
})();
if((now_56436__$1 <= stop_time)){
cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),now_56436__$1);

untangled_spec.async.process_first_event_BANG_.call(null,this$__$1);

var G__56437 = this$__$1.untangled_spec$async$IAsyncQueue$peek_event$arity$1(null);
evt_56435 = G__56437;
continue;
} else {
}
break;
}

return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),stop_time);
});


untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 = (function (this$,ms_from_now,fn_to_call){
var self__ = this;
var this$__$1 = this;
var tm = (ms_from_now + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var event = (new untangled_spec.async.Event(tm,fn_to_call,null,null,null));
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1)),tm)){
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Schedule already contains an event "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(ms_from_now),cljs.core.str.cljs$core$IFn$_invoke$arity$1("ms from 'now' which would generate an indeterminant ordering for your events. Please offset your submission time a bit")].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1),((function (tm,event,this$__$1){
return (function (p1__56426_SHARP_){
return cljs.core.assoc.call(null,p1__56426_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(event),event);
});})(tm,event,this$__$1))
);
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__11580__auto__,k__11581__auto__){
var self__ = this;
var this__11580__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schedule","schedule",349275266),null,new cljs.core.Keyword(null,"now","now",-1650525531),null], null), null),k__11581__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__11580__auto____$1),self__.__meta),k__11581__auto__);
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__11581__auto__)),null));
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__11578__auto__,k__11579__auto__,G__56427){
var self__ = this;
var this__11578__auto____$1 = this;
var pred__56431 = cljs.core.keyword_identical_QMARK_;
var expr__56432 = k__11579__auto__;
if(cljs.core.truth_(pred__56431.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266),expr__56432))){
return (new untangled_spec.async.AsyncQueue(G__56427,self__.now,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56431.call(null,new cljs.core.Keyword(null,"now","now",-1650525531),expr__56432))){
return (new untangled_spec.async.AsyncQueue(self__.schedule,G__56427,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__11579__auto__,G__56427),null));
}
}
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__11583__auto__){
var self__ = this;
var this__11583__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__11570__auto__,G__56427){
var self__ = this;
var this__11570__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,G__56427,self__.__extmap,self__.__hash));
});


untangled_spec.async.AsyncQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__11576__auto__,entry__11577__auto__){
var self__ = this;
var this__11576__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__11577__auto__)){
return this__11576__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__11577__auto__,(0)),cljs.core._nth.call(null,entry__11577__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__11576__auto____$1,entry__11577__auto__);
}
});

untangled_spec.async.AsyncQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schedule","schedule",1989806793,null),new cljs.core.Symbol(null,"now","now",-9994004,null)], null);
});

untangled_spec.async.AsyncQueue.cljs$lang$type = true;

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrSeq = (function (this__11607__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrWriter = (function (this__11607__auto__,writer__11608__auto__){
return cljs.core._write.call(null,writer__11608__auto__,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.__GT_AsyncQueue = (function untangled_spec$async$__GT_AsyncQueue(schedule,now){
return (new untangled_spec.async.AsyncQueue(schedule,now,null,null,null));
});

untangled_spec.async.map__GT_AsyncQueue = (function untangled_spec$async$map__GT_AsyncQueue(G__56429){
return (new untangled_spec.async.AsyncQueue(new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(G__56429),new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(G__56429),null,cljs.core.dissoc.call(null,G__56429,new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)),null));
});

/**
 * Build an asynchronous event simulation queue.
 */
untangled_spec.async.make_async_queue = (function untangled_spec$async$make_async_queue(){
return (new untangled_spec.async.AsyncQueue(cljs.core.atom.call(null,cljs.core.sorted_map.call(null)),cljs.core.atom.call(null,(0)),null,null,null));
});

//# sourceMappingURL=async.js.map?rel=1486495668264