// Compiled by ClojureScript 1.9.456 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args57180 = [];
var len__28856__auto___57186 = arguments.length;
var i__28857__auto___57187 = (0);
while(true){
if((i__28857__auto___57187 < len__28856__auto___57186)){
args57180.push((arguments[i__28857__auto___57187]));

var G__57188 = (i__28857__auto___57187 + (1));
i__28857__auto___57187 = G__57188;
continue;
} else {
}
break;
}

var G__57182 = args57180.length;
switch (G__57182) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57180.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async57183 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57183 = (function (f,blockable,meta57184){
this.f = f;
this.blockable = blockable;
this.meta57184 = meta57184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57185,meta57184__$1){
var self__ = this;
var _57185__$1 = this;
return (new cljs.core.async.t_cljs$core$async57183(self__.f,self__.blockable,meta57184__$1));
});


cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57185){
var self__ = this;
var _57185__$1 = this;
return self__.meta57184;
});


cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async57183.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async57183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta57184","meta57184",-746594990,null)], null);
});

cljs.core.async.t_cljs$core$async57183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57183";

cljs.core.async.t_cljs$core$async57183.cljs$lang$ctorPrWriter = (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async57183");
});

cljs.core.async.__GT_t_cljs$core$async57183 = (function cljs$core$async$__GT_t_cljs$core$async57183(f__$1,blockable__$1,meta57184){
return (new cljs.core.async.t_cljs$core$async57183(f__$1,blockable__$1,meta57184));
});

}

return (new cljs.core.async.t_cljs$core$async57183(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args57192 = [];
var len__28856__auto___57195 = arguments.length;
var i__28857__auto___57196 = (0);
while(true){
if((i__28857__auto___57196 < len__28856__auto___57195)){
args57192.push((arguments[i__28857__auto___57196]));

var G__57197 = (i__28857__auto___57196 + (1));
i__28857__auto___57196 = G__57197;
continue;
} else {
}
break;
}

var G__57194 = args57192.length;
switch (G__57194) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57192.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args57199 = [];
var len__28856__auto___57202 = arguments.length;
var i__28857__auto___57203 = (0);
while(true){
if((i__28857__auto___57203 < len__28856__auto___57202)){
args57199.push((arguments[i__28857__auto___57203]));

var G__57204 = (i__28857__auto___57203 + (1));
i__28857__auto___57203 = G__57204;
continue;
} else {
}
break;
}

var G__57201 = args57199.length;
switch (G__57201) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57199.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args57206 = [];
var len__28856__auto___57209 = arguments.length;
var i__28857__auto___57210 = (0);
while(true){
if((i__28857__auto___57210 < len__28856__auto___57209)){
args57206.push((arguments[i__28857__auto___57210]));

var G__57211 = (i__28857__auto___57210 + (1));
i__28857__auto___57210 = G__57211;
continue;
} else {
}
break;
}

var G__57208 = args57206.length;
switch (G__57208) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57206.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_57213 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_57213);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_57213,ret){
return (function (){
return fn1.call(null,val_57213);
});})(val_57213,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args57214 = [];
var len__28856__auto___57217 = arguments.length;
var i__28857__auto___57218 = (0);
while(true){
if((i__28857__auto___57218 < len__28856__auto___57217)){
args57214.push((arguments[i__28857__auto___57218]));

var G__57219 = (i__28857__auto___57218 + (1));
i__28857__auto___57218 = G__57219;
continue;
} else {
}
break;
}

var G__57216 = args57214.length;
switch (G__57216) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57214.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28656__auto___57221 = n;
var x_57222 = (0);
while(true){
if((x_57222 < n__28656__auto___57221)){
(a[x_57222] = (0));

var G__57223 = (x_57222 + (1));
x_57222 = G__57223;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__57224 = (i + (1));
i = G__57224;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async57228 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57228 = (function (flag,meta57229){
this.flag = flag;
this.meta57229 = meta57229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_57230,meta57229__$1){
var self__ = this;
var _57230__$1 = this;
return (new cljs.core.async.t_cljs$core$async57228(self__.flag,meta57229__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_57230){
var self__ = this;
var _57230__$1 = this;
return self__.meta57229;
});})(flag))
;


cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async57228.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57228.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta57229","meta57229",100367211,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async57228.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57228.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57228";

cljs.core.async.t_cljs$core$async57228.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async57228");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async57228 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async57228(flag__$1,meta57229){
return (new cljs.core.async.t_cljs$core$async57228(flag__$1,meta57229));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async57228(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async57234 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57234 = (function (flag,cb,meta57235){
this.flag = flag;
this.cb = cb;
this.meta57235 = meta57235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57236,meta57235__$1){
var self__ = this;
var _57236__$1 = this;
return (new cljs.core.async.t_cljs$core$async57234(self__.flag,self__.cb,meta57235__$1));
});


cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57236){
var self__ = this;
var _57236__$1 = this;
return self__.meta57235;
});


cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async57234.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async57234.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta57235","meta57235",754233073,null)], null);
});

cljs.core.async.t_cljs$core$async57234.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57234.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57234";

cljs.core.async.t_cljs$core$async57234.cljs$lang$ctorPrWriter = (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async57234");
});

cljs.core.async.__GT_t_cljs$core$async57234 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async57234(flag__$1,cb__$1,meta57235){
return (new cljs.core.async.t_cljs$core$async57234(flag__$1,cb__$1,meta57235));
});

}

return (new cljs.core.async.t_cljs$core$async57234(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57237_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57237_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57238_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57238_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27635__auto__ = wport;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return port;
}
})()], null));
} else {
var G__57239 = (i + (1));
i = G__57239;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27635__auto__ = ret;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__27623__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27623__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27623__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___57245 = arguments.length;
var i__28857__auto___57246 = (0);
while(true){
if((i__28857__auto___57246 < len__28856__auto___57245)){
args__28863__auto__.push((arguments[i__28857__auto___57246]));

var G__57247 = (i__28857__auto___57246 + (1));
i__28857__auto___57246 = G__57247;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__57242){
var map__57243 = p__57242;
var map__57243__$1 = ((((!((map__57243 == null)))?((((map__57243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57243.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57243):map__57243);
var opts = map__57243__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq57240){
var G__57241 = cljs.core.first.call(null,seq57240);
var seq57240__$1 = cljs.core.next.call(null,seq57240);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57241,seq57240__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args57248 = [];
var len__28856__auto___57298 = arguments.length;
var i__28857__auto___57299 = (0);
while(true){
if((i__28857__auto___57299 < len__28856__auto___57298)){
args57248.push((arguments[i__28857__auto___57299]));

var G__57300 = (i__28857__auto___57299 + (1));
i__28857__auto___57299 = G__57300;
continue;
} else {
}
break;
}

var G__57250 = args57248.length;
switch (G__57250) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57248.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31463__auto___57302 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___57302){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___57302){
return (function (state_57274){
var state_val_57275 = (state_57274[(1)]);
if((state_val_57275 === (7))){
var inst_57270 = (state_57274[(2)]);
var state_57274__$1 = state_57274;
var statearr_57276_57303 = state_57274__$1;
(statearr_57276_57303[(2)] = inst_57270);

(statearr_57276_57303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (1))){
var state_57274__$1 = state_57274;
var statearr_57277_57304 = state_57274__$1;
(statearr_57277_57304[(2)] = null);

(statearr_57277_57304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (4))){
var inst_57253 = (state_57274[(7)]);
var inst_57253__$1 = (state_57274[(2)]);
var inst_57254 = (inst_57253__$1 == null);
var state_57274__$1 = (function (){var statearr_57278 = state_57274;
(statearr_57278[(7)] = inst_57253__$1);

return statearr_57278;
})();
if(cljs.core.truth_(inst_57254)){
var statearr_57279_57305 = state_57274__$1;
(statearr_57279_57305[(1)] = (5));

} else {
var statearr_57280_57306 = state_57274__$1;
(statearr_57280_57306[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (13))){
var state_57274__$1 = state_57274;
var statearr_57281_57307 = state_57274__$1;
(statearr_57281_57307[(2)] = null);

(statearr_57281_57307[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (6))){
var inst_57253 = (state_57274[(7)]);
var state_57274__$1 = state_57274;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57274__$1,(11),to,inst_57253);
} else {
if((state_val_57275 === (3))){
var inst_57272 = (state_57274[(2)]);
var state_57274__$1 = state_57274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57274__$1,inst_57272);
} else {
if((state_val_57275 === (12))){
var state_57274__$1 = state_57274;
var statearr_57282_57308 = state_57274__$1;
(statearr_57282_57308[(2)] = null);

(statearr_57282_57308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (2))){
var state_57274__$1 = state_57274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57274__$1,(4),from);
} else {
if((state_val_57275 === (11))){
var inst_57263 = (state_57274[(2)]);
var state_57274__$1 = state_57274;
if(cljs.core.truth_(inst_57263)){
var statearr_57283_57309 = state_57274__$1;
(statearr_57283_57309[(1)] = (12));

} else {
var statearr_57284_57310 = state_57274__$1;
(statearr_57284_57310[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (9))){
var state_57274__$1 = state_57274;
var statearr_57285_57311 = state_57274__$1;
(statearr_57285_57311[(2)] = null);

(statearr_57285_57311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (5))){
var state_57274__$1 = state_57274;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57286_57312 = state_57274__$1;
(statearr_57286_57312[(1)] = (8));

} else {
var statearr_57287_57313 = state_57274__$1;
(statearr_57287_57313[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (14))){
var inst_57268 = (state_57274[(2)]);
var state_57274__$1 = state_57274;
var statearr_57288_57314 = state_57274__$1;
(statearr_57288_57314[(2)] = inst_57268);

(statearr_57288_57314[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (10))){
var inst_57260 = (state_57274[(2)]);
var state_57274__$1 = state_57274;
var statearr_57289_57315 = state_57274__$1;
(statearr_57289_57315[(2)] = inst_57260);

(statearr_57289_57315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57275 === (8))){
var inst_57257 = cljs.core.async.close_BANG_.call(null,to);
var state_57274__$1 = state_57274;
var statearr_57290_57316 = state_57274__$1;
(statearr_57290_57316[(2)] = inst_57257);

(statearr_57290_57316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___57302))
;
return ((function (switch__31349__auto__,c__31463__auto___57302){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_57294 = [null,null,null,null,null,null,null,null];
(statearr_57294[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_57294[(1)] = (1));

return statearr_57294;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_57274){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57295){if((e57295 instanceof Object)){
var ex__31353__auto__ = e57295;
var statearr_57296_57317 = state_57274;
(statearr_57296_57317[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57274);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57295;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57318 = state_57274;
state_57274 = G__57318;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_57274){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_57274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___57302))
})();
var state__31465__auto__ = (function (){var statearr_57297 = f__31464__auto__.call(null);
(statearr_57297[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57302);

return statearr_57297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___57302))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__57506){
var vec__57507 = p__57506;
var v = cljs.core.nth.call(null,vec__57507,(0),null);
var p = cljs.core.nth.call(null,vec__57507,(1),null);
var job = vec__57507;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__31463__auto___57693 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results){
return (function (state_57514){
var state_val_57515 = (state_57514[(1)]);
if((state_val_57515 === (1))){
var state_57514__$1 = state_57514;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57514__$1,(2),res,v);
} else {
if((state_val_57515 === (2))){
var inst_57511 = (state_57514[(2)]);
var inst_57512 = cljs.core.async.close_BANG_.call(null,res);
var state_57514__$1 = (function (){var statearr_57516 = state_57514;
(statearr_57516[(7)] = inst_57511);

return statearr_57516;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57514__$1,inst_57512);
} else {
return null;
}
}
});})(c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results))
;
return ((function (switch__31349__auto__,c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_57520 = [null,null,null,null,null,null,null,null];
(statearr_57520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__);

(statearr_57520[(1)] = (1));

return statearr_57520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1 = (function (state_57514){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57521){if((e57521 instanceof Object)){
var ex__31353__auto__ = e57521;
var statearr_57522_57694 = state_57514;
(statearr_57522_57694[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57514);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57695 = state_57514;
state_57514 = G__57695;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = function(state_57514){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1.call(this,state_57514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results))
})();
var state__31465__auto__ = (function (){var statearr_57523 = f__31464__auto__.call(null);
(statearr_57523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57693);

return statearr_57523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___57693,res,vec__57507,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__57524){
var vec__57525 = p__57524;
var v = cljs.core.nth.call(null,vec__57525,(0),null);
var p = cljs.core.nth.call(null,vec__57525,(1),null);
var job = vec__57525;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28656__auto___57696 = n;
var __57697 = (0);
while(true){
if((__57697 < n__28656__auto___57696)){
var G__57528_57698 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__57528_57698) {
case "compute":
var c__31463__auto___57700 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__57697,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (__57697,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function (state_57541){
var state_val_57542 = (state_57541[(1)]);
if((state_val_57542 === (1))){
var state_57541__$1 = state_57541;
var statearr_57543_57701 = state_57541__$1;
(statearr_57543_57701[(2)] = null);

(statearr_57543_57701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (2))){
var state_57541__$1 = state_57541;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57541__$1,(4),jobs);
} else {
if((state_val_57542 === (3))){
var inst_57539 = (state_57541[(2)]);
var state_57541__$1 = state_57541;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57541__$1,inst_57539);
} else {
if((state_val_57542 === (4))){
var inst_57531 = (state_57541[(2)]);
var inst_57532 = process.call(null,inst_57531);
var state_57541__$1 = state_57541;
if(cljs.core.truth_(inst_57532)){
var statearr_57544_57702 = state_57541__$1;
(statearr_57544_57702[(1)] = (5));

} else {
var statearr_57545_57703 = state_57541__$1;
(statearr_57545_57703[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (5))){
var state_57541__$1 = state_57541;
var statearr_57546_57704 = state_57541__$1;
(statearr_57546_57704[(2)] = null);

(statearr_57546_57704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (6))){
var state_57541__$1 = state_57541;
var statearr_57547_57705 = state_57541__$1;
(statearr_57547_57705[(2)] = null);

(statearr_57547_57705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (7))){
var inst_57537 = (state_57541[(2)]);
var state_57541__$1 = state_57541;
var statearr_57548_57706 = state_57541__$1;
(statearr_57548_57706[(2)] = inst_57537);

(statearr_57548_57706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__57697,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
;
return ((function (__57697,switch__31349__auto__,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_57552 = [null,null,null,null,null,null,null];
(statearr_57552[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__);

(statearr_57552[(1)] = (1));

return statearr_57552;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1 = (function (state_57541){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57541);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57553){if((e57553 instanceof Object)){
var ex__31353__auto__ = e57553;
var statearr_57554_57707 = state_57541;
(statearr_57554_57707[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57541);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57708 = state_57541;
state_57541 = G__57708;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = function(state_57541){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1.call(this,state_57541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__;
})()
;})(__57697,switch__31349__auto__,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
})();
var state__31465__auto__ = (function (){var statearr_57555 = f__31464__auto__.call(null);
(statearr_57555[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57700);

return statearr_57555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(__57697,c__31463__auto___57700,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
);


break;
case "async":
var c__31463__auto___57709 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__57697,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (__57697,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function (state_57568){
var state_val_57569 = (state_57568[(1)]);
if((state_val_57569 === (1))){
var state_57568__$1 = state_57568;
var statearr_57570_57710 = state_57568__$1;
(statearr_57570_57710[(2)] = null);

(statearr_57570_57710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (2))){
var state_57568__$1 = state_57568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57568__$1,(4),jobs);
} else {
if((state_val_57569 === (3))){
var inst_57566 = (state_57568[(2)]);
var state_57568__$1 = state_57568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57568__$1,inst_57566);
} else {
if((state_val_57569 === (4))){
var inst_57558 = (state_57568[(2)]);
var inst_57559 = async.call(null,inst_57558);
var state_57568__$1 = state_57568;
if(cljs.core.truth_(inst_57559)){
var statearr_57571_57711 = state_57568__$1;
(statearr_57571_57711[(1)] = (5));

} else {
var statearr_57572_57712 = state_57568__$1;
(statearr_57572_57712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (5))){
var state_57568__$1 = state_57568;
var statearr_57573_57713 = state_57568__$1;
(statearr_57573_57713[(2)] = null);

(statearr_57573_57713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (6))){
var state_57568__$1 = state_57568;
var statearr_57574_57714 = state_57568__$1;
(statearr_57574_57714[(2)] = null);

(statearr_57574_57714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (7))){
var inst_57564 = (state_57568[(2)]);
var state_57568__$1 = state_57568;
var statearr_57575_57715 = state_57568__$1;
(statearr_57575_57715[(2)] = inst_57564);

(statearr_57575_57715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__57697,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
;
return ((function (__57697,switch__31349__auto__,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_57579 = [null,null,null,null,null,null,null];
(statearr_57579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__);

(statearr_57579[(1)] = (1));

return statearr_57579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1 = (function (state_57568){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57580){if((e57580 instanceof Object)){
var ex__31353__auto__ = e57580;
var statearr_57581_57716 = state_57568;
(statearr_57581_57716[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57580;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57717 = state_57568;
state_57568 = G__57717;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = function(state_57568){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1.call(this,state_57568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__;
})()
;})(__57697,switch__31349__auto__,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
})();
var state__31465__auto__ = (function (){var statearr_57582 = f__31464__auto__.call(null);
(statearr_57582[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57709);

return statearr_57582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(__57697,c__31463__auto___57709,G__57528_57698,n__28656__auto___57696,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__57718 = (__57697 + (1));
__57697 = G__57718;
continue;
} else {
}
break;
}

var c__31463__auto___57719 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___57719,jobs,results,process,async){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___57719,jobs,results,process,async){
return (function (state_57604){
var state_val_57605 = (state_57604[(1)]);
if((state_val_57605 === (1))){
var state_57604__$1 = state_57604;
var statearr_57606_57720 = state_57604__$1;
(statearr_57606_57720[(2)] = null);

(statearr_57606_57720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57605 === (2))){
var state_57604__$1 = state_57604;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57604__$1,(4),from);
} else {
if((state_val_57605 === (3))){
var inst_57602 = (state_57604[(2)]);
var state_57604__$1 = state_57604;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57604__$1,inst_57602);
} else {
if((state_val_57605 === (4))){
var inst_57585 = (state_57604[(7)]);
var inst_57585__$1 = (state_57604[(2)]);
var inst_57586 = (inst_57585__$1 == null);
var state_57604__$1 = (function (){var statearr_57607 = state_57604;
(statearr_57607[(7)] = inst_57585__$1);

return statearr_57607;
})();
if(cljs.core.truth_(inst_57586)){
var statearr_57608_57721 = state_57604__$1;
(statearr_57608_57721[(1)] = (5));

} else {
var statearr_57609_57722 = state_57604__$1;
(statearr_57609_57722[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57605 === (5))){
var inst_57588 = cljs.core.async.close_BANG_.call(null,jobs);
var state_57604__$1 = state_57604;
var statearr_57610_57723 = state_57604__$1;
(statearr_57610_57723[(2)] = inst_57588);

(statearr_57610_57723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57605 === (6))){
var inst_57585 = (state_57604[(7)]);
var inst_57590 = (state_57604[(8)]);
var inst_57590__$1 = cljs.core.async.chan.call(null,(1));
var inst_57591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57592 = [inst_57585,inst_57590__$1];
var inst_57593 = (new cljs.core.PersistentVector(null,2,(5),inst_57591,inst_57592,null));
var state_57604__$1 = (function (){var statearr_57611 = state_57604;
(statearr_57611[(8)] = inst_57590__$1);

return statearr_57611;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57604__$1,(8),jobs,inst_57593);
} else {
if((state_val_57605 === (7))){
var inst_57600 = (state_57604[(2)]);
var state_57604__$1 = state_57604;
var statearr_57612_57724 = state_57604__$1;
(statearr_57612_57724[(2)] = inst_57600);

(statearr_57612_57724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57605 === (8))){
var inst_57590 = (state_57604[(8)]);
var inst_57595 = (state_57604[(2)]);
var state_57604__$1 = (function (){var statearr_57613 = state_57604;
(statearr_57613[(9)] = inst_57595);

return statearr_57613;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57604__$1,(9),results,inst_57590);
} else {
if((state_val_57605 === (9))){
var inst_57597 = (state_57604[(2)]);
var state_57604__$1 = (function (){var statearr_57614 = state_57604;
(statearr_57614[(10)] = inst_57597);

return statearr_57614;
})();
var statearr_57615_57725 = state_57604__$1;
(statearr_57615_57725[(2)] = null);

(statearr_57615_57725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___57719,jobs,results,process,async))
;
return ((function (switch__31349__auto__,c__31463__auto___57719,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_57619 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_57619[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__);

(statearr_57619[(1)] = (1));

return statearr_57619;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1 = (function (state_57604){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57604);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57620){if((e57620 instanceof Object)){
var ex__31353__auto__ = e57620;
var statearr_57621_57726 = state_57604;
(statearr_57621_57726[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57604);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57727 = state_57604;
state_57604 = G__57727;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = function(state_57604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1.call(this,state_57604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___57719,jobs,results,process,async))
})();
var state__31465__auto__ = (function (){var statearr_57622 = f__31464__auto__.call(null);
(statearr_57622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57719);

return statearr_57622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___57719,jobs,results,process,async))
);


var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__,jobs,results,process,async){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__,jobs,results,process,async){
return (function (state_57660){
var state_val_57661 = (state_57660[(1)]);
if((state_val_57661 === (7))){
var inst_57656 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57662_57728 = state_57660__$1;
(statearr_57662_57728[(2)] = inst_57656);

(statearr_57662_57728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (20))){
var state_57660__$1 = state_57660;
var statearr_57663_57729 = state_57660__$1;
(statearr_57663_57729[(2)] = null);

(statearr_57663_57729[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (1))){
var state_57660__$1 = state_57660;
var statearr_57664_57730 = state_57660__$1;
(statearr_57664_57730[(2)] = null);

(statearr_57664_57730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (4))){
var inst_57625 = (state_57660[(7)]);
var inst_57625__$1 = (state_57660[(2)]);
var inst_57626 = (inst_57625__$1 == null);
var state_57660__$1 = (function (){var statearr_57665 = state_57660;
(statearr_57665[(7)] = inst_57625__$1);

return statearr_57665;
})();
if(cljs.core.truth_(inst_57626)){
var statearr_57666_57731 = state_57660__$1;
(statearr_57666_57731[(1)] = (5));

} else {
var statearr_57667_57732 = state_57660__$1;
(statearr_57667_57732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (15))){
var inst_57638 = (state_57660[(8)]);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57660__$1,(18),to,inst_57638);
} else {
if((state_val_57661 === (21))){
var inst_57651 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57668_57733 = state_57660__$1;
(statearr_57668_57733[(2)] = inst_57651);

(statearr_57668_57733[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (13))){
var inst_57653 = (state_57660[(2)]);
var state_57660__$1 = (function (){var statearr_57669 = state_57660;
(statearr_57669[(9)] = inst_57653);

return statearr_57669;
})();
var statearr_57670_57734 = state_57660__$1;
(statearr_57670_57734[(2)] = null);

(statearr_57670_57734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (6))){
var inst_57625 = (state_57660[(7)]);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57660__$1,(11),inst_57625);
} else {
if((state_val_57661 === (17))){
var inst_57646 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
if(cljs.core.truth_(inst_57646)){
var statearr_57671_57735 = state_57660__$1;
(statearr_57671_57735[(1)] = (19));

} else {
var statearr_57672_57736 = state_57660__$1;
(statearr_57672_57736[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (3))){
var inst_57658 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57660__$1,inst_57658);
} else {
if((state_val_57661 === (12))){
var inst_57635 = (state_57660[(10)]);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57660__$1,(14),inst_57635);
} else {
if((state_val_57661 === (2))){
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57660__$1,(4),results);
} else {
if((state_val_57661 === (19))){
var state_57660__$1 = state_57660;
var statearr_57673_57737 = state_57660__$1;
(statearr_57673_57737[(2)] = null);

(statearr_57673_57737[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (11))){
var inst_57635 = (state_57660[(2)]);
var state_57660__$1 = (function (){var statearr_57674 = state_57660;
(statearr_57674[(10)] = inst_57635);

return statearr_57674;
})();
var statearr_57675_57738 = state_57660__$1;
(statearr_57675_57738[(2)] = null);

(statearr_57675_57738[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (9))){
var state_57660__$1 = state_57660;
var statearr_57676_57739 = state_57660__$1;
(statearr_57676_57739[(2)] = null);

(statearr_57676_57739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (5))){
var state_57660__$1 = state_57660;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57677_57740 = state_57660__$1;
(statearr_57677_57740[(1)] = (8));

} else {
var statearr_57678_57741 = state_57660__$1;
(statearr_57678_57741[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (14))){
var inst_57638 = (state_57660[(8)]);
var inst_57640 = (state_57660[(11)]);
var inst_57638__$1 = (state_57660[(2)]);
var inst_57639 = (inst_57638__$1 == null);
var inst_57640__$1 = cljs.core.not.call(null,inst_57639);
var state_57660__$1 = (function (){var statearr_57679 = state_57660;
(statearr_57679[(8)] = inst_57638__$1);

(statearr_57679[(11)] = inst_57640__$1);

return statearr_57679;
})();
if(inst_57640__$1){
var statearr_57680_57742 = state_57660__$1;
(statearr_57680_57742[(1)] = (15));

} else {
var statearr_57681_57743 = state_57660__$1;
(statearr_57681_57743[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (16))){
var inst_57640 = (state_57660[(11)]);
var state_57660__$1 = state_57660;
var statearr_57682_57744 = state_57660__$1;
(statearr_57682_57744[(2)] = inst_57640);

(statearr_57682_57744[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (10))){
var inst_57632 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57683_57745 = state_57660__$1;
(statearr_57683_57745[(2)] = inst_57632);

(statearr_57683_57745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (18))){
var inst_57643 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57684_57746 = state_57660__$1;
(statearr_57684_57746[(2)] = inst_57643);

(statearr_57684_57746[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (8))){
var inst_57629 = cljs.core.async.close_BANG_.call(null,to);
var state_57660__$1 = state_57660;
var statearr_57685_57747 = state_57660__$1;
(statearr_57685_57747[(2)] = inst_57629);

(statearr_57685_57747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__,jobs,results,process,async))
;
return ((function (switch__31349__auto__,c__31463__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_57689 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57689[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__);

(statearr_57689[(1)] = (1));

return statearr_57689;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1 = (function (state_57660){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57690){if((e57690 instanceof Object)){
var ex__31353__auto__ = e57690;
var statearr_57691_57748 = state_57660;
(statearr_57691_57748[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57660);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57749 = state_57660;
state_57660 = G__57749;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__ = function(state_57660){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1.call(this,state_57660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__,jobs,results,process,async))
})();
var state__31465__auto__ = (function (){var statearr_57692 = f__31464__auto__.call(null);
(statearr_57692[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_57692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__,jobs,results,process,async))
);

return c__31463__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args57750 = [];
var len__28856__auto___57753 = arguments.length;
var i__28857__auto___57754 = (0);
while(true){
if((i__28857__auto___57754 < len__28856__auto___57753)){
args57750.push((arguments[i__28857__auto___57754]));

var G__57755 = (i__28857__auto___57754 + (1));
i__28857__auto___57754 = G__57755;
continue;
} else {
}
break;
}

var G__57752 = args57750.length;
switch (G__57752) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57750.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args57757 = [];
var len__28856__auto___57760 = arguments.length;
var i__28857__auto___57761 = (0);
while(true){
if((i__28857__auto___57761 < len__28856__auto___57760)){
args57757.push((arguments[i__28857__auto___57761]));

var G__57762 = (i__28857__auto___57761 + (1));
i__28857__auto___57761 = G__57762;
continue;
} else {
}
break;
}

var G__57759 = args57757.length;
switch (G__57759) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57757.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args57764 = [];
var len__28856__auto___57817 = arguments.length;
var i__28857__auto___57818 = (0);
while(true){
if((i__28857__auto___57818 < len__28856__auto___57817)){
args57764.push((arguments[i__28857__auto___57818]));

var G__57819 = (i__28857__auto___57818 + (1));
i__28857__auto___57818 = G__57819;
continue;
} else {
}
break;
}

var G__57766 = args57764.length;
switch (G__57766) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57764.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__31463__auto___57821 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___57821,tc,fc){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___57821,tc,fc){
return (function (state_57792){
var state_val_57793 = (state_57792[(1)]);
if((state_val_57793 === (7))){
var inst_57788 = (state_57792[(2)]);
var state_57792__$1 = state_57792;
var statearr_57794_57822 = state_57792__$1;
(statearr_57794_57822[(2)] = inst_57788);

(statearr_57794_57822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (1))){
var state_57792__$1 = state_57792;
var statearr_57795_57823 = state_57792__$1;
(statearr_57795_57823[(2)] = null);

(statearr_57795_57823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (4))){
var inst_57769 = (state_57792[(7)]);
var inst_57769__$1 = (state_57792[(2)]);
var inst_57770 = (inst_57769__$1 == null);
var state_57792__$1 = (function (){var statearr_57796 = state_57792;
(statearr_57796[(7)] = inst_57769__$1);

return statearr_57796;
})();
if(cljs.core.truth_(inst_57770)){
var statearr_57797_57824 = state_57792__$1;
(statearr_57797_57824[(1)] = (5));

} else {
var statearr_57798_57825 = state_57792__$1;
(statearr_57798_57825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (13))){
var state_57792__$1 = state_57792;
var statearr_57799_57826 = state_57792__$1;
(statearr_57799_57826[(2)] = null);

(statearr_57799_57826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (6))){
var inst_57769 = (state_57792[(7)]);
var inst_57775 = p.call(null,inst_57769);
var state_57792__$1 = state_57792;
if(cljs.core.truth_(inst_57775)){
var statearr_57800_57827 = state_57792__$1;
(statearr_57800_57827[(1)] = (9));

} else {
var statearr_57801_57828 = state_57792__$1;
(statearr_57801_57828[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (3))){
var inst_57790 = (state_57792[(2)]);
var state_57792__$1 = state_57792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57792__$1,inst_57790);
} else {
if((state_val_57793 === (12))){
var state_57792__$1 = state_57792;
var statearr_57802_57829 = state_57792__$1;
(statearr_57802_57829[(2)] = null);

(statearr_57802_57829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (2))){
var state_57792__$1 = state_57792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57792__$1,(4),ch);
} else {
if((state_val_57793 === (11))){
var inst_57769 = (state_57792[(7)]);
var inst_57779 = (state_57792[(2)]);
var state_57792__$1 = state_57792;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57792__$1,(8),inst_57779,inst_57769);
} else {
if((state_val_57793 === (9))){
var state_57792__$1 = state_57792;
var statearr_57803_57830 = state_57792__$1;
(statearr_57803_57830[(2)] = tc);

(statearr_57803_57830[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (5))){
var inst_57772 = cljs.core.async.close_BANG_.call(null,tc);
var inst_57773 = cljs.core.async.close_BANG_.call(null,fc);
var state_57792__$1 = (function (){var statearr_57804 = state_57792;
(statearr_57804[(8)] = inst_57772);

return statearr_57804;
})();
var statearr_57805_57831 = state_57792__$1;
(statearr_57805_57831[(2)] = inst_57773);

(statearr_57805_57831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (14))){
var inst_57786 = (state_57792[(2)]);
var state_57792__$1 = state_57792;
var statearr_57806_57832 = state_57792__$1;
(statearr_57806_57832[(2)] = inst_57786);

(statearr_57806_57832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (10))){
var state_57792__$1 = state_57792;
var statearr_57807_57833 = state_57792__$1;
(statearr_57807_57833[(2)] = fc);

(statearr_57807_57833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57793 === (8))){
var inst_57781 = (state_57792[(2)]);
var state_57792__$1 = state_57792;
if(cljs.core.truth_(inst_57781)){
var statearr_57808_57834 = state_57792__$1;
(statearr_57808_57834[(1)] = (12));

} else {
var statearr_57809_57835 = state_57792__$1;
(statearr_57809_57835[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___57821,tc,fc))
;
return ((function (switch__31349__auto__,c__31463__auto___57821,tc,fc){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_57813 = [null,null,null,null,null,null,null,null,null];
(statearr_57813[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_57813[(1)] = (1));

return statearr_57813;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_57792){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57814){if((e57814 instanceof Object)){
var ex__31353__auto__ = e57814;
var statearr_57815_57836 = state_57792;
(statearr_57815_57836[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57837 = state_57792;
state_57792 = G__57837;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_57792){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_57792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___57821,tc,fc))
})();
var state__31465__auto__ = (function (){var statearr_57816 = f__31464__auto__.call(null);
(statearr_57816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___57821);

return statearr_57816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___57821,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_57901){
var state_val_57902 = (state_57901[(1)]);
if((state_val_57902 === (7))){
var inst_57897 = (state_57901[(2)]);
var state_57901__$1 = state_57901;
var statearr_57903_57924 = state_57901__$1;
(statearr_57903_57924[(2)] = inst_57897);

(statearr_57903_57924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (1))){
var inst_57881 = init;
var state_57901__$1 = (function (){var statearr_57904 = state_57901;
(statearr_57904[(7)] = inst_57881);

return statearr_57904;
})();
var statearr_57905_57925 = state_57901__$1;
(statearr_57905_57925[(2)] = null);

(statearr_57905_57925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (4))){
var inst_57884 = (state_57901[(8)]);
var inst_57884__$1 = (state_57901[(2)]);
var inst_57885 = (inst_57884__$1 == null);
var state_57901__$1 = (function (){var statearr_57906 = state_57901;
(statearr_57906[(8)] = inst_57884__$1);

return statearr_57906;
})();
if(cljs.core.truth_(inst_57885)){
var statearr_57907_57926 = state_57901__$1;
(statearr_57907_57926[(1)] = (5));

} else {
var statearr_57908_57927 = state_57901__$1;
(statearr_57908_57927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (6))){
var inst_57881 = (state_57901[(7)]);
var inst_57884 = (state_57901[(8)]);
var inst_57888 = (state_57901[(9)]);
var inst_57888__$1 = f.call(null,inst_57881,inst_57884);
var inst_57889 = cljs.core.reduced_QMARK_.call(null,inst_57888__$1);
var state_57901__$1 = (function (){var statearr_57909 = state_57901;
(statearr_57909[(9)] = inst_57888__$1);

return statearr_57909;
})();
if(inst_57889){
var statearr_57910_57928 = state_57901__$1;
(statearr_57910_57928[(1)] = (8));

} else {
var statearr_57911_57929 = state_57901__$1;
(statearr_57911_57929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (3))){
var inst_57899 = (state_57901[(2)]);
var state_57901__$1 = state_57901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57901__$1,inst_57899);
} else {
if((state_val_57902 === (2))){
var state_57901__$1 = state_57901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57901__$1,(4),ch);
} else {
if((state_val_57902 === (9))){
var inst_57888 = (state_57901[(9)]);
var inst_57881 = inst_57888;
var state_57901__$1 = (function (){var statearr_57912 = state_57901;
(statearr_57912[(7)] = inst_57881);

return statearr_57912;
})();
var statearr_57913_57930 = state_57901__$1;
(statearr_57913_57930[(2)] = null);

(statearr_57913_57930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (5))){
var inst_57881 = (state_57901[(7)]);
var state_57901__$1 = state_57901;
var statearr_57914_57931 = state_57901__$1;
(statearr_57914_57931[(2)] = inst_57881);

(statearr_57914_57931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (10))){
var inst_57895 = (state_57901[(2)]);
var state_57901__$1 = state_57901;
var statearr_57915_57932 = state_57901__$1;
(statearr_57915_57932[(2)] = inst_57895);

(statearr_57915_57932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57902 === (8))){
var inst_57888 = (state_57901[(9)]);
var inst_57891 = cljs.core.deref.call(null,inst_57888);
var state_57901__$1 = state_57901;
var statearr_57916_57933 = state_57901__$1;
(statearr_57916_57933[(2)] = inst_57891);

(statearr_57916_57933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31350__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31350__auto____0 = (function (){
var statearr_57920 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57920[(0)] = cljs$core$async$reduce_$_state_machine__31350__auto__);

(statearr_57920[(1)] = (1));

return statearr_57920;
});
var cljs$core$async$reduce_$_state_machine__31350__auto____1 = (function (state_57901){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57921){if((e57921 instanceof Object)){
var ex__31353__auto__ = e57921;
var statearr_57922_57934 = state_57901;
(statearr_57922_57934[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57935 = state_57901;
state_57901 = G__57935;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31350__auto__ = function(state_57901){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31350__auto____1.call(this,state_57901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31350__auto____0;
cljs$core$async$reduce_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31350__auto____1;
return cljs$core$async$reduce_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_57923 = f__31464__auto__.call(null);
(statearr_57923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_57923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args57936 = [];
var len__28856__auto___57988 = arguments.length;
var i__28857__auto___57989 = (0);
while(true){
if((i__28857__auto___57989 < len__28856__auto___57988)){
args57936.push((arguments[i__28857__auto___57989]));

var G__57990 = (i__28857__auto___57989 + (1));
i__28857__auto___57989 = G__57990;
continue;
} else {
}
break;
}

var G__57938 = args57936.length;
switch (G__57938) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57936.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_57963){
var state_val_57964 = (state_57963[(1)]);
if((state_val_57964 === (7))){
var inst_57945 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
var statearr_57965_57992 = state_57963__$1;
(statearr_57965_57992[(2)] = inst_57945);

(statearr_57965_57992[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (1))){
var inst_57939 = cljs.core.seq.call(null,coll);
var inst_57940 = inst_57939;
var state_57963__$1 = (function (){var statearr_57966 = state_57963;
(statearr_57966[(7)] = inst_57940);

return statearr_57966;
})();
var statearr_57967_57993 = state_57963__$1;
(statearr_57967_57993[(2)] = null);

(statearr_57967_57993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (4))){
var inst_57940 = (state_57963[(7)]);
var inst_57943 = cljs.core.first.call(null,inst_57940);
var state_57963__$1 = state_57963;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57963__$1,(7),ch,inst_57943);
} else {
if((state_val_57964 === (13))){
var inst_57957 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
var statearr_57968_57994 = state_57963__$1;
(statearr_57968_57994[(2)] = inst_57957);

(statearr_57968_57994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (6))){
var inst_57948 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
if(cljs.core.truth_(inst_57948)){
var statearr_57969_57995 = state_57963__$1;
(statearr_57969_57995[(1)] = (8));

} else {
var statearr_57970_57996 = state_57963__$1;
(statearr_57970_57996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (3))){
var inst_57961 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57963__$1,inst_57961);
} else {
if((state_val_57964 === (12))){
var state_57963__$1 = state_57963;
var statearr_57971_57997 = state_57963__$1;
(statearr_57971_57997[(2)] = null);

(statearr_57971_57997[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (2))){
var inst_57940 = (state_57963[(7)]);
var state_57963__$1 = state_57963;
if(cljs.core.truth_(inst_57940)){
var statearr_57972_57998 = state_57963__$1;
(statearr_57972_57998[(1)] = (4));

} else {
var statearr_57973_57999 = state_57963__$1;
(statearr_57973_57999[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (11))){
var inst_57954 = cljs.core.async.close_BANG_.call(null,ch);
var state_57963__$1 = state_57963;
var statearr_57974_58000 = state_57963__$1;
(statearr_57974_58000[(2)] = inst_57954);

(statearr_57974_58000[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (9))){
var state_57963__$1 = state_57963;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57975_58001 = state_57963__$1;
(statearr_57975_58001[(1)] = (11));

} else {
var statearr_57976_58002 = state_57963__$1;
(statearr_57976_58002[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (5))){
var inst_57940 = (state_57963[(7)]);
var state_57963__$1 = state_57963;
var statearr_57977_58003 = state_57963__$1;
(statearr_57977_58003[(2)] = inst_57940);

(statearr_57977_58003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (10))){
var inst_57959 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
var statearr_57978_58004 = state_57963__$1;
(statearr_57978_58004[(2)] = inst_57959);

(statearr_57978_58004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (8))){
var inst_57940 = (state_57963[(7)]);
var inst_57950 = cljs.core.next.call(null,inst_57940);
var inst_57940__$1 = inst_57950;
var state_57963__$1 = (function (){var statearr_57979 = state_57963;
(statearr_57979[(7)] = inst_57940__$1);

return statearr_57979;
})();
var statearr_57980_58005 = state_57963__$1;
(statearr_57980_58005[(2)] = null);

(statearr_57980_58005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_57984 = [null,null,null,null,null,null,null,null];
(statearr_57984[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_57984[(1)] = (1));

return statearr_57984;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_57963){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_57963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e57985){if((e57985 instanceof Object)){
var ex__31353__auto__ = e57985;
var statearr_57986_58006 = state_57963;
(statearr_57986_58006[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58007 = state_57963;
state_57963 = G__58007;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_57963){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_57963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_57987 = f__31464__auto__.call(null);
(statearr_57987[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_57987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28353__auto__ = (((_ == null))?null:_);
var m__28354__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,_);
} else {
var m__28354__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28354__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,ch);
} else {
var m__28354__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m);
} else {
var m__28354__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async58233 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58233 = (function (ch,cs,meta58234){
this.ch = ch;
this.cs = cs;
this.meta58234 = meta58234;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_58235,meta58234__$1){
var self__ = this;
var _58235__$1 = this;
return (new cljs.core.async.t_cljs$core$async58233(self__.ch,self__.cs,meta58234__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_58235){
var self__ = this;
var _58235__$1 = this;
return self__.meta58234;
});})(cs))
;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async58233.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async58233.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta58234","meta58234",660680523,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async58233.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58233.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58233";

cljs.core.async.t_cljs$core$async58233.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async58233");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async58233 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async58233(ch__$1,cs__$1,meta58234){
return (new cljs.core.async.t_cljs$core$async58233(ch__$1,cs__$1,meta58234));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async58233(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31463__auto___58458 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___58458,cs,m,dchan,dctr,done){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___58458,cs,m,dchan,dctr,done){
return (function (state_58370){
var state_val_58371 = (state_58370[(1)]);
if((state_val_58371 === (7))){
var inst_58366 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58372_58459 = state_58370__$1;
(statearr_58372_58459[(2)] = inst_58366);

(statearr_58372_58459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (20))){
var inst_58269 = (state_58370[(7)]);
var inst_58281 = cljs.core.first.call(null,inst_58269);
var inst_58282 = cljs.core.nth.call(null,inst_58281,(0),null);
var inst_58283 = cljs.core.nth.call(null,inst_58281,(1),null);
var state_58370__$1 = (function (){var statearr_58373 = state_58370;
(statearr_58373[(8)] = inst_58282);

return statearr_58373;
})();
if(cljs.core.truth_(inst_58283)){
var statearr_58374_58460 = state_58370__$1;
(statearr_58374_58460[(1)] = (22));

} else {
var statearr_58375_58461 = state_58370__$1;
(statearr_58375_58461[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (27))){
var inst_58313 = (state_58370[(9)]);
var inst_58318 = (state_58370[(10)]);
var inst_58311 = (state_58370[(11)]);
var inst_58238 = (state_58370[(12)]);
var inst_58318__$1 = cljs.core._nth.call(null,inst_58311,inst_58313);
var inst_58319 = cljs.core.async.put_BANG_.call(null,inst_58318__$1,inst_58238,done);
var state_58370__$1 = (function (){var statearr_58376 = state_58370;
(statearr_58376[(10)] = inst_58318__$1);

return statearr_58376;
})();
if(cljs.core.truth_(inst_58319)){
var statearr_58377_58462 = state_58370__$1;
(statearr_58377_58462[(1)] = (30));

} else {
var statearr_58378_58463 = state_58370__$1;
(statearr_58378_58463[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (1))){
var state_58370__$1 = state_58370;
var statearr_58379_58464 = state_58370__$1;
(statearr_58379_58464[(2)] = null);

(statearr_58379_58464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (24))){
var inst_58269 = (state_58370[(7)]);
var inst_58288 = (state_58370[(2)]);
var inst_58289 = cljs.core.next.call(null,inst_58269);
var inst_58247 = inst_58289;
var inst_58248 = null;
var inst_58249 = (0);
var inst_58250 = (0);
var state_58370__$1 = (function (){var statearr_58380 = state_58370;
(statearr_58380[(13)] = inst_58247);

(statearr_58380[(14)] = inst_58248);

(statearr_58380[(15)] = inst_58288);

(statearr_58380[(16)] = inst_58250);

(statearr_58380[(17)] = inst_58249);

return statearr_58380;
})();
var statearr_58381_58465 = state_58370__$1;
(statearr_58381_58465[(2)] = null);

(statearr_58381_58465[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (39))){
var state_58370__$1 = state_58370;
var statearr_58385_58466 = state_58370__$1;
(statearr_58385_58466[(2)] = null);

(statearr_58385_58466[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (4))){
var inst_58238 = (state_58370[(12)]);
var inst_58238__$1 = (state_58370[(2)]);
var inst_58239 = (inst_58238__$1 == null);
var state_58370__$1 = (function (){var statearr_58386 = state_58370;
(statearr_58386[(12)] = inst_58238__$1);

return statearr_58386;
})();
if(cljs.core.truth_(inst_58239)){
var statearr_58387_58467 = state_58370__$1;
(statearr_58387_58467[(1)] = (5));

} else {
var statearr_58388_58468 = state_58370__$1;
(statearr_58388_58468[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (15))){
var inst_58247 = (state_58370[(13)]);
var inst_58248 = (state_58370[(14)]);
var inst_58250 = (state_58370[(16)]);
var inst_58249 = (state_58370[(17)]);
var inst_58265 = (state_58370[(2)]);
var inst_58266 = (inst_58250 + (1));
var tmp58382 = inst_58247;
var tmp58383 = inst_58248;
var tmp58384 = inst_58249;
var inst_58247__$1 = tmp58382;
var inst_58248__$1 = tmp58383;
var inst_58249__$1 = tmp58384;
var inst_58250__$1 = inst_58266;
var state_58370__$1 = (function (){var statearr_58389 = state_58370;
(statearr_58389[(13)] = inst_58247__$1);

(statearr_58389[(18)] = inst_58265);

(statearr_58389[(14)] = inst_58248__$1);

(statearr_58389[(16)] = inst_58250__$1);

(statearr_58389[(17)] = inst_58249__$1);

return statearr_58389;
})();
var statearr_58390_58469 = state_58370__$1;
(statearr_58390_58469[(2)] = null);

(statearr_58390_58469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (21))){
var inst_58292 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58394_58470 = state_58370__$1;
(statearr_58394_58470[(2)] = inst_58292);

(statearr_58394_58470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (31))){
var inst_58318 = (state_58370[(10)]);
var inst_58322 = done.call(null,null);
var inst_58323 = cljs.core.async.untap_STAR_.call(null,m,inst_58318);
var state_58370__$1 = (function (){var statearr_58395 = state_58370;
(statearr_58395[(19)] = inst_58322);

return statearr_58395;
})();
var statearr_58396_58471 = state_58370__$1;
(statearr_58396_58471[(2)] = inst_58323);

(statearr_58396_58471[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (32))){
var inst_58312 = (state_58370[(20)]);
var inst_58313 = (state_58370[(9)]);
var inst_58310 = (state_58370[(21)]);
var inst_58311 = (state_58370[(11)]);
var inst_58325 = (state_58370[(2)]);
var inst_58326 = (inst_58313 + (1));
var tmp58391 = inst_58312;
var tmp58392 = inst_58310;
var tmp58393 = inst_58311;
var inst_58310__$1 = tmp58392;
var inst_58311__$1 = tmp58393;
var inst_58312__$1 = tmp58391;
var inst_58313__$1 = inst_58326;
var state_58370__$1 = (function (){var statearr_58397 = state_58370;
(statearr_58397[(20)] = inst_58312__$1);

(statearr_58397[(9)] = inst_58313__$1);

(statearr_58397[(21)] = inst_58310__$1);

(statearr_58397[(11)] = inst_58311__$1);

(statearr_58397[(22)] = inst_58325);

return statearr_58397;
})();
var statearr_58398_58472 = state_58370__$1;
(statearr_58398_58472[(2)] = null);

(statearr_58398_58472[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (40))){
var inst_58338 = (state_58370[(23)]);
var inst_58342 = done.call(null,null);
var inst_58343 = cljs.core.async.untap_STAR_.call(null,m,inst_58338);
var state_58370__$1 = (function (){var statearr_58399 = state_58370;
(statearr_58399[(24)] = inst_58342);

return statearr_58399;
})();
var statearr_58400_58473 = state_58370__$1;
(statearr_58400_58473[(2)] = inst_58343);

(statearr_58400_58473[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (33))){
var inst_58329 = (state_58370[(25)]);
var inst_58331 = cljs.core.chunked_seq_QMARK_.call(null,inst_58329);
var state_58370__$1 = state_58370;
if(inst_58331){
var statearr_58401_58474 = state_58370__$1;
(statearr_58401_58474[(1)] = (36));

} else {
var statearr_58402_58475 = state_58370__$1;
(statearr_58402_58475[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (13))){
var inst_58259 = (state_58370[(26)]);
var inst_58262 = cljs.core.async.close_BANG_.call(null,inst_58259);
var state_58370__$1 = state_58370;
var statearr_58403_58476 = state_58370__$1;
(statearr_58403_58476[(2)] = inst_58262);

(statearr_58403_58476[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (22))){
var inst_58282 = (state_58370[(8)]);
var inst_58285 = cljs.core.async.close_BANG_.call(null,inst_58282);
var state_58370__$1 = state_58370;
var statearr_58404_58477 = state_58370__$1;
(statearr_58404_58477[(2)] = inst_58285);

(statearr_58404_58477[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (36))){
var inst_58329 = (state_58370[(25)]);
var inst_58333 = cljs.core.chunk_first.call(null,inst_58329);
var inst_58334 = cljs.core.chunk_rest.call(null,inst_58329);
var inst_58335 = cljs.core.count.call(null,inst_58333);
var inst_58310 = inst_58334;
var inst_58311 = inst_58333;
var inst_58312 = inst_58335;
var inst_58313 = (0);
var state_58370__$1 = (function (){var statearr_58405 = state_58370;
(statearr_58405[(20)] = inst_58312);

(statearr_58405[(9)] = inst_58313);

(statearr_58405[(21)] = inst_58310);

(statearr_58405[(11)] = inst_58311);

return statearr_58405;
})();
var statearr_58406_58478 = state_58370__$1;
(statearr_58406_58478[(2)] = null);

(statearr_58406_58478[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (41))){
var inst_58329 = (state_58370[(25)]);
var inst_58345 = (state_58370[(2)]);
var inst_58346 = cljs.core.next.call(null,inst_58329);
var inst_58310 = inst_58346;
var inst_58311 = null;
var inst_58312 = (0);
var inst_58313 = (0);
var state_58370__$1 = (function (){var statearr_58407 = state_58370;
(statearr_58407[(20)] = inst_58312);

(statearr_58407[(9)] = inst_58313);

(statearr_58407[(27)] = inst_58345);

(statearr_58407[(21)] = inst_58310);

(statearr_58407[(11)] = inst_58311);

return statearr_58407;
})();
var statearr_58408_58479 = state_58370__$1;
(statearr_58408_58479[(2)] = null);

(statearr_58408_58479[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (43))){
var state_58370__$1 = state_58370;
var statearr_58409_58480 = state_58370__$1;
(statearr_58409_58480[(2)] = null);

(statearr_58409_58480[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (29))){
var inst_58354 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58410_58481 = state_58370__$1;
(statearr_58410_58481[(2)] = inst_58354);

(statearr_58410_58481[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (44))){
var inst_58363 = (state_58370[(2)]);
var state_58370__$1 = (function (){var statearr_58411 = state_58370;
(statearr_58411[(28)] = inst_58363);

return statearr_58411;
})();
var statearr_58412_58482 = state_58370__$1;
(statearr_58412_58482[(2)] = null);

(statearr_58412_58482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (6))){
var inst_58302 = (state_58370[(29)]);
var inst_58301 = cljs.core.deref.call(null,cs);
var inst_58302__$1 = cljs.core.keys.call(null,inst_58301);
var inst_58303 = cljs.core.count.call(null,inst_58302__$1);
var inst_58304 = cljs.core.reset_BANG_.call(null,dctr,inst_58303);
var inst_58309 = cljs.core.seq.call(null,inst_58302__$1);
var inst_58310 = inst_58309;
var inst_58311 = null;
var inst_58312 = (0);
var inst_58313 = (0);
var state_58370__$1 = (function (){var statearr_58413 = state_58370;
(statearr_58413[(20)] = inst_58312);

(statearr_58413[(9)] = inst_58313);

(statearr_58413[(29)] = inst_58302__$1);

(statearr_58413[(21)] = inst_58310);

(statearr_58413[(11)] = inst_58311);

(statearr_58413[(30)] = inst_58304);

return statearr_58413;
})();
var statearr_58414_58483 = state_58370__$1;
(statearr_58414_58483[(2)] = null);

(statearr_58414_58483[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (28))){
var inst_58329 = (state_58370[(25)]);
var inst_58310 = (state_58370[(21)]);
var inst_58329__$1 = cljs.core.seq.call(null,inst_58310);
var state_58370__$1 = (function (){var statearr_58415 = state_58370;
(statearr_58415[(25)] = inst_58329__$1);

return statearr_58415;
})();
if(inst_58329__$1){
var statearr_58416_58484 = state_58370__$1;
(statearr_58416_58484[(1)] = (33));

} else {
var statearr_58417_58485 = state_58370__$1;
(statearr_58417_58485[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (25))){
var inst_58312 = (state_58370[(20)]);
var inst_58313 = (state_58370[(9)]);
var inst_58315 = (inst_58313 < inst_58312);
var inst_58316 = inst_58315;
var state_58370__$1 = state_58370;
if(cljs.core.truth_(inst_58316)){
var statearr_58418_58486 = state_58370__$1;
(statearr_58418_58486[(1)] = (27));

} else {
var statearr_58419_58487 = state_58370__$1;
(statearr_58419_58487[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (34))){
var state_58370__$1 = state_58370;
var statearr_58420_58488 = state_58370__$1;
(statearr_58420_58488[(2)] = null);

(statearr_58420_58488[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (17))){
var state_58370__$1 = state_58370;
var statearr_58421_58489 = state_58370__$1;
(statearr_58421_58489[(2)] = null);

(statearr_58421_58489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (3))){
var inst_58368 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58370__$1,inst_58368);
} else {
if((state_val_58371 === (12))){
var inst_58297 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58422_58490 = state_58370__$1;
(statearr_58422_58490[(2)] = inst_58297);

(statearr_58422_58490[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (2))){
var state_58370__$1 = state_58370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58370__$1,(4),ch);
} else {
if((state_val_58371 === (23))){
var state_58370__$1 = state_58370;
var statearr_58423_58491 = state_58370__$1;
(statearr_58423_58491[(2)] = null);

(statearr_58423_58491[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (35))){
var inst_58352 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58424_58492 = state_58370__$1;
(statearr_58424_58492[(2)] = inst_58352);

(statearr_58424_58492[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (19))){
var inst_58269 = (state_58370[(7)]);
var inst_58273 = cljs.core.chunk_first.call(null,inst_58269);
var inst_58274 = cljs.core.chunk_rest.call(null,inst_58269);
var inst_58275 = cljs.core.count.call(null,inst_58273);
var inst_58247 = inst_58274;
var inst_58248 = inst_58273;
var inst_58249 = inst_58275;
var inst_58250 = (0);
var state_58370__$1 = (function (){var statearr_58425 = state_58370;
(statearr_58425[(13)] = inst_58247);

(statearr_58425[(14)] = inst_58248);

(statearr_58425[(16)] = inst_58250);

(statearr_58425[(17)] = inst_58249);

return statearr_58425;
})();
var statearr_58426_58493 = state_58370__$1;
(statearr_58426_58493[(2)] = null);

(statearr_58426_58493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (11))){
var inst_58247 = (state_58370[(13)]);
var inst_58269 = (state_58370[(7)]);
var inst_58269__$1 = cljs.core.seq.call(null,inst_58247);
var state_58370__$1 = (function (){var statearr_58427 = state_58370;
(statearr_58427[(7)] = inst_58269__$1);

return statearr_58427;
})();
if(inst_58269__$1){
var statearr_58428_58494 = state_58370__$1;
(statearr_58428_58494[(1)] = (16));

} else {
var statearr_58429_58495 = state_58370__$1;
(statearr_58429_58495[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (9))){
var inst_58299 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58430_58496 = state_58370__$1;
(statearr_58430_58496[(2)] = inst_58299);

(statearr_58430_58496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (5))){
var inst_58245 = cljs.core.deref.call(null,cs);
var inst_58246 = cljs.core.seq.call(null,inst_58245);
var inst_58247 = inst_58246;
var inst_58248 = null;
var inst_58249 = (0);
var inst_58250 = (0);
var state_58370__$1 = (function (){var statearr_58431 = state_58370;
(statearr_58431[(13)] = inst_58247);

(statearr_58431[(14)] = inst_58248);

(statearr_58431[(16)] = inst_58250);

(statearr_58431[(17)] = inst_58249);

return statearr_58431;
})();
var statearr_58432_58497 = state_58370__$1;
(statearr_58432_58497[(2)] = null);

(statearr_58432_58497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (14))){
var state_58370__$1 = state_58370;
var statearr_58433_58498 = state_58370__$1;
(statearr_58433_58498[(2)] = null);

(statearr_58433_58498[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (45))){
var inst_58360 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58434_58499 = state_58370__$1;
(statearr_58434_58499[(2)] = inst_58360);

(statearr_58434_58499[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (26))){
var inst_58302 = (state_58370[(29)]);
var inst_58356 = (state_58370[(2)]);
var inst_58357 = cljs.core.seq.call(null,inst_58302);
var state_58370__$1 = (function (){var statearr_58435 = state_58370;
(statearr_58435[(31)] = inst_58356);

return statearr_58435;
})();
if(inst_58357){
var statearr_58436_58500 = state_58370__$1;
(statearr_58436_58500[(1)] = (42));

} else {
var statearr_58437_58501 = state_58370__$1;
(statearr_58437_58501[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (16))){
var inst_58269 = (state_58370[(7)]);
var inst_58271 = cljs.core.chunked_seq_QMARK_.call(null,inst_58269);
var state_58370__$1 = state_58370;
if(inst_58271){
var statearr_58438_58502 = state_58370__$1;
(statearr_58438_58502[(1)] = (19));

} else {
var statearr_58439_58503 = state_58370__$1;
(statearr_58439_58503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (38))){
var inst_58349 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58440_58504 = state_58370__$1;
(statearr_58440_58504[(2)] = inst_58349);

(statearr_58440_58504[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (30))){
var state_58370__$1 = state_58370;
var statearr_58441_58505 = state_58370__$1;
(statearr_58441_58505[(2)] = null);

(statearr_58441_58505[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (10))){
var inst_58248 = (state_58370[(14)]);
var inst_58250 = (state_58370[(16)]);
var inst_58258 = cljs.core._nth.call(null,inst_58248,inst_58250);
var inst_58259 = cljs.core.nth.call(null,inst_58258,(0),null);
var inst_58260 = cljs.core.nth.call(null,inst_58258,(1),null);
var state_58370__$1 = (function (){var statearr_58442 = state_58370;
(statearr_58442[(26)] = inst_58259);

return statearr_58442;
})();
if(cljs.core.truth_(inst_58260)){
var statearr_58443_58506 = state_58370__$1;
(statearr_58443_58506[(1)] = (13));

} else {
var statearr_58444_58507 = state_58370__$1;
(statearr_58444_58507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (18))){
var inst_58295 = (state_58370[(2)]);
var state_58370__$1 = state_58370;
var statearr_58445_58508 = state_58370__$1;
(statearr_58445_58508[(2)] = inst_58295);

(statearr_58445_58508[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (42))){
var state_58370__$1 = state_58370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58370__$1,(45),dchan);
} else {
if((state_val_58371 === (37))){
var inst_58338 = (state_58370[(23)]);
var inst_58329 = (state_58370[(25)]);
var inst_58238 = (state_58370[(12)]);
var inst_58338__$1 = cljs.core.first.call(null,inst_58329);
var inst_58339 = cljs.core.async.put_BANG_.call(null,inst_58338__$1,inst_58238,done);
var state_58370__$1 = (function (){var statearr_58446 = state_58370;
(statearr_58446[(23)] = inst_58338__$1);

return statearr_58446;
})();
if(cljs.core.truth_(inst_58339)){
var statearr_58447_58509 = state_58370__$1;
(statearr_58447_58509[(1)] = (39));

} else {
var statearr_58448_58510 = state_58370__$1;
(statearr_58448_58510[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58371 === (8))){
var inst_58250 = (state_58370[(16)]);
var inst_58249 = (state_58370[(17)]);
var inst_58252 = (inst_58250 < inst_58249);
var inst_58253 = inst_58252;
var state_58370__$1 = state_58370;
if(cljs.core.truth_(inst_58253)){
var statearr_58449_58511 = state_58370__$1;
(statearr_58449_58511[(1)] = (10));

} else {
var statearr_58450_58512 = state_58370__$1;
(statearr_58450_58512[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___58458,cs,m,dchan,dctr,done))
;
return ((function (switch__31349__auto__,c__31463__auto___58458,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31350__auto__ = null;
var cljs$core$async$mult_$_state_machine__31350__auto____0 = (function (){
var statearr_58454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58454[(0)] = cljs$core$async$mult_$_state_machine__31350__auto__);

(statearr_58454[(1)] = (1));

return statearr_58454;
});
var cljs$core$async$mult_$_state_machine__31350__auto____1 = (function (state_58370){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_58370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e58455){if((e58455 instanceof Object)){
var ex__31353__auto__ = e58455;
var statearr_58456_58513 = state_58370;
(statearr_58456_58513[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58455;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58514 = state_58370;
state_58370 = G__58514;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31350__auto__ = function(state_58370){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31350__auto____1.call(this,state_58370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31350__auto____0;
cljs$core$async$mult_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31350__auto____1;
return cljs$core$async$mult_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___58458,cs,m,dchan,dctr,done))
})();
var state__31465__auto__ = (function (){var statearr_58457 = f__31464__auto__.call(null);
(statearr_58457[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___58458);

return statearr_58457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___58458,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args58515 = [];
var len__28856__auto___58518 = arguments.length;
var i__28857__auto___58519 = (0);
while(true){
if((i__28857__auto___58519 < len__28856__auto___58518)){
args58515.push((arguments[i__28857__auto___58519]));

var G__58520 = (i__28857__auto___58519 + (1));
i__28857__auto___58519 = G__58520;
continue;
} else {
}
break;
}

var G__58517 = args58515.length;
switch (G__58517) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58515.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,ch);
} else {
var m__28354__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,ch);
} else {
var m__28354__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m);
} else {
var m__28354__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,state_map);
} else {
var m__28354__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28353__auto__ = (((m == null))?null:m);
var m__28354__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,m,mode);
} else {
var m__28354__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___58532 = arguments.length;
var i__28857__auto___58533 = (0);
while(true){
if((i__28857__auto___58533 < len__28856__auto___58532)){
args__28863__auto__.push((arguments[i__28857__auto___58533]));

var G__58534 = (i__28857__auto___58533 + (1));
i__28857__auto___58533 = G__58534;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((3) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28864__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__58526){
var map__58527 = p__58526;
var map__58527__$1 = ((((!((map__58527 == null)))?((((map__58527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58527.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58527):map__58527);
var opts = map__58527__$1;
var statearr_58529_58535 = state;
(statearr_58529_58535[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__58527,map__58527__$1,opts){
return (function (val){
var statearr_58530_58536 = state;
(statearr_58530_58536[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__58527,map__58527__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_58531_58537 = state;
(statearr_58531_58537[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq58522){
var G__58523 = cljs.core.first.call(null,seq58522);
var seq58522__$1 = cljs.core.next.call(null,seq58522);
var G__58524 = cljs.core.first.call(null,seq58522__$1);
var seq58522__$2 = cljs.core.next.call(null,seq58522__$1);
var G__58525 = cljs.core.first.call(null,seq58522__$2);
var seq58522__$3 = cljs.core.next.call(null,seq58522__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__58523,G__58524,G__58525,seq58522__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async58705 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58705 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta58706){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta58706 = meta58706;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_58707,meta58706__$1){
var self__ = this;
var _58707__$1 = this;
return (new cljs.core.async.t_cljs$core$async58705(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta58706__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_58707){
var self__ = this;
var _58707__$1 = this;
return self__.meta58706;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async58705.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58705.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta58706","meta58706",-1700241375,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58705.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58705.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58705";

cljs.core.async.t_cljs$core$async58705.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async58705");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async58705 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async58705(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta58706){
return (new cljs.core.async.t_cljs$core$async58705(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta58706));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async58705(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31463__auto___58872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_58809){
var state_val_58810 = (state_58809[(1)]);
if((state_val_58810 === (7))){
var inst_58724 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
var statearr_58811_58873 = state_58809__$1;
(statearr_58811_58873[(2)] = inst_58724);

(statearr_58811_58873[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (20))){
var inst_58736 = (state_58809[(7)]);
var state_58809__$1 = state_58809;
var statearr_58812_58874 = state_58809__$1;
(statearr_58812_58874[(2)] = inst_58736);

(statearr_58812_58874[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (27))){
var state_58809__$1 = state_58809;
var statearr_58813_58875 = state_58809__$1;
(statearr_58813_58875[(2)] = null);

(statearr_58813_58875[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (1))){
var inst_58711 = (state_58809[(8)]);
var inst_58711__$1 = calc_state.call(null);
var inst_58713 = (inst_58711__$1 == null);
var inst_58714 = cljs.core.not.call(null,inst_58713);
var state_58809__$1 = (function (){var statearr_58814 = state_58809;
(statearr_58814[(8)] = inst_58711__$1);

return statearr_58814;
})();
if(inst_58714){
var statearr_58815_58876 = state_58809__$1;
(statearr_58815_58876[(1)] = (2));

} else {
var statearr_58816_58877 = state_58809__$1;
(statearr_58816_58877[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (24))){
var inst_58760 = (state_58809[(9)]);
var inst_58783 = (state_58809[(10)]);
var inst_58769 = (state_58809[(11)]);
var inst_58783__$1 = inst_58760.call(null,inst_58769);
var state_58809__$1 = (function (){var statearr_58817 = state_58809;
(statearr_58817[(10)] = inst_58783__$1);

return statearr_58817;
})();
if(cljs.core.truth_(inst_58783__$1)){
var statearr_58818_58878 = state_58809__$1;
(statearr_58818_58878[(1)] = (29));

} else {
var statearr_58819_58879 = state_58809__$1;
(statearr_58819_58879[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (4))){
var inst_58727 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58727)){
var statearr_58820_58880 = state_58809__$1;
(statearr_58820_58880[(1)] = (8));

} else {
var statearr_58821_58881 = state_58809__$1;
(statearr_58821_58881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (15))){
var inst_58754 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58754)){
var statearr_58822_58882 = state_58809__$1;
(statearr_58822_58882[(1)] = (19));

} else {
var statearr_58823_58883 = state_58809__$1;
(statearr_58823_58883[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (21))){
var inst_58759 = (state_58809[(12)]);
var inst_58759__$1 = (state_58809[(2)]);
var inst_58760 = cljs.core.get.call(null,inst_58759__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_58761 = cljs.core.get.call(null,inst_58759__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_58762 = cljs.core.get.call(null,inst_58759__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_58809__$1 = (function (){var statearr_58824 = state_58809;
(statearr_58824[(13)] = inst_58761);

(statearr_58824[(9)] = inst_58760);

(statearr_58824[(12)] = inst_58759__$1);

return statearr_58824;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_58809__$1,(22),inst_58762);
} else {
if((state_val_58810 === (31))){
var inst_58791 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58791)){
var statearr_58825_58884 = state_58809__$1;
(statearr_58825_58884[(1)] = (32));

} else {
var statearr_58826_58885 = state_58809__$1;
(statearr_58826_58885[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (32))){
var inst_58768 = (state_58809[(14)]);
var state_58809__$1 = state_58809;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58809__$1,(35),out,inst_58768);
} else {
if((state_val_58810 === (33))){
var inst_58759 = (state_58809[(12)]);
var inst_58736 = inst_58759;
var state_58809__$1 = (function (){var statearr_58827 = state_58809;
(statearr_58827[(7)] = inst_58736);

return statearr_58827;
})();
var statearr_58828_58886 = state_58809__$1;
(statearr_58828_58886[(2)] = null);

(statearr_58828_58886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (13))){
var inst_58736 = (state_58809[(7)]);
var inst_58743 = inst_58736.cljs$lang$protocol_mask$partition0$;
var inst_58744 = (inst_58743 & (64));
var inst_58745 = inst_58736.cljs$core$ISeq$;
var inst_58746 = (cljs.core.PROTOCOL_SENTINEL === inst_58745);
var inst_58747 = (inst_58744) || (inst_58746);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58747)){
var statearr_58829_58887 = state_58809__$1;
(statearr_58829_58887[(1)] = (16));

} else {
var statearr_58830_58888 = state_58809__$1;
(statearr_58830_58888[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (22))){
var inst_58768 = (state_58809[(14)]);
var inst_58769 = (state_58809[(11)]);
var inst_58767 = (state_58809[(2)]);
var inst_58768__$1 = cljs.core.nth.call(null,inst_58767,(0),null);
var inst_58769__$1 = cljs.core.nth.call(null,inst_58767,(1),null);
var inst_58770 = (inst_58768__$1 == null);
var inst_58771 = cljs.core._EQ_.call(null,inst_58769__$1,change);
var inst_58772 = (inst_58770) || (inst_58771);
var state_58809__$1 = (function (){var statearr_58831 = state_58809;
(statearr_58831[(14)] = inst_58768__$1);

(statearr_58831[(11)] = inst_58769__$1);

return statearr_58831;
})();
if(cljs.core.truth_(inst_58772)){
var statearr_58832_58889 = state_58809__$1;
(statearr_58832_58889[(1)] = (23));

} else {
var statearr_58833_58890 = state_58809__$1;
(statearr_58833_58890[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (36))){
var inst_58759 = (state_58809[(12)]);
var inst_58736 = inst_58759;
var state_58809__$1 = (function (){var statearr_58834 = state_58809;
(statearr_58834[(7)] = inst_58736);

return statearr_58834;
})();
var statearr_58835_58891 = state_58809__$1;
(statearr_58835_58891[(2)] = null);

(statearr_58835_58891[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (29))){
var inst_58783 = (state_58809[(10)]);
var state_58809__$1 = state_58809;
var statearr_58836_58892 = state_58809__$1;
(statearr_58836_58892[(2)] = inst_58783);

(statearr_58836_58892[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (6))){
var state_58809__$1 = state_58809;
var statearr_58837_58893 = state_58809__$1;
(statearr_58837_58893[(2)] = false);

(statearr_58837_58893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (28))){
var inst_58779 = (state_58809[(2)]);
var inst_58780 = calc_state.call(null);
var inst_58736 = inst_58780;
var state_58809__$1 = (function (){var statearr_58838 = state_58809;
(statearr_58838[(7)] = inst_58736);

(statearr_58838[(15)] = inst_58779);

return statearr_58838;
})();
var statearr_58839_58894 = state_58809__$1;
(statearr_58839_58894[(2)] = null);

(statearr_58839_58894[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (25))){
var inst_58805 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
var statearr_58840_58895 = state_58809__$1;
(statearr_58840_58895[(2)] = inst_58805);

(statearr_58840_58895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (34))){
var inst_58803 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
var statearr_58841_58896 = state_58809__$1;
(statearr_58841_58896[(2)] = inst_58803);

(statearr_58841_58896[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (17))){
var state_58809__$1 = state_58809;
var statearr_58842_58897 = state_58809__$1;
(statearr_58842_58897[(2)] = false);

(statearr_58842_58897[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (3))){
var state_58809__$1 = state_58809;
var statearr_58843_58898 = state_58809__$1;
(statearr_58843_58898[(2)] = false);

(statearr_58843_58898[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (12))){
var inst_58807 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58809__$1,inst_58807);
} else {
if((state_val_58810 === (2))){
var inst_58711 = (state_58809[(8)]);
var inst_58716 = inst_58711.cljs$lang$protocol_mask$partition0$;
var inst_58717 = (inst_58716 & (64));
var inst_58718 = inst_58711.cljs$core$ISeq$;
var inst_58719 = (cljs.core.PROTOCOL_SENTINEL === inst_58718);
var inst_58720 = (inst_58717) || (inst_58719);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58720)){
var statearr_58844_58899 = state_58809__$1;
(statearr_58844_58899[(1)] = (5));

} else {
var statearr_58845_58900 = state_58809__$1;
(statearr_58845_58900[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (23))){
var inst_58768 = (state_58809[(14)]);
var inst_58774 = (inst_58768 == null);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58774)){
var statearr_58846_58901 = state_58809__$1;
(statearr_58846_58901[(1)] = (26));

} else {
var statearr_58847_58902 = state_58809__$1;
(statearr_58847_58902[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (35))){
var inst_58794 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
if(cljs.core.truth_(inst_58794)){
var statearr_58848_58903 = state_58809__$1;
(statearr_58848_58903[(1)] = (36));

} else {
var statearr_58849_58904 = state_58809__$1;
(statearr_58849_58904[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (19))){
var inst_58736 = (state_58809[(7)]);
var inst_58756 = cljs.core.apply.call(null,cljs.core.hash_map,inst_58736);
var state_58809__$1 = state_58809;
var statearr_58850_58905 = state_58809__$1;
(statearr_58850_58905[(2)] = inst_58756);

(statearr_58850_58905[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (11))){
var inst_58736 = (state_58809[(7)]);
var inst_58740 = (inst_58736 == null);
var inst_58741 = cljs.core.not.call(null,inst_58740);
var state_58809__$1 = state_58809;
if(inst_58741){
var statearr_58851_58906 = state_58809__$1;
(statearr_58851_58906[(1)] = (13));

} else {
var statearr_58852_58907 = state_58809__$1;
(statearr_58852_58907[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (9))){
var inst_58711 = (state_58809[(8)]);
var state_58809__$1 = state_58809;
var statearr_58853_58908 = state_58809__$1;
(statearr_58853_58908[(2)] = inst_58711);

(statearr_58853_58908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (5))){
var state_58809__$1 = state_58809;
var statearr_58854_58909 = state_58809__$1;
(statearr_58854_58909[(2)] = true);

(statearr_58854_58909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (14))){
var state_58809__$1 = state_58809;
var statearr_58855_58910 = state_58809__$1;
(statearr_58855_58910[(2)] = false);

(statearr_58855_58910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (26))){
var inst_58769 = (state_58809[(11)]);
var inst_58776 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_58769);
var state_58809__$1 = state_58809;
var statearr_58856_58911 = state_58809__$1;
(statearr_58856_58911[(2)] = inst_58776);

(statearr_58856_58911[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (16))){
var state_58809__$1 = state_58809;
var statearr_58857_58912 = state_58809__$1;
(statearr_58857_58912[(2)] = true);

(statearr_58857_58912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (38))){
var inst_58799 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
var statearr_58858_58913 = state_58809__$1;
(statearr_58858_58913[(2)] = inst_58799);

(statearr_58858_58913[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (30))){
var inst_58761 = (state_58809[(13)]);
var inst_58760 = (state_58809[(9)]);
var inst_58769 = (state_58809[(11)]);
var inst_58786 = cljs.core.empty_QMARK_.call(null,inst_58760);
var inst_58787 = inst_58761.call(null,inst_58769);
var inst_58788 = cljs.core.not.call(null,inst_58787);
var inst_58789 = (inst_58786) && (inst_58788);
var state_58809__$1 = state_58809;
var statearr_58859_58914 = state_58809__$1;
(statearr_58859_58914[(2)] = inst_58789);

(statearr_58859_58914[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (10))){
var inst_58711 = (state_58809[(8)]);
var inst_58732 = (state_58809[(2)]);
var inst_58733 = cljs.core.get.call(null,inst_58732,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_58734 = cljs.core.get.call(null,inst_58732,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_58735 = cljs.core.get.call(null,inst_58732,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_58736 = inst_58711;
var state_58809__$1 = (function (){var statearr_58860 = state_58809;
(statearr_58860[(16)] = inst_58734);

(statearr_58860[(7)] = inst_58736);

(statearr_58860[(17)] = inst_58733);

(statearr_58860[(18)] = inst_58735);

return statearr_58860;
})();
var statearr_58861_58915 = state_58809__$1;
(statearr_58861_58915[(2)] = null);

(statearr_58861_58915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (18))){
var inst_58751 = (state_58809[(2)]);
var state_58809__$1 = state_58809;
var statearr_58862_58916 = state_58809__$1;
(statearr_58862_58916[(2)] = inst_58751);

(statearr_58862_58916[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (37))){
var state_58809__$1 = state_58809;
var statearr_58863_58917 = state_58809__$1;
(statearr_58863_58917[(2)] = null);

(statearr_58863_58917[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58810 === (8))){
var inst_58711 = (state_58809[(8)]);
var inst_58729 = cljs.core.apply.call(null,cljs.core.hash_map,inst_58711);
var state_58809__$1 = state_58809;
var statearr_58864_58918 = state_58809__$1;
(statearr_58864_58918[(2)] = inst_58729);

(statearr_58864_58918[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31349__auto__,c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31350__auto__ = null;
var cljs$core$async$mix_$_state_machine__31350__auto____0 = (function (){
var statearr_58868 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58868[(0)] = cljs$core$async$mix_$_state_machine__31350__auto__);

(statearr_58868[(1)] = (1));

return statearr_58868;
});
var cljs$core$async$mix_$_state_machine__31350__auto____1 = (function (state_58809){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_58809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e58869){if((e58869 instanceof Object)){
var ex__31353__auto__ = e58869;
var statearr_58870_58919 = state_58809;
(statearr_58870_58919[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58809);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58920 = state_58809;
state_58809 = G__58920;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31350__auto__ = function(state_58809){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31350__auto____1.call(this,state_58809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31350__auto____0;
cljs$core$async$mix_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31350__auto____1;
return cljs$core$async$mix_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31465__auto__ = (function (){var statearr_58871 = f__31464__auto__.call(null);
(statearr_58871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___58872);

return statearr_58871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___58872,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28353__auto__ = (((p == null))?null:p);
var m__28354__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28354__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28353__auto__ = (((p == null))?null:p);
var m__28354__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,p,v,ch);
} else {
var m__28354__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args58921 = [];
var len__28856__auto___58924 = arguments.length;
var i__28857__auto___58925 = (0);
while(true){
if((i__28857__auto___58925 < len__28856__auto___58924)){
args58921.push((arguments[i__28857__auto___58925]));

var G__58926 = (i__28857__auto___58925 + (1));
i__28857__auto___58925 = G__58926;
continue;
} else {
}
break;
}

var G__58923 = args58921.length;
switch (G__58923) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58921.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28353__auto__ = (((p == null))?null:p);
var m__28354__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,p);
} else {
var m__28354__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28353__auto__ = (((p == null))?null:p);
var m__28354__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,p,v);
} else {
var m__28354__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args58929 = [];
var len__28856__auto___59054 = arguments.length;
var i__28857__auto___59055 = (0);
while(true){
if((i__28857__auto___59055 < len__28856__auto___59054)){
args58929.push((arguments[i__28857__auto___59055]));

var G__59056 = (i__28857__auto___59055 + (1));
i__28857__auto___59055 = G__59056;
continue;
} else {
}
break;
}

var G__58931 = args58929.length;
switch (G__58931) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58929.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27635__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27635__auto__,mults){
return (function (p1__58928_SHARP_){
if(cljs.core.truth_(p1__58928_SHARP_.call(null,topic))){
return p1__58928_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__58928_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27635__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async58932 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58932 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta58933){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta58933 = meta58933;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_58934,meta58933__$1){
var self__ = this;
var _58934__$1 = this;
return (new cljs.core.async.t_cljs$core$async58932(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta58933__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_58934){
var self__ = this;
var _58934__$1 = this;
return self__.meta58933;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async58932.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58932.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta58933","meta58933",-2007826005,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58932.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58932.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58932";

cljs.core.async.t_cljs$core$async58932.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async58932");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async58932 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async58932(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta58933){
return (new cljs.core.async.t_cljs$core$async58932(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta58933));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async58932(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31463__auto___59058 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59058,mults,ensure_mult,p){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59058,mults,ensure_mult,p){
return (function (state_59006){
var state_val_59007 = (state_59006[(1)]);
if((state_val_59007 === (7))){
var inst_59002 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59008_59059 = state_59006__$1;
(statearr_59008_59059[(2)] = inst_59002);

(statearr_59008_59059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (20))){
var state_59006__$1 = state_59006;
var statearr_59009_59060 = state_59006__$1;
(statearr_59009_59060[(2)] = null);

(statearr_59009_59060[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (1))){
var state_59006__$1 = state_59006;
var statearr_59010_59061 = state_59006__$1;
(statearr_59010_59061[(2)] = null);

(statearr_59010_59061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (24))){
var inst_58985 = (state_59006[(7)]);
var inst_58994 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_58985);
var state_59006__$1 = state_59006;
var statearr_59011_59062 = state_59006__$1;
(statearr_59011_59062[(2)] = inst_58994);

(statearr_59011_59062[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (4))){
var inst_58937 = (state_59006[(8)]);
var inst_58937__$1 = (state_59006[(2)]);
var inst_58938 = (inst_58937__$1 == null);
var state_59006__$1 = (function (){var statearr_59012 = state_59006;
(statearr_59012[(8)] = inst_58937__$1);

return statearr_59012;
})();
if(cljs.core.truth_(inst_58938)){
var statearr_59013_59063 = state_59006__$1;
(statearr_59013_59063[(1)] = (5));

} else {
var statearr_59014_59064 = state_59006__$1;
(statearr_59014_59064[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (15))){
var inst_58979 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59015_59065 = state_59006__$1;
(statearr_59015_59065[(2)] = inst_58979);

(statearr_59015_59065[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (21))){
var inst_58999 = (state_59006[(2)]);
var state_59006__$1 = (function (){var statearr_59016 = state_59006;
(statearr_59016[(9)] = inst_58999);

return statearr_59016;
})();
var statearr_59017_59066 = state_59006__$1;
(statearr_59017_59066[(2)] = null);

(statearr_59017_59066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (13))){
var inst_58961 = (state_59006[(10)]);
var inst_58963 = cljs.core.chunked_seq_QMARK_.call(null,inst_58961);
var state_59006__$1 = state_59006;
if(inst_58963){
var statearr_59018_59067 = state_59006__$1;
(statearr_59018_59067[(1)] = (16));

} else {
var statearr_59019_59068 = state_59006__$1;
(statearr_59019_59068[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (22))){
var inst_58991 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
if(cljs.core.truth_(inst_58991)){
var statearr_59020_59069 = state_59006__$1;
(statearr_59020_59069[(1)] = (23));

} else {
var statearr_59021_59070 = state_59006__$1;
(statearr_59021_59070[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (6))){
var inst_58985 = (state_59006[(7)]);
var inst_58937 = (state_59006[(8)]);
var inst_58987 = (state_59006[(11)]);
var inst_58985__$1 = topic_fn.call(null,inst_58937);
var inst_58986 = cljs.core.deref.call(null,mults);
var inst_58987__$1 = cljs.core.get.call(null,inst_58986,inst_58985__$1);
var state_59006__$1 = (function (){var statearr_59022 = state_59006;
(statearr_59022[(7)] = inst_58985__$1);

(statearr_59022[(11)] = inst_58987__$1);

return statearr_59022;
})();
if(cljs.core.truth_(inst_58987__$1)){
var statearr_59023_59071 = state_59006__$1;
(statearr_59023_59071[(1)] = (19));

} else {
var statearr_59024_59072 = state_59006__$1;
(statearr_59024_59072[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (25))){
var inst_58996 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59025_59073 = state_59006__$1;
(statearr_59025_59073[(2)] = inst_58996);

(statearr_59025_59073[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (17))){
var inst_58961 = (state_59006[(10)]);
var inst_58970 = cljs.core.first.call(null,inst_58961);
var inst_58971 = cljs.core.async.muxch_STAR_.call(null,inst_58970);
var inst_58972 = cljs.core.async.close_BANG_.call(null,inst_58971);
var inst_58973 = cljs.core.next.call(null,inst_58961);
var inst_58947 = inst_58973;
var inst_58948 = null;
var inst_58949 = (0);
var inst_58950 = (0);
var state_59006__$1 = (function (){var statearr_59026 = state_59006;
(statearr_59026[(12)] = inst_58950);

(statearr_59026[(13)] = inst_58948);

(statearr_59026[(14)] = inst_58949);

(statearr_59026[(15)] = inst_58947);

(statearr_59026[(16)] = inst_58972);

return statearr_59026;
})();
var statearr_59027_59074 = state_59006__$1;
(statearr_59027_59074[(2)] = null);

(statearr_59027_59074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (3))){
var inst_59004 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59006__$1,inst_59004);
} else {
if((state_val_59007 === (12))){
var inst_58981 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59028_59075 = state_59006__$1;
(statearr_59028_59075[(2)] = inst_58981);

(statearr_59028_59075[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (2))){
var state_59006__$1 = state_59006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59006__$1,(4),ch);
} else {
if((state_val_59007 === (23))){
var state_59006__$1 = state_59006;
var statearr_59029_59076 = state_59006__$1;
(statearr_59029_59076[(2)] = null);

(statearr_59029_59076[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (19))){
var inst_58937 = (state_59006[(8)]);
var inst_58987 = (state_59006[(11)]);
var inst_58989 = cljs.core.async.muxch_STAR_.call(null,inst_58987);
var state_59006__$1 = state_59006;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59006__$1,(22),inst_58989,inst_58937);
} else {
if((state_val_59007 === (11))){
var inst_58961 = (state_59006[(10)]);
var inst_58947 = (state_59006[(15)]);
var inst_58961__$1 = cljs.core.seq.call(null,inst_58947);
var state_59006__$1 = (function (){var statearr_59030 = state_59006;
(statearr_59030[(10)] = inst_58961__$1);

return statearr_59030;
})();
if(inst_58961__$1){
var statearr_59031_59077 = state_59006__$1;
(statearr_59031_59077[(1)] = (13));

} else {
var statearr_59032_59078 = state_59006__$1;
(statearr_59032_59078[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (9))){
var inst_58983 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59033_59079 = state_59006__$1;
(statearr_59033_59079[(2)] = inst_58983);

(statearr_59033_59079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (5))){
var inst_58944 = cljs.core.deref.call(null,mults);
var inst_58945 = cljs.core.vals.call(null,inst_58944);
var inst_58946 = cljs.core.seq.call(null,inst_58945);
var inst_58947 = inst_58946;
var inst_58948 = null;
var inst_58949 = (0);
var inst_58950 = (0);
var state_59006__$1 = (function (){var statearr_59034 = state_59006;
(statearr_59034[(12)] = inst_58950);

(statearr_59034[(13)] = inst_58948);

(statearr_59034[(14)] = inst_58949);

(statearr_59034[(15)] = inst_58947);

return statearr_59034;
})();
var statearr_59035_59080 = state_59006__$1;
(statearr_59035_59080[(2)] = null);

(statearr_59035_59080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (14))){
var state_59006__$1 = state_59006;
var statearr_59039_59081 = state_59006__$1;
(statearr_59039_59081[(2)] = null);

(statearr_59039_59081[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (16))){
var inst_58961 = (state_59006[(10)]);
var inst_58965 = cljs.core.chunk_first.call(null,inst_58961);
var inst_58966 = cljs.core.chunk_rest.call(null,inst_58961);
var inst_58967 = cljs.core.count.call(null,inst_58965);
var inst_58947 = inst_58966;
var inst_58948 = inst_58965;
var inst_58949 = inst_58967;
var inst_58950 = (0);
var state_59006__$1 = (function (){var statearr_59040 = state_59006;
(statearr_59040[(12)] = inst_58950);

(statearr_59040[(13)] = inst_58948);

(statearr_59040[(14)] = inst_58949);

(statearr_59040[(15)] = inst_58947);

return statearr_59040;
})();
var statearr_59041_59082 = state_59006__$1;
(statearr_59041_59082[(2)] = null);

(statearr_59041_59082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (10))){
var inst_58950 = (state_59006[(12)]);
var inst_58948 = (state_59006[(13)]);
var inst_58949 = (state_59006[(14)]);
var inst_58947 = (state_59006[(15)]);
var inst_58955 = cljs.core._nth.call(null,inst_58948,inst_58950);
var inst_58956 = cljs.core.async.muxch_STAR_.call(null,inst_58955);
var inst_58957 = cljs.core.async.close_BANG_.call(null,inst_58956);
var inst_58958 = (inst_58950 + (1));
var tmp59036 = inst_58948;
var tmp59037 = inst_58949;
var tmp59038 = inst_58947;
var inst_58947__$1 = tmp59038;
var inst_58948__$1 = tmp59036;
var inst_58949__$1 = tmp59037;
var inst_58950__$1 = inst_58958;
var state_59006__$1 = (function (){var statearr_59042 = state_59006;
(statearr_59042[(12)] = inst_58950__$1);

(statearr_59042[(13)] = inst_58948__$1);

(statearr_59042[(14)] = inst_58949__$1);

(statearr_59042[(15)] = inst_58947__$1);

(statearr_59042[(17)] = inst_58957);

return statearr_59042;
})();
var statearr_59043_59083 = state_59006__$1;
(statearr_59043_59083[(2)] = null);

(statearr_59043_59083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (18))){
var inst_58976 = (state_59006[(2)]);
var state_59006__$1 = state_59006;
var statearr_59044_59084 = state_59006__$1;
(statearr_59044_59084[(2)] = inst_58976);

(statearr_59044_59084[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59007 === (8))){
var inst_58950 = (state_59006[(12)]);
var inst_58949 = (state_59006[(14)]);
var inst_58952 = (inst_58950 < inst_58949);
var inst_58953 = inst_58952;
var state_59006__$1 = state_59006;
if(cljs.core.truth_(inst_58953)){
var statearr_59045_59085 = state_59006__$1;
(statearr_59045_59085[(1)] = (10));

} else {
var statearr_59046_59086 = state_59006__$1;
(statearr_59046_59086[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59058,mults,ensure_mult,p))
;
return ((function (switch__31349__auto__,c__31463__auto___59058,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59050[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59050[(1)] = (1));

return statearr_59050;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59006){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59051){if((e59051 instanceof Object)){
var ex__31353__auto__ = e59051;
var statearr_59052_59087 = state_59006;
(statearr_59052_59087[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59088 = state_59006;
state_59006 = G__59088;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59058,mults,ensure_mult,p))
})();
var state__31465__auto__ = (function (){var statearr_59053 = f__31464__auto__.call(null);
(statearr_59053[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59058);

return statearr_59053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59058,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args59089 = [];
var len__28856__auto___59092 = arguments.length;
var i__28857__auto___59093 = (0);
while(true){
if((i__28857__auto___59093 < len__28856__auto___59092)){
args59089.push((arguments[i__28857__auto___59093]));

var G__59094 = (i__28857__auto___59093 + (1));
i__28857__auto___59093 = G__59094;
continue;
} else {
}
break;
}

var G__59091 = args59089.length;
switch (G__59091) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59089.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args59096 = [];
var len__28856__auto___59099 = arguments.length;
var i__28857__auto___59100 = (0);
while(true){
if((i__28857__auto___59100 < len__28856__auto___59099)){
args59096.push((arguments[i__28857__auto___59100]));

var G__59101 = (i__28857__auto___59100 + (1));
i__28857__auto___59100 = G__59101;
continue;
} else {
}
break;
}

var G__59098 = args59096.length;
switch (G__59098) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59096.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args59103 = [];
var len__28856__auto___59174 = arguments.length;
var i__28857__auto___59175 = (0);
while(true){
if((i__28857__auto___59175 < len__28856__auto___59174)){
args59103.push((arguments[i__28857__auto___59175]));

var G__59176 = (i__28857__auto___59175 + (1));
i__28857__auto___59175 = G__59176;
continue;
} else {
}
break;
}

var G__59105 = args59103.length;
switch (G__59105) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59103.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__31463__auto___59178 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_59144){
var state_val_59145 = (state_59144[(1)]);
if((state_val_59145 === (7))){
var state_59144__$1 = state_59144;
var statearr_59146_59179 = state_59144__$1;
(statearr_59146_59179[(2)] = null);

(statearr_59146_59179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (1))){
var state_59144__$1 = state_59144;
var statearr_59147_59180 = state_59144__$1;
(statearr_59147_59180[(2)] = null);

(statearr_59147_59180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (4))){
var inst_59108 = (state_59144[(7)]);
var inst_59110 = (inst_59108 < cnt);
var state_59144__$1 = state_59144;
if(cljs.core.truth_(inst_59110)){
var statearr_59148_59181 = state_59144__$1;
(statearr_59148_59181[(1)] = (6));

} else {
var statearr_59149_59182 = state_59144__$1;
(statearr_59149_59182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (15))){
var inst_59140 = (state_59144[(2)]);
var state_59144__$1 = state_59144;
var statearr_59150_59183 = state_59144__$1;
(statearr_59150_59183[(2)] = inst_59140);

(statearr_59150_59183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (13))){
var inst_59133 = cljs.core.async.close_BANG_.call(null,out);
var state_59144__$1 = state_59144;
var statearr_59151_59184 = state_59144__$1;
(statearr_59151_59184[(2)] = inst_59133);

(statearr_59151_59184[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (6))){
var state_59144__$1 = state_59144;
var statearr_59152_59185 = state_59144__$1;
(statearr_59152_59185[(2)] = null);

(statearr_59152_59185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (3))){
var inst_59142 = (state_59144[(2)]);
var state_59144__$1 = state_59144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59144__$1,inst_59142);
} else {
if((state_val_59145 === (12))){
var inst_59130 = (state_59144[(8)]);
var inst_59130__$1 = (state_59144[(2)]);
var inst_59131 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_59130__$1);
var state_59144__$1 = (function (){var statearr_59153 = state_59144;
(statearr_59153[(8)] = inst_59130__$1);

return statearr_59153;
})();
if(cljs.core.truth_(inst_59131)){
var statearr_59154_59186 = state_59144__$1;
(statearr_59154_59186[(1)] = (13));

} else {
var statearr_59155_59187 = state_59144__$1;
(statearr_59155_59187[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (2))){
var inst_59107 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_59108 = (0);
var state_59144__$1 = (function (){var statearr_59156 = state_59144;
(statearr_59156[(9)] = inst_59107);

(statearr_59156[(7)] = inst_59108);

return statearr_59156;
})();
var statearr_59157_59188 = state_59144__$1;
(statearr_59157_59188[(2)] = null);

(statearr_59157_59188[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (11))){
var inst_59108 = (state_59144[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_59144,(10),Object,null,(9));
var inst_59117 = chs__$1.call(null,inst_59108);
var inst_59118 = done.call(null,inst_59108);
var inst_59119 = cljs.core.async.take_BANG_.call(null,inst_59117,inst_59118);
var state_59144__$1 = state_59144;
var statearr_59158_59189 = state_59144__$1;
(statearr_59158_59189[(2)] = inst_59119);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59144__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (9))){
var inst_59108 = (state_59144[(7)]);
var inst_59121 = (state_59144[(2)]);
var inst_59122 = (inst_59108 + (1));
var inst_59108__$1 = inst_59122;
var state_59144__$1 = (function (){var statearr_59159 = state_59144;
(statearr_59159[(7)] = inst_59108__$1);

(statearr_59159[(10)] = inst_59121);

return statearr_59159;
})();
var statearr_59160_59190 = state_59144__$1;
(statearr_59160_59190[(2)] = null);

(statearr_59160_59190[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (5))){
var inst_59128 = (state_59144[(2)]);
var state_59144__$1 = (function (){var statearr_59161 = state_59144;
(statearr_59161[(11)] = inst_59128);

return statearr_59161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59144__$1,(12),dchan);
} else {
if((state_val_59145 === (14))){
var inst_59130 = (state_59144[(8)]);
var inst_59135 = cljs.core.apply.call(null,f,inst_59130);
var state_59144__$1 = state_59144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59144__$1,(16),out,inst_59135);
} else {
if((state_val_59145 === (16))){
var inst_59137 = (state_59144[(2)]);
var state_59144__$1 = (function (){var statearr_59162 = state_59144;
(statearr_59162[(12)] = inst_59137);

return statearr_59162;
})();
var statearr_59163_59191 = state_59144__$1;
(statearr_59163_59191[(2)] = null);

(statearr_59163_59191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (10))){
var inst_59112 = (state_59144[(2)]);
var inst_59113 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_59144__$1 = (function (){var statearr_59164 = state_59144;
(statearr_59164[(13)] = inst_59112);

return statearr_59164;
})();
var statearr_59165_59192 = state_59144__$1;
(statearr_59165_59192[(2)] = inst_59113);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59144__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59145 === (8))){
var inst_59126 = (state_59144[(2)]);
var state_59144__$1 = state_59144;
var statearr_59166_59193 = state_59144__$1;
(statearr_59166_59193[(2)] = inst_59126);

(statearr_59166_59193[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31349__auto__,c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59170[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59170[(1)] = (1));

return statearr_59170;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59144){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59171){if((e59171 instanceof Object)){
var ex__31353__auto__ = e59171;
var statearr_59172_59194 = state_59144;
(statearr_59172_59194[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59144);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59195 = state_59144;
state_59144 = G__59195;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59144){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31465__auto__ = (function (){var statearr_59173 = f__31464__auto__.call(null);
(statearr_59173[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59178);

return statearr_59173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59178,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args59197 = [];
var len__28856__auto___59255 = arguments.length;
var i__28857__auto___59256 = (0);
while(true){
if((i__28857__auto___59256 < len__28856__auto___59255)){
args59197.push((arguments[i__28857__auto___59256]));

var G__59257 = (i__28857__auto___59256 + (1));
i__28857__auto___59256 = G__59257;
continue;
} else {
}
break;
}

var G__59199 = args59197.length;
switch (G__59199) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59197.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59259 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59259,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59259,out){
return (function (state_59231){
var state_val_59232 = (state_59231[(1)]);
if((state_val_59232 === (7))){
var inst_59211 = (state_59231[(7)]);
var inst_59210 = (state_59231[(8)]);
var inst_59210__$1 = (state_59231[(2)]);
var inst_59211__$1 = cljs.core.nth.call(null,inst_59210__$1,(0),null);
var inst_59212 = cljs.core.nth.call(null,inst_59210__$1,(1),null);
var inst_59213 = (inst_59211__$1 == null);
var state_59231__$1 = (function (){var statearr_59233 = state_59231;
(statearr_59233[(7)] = inst_59211__$1);

(statearr_59233[(9)] = inst_59212);

(statearr_59233[(8)] = inst_59210__$1);

return statearr_59233;
})();
if(cljs.core.truth_(inst_59213)){
var statearr_59234_59260 = state_59231__$1;
(statearr_59234_59260[(1)] = (8));

} else {
var statearr_59235_59261 = state_59231__$1;
(statearr_59235_59261[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (1))){
var inst_59200 = cljs.core.vec.call(null,chs);
var inst_59201 = inst_59200;
var state_59231__$1 = (function (){var statearr_59236 = state_59231;
(statearr_59236[(10)] = inst_59201);

return statearr_59236;
})();
var statearr_59237_59262 = state_59231__$1;
(statearr_59237_59262[(2)] = null);

(statearr_59237_59262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (4))){
var inst_59201 = (state_59231[(10)]);
var state_59231__$1 = state_59231;
return cljs.core.async.ioc_alts_BANG_.call(null,state_59231__$1,(7),inst_59201);
} else {
if((state_val_59232 === (6))){
var inst_59227 = (state_59231[(2)]);
var state_59231__$1 = state_59231;
var statearr_59238_59263 = state_59231__$1;
(statearr_59238_59263[(2)] = inst_59227);

(statearr_59238_59263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (3))){
var inst_59229 = (state_59231[(2)]);
var state_59231__$1 = state_59231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59231__$1,inst_59229);
} else {
if((state_val_59232 === (2))){
var inst_59201 = (state_59231[(10)]);
var inst_59203 = cljs.core.count.call(null,inst_59201);
var inst_59204 = (inst_59203 > (0));
var state_59231__$1 = state_59231;
if(cljs.core.truth_(inst_59204)){
var statearr_59240_59264 = state_59231__$1;
(statearr_59240_59264[(1)] = (4));

} else {
var statearr_59241_59265 = state_59231__$1;
(statearr_59241_59265[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (11))){
var inst_59201 = (state_59231[(10)]);
var inst_59220 = (state_59231[(2)]);
var tmp59239 = inst_59201;
var inst_59201__$1 = tmp59239;
var state_59231__$1 = (function (){var statearr_59242 = state_59231;
(statearr_59242[(10)] = inst_59201__$1);

(statearr_59242[(11)] = inst_59220);

return statearr_59242;
})();
var statearr_59243_59266 = state_59231__$1;
(statearr_59243_59266[(2)] = null);

(statearr_59243_59266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (9))){
var inst_59211 = (state_59231[(7)]);
var state_59231__$1 = state_59231;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59231__$1,(11),out,inst_59211);
} else {
if((state_val_59232 === (5))){
var inst_59225 = cljs.core.async.close_BANG_.call(null,out);
var state_59231__$1 = state_59231;
var statearr_59244_59267 = state_59231__$1;
(statearr_59244_59267[(2)] = inst_59225);

(statearr_59244_59267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (10))){
var inst_59223 = (state_59231[(2)]);
var state_59231__$1 = state_59231;
var statearr_59245_59268 = state_59231__$1;
(statearr_59245_59268[(2)] = inst_59223);

(statearr_59245_59268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59232 === (8))){
var inst_59211 = (state_59231[(7)]);
var inst_59212 = (state_59231[(9)]);
var inst_59210 = (state_59231[(8)]);
var inst_59201 = (state_59231[(10)]);
var inst_59215 = (function (){var cs = inst_59201;
var vec__59206 = inst_59210;
var v = inst_59211;
var c = inst_59212;
return ((function (cs,vec__59206,v,c,inst_59211,inst_59212,inst_59210,inst_59201,state_val_59232,c__31463__auto___59259,out){
return (function (p1__59196_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__59196_SHARP_);
});
;})(cs,vec__59206,v,c,inst_59211,inst_59212,inst_59210,inst_59201,state_val_59232,c__31463__auto___59259,out))
})();
var inst_59216 = cljs.core.filterv.call(null,inst_59215,inst_59201);
var inst_59201__$1 = inst_59216;
var state_59231__$1 = (function (){var statearr_59246 = state_59231;
(statearr_59246[(10)] = inst_59201__$1);

return statearr_59246;
})();
var statearr_59247_59269 = state_59231__$1;
(statearr_59247_59269[(2)] = null);

(statearr_59247_59269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59259,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59259,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59251 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59251[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59251[(1)] = (1));

return statearr_59251;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59231){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59252){if((e59252 instanceof Object)){
var ex__31353__auto__ = e59252;
var statearr_59253_59270 = state_59231;
(statearr_59253_59270[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59231);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59252;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59271 = state_59231;
state_59231 = G__59271;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59231){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59259,out))
})();
var state__31465__auto__ = (function (){var statearr_59254 = f__31464__auto__.call(null);
(statearr_59254[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59259);

return statearr_59254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59259,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args59272 = [];
var len__28856__auto___59321 = arguments.length;
var i__28857__auto___59322 = (0);
while(true){
if((i__28857__auto___59322 < len__28856__auto___59321)){
args59272.push((arguments[i__28857__auto___59322]));

var G__59323 = (i__28857__auto___59322 + (1));
i__28857__auto___59322 = G__59323;
continue;
} else {
}
break;
}

var G__59274 = args59272.length;
switch (G__59274) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59272.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59325 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59325,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59325,out){
return (function (state_59298){
var state_val_59299 = (state_59298[(1)]);
if((state_val_59299 === (7))){
var inst_59280 = (state_59298[(7)]);
var inst_59280__$1 = (state_59298[(2)]);
var inst_59281 = (inst_59280__$1 == null);
var inst_59282 = cljs.core.not.call(null,inst_59281);
var state_59298__$1 = (function (){var statearr_59300 = state_59298;
(statearr_59300[(7)] = inst_59280__$1);

return statearr_59300;
})();
if(inst_59282){
var statearr_59301_59326 = state_59298__$1;
(statearr_59301_59326[(1)] = (8));

} else {
var statearr_59302_59327 = state_59298__$1;
(statearr_59302_59327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (1))){
var inst_59275 = (0);
var state_59298__$1 = (function (){var statearr_59303 = state_59298;
(statearr_59303[(8)] = inst_59275);

return statearr_59303;
})();
var statearr_59304_59328 = state_59298__$1;
(statearr_59304_59328[(2)] = null);

(statearr_59304_59328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (4))){
var state_59298__$1 = state_59298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59298__$1,(7),ch);
} else {
if((state_val_59299 === (6))){
var inst_59293 = (state_59298[(2)]);
var state_59298__$1 = state_59298;
var statearr_59305_59329 = state_59298__$1;
(statearr_59305_59329[(2)] = inst_59293);

(statearr_59305_59329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (3))){
var inst_59295 = (state_59298[(2)]);
var inst_59296 = cljs.core.async.close_BANG_.call(null,out);
var state_59298__$1 = (function (){var statearr_59306 = state_59298;
(statearr_59306[(9)] = inst_59295);

return statearr_59306;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59298__$1,inst_59296);
} else {
if((state_val_59299 === (2))){
var inst_59275 = (state_59298[(8)]);
var inst_59277 = (inst_59275 < n);
var state_59298__$1 = state_59298;
if(cljs.core.truth_(inst_59277)){
var statearr_59307_59330 = state_59298__$1;
(statearr_59307_59330[(1)] = (4));

} else {
var statearr_59308_59331 = state_59298__$1;
(statearr_59308_59331[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (11))){
var inst_59275 = (state_59298[(8)]);
var inst_59285 = (state_59298[(2)]);
var inst_59286 = (inst_59275 + (1));
var inst_59275__$1 = inst_59286;
var state_59298__$1 = (function (){var statearr_59309 = state_59298;
(statearr_59309[(10)] = inst_59285);

(statearr_59309[(8)] = inst_59275__$1);

return statearr_59309;
})();
var statearr_59310_59332 = state_59298__$1;
(statearr_59310_59332[(2)] = null);

(statearr_59310_59332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (9))){
var state_59298__$1 = state_59298;
var statearr_59311_59333 = state_59298__$1;
(statearr_59311_59333[(2)] = null);

(statearr_59311_59333[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (5))){
var state_59298__$1 = state_59298;
var statearr_59312_59334 = state_59298__$1;
(statearr_59312_59334[(2)] = null);

(statearr_59312_59334[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (10))){
var inst_59290 = (state_59298[(2)]);
var state_59298__$1 = state_59298;
var statearr_59313_59335 = state_59298__$1;
(statearr_59313_59335[(2)] = inst_59290);

(statearr_59313_59335[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59299 === (8))){
var inst_59280 = (state_59298[(7)]);
var state_59298__$1 = state_59298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59298__$1,(11),out,inst_59280);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59325,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59325,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59317 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_59317[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59317[(1)] = (1));

return statearr_59317;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59298){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59318){if((e59318 instanceof Object)){
var ex__31353__auto__ = e59318;
var statearr_59319_59336 = state_59298;
(statearr_59319_59336[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59318;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59337 = state_59298;
state_59298 = G__59337;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59325,out))
})();
var state__31465__auto__ = (function (){var statearr_59320 = f__31464__auto__.call(null);
(statearr_59320[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59325);

return statearr_59320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59325,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async59345 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59345 = (function (f,ch,meta59346){
this.f = f;
this.ch = ch;
this.meta59346 = meta59346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59347,meta59346__$1){
var self__ = this;
var _59347__$1 = this;
return (new cljs.core.async.t_cljs$core$async59345(self__.f,self__.ch,meta59346__$1));
});


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59347){
var self__ = this;
var _59347__$1 = this;
return self__.meta59346;
});


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async59348 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59348 = (function (f,ch,meta59346,_,fn1,meta59349){
this.f = f;
this.ch = ch;
this.meta59346 = meta59346;
this._ = _;
this.fn1 = fn1;
this.meta59349 = meta59349;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_59350,meta59349__$1){
var self__ = this;
var _59350__$1 = this;
return (new cljs.core.async.t_cljs$core$async59348(self__.f,self__.ch,self__.meta59346,self__._,self__.fn1,meta59349__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_59350){
var self__ = this;
var _59350__$1 = this;
return self__.meta59349;
});})(___$1))
;


cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async59348.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__59338_SHARP_){
return f1.call(null,(((p1__59338_SHARP_ == null))?null:self__.f.call(null,p1__59338_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async59348.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59346","meta59346",322718280,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async59345","cljs.core.async/t_cljs$core$async59345",717248791,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta59349","meta59349",1168940548,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async59348.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59348.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59348";

cljs.core.async.t_cljs$core$async59348.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async59348");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async59348 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async59348(f__$1,ch__$1,meta59346__$1,___$2,fn1__$1,meta59349){
return (new cljs.core.async.t_cljs$core$async59348(f__$1,ch__$1,meta59346__$1,___$2,fn1__$1,meta59349));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async59348(self__.f,self__.ch,self__.meta59346,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27623__auto__ = ret;
if(cljs.core.truth_(and__27623__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27623__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59345.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async59345.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59346","meta59346",322718280,null)], null);
});

cljs.core.async.t_cljs$core$async59345.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59345";

cljs.core.async.t_cljs$core$async59345.cljs$lang$ctorPrWriter = (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async59345");
});

cljs.core.async.__GT_t_cljs$core$async59345 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async59345(f__$1,ch__$1,meta59346){
return (new cljs.core.async.t_cljs$core$async59345(f__$1,ch__$1,meta59346));
});

}

return (new cljs.core.async.t_cljs$core$async59345(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async59354 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59354 = (function (f,ch,meta59355){
this.f = f;
this.ch = ch;
this.meta59355 = meta59355;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59356,meta59355__$1){
var self__ = this;
var _59356__$1 = this;
return (new cljs.core.async.t_cljs$core$async59354(self__.f,self__.ch,meta59355__$1));
});


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59356){
var self__ = this;
var _59356__$1 = this;
return self__.meta59355;
});


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59354.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async59354.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59355","meta59355",547720150,null)], null);
});

cljs.core.async.t_cljs$core$async59354.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59354.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59354";

cljs.core.async.t_cljs$core$async59354.cljs$lang$ctorPrWriter = (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async59354");
});

cljs.core.async.__GT_t_cljs$core$async59354 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async59354(f__$1,ch__$1,meta59355){
return (new cljs.core.async.t_cljs$core$async59354(f__$1,ch__$1,meta59355));
});

}

return (new cljs.core.async.t_cljs$core$async59354(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async59360 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59360 = (function (p,ch,meta59361){
this.p = p;
this.ch = ch;
this.meta59361 = meta59361;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59362,meta59361__$1){
var self__ = this;
var _59362__$1 = this;
return (new cljs.core.async.t_cljs$core$async59360(self__.p,self__.ch,meta59361__$1));
});


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59362){
var self__ = this;
var _59362__$1 = this;
return self__.meta59361;
});


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async59360.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async59360.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59361","meta59361",-1949556487,null)], null);
});

cljs.core.async.t_cljs$core$async59360.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59360.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59360";

cljs.core.async.t_cljs$core$async59360.cljs$lang$ctorPrWriter = (function (this__28292__auto__,writer__28293__auto__,opt__28294__auto__){
return cljs.core._write.call(null,writer__28293__auto__,"cljs.core.async/t_cljs$core$async59360");
});

cljs.core.async.__GT_t_cljs$core$async59360 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async59360(p__$1,ch__$1,meta59361){
return (new cljs.core.async.t_cljs$core$async59360(p__$1,ch__$1,meta59361));
});

}

return (new cljs.core.async.t_cljs$core$async59360(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args59363 = [];
var len__28856__auto___59407 = arguments.length;
var i__28857__auto___59408 = (0);
while(true){
if((i__28857__auto___59408 < len__28856__auto___59407)){
args59363.push((arguments[i__28857__auto___59408]));

var G__59409 = (i__28857__auto___59408 + (1));
i__28857__auto___59408 = G__59409;
continue;
} else {
}
break;
}

var G__59365 = args59363.length;
switch (G__59365) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59363.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59411 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59411,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59411,out){
return (function (state_59386){
var state_val_59387 = (state_59386[(1)]);
if((state_val_59387 === (7))){
var inst_59382 = (state_59386[(2)]);
var state_59386__$1 = state_59386;
var statearr_59388_59412 = state_59386__$1;
(statearr_59388_59412[(2)] = inst_59382);

(statearr_59388_59412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (1))){
var state_59386__$1 = state_59386;
var statearr_59389_59413 = state_59386__$1;
(statearr_59389_59413[(2)] = null);

(statearr_59389_59413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (4))){
var inst_59368 = (state_59386[(7)]);
var inst_59368__$1 = (state_59386[(2)]);
var inst_59369 = (inst_59368__$1 == null);
var state_59386__$1 = (function (){var statearr_59390 = state_59386;
(statearr_59390[(7)] = inst_59368__$1);

return statearr_59390;
})();
if(cljs.core.truth_(inst_59369)){
var statearr_59391_59414 = state_59386__$1;
(statearr_59391_59414[(1)] = (5));

} else {
var statearr_59392_59415 = state_59386__$1;
(statearr_59392_59415[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (6))){
var inst_59368 = (state_59386[(7)]);
var inst_59373 = p.call(null,inst_59368);
var state_59386__$1 = state_59386;
if(cljs.core.truth_(inst_59373)){
var statearr_59393_59416 = state_59386__$1;
(statearr_59393_59416[(1)] = (8));

} else {
var statearr_59394_59417 = state_59386__$1;
(statearr_59394_59417[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (3))){
var inst_59384 = (state_59386[(2)]);
var state_59386__$1 = state_59386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59386__$1,inst_59384);
} else {
if((state_val_59387 === (2))){
var state_59386__$1 = state_59386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59386__$1,(4),ch);
} else {
if((state_val_59387 === (11))){
var inst_59376 = (state_59386[(2)]);
var state_59386__$1 = state_59386;
var statearr_59395_59418 = state_59386__$1;
(statearr_59395_59418[(2)] = inst_59376);

(statearr_59395_59418[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (9))){
var state_59386__$1 = state_59386;
var statearr_59396_59419 = state_59386__$1;
(statearr_59396_59419[(2)] = null);

(statearr_59396_59419[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (5))){
var inst_59371 = cljs.core.async.close_BANG_.call(null,out);
var state_59386__$1 = state_59386;
var statearr_59397_59420 = state_59386__$1;
(statearr_59397_59420[(2)] = inst_59371);

(statearr_59397_59420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (10))){
var inst_59379 = (state_59386[(2)]);
var state_59386__$1 = (function (){var statearr_59398 = state_59386;
(statearr_59398[(8)] = inst_59379);

return statearr_59398;
})();
var statearr_59399_59421 = state_59386__$1;
(statearr_59399_59421[(2)] = null);

(statearr_59399_59421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59387 === (8))){
var inst_59368 = (state_59386[(7)]);
var state_59386__$1 = state_59386;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59386__$1,(11),out,inst_59368);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59411,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59411,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59403 = [null,null,null,null,null,null,null,null,null];
(statearr_59403[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59403[(1)] = (1));

return statearr_59403;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59386){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59404){if((e59404 instanceof Object)){
var ex__31353__auto__ = e59404;
var statearr_59405_59422 = state_59386;
(statearr_59405_59422[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59423 = state_59386;
state_59386 = G__59423;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59411,out))
})();
var state__31465__auto__ = (function (){var statearr_59406 = f__31464__auto__.call(null);
(statearr_59406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59411);

return statearr_59406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59411,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args59424 = [];
var len__28856__auto___59427 = arguments.length;
var i__28857__auto___59428 = (0);
while(true){
if((i__28857__auto___59428 < len__28856__auto___59427)){
args59424.push((arguments[i__28857__auto___59428]));

var G__59429 = (i__28857__auto___59428 + (1));
i__28857__auto___59428 = G__59429;
continue;
} else {
}
break;
}

var G__59426 = args59424.length;
switch (G__59426) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59424.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_59596){
var state_val_59597 = (state_59596[(1)]);
if((state_val_59597 === (7))){
var inst_59592 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59598_59639 = state_59596__$1;
(statearr_59598_59639[(2)] = inst_59592);

(statearr_59598_59639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (20))){
var inst_59562 = (state_59596[(7)]);
var inst_59573 = (state_59596[(2)]);
var inst_59574 = cljs.core.next.call(null,inst_59562);
var inst_59548 = inst_59574;
var inst_59549 = null;
var inst_59550 = (0);
var inst_59551 = (0);
var state_59596__$1 = (function (){var statearr_59599 = state_59596;
(statearr_59599[(8)] = inst_59548);

(statearr_59599[(9)] = inst_59573);

(statearr_59599[(10)] = inst_59551);

(statearr_59599[(11)] = inst_59550);

(statearr_59599[(12)] = inst_59549);

return statearr_59599;
})();
var statearr_59600_59640 = state_59596__$1;
(statearr_59600_59640[(2)] = null);

(statearr_59600_59640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (1))){
var state_59596__$1 = state_59596;
var statearr_59601_59641 = state_59596__$1;
(statearr_59601_59641[(2)] = null);

(statearr_59601_59641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (4))){
var inst_59537 = (state_59596[(13)]);
var inst_59537__$1 = (state_59596[(2)]);
var inst_59538 = (inst_59537__$1 == null);
var state_59596__$1 = (function (){var statearr_59602 = state_59596;
(statearr_59602[(13)] = inst_59537__$1);

return statearr_59602;
})();
if(cljs.core.truth_(inst_59538)){
var statearr_59603_59642 = state_59596__$1;
(statearr_59603_59642[(1)] = (5));

} else {
var statearr_59604_59643 = state_59596__$1;
(statearr_59604_59643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (15))){
var state_59596__$1 = state_59596;
var statearr_59608_59644 = state_59596__$1;
(statearr_59608_59644[(2)] = null);

(statearr_59608_59644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (21))){
var state_59596__$1 = state_59596;
var statearr_59609_59645 = state_59596__$1;
(statearr_59609_59645[(2)] = null);

(statearr_59609_59645[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (13))){
var inst_59548 = (state_59596[(8)]);
var inst_59551 = (state_59596[(10)]);
var inst_59550 = (state_59596[(11)]);
var inst_59549 = (state_59596[(12)]);
var inst_59558 = (state_59596[(2)]);
var inst_59559 = (inst_59551 + (1));
var tmp59605 = inst_59548;
var tmp59606 = inst_59550;
var tmp59607 = inst_59549;
var inst_59548__$1 = tmp59605;
var inst_59549__$1 = tmp59607;
var inst_59550__$1 = tmp59606;
var inst_59551__$1 = inst_59559;
var state_59596__$1 = (function (){var statearr_59610 = state_59596;
(statearr_59610[(8)] = inst_59548__$1);

(statearr_59610[(10)] = inst_59551__$1);

(statearr_59610[(11)] = inst_59550__$1);

(statearr_59610[(12)] = inst_59549__$1);

(statearr_59610[(14)] = inst_59558);

return statearr_59610;
})();
var statearr_59611_59646 = state_59596__$1;
(statearr_59611_59646[(2)] = null);

(statearr_59611_59646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (22))){
var state_59596__$1 = state_59596;
var statearr_59612_59647 = state_59596__$1;
(statearr_59612_59647[(2)] = null);

(statearr_59612_59647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (6))){
var inst_59537 = (state_59596[(13)]);
var inst_59546 = f.call(null,inst_59537);
var inst_59547 = cljs.core.seq.call(null,inst_59546);
var inst_59548 = inst_59547;
var inst_59549 = null;
var inst_59550 = (0);
var inst_59551 = (0);
var state_59596__$1 = (function (){var statearr_59613 = state_59596;
(statearr_59613[(8)] = inst_59548);

(statearr_59613[(10)] = inst_59551);

(statearr_59613[(11)] = inst_59550);

(statearr_59613[(12)] = inst_59549);

return statearr_59613;
})();
var statearr_59614_59648 = state_59596__$1;
(statearr_59614_59648[(2)] = null);

(statearr_59614_59648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (17))){
var inst_59562 = (state_59596[(7)]);
var inst_59566 = cljs.core.chunk_first.call(null,inst_59562);
var inst_59567 = cljs.core.chunk_rest.call(null,inst_59562);
var inst_59568 = cljs.core.count.call(null,inst_59566);
var inst_59548 = inst_59567;
var inst_59549 = inst_59566;
var inst_59550 = inst_59568;
var inst_59551 = (0);
var state_59596__$1 = (function (){var statearr_59615 = state_59596;
(statearr_59615[(8)] = inst_59548);

(statearr_59615[(10)] = inst_59551);

(statearr_59615[(11)] = inst_59550);

(statearr_59615[(12)] = inst_59549);

return statearr_59615;
})();
var statearr_59616_59649 = state_59596__$1;
(statearr_59616_59649[(2)] = null);

(statearr_59616_59649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (3))){
var inst_59594 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59596__$1,inst_59594);
} else {
if((state_val_59597 === (12))){
var inst_59582 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59617_59650 = state_59596__$1;
(statearr_59617_59650[(2)] = inst_59582);

(statearr_59617_59650[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (2))){
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59596__$1,(4),in$);
} else {
if((state_val_59597 === (23))){
var inst_59590 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59618_59651 = state_59596__$1;
(statearr_59618_59651[(2)] = inst_59590);

(statearr_59618_59651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (19))){
var inst_59577 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59619_59652 = state_59596__$1;
(statearr_59619_59652[(2)] = inst_59577);

(statearr_59619_59652[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (11))){
var inst_59548 = (state_59596[(8)]);
var inst_59562 = (state_59596[(7)]);
var inst_59562__$1 = cljs.core.seq.call(null,inst_59548);
var state_59596__$1 = (function (){var statearr_59620 = state_59596;
(statearr_59620[(7)] = inst_59562__$1);

return statearr_59620;
})();
if(inst_59562__$1){
var statearr_59621_59653 = state_59596__$1;
(statearr_59621_59653[(1)] = (14));

} else {
var statearr_59622_59654 = state_59596__$1;
(statearr_59622_59654[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (9))){
var inst_59584 = (state_59596[(2)]);
var inst_59585 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_59596__$1 = (function (){var statearr_59623 = state_59596;
(statearr_59623[(15)] = inst_59584);

return statearr_59623;
})();
if(cljs.core.truth_(inst_59585)){
var statearr_59624_59655 = state_59596__$1;
(statearr_59624_59655[(1)] = (21));

} else {
var statearr_59625_59656 = state_59596__$1;
(statearr_59625_59656[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (5))){
var inst_59540 = cljs.core.async.close_BANG_.call(null,out);
var state_59596__$1 = state_59596;
var statearr_59626_59657 = state_59596__$1;
(statearr_59626_59657[(2)] = inst_59540);

(statearr_59626_59657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (14))){
var inst_59562 = (state_59596[(7)]);
var inst_59564 = cljs.core.chunked_seq_QMARK_.call(null,inst_59562);
var state_59596__$1 = state_59596;
if(inst_59564){
var statearr_59627_59658 = state_59596__$1;
(statearr_59627_59658[(1)] = (17));

} else {
var statearr_59628_59659 = state_59596__$1;
(statearr_59628_59659[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (16))){
var inst_59580 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59629_59660 = state_59596__$1;
(statearr_59629_59660[(2)] = inst_59580);

(statearr_59629_59660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (10))){
var inst_59551 = (state_59596[(10)]);
var inst_59549 = (state_59596[(12)]);
var inst_59556 = cljs.core._nth.call(null,inst_59549,inst_59551);
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59596__$1,(13),out,inst_59556);
} else {
if((state_val_59597 === (18))){
var inst_59562 = (state_59596[(7)]);
var inst_59571 = cljs.core.first.call(null,inst_59562);
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59596__$1,(20),out,inst_59571);
} else {
if((state_val_59597 === (8))){
var inst_59551 = (state_59596[(10)]);
var inst_59550 = (state_59596[(11)]);
var inst_59553 = (inst_59551 < inst_59550);
var inst_59554 = inst_59553;
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59554)){
var statearr_59630_59661 = state_59596__$1;
(statearr_59630_59661[(1)] = (10));

} else {
var statearr_59631_59662 = state_59596__$1;
(statearr_59631_59662[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____0 = (function (){
var statearr_59635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59635[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__);

(statearr_59635[(1)] = (1));

return statearr_59635;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____1 = (function (state_59596){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59636){if((e59636 instanceof Object)){
var ex__31353__auto__ = e59636;
var statearr_59637_59663 = state_59596;
(statearr_59637_59663[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59664 = state_59596;
state_59596 = G__59664;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__ = function(state_59596){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____1.call(this,state_59596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31350__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_59638 = f__31464__auto__.call(null);
(statearr_59638[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_59638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args59665 = [];
var len__28856__auto___59668 = arguments.length;
var i__28857__auto___59669 = (0);
while(true){
if((i__28857__auto___59669 < len__28856__auto___59668)){
args59665.push((arguments[i__28857__auto___59669]));

var G__59670 = (i__28857__auto___59669 + (1));
i__28857__auto___59669 = G__59670;
continue;
} else {
}
break;
}

var G__59667 = args59665.length;
switch (G__59667) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59665.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args59672 = [];
var len__28856__auto___59675 = arguments.length;
var i__28857__auto___59676 = (0);
while(true){
if((i__28857__auto___59676 < len__28856__auto___59675)){
args59672.push((arguments[i__28857__auto___59676]));

var G__59677 = (i__28857__auto___59676 + (1));
i__28857__auto___59676 = G__59677;
continue;
} else {
}
break;
}

var G__59674 = args59672.length;
switch (G__59674) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59672.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args59679 = [];
var len__28856__auto___59730 = arguments.length;
var i__28857__auto___59731 = (0);
while(true){
if((i__28857__auto___59731 < len__28856__auto___59730)){
args59679.push((arguments[i__28857__auto___59731]));

var G__59732 = (i__28857__auto___59731 + (1));
i__28857__auto___59731 = G__59732;
continue;
} else {
}
break;
}

var G__59681 = args59679.length;
switch (G__59681) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59679.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59734,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59734,out){
return (function (state_59705){
var state_val_59706 = (state_59705[(1)]);
if((state_val_59706 === (7))){
var inst_59700 = (state_59705[(2)]);
var state_59705__$1 = state_59705;
var statearr_59707_59735 = state_59705__$1;
(statearr_59707_59735[(2)] = inst_59700);

(statearr_59707_59735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (1))){
var inst_59682 = null;
var state_59705__$1 = (function (){var statearr_59708 = state_59705;
(statearr_59708[(7)] = inst_59682);

return statearr_59708;
})();
var statearr_59709_59736 = state_59705__$1;
(statearr_59709_59736[(2)] = null);

(statearr_59709_59736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (4))){
var inst_59685 = (state_59705[(8)]);
var inst_59685__$1 = (state_59705[(2)]);
var inst_59686 = (inst_59685__$1 == null);
var inst_59687 = cljs.core.not.call(null,inst_59686);
var state_59705__$1 = (function (){var statearr_59710 = state_59705;
(statearr_59710[(8)] = inst_59685__$1);

return statearr_59710;
})();
if(inst_59687){
var statearr_59711_59737 = state_59705__$1;
(statearr_59711_59737[(1)] = (5));

} else {
var statearr_59712_59738 = state_59705__$1;
(statearr_59712_59738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (6))){
var state_59705__$1 = state_59705;
var statearr_59713_59739 = state_59705__$1;
(statearr_59713_59739[(2)] = null);

(statearr_59713_59739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (3))){
var inst_59702 = (state_59705[(2)]);
var inst_59703 = cljs.core.async.close_BANG_.call(null,out);
var state_59705__$1 = (function (){var statearr_59714 = state_59705;
(statearr_59714[(9)] = inst_59702);

return statearr_59714;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59705__$1,inst_59703);
} else {
if((state_val_59706 === (2))){
var state_59705__$1 = state_59705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59705__$1,(4),ch);
} else {
if((state_val_59706 === (11))){
var inst_59685 = (state_59705[(8)]);
var inst_59694 = (state_59705[(2)]);
var inst_59682 = inst_59685;
var state_59705__$1 = (function (){var statearr_59715 = state_59705;
(statearr_59715[(7)] = inst_59682);

(statearr_59715[(10)] = inst_59694);

return statearr_59715;
})();
var statearr_59716_59740 = state_59705__$1;
(statearr_59716_59740[(2)] = null);

(statearr_59716_59740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (9))){
var inst_59685 = (state_59705[(8)]);
var state_59705__$1 = state_59705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59705__$1,(11),out,inst_59685);
} else {
if((state_val_59706 === (5))){
var inst_59682 = (state_59705[(7)]);
var inst_59685 = (state_59705[(8)]);
var inst_59689 = cljs.core._EQ_.call(null,inst_59685,inst_59682);
var state_59705__$1 = state_59705;
if(inst_59689){
var statearr_59718_59741 = state_59705__$1;
(statearr_59718_59741[(1)] = (8));

} else {
var statearr_59719_59742 = state_59705__$1;
(statearr_59719_59742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (10))){
var inst_59697 = (state_59705[(2)]);
var state_59705__$1 = state_59705;
var statearr_59720_59743 = state_59705__$1;
(statearr_59720_59743[(2)] = inst_59697);

(statearr_59720_59743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59706 === (8))){
var inst_59682 = (state_59705[(7)]);
var tmp59717 = inst_59682;
var inst_59682__$1 = tmp59717;
var state_59705__$1 = (function (){var statearr_59721 = state_59705;
(statearr_59721[(7)] = inst_59682__$1);

return statearr_59721;
})();
var statearr_59722_59744 = state_59705__$1;
(statearr_59722_59744[(2)] = null);

(statearr_59722_59744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59734,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59734,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59726 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_59726[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59726[(1)] = (1));

return statearr_59726;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59705){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59727){if((e59727 instanceof Object)){
var ex__31353__auto__ = e59727;
var statearr_59728_59745 = state_59705;
(statearr_59728_59745[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59727;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59746 = state_59705;
state_59705 = G__59746;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59705){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59734,out))
})();
var state__31465__auto__ = (function (){var statearr_59729 = f__31464__auto__.call(null);
(statearr_59729[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59734);

return statearr_59729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59734,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args59747 = [];
var len__28856__auto___59817 = arguments.length;
var i__28857__auto___59818 = (0);
while(true){
if((i__28857__auto___59818 < len__28856__auto___59817)){
args59747.push((arguments[i__28857__auto___59818]));

var G__59819 = (i__28857__auto___59818 + (1));
i__28857__auto___59818 = G__59819;
continue;
} else {
}
break;
}

var G__59749 = args59747.length;
switch (G__59749) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59747.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59821 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59821,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59821,out){
return (function (state_59787){
var state_val_59788 = (state_59787[(1)]);
if((state_val_59788 === (7))){
var inst_59783 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59789_59822 = state_59787__$1;
(statearr_59789_59822[(2)] = inst_59783);

(statearr_59789_59822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (1))){
var inst_59750 = (new Array(n));
var inst_59751 = inst_59750;
var inst_59752 = (0);
var state_59787__$1 = (function (){var statearr_59790 = state_59787;
(statearr_59790[(7)] = inst_59752);

(statearr_59790[(8)] = inst_59751);

return statearr_59790;
})();
var statearr_59791_59823 = state_59787__$1;
(statearr_59791_59823[(2)] = null);

(statearr_59791_59823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (4))){
var inst_59755 = (state_59787[(9)]);
var inst_59755__$1 = (state_59787[(2)]);
var inst_59756 = (inst_59755__$1 == null);
var inst_59757 = cljs.core.not.call(null,inst_59756);
var state_59787__$1 = (function (){var statearr_59792 = state_59787;
(statearr_59792[(9)] = inst_59755__$1);

return statearr_59792;
})();
if(inst_59757){
var statearr_59793_59824 = state_59787__$1;
(statearr_59793_59824[(1)] = (5));

} else {
var statearr_59794_59825 = state_59787__$1;
(statearr_59794_59825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (15))){
var inst_59777 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59795_59826 = state_59787__$1;
(statearr_59795_59826[(2)] = inst_59777);

(statearr_59795_59826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (13))){
var state_59787__$1 = state_59787;
var statearr_59796_59827 = state_59787__$1;
(statearr_59796_59827[(2)] = null);

(statearr_59796_59827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (6))){
var inst_59752 = (state_59787[(7)]);
var inst_59773 = (inst_59752 > (0));
var state_59787__$1 = state_59787;
if(cljs.core.truth_(inst_59773)){
var statearr_59797_59828 = state_59787__$1;
(statearr_59797_59828[(1)] = (12));

} else {
var statearr_59798_59829 = state_59787__$1;
(statearr_59798_59829[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (3))){
var inst_59785 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59787__$1,inst_59785);
} else {
if((state_val_59788 === (12))){
var inst_59751 = (state_59787[(8)]);
var inst_59775 = cljs.core.vec.call(null,inst_59751);
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59787__$1,(15),out,inst_59775);
} else {
if((state_val_59788 === (2))){
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59787__$1,(4),ch);
} else {
if((state_val_59788 === (11))){
var inst_59767 = (state_59787[(2)]);
var inst_59768 = (new Array(n));
var inst_59751 = inst_59768;
var inst_59752 = (0);
var state_59787__$1 = (function (){var statearr_59799 = state_59787;
(statearr_59799[(7)] = inst_59752);

(statearr_59799[(8)] = inst_59751);

(statearr_59799[(10)] = inst_59767);

return statearr_59799;
})();
var statearr_59800_59830 = state_59787__$1;
(statearr_59800_59830[(2)] = null);

(statearr_59800_59830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (9))){
var inst_59751 = (state_59787[(8)]);
var inst_59765 = cljs.core.vec.call(null,inst_59751);
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59787__$1,(11),out,inst_59765);
} else {
if((state_val_59788 === (5))){
var inst_59752 = (state_59787[(7)]);
var inst_59751 = (state_59787[(8)]);
var inst_59755 = (state_59787[(9)]);
var inst_59760 = (state_59787[(11)]);
var inst_59759 = (inst_59751[inst_59752] = inst_59755);
var inst_59760__$1 = (inst_59752 + (1));
var inst_59761 = (inst_59760__$1 < n);
var state_59787__$1 = (function (){var statearr_59801 = state_59787;
(statearr_59801[(11)] = inst_59760__$1);

(statearr_59801[(12)] = inst_59759);

return statearr_59801;
})();
if(cljs.core.truth_(inst_59761)){
var statearr_59802_59831 = state_59787__$1;
(statearr_59802_59831[(1)] = (8));

} else {
var statearr_59803_59832 = state_59787__$1;
(statearr_59803_59832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (14))){
var inst_59780 = (state_59787[(2)]);
var inst_59781 = cljs.core.async.close_BANG_.call(null,out);
var state_59787__$1 = (function (){var statearr_59805 = state_59787;
(statearr_59805[(13)] = inst_59780);

return statearr_59805;
})();
var statearr_59806_59833 = state_59787__$1;
(statearr_59806_59833[(2)] = inst_59781);

(statearr_59806_59833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (10))){
var inst_59771 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59807_59834 = state_59787__$1;
(statearr_59807_59834[(2)] = inst_59771);

(statearr_59807_59834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (8))){
var inst_59751 = (state_59787[(8)]);
var inst_59760 = (state_59787[(11)]);
var tmp59804 = inst_59751;
var inst_59751__$1 = tmp59804;
var inst_59752 = inst_59760;
var state_59787__$1 = (function (){var statearr_59808 = state_59787;
(statearr_59808[(7)] = inst_59752);

(statearr_59808[(8)] = inst_59751__$1);

return statearr_59808;
})();
var statearr_59809_59835 = state_59787__$1;
(statearr_59809_59835[(2)] = null);

(statearr_59809_59835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59821,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59821,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59813 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59813[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59813[(1)] = (1));

return statearr_59813;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59787){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59814){if((e59814 instanceof Object)){
var ex__31353__auto__ = e59814;
var statearr_59815_59836 = state_59787;
(statearr_59815_59836[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59787);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59837 = state_59787;
state_59787 = G__59837;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59787){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59821,out))
})();
var state__31465__auto__ = (function (){var statearr_59816 = f__31464__auto__.call(null);
(statearr_59816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59821);

return statearr_59816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59821,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args59838 = [];
var len__28856__auto___59912 = arguments.length;
var i__28857__auto___59913 = (0);
while(true){
if((i__28857__auto___59913 < len__28856__auto___59912)){
args59838.push((arguments[i__28857__auto___59913]));

var G__59914 = (i__28857__auto___59913 + (1));
i__28857__auto___59913 = G__59914;
continue;
} else {
}
break;
}

var G__59840 = args59838.length;
switch (G__59840) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59838.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31463__auto___59916 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___59916,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___59916,out){
return (function (state_59882){
var state_val_59883 = (state_59882[(1)]);
if((state_val_59883 === (7))){
var inst_59878 = (state_59882[(2)]);
var state_59882__$1 = state_59882;
var statearr_59884_59917 = state_59882__$1;
(statearr_59884_59917[(2)] = inst_59878);

(statearr_59884_59917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (1))){
var inst_59841 = [];
var inst_59842 = inst_59841;
var inst_59843 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_59882__$1 = (function (){var statearr_59885 = state_59882;
(statearr_59885[(7)] = inst_59842);

(statearr_59885[(8)] = inst_59843);

return statearr_59885;
})();
var statearr_59886_59918 = state_59882__$1;
(statearr_59886_59918[(2)] = null);

(statearr_59886_59918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (4))){
var inst_59846 = (state_59882[(9)]);
var inst_59846__$1 = (state_59882[(2)]);
var inst_59847 = (inst_59846__$1 == null);
var inst_59848 = cljs.core.not.call(null,inst_59847);
var state_59882__$1 = (function (){var statearr_59887 = state_59882;
(statearr_59887[(9)] = inst_59846__$1);

return statearr_59887;
})();
if(inst_59848){
var statearr_59888_59919 = state_59882__$1;
(statearr_59888_59919[(1)] = (5));

} else {
var statearr_59889_59920 = state_59882__$1;
(statearr_59889_59920[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (15))){
var inst_59872 = (state_59882[(2)]);
var state_59882__$1 = state_59882;
var statearr_59890_59921 = state_59882__$1;
(statearr_59890_59921[(2)] = inst_59872);

(statearr_59890_59921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (13))){
var state_59882__$1 = state_59882;
var statearr_59891_59922 = state_59882__$1;
(statearr_59891_59922[(2)] = null);

(statearr_59891_59922[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (6))){
var inst_59842 = (state_59882[(7)]);
var inst_59867 = inst_59842.length;
var inst_59868 = (inst_59867 > (0));
var state_59882__$1 = state_59882;
if(cljs.core.truth_(inst_59868)){
var statearr_59892_59923 = state_59882__$1;
(statearr_59892_59923[(1)] = (12));

} else {
var statearr_59893_59924 = state_59882__$1;
(statearr_59893_59924[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (3))){
var inst_59880 = (state_59882[(2)]);
var state_59882__$1 = state_59882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59882__$1,inst_59880);
} else {
if((state_val_59883 === (12))){
var inst_59842 = (state_59882[(7)]);
var inst_59870 = cljs.core.vec.call(null,inst_59842);
var state_59882__$1 = state_59882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59882__$1,(15),out,inst_59870);
} else {
if((state_val_59883 === (2))){
var state_59882__$1 = state_59882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59882__$1,(4),ch);
} else {
if((state_val_59883 === (11))){
var inst_59850 = (state_59882[(10)]);
var inst_59846 = (state_59882[(9)]);
var inst_59860 = (state_59882[(2)]);
var inst_59861 = [];
var inst_59862 = inst_59861.push(inst_59846);
var inst_59842 = inst_59861;
var inst_59843 = inst_59850;
var state_59882__$1 = (function (){var statearr_59894 = state_59882;
(statearr_59894[(11)] = inst_59862);

(statearr_59894[(7)] = inst_59842);

(statearr_59894[(8)] = inst_59843);

(statearr_59894[(12)] = inst_59860);

return statearr_59894;
})();
var statearr_59895_59925 = state_59882__$1;
(statearr_59895_59925[(2)] = null);

(statearr_59895_59925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (9))){
var inst_59842 = (state_59882[(7)]);
var inst_59858 = cljs.core.vec.call(null,inst_59842);
var state_59882__$1 = state_59882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59882__$1,(11),out,inst_59858);
} else {
if((state_val_59883 === (5))){
var inst_59850 = (state_59882[(10)]);
var inst_59846 = (state_59882[(9)]);
var inst_59843 = (state_59882[(8)]);
var inst_59850__$1 = f.call(null,inst_59846);
var inst_59851 = cljs.core._EQ_.call(null,inst_59850__$1,inst_59843);
var inst_59852 = cljs.core.keyword_identical_QMARK_.call(null,inst_59843,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_59853 = (inst_59851) || (inst_59852);
var state_59882__$1 = (function (){var statearr_59896 = state_59882;
(statearr_59896[(10)] = inst_59850__$1);

return statearr_59896;
})();
if(cljs.core.truth_(inst_59853)){
var statearr_59897_59926 = state_59882__$1;
(statearr_59897_59926[(1)] = (8));

} else {
var statearr_59898_59927 = state_59882__$1;
(statearr_59898_59927[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (14))){
var inst_59875 = (state_59882[(2)]);
var inst_59876 = cljs.core.async.close_BANG_.call(null,out);
var state_59882__$1 = (function (){var statearr_59900 = state_59882;
(statearr_59900[(13)] = inst_59875);

return statearr_59900;
})();
var statearr_59901_59928 = state_59882__$1;
(statearr_59901_59928[(2)] = inst_59876);

(statearr_59901_59928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (10))){
var inst_59865 = (state_59882[(2)]);
var state_59882__$1 = state_59882;
var statearr_59902_59929 = state_59882__$1;
(statearr_59902_59929[(2)] = inst_59865);

(statearr_59902_59929[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59883 === (8))){
var inst_59842 = (state_59882[(7)]);
var inst_59850 = (state_59882[(10)]);
var inst_59846 = (state_59882[(9)]);
var inst_59855 = inst_59842.push(inst_59846);
var tmp59899 = inst_59842;
var inst_59842__$1 = tmp59899;
var inst_59843 = inst_59850;
var state_59882__$1 = (function (){var statearr_59903 = state_59882;
(statearr_59903[(7)] = inst_59842__$1);

(statearr_59903[(8)] = inst_59843);

(statearr_59903[(14)] = inst_59855);

return statearr_59903;
})();
var statearr_59904_59930 = state_59882__$1;
(statearr_59904_59930[(2)] = null);

(statearr_59904_59930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___59916,out))
;
return ((function (switch__31349__auto__,c__31463__auto___59916,out){
return (function() {
var cljs$core$async$state_machine__31350__auto__ = null;
var cljs$core$async$state_machine__31350__auto____0 = (function (){
var statearr_59908 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59908[(0)] = cljs$core$async$state_machine__31350__auto__);

(statearr_59908[(1)] = (1));

return statearr_59908;
});
var cljs$core$async$state_machine__31350__auto____1 = (function (state_59882){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_59882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e59909){if((e59909 instanceof Object)){
var ex__31353__auto__ = e59909;
var statearr_59910_59931 = state_59882;
(statearr_59910_59931[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59909;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59932 = state_59882;
state_59882 = G__59932;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
cljs$core$async$state_machine__31350__auto__ = function(state_59882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31350__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31350__auto____1.call(this,state_59882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31350__auto____0;
cljs$core$async$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31350__auto____1;
return cljs$core$async$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___59916,out))
})();
var state__31465__auto__ = (function (){var statearr_59911 = f__31464__auto__.call(null);
(statearr_59911[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___59916);

return statearr_59911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___59916,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1486510897066