// Compiled by ClojureScript 1.9.456 {}
goog.provide('devtools.core');
goog.require('cljs.core');
goog.require('devtools.prefs');
goog.require('devtools.sanity_hints');
goog.require('devtools.custom_formatters');
goog.require('devtools.dirac');
goog.require('devtools.util');
goog.require('goog.userAgent');
devtools.core.known_features = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779),new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327),new cljs.core.Keyword(null,"dirac","dirac",1785994033),new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649),new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858),new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)], null);
devtools.core.missing_feature_warning = (function devtools$core$missing_feature_warning(feature,known_features){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No such feature '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(feature),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' is currently available in cljs-devtools. "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("List of supported features:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.keys.call(null,known_features))].join('');
});
devtools.core.warn_feature_not_available = (function devtools$core$warn_feature_not_available(feature){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Feature '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,feature)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' cannot be installed. Unsupported browser "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.userAgent.getUserAgentString()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".")].join(''));
});
devtools.core.install_BANG_ = (function devtools$core$install_BANG_(){
devtools.util.display_banner.call(null,"Installing cljs-devtools:",devtools.core.known_features);

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327)))){
if(cljs.core.truth_(devtools.custom_formatters.available_QMARK_.call(null))){
devtools.custom_formatters.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)))){
if(cljs.core.truth_(devtools.sanity_hints.available_QMARK_.call(null))){
devtools.sanity_hints.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649)))){
if(cljs.core.truth_(devtools.dirac.available_QMARK_.call(null))){
return devtools.dirac.install_BANG_.call(null);
} else {
return devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"dirac","dirac",1785994033));
}
} else {
return null;
}
});
devtools.core.uninstall_BANG_ = (function devtools$core$uninstall_BANG_(){
devtools.custom_formatters.uninstall_BANG_.call(null);

devtools.sanity_hints.uninstall_BANG_.call(null);

return devtools.dirac.uninstall_BANG_.call(null);
});
devtools.core.set_prefs_BANG_ = (function devtools$core$set_prefs_BANG_(new_prefs){
return devtools.prefs.set_prefs_BANG_.call(null,new_prefs);
});
devtools.core.get_prefs = (function devtools$core$get_prefs(){
return devtools.prefs.get_prefs.call(null);
});
devtools.core.set_pref_BANG_ = (function devtools$core$set_pref_BANG_(pref,val){
return devtools.prefs.set_pref_BANG_.call(null,pref,val);
});
devtools.core.set_single_feature_BANG_ = (function devtools$core$set_single_feature_BANG_(feature,val){
var temp__6751__auto__ = feature.call(null,devtools.core.known_features);
if(cljs.core.truth_(temp__6751__auto__)){
var feature_installation_key = temp__6751__auto__;
return devtools.core.set_pref_BANG_.call(null,feature_installation_key,val);
} else {
return console.warn(devtools.core.missing_feature_warning.call(null,feature,devtools.core.known_features));
}
});
devtools.core.enable_single_feature_BANG_ = (function devtools$core$enable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,true);
});
devtools.core.disable_single_feature_BANG_ = (function devtools$core$disable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,false);
});
devtools.core.enable_feature_BANG_ = (function devtools$core$enable_feature_BANG_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___76681 = arguments.length;
var i__28857__auto___76682 = (0);
while(true){
if((i__28857__auto___76682 < len__28856__auto___76681)){
args__28863__auto__.push((arguments[i__28857__auto___76682]));

var G__76683 = (i__28857__auto___76682 + (1));
i__28857__auto___76682 = G__76683;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__76677 = cljs.core.seq.call(null,features);
var chunk__76678 = null;
var count__76679 = (0);
var i__76680 = (0);
while(true){
if((i__76680 < count__76679)){
var feature = cljs.core._nth.call(null,chunk__76678,i__76680);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__76684 = seq__76677;
var G__76685 = chunk__76678;
var G__76686 = count__76679;
var G__76687 = (i__76680 + (1));
seq__76677 = G__76684;
chunk__76678 = G__76685;
count__76679 = G__76686;
i__76680 = G__76687;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__76677);
if(temp__6753__auto__){
var seq__76677__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__76677__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__76677__$1);
var G__76688 = cljs.core.chunk_rest.call(null,seq__76677__$1);
var G__76689 = c__28546__auto__;
var G__76690 = cljs.core.count.call(null,c__28546__auto__);
var G__76691 = (0);
seq__76677 = G__76688;
chunk__76678 = G__76689;
count__76679 = G__76690;
i__76680 = G__76691;
continue;
} else {
var feature = cljs.core.first.call(null,seq__76677__$1);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__76692 = cljs.core.next.call(null,seq__76677__$1);
var G__76693 = null;
var G__76694 = (0);
var G__76695 = (0);
seq__76677 = G__76692;
chunk__76678 = G__76693;
count__76679 = G__76694;
i__76680 = G__76695;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.enable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.enable_feature_BANG_.cljs$lang$applyTo = (function (seq76676){
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq76676));
});

devtools.core.disable_feature_BANG_ = (function devtools$core$disable_feature_BANG_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___76701 = arguments.length;
var i__28857__auto___76702 = (0);
while(true){
if((i__28857__auto___76702 < len__28856__auto___76701)){
args__28863__auto__.push((arguments[i__28857__auto___76702]));

var G__76703 = (i__28857__auto___76702 + (1));
i__28857__auto___76702 = G__76703;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__76697 = cljs.core.seq.call(null,features);
var chunk__76698 = null;
var count__76699 = (0);
var i__76700 = (0);
while(true){
if((i__76700 < count__76699)){
var feature = cljs.core._nth.call(null,chunk__76698,i__76700);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__76704 = seq__76697;
var G__76705 = chunk__76698;
var G__76706 = count__76699;
var G__76707 = (i__76700 + (1));
seq__76697 = G__76704;
chunk__76698 = G__76705;
count__76699 = G__76706;
i__76700 = G__76707;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__76697);
if(temp__6753__auto__){
var seq__76697__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__76697__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__76697__$1);
var G__76708 = cljs.core.chunk_rest.call(null,seq__76697__$1);
var G__76709 = c__28546__auto__;
var G__76710 = cljs.core.count.call(null,c__28546__auto__);
var G__76711 = (0);
seq__76697 = G__76708;
chunk__76698 = G__76709;
count__76699 = G__76710;
i__76700 = G__76711;
continue;
} else {
var feature = cljs.core.first.call(null,seq__76697__$1);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__76712 = cljs.core.next.call(null,seq__76697__$1);
var G__76713 = null;
var G__76714 = (0);
var G__76715 = (0);
seq__76697 = G__76712;
chunk__76698 = G__76713;
count__76699 = G__76714;
i__76700 = G__76715;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.disable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.disable_feature_BANG_.cljs$lang$applyTo = (function (seq76696){
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq76696));
});

devtools.core.single_feature_available_QMARK_ = (function devtools$core$single_feature_available_QMARK_(feature){
var G__76717 = (((feature instanceof cljs.core.Keyword))?feature.fqn:null);
switch (G__76717) {
case "custom-formatters":
return devtools.custom_formatters.available_QMARK_.call(null);

break;
case "dirac":
return devtools.dirac.available_QMARK_.call(null);

break;
case "sanity-hints":
return devtools.sanity_hints.available_QMARK_.call(null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(feature)].join('')));

}
});
devtools.core.feature_available_QMARK_ = (function devtools$core$feature_available_QMARK_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___76720 = arguments.length;
var i__28857__auto___76721 = (0);
while(true){
if((i__28857__auto___76721 < len__28856__auto___76720)){
args__28863__auto__.push((arguments[i__28857__auto___76721]));

var G__76722 = (i__28857__auto___76721 + (1));
i__28857__auto___76721 = G__76722;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
return cljs.core.every_QMARK_.call(null,devtools.core.single_feature_available_QMARK_,features);
});

devtools.core.feature_available_QMARK_.cljs$lang$maxFixedArity = (0);

devtools.core.feature_available_QMARK_.cljs$lang$applyTo = (function (seq76719){
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq76719));
});

devtools.core.enable_BANG_ = (function devtools$core$enable_BANG_(){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("devtools.core/enable! was deprecated "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("and has no effect in current version of cljs-devtools "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=> remove the call")].join(''));
});
devtools.core.disable_BANG_ = (function devtools$core$disable_BANG_(){
return console.warn([cljs.core.str.cljs$core$IFn$_invoke$arity$1("devtools.core/disable! was deprecated "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("and has no effect in current version of cljs-devtools "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=> remove the call")].join(''));
});

//# sourceMappingURL=core.js.map?rel=1486510919313