// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args64295 = [];
var len__28856__auto___64298 = arguments.length;
var i__28857__auto___64299 = (0);
while(true){
if((i__28857__auto___64299 < len__28856__auto___64298)){
args64295.push((arguments[i__28857__auto___64299]));

var G__64300 = (i__28857__auto___64299 + (1));
i__28857__auto___64299 = G__64300;
continue;
} else {
}
break;
}

var G__64297 = args64295.length;
switch (G__64297) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args64295.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__28863__auto__ = [];
var len__28856__auto___64303 = arguments.length;
var i__28857__auto___64304 = (0);
while(true){
if((i__28857__auto___64304 < len__28856__auto___64303)){
args__28863__auto__.push((arguments[i__28857__auto___64304]));

var G__64305 = (i__28857__auto___64304 + (1));
i__28857__auto___64304 = G__64305;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq64302){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq64302));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__28863__auto__ = [];
var len__28856__auto___64307 = arguments.length;
var i__28857__auto___64308 = (0);
while(true){
if((i__28857__auto___64308 < len__28856__auto___64307)){
args__28863__auto__.push((arguments[i__28857__auto___64308]));

var G__64309 = (i__28857__auto___64308 + (1));
i__28857__auto___64308 = G__64309;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq64306){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq64306));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__64310){
var map__64313 = p__64310;
var map__64313__$1 = ((((!((map__64313 == null)))?((((map__64313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64313.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64313):map__64313);
var message = cljs.core.get.call(null,map__64313__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__64313__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27635__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27623__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27623__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27623__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__31463__auto___64475 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___64475,ch){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___64475,ch){
return (function (state_64444){
var state_val_64445 = (state_64444[(1)]);
if((state_val_64445 === (7))){
var inst_64440 = (state_64444[(2)]);
var state_64444__$1 = state_64444;
var statearr_64446_64476 = state_64444__$1;
(statearr_64446_64476[(2)] = inst_64440);

(statearr_64446_64476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (1))){
var state_64444__$1 = state_64444;
var statearr_64447_64477 = state_64444__$1;
(statearr_64447_64477[(2)] = null);

(statearr_64447_64477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (4))){
var inst_64397 = (state_64444[(7)]);
var inst_64397__$1 = (state_64444[(2)]);
var state_64444__$1 = (function (){var statearr_64448 = state_64444;
(statearr_64448[(7)] = inst_64397__$1);

return statearr_64448;
})();
if(cljs.core.truth_(inst_64397__$1)){
var statearr_64449_64478 = state_64444__$1;
(statearr_64449_64478[(1)] = (5));

} else {
var statearr_64450_64479 = state_64444__$1;
(statearr_64450_64479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (15))){
var inst_64404 = (state_64444[(8)]);
var inst_64419 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_64404);
var inst_64420 = cljs.core.first.call(null,inst_64419);
var inst_64421 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_64420);
var inst_64422 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64421)].join('');
var inst_64423 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_64422);
var state_64444__$1 = state_64444;
var statearr_64451_64480 = state_64444__$1;
(statearr_64451_64480[(2)] = inst_64423);

(statearr_64451_64480[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (13))){
var inst_64428 = (state_64444[(2)]);
var state_64444__$1 = state_64444;
var statearr_64452_64481 = state_64444__$1;
(statearr_64452_64481[(2)] = inst_64428);

(statearr_64452_64481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (6))){
var state_64444__$1 = state_64444;
var statearr_64453_64482 = state_64444__$1;
(statearr_64453_64482[(2)] = null);

(statearr_64453_64482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (17))){
var inst_64426 = (state_64444[(2)]);
var state_64444__$1 = state_64444;
var statearr_64454_64483 = state_64444__$1;
(statearr_64454_64483[(2)] = inst_64426);

(statearr_64454_64483[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (3))){
var inst_64442 = (state_64444[(2)]);
var state_64444__$1 = state_64444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64444__$1,inst_64442);
} else {
if((state_val_64445 === (12))){
var inst_64403 = (state_64444[(9)]);
var inst_64417 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_64403,opts);
var state_64444__$1 = state_64444;
if(cljs.core.truth_(inst_64417)){
var statearr_64455_64484 = state_64444__$1;
(statearr_64455_64484[(1)] = (15));

} else {
var statearr_64456_64485 = state_64444__$1;
(statearr_64456_64485[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (2))){
var state_64444__$1 = state_64444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64444__$1,(4),ch);
} else {
if((state_val_64445 === (11))){
var inst_64404 = (state_64444[(8)]);
var inst_64409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64410 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_64404);
var inst_64411 = cljs.core.async.timeout.call(null,(1000));
var inst_64412 = [inst_64410,inst_64411];
var inst_64413 = (new cljs.core.PersistentVector(null,2,(5),inst_64409,inst_64412,null));
var state_64444__$1 = state_64444;
return cljs.core.async.ioc_alts_BANG_.call(null,state_64444__$1,(14),inst_64413);
} else {
if((state_val_64445 === (9))){
var inst_64404 = (state_64444[(8)]);
var inst_64430 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_64431 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_64404);
var inst_64432 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_64431);
var inst_64433 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64432)].join('');
var inst_64434 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_64433);
var state_64444__$1 = (function (){var statearr_64457 = state_64444;
(statearr_64457[(10)] = inst_64430);

return statearr_64457;
})();
var statearr_64458_64486 = state_64444__$1;
(statearr_64458_64486[(2)] = inst_64434);

(statearr_64458_64486[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (5))){
var inst_64397 = (state_64444[(7)]);
var inst_64399 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_64400 = (new cljs.core.PersistentArrayMap(null,2,inst_64399,null));
var inst_64401 = (new cljs.core.PersistentHashSet(null,inst_64400,null));
var inst_64402 = figwheel.client.focus_msgs.call(null,inst_64401,inst_64397);
var inst_64403 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_64402);
var inst_64404 = cljs.core.first.call(null,inst_64402);
var inst_64405 = figwheel.client.autoload_QMARK_.call(null);
var state_64444__$1 = (function (){var statearr_64459 = state_64444;
(statearr_64459[(9)] = inst_64403);

(statearr_64459[(8)] = inst_64404);

return statearr_64459;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64460_64487 = state_64444__$1;
(statearr_64460_64487[(1)] = (8));

} else {
var statearr_64461_64488 = state_64444__$1;
(statearr_64461_64488[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (14))){
var inst_64415 = (state_64444[(2)]);
var state_64444__$1 = state_64444;
var statearr_64462_64489 = state_64444__$1;
(statearr_64462_64489[(2)] = inst_64415);

(statearr_64462_64489[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (16))){
var state_64444__$1 = state_64444;
var statearr_64463_64490 = state_64444__$1;
(statearr_64463_64490[(2)] = null);

(statearr_64463_64490[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (10))){
var inst_64436 = (state_64444[(2)]);
var state_64444__$1 = (function (){var statearr_64464 = state_64444;
(statearr_64464[(11)] = inst_64436);

return statearr_64464;
})();
var statearr_64465_64491 = state_64444__$1;
(statearr_64465_64491[(2)] = null);

(statearr_64465_64491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64445 === (8))){
var inst_64403 = (state_64444[(9)]);
var inst_64407 = figwheel.client.reload_file_state_QMARK_.call(null,inst_64403,opts);
var state_64444__$1 = state_64444;
if(cljs.core.truth_(inst_64407)){
var statearr_64466_64492 = state_64444__$1;
(statearr_64466_64492[(1)] = (11));

} else {
var statearr_64467_64493 = state_64444__$1;
(statearr_64467_64493[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto___64475,ch))
;
return ((function (switch__31349__auto__,c__31463__auto___64475,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____0 = (function (){
var statearr_64471 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64471[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__);

(statearr_64471[(1)] = (1));

return statearr_64471;
});
var figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____1 = (function (state_64444){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_64444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e64472){if((e64472 instanceof Object)){
var ex__31353__auto__ = e64472;
var statearr_64473_64494 = state_64444;
(statearr_64473_64494[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64444);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64472;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64495 = state_64444;
state_64444 = G__64495;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__ = function(state_64444){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____1.call(this,state_64444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__31350__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___64475,ch))
})();
var state__31465__auto__ = (function (){var statearr_64474 = f__31464__auto__.call(null);
(statearr_64474[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___64475);

return statearr_64474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___64475,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__64496_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__64496_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_64499 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_64499){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e64498){if((e64498 instanceof Error)){
var e = e64498;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_64499], null));
} else {
var e = e64498;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_64499))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__64500){
var map__64509 = p__64500;
var map__64509__$1 = ((((!((map__64509 == null)))?((((map__64509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64509.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64509):map__64509);
var opts = map__64509__$1;
var build_id = cljs.core.get.call(null,map__64509__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__64509,map__64509__$1,opts,build_id){
return (function (p__64511){
var vec__64512 = p__64511;
var seq__64513 = cljs.core.seq.call(null,vec__64512);
var first__64514 = cljs.core.first.call(null,seq__64513);
var seq__64513__$1 = cljs.core.next.call(null,seq__64513);
var map__64515 = first__64514;
var map__64515__$1 = ((((!((map__64515 == null)))?((((map__64515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64515.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64515):map__64515);
var msg = map__64515__$1;
var msg_name = cljs.core.get.call(null,map__64515__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__64513__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__64512,seq__64513,first__64514,seq__64513__$1,map__64515,map__64515__$1,msg,msg_name,_,map__64509,map__64509__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__64512,seq__64513,first__64514,seq__64513__$1,map__64515,map__64515__$1,msg,msg_name,_,map__64509,map__64509__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__64509,map__64509__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__64523){
var vec__64524 = p__64523;
var seq__64525 = cljs.core.seq.call(null,vec__64524);
var first__64526 = cljs.core.first.call(null,seq__64525);
var seq__64525__$1 = cljs.core.next.call(null,seq__64525);
var map__64527 = first__64526;
var map__64527__$1 = ((((!((map__64527 == null)))?((((map__64527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64527.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64527):map__64527);
var msg = map__64527__$1;
var msg_name = cljs.core.get.call(null,map__64527__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__64525__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__64529){
var map__64541 = p__64529;
var map__64541__$1 = ((((!((map__64541 == null)))?((((map__64541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64541.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64541):map__64541);
var on_compile_warning = cljs.core.get.call(null,map__64541__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__64541__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__64541,map__64541__$1,on_compile_warning,on_compile_fail){
return (function (p__64543){
var vec__64544 = p__64543;
var seq__64545 = cljs.core.seq.call(null,vec__64544);
var first__64546 = cljs.core.first.call(null,seq__64545);
var seq__64545__$1 = cljs.core.next.call(null,seq__64545);
var map__64547 = first__64546;
var map__64547__$1 = ((((!((map__64547 == null)))?((((map__64547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64547.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64547):map__64547);
var msg = map__64547__$1;
var msg_name = cljs.core.get.call(null,map__64547__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__64545__$1;
var pred__64549 = cljs.core._EQ_;
var expr__64550 = msg_name;
if(cljs.core.truth_(pred__64549.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__64550))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__64549.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__64550))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__64541,map__64541__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__,msg_hist,msg_names,msg){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__,msg_hist,msg_names,msg){
return (function (state_64778){
var state_val_64779 = (state_64778[(1)]);
if((state_val_64779 === (7))){
var inst_64698 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64698)){
var statearr_64780_64830 = state_64778__$1;
(statearr_64780_64830[(1)] = (8));

} else {
var statearr_64781_64831 = state_64778__$1;
(statearr_64781_64831[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (20))){
var inst_64772 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64782_64832 = state_64778__$1;
(statearr_64782_64832[(2)] = inst_64772);

(statearr_64782_64832[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (27))){
var inst_64768 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64783_64833 = state_64778__$1;
(statearr_64783_64833[(2)] = inst_64768);

(statearr_64783_64833[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (1))){
var inst_64691 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64691)){
var statearr_64784_64834 = state_64778__$1;
(statearr_64784_64834[(1)] = (2));

} else {
var statearr_64785_64835 = state_64778__$1;
(statearr_64785_64835[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (24))){
var inst_64770 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64786_64836 = state_64778__$1;
(statearr_64786_64836[(2)] = inst_64770);

(statearr_64786_64836[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (4))){
var inst_64776 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64778__$1,inst_64776);
} else {
if((state_val_64779 === (15))){
var inst_64774 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64787_64837 = state_64778__$1;
(statearr_64787_64837[(2)] = inst_64774);

(statearr_64787_64837[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (21))){
var inst_64727 = (state_64778[(2)]);
var inst_64728 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64729 = figwheel.client.auto_jump_to_error.call(null,opts,inst_64728);
var state_64778__$1 = (function (){var statearr_64788 = state_64778;
(statearr_64788[(7)] = inst_64727);

return statearr_64788;
})();
var statearr_64789_64838 = state_64778__$1;
(statearr_64789_64838[(2)] = inst_64729);

(statearr_64789_64838[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (31))){
var inst_64757 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64757)){
var statearr_64790_64839 = state_64778__$1;
(statearr_64790_64839[(1)] = (34));

} else {
var statearr_64791_64840 = state_64778__$1;
(statearr_64791_64840[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (32))){
var inst_64766 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64792_64841 = state_64778__$1;
(statearr_64792_64841[(2)] = inst_64766);

(statearr_64792_64841[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (33))){
var inst_64753 = (state_64778[(2)]);
var inst_64754 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64755 = figwheel.client.auto_jump_to_error.call(null,opts,inst_64754);
var state_64778__$1 = (function (){var statearr_64793 = state_64778;
(statearr_64793[(8)] = inst_64753);

return statearr_64793;
})();
var statearr_64794_64842 = state_64778__$1;
(statearr_64794_64842[(2)] = inst_64755);

(statearr_64794_64842[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (13))){
var inst_64712 = figwheel.client.heads_up.clear.call(null);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(16),inst_64712);
} else {
if((state_val_64779 === (22))){
var inst_64733 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64734 = figwheel.client.heads_up.append_warning_message.call(null,inst_64733);
var state_64778__$1 = state_64778;
var statearr_64795_64843 = state_64778__$1;
(statearr_64795_64843[(2)] = inst_64734);

(statearr_64795_64843[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (36))){
var inst_64764 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64796_64844 = state_64778__$1;
(statearr_64796_64844[(2)] = inst_64764);

(statearr_64796_64844[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (29))){
var inst_64744 = (state_64778[(2)]);
var inst_64745 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64746 = figwheel.client.auto_jump_to_error.call(null,opts,inst_64745);
var state_64778__$1 = (function (){var statearr_64797 = state_64778;
(statearr_64797[(9)] = inst_64744);

return statearr_64797;
})();
var statearr_64798_64845 = state_64778__$1;
(statearr_64798_64845[(2)] = inst_64746);

(statearr_64798_64845[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (6))){
var inst_64693 = (state_64778[(10)]);
var state_64778__$1 = state_64778;
var statearr_64799_64846 = state_64778__$1;
(statearr_64799_64846[(2)] = inst_64693);

(statearr_64799_64846[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (28))){
var inst_64740 = (state_64778[(2)]);
var inst_64741 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64742 = figwheel.client.heads_up.display_warning.call(null,inst_64741);
var state_64778__$1 = (function (){var statearr_64800 = state_64778;
(statearr_64800[(11)] = inst_64740);

return statearr_64800;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(29),inst_64742);
} else {
if((state_val_64779 === (25))){
var inst_64738 = figwheel.client.heads_up.clear.call(null);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(28),inst_64738);
} else {
if((state_val_64779 === (34))){
var inst_64759 = figwheel.client.heads_up.flash_loaded.call(null);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(37),inst_64759);
} else {
if((state_val_64779 === (17))){
var inst_64718 = (state_64778[(2)]);
var inst_64719 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64720 = figwheel.client.auto_jump_to_error.call(null,opts,inst_64719);
var state_64778__$1 = (function (){var statearr_64801 = state_64778;
(statearr_64801[(12)] = inst_64718);

return statearr_64801;
})();
var statearr_64802_64847 = state_64778__$1;
(statearr_64802_64847[(2)] = inst_64720);

(statearr_64802_64847[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (3))){
var inst_64710 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64710)){
var statearr_64803_64848 = state_64778__$1;
(statearr_64803_64848[(1)] = (13));

} else {
var statearr_64804_64849 = state_64778__$1;
(statearr_64804_64849[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (12))){
var inst_64706 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64805_64850 = state_64778__$1;
(statearr_64805_64850[(2)] = inst_64706);

(statearr_64805_64850[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (2))){
var inst_64693 = (state_64778[(10)]);
var inst_64693__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_64778__$1 = (function (){var statearr_64806 = state_64778;
(statearr_64806[(10)] = inst_64693__$1);

return statearr_64806;
})();
if(cljs.core.truth_(inst_64693__$1)){
var statearr_64807_64851 = state_64778__$1;
(statearr_64807_64851[(1)] = (5));

} else {
var statearr_64808_64852 = state_64778__$1;
(statearr_64808_64852[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (23))){
var inst_64736 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64736)){
var statearr_64809_64853 = state_64778__$1;
(statearr_64809_64853[(1)] = (25));

} else {
var statearr_64810_64854 = state_64778__$1;
(statearr_64810_64854[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (35))){
var state_64778__$1 = state_64778;
var statearr_64811_64855 = state_64778__$1;
(statearr_64811_64855[(2)] = null);

(statearr_64811_64855[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (19))){
var inst_64731 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64731)){
var statearr_64812_64856 = state_64778__$1;
(statearr_64812_64856[(1)] = (22));

} else {
var statearr_64813_64857 = state_64778__$1;
(statearr_64813_64857[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (11))){
var inst_64702 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64814_64858 = state_64778__$1;
(statearr_64814_64858[(2)] = inst_64702);

(statearr_64814_64858[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (9))){
var inst_64704 = figwheel.client.heads_up.clear.call(null);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(12),inst_64704);
} else {
if((state_val_64779 === (5))){
var inst_64695 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_64778__$1 = state_64778;
var statearr_64815_64859 = state_64778__$1;
(statearr_64815_64859[(2)] = inst_64695);

(statearr_64815_64859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (14))){
var inst_64722 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64722)){
var statearr_64816_64860 = state_64778__$1;
(statearr_64816_64860[(1)] = (18));

} else {
var statearr_64817_64861 = state_64778__$1;
(statearr_64817_64861[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (26))){
var inst_64748 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_64778__$1 = state_64778;
if(cljs.core.truth_(inst_64748)){
var statearr_64818_64862 = state_64778__$1;
(statearr_64818_64862[(1)] = (30));

} else {
var statearr_64819_64863 = state_64778__$1;
(statearr_64819_64863[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (16))){
var inst_64714 = (state_64778[(2)]);
var inst_64715 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64716 = figwheel.client.heads_up.display_exception.call(null,inst_64715);
var state_64778__$1 = (function (){var statearr_64820 = state_64778;
(statearr_64820[(13)] = inst_64714);

return statearr_64820;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(17),inst_64716);
} else {
if((state_val_64779 === (30))){
var inst_64750 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64751 = figwheel.client.heads_up.display_warning.call(null,inst_64750);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(33),inst_64751);
} else {
if((state_val_64779 === (10))){
var inst_64708 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64821_64864 = state_64778__$1;
(statearr_64821_64864[(2)] = inst_64708);

(statearr_64821_64864[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (18))){
var inst_64724 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_64725 = figwheel.client.heads_up.display_exception.call(null,inst_64724);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(21),inst_64725);
} else {
if((state_val_64779 === (37))){
var inst_64761 = (state_64778[(2)]);
var state_64778__$1 = state_64778;
var statearr_64822_64865 = state_64778__$1;
(statearr_64822_64865[(2)] = inst_64761);

(statearr_64822_64865[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64779 === (8))){
var inst_64700 = figwheel.client.heads_up.flash_loaded.call(null);
var state_64778__$1 = state_64778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64778__$1,(11),inst_64700);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__31349__auto__,c__31463__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____0 = (function (){
var statearr_64826 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64826[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__);

(statearr_64826[(1)] = (1));

return statearr_64826;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____1 = (function (state_64778){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_64778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e64827){if((e64827 instanceof Object)){
var ex__31353__auto__ = e64827;
var statearr_64828_64866 = state_64778;
(statearr_64828_64866[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64867 = state_64778;
state_64778 = G__64867;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__ = function(state_64778){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____1.call(this,state_64778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__,msg_hist,msg_names,msg))
})();
var state__31465__auto__ = (function (){var statearr_64829 = f__31464__auto__.call(null);
(statearr_64829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_64829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__,msg_hist,msg_names,msg))
);

return c__31463__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__31463__auto___64930 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___64930,ch){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___64930,ch){
return (function (state_64913){
var state_val_64914 = (state_64913[(1)]);
if((state_val_64914 === (1))){
var state_64913__$1 = state_64913;
var statearr_64915_64931 = state_64913__$1;
(statearr_64915_64931[(2)] = null);

(statearr_64915_64931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64914 === (2))){
var state_64913__$1 = state_64913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64913__$1,(4),ch);
} else {
if((state_val_64914 === (3))){
var inst_64911 = (state_64913[(2)]);
var state_64913__$1 = state_64913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64913__$1,inst_64911);
} else {
if((state_val_64914 === (4))){
var inst_64901 = (state_64913[(7)]);
var inst_64901__$1 = (state_64913[(2)]);
var state_64913__$1 = (function (){var statearr_64916 = state_64913;
(statearr_64916[(7)] = inst_64901__$1);

return statearr_64916;
})();
if(cljs.core.truth_(inst_64901__$1)){
var statearr_64917_64932 = state_64913__$1;
(statearr_64917_64932[(1)] = (5));

} else {
var statearr_64918_64933 = state_64913__$1;
(statearr_64918_64933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64914 === (5))){
var inst_64901 = (state_64913[(7)]);
var inst_64903 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_64901);
var state_64913__$1 = state_64913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64913__$1,(8),inst_64903);
} else {
if((state_val_64914 === (6))){
var state_64913__$1 = state_64913;
var statearr_64919_64934 = state_64913__$1;
(statearr_64919_64934[(2)] = null);

(statearr_64919_64934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64914 === (7))){
var inst_64909 = (state_64913[(2)]);
var state_64913__$1 = state_64913;
var statearr_64920_64935 = state_64913__$1;
(statearr_64920_64935[(2)] = inst_64909);

(statearr_64920_64935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64914 === (8))){
var inst_64905 = (state_64913[(2)]);
var state_64913__$1 = (function (){var statearr_64921 = state_64913;
(statearr_64921[(8)] = inst_64905);

return statearr_64921;
})();
var statearr_64922_64936 = state_64913__$1;
(statearr_64922_64936[(2)] = null);

(statearr_64922_64936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__31463__auto___64930,ch))
;
return ((function (switch__31349__auto__,c__31463__auto___64930,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__31350__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__31350__auto____0 = (function (){
var statearr_64926 = [null,null,null,null,null,null,null,null,null];
(statearr_64926[(0)] = figwheel$client$heads_up_plugin_$_state_machine__31350__auto__);

(statearr_64926[(1)] = (1));

return statearr_64926;
});
var figwheel$client$heads_up_plugin_$_state_machine__31350__auto____1 = (function (state_64913){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_64913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e64927){if((e64927 instanceof Object)){
var ex__31353__auto__ = e64927;
var statearr_64928_64937 = state_64913;
(statearr_64928_64937[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64913);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64938 = state_64913;
state_64913 = G__64938;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__31350__auto__ = function(state_64913){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__31350__auto____1.call(this,state_64913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__31350__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__31350__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___64930,ch))
})();
var state__31465__auto__ = (function (){var statearr_64929 = f__31464__auto__.call(null);
(statearr_64929[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___64930);

return statearr_64929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___64930,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_64959){
var state_val_64960 = (state_64959[(1)]);
if((state_val_64960 === (1))){
var inst_64954 = cljs.core.async.timeout.call(null,(3000));
var state_64959__$1 = state_64959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64959__$1,(2),inst_64954);
} else {
if((state_val_64960 === (2))){
var inst_64956 = (state_64959[(2)]);
var inst_64957 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_64959__$1 = (function (){var statearr_64961 = state_64959;
(statearr_64961[(7)] = inst_64956);

return statearr_64961;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64959__$1,inst_64957);
} else {
return null;
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____0 = (function (){
var statearr_64965 = [null,null,null,null,null,null,null,null];
(statearr_64965[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__);

(statearr_64965[(1)] = (1));

return statearr_64965;
});
var figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____1 = (function (state_64959){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_64959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e64966){if((e64966 instanceof Object)){
var ex__31353__auto__ = e64966;
var statearr_64967_64969 = state_64959;
(statearr_64967_64969[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64970 = state_64959;
state_64959 = G__64970;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__ = function(state_64959){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____1.call(this,state_64959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__31350__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_64968 = f__31464__auto__.call(null);
(statearr_64968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_64968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__,figwheel_version,temp__6753__auto__){
return (function (state_64993){
var state_val_64994 = (state_64993[(1)]);
if((state_val_64994 === (1))){
var inst_64987 = cljs.core.async.timeout.call(null,(2000));
var state_64993__$1 = state_64993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64993__$1,(2),inst_64987);
} else {
if((state_val_64994 === (2))){
var inst_64989 = (state_64993[(2)]);
var inst_64990 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_64991 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_64990);
var state_64993__$1 = (function (){var statearr_64995 = state_64993;
(statearr_64995[(7)] = inst_64989);

return statearr_64995;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64993__$1,inst_64991);
} else {
return null;
}
}
});})(c__31463__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____0 = (function (){
var statearr_64999 = [null,null,null,null,null,null,null,null];
(statearr_64999[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__);

(statearr_64999[(1)] = (1));

return statearr_64999;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____1 = (function (state_64993){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_64993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e65000){if((e65000 instanceof Object)){
var ex__31353__auto__ = e65000;
var statearr_65001_65003 = state_64993;
(statearr_65001_65003[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e65000;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65004 = state_64993;
state_64993 = G__65004;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__ = function(state_64993){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____1.call(this,state_64993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__,figwheel_version,temp__6753__auto__))
})();
var state__31465__auto__ = (function (){var statearr_65002 = f__31464__auto__.call(null);
(statearr_65002[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_65002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__,figwheel_version,temp__6753__auto__))
);

return c__31463__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__65005){
var map__65009 = p__65005;
var map__65009__$1 = ((((!((map__65009 == null)))?((((map__65009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65009):map__65009);
var file = cljs.core.get.call(null,map__65009__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__65009__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__65009__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__65011 = "";
var G__65011__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__65011),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__65011);
var G__65011__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__65011__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__65011__$1);
if(cljs.core.truth_((function (){var and__27623__auto__ = line;
if(cljs.core.truth_(and__27623__auto__)){
return column;
} else {
return and__27623__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__65011__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__65011__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__65012){
var map__65019 = p__65012;
var map__65019__$1 = ((((!((map__65019 == null)))?((((map__65019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65019.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65019):map__65019);
var ed = map__65019__$1;
var formatted_exception = cljs.core.get.call(null,map__65019__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__65019__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__65019__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__65021_65025 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__65022_65026 = null;
var count__65023_65027 = (0);
var i__65024_65028 = (0);
while(true){
if((i__65024_65028 < count__65023_65027)){
var msg_65029 = cljs.core._nth.call(null,chunk__65022_65026,i__65024_65028);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_65029);

var G__65030 = seq__65021_65025;
var G__65031 = chunk__65022_65026;
var G__65032 = count__65023_65027;
var G__65033 = (i__65024_65028 + (1));
seq__65021_65025 = G__65030;
chunk__65022_65026 = G__65031;
count__65023_65027 = G__65032;
i__65024_65028 = G__65033;
continue;
} else {
var temp__6753__auto___65034 = cljs.core.seq.call(null,seq__65021_65025);
if(temp__6753__auto___65034){
var seq__65021_65035__$1 = temp__6753__auto___65034;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65021_65035__$1)){
var c__28546__auto___65036 = cljs.core.chunk_first.call(null,seq__65021_65035__$1);
var G__65037 = cljs.core.chunk_rest.call(null,seq__65021_65035__$1);
var G__65038 = c__28546__auto___65036;
var G__65039 = cljs.core.count.call(null,c__28546__auto___65036);
var G__65040 = (0);
seq__65021_65025 = G__65037;
chunk__65022_65026 = G__65038;
count__65023_65027 = G__65039;
i__65024_65028 = G__65040;
continue;
} else {
var msg_65041 = cljs.core.first.call(null,seq__65021_65035__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_65041);

var G__65042 = cljs.core.next.call(null,seq__65021_65035__$1);
var G__65043 = null;
var G__65044 = (0);
var G__65045 = (0);
seq__65021_65025 = G__65042;
chunk__65022_65026 = G__65043;
count__65023_65027 = G__65044;
i__65024_65028 = G__65045;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__65046){
var map__65049 = p__65046;
var map__65049__$1 = ((((!((map__65049 == null)))?((((map__65049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65049.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65049):map__65049);
var w = map__65049__$1;
var message = cljs.core.get.call(null,map__65049__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/cards/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/cards/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27623__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27623__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27623__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__65061 = cljs.core.seq.call(null,plugins);
var chunk__65062 = null;
var count__65063 = (0);
var i__65064 = (0);
while(true){
if((i__65064 < count__65063)){
var vec__65065 = cljs.core._nth.call(null,chunk__65062,i__65064);
var k = cljs.core.nth.call(null,vec__65065,(0),null);
var plugin = cljs.core.nth.call(null,vec__65065,(1),null);
if(cljs.core.truth_(plugin)){
var pl_65071 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__65061,chunk__65062,count__65063,i__65064,pl_65071,vec__65065,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_65071.call(null,msg_hist);
});})(seq__65061,chunk__65062,count__65063,i__65064,pl_65071,vec__65065,k,plugin))
);
} else {
}

var G__65072 = seq__65061;
var G__65073 = chunk__65062;
var G__65074 = count__65063;
var G__65075 = (i__65064 + (1));
seq__65061 = G__65072;
chunk__65062 = G__65073;
count__65063 = G__65074;
i__65064 = G__65075;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__65061);
if(temp__6753__auto__){
var seq__65061__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65061__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__65061__$1);
var G__65076 = cljs.core.chunk_rest.call(null,seq__65061__$1);
var G__65077 = c__28546__auto__;
var G__65078 = cljs.core.count.call(null,c__28546__auto__);
var G__65079 = (0);
seq__65061 = G__65076;
chunk__65062 = G__65077;
count__65063 = G__65078;
i__65064 = G__65079;
continue;
} else {
var vec__65068 = cljs.core.first.call(null,seq__65061__$1);
var k = cljs.core.nth.call(null,vec__65068,(0),null);
var plugin = cljs.core.nth.call(null,vec__65068,(1),null);
if(cljs.core.truth_(plugin)){
var pl_65080 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__65061,chunk__65062,count__65063,i__65064,pl_65080,vec__65068,k,plugin,seq__65061__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_65080.call(null,msg_hist);
});})(seq__65061,chunk__65062,count__65063,i__65064,pl_65080,vec__65068,k,plugin,seq__65061__$1,temp__6753__auto__))
);
} else {
}

var G__65081 = cljs.core.next.call(null,seq__65061__$1);
var G__65082 = null;
var G__65083 = (0);
var G__65084 = (0);
seq__65061 = G__65081;
chunk__65062 = G__65082;
count__65063 = G__65083;
i__65064 = G__65084;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args65085 = [];
var len__28856__auto___65092 = arguments.length;
var i__28857__auto___65093 = (0);
while(true){
if((i__28857__auto___65093 < len__28856__auto___65092)){
args65085.push((arguments[i__28857__auto___65093]));

var G__65094 = (i__28857__auto___65093 + (1));
i__28857__auto___65093 = G__65094;
continue;
} else {
}
break;
}

var G__65087 = args65085.length;
switch (G__65087) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args65085.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__65088_65096 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__65089_65097 = null;
var count__65090_65098 = (0);
var i__65091_65099 = (0);
while(true){
if((i__65091_65099 < count__65090_65098)){
var msg_65100 = cljs.core._nth.call(null,chunk__65089_65097,i__65091_65099);
figwheel.client.socket.handle_incoming_message.call(null,msg_65100);

var G__65101 = seq__65088_65096;
var G__65102 = chunk__65089_65097;
var G__65103 = count__65090_65098;
var G__65104 = (i__65091_65099 + (1));
seq__65088_65096 = G__65101;
chunk__65089_65097 = G__65102;
count__65090_65098 = G__65103;
i__65091_65099 = G__65104;
continue;
} else {
var temp__6753__auto___65105 = cljs.core.seq.call(null,seq__65088_65096);
if(temp__6753__auto___65105){
var seq__65088_65106__$1 = temp__6753__auto___65105;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65088_65106__$1)){
var c__28546__auto___65107 = cljs.core.chunk_first.call(null,seq__65088_65106__$1);
var G__65108 = cljs.core.chunk_rest.call(null,seq__65088_65106__$1);
var G__65109 = c__28546__auto___65107;
var G__65110 = cljs.core.count.call(null,c__28546__auto___65107);
var G__65111 = (0);
seq__65088_65096 = G__65108;
chunk__65089_65097 = G__65109;
count__65090_65098 = G__65110;
i__65091_65099 = G__65111;
continue;
} else {
var msg_65112 = cljs.core.first.call(null,seq__65088_65106__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_65112);

var G__65113 = cljs.core.next.call(null,seq__65088_65106__$1);
var G__65114 = null;
var G__65115 = (0);
var G__65116 = (0);
seq__65088_65096 = G__65113;
chunk__65089_65097 = G__65114;
count__65090_65098 = G__65115;
i__65091_65099 = G__65116;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__28863__auto__ = [];
var len__28856__auto___65121 = arguments.length;
var i__28857__auto___65122 = (0);
while(true){
if((i__28857__auto___65122 < len__28856__auto___65121)){
args__28863__auto__.push((arguments[i__28857__auto___65122]));

var G__65123 = (i__28857__auto___65122 + (1));
i__28857__auto___65122 = G__65123;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__65118){
var map__65119 = p__65118;
var map__65119__$1 = ((((!((map__65119 == null)))?((((map__65119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65119.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65119):map__65119);
var opts = map__65119__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq65117){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65117));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e65125){if((e65125 instanceof Error)){
var e = e65125;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e65125;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__65129){
var map__65130 = p__65129;
var map__65130__$1 = ((((!((map__65130 == null)))?((((map__65130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65130):map__65130);
var msg_name = cljs.core.get.call(null,map__65130__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1486510900220