// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('om.next');
goog.require('untangled.client.impl.data_fetch');
goog.require('untangled.client.impl.util');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('untangled.i18n.core');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__56282,query){
var map__56285 = p__56282;
var map__56285__$1 = ((((!((map__56285 == null)))?((((map__56285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56285.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56285):map__56285);
var reconciler = cljs.core.get.call(null,map__56285__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__56285,map__56285__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__56285,map__56285__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_56302){
var state_val_56303 = (state_56302[(1)]);
if((state_val_56303 === (1))){
var state_56302__$1 = state_56302;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56302__$1,(2),q,v);
} else {
if((state_val_56303 === (2))){
var inst_56300 = (state_56302[(2)]);
var state_56302__$1 = state_56302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56302__$1,inst_56300);
} else {
return null;
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__31350__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__31350__auto____0 = (function (){
var statearr_56307 = [null,null,null,null,null,null,null];
(statearr_56307[(0)] = untangled$client$impl$application$enqueue_$_state_machine__31350__auto__);

(statearr_56307[(1)] = (1));

return statearr_56307;
});
var untangled$client$impl$application$enqueue_$_state_machine__31350__auto____1 = (function (state_56302){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_56302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e56308){if((e56308 instanceof Object)){
var ex__31353__auto__ = e56308;
var statearr_56309_56311 = state_56302;
(statearr_56309_56311[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56302);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56308;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56312 = state_56302;
state_56302 = G__56312;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__31350__auto__ = function(state_56302){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__31350__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__31350__auto____1.call(this,state_56302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__31350__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__31350__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_56310 = f__31464__auto__.call(null);
(statearr_56310[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_56310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__56314,remote_tx_map,cb){
var map__56317 = p__56314;
var map__56317__$1 = ((((!((map__56317 == null)))?((((map__56317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56317.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56317):map__56317);
var app = map__56317__$1;
var queue = cljs.core.get.call(null,map__56317__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__56317,map__56317__$1,app,queue){
return (function (p1__56313_SHARP_){
return fallback.call(null,p1__56313_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__56317,map__56317__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__56321){
var map__56332 = p__56321;
var map__56332__$1 = ((((!((map__56332 == null)))?((((map__56332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56332.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56332):map__56332);
var queue = cljs.core.get.call(null,map__56332__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__56332__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__56332__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__56334_56342 = cljs.core.seq.call(null,parallel_payload);
var chunk__56335_56343 = null;
var count__56336_56344 = (0);
var i__56337_56345 = (0);
while(true){
if((i__56337_56345 < count__56336_56344)){
var map__56338_56346 = cljs.core._nth.call(null,chunk__56335_56343,i__56337_56345);
var map__56338_56347__$1 = ((((!((map__56338_56346 == null)))?((((map__56338_56346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56338_56346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56338_56346):map__56338_56346);
var query_56348 = cljs.core.get.call(null,map__56338_56347__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_56349 = cljs.core.get.call(null,map__56338_56347__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_56350 = cljs.core.get.call(null,map__56338_56347__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_56351 = cljs.core.get.call(null,map__56338_56347__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__56352 = ((function (seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,map__56338_56346,map__56338_56347__$1,query_56348,on_load_56349,on_error_56350,callback_args_56351,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking){
return (function (p1__56319_SHARP_){
return on_load_56349.call(null,p1__56319_SHARP_,callback_args_56351);
});})(seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,map__56338_56346,map__56338_56347__$1,query_56348,on_load_56349,on_error_56350,callback_args_56351,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__56353 = ((function (seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,on_load_SINGLEQUOTE__56352,map__56338_56346,map__56338_56347__$1,query_56348,on_load_56349,on_error_56350,callback_args_56351,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking){
return (function (p1__56320_SHARP_){
return on_error_56350.call(null,p1__56320_SHARP_,callback_args_56351);
});})(seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,on_load_SINGLEQUOTE__56352,map__56338_56346,map__56338_56347__$1,query_56348,on_load_56349,on_error_56350,callback_args_56351,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_56348,on_load_SINGLEQUOTE__56352,on_error_SINGLEQUOTE__56353);

var G__56354 = seq__56334_56342;
var G__56355 = chunk__56335_56343;
var G__56356 = count__56336_56344;
var G__56357 = (i__56337_56345 + (1));
seq__56334_56342 = G__56354;
chunk__56335_56343 = G__56355;
count__56336_56344 = G__56356;
i__56337_56345 = G__56357;
continue;
} else {
var temp__6753__auto___56358 = cljs.core.seq.call(null,seq__56334_56342);
if(temp__6753__auto___56358){
var seq__56334_56359__$1 = temp__6753__auto___56358;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56334_56359__$1)){
var c__28546__auto___56360 = cljs.core.chunk_first.call(null,seq__56334_56359__$1);
var G__56361 = cljs.core.chunk_rest.call(null,seq__56334_56359__$1);
var G__56362 = c__28546__auto___56360;
var G__56363 = cljs.core.count.call(null,c__28546__auto___56360);
var G__56364 = (0);
seq__56334_56342 = G__56361;
chunk__56335_56343 = G__56362;
count__56336_56344 = G__56363;
i__56337_56345 = G__56364;
continue;
} else {
var map__56340_56365 = cljs.core.first.call(null,seq__56334_56359__$1);
var map__56340_56366__$1 = ((((!((map__56340_56365 == null)))?((((map__56340_56365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56340_56365.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56340_56365):map__56340_56365);
var query_56367 = cljs.core.get.call(null,map__56340_56366__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_56368 = cljs.core.get.call(null,map__56340_56366__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_56369 = cljs.core.get.call(null,map__56340_56366__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_56370 = cljs.core.get.call(null,map__56340_56366__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__56371 = ((function (seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,map__56340_56365,map__56340_56366__$1,query_56367,on_load_56368,on_error_56369,callback_args_56370,seq__56334_56359__$1,temp__6753__auto___56358,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking){
return (function (p1__56319_SHARP_){
return on_load_56368.call(null,p1__56319_SHARP_,callback_args_56370);
});})(seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,map__56340_56365,map__56340_56366__$1,query_56367,on_load_56368,on_error_56369,callback_args_56370,seq__56334_56359__$1,temp__6753__auto___56358,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__56372 = ((function (seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,on_load_SINGLEQUOTE__56371,map__56340_56365,map__56340_56366__$1,query_56367,on_load_56368,on_error_56369,callback_args_56370,seq__56334_56359__$1,temp__6753__auto___56358,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking){
return (function (p1__56320_SHARP_){
return on_error_56369.call(null,p1__56320_SHARP_,callback_args_56370);
});})(seq__56334_56342,chunk__56335_56343,count__56336_56344,i__56337_56345,on_load_SINGLEQUOTE__56371,map__56340_56365,map__56340_56366__$1,query_56367,on_load_56368,on_error_56369,callback_args_56370,seq__56334_56359__$1,temp__6753__auto___56358,parallel_payload,map__56332,map__56332__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_56367,on_load_SINGLEQUOTE__56371,on_error_SINGLEQUOTE__56372);

var G__56373 = cljs.core.next.call(null,seq__56334_56359__$1);
var G__56374 = null;
var G__56375 = (0);
var G__56376 = (0);
seq__56334_56342 = G__56373;
chunk__56335_56343 = G__56374;
count__56336_56344 = G__56375;
i__56337_56345 = G__56376;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__56377 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__56377;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__56378){
var map__56497 = p__56378;
var map__56497__$1 = ((((!((map__56497 == null)))?((((map__56497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56497.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56497):map__56497);
var networking = cljs.core.get.call(null,map__56497__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__56497__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__56497__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__56497,map__56497__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__56497,map__56497__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__31463__auto___56615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel){
return (function (state_56538){
var state_val_56539 = (state_56538[(1)]);
if((state_val_56539 === (1))){
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56538__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_56539 === (2))){
var inst_56536 = (state_56538[(2)]);
var state_56538__$1 = state_56538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56538__$1,inst_56536);
} else {
return null;
}
}
});})(c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel))
;
return ((function (switch__31349__auto__,c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____0 = (function (){
var statearr_56543 = [null,null,null,null,null,null,null];
(statearr_56543[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__);

(statearr_56543[(1)] = (1));

return statearr_56543;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____1 = (function (state_56538){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_56538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e56544){if((e56544 instanceof Object)){
var ex__31353__auto__ = e56544;
var statearr_56545_56616 = state_56538;
(statearr_56545_56616[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56538);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56544;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56617 = state_56538;
state_56538 = G__56617;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__ = function(state_56538){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____1.call(this,state_56538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel))
})();
var state__31465__auto__ = (function (){var statearr_56546 = f__31464__auto__.call(null);
(statearr_56546[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___56615);

return statearr_56546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___56615,map__56497,map__56497__$1,networking,queue,response_channel))
);

}});
;})(map__56497,map__56497__$1,networking,queue,response_channel))
});})(map__56497,map__56497__$1,networking,queue,response_channel))
;
var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel){
return (function (state_56588){
var state_val_56589 = (state_56588[(1)]);
if((state_val_56589 === (7))){
var inst_56567 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56567)){
var statearr_56590_56618 = state_56588__$1;
(statearr_56590_56618[(1)] = (11));

} else {
var statearr_56591_56619 = state_56588__$1;
(statearr_56591_56619[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (1))){
var state_56588__$1 = state_56588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56588__$1,(2),queue);
} else {
if((state_val_56589 === (4))){
var inst_56586 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56588__$1,inst_56586);
} else {
if((state_val_56589 === (15))){
var inst_56583 = (state_56588[(2)]);
var inst_56549 = inst_56583;
var state_56588__$1 = (function (){var statearr_56592 = state_56588;
(statearr_56592[(7)] = inst_56549);

return statearr_56592;
})();
var statearr_56593_56620 = state_56588__$1;
(statearr_56593_56620[(2)] = null);

(statearr_56593_56620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (13))){
var inst_56572 = (state_56588[(2)]);
var inst_56573 = cljs.core.get.call(null,inst_56572,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_56574 = cljs.core.get.call(null,inst_56572,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_56575 = cljs.core.get.call(null,inst_56572,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_56576 = cljs.core.get.call(null,inst_56572,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_56577 = make_process_response.call(null,inst_56574,inst_56576);
var inst_56578 = make_process_response.call(null,inst_56575,inst_56576);
var inst_56579 = untangled.client.impl.application.real_send.call(null,networking,inst_56573,inst_56577,inst_56578);
var state_56588__$1 = (function (){var statearr_56594 = state_56588;
(statearr_56594[(8)] = inst_56579);

return statearr_56594;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56588__$1,(14),response_channel);
} else {
if((state_val_56589 === (6))){
var state_56588__$1 = state_56588;
var statearr_56595_56621 = state_56588__$1;
(statearr_56595_56621[(2)] = false);

(statearr_56595_56621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (3))){
var inst_56549 = (state_56588[(7)]);
var inst_56553 = (inst_56549 == null);
var inst_56554 = cljs.core.not.call(null,inst_56553);
var state_56588__$1 = state_56588;
if(inst_56554){
var statearr_56596_56622 = state_56588__$1;
(statearr_56596_56622[(1)] = (5));

} else {
var statearr_56597_56623 = state_56588__$1;
(statearr_56597_56623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (12))){
var inst_56549 = (state_56588[(7)]);
var state_56588__$1 = state_56588;
var statearr_56598_56624 = state_56588__$1;
(statearr_56598_56624[(2)] = inst_56549);

(statearr_56598_56624[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (2))){
var inst_56548 = (state_56588[(2)]);
var inst_56549 = inst_56548;
var state_56588__$1 = (function (){var statearr_56599 = state_56588;
(statearr_56599[(7)] = inst_56549);

return statearr_56599;
})();
var statearr_56600_56625 = state_56588__$1;
(statearr_56600_56625[(2)] = null);

(statearr_56600_56625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (11))){
var inst_56549 = (state_56588[(7)]);
var inst_56569 = cljs.core.apply.call(null,cljs.core.hash_map,inst_56549);
var state_56588__$1 = state_56588;
var statearr_56601_56626 = state_56588__$1;
(statearr_56601_56626[(2)] = inst_56569);

(statearr_56601_56626[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (9))){
var state_56588__$1 = state_56588;
var statearr_56602_56627 = state_56588__$1;
(statearr_56602_56627[(2)] = false);

(statearr_56602_56627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (5))){
var inst_56549 = (state_56588[(7)]);
var inst_56556 = inst_56549.cljs$lang$protocol_mask$partition0$;
var inst_56557 = (inst_56556 & (64));
var inst_56558 = inst_56549.cljs$core$ISeq$;
var inst_56559 = (cljs.core.PROTOCOL_SENTINEL === inst_56558);
var inst_56560 = (inst_56557) || (inst_56559);
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56560)){
var statearr_56603_56628 = state_56588__$1;
(statearr_56603_56628[(1)] = (8));

} else {
var statearr_56604_56629 = state_56588__$1;
(statearr_56604_56629[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (14))){
var inst_56581 = (state_56588[(2)]);
var state_56588__$1 = (function (){var statearr_56605 = state_56588;
(statearr_56605[(9)] = inst_56581);

return statearr_56605;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56588__$1,(15),queue);
} else {
if((state_val_56589 === (10))){
var inst_56564 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56606_56630 = state_56588__$1;
(statearr_56606_56630[(2)] = inst_56564);

(statearr_56606_56630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (8))){
var state_56588__$1 = state_56588;
var statearr_56607_56631 = state_56588__$1;
(statearr_56607_56631[(2)] = true);

(statearr_56607_56631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel))
;
return ((function (switch__31349__auto__,c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____0 = (function (){
var statearr_56611 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56611[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__);

(statearr_56611[(1)] = (1));

return statearr_56611;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____1 = (function (state_56588){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_56588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e56612){if((e56612 instanceof Object)){
var ex__31353__auto__ = e56612;
var statearr_56613_56632 = state_56588;
(statearr_56613_56632[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56633 = state_56588;
state_56588 = G__56633;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__ = function(state_56588){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____1.call(this,state_56588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel))
})();
var state__31465__auto__ = (function (){var statearr_56614 = f__31464__auto__.call(null);
(statearr_56614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_56614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__,map__56497,map__56497__$1,networking,queue,response_channel))
);

return c__31463__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__56638){
var vec__56639 = p__56638;
var k = cljs.core.nth.call(null,vec__56639,(0),null);
var v = cljs.core.nth.call(null,vec__56639,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__56646){
var vec__56647 = p__56646;
var k = cljs.core.nth.call(null,vec__56647,(0),null);
var v = cljs.core.nth.call(null,vec__56647,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__56654){
var vec__56655 = p__56654;
var k = cljs.core.nth.call(null,vec__56655,(0),null);
var v = cljs.core.nth.call(null,vec__56655,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__56666){
var vec__56667 = p__56666;
var k = cljs.core.nth.call(null,vec__56667,(0),null);
var _ = cljs.core.nth.call(null,vec__56667,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__56670){
var vec__56671 = p__56670;
var k = cljs.core.nth.call(null,vec__56671,(0),null);
var v = cljs.core.nth.call(null,vec__56671,(1),null);
if(cljs.core.truth_((function (){var and__27623__auto__ = mutation_merge;
if(cljs.core.truth_(and__27623__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__27623__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__56674,initial_state,parser,p__56675){
var map__56680 = p__56674;
var map__56680__$1 = ((((!((map__56680 == null)))?((((map__56680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56680.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56680):map__56680);
var app = map__56680__$1;
var queue = cljs.core.get.call(null,map__56680__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__56680__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__56681 = p__56675;
var map__56681__$1 = ((((!((map__56681 == null)))?((((map__56681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56681.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56681):map__56681);
var pathopt = cljs.core.get.call(null,map__56681__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__56681__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__56681__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__27635__auto__ = migrate;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = (cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,initial_state))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__27635__auto__ = migrate;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__56680,map__56680__$1,app,queue,mutation_merge,map__56681,map__56681__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__56684_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__56684_SHARP_)){
return cljs.core.partial.call(null,p1__56684_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1486703216752