// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.protocol_support');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('untangled_spec.core');
goog.require('om.next');
goog.require('untangled.client.impl.om_plumbing');
goog.require('om.tempid');
goog.require('untangled.client.impl.protocol_support');
/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to the optimistic update for transactions going to the server
 *   `ui-tx`: the om transaction that modifies the app state prior to receiving a server response
 *   `optimistic-delta`: the expected changes to the app state after executing ui-tx. See Protocol Testing README for how
 *   to build this properly.
 */
untangled.client.protocol_support.check_optimistic_update = (function untangled$client$protocol_support$check_optimistic_update(var_args){
var args__28863__auto__ = [];
var len__28856__auto___57164 = arguments.length;
var i__28857__auto___57165 = (0);
while(true){
if((i__28857__auto___57165 < len__28856__auto___57164)){
args__28863__auto__.push((arguments[i__28857__auto___57165]));

var G__57166 = (i__28857__auto___57165 + (1));
i__28857__auto___57165 = G__57166;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic = (function (p__57156,p__57157){
var map__57158 = p__57156;
var map__57158__$1 = ((((!((map__57158 == null)))?((((map__57158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57158.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57158):map__57158);
var data = map__57158__$1;
var initial_ui_state = cljs.core.get.call(null,map__57158__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__57158__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var optimistic_delta = cljs.core.get.call(null,map__57158__$1,new cljs.core.Keyword(null,"optimistic-delta","optimistic-delta",-2118700684));
var map__57159 = p__57157;
var map__57159__$1 = ((((!((map__57159 == null)))?((((map__57159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57159.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57159):map__57159);
var env = cljs.core.get.call(null,map__57159__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("state not allowed in the env argument"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(not (:state env))")].join('')));
}

cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Optimistic Updates");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));

var map__57162_57167 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__57162_57168__$1 = ((((!((map__57162_57167 == null)))?((((map__57162_57167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57162_57167.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57162_57167):map__57162_57167);
var parser_57169 = cljs.core.get.call(null,map__57162_57168__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_57170 = cljs.core.atom.call(null,initial_ui_state);
var parse_57171 = cljs.core.partial.call(null,parser_57169,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_57170], null),env));
var tempid_map_57172 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_57173__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_57172);
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"trigger correct state transitions");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));

parse_57171.call(null,ui_tx_57173__$1);

untangled.client.impl.protocol_support.check_delta.call(null,untangled.client.impl.protocol_support.rewrite_tempids.call(null,cljs.core.deref.call(null,state_57170),clojure.set.map_invert.call(null,tempid_map_57172),om.tempid.tempid_QMARK_),optimistic_delta);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"trigger correct state transitions"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Optimistic Updates"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_optimistic_update.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_optimistic_update.cljs$lang$applyTo = (function (seq57154){
var G__57155 = cljs.core.first.call(null,seq57154);
var seq57154__$1 = cljs.core.next.call(null,seq57154);
return untangled.client.protocol_support.check_optimistic_update.cljs$core$IFn$_invoke$arity$variadic(G__57155,seq57154__$1);
});

/**
 * Takes a map containing:
 *   `initial-ui-state`: denormalized app state prior to sending the server transaction
 *   `ui-tx`: the om transaction that modifies the app state locally
 *   `server-tx`: the server transaction corresponding to ui-tx
 */
untangled.client.protocol_support.check_server_tx = (function untangled$client$protocol_support$check_server_tx(var_args){
var args__28863__auto__ = [];
var len__28856__auto___57185 = arguments.length;
var i__28857__auto___57186 = (0);
while(true){
if((i__28857__auto___57186 < len__28856__auto___57185)){
args__28863__auto__.push((arguments[i__28857__auto___57186]));

var G__57187 = (i__28857__auto___57186 + (1));
i__28857__auto___57186 = G__57187;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic = (function (p__57176,p__57177){
var map__57178 = p__57176;
var map__57178__$1 = ((((!((map__57178 == null)))?((((map__57178.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57178.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57178):map__57178);
var initial_ui_state = cljs.core.get.call(null,map__57178__$1,new cljs.core.Keyword(null,"initial-ui-state","initial-ui-state",-1367689122));
var ui_tx = cljs.core.get.call(null,map__57178__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var server_tx = cljs.core.get.call(null,map__57178__$1,new cljs.core.Keyword(null,"server-tx","server-tx",-1146708246));
var map__57179 = p__57177;
var map__57179__$1 = ((((!((map__57179 == null)))?((((map__57179.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57179.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57179):map__57179);
var env = cljs.core.get.call(null,map__57179__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Client Remoting");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));

var map__57182_57188 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__57182_57189__$1 = ((((!((map__57182_57188 == null)))?((((map__57182_57188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57182_57188.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57182_57188):map__57182_57188);
var parser_57190 = cljs.core.get.call(null,map__57182_57189__$1,new cljs.core.Keyword(null,"parser","parser",-1543495310));
var state_57191 = cljs.core.atom.call(null,initial_ui_state);
var parse_57192 = cljs.core.partial.call(null,parser_57190,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),state_57191], null),env));
var tempid_map_57193 = untangled.client.impl.protocol_support.allocate_tempids.call(null,ui_tx);
var ui_tx_57194__$1 = untangled.client.impl.protocol_support.rewrite_tempids.call(null,ui_tx,tempid_map_57193);
parse_57192.call(null,ui_tx_57194__$1);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

try{cljs.test.do_report.call(null,(function (){var act__47874__auto__ = untangled.client.impl.protocol_support.rewrite_tempids.call(null,untangled.client.impl.om_plumbing.strip_ui.call(null,untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,parse_57192.call(null,ui_tx_57194__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576)))),clojure.set.map_invert.call(null,tempid_map_57193),om.tempid.tempid_QMARK_);
var exp__47875__auto__ = server_tx;
var result__47876__auto__ = cljs.core._EQ_.call(null,exp__47875__auto__,act__47874__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__47876__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__47875__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__47874__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null);
})());
}catch (e57184){var t__40051__auto___57195 = e57184;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"server-tx","server-tx",493823281,null),cljs.core.list(new cljs.core.Symbol(null,"->","->",-2139605430,null),cljs.core.list(new cljs.core.Symbol(null,"parse","parse",478366908,null),new cljs.core.Symbol(null,"ui-tx","ui-tx",62864806,null),new cljs.core.Keyword(null,"remote","remote",-1593576576)),new cljs.core.Symbol("plumbing","remove-loads-and-fallbacks","plumbing/remove-loads-and-fallbacks",-474759113,null),new cljs.core.Symbol("plumbing","strip-ui","plumbing/strip-ui",-2004815259,null),cljs.core.list(new cljs.core.Symbol("impl","rewrite-tempids","impl/rewrite-tempids",-1005245316,null),cljs.core.list(new cljs.core.Symbol("set","map-invert","set/map-invert",1259038818,null),new cljs.core.Symbol(null,"tempid-map","tempid-map",-1148551297,null)),new cljs.core.Symbol("omt","tempid?","omt/tempid?",2034821487,null)))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57195,new cljs.core.Keyword(null,"message","message",-406056002),"(-> (parse ui-tx :remote) plumbing/remove-loads-and-fallbacks plumbing/strip-ui (impl/rewrite-tempids (set/map-invert tempid-map) omt/tempid?)) => server-tx"], null));
}
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Generates the expected server query"], null));

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Client Remoting"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

untangled.client.protocol_support.check_server_tx.cljs$lang$maxFixedArity = (1);

untangled.client.protocol_support.check_server_tx.cljs$lang$applyTo = (function (seq57174){
var G__57175 = cljs.core.first.call(null,seq57174);
var seq57174__$1 = cljs.core.next.call(null,seq57174);
return untangled.client.protocol_support.check_server_tx.cljs$core$IFn$_invoke$arity$variadic(G__57175,seq57174__$1);
});

/**
 * Takes a map containing:
 *   `response`: the exact data the server sends back to the client
 *   `pre-response-state`: normalized state prior to receiving `response`
 *   `server-tx`: the transaction originally sent to the server, yielding `response`
 *   `merge-delta`: the delta between `pre-response-state` and its integration with `response`
 */
untangled.client.protocol_support.check_response_from_server = (function untangled$client$protocol_support$check_response_from_server(p__57196){
var map__57202 = p__57196;
var map__57202__$1 = ((((!((map__57202 == null)))?((((map__57202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57202.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57202):map__57202);
var response = cljs.core.get.call(null,map__57202__$1,new cljs.core.Keyword(null,"response","response",-1068424192));
var pre_response_state = cljs.core.get.call(null,map__57202__$1,new cljs.core.Keyword(null,"pre-response-state","pre-response-state",696272294));
var ui_tx = cljs.core.get.call(null,map__57202__$1,new cljs.core.Keyword(null,"ui-tx","ui-tx",-1577666721));
var merge_delta = cljs.core.get.call(null,map__57202__$1,new cljs.core.Keyword(null,"merge-delta","merge-delta",-1454035297));
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"Server response merged with app state");

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));

var map__57204_57207 = untangled.client.impl.protocol_support.init_testing.call(null);
var map__57204_57208__$1 = ((((!((map__57204_57207 == null)))?((((map__57204_57207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57204_57207.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57204_57207):map__57204_57207);
var reconciler_57209 = cljs.core.get.call(null,map__57204_57208__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state_57210 = om.next.app_state.call(null,reconciler_57209);
cljs.core.reset_BANG_.call(null,state_57210,pre_response_state);

om.next.merge_BANG_.call(null,reconciler_57209,response,ui_tx);

if(cljs.core.truth_(merge_delta)){
untangled.client.impl.protocol_support.check_delta.call(null,cljs.core.deref.call(null,state_57210),merge_delta);
} else {
try{cljs.test.do_report.call(null,(function (){var act__47874__auto__ = cljs.core.deref.call(null,state_57210);
var exp__47875__auto__ = pre_response_state;
var result__47876__auto__ = cljs.core._EQ_.call(null,exp__47875__auto__,act__47874__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__47876__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__47875__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__47874__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null);
})());
}catch (e57206){var t__40051__auto___57211 = e57206;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"pre-response-state","pre-response-state",-1958163475,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"state","state",-348086572,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57211,new cljs.core.Keyword(null,"message","message",-406056002),"(clojure.core/deref state) => pre-response-state"], null));
}}

return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),"Server response merged with app state"], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});
untangled.client.protocol_support.with_behavior = untangled.client.impl.protocol_support.with_behavior;

//# sourceMappingURL=protocol_support.js.map?rel=1486703217637