// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.openid_client');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('goog.net.Cookies');
untangled.openid_client.params = (function untangled$openid_client$params(){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.rest.call(null,window.location.hash));
});
untangled.openid_client.get_tokens_from_cookies = (function untangled$openid_client$get_tokens_from_cookies(){
var cookies = (new goog.net.Cookies(document));
var cookie_keys = cookies.getKeys();
return cljs.core.reduce.call(null,((function (cookies,cookie_keys){
return (function (p1__76731_SHARP_,p2__76732_SHARP_){
return cljs.core.assoc.call(null,p1__76731_SHARP_,p2__76732_SHARP_,cookies.get(p2__76732_SHARP_));
});})(cookies,cookie_keys))
,cljs.core.PersistentArrayMap.EMPTY,cookie_keys);
});
untangled.openid_client.tokens_from_params = (function untangled$openid_client$tokens_from_params(params){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,(function (v){
var pairs = clojure.string.split.call(null,v,/=/);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.first.call(null,pairs),cljs.core.second.call(null,pairs)]);
}),clojure.string.split.call(null,params,/&/)));
});
untangled.openid_client.parse_claims = (function untangled$openid_client$parse_claims(token){
var G__76734 = token;
var G__76734__$1 = (((G__76734 == null))?null:clojure.string.split.call(null,G__76734,/\./));
var G__76734__$2 = (((G__76734__$1 == null))?null:cljs.core.second.call(null,G__76734__$1));
var G__76734__$3 = (((G__76734__$2 == null))?null:atob(G__76734__$2));
if((G__76734__$3 == null)){
return null;
} else {
return JSON.parse(G__76734__$3);
}
});
/**
 * Adds an Authorization header for each request based on the claims in the cookies or the url's hash fragments
 */
untangled.openid_client.add_auth_header = (function untangled$openid_client$add_auth_header(req){
var access_token = cljs.core.get.call(null,(function (){var or__27635__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
}
})(),"access_token");
return cljs.core.assoc_in.call(null,req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(access_token)].join(''));
});
/**
 * Installs openid information into the passed in untangled-client app's initial state,
 *   based on the token claims in the cookies or the url's hash fragments.
 */
untangled.openid_client.install_state_BANG_ = (function untangled$openid_client$install_state_BANG_(var_args){
var args__28863__auto__ = [];
var len__28856__auto___76741 = arguments.length;
var i__28857__auto___76742 = (0);
while(true){
if((i__28857__auto___76742 < len__28856__auto___76741)){
args__28863__auto__.push((arguments[i__28857__auto___76742]));

var G__76743 = (i__28857__auto___76742 + (1));
i__28857__auto___76742 = G__76743;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (reconciler,p__76737){
var map__76738 = p__76737;
var map__76738__$1 = ((((!((map__76738 == null)))?((((map__76738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76738.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__76738):map__76738);
var custom_state_fn = cljs.core.get.call(null,map__76738__$1,new cljs.core.Keyword(null,"custom-state-fn","custom-state-fn",1049325348),cljs.core.constantly.call(null,cljs.core.PersistentArrayMap.EMPTY));
var hash_tokens = untangled.openid_client.tokens_from_params.call(null,untangled.openid_client.params.call(null));
var tokens = (function (){var or__27635__auto__ = untangled.openid_client.get_tokens_from_cookies.call(null);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return hash_tokens;
}
})();
var id_claims = (function (){var G__76740 = tokens;
var G__76740__$1 = (((G__76740 == null))?null:cljs.core.get.call(null,G__76740,"id_token"));
var G__76740__$2 = (((G__76740__$1 == null))?null:untangled.openid_client.parse_claims.call(null,G__76740__$1));
var G__76740__$3 = (((G__76740__$2 == null))?null:cljs.core.js__GT_clj.call(null,G__76740__$2));
if((G__76740__$3 == null)){
return null;
} else {
return clojure.walk.keywordize_keys.call(null,G__76740__$3);
}
})();
if(cljs.core._EQ_.call(null,tokens,hash_tokens)){
(window.location["hash"] = "");
} else {
}

return cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.merge,cljs.core.merge.call(null,custom_state_fn.call(null,id_claims),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("openid","claims","openid/claims",498347492),id_claims,new cljs.core.Keyword("openid","access-token","openid/access-token",390035886),cljs.core.get.call(null,tokens,"access_token")], null)));
});

untangled.openid_client.install_state_BANG_.cljs$lang$maxFixedArity = (1);

untangled.openid_client.install_state_BANG_.cljs$lang$applyTo = (function (seq76735){
var G__76736 = cljs.core.first.call(null,seq76735);
var seq76735__$1 = cljs.core.next.call(null,seq76735);
return untangled.openid_client.install_state_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__76736,seq76735__$1);
});


//# sourceMappingURL=openid_client.js.map?rel=1486510919374