// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27635__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27635__auto__){
return or__27635__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27635__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__61727_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__61727_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__61732 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__61733 = null;
var count__61734 = (0);
var i__61735 = (0);
while(true){
if((i__61735 < count__61734)){
var n = cljs.core._nth.call(null,chunk__61733,i__61735);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__61736 = seq__61732;
var G__61737 = chunk__61733;
var G__61738 = count__61734;
var G__61739 = (i__61735 + (1));
seq__61732 = G__61736;
chunk__61733 = G__61737;
count__61734 = G__61738;
i__61735 = G__61739;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__61732);
if(temp__6753__auto__){
var seq__61732__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61732__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__61732__$1);
var G__61740 = cljs.core.chunk_rest.call(null,seq__61732__$1);
var G__61741 = c__28546__auto__;
var G__61742 = cljs.core.count.call(null,c__28546__auto__);
var G__61743 = (0);
seq__61732 = G__61740;
chunk__61733 = G__61741;
count__61734 = G__61742;
i__61735 = G__61743;
continue;
} else {
var n = cljs.core.first.call(null,seq__61732__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__61744 = cljs.core.next.call(null,seq__61732__$1);
var G__61745 = null;
var G__61746 = (0);
var G__61747 = (0);
seq__61732 = G__61744;
chunk__61733 = G__61745;
count__61734 = G__61746;
i__61735 = G__61747;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__61798_61809 = cljs.core.seq.call(null,deps);
var chunk__61799_61810 = null;
var count__61800_61811 = (0);
var i__61801_61812 = (0);
while(true){
if((i__61801_61812 < count__61800_61811)){
var dep_61813 = cljs.core._nth.call(null,chunk__61799_61810,i__61801_61812);
topo_sort_helper_STAR_.call(null,dep_61813,(depth + (1)),state);

var G__61814 = seq__61798_61809;
var G__61815 = chunk__61799_61810;
var G__61816 = count__61800_61811;
var G__61817 = (i__61801_61812 + (1));
seq__61798_61809 = G__61814;
chunk__61799_61810 = G__61815;
count__61800_61811 = G__61816;
i__61801_61812 = G__61817;
continue;
} else {
var temp__6753__auto___61818 = cljs.core.seq.call(null,seq__61798_61809);
if(temp__6753__auto___61818){
var seq__61798_61819__$1 = temp__6753__auto___61818;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61798_61819__$1)){
var c__28546__auto___61820 = cljs.core.chunk_first.call(null,seq__61798_61819__$1);
var G__61821 = cljs.core.chunk_rest.call(null,seq__61798_61819__$1);
var G__61822 = c__28546__auto___61820;
var G__61823 = cljs.core.count.call(null,c__28546__auto___61820);
var G__61824 = (0);
seq__61798_61809 = G__61821;
chunk__61799_61810 = G__61822;
count__61800_61811 = G__61823;
i__61801_61812 = G__61824;
continue;
} else {
var dep_61825 = cljs.core.first.call(null,seq__61798_61819__$1);
topo_sort_helper_STAR_.call(null,dep_61825,(depth + (1)),state);

var G__61826 = cljs.core.next.call(null,seq__61798_61819__$1);
var G__61827 = null;
var G__61828 = (0);
var G__61829 = (0);
seq__61798_61809 = G__61826;
chunk__61799_61810 = G__61827;
count__61800_61811 = G__61828;
i__61801_61812 = G__61829;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__61802){
var vec__61806 = p__61802;
var seq__61807 = cljs.core.seq.call(null,vec__61806);
var first__61808 = cljs.core.first.call(null,seq__61807);
var seq__61807__$1 = cljs.core.next.call(null,seq__61807);
var x = first__61808;
var xs = seq__61807__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__61806,seq__61807,first__61808,seq__61807__$1,x,xs,get_deps__$1){
return (function (p1__61748_SHARP_){
return clojure.set.difference.call(null,p1__61748_SHARP_,x);
});})(vec__61806,seq__61807,first__61808,seq__61807__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__61842 = cljs.core.seq.call(null,provides);
var chunk__61843 = null;
var count__61844 = (0);
var i__61845 = (0);
while(true){
if((i__61845 < count__61844)){
var prov = cljs.core._nth.call(null,chunk__61843,i__61845);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__61846_61854 = cljs.core.seq.call(null,requires);
var chunk__61847_61855 = null;
var count__61848_61856 = (0);
var i__61849_61857 = (0);
while(true){
if((i__61849_61857 < count__61848_61856)){
var req_61858 = cljs.core._nth.call(null,chunk__61847_61855,i__61849_61857);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_61858,prov);

var G__61859 = seq__61846_61854;
var G__61860 = chunk__61847_61855;
var G__61861 = count__61848_61856;
var G__61862 = (i__61849_61857 + (1));
seq__61846_61854 = G__61859;
chunk__61847_61855 = G__61860;
count__61848_61856 = G__61861;
i__61849_61857 = G__61862;
continue;
} else {
var temp__6753__auto___61863 = cljs.core.seq.call(null,seq__61846_61854);
if(temp__6753__auto___61863){
var seq__61846_61864__$1 = temp__6753__auto___61863;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61846_61864__$1)){
var c__28546__auto___61865 = cljs.core.chunk_first.call(null,seq__61846_61864__$1);
var G__61866 = cljs.core.chunk_rest.call(null,seq__61846_61864__$1);
var G__61867 = c__28546__auto___61865;
var G__61868 = cljs.core.count.call(null,c__28546__auto___61865);
var G__61869 = (0);
seq__61846_61854 = G__61866;
chunk__61847_61855 = G__61867;
count__61848_61856 = G__61868;
i__61849_61857 = G__61869;
continue;
} else {
var req_61870 = cljs.core.first.call(null,seq__61846_61864__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_61870,prov);

var G__61871 = cljs.core.next.call(null,seq__61846_61864__$1);
var G__61872 = null;
var G__61873 = (0);
var G__61874 = (0);
seq__61846_61854 = G__61871;
chunk__61847_61855 = G__61872;
count__61848_61856 = G__61873;
i__61849_61857 = G__61874;
continue;
}
} else {
}
}
break;
}

var G__61875 = seq__61842;
var G__61876 = chunk__61843;
var G__61877 = count__61844;
var G__61878 = (i__61845 + (1));
seq__61842 = G__61875;
chunk__61843 = G__61876;
count__61844 = G__61877;
i__61845 = G__61878;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__61842);
if(temp__6753__auto__){
var seq__61842__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61842__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__61842__$1);
var G__61879 = cljs.core.chunk_rest.call(null,seq__61842__$1);
var G__61880 = c__28546__auto__;
var G__61881 = cljs.core.count.call(null,c__28546__auto__);
var G__61882 = (0);
seq__61842 = G__61879;
chunk__61843 = G__61880;
count__61844 = G__61881;
i__61845 = G__61882;
continue;
} else {
var prov = cljs.core.first.call(null,seq__61842__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__61850_61883 = cljs.core.seq.call(null,requires);
var chunk__61851_61884 = null;
var count__61852_61885 = (0);
var i__61853_61886 = (0);
while(true){
if((i__61853_61886 < count__61852_61885)){
var req_61887 = cljs.core._nth.call(null,chunk__61851_61884,i__61853_61886);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_61887,prov);

var G__61888 = seq__61850_61883;
var G__61889 = chunk__61851_61884;
var G__61890 = count__61852_61885;
var G__61891 = (i__61853_61886 + (1));
seq__61850_61883 = G__61888;
chunk__61851_61884 = G__61889;
count__61852_61885 = G__61890;
i__61853_61886 = G__61891;
continue;
} else {
var temp__6753__auto___61892__$1 = cljs.core.seq.call(null,seq__61850_61883);
if(temp__6753__auto___61892__$1){
var seq__61850_61893__$1 = temp__6753__auto___61892__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61850_61893__$1)){
var c__28546__auto___61894 = cljs.core.chunk_first.call(null,seq__61850_61893__$1);
var G__61895 = cljs.core.chunk_rest.call(null,seq__61850_61893__$1);
var G__61896 = c__28546__auto___61894;
var G__61897 = cljs.core.count.call(null,c__28546__auto___61894);
var G__61898 = (0);
seq__61850_61883 = G__61895;
chunk__61851_61884 = G__61896;
count__61852_61885 = G__61897;
i__61853_61886 = G__61898;
continue;
} else {
var req_61899 = cljs.core.first.call(null,seq__61850_61893__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_61899,prov);

var G__61900 = cljs.core.next.call(null,seq__61850_61893__$1);
var G__61901 = null;
var G__61902 = (0);
var G__61903 = (0);
seq__61850_61883 = G__61900;
chunk__61851_61884 = G__61901;
count__61852_61885 = G__61902;
i__61853_61886 = G__61903;
continue;
}
} else {
}
}
break;
}

var G__61904 = cljs.core.next.call(null,seq__61842__$1);
var G__61905 = null;
var G__61906 = (0);
var G__61907 = (0);
seq__61842 = G__61904;
chunk__61843 = G__61905;
count__61844 = G__61906;
i__61845 = G__61907;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__61912_61916 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__61913_61917 = null;
var count__61914_61918 = (0);
var i__61915_61919 = (0);
while(true){
if((i__61915_61919 < count__61914_61918)){
var ns_61920 = cljs.core._nth.call(null,chunk__61913_61917,i__61915_61919);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_61920);

var G__61921 = seq__61912_61916;
var G__61922 = chunk__61913_61917;
var G__61923 = count__61914_61918;
var G__61924 = (i__61915_61919 + (1));
seq__61912_61916 = G__61921;
chunk__61913_61917 = G__61922;
count__61914_61918 = G__61923;
i__61915_61919 = G__61924;
continue;
} else {
var temp__6753__auto___61925 = cljs.core.seq.call(null,seq__61912_61916);
if(temp__6753__auto___61925){
var seq__61912_61926__$1 = temp__6753__auto___61925;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61912_61926__$1)){
var c__28546__auto___61927 = cljs.core.chunk_first.call(null,seq__61912_61926__$1);
var G__61928 = cljs.core.chunk_rest.call(null,seq__61912_61926__$1);
var G__61929 = c__28546__auto___61927;
var G__61930 = cljs.core.count.call(null,c__28546__auto___61927);
var G__61931 = (0);
seq__61912_61916 = G__61928;
chunk__61913_61917 = G__61929;
count__61914_61918 = G__61930;
i__61915_61919 = G__61931;
continue;
} else {
var ns_61932 = cljs.core.first.call(null,seq__61912_61926__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_61932);

var G__61933 = cljs.core.next.call(null,seq__61912_61926__$1);
var G__61934 = null;
var G__61935 = (0);
var G__61936 = (0);
seq__61912_61916 = G__61933;
chunk__61913_61917 = G__61934;
count__61914_61918 = G__61935;
i__61915_61919 = G__61936;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27635__auto__ = goog.require__;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__61937__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__61937 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__61938__i = 0, G__61938__a = new Array(arguments.length -  0);
while (G__61938__i < G__61938__a.length) {G__61938__a[G__61938__i] = arguments[G__61938__i + 0]; ++G__61938__i;}
  args = new cljs.core.IndexedSeq(G__61938__a,0);
} 
return G__61937__delegate.call(this,args);};
G__61937.cljs$lang$maxFixedArity = 0;
G__61937.cljs$lang$applyTo = (function (arglist__61939){
var args = cljs.core.seq(arglist__61939);
return G__61937__delegate(args);
});
G__61937.cljs$core$IFn$_invoke$arity$variadic = G__61937__delegate;
return G__61937;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__61940 = cljs.core._EQ_;
var expr__61941 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__61940.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__61941))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__61940,expr__61941){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__61940,expr__61941))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__61940,expr__61941){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e61943){if((e61943 instanceof Error)){
var e = e61943;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e61943;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__61940,expr__61941))
} else {
if(cljs.core.truth_(pred__61940.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__61941))){
return ((function (pred__61940,expr__61941){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__61940,expr__61941){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__61940,expr__61941))
);

return deferred.addErrback(((function (deferred,pred__61940,expr__61941){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__61940,expr__61941))
);
});
;})(pred__61940,expr__61941))
} else {
if(cljs.core.truth_(pred__61940.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__61941))){
return ((function (pred__61940,expr__61941){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e61944){if((e61944 instanceof Error)){
var e = e61944;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e61944;

}
}})());
});
;})(pred__61940,expr__61941))
} else {
return ((function (pred__61940,expr__61941){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__61940,expr__61941))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__61945,callback){
var map__61948 = p__61945;
var map__61948__$1 = ((((!((map__61948 == null)))?((((map__61948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61948):map__61948);
var file_msg = map__61948__$1;
var request_url = cljs.core.get.call(null,map__61948__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__61948,map__61948__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__61948,map__61948__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__){
return (function (state_61972){
var state_val_61973 = (state_61972[(1)]);
if((state_val_61973 === (7))){
var inst_61968 = (state_61972[(2)]);
var state_61972__$1 = state_61972;
var statearr_61974_61994 = state_61972__$1;
(statearr_61974_61994[(2)] = inst_61968);

(statearr_61974_61994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (1))){
var state_61972__$1 = state_61972;
var statearr_61975_61995 = state_61972__$1;
(statearr_61975_61995[(2)] = null);

(statearr_61975_61995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (4))){
var inst_61952 = (state_61972[(7)]);
var inst_61952__$1 = (state_61972[(2)]);
var state_61972__$1 = (function (){var statearr_61976 = state_61972;
(statearr_61976[(7)] = inst_61952__$1);

return statearr_61976;
})();
if(cljs.core.truth_(inst_61952__$1)){
var statearr_61977_61996 = state_61972__$1;
(statearr_61977_61996[(1)] = (5));

} else {
var statearr_61978_61997 = state_61972__$1;
(statearr_61978_61997[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (6))){
var state_61972__$1 = state_61972;
var statearr_61979_61998 = state_61972__$1;
(statearr_61979_61998[(2)] = null);

(statearr_61979_61998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (3))){
var inst_61970 = (state_61972[(2)]);
var state_61972__$1 = state_61972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61972__$1,inst_61970);
} else {
if((state_val_61973 === (2))){
var state_61972__$1 = state_61972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61972__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_61973 === (11))){
var inst_61964 = (state_61972[(2)]);
var state_61972__$1 = (function (){var statearr_61980 = state_61972;
(statearr_61980[(8)] = inst_61964);

return statearr_61980;
})();
var statearr_61981_61999 = state_61972__$1;
(statearr_61981_61999[(2)] = null);

(statearr_61981_61999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (9))){
var inst_61956 = (state_61972[(9)]);
var inst_61958 = (state_61972[(10)]);
var inst_61960 = inst_61958.call(null,inst_61956);
var state_61972__$1 = state_61972;
var statearr_61982_62000 = state_61972__$1;
(statearr_61982_62000[(2)] = inst_61960);

(statearr_61982_62000[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (5))){
var inst_61952 = (state_61972[(7)]);
var inst_61954 = figwheel.client.file_reloading.blocking_load.call(null,inst_61952);
var state_61972__$1 = state_61972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61972__$1,(8),inst_61954);
} else {
if((state_val_61973 === (10))){
var inst_61956 = (state_61972[(9)]);
var inst_61962 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_61956);
var state_61972__$1 = state_61972;
var statearr_61983_62001 = state_61972__$1;
(statearr_61983_62001[(2)] = inst_61962);

(statearr_61983_62001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (8))){
var inst_61952 = (state_61972[(7)]);
var inst_61958 = (state_61972[(10)]);
var inst_61956 = (state_61972[(2)]);
var inst_61957 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_61958__$1 = cljs.core.get.call(null,inst_61957,inst_61952);
var state_61972__$1 = (function (){var statearr_61984 = state_61972;
(statearr_61984[(9)] = inst_61956);

(statearr_61984[(10)] = inst_61958__$1);

return statearr_61984;
})();
if(cljs.core.truth_(inst_61958__$1)){
var statearr_61985_62002 = state_61972__$1;
(statearr_61985_62002[(1)] = (9));

} else {
var statearr_61986_62003 = state_61972__$1;
(statearr_61986_62003[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__))
;
return ((function (switch__31349__auto__,c__31463__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__31350__auto__ = null;
var figwheel$client$file_reloading$state_machine__31350__auto____0 = (function (){
var statearr_61990 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_61990[(0)] = figwheel$client$file_reloading$state_machine__31350__auto__);

(statearr_61990[(1)] = (1));

return statearr_61990;
});
var figwheel$client$file_reloading$state_machine__31350__auto____1 = (function (state_61972){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_61972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e61991){if((e61991 instanceof Object)){
var ex__31353__auto__ = e61991;
var statearr_61992_62004 = state_61972;
(statearr_61992_62004[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61972);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61991;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62005 = state_61972;
state_61972 = G__62005;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__31350__auto__ = function(state_61972){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__31350__auto____1.call(this,state_61972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__31350__auto____0;
figwheel$client$file_reloading$state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__31350__auto____1;
return figwheel$client$file_reloading$state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__))
})();
var state__31465__auto__ = (function (){var statearr_61993 = f__31464__auto__.call(null);
(statearr_61993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_61993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__))
);

return c__31463__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__62006,callback){
var map__62009 = p__62006;
var map__62009__$1 = ((((!((map__62009 == null)))?((((map__62009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62009):map__62009);
var file_msg = map__62009__$1;
var namespace = cljs.core.get.call(null,map__62009__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__62009,map__62009__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__62009,map__62009__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__62011){
var map__62014 = p__62011;
var map__62014__$1 = ((((!((map__62014 == null)))?((((map__62014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62014.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62014):map__62014);
var file_msg = map__62014__$1;
var namespace = cljs.core.get.call(null,map__62014__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__62016){
var map__62019 = p__62016;
var map__62019__$1 = ((((!((map__62019 == null)))?((((map__62019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62019.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62019):map__62019);
var file_msg = map__62019__$1;
var namespace = cljs.core.get.call(null,map__62019__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27623__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__27623__auto__){
var or__27635__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
var or__27635__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27635__auto____$1)){
return or__27635__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27623__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__62021,callback){
var map__62024 = p__62021;
var map__62024__$1 = ((((!((map__62024 == null)))?((((map__62024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62024.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62024):map__62024);
var file_msg = map__62024__$1;
var request_url = cljs.core.get.call(null,map__62024__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__62024__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__31463__auto___62128 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto___62128,out){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto___62128,out){
return (function (state_62110){
var state_val_62111 = (state_62110[(1)]);
if((state_val_62111 === (1))){
var inst_62084 = cljs.core.seq.call(null,files);
var inst_62085 = cljs.core.first.call(null,inst_62084);
var inst_62086 = cljs.core.next.call(null,inst_62084);
var inst_62087 = files;
var state_62110__$1 = (function (){var statearr_62112 = state_62110;
(statearr_62112[(7)] = inst_62087);

(statearr_62112[(8)] = inst_62085);

(statearr_62112[(9)] = inst_62086);

return statearr_62112;
})();
var statearr_62113_62129 = state_62110__$1;
(statearr_62113_62129[(2)] = null);

(statearr_62113_62129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (2))){
var inst_62087 = (state_62110[(7)]);
var inst_62093 = (state_62110[(10)]);
var inst_62092 = cljs.core.seq.call(null,inst_62087);
var inst_62093__$1 = cljs.core.first.call(null,inst_62092);
var inst_62094 = cljs.core.next.call(null,inst_62092);
var inst_62095 = (inst_62093__$1 == null);
var inst_62096 = cljs.core.not.call(null,inst_62095);
var state_62110__$1 = (function (){var statearr_62114 = state_62110;
(statearr_62114[(11)] = inst_62094);

(statearr_62114[(10)] = inst_62093__$1);

return statearr_62114;
})();
if(inst_62096){
var statearr_62115_62130 = state_62110__$1;
(statearr_62115_62130[(1)] = (4));

} else {
var statearr_62116_62131 = state_62110__$1;
(statearr_62116_62131[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (3))){
var inst_62108 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62110__$1,inst_62108);
} else {
if((state_val_62111 === (4))){
var inst_62093 = (state_62110[(10)]);
var inst_62098 = figwheel.client.file_reloading.reload_js_file.call(null,inst_62093);
var state_62110__$1 = state_62110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62110__$1,(7),inst_62098);
} else {
if((state_val_62111 === (5))){
var inst_62104 = cljs.core.async.close_BANG_.call(null,out);
var state_62110__$1 = state_62110;
var statearr_62117_62132 = state_62110__$1;
(statearr_62117_62132[(2)] = inst_62104);

(statearr_62117_62132[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (6))){
var inst_62106 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62118_62133 = state_62110__$1;
(statearr_62118_62133[(2)] = inst_62106);

(statearr_62118_62133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (7))){
var inst_62094 = (state_62110[(11)]);
var inst_62100 = (state_62110[(2)]);
var inst_62101 = cljs.core.async.put_BANG_.call(null,out,inst_62100);
var inst_62087 = inst_62094;
var state_62110__$1 = (function (){var statearr_62119 = state_62110;
(statearr_62119[(7)] = inst_62087);

(statearr_62119[(12)] = inst_62101);

return statearr_62119;
})();
var statearr_62120_62134 = state_62110__$1;
(statearr_62120_62134[(2)] = null);

(statearr_62120_62134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31463__auto___62128,out))
;
return ((function (switch__31349__auto__,c__31463__auto___62128,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____0 = (function (){
var statearr_62124 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62124[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__);

(statearr_62124[(1)] = (1));

return statearr_62124;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____1 = (function (state_62110){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_62110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e62125){if((e62125 instanceof Object)){
var ex__31353__auto__ = e62125;
var statearr_62126_62135 = state_62110;
(statearr_62126_62135[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62110);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62136 = state_62110;
state_62110 = G__62136;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__ = function(state_62110){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____1.call(this,state_62110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto___62128,out))
})();
var state__31465__auto__ = (function (){var statearr_62127 = f__31464__auto__.call(null);
(statearr_62127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto___62128);

return statearr_62127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto___62128,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__62137,opts){
var map__62141 = p__62137;
var map__62141__$1 = ((((!((map__62141 == null)))?((((map__62141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62141.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62141):map__62141);
var eval_body = cljs.core.get.call(null,map__62141__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__62141__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27623__auto__ = eval_body;
if(cljs.core.truth_(and__27623__auto__)){
return typeof eval_body === 'string';
} else {
return and__27623__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e62143){var e = e62143;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__62144_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__62144_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__62153){
var vec__62154 = p__62153;
var k = cljs.core.nth.call(null,vec__62154,(0),null);
var v = cljs.core.nth.call(null,vec__62154,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__62157){
var vec__62158 = p__62157;
var k = cljs.core.nth.call(null,vec__62158,(0),null);
var v = cljs.core.nth.call(null,vec__62158,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__62164,p__62165){
var map__62413 = p__62164;
var map__62413__$1 = ((((!((map__62413 == null)))?((((map__62413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62413.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62413):map__62413);
var opts = map__62413__$1;
var before_jsload = cljs.core.get.call(null,map__62413__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__62413__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__62413__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__62414 = p__62165;
var map__62414__$1 = ((((!((map__62414 == null)))?((((map__62414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62414.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62414):map__62414);
var msg = map__62414__$1;
var files = cljs.core.get.call(null,map__62414__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__62414__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__62414__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__31463__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__31464__auto__ = (function (){var switch__31349__auto__ = ((function (c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_62568){
var state_val_62569 = (state_62568[(1)]);
if((state_val_62569 === (7))){
var inst_62429 = (state_62568[(7)]);
var inst_62428 = (state_62568[(8)]);
var inst_62430 = (state_62568[(9)]);
var inst_62431 = (state_62568[(10)]);
var inst_62436 = cljs.core._nth.call(null,inst_62429,inst_62431);
var inst_62437 = figwheel.client.file_reloading.eval_body.call(null,inst_62436,opts);
var inst_62438 = (inst_62431 + (1));
var tmp62570 = inst_62429;
var tmp62571 = inst_62428;
var tmp62572 = inst_62430;
var inst_62428__$1 = tmp62571;
var inst_62429__$1 = tmp62570;
var inst_62430__$1 = tmp62572;
var inst_62431__$1 = inst_62438;
var state_62568__$1 = (function (){var statearr_62573 = state_62568;
(statearr_62573[(7)] = inst_62429__$1);

(statearr_62573[(11)] = inst_62437);

(statearr_62573[(8)] = inst_62428__$1);

(statearr_62573[(9)] = inst_62430__$1);

(statearr_62573[(10)] = inst_62431__$1);

return statearr_62573;
})();
var statearr_62574_62660 = state_62568__$1;
(statearr_62574_62660[(2)] = null);

(statearr_62574_62660[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (20))){
var inst_62471 = (state_62568[(12)]);
var inst_62479 = figwheel.client.file_reloading.sort_files.call(null,inst_62471);
var state_62568__$1 = state_62568;
var statearr_62575_62661 = state_62568__$1;
(statearr_62575_62661[(2)] = inst_62479);

(statearr_62575_62661[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (27))){
var state_62568__$1 = state_62568;
var statearr_62576_62662 = state_62568__$1;
(statearr_62576_62662[(2)] = null);

(statearr_62576_62662[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (1))){
var inst_62420 = (state_62568[(13)]);
var inst_62417 = before_jsload.call(null,files);
var inst_62418 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_62419 = (function (){return ((function (inst_62420,inst_62417,inst_62418,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62161_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__62161_SHARP_);
});
;})(inst_62420,inst_62417,inst_62418,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62420__$1 = cljs.core.filter.call(null,inst_62419,files);
var inst_62421 = cljs.core.not_empty.call(null,inst_62420__$1);
var state_62568__$1 = (function (){var statearr_62577 = state_62568;
(statearr_62577[(14)] = inst_62418);

(statearr_62577[(13)] = inst_62420__$1);

(statearr_62577[(15)] = inst_62417);

return statearr_62577;
})();
if(cljs.core.truth_(inst_62421)){
var statearr_62578_62663 = state_62568__$1;
(statearr_62578_62663[(1)] = (2));

} else {
var statearr_62579_62664 = state_62568__$1;
(statearr_62579_62664[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (24))){
var state_62568__$1 = state_62568;
var statearr_62580_62665 = state_62568__$1;
(statearr_62580_62665[(2)] = null);

(statearr_62580_62665[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (39))){
var inst_62521 = (state_62568[(16)]);
var state_62568__$1 = state_62568;
var statearr_62581_62666 = state_62568__$1;
(statearr_62581_62666[(2)] = inst_62521);

(statearr_62581_62666[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (46))){
var inst_62563 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62582_62667 = state_62568__$1;
(statearr_62582_62667[(2)] = inst_62563);

(statearr_62582_62667[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (4))){
var inst_62465 = (state_62568[(2)]);
var inst_62466 = cljs.core.List.EMPTY;
var inst_62467 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_62466);
var inst_62468 = (function (){return ((function (inst_62465,inst_62466,inst_62467,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62162_SHARP_){
var and__27623__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__62162_SHARP_);
if(cljs.core.truth_(and__27623__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__62162_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__62162_SHARP_)));
} else {
return and__27623__auto__;
}
});
;})(inst_62465,inst_62466,inst_62467,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62469 = cljs.core.filter.call(null,inst_62468,files);
var inst_62470 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_62471 = cljs.core.concat.call(null,inst_62469,inst_62470);
var state_62568__$1 = (function (){var statearr_62583 = state_62568;
(statearr_62583[(17)] = inst_62465);

(statearr_62583[(18)] = inst_62467);

(statearr_62583[(12)] = inst_62471);

return statearr_62583;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_62584_62668 = state_62568__$1;
(statearr_62584_62668[(1)] = (16));

} else {
var statearr_62585_62669 = state_62568__$1;
(statearr_62585_62669[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (15))){
var inst_62455 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62586_62670 = state_62568__$1;
(statearr_62586_62670[(2)] = inst_62455);

(statearr_62586_62670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (21))){
var inst_62481 = (state_62568[(19)]);
var inst_62481__$1 = (state_62568[(2)]);
var inst_62482 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_62481__$1);
var state_62568__$1 = (function (){var statearr_62587 = state_62568;
(statearr_62587[(19)] = inst_62481__$1);

return statearr_62587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62568__$1,(22),inst_62482);
} else {
if((state_val_62569 === (31))){
var inst_62566 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62568__$1,inst_62566);
} else {
if((state_val_62569 === (32))){
var inst_62521 = (state_62568[(16)]);
var inst_62526 = inst_62521.cljs$lang$protocol_mask$partition0$;
var inst_62527 = (inst_62526 & (64));
var inst_62528 = inst_62521.cljs$core$ISeq$;
var inst_62529 = (cljs.core.PROTOCOL_SENTINEL === inst_62528);
var inst_62530 = (inst_62527) || (inst_62529);
var state_62568__$1 = state_62568;
if(cljs.core.truth_(inst_62530)){
var statearr_62588_62671 = state_62568__$1;
(statearr_62588_62671[(1)] = (35));

} else {
var statearr_62589_62672 = state_62568__$1;
(statearr_62589_62672[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (40))){
var inst_62543 = (state_62568[(20)]);
var inst_62542 = (state_62568[(2)]);
var inst_62543__$1 = cljs.core.get.call(null,inst_62542,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_62544 = cljs.core.get.call(null,inst_62542,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_62545 = cljs.core.not_empty.call(null,inst_62543__$1);
var state_62568__$1 = (function (){var statearr_62590 = state_62568;
(statearr_62590[(21)] = inst_62544);

(statearr_62590[(20)] = inst_62543__$1);

return statearr_62590;
})();
if(cljs.core.truth_(inst_62545)){
var statearr_62591_62673 = state_62568__$1;
(statearr_62591_62673[(1)] = (41));

} else {
var statearr_62592_62674 = state_62568__$1;
(statearr_62592_62674[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (33))){
var state_62568__$1 = state_62568;
var statearr_62593_62675 = state_62568__$1;
(statearr_62593_62675[(2)] = false);

(statearr_62593_62675[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (13))){
var inst_62441 = (state_62568[(22)]);
var inst_62445 = cljs.core.chunk_first.call(null,inst_62441);
var inst_62446 = cljs.core.chunk_rest.call(null,inst_62441);
var inst_62447 = cljs.core.count.call(null,inst_62445);
var inst_62428 = inst_62446;
var inst_62429 = inst_62445;
var inst_62430 = inst_62447;
var inst_62431 = (0);
var state_62568__$1 = (function (){var statearr_62594 = state_62568;
(statearr_62594[(7)] = inst_62429);

(statearr_62594[(8)] = inst_62428);

(statearr_62594[(9)] = inst_62430);

(statearr_62594[(10)] = inst_62431);

return statearr_62594;
})();
var statearr_62595_62676 = state_62568__$1;
(statearr_62595_62676[(2)] = null);

(statearr_62595_62676[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (22))){
var inst_62484 = (state_62568[(23)]);
var inst_62481 = (state_62568[(19)]);
var inst_62485 = (state_62568[(24)]);
var inst_62489 = (state_62568[(25)]);
var inst_62484__$1 = (state_62568[(2)]);
var inst_62485__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_62484__$1);
var inst_62486 = (function (){var all_files = inst_62481;
var res_SINGLEQUOTE_ = inst_62484__$1;
var res = inst_62485__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_62484,inst_62481,inst_62485,inst_62489,inst_62484__$1,inst_62485__$1,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62163_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__62163_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_62484,inst_62481,inst_62485,inst_62489,inst_62484__$1,inst_62485__$1,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62487 = cljs.core.filter.call(null,inst_62486,inst_62484__$1);
var inst_62488 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_62489__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_62488);
var inst_62490 = cljs.core.not_empty.call(null,inst_62489__$1);
var state_62568__$1 = (function (){var statearr_62596 = state_62568;
(statearr_62596[(23)] = inst_62484__$1);

(statearr_62596[(24)] = inst_62485__$1);

(statearr_62596[(26)] = inst_62487);

(statearr_62596[(25)] = inst_62489__$1);

return statearr_62596;
})();
if(cljs.core.truth_(inst_62490)){
var statearr_62597_62677 = state_62568__$1;
(statearr_62597_62677[(1)] = (23));

} else {
var statearr_62598_62678 = state_62568__$1;
(statearr_62598_62678[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (36))){
var state_62568__$1 = state_62568;
var statearr_62599_62679 = state_62568__$1;
(statearr_62599_62679[(2)] = false);

(statearr_62599_62679[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (41))){
var inst_62543 = (state_62568[(20)]);
var inst_62547 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_62548 = cljs.core.map.call(null,inst_62547,inst_62543);
var inst_62549 = cljs.core.pr_str.call(null,inst_62548);
var inst_62550 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62549)].join('');
var inst_62551 = figwheel.client.utils.log.call(null,inst_62550);
var state_62568__$1 = state_62568;
var statearr_62600_62680 = state_62568__$1;
(statearr_62600_62680[(2)] = inst_62551);

(statearr_62600_62680[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (43))){
var inst_62544 = (state_62568[(21)]);
var inst_62554 = (state_62568[(2)]);
var inst_62555 = cljs.core.not_empty.call(null,inst_62544);
var state_62568__$1 = (function (){var statearr_62601 = state_62568;
(statearr_62601[(27)] = inst_62554);

return statearr_62601;
})();
if(cljs.core.truth_(inst_62555)){
var statearr_62602_62681 = state_62568__$1;
(statearr_62602_62681[(1)] = (44));

} else {
var statearr_62603_62682 = state_62568__$1;
(statearr_62603_62682[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (29))){
var inst_62521 = (state_62568[(16)]);
var inst_62484 = (state_62568[(23)]);
var inst_62481 = (state_62568[(19)]);
var inst_62485 = (state_62568[(24)]);
var inst_62487 = (state_62568[(26)]);
var inst_62489 = (state_62568[(25)]);
var inst_62517 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_62520 = (function (){var all_files = inst_62481;
var res_SINGLEQUOTE_ = inst_62484;
var res = inst_62485;
var files_not_loaded = inst_62487;
var dependencies_that_loaded = inst_62489;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62521,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62517,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62519){
var map__62604 = p__62519;
var map__62604__$1 = ((((!((map__62604 == null)))?((((map__62604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62604.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62604):map__62604);
var namespace = cljs.core.get.call(null,map__62604__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62521,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62517,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62521__$1 = cljs.core.group_by.call(null,inst_62520,inst_62487);
var inst_62523 = (inst_62521__$1 == null);
var inst_62524 = cljs.core.not.call(null,inst_62523);
var state_62568__$1 = (function (){var statearr_62606 = state_62568;
(statearr_62606[(28)] = inst_62517);

(statearr_62606[(16)] = inst_62521__$1);

return statearr_62606;
})();
if(inst_62524){
var statearr_62607_62683 = state_62568__$1;
(statearr_62607_62683[(1)] = (32));

} else {
var statearr_62608_62684 = state_62568__$1;
(statearr_62608_62684[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (44))){
var inst_62544 = (state_62568[(21)]);
var inst_62557 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_62544);
var inst_62558 = cljs.core.pr_str.call(null,inst_62557);
var inst_62559 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62558)].join('');
var inst_62560 = figwheel.client.utils.log.call(null,inst_62559);
var state_62568__$1 = state_62568;
var statearr_62609_62685 = state_62568__$1;
(statearr_62609_62685[(2)] = inst_62560);

(statearr_62609_62685[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (6))){
var inst_62462 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62610_62686 = state_62568__$1;
(statearr_62610_62686[(2)] = inst_62462);

(statearr_62610_62686[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (28))){
var inst_62487 = (state_62568[(26)]);
var inst_62514 = (state_62568[(2)]);
var inst_62515 = cljs.core.not_empty.call(null,inst_62487);
var state_62568__$1 = (function (){var statearr_62611 = state_62568;
(statearr_62611[(29)] = inst_62514);

return statearr_62611;
})();
if(cljs.core.truth_(inst_62515)){
var statearr_62612_62687 = state_62568__$1;
(statearr_62612_62687[(1)] = (29));

} else {
var statearr_62613_62688 = state_62568__$1;
(statearr_62613_62688[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (25))){
var inst_62485 = (state_62568[(24)]);
var inst_62501 = (state_62568[(2)]);
var inst_62502 = cljs.core.not_empty.call(null,inst_62485);
var state_62568__$1 = (function (){var statearr_62614 = state_62568;
(statearr_62614[(30)] = inst_62501);

return statearr_62614;
})();
if(cljs.core.truth_(inst_62502)){
var statearr_62615_62689 = state_62568__$1;
(statearr_62615_62689[(1)] = (26));

} else {
var statearr_62616_62690 = state_62568__$1;
(statearr_62616_62690[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (34))){
var inst_62537 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
if(cljs.core.truth_(inst_62537)){
var statearr_62617_62691 = state_62568__$1;
(statearr_62617_62691[(1)] = (38));

} else {
var statearr_62618_62692 = state_62568__$1;
(statearr_62618_62692[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (17))){
var state_62568__$1 = state_62568;
var statearr_62619_62693 = state_62568__$1;
(statearr_62619_62693[(2)] = recompile_dependents);

(statearr_62619_62693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (3))){
var state_62568__$1 = state_62568;
var statearr_62620_62694 = state_62568__$1;
(statearr_62620_62694[(2)] = null);

(statearr_62620_62694[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (12))){
var inst_62458 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62621_62695 = state_62568__$1;
(statearr_62621_62695[(2)] = inst_62458);

(statearr_62621_62695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (2))){
var inst_62420 = (state_62568[(13)]);
var inst_62427 = cljs.core.seq.call(null,inst_62420);
var inst_62428 = inst_62427;
var inst_62429 = null;
var inst_62430 = (0);
var inst_62431 = (0);
var state_62568__$1 = (function (){var statearr_62622 = state_62568;
(statearr_62622[(7)] = inst_62429);

(statearr_62622[(8)] = inst_62428);

(statearr_62622[(9)] = inst_62430);

(statearr_62622[(10)] = inst_62431);

return statearr_62622;
})();
var statearr_62623_62696 = state_62568__$1;
(statearr_62623_62696[(2)] = null);

(statearr_62623_62696[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (23))){
var inst_62484 = (state_62568[(23)]);
var inst_62481 = (state_62568[(19)]);
var inst_62485 = (state_62568[(24)]);
var inst_62487 = (state_62568[(26)]);
var inst_62489 = (state_62568[(25)]);
var inst_62492 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_62494 = (function (){var all_files = inst_62481;
var res_SINGLEQUOTE_ = inst_62484;
var res = inst_62485;
var files_not_loaded = inst_62487;
var dependencies_that_loaded = inst_62489;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62492,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62493){
var map__62624 = p__62493;
var map__62624__$1 = ((((!((map__62624 == null)))?((((map__62624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62624.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62624):map__62624);
var request_url = cljs.core.get.call(null,map__62624__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62492,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62495 = cljs.core.reverse.call(null,inst_62489);
var inst_62496 = cljs.core.map.call(null,inst_62494,inst_62495);
var inst_62497 = cljs.core.pr_str.call(null,inst_62496);
var inst_62498 = figwheel.client.utils.log.call(null,inst_62497);
var state_62568__$1 = (function (){var statearr_62626 = state_62568;
(statearr_62626[(31)] = inst_62492);

return statearr_62626;
})();
var statearr_62627_62697 = state_62568__$1;
(statearr_62627_62697[(2)] = inst_62498);

(statearr_62627_62697[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (35))){
var state_62568__$1 = state_62568;
var statearr_62628_62698 = state_62568__$1;
(statearr_62628_62698[(2)] = true);

(statearr_62628_62698[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (19))){
var inst_62471 = (state_62568[(12)]);
var inst_62477 = figwheel.client.file_reloading.expand_files.call(null,inst_62471);
var state_62568__$1 = state_62568;
var statearr_62629_62699 = state_62568__$1;
(statearr_62629_62699[(2)] = inst_62477);

(statearr_62629_62699[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (11))){
var state_62568__$1 = state_62568;
var statearr_62630_62700 = state_62568__$1;
(statearr_62630_62700[(2)] = null);

(statearr_62630_62700[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (9))){
var inst_62460 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62631_62701 = state_62568__$1;
(statearr_62631_62701[(2)] = inst_62460);

(statearr_62631_62701[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (5))){
var inst_62430 = (state_62568[(9)]);
var inst_62431 = (state_62568[(10)]);
var inst_62433 = (inst_62431 < inst_62430);
var inst_62434 = inst_62433;
var state_62568__$1 = state_62568;
if(cljs.core.truth_(inst_62434)){
var statearr_62632_62702 = state_62568__$1;
(statearr_62632_62702[(1)] = (7));

} else {
var statearr_62633_62703 = state_62568__$1;
(statearr_62633_62703[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (14))){
var inst_62441 = (state_62568[(22)]);
var inst_62450 = cljs.core.first.call(null,inst_62441);
var inst_62451 = figwheel.client.file_reloading.eval_body.call(null,inst_62450,opts);
var inst_62452 = cljs.core.next.call(null,inst_62441);
var inst_62428 = inst_62452;
var inst_62429 = null;
var inst_62430 = (0);
var inst_62431 = (0);
var state_62568__$1 = (function (){var statearr_62634 = state_62568;
(statearr_62634[(7)] = inst_62429);

(statearr_62634[(8)] = inst_62428);

(statearr_62634[(32)] = inst_62451);

(statearr_62634[(9)] = inst_62430);

(statearr_62634[(10)] = inst_62431);

return statearr_62634;
})();
var statearr_62635_62704 = state_62568__$1;
(statearr_62635_62704[(2)] = null);

(statearr_62635_62704[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (45))){
var state_62568__$1 = state_62568;
var statearr_62636_62705 = state_62568__$1;
(statearr_62636_62705[(2)] = null);

(statearr_62636_62705[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (26))){
var inst_62484 = (state_62568[(23)]);
var inst_62481 = (state_62568[(19)]);
var inst_62485 = (state_62568[(24)]);
var inst_62487 = (state_62568[(26)]);
var inst_62489 = (state_62568[(25)]);
var inst_62504 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_62506 = (function (){var all_files = inst_62481;
var res_SINGLEQUOTE_ = inst_62484;
var res = inst_62485;
var files_not_loaded = inst_62487;
var dependencies_that_loaded = inst_62489;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62504,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62505){
var map__62637 = p__62505;
var map__62637__$1 = ((((!((map__62637 == null)))?((((map__62637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62637.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62637):map__62637);
var namespace = cljs.core.get.call(null,map__62637__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__62637__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62504,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62507 = cljs.core.map.call(null,inst_62506,inst_62485);
var inst_62508 = cljs.core.pr_str.call(null,inst_62507);
var inst_62509 = figwheel.client.utils.log.call(null,inst_62508);
var inst_62510 = (function (){var all_files = inst_62481;
var res_SINGLEQUOTE_ = inst_62484;
var res = inst_62485;
var files_not_loaded = inst_62487;
var dependencies_that_loaded = inst_62489;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62504,inst_62506,inst_62507,inst_62508,inst_62509,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62484,inst_62481,inst_62485,inst_62487,inst_62489,inst_62504,inst_62506,inst_62507,inst_62508,inst_62509,state_val_62569,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62511 = setTimeout(inst_62510,(10));
var state_62568__$1 = (function (){var statearr_62639 = state_62568;
(statearr_62639[(33)] = inst_62509);

(statearr_62639[(34)] = inst_62504);

return statearr_62639;
})();
var statearr_62640_62706 = state_62568__$1;
(statearr_62640_62706[(2)] = inst_62511);

(statearr_62640_62706[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (16))){
var state_62568__$1 = state_62568;
var statearr_62641_62707 = state_62568__$1;
(statearr_62641_62707[(2)] = reload_dependents);

(statearr_62641_62707[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (38))){
var inst_62521 = (state_62568[(16)]);
var inst_62539 = cljs.core.apply.call(null,cljs.core.hash_map,inst_62521);
var state_62568__$1 = state_62568;
var statearr_62642_62708 = state_62568__$1;
(statearr_62642_62708[(2)] = inst_62539);

(statearr_62642_62708[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (30))){
var state_62568__$1 = state_62568;
var statearr_62643_62709 = state_62568__$1;
(statearr_62643_62709[(2)] = null);

(statearr_62643_62709[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (10))){
var inst_62441 = (state_62568[(22)]);
var inst_62443 = cljs.core.chunked_seq_QMARK_.call(null,inst_62441);
var state_62568__$1 = state_62568;
if(inst_62443){
var statearr_62644_62710 = state_62568__$1;
(statearr_62644_62710[(1)] = (13));

} else {
var statearr_62645_62711 = state_62568__$1;
(statearr_62645_62711[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (18))){
var inst_62475 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
if(cljs.core.truth_(inst_62475)){
var statearr_62646_62712 = state_62568__$1;
(statearr_62646_62712[(1)] = (19));

} else {
var statearr_62647_62713 = state_62568__$1;
(statearr_62647_62713[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (42))){
var state_62568__$1 = state_62568;
var statearr_62648_62714 = state_62568__$1;
(statearr_62648_62714[(2)] = null);

(statearr_62648_62714[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (37))){
var inst_62534 = (state_62568[(2)]);
var state_62568__$1 = state_62568;
var statearr_62649_62715 = state_62568__$1;
(statearr_62649_62715[(2)] = inst_62534);

(statearr_62649_62715[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62569 === (8))){
var inst_62441 = (state_62568[(22)]);
var inst_62428 = (state_62568[(8)]);
var inst_62441__$1 = cljs.core.seq.call(null,inst_62428);
var state_62568__$1 = (function (){var statearr_62650 = state_62568;
(statearr_62650[(22)] = inst_62441__$1);

return statearr_62650;
})();
if(inst_62441__$1){
var statearr_62651_62716 = state_62568__$1;
(statearr_62651_62716[(1)] = (10));

} else {
var statearr_62652_62717 = state_62568__$1;
(statearr_62652_62717[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__31349__auto__,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____0 = (function (){
var statearr_62656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62656[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__);

(statearr_62656[(1)] = (1));

return statearr_62656;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____1 = (function (state_62568){
while(true){
var ret_value__31351__auto__ = (function (){try{while(true){
var result__31352__auto__ = switch__31349__auto__.call(null,state_62568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31352__auto__;
}
break;
}
}catch (e62657){if((e62657 instanceof Object)){
var ex__31353__auto__ = e62657;
var statearr_62658_62718 = state_62568;
(statearr_62658_62718[(5)] = ex__31353__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62657;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62719 = state_62568;
state_62568 = G__62719;
continue;
} else {
return ret_value__31351__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__ = function(state_62568){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____1.call(this,state_62568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31350__auto__;
})()
;})(switch__31349__auto__,c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__31465__auto__ = (function (){var statearr_62659 = f__31464__auto__.call(null);
(statearr_62659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__31463__auto__);

return statearr_62659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31465__auto__);
});})(c__31463__auto__,map__62413,map__62413__$1,opts,before_jsload,on_jsload,reload_dependents,map__62414,map__62414__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__31463__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__62722,link){
var map__62725 = p__62722;
var map__62725__$1 = ((((!((map__62725 == null)))?((((map__62725.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62725.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62725):map__62725);
var file = cljs.core.get.call(null,map__62725__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__62725,map__62725__$1,file){
return (function (p1__62720_SHARP_,p2__62721_SHARP_){
if(cljs.core._EQ_.call(null,p1__62720_SHARP_,p2__62721_SHARP_)){
return p1__62720_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__62725,map__62725__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__62731){
var map__62732 = p__62731;
var map__62732__$1 = ((((!((map__62732 == null)))?((((map__62732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62732.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62732):map__62732);
var match_length = cljs.core.get.call(null,map__62732__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__62732__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__62727_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__62727_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__62734_SHARP_,p2__62735_SHARP_){
return cljs.core.assoc.call(null,p1__62734_SHARP_,cljs.core.get.call(null,p2__62735_SHARP_,key),p2__62735_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_62736 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_62736);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_62736);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__62737,p__62738){
var map__62743 = p__62737;
var map__62743__$1 = ((((!((map__62743 == null)))?((((map__62743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62743.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62743):map__62743);
var on_cssload = cljs.core.get.call(null,map__62743__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__62744 = p__62738;
var map__62744__$1 = ((((!((map__62744 == null)))?((((map__62744.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62744.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62744):map__62744);
var files_msg = map__62744__$1;
var files = cljs.core.get.call(null,map__62744__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1486510898804