// Compiled by ClojureScript 1.9.456 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__72166__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__72163 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__72164 = cljs.core.seq.call(null,vec__72163);
var first__72165 = cljs.core.first.call(null,seq__72164);
var seq__72164__$1 = cljs.core.next.call(null,seq__72164);
var tag = first__72165;
var body = seq__72164__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__72166 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__72167__i = 0, G__72167__a = new Array(arguments.length -  0);
while (G__72167__i < G__72167__a.length) {G__72167__a[G__72167__i] = arguments[G__72167__i + 0]; ++G__72167__i;}
  args = new cljs.core.IndexedSeq(G__72167__a,0);
} 
return G__72166__delegate.call(this,args);};
G__72166.cljs$lang$maxFixedArity = 0;
G__72166.cljs$lang$applyTo = (function (arglist__72168){
var args = cljs.core.seq(arglist__72168);
return G__72166__delegate(args);
});
G__72166.cljs$core$IFn$_invoke$arity$variadic = G__72166__delegate;
return G__72166;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28497__auto__ = (function sablono$core$update_arglists_$_iter__72173(s__72174){
return (new cljs.core.LazySeq(null,(function (){
var s__72174__$1 = s__72174;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__72174__$1);
if(temp__6753__auto__){
var s__72174__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__72174__$2)){
var c__28495__auto__ = cljs.core.chunk_first.call(null,s__72174__$2);
var size__28496__auto__ = cljs.core.count.call(null,c__28495__auto__);
var b__72176 = cljs.core.chunk_buffer.call(null,size__28496__auto__);
if((function (){var i__72175 = (0);
while(true){
if((i__72175 < size__28496__auto__)){
var args = cljs.core._nth.call(null,c__28495__auto__,i__72175);
cljs.core.chunk_append.call(null,b__72176,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__72177 = (i__72175 + (1));
i__72175 = G__72177;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72176),sablono$core$update_arglists_$_iter__72173.call(null,cljs.core.chunk_rest.call(null,s__72174__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72176),null);
}
} else {
var args = cljs.core.first.call(null,s__72174__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__72173.call(null,cljs.core.rest.call(null,s__72174__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28497__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__28863__auto__ = [];
var len__28856__auto___72183 = arguments.length;
var i__28857__auto___72184 = (0);
while(true){
if((i__28857__auto___72184 < len__28856__auto___72183)){
args__28863__auto__.push((arguments[i__28857__auto___72184]));

var G__72185 = (i__28857__auto___72184 + (1));
i__28857__auto___72184 = G__72185;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((0) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__28864__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28497__auto__ = (function sablono$core$iter__72179(s__72180){
return (new cljs.core.LazySeq(null,(function (){
var s__72180__$1 = s__72180;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__72180__$1);
if(temp__6753__auto__){
var s__72180__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__72180__$2)){
var c__28495__auto__ = cljs.core.chunk_first.call(null,s__72180__$2);
var size__28496__auto__ = cljs.core.count.call(null,c__28495__auto__);
var b__72182 = cljs.core.chunk_buffer.call(null,size__28496__auto__);
if((function (){var i__72181 = (0);
while(true){
if((i__72181 < size__28496__auto__)){
var style = cljs.core._nth.call(null,c__28495__auto__,i__72181);
cljs.core.chunk_append.call(null,b__72182,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__72186 = (i__72181 + (1));
i__72181 = G__72186;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72182),sablono$core$iter__72179.call(null,cljs.core.chunk_rest.call(null,s__72180__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72182),null);
}
} else {
var style = cljs.core.first.call(null,s__72180__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__72179.call(null,cljs.core.rest.call(null,s__72180__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28497__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq72178){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq72178));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to72187 = (function sablono$core$link_to72187(var_args){
var args__28863__auto__ = [];
var len__28856__auto___72190 = arguments.length;
var i__28857__auto___72191 = (0);
while(true){
if((i__28857__auto___72191 < len__28856__auto___72190)){
args__28863__auto__.push((arguments[i__28857__auto___72191]));

var G__72192 = (i__28857__auto___72191 + (1));
i__28857__auto___72191 = G__72192;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to72187.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

sablono.core.link_to72187.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to72187.cljs$lang$maxFixedArity = (1);

sablono.core.link_to72187.cljs$lang$applyTo = (function (seq72188){
var G__72189 = cljs.core.first.call(null,seq72188);
var seq72188__$1 = cljs.core.next.call(null,seq72188);
return sablono.core.link_to72187.cljs$core$IFn$_invoke$arity$variadic(G__72189,seq72188__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to72187);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to72193 = (function sablono$core$mail_to72193(var_args){
var args__28863__auto__ = [];
var len__28856__auto___72200 = arguments.length;
var i__28857__auto___72201 = (0);
while(true){
if((i__28857__auto___72201 < len__28856__auto___72200)){
args__28863__auto__.push((arguments[i__28857__auto___72201]));

var G__72202 = (i__28857__auto___72201 + (1));
i__28857__auto___72201 = G__72202;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to72193.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

sablono.core.mail_to72193.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__72196){
var vec__72197 = p__72196;
var content = cljs.core.nth.call(null,vec__72197,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__27635__auto__ = content;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to72193.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to72193.cljs$lang$applyTo = (function (seq72194){
var G__72195 = cljs.core.first.call(null,seq72194);
var seq72194__$1 = cljs.core.next.call(null,seq72194);
return sablono.core.mail_to72193.cljs$core$IFn$_invoke$arity$variadic(G__72195,seq72194__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to72193);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list72203 = (function sablono$core$unordered_list72203(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28497__auto__ = (function sablono$core$unordered_list72203_$_iter__72208(s__72209){
return (new cljs.core.LazySeq(null,(function (){
var s__72209__$1 = s__72209;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__72209__$1);
if(temp__6753__auto__){
var s__72209__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__72209__$2)){
var c__28495__auto__ = cljs.core.chunk_first.call(null,s__72209__$2);
var size__28496__auto__ = cljs.core.count.call(null,c__28495__auto__);
var b__72211 = cljs.core.chunk_buffer.call(null,size__28496__auto__);
if((function (){var i__72210 = (0);
while(true){
if((i__72210 < size__28496__auto__)){
var x = cljs.core._nth.call(null,c__28495__auto__,i__72210);
cljs.core.chunk_append.call(null,b__72211,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__72212 = (i__72210 + (1));
i__72210 = G__72212;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72211),sablono$core$unordered_list72203_$_iter__72208.call(null,cljs.core.chunk_rest.call(null,s__72209__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72211),null);
}
} else {
var x = cljs.core.first.call(null,s__72209__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list72203_$_iter__72208.call(null,cljs.core.rest.call(null,s__72209__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28497__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list72203);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list72213 = (function sablono$core$ordered_list72213(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28497__auto__ = (function sablono$core$ordered_list72213_$_iter__72218(s__72219){
return (new cljs.core.LazySeq(null,(function (){
var s__72219__$1 = s__72219;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__72219__$1);
if(temp__6753__auto__){
var s__72219__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__72219__$2)){
var c__28495__auto__ = cljs.core.chunk_first.call(null,s__72219__$2);
var size__28496__auto__ = cljs.core.count.call(null,c__28495__auto__);
var b__72221 = cljs.core.chunk_buffer.call(null,size__28496__auto__);
if((function (){var i__72220 = (0);
while(true){
if((i__72220 < size__28496__auto__)){
var x = cljs.core._nth.call(null,c__28495__auto__,i__72220);
cljs.core.chunk_append.call(null,b__72221,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__72222 = (i__72220 + (1));
i__72220 = G__72222;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72221),sablono$core$ordered_list72213_$_iter__72218.call(null,cljs.core.chunk_rest.call(null,s__72219__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72221),null);
}
} else {
var x = cljs.core.first.call(null,s__72219__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list72213_$_iter__72218.call(null,cljs.core.rest.call(null,s__72219__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28497__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list72213);
/**
 * Create an image element.
 */
sablono.core.image72223 = (function sablono$core$image72223(var_args){
var args72224 = [];
var len__28856__auto___72227 = arguments.length;
var i__28857__auto___72228 = (0);
while(true){
if((i__28857__auto___72228 < len__28856__auto___72227)){
args72224.push((arguments[i__28857__auto___72228]));

var G__72229 = (i__28857__auto___72228 + (1));
i__28857__auto___72228 = G__72229;
continue;
} else {
}
break;
}

var G__72226 = args72224.length;
switch (G__72226) {
case 1:
return sablono.core.image72223.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image72223.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72224.length)].join('')));

}
});

sablono.core.image72223.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image72223.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image72223.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image72223);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__72231_SHARP_,p2__72232_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__72231_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__72232_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__72233_SHARP_,p2__72234_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__72233_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__72234_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27635__auto__ = value;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field72235 = (function sablono$core$color_field72235(var_args){
var args72236 = [];
var len__28856__auto___72303 = arguments.length;
var i__28857__auto___72304 = (0);
while(true){
if((i__28857__auto___72304 < len__28856__auto___72303)){
args72236.push((arguments[i__28857__auto___72304]));

var G__72305 = (i__28857__auto___72304 + (1));
i__28857__auto___72304 = G__72305;
continue;
} else {
}
break;
}

var G__72238 = args72236.length;
switch (G__72238) {
case 1:
return sablono.core.color_field72235.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field72235.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72236.length)].join('')));

}
});

sablono.core.color_field72235.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.color_field72235.call(null,name__51642__auto__,null);
});

sablono.core.color_field72235.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.color_field72235.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field72235);

/**
 * Creates a date input field.
 */
sablono.core.date_field72239 = (function sablono$core$date_field72239(var_args){
var args72240 = [];
var len__28856__auto___72307 = arguments.length;
var i__28857__auto___72308 = (0);
while(true){
if((i__28857__auto___72308 < len__28856__auto___72307)){
args72240.push((arguments[i__28857__auto___72308]));

var G__72309 = (i__28857__auto___72308 + (1));
i__28857__auto___72308 = G__72309;
continue;
} else {
}
break;
}

var G__72242 = args72240.length;
switch (G__72242) {
case 1:
return sablono.core.date_field72239.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field72239.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72240.length)].join('')));

}
});

sablono.core.date_field72239.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.date_field72239.call(null,name__51642__auto__,null);
});

sablono.core.date_field72239.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.date_field72239.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field72239);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field72243 = (function sablono$core$datetime_field72243(var_args){
var args72244 = [];
var len__28856__auto___72311 = arguments.length;
var i__28857__auto___72312 = (0);
while(true){
if((i__28857__auto___72312 < len__28856__auto___72311)){
args72244.push((arguments[i__28857__auto___72312]));

var G__72313 = (i__28857__auto___72312 + (1));
i__28857__auto___72312 = G__72313;
continue;
} else {
}
break;
}

var G__72246 = args72244.length;
switch (G__72246) {
case 1:
return sablono.core.datetime_field72243.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field72243.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72244.length)].join('')));

}
});

sablono.core.datetime_field72243.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.datetime_field72243.call(null,name__51642__auto__,null);
});

sablono.core.datetime_field72243.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.datetime_field72243.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field72243);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field72247 = (function sablono$core$datetime_local_field72247(var_args){
var args72248 = [];
var len__28856__auto___72315 = arguments.length;
var i__28857__auto___72316 = (0);
while(true){
if((i__28857__auto___72316 < len__28856__auto___72315)){
args72248.push((arguments[i__28857__auto___72316]));

var G__72317 = (i__28857__auto___72316 + (1));
i__28857__auto___72316 = G__72317;
continue;
} else {
}
break;
}

var G__72250 = args72248.length;
switch (G__72250) {
case 1:
return sablono.core.datetime_local_field72247.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field72247.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72248.length)].join('')));

}
});

sablono.core.datetime_local_field72247.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.datetime_local_field72247.call(null,name__51642__auto__,null);
});

sablono.core.datetime_local_field72247.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.datetime_local_field72247.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field72247);

/**
 * Creates a email input field.
 */
sablono.core.email_field72251 = (function sablono$core$email_field72251(var_args){
var args72252 = [];
var len__28856__auto___72319 = arguments.length;
var i__28857__auto___72320 = (0);
while(true){
if((i__28857__auto___72320 < len__28856__auto___72319)){
args72252.push((arguments[i__28857__auto___72320]));

var G__72321 = (i__28857__auto___72320 + (1));
i__28857__auto___72320 = G__72321;
continue;
} else {
}
break;
}

var G__72254 = args72252.length;
switch (G__72254) {
case 1:
return sablono.core.email_field72251.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field72251.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72252.length)].join('')));

}
});

sablono.core.email_field72251.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.email_field72251.call(null,name__51642__auto__,null);
});

sablono.core.email_field72251.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.email_field72251.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field72251);

/**
 * Creates a file input field.
 */
sablono.core.file_field72255 = (function sablono$core$file_field72255(var_args){
var args72256 = [];
var len__28856__auto___72323 = arguments.length;
var i__28857__auto___72324 = (0);
while(true){
if((i__28857__auto___72324 < len__28856__auto___72323)){
args72256.push((arguments[i__28857__auto___72324]));

var G__72325 = (i__28857__auto___72324 + (1));
i__28857__auto___72324 = G__72325;
continue;
} else {
}
break;
}

var G__72258 = args72256.length;
switch (G__72258) {
case 1:
return sablono.core.file_field72255.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field72255.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72256.length)].join('')));

}
});

sablono.core.file_field72255.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.file_field72255.call(null,name__51642__auto__,null);
});

sablono.core.file_field72255.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.file_field72255.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field72255);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field72259 = (function sablono$core$hidden_field72259(var_args){
var args72260 = [];
var len__28856__auto___72327 = arguments.length;
var i__28857__auto___72328 = (0);
while(true){
if((i__28857__auto___72328 < len__28856__auto___72327)){
args72260.push((arguments[i__28857__auto___72328]));

var G__72329 = (i__28857__auto___72328 + (1));
i__28857__auto___72328 = G__72329;
continue;
} else {
}
break;
}

var G__72262 = args72260.length;
switch (G__72262) {
case 1:
return sablono.core.hidden_field72259.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field72259.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72260.length)].join('')));

}
});

sablono.core.hidden_field72259.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.hidden_field72259.call(null,name__51642__auto__,null);
});

sablono.core.hidden_field72259.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.hidden_field72259.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field72259);

/**
 * Creates a month input field.
 */
sablono.core.month_field72263 = (function sablono$core$month_field72263(var_args){
var args72264 = [];
var len__28856__auto___72331 = arguments.length;
var i__28857__auto___72332 = (0);
while(true){
if((i__28857__auto___72332 < len__28856__auto___72331)){
args72264.push((arguments[i__28857__auto___72332]));

var G__72333 = (i__28857__auto___72332 + (1));
i__28857__auto___72332 = G__72333;
continue;
} else {
}
break;
}

var G__72266 = args72264.length;
switch (G__72266) {
case 1:
return sablono.core.month_field72263.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field72263.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72264.length)].join('')));

}
});

sablono.core.month_field72263.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.month_field72263.call(null,name__51642__auto__,null);
});

sablono.core.month_field72263.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.month_field72263.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field72263);

/**
 * Creates a number input field.
 */
sablono.core.number_field72267 = (function sablono$core$number_field72267(var_args){
var args72268 = [];
var len__28856__auto___72335 = arguments.length;
var i__28857__auto___72336 = (0);
while(true){
if((i__28857__auto___72336 < len__28856__auto___72335)){
args72268.push((arguments[i__28857__auto___72336]));

var G__72337 = (i__28857__auto___72336 + (1));
i__28857__auto___72336 = G__72337;
continue;
} else {
}
break;
}

var G__72270 = args72268.length;
switch (G__72270) {
case 1:
return sablono.core.number_field72267.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field72267.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72268.length)].join('')));

}
});

sablono.core.number_field72267.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.number_field72267.call(null,name__51642__auto__,null);
});

sablono.core.number_field72267.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.number_field72267.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field72267);

/**
 * Creates a password input field.
 */
sablono.core.password_field72271 = (function sablono$core$password_field72271(var_args){
var args72272 = [];
var len__28856__auto___72339 = arguments.length;
var i__28857__auto___72340 = (0);
while(true){
if((i__28857__auto___72340 < len__28856__auto___72339)){
args72272.push((arguments[i__28857__auto___72340]));

var G__72341 = (i__28857__auto___72340 + (1));
i__28857__auto___72340 = G__72341;
continue;
} else {
}
break;
}

var G__72274 = args72272.length;
switch (G__72274) {
case 1:
return sablono.core.password_field72271.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field72271.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72272.length)].join('')));

}
});

sablono.core.password_field72271.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.password_field72271.call(null,name__51642__auto__,null);
});

sablono.core.password_field72271.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.password_field72271.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field72271);

/**
 * Creates a range input field.
 */
sablono.core.range_field72275 = (function sablono$core$range_field72275(var_args){
var args72276 = [];
var len__28856__auto___72343 = arguments.length;
var i__28857__auto___72344 = (0);
while(true){
if((i__28857__auto___72344 < len__28856__auto___72343)){
args72276.push((arguments[i__28857__auto___72344]));

var G__72345 = (i__28857__auto___72344 + (1));
i__28857__auto___72344 = G__72345;
continue;
} else {
}
break;
}

var G__72278 = args72276.length;
switch (G__72278) {
case 1:
return sablono.core.range_field72275.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field72275.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72276.length)].join('')));

}
});

sablono.core.range_field72275.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.range_field72275.call(null,name__51642__auto__,null);
});

sablono.core.range_field72275.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.range_field72275.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field72275);

/**
 * Creates a search input field.
 */
sablono.core.search_field72279 = (function sablono$core$search_field72279(var_args){
var args72280 = [];
var len__28856__auto___72347 = arguments.length;
var i__28857__auto___72348 = (0);
while(true){
if((i__28857__auto___72348 < len__28856__auto___72347)){
args72280.push((arguments[i__28857__auto___72348]));

var G__72349 = (i__28857__auto___72348 + (1));
i__28857__auto___72348 = G__72349;
continue;
} else {
}
break;
}

var G__72282 = args72280.length;
switch (G__72282) {
case 1:
return sablono.core.search_field72279.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field72279.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72280.length)].join('')));

}
});

sablono.core.search_field72279.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.search_field72279.call(null,name__51642__auto__,null);
});

sablono.core.search_field72279.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.search_field72279.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field72279);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field72283 = (function sablono$core$tel_field72283(var_args){
var args72284 = [];
var len__28856__auto___72351 = arguments.length;
var i__28857__auto___72352 = (0);
while(true){
if((i__28857__auto___72352 < len__28856__auto___72351)){
args72284.push((arguments[i__28857__auto___72352]));

var G__72353 = (i__28857__auto___72352 + (1));
i__28857__auto___72352 = G__72353;
continue;
} else {
}
break;
}

var G__72286 = args72284.length;
switch (G__72286) {
case 1:
return sablono.core.tel_field72283.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field72283.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72284.length)].join('')));

}
});

sablono.core.tel_field72283.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.tel_field72283.call(null,name__51642__auto__,null);
});

sablono.core.tel_field72283.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.tel_field72283.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field72283);

/**
 * Creates a text input field.
 */
sablono.core.text_field72287 = (function sablono$core$text_field72287(var_args){
var args72288 = [];
var len__28856__auto___72355 = arguments.length;
var i__28857__auto___72356 = (0);
while(true){
if((i__28857__auto___72356 < len__28856__auto___72355)){
args72288.push((arguments[i__28857__auto___72356]));

var G__72357 = (i__28857__auto___72356 + (1));
i__28857__auto___72356 = G__72357;
continue;
} else {
}
break;
}

var G__72290 = args72288.length;
switch (G__72290) {
case 1:
return sablono.core.text_field72287.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field72287.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72288.length)].join('')));

}
});

sablono.core.text_field72287.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.text_field72287.call(null,name__51642__auto__,null);
});

sablono.core.text_field72287.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.text_field72287.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field72287);

/**
 * Creates a time input field.
 */
sablono.core.time_field72291 = (function sablono$core$time_field72291(var_args){
var args72292 = [];
var len__28856__auto___72359 = arguments.length;
var i__28857__auto___72360 = (0);
while(true){
if((i__28857__auto___72360 < len__28856__auto___72359)){
args72292.push((arguments[i__28857__auto___72360]));

var G__72361 = (i__28857__auto___72360 + (1));
i__28857__auto___72360 = G__72361;
continue;
} else {
}
break;
}

var G__72294 = args72292.length;
switch (G__72294) {
case 1:
return sablono.core.time_field72291.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field72291.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72292.length)].join('')));

}
});

sablono.core.time_field72291.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.time_field72291.call(null,name__51642__auto__,null);
});

sablono.core.time_field72291.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.time_field72291.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field72291);

/**
 * Creates a url input field.
 */
sablono.core.url_field72295 = (function sablono$core$url_field72295(var_args){
var args72296 = [];
var len__28856__auto___72363 = arguments.length;
var i__28857__auto___72364 = (0);
while(true){
if((i__28857__auto___72364 < len__28856__auto___72363)){
args72296.push((arguments[i__28857__auto___72364]));

var G__72365 = (i__28857__auto___72364 + (1));
i__28857__auto___72364 = G__72365;
continue;
} else {
}
break;
}

var G__72298 = args72296.length;
switch (G__72298) {
case 1:
return sablono.core.url_field72295.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field72295.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72296.length)].join('')));

}
});

sablono.core.url_field72295.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.url_field72295.call(null,name__51642__auto__,null);
});

sablono.core.url_field72295.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.url_field72295.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field72295);

/**
 * Creates a week input field.
 */
sablono.core.week_field72299 = (function sablono$core$week_field72299(var_args){
var args72300 = [];
var len__28856__auto___72367 = arguments.length;
var i__28857__auto___72368 = (0);
while(true){
if((i__28857__auto___72368 < len__28856__auto___72367)){
args72300.push((arguments[i__28857__auto___72368]));

var G__72369 = (i__28857__auto___72368 + (1));
i__28857__auto___72368 = G__72369;
continue;
} else {
}
break;
}

var G__72302 = args72300.length;
switch (G__72302) {
case 1:
return sablono.core.week_field72299.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field72299.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72300.length)].join('')));

}
});

sablono.core.week_field72299.cljs$core$IFn$_invoke$arity$1 = (function (name__51642__auto__){
return sablono.core.week_field72299.call(null,name__51642__auto__,null);
});

sablono.core.week_field72299.cljs$core$IFn$_invoke$arity$2 = (function (name__51642__auto__,value__51643__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__51642__auto__,value__51643__auto__);
});

sablono.core.week_field72299.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field72299);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box72371 = (function sablono$core$check_box72371(var_args){
var args72372 = [];
var len__28856__auto___72375 = arguments.length;
var i__28857__auto___72376 = (0);
while(true){
if((i__28857__auto___72376 < len__28856__auto___72375)){
args72372.push((arguments[i__28857__auto___72376]));

var G__72377 = (i__28857__auto___72376 + (1));
i__28857__auto___72376 = G__72377;
continue;
} else {
}
break;
}

var G__72374 = args72372.length;
switch (G__72374) {
case 1:
return sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72372.length)].join('')));

}
});

sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box72371.call(null,name,null);
});

sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box72371.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box72371.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27635__auto__ = value;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box72371.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box72371);
/**
 * Creates a radio button.
 */
sablono.core.radio_button72379 = (function sablono$core$radio_button72379(var_args){
var args72380 = [];
var len__28856__auto___72383 = arguments.length;
var i__28857__auto___72384 = (0);
while(true){
if((i__28857__auto___72384 < len__28856__auto___72383)){
args72380.push((arguments[i__28857__auto___72384]));

var G__72385 = (i__28857__auto___72384 + (1));
i__28857__auto___72384 = G__72385;
continue;
} else {
}
break;
}

var G__72382 = args72380.length;
switch (G__72382) {
case 1:
return sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72380.length)].join('')));

}
});

sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button72379.call(null,group,null);
});

sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button72379.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button72379.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27635__auto__ = value;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button72379.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button72379);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options72387 = (function sablono$core$select_options72387(coll){
var iter__28497__auto__ = (function sablono$core$select_options72387_$_iter__72404(s__72405){
return (new cljs.core.LazySeq(null,(function (){
var s__72405__$1 = s__72405;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__72405__$1);
if(temp__6753__auto__){
var s__72405__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__72405__$2)){
var c__28495__auto__ = cljs.core.chunk_first.call(null,s__72405__$2);
var size__28496__auto__ = cljs.core.count.call(null,c__28495__auto__);
var b__72407 = cljs.core.chunk_buffer.call(null,size__28496__auto__);
if((function (){var i__72406 = (0);
while(true){
if((i__72406 < size__28496__auto__)){
var x = cljs.core._nth.call(null,c__28495__auto__,i__72406);
cljs.core.chunk_append.call(null,b__72407,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__72414 = x;
var text = cljs.core.nth.call(null,vec__72414,(0),null);
var val = cljs.core.nth.call(null,vec__72414,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__72414,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options72387.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__72420 = (i__72406 + (1));
i__72406 = G__72420;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72407),sablono$core$select_options72387_$_iter__72404.call(null,cljs.core.chunk_rest.call(null,s__72405__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__72407),null);
}
} else {
var x = cljs.core.first.call(null,s__72405__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__72417 = x;
var text = cljs.core.nth.call(null,vec__72417,(0),null);
var val = cljs.core.nth.call(null,vec__72417,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__72417,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options72387.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options72387_$_iter__72404.call(null,cljs.core.rest.call(null,s__72405__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28497__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options72387);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down72421 = (function sablono$core$drop_down72421(var_args){
var args72422 = [];
var len__28856__auto___72425 = arguments.length;
var i__28857__auto___72426 = (0);
while(true){
if((i__28857__auto___72426 < len__28856__auto___72425)){
args72422.push((arguments[i__28857__auto___72426]));

var G__72427 = (i__28857__auto___72426 + (1));
i__28857__auto___72426 = G__72427;
continue;
} else {
}
break;
}

var G__72424 = args72422.length;
switch (G__72424) {
case 2:
return sablono.core.drop_down72421.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down72421.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72422.length)].join('')));

}
});

sablono.core.drop_down72421.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down72421.call(null,name,options,null);
});

sablono.core.drop_down72421.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down72421.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down72421);
/**
 * Creates a text area element.
 */
sablono.core.text_area72429 = (function sablono$core$text_area72429(var_args){
var args72430 = [];
var len__28856__auto___72433 = arguments.length;
var i__28857__auto___72434 = (0);
while(true){
if((i__28857__auto___72434 < len__28856__auto___72433)){
args72430.push((arguments[i__28857__auto___72434]));

var G__72435 = (i__28857__auto___72434 + (1));
i__28857__auto___72434 = G__72435;
continue;
} else {
}
break;
}

var G__72432 = args72430.length;
switch (G__72432) {
case 1:
return sablono.core.text_area72429.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area72429.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72430.length)].join('')));

}
});

sablono.core.text_area72429.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area72429.call(null,name,null);
});

sablono.core.text_area72429.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27635__auto__ = value;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area72429.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area72429);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label72437 = (function sablono$core$label72437(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label72437);
/**
 * Creates a submit button.
 */
sablono.core.submit_button72438 = (function sablono$core$submit_button72438(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button72438);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button72439 = (function sablono$core$reset_button72439(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button72439);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to72440 = (function sablono$core$form_to72440(var_args){
var args__28863__auto__ = [];
var len__28856__auto___72447 = arguments.length;
var i__28857__auto___72448 = (0);
while(true){
if((i__28857__auto___72448 < len__28856__auto___72447)){
args__28863__auto__.push((arguments[i__28857__auto___72448]));

var G__72449 = (i__28857__auto___72448 + (1));
i__28857__auto___72448 = G__72449;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((1) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to72440.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28864__auto__);
});

sablono.core.form_to72440.cljs$core$IFn$_invoke$arity$variadic = (function (p__72443,body){
var vec__72444 = p__72443;
var method = cljs.core.nth.call(null,vec__72444,(0),null);
var action = cljs.core.nth.call(null,vec__72444,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to72440.cljs$lang$maxFixedArity = (1);

sablono.core.form_to72440.cljs$lang$applyTo = (function (seq72441){
var G__72442 = cljs.core.first.call(null,seq72441);
var seq72441__$1 = cljs.core.next.call(null,seq72441);
return sablono.core.form_to72440.cljs$core$IFn$_invoke$arity$variadic(G__72442,seq72441__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to72440);

//# sourceMappingURL=core.js.map?rel=1486510913704