// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.cache_manager');
goog.require('cljs.core');

/**
 * @interface
 */
untangled.client.cache_manager.ICacheEntry = function(){};

/**
 * Returns new cache entry with `time-last-refreshed`
 *                             updated to `new-timestamp`.
 */
untangled.client.cache_manager.touch = (function untangled$client$cache_manager$touch(this$,new_timestamp){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheEntry$touch$arity$2 == null)))){
return this$.untangled$client$cache_manager$ICacheEntry$touch$arity$2(this$,new_timestamp);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.touch[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,new_timestamp);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.touch["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,new_timestamp);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheEntry.touch",this$);
}
}
}
});

/**
 * True when `seconds-valid` has been exceeded.
 */
untangled.client.cache_manager.stale_QMARK_ = (function untangled$client$cache_manager$stale_QMARK_(this$,timestamp){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheEntry$stale_QMARK_$arity$2 == null)))){
return this$.untangled$client$cache_manager$ICacheEntry$stale_QMARK_$arity$2(this$,timestamp);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.stale_QMARK_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,timestamp);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.stale_QMARK_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,timestamp);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheEntry.stale?",this$);
}
}
}
});

/**
 * Function to refresh the cached data.
 */
untangled.client.cache_manager.refresh = (function untangled$client$cache_manager$refresh(this$,timestamp){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheEntry$refresh$arity$2 == null)))){
return this$.untangled$client$cache_manager$ICacheEntry$refresh$arity$2(this$,timestamp);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.refresh[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,timestamp);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.refresh["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,timestamp);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheEntry.refresh",this$);
}
}
}
});

/**
 * Boolean indicating whether `refresh` should be called.
 */
untangled.client.cache_manager.enable_refresh_QMARK_ = (function untangled$client$cache_manager$enable_refresh_QMARK_(this$){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheEntry$enable_refresh_QMARK_$arity$1 == null)))){
return this$.untangled$client$cache_manager$ICacheEntry$enable_refresh_QMARK_$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.enable_refresh_QMARK_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.enable_refresh_QMARK_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheEntry.enable-refresh?",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled.client.cache_manager.ICacheEntry}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled.client.cache_manager.CacheEntry = (function (time_last_refreshed,seconds_valid,key,refresh_fn,is_refresh_enabled_fn,__meta,__extmap,__hash){
this.time_last_refreshed = time_last_refreshed;
this.seconds_valid = seconds_valid;
this.key = key;
this.refresh_fn = refresh_fn;
this.is_refresh_enabled_fn = is_refresh_enabled_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28310__auto__,k__28311__auto__){
var self__ = this;
var this__28310__auto____$1 = this;
return this__28310__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28311__auto__,null);
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28312__auto__,k88538,else__28313__auto__){
var self__ = this;
var this__28312__auto____$1 = this;
var G__88540 = (((k88538 instanceof cljs.core.Keyword))?k88538.fqn:null);
switch (G__88540) {
case "time-last-refreshed":
return self__.time_last_refreshed;

break;
case "seconds-valid":
return self__.seconds_valid;

break;
case "key":
return self__.key;

break;
case "refresh-fn":
return self__.refresh_fn;

break;
case "is-refresh-enabled-fn":
return self__.is_refresh_enabled_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k88538,else__28313__auto__);

}
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28324__auto__,writer__28325__auto__,opts__28326__auto__){
var self__ = this;
var this__28324__auto____$1 = this;
var pr_pair__28327__auto__ = ((function (this__28324__auto____$1){
return (function (keyval__28328__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,cljs.core.pr_writer,""," ","",opts__28326__auto__,keyval__28328__auto__);
});})(this__28324__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,pr_pair__28327__auto__,"#untangled.client.cache-manager.CacheEntry{",", ","}",opts__28326__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),self__.time_last_refreshed],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),self__.seconds_valid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),self__.refresh_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778),self__.is_refresh_enabled_fn],null))], null),self__.__extmap));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__88537){
var self__ = this;
var G__88537__$1 = this;
return (new cljs.core.RecordIter((0),G__88537__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28308__auto__){
var self__ = this;
var this__28308__auto____$1 = this;
return self__.__meta;
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28304__auto__){
var self__ = this;
var this__28304__auto____$1 = this;
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,self__.__extmap,self__.__hash));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28314__auto__){
var self__ = this;
var this__28314__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28305__auto__){
var self__ = this;
var this__28305__auto____$1 = this;
var h__28077__auto__ = self__.__hash;
if(!((h__28077__auto__ == null))){
return h__28077__auto__;
} else {
var h__28077__auto____$1 = cljs.core.hash_imap.call(null,this__28305__auto____$1);
self__.__hash = h__28077__auto____$1;

return h__28077__auto____$1;
}
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__28306__auto__,other__28307__auto__){
var self__ = this;
var this__28306__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27623__auto__ = other__28307__auto__;
if(cljs.core.truth_(and__27623__auto__)){
return ((this__28306__auto____$1.constructor === other__28307__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__28306__auto____$1,other__28307__auto__));
} else {
return and__27623__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled.client.cache_manager.CacheEntry.prototype.untangled$client$cache_manager$ICacheEntry$ = cljs.core.PROTOCOL_SENTINEL;


untangled.client.cache_manager.CacheEntry.prototype.untangled$client$cache_manager$ICacheEntry$touch$arity$2 = (function (this$,new_timestamp){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),new_timestamp);
});


untangled.client.cache_manager.CacheEntry.prototype.untangled$client$cache_manager$ICacheEntry$stale_QMARK_$arity$2 = (function (this$,from_when){
var self__ = this;
var this$__$1 = this;
return ((self__.time_last_refreshed + self__.seconds_valid) < from_when);
});


untangled.client.cache_manager.CacheEntry.prototype.untangled$client$cache_manager$ICacheEntry$refresh$arity$2 = (function (this$,timestamp){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.refresh_fn)){
if(cljs.core.truth_(this$__$1.untangled$client$cache_manager$ICacheEntry$enable_refresh_QMARK_$arity$1(null))){
var new_entry = this$__$1.untangled$client$cache_manager$ICacheEntry$touch$arity$2(null,timestamp);
self__.refresh_fn.call(null,new_entry);

return new_entry;
} else {
return this$__$1;
}
} else {
return this$__$1;
}
});


untangled.client.cache_manager.CacheEntry.prototype.untangled$client$cache_manager$ICacheEntry$enable_refresh_QMARK_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.is_refresh_enabled_fn)){
return self__.is_refresh_enabled_fn.call(null,this$__$1);
} else {
return null;
}
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28319__auto__,k__28320__auto__){
var self__ = this;
var this__28319__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),null,new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),null,new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),null,new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778),null], null), null),k__28320__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28319__auto____$1),self__.__meta),k__28320__auto__);
} else {
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28320__auto__)),null));
}
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28317__auto__,k__28318__auto__,G__88537){
var self__ = this;
var this__28317__auto____$1 = this;
var pred__88541 = cljs.core.keyword_identical_QMARK_;
var expr__88542 = k__28318__auto__;
if(cljs.core.truth_(pred__88541.call(null,new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),expr__88542))){
return (new untangled.client.cache_manager.CacheEntry(G__88537,self__.seconds_valid,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88541.call(null,new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),expr__88542))){
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,G__88537,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88541.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__88542))){
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,G__88537,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88541.call(null,new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),expr__88542))){
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,G__88537,self__.is_refresh_enabled_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88541.call(null,new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778),expr__88542))){
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,self__.refresh_fn,G__88537,self__.__meta,self__.__extmap,null));
} else {
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28318__auto__,G__88537),null));
}
}
}
}
}
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28322__auto__){
var self__ = this;
var this__28322__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),self__.time_last_refreshed],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),self__.seconds_valid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),self__.refresh_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778),self__.is_refresh_enabled_fn],null))], null),self__.__extmap));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28309__auto__,G__88537){
var self__ = this;
var this__28309__auto____$1 = this;
return (new untangled.client.cache_manager.CacheEntry(self__.time_last_refreshed,self__.seconds_valid,self__.key,self__.refresh_fn,self__.is_refresh_enabled_fn,G__88537,self__.__extmap,self__.__hash));
});


untangled.client.cache_manager.CacheEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28315__auto__,entry__28316__auto__){
var self__ = this;
var this__28315__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28316__auto__)){
return this__28315__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28316__auto__,(0)),cljs.core._nth.call(null,entry__28316__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28315__auto____$1,entry__28316__auto__);
}
});

untangled.client.cache_manager.CacheEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"time-last-refreshed","time-last-refreshed",1587570366,null),new cljs.core.Symbol(null,"seconds-valid","seconds-valid",839201979,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"refresh-fn","refresh-fn",-112528360,null),new cljs.core.Symbol(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",-1856956991,null)], null);
});

untangled.client.cache_manager.CacheEntry.cljs$lang$type = true;

untangled.client.cache_manager.CacheEntry.cljs$lang$ctorPrSeq = (function (this__28346__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled.client.cache-manager/CacheEntry");
});

untangled.client.cache_manager.CacheEntry.cljs$lang$ctorPrWriter = (function (this__28346__auto__,writer__28347__auto__){
return cljs.core._write.call(null,writer__28347__auto__,"untangled.client.cache-manager/CacheEntry");
});

untangled.client.cache_manager.__GT_CacheEntry = (function untangled$client$cache_manager$__GT_CacheEntry(time_last_refreshed,seconds_valid,key,refresh_fn,is_refresh_enabled_fn){
return (new untangled.client.cache_manager.CacheEntry(time_last_refreshed,seconds_valid,key,refresh_fn,is_refresh_enabled_fn,null,null,null));
});

untangled.client.cache_manager.map__GT_CacheEntry = (function untangled$client$cache_manager$map__GT_CacheEntry(G__88539){
return (new untangled.client.cache_manager.CacheEntry(new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161).cljs$core$IFn$_invoke$arity$1(G__88539),new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548).cljs$core$IFn$_invoke$arity$1(G__88539),new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__88539),new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887).cljs$core$IFn$_invoke$arity$1(G__88539),new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778).cljs$core$IFn$_invoke$arity$1(G__88539),null,cljs.core.dissoc.call(null,G__88539,new cljs.core.Keyword(null,"time-last-refreshed","time-last-refreshed",-52961161),new cljs.core.Keyword(null,"seconds-valid","seconds-valid",-801329548),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"refresh-fn","refresh-fn",-1753059887),new cljs.core.Keyword(null,"is-refresh-enabled-fn","is-refresh-enabled-fn",797478778)),null));
});


/**
 * @interface
 */
untangled.client.cache_manager.ICacheManager = function(){};

untangled.client.cache_manager.add = (function untangled$client$cache_manager$add(this$,key,cache_entry){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheManager$add$arity$3 == null)))){
return this$.untangled$client$cache_manager$ICacheManager$add$arity$3(this$,key,cache_entry);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.add[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,key,cache_entry);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.add["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,key,cache_entry);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheManager.add",this$);
}
}
}
});

untangled.client.cache_manager.refresh_entries = (function untangled$client$cache_manager$refresh_entries(this$,timestamp){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheManager$refresh_entries$arity$2 == null)))){
return this$.untangled$client$cache_manager$ICacheManager$refresh_entries$arity$2(this$,timestamp);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.refresh_entries[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,timestamp);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.refresh_entries["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,timestamp);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheManager.refresh-entries",this$);
}
}
}
});

untangled.client.cache_manager.should_update_QMARK_ = (function untangled$client$cache_manager$should_update_QMARK_(this$,timestamp){
if((!((this$ == null))) && (!((this$.untangled$client$cache_manager$ICacheManager$should_update_QMARK_$arity$2 == null)))){
return this$.untangled$client$cache_manager$ICacheManager$should_update_QMARK_$arity$2(this$,timestamp);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled.client.cache_manager.should_update_QMARK_[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,timestamp);
} else {
var m__28354__auto____$1 = (untangled.client.cache_manager.should_update_QMARK_["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,timestamp);
} else {
throw cljs.core.missing_protocol.call(null,"ICacheManager.should-update?",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled.client.cache_manager.ICacheManager}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled.client.cache_manager.CacheManager = (function (cache_entries,time_last_checked,debounce_freq_in_seconds,__meta,__extmap,__hash){
this.cache_entries = cache_entries;
this.time_last_checked = time_last_checked;
this.debounce_freq_in_seconds = debounce_freq_in_seconds;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled.client.cache_manager.CacheManager.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28310__auto__,k__28311__auto__){
var self__ = this;
var this__28310__auto____$1 = this;
return this__28310__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28311__auto__,null);
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28312__auto__,k88546,else__28313__auto__){
var self__ = this;
var this__28312__auto____$1 = this;
var G__88548 = (((k88546 instanceof cljs.core.Keyword))?k88546.fqn:null);
switch (G__88548) {
case "cache-entries":
return self__.cache_entries;

break;
case "time-last-checked":
return self__.time_last_checked;

break;
case "debounce-freq-in-seconds":
return self__.debounce_freq_in_seconds;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k88546,else__28313__auto__);

}
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28324__auto__,writer__28325__auto__,opts__28326__auto__){
var self__ = this;
var this__28324__auto____$1 = this;
var pr_pair__28327__auto__ = ((function (this__28324__auto____$1){
return (function (keyval__28328__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,cljs.core.pr_writer,""," ","",opts__28326__auto__,keyval__28328__auto__);
});})(this__28324__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,pr_pair__28327__auto__,"#untangled.client.cache-manager.CacheManager{",", ","}",opts__28326__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),self__.cache_entries],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),self__.time_last_checked],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661),self__.debounce_freq_in_seconds],null))], null),self__.__extmap));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__88545){
var self__ = this;
var G__88545__$1 = this;
return (new cljs.core.RecordIter((0),G__88545__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28308__auto__){
var self__ = this;
var this__28308__auto____$1 = this;
return self__.__meta;
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28304__auto__){
var self__ = this;
var this__28304__auto____$1 = this;
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,self__.time_last_checked,self__.debounce_freq_in_seconds,self__.__meta,self__.__extmap,self__.__hash));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28314__auto__){
var self__ = this;
var this__28314__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28305__auto__){
var self__ = this;
var this__28305__auto____$1 = this;
var h__28077__auto__ = self__.__hash;
if(!((h__28077__auto__ == null))){
return h__28077__auto__;
} else {
var h__28077__auto____$1 = cljs.core.hash_imap.call(null,this__28305__auto____$1);
self__.__hash = h__28077__auto____$1;

return h__28077__auto____$1;
}
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__28306__auto__,other__28307__auto__){
var self__ = this;
var this__28306__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27623__auto__ = other__28307__auto__;
if(cljs.core.truth_(and__27623__auto__)){
return ((this__28306__auto____$1.constructor === other__28307__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__28306__auto____$1,other__28307__auto__));
} else {
return and__27623__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled.client.cache_manager.CacheManager.prototype.untangled$client$cache_manager$ICacheManager$ = cljs.core.PROTOCOL_SENTINEL;


untangled.client.cache_manager.CacheManager.prototype.untangled$client$cache_manager$ICacheManager$add$arity$3 = (function (this$,key,cache_entry){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc_in.call(null,this$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),key], null),cache_entry);
});


untangled.client.cache_manager.CacheManager.prototype.untangled$client$cache_manager$ICacheManager$should_update_QMARK_$arity$2 = (function (this$,timestamp){
var self__ = this;
var this$__$1 = this;
return ((self__.time_last_checked + self__.debounce_freq_in_seconds) < timestamp);
});


untangled.client.cache_manager.CacheManager.prototype.untangled$client$cache_manager$ICacheManager$refresh_entries$arity$2 = (function (this$,current_time){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(this$__$1.untangled$client$cache_manager$ICacheManager$should_update_QMARK_$arity$2(null,current_time))){
var refresh_entry = ((function (this$__$1){
return (function (entry){
if(cljs.core.truth_(untangled.client.cache_manager.stale_QMARK_.call(null,entry,current_time))){
return untangled.client.cache_manager.refresh.call(null,entry,current_time);
} else {
return entry;
}
});})(this$__$1))
;
var new_entries = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (refresh_entry,this$__$1){
return (function (p__88549){
var vec__88550 = p__88549;
var k = cljs.core.nth.call(null,vec__88550,(0),null);
var entry = cljs.core.nth.call(null,vec__88550,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,refresh_entry.call(null,entry)], null);
});})(refresh_entry,this$__$1))
,self__.cache_entries));
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),new_entries);
} else {
return this$__$1;
}
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28319__auto__,k__28320__auto__){
var self__ = this;
var this__28319__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661),null,new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),null,new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),null], null), null),k__28320__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28319__auto____$1),self__.__meta),k__28320__auto__);
} else {
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,self__.time_last_checked,self__.debounce_freq_in_seconds,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28320__auto__)),null));
}
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28317__auto__,k__28318__auto__,G__88545){
var self__ = this;
var this__28317__auto____$1 = this;
var pred__88553 = cljs.core.keyword_identical_QMARK_;
var expr__88554 = k__28318__auto__;
if(cljs.core.truth_(pred__88553.call(null,new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),expr__88554))){
return (new untangled.client.cache_manager.CacheManager(G__88545,self__.time_last_checked,self__.debounce_freq_in_seconds,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88553.call(null,new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),expr__88554))){
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,G__88545,self__.debounce_freq_in_seconds,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__88553.call(null,new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661),expr__88554))){
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,self__.time_last_checked,G__88545,self__.__meta,self__.__extmap,null));
} else {
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,self__.time_last_checked,self__.debounce_freq_in_seconds,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28318__auto__,G__88545),null));
}
}
}
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28322__auto__){
var self__ = this;
var this__28322__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),self__.cache_entries],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),self__.time_last_checked],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661),self__.debounce_freq_in_seconds],null))], null),self__.__extmap));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28309__auto__,G__88545){
var self__ = this;
var this__28309__auto____$1 = this;
return (new untangled.client.cache_manager.CacheManager(self__.cache_entries,self__.time_last_checked,self__.debounce_freq_in_seconds,G__88545,self__.__extmap,self__.__hash));
});


untangled.client.cache_manager.CacheManager.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28315__auto__,entry__28316__auto__){
var self__ = this;
var this__28315__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28316__auto__)){
return this__28315__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28316__auto__,(0)),cljs.core._nth.call(null,entry__28316__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28315__auto____$1,entry__28316__auto__);
}
});

untangled.client.cache_manager.CacheManager.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache-entries","cache-entries",849953368,null),new cljs.core.Symbol(null,"time-last-checked","time-last-checked",-341299297,null),new cljs.core.Symbol(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",-2114193108,null)], null);
});

untangled.client.cache_manager.CacheManager.cljs$lang$type = true;

untangled.client.cache_manager.CacheManager.cljs$lang$ctorPrSeq = (function (this__28346__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled.client.cache-manager/CacheManager");
});

untangled.client.cache_manager.CacheManager.cljs$lang$ctorPrWriter = (function (this__28346__auto__,writer__28347__auto__){
return cljs.core._write.call(null,writer__28347__auto__,"untangled.client.cache-manager/CacheManager");
});

untangled.client.cache_manager.__GT_CacheManager = (function untangled$client$cache_manager$__GT_CacheManager(cache_entries,time_last_checked,debounce_freq_in_seconds){
return (new untangled.client.cache_manager.CacheManager(cache_entries,time_last_checked,debounce_freq_in_seconds,null,null,null));
});

untangled.client.cache_manager.map__GT_CacheManager = (function untangled$client$cache_manager$map__GT_CacheManager(G__88547){
return (new untangled.client.cache_manager.CacheManager(new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159).cljs$core$IFn$_invoke$arity$1(G__88547),new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824).cljs$core$IFn$_invoke$arity$1(G__88547),new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661).cljs$core$IFn$_invoke$arity$1(G__88547),null,cljs.core.dissoc.call(null,G__88547,new cljs.core.Keyword(null,"cache-entries","cache-entries",-790578159),new cljs.core.Keyword(null,"time-last-checked","time-last-checked",-1981830824),new cljs.core.Keyword(null,"debounce-freq-in-seconds","debounce-freq-in-seconds",540242661)),null));
});


//# sourceMappingURL=cache_manager.js.map?rel=1486510943733