// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled.client.impl.protocol_support');
goog.require('cljs.core');
goog.require('untangled_spec.core');
goog.require('cljs.test');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('om.dom');
goog.require('untangled.client.core');
/**
 * Is the given keyword a seed data tempid keyword (namespaced to `tempid`)?
 */
untangled.client.impl.protocol_support.tempid_QMARK_ = (function untangled$client$impl$protocol_support$tempid_QMARK_(kw){
return ((kw instanceof cljs.core.Keyword)) && (cljs.core._EQ_.call(null,"om.tempid",cljs.core.namespace.call(null,kw)));
});
/**
 * Rewrite tempid keywords in the given state using the tid->rid map. Leaves the keyword alone if the map
 * does not contain an entry for it.
 */
untangled.client.impl.protocol_support.rewrite_tempids = (function untangled$client$impl$protocol_support$rewrite_tempids(var_args){
var args__28863__auto__ = [];
var len__28856__auto___57076 = arguments.length;
var i__28857__auto___57077 = (0);
while(true){
if((i__28857__auto___57077 < len__28856__auto___57076)){
args__28863__auto__.push((arguments[i__28857__auto___57077]));

var G__57078 = (i__28857__auto___57077 + (1));
i__28857__auto___57077 = G__57078;
continue;
} else {
}
break;
}

var argseq__28864__auto__ = ((((2) < args__28863__auto__.length))?(new cljs.core.IndexedSeq(args__28863__auto__.slice((2)),(0),null)):null);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28864__auto__);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic = (function (state,tid__GT_rid,p__57072){
var vec__57073 = p__57072;
var pred = cljs.core.nth.call(null,vec__57073,(0),null);
return clojure.walk.prewalk.call(null,((function (vec__57073,pred){
return (function (p1__57068_SHARP_){
if(cljs.core.truth_((function (){var or__27635__auto__ = pred;
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return untangled.client.impl.protocol_support.tempid_QMARK_;
}
})().call(null,p1__57068_SHARP_))){
return cljs.core.get.call(null,tid__GT_rid,p1__57068_SHARP_,p1__57068_SHARP_);
} else {
return p1__57068_SHARP_;
}
});})(vec__57073,pred))
,state);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$maxFixedArity = (2);

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$applyTo = (function (seq57069){
var G__57070 = cljs.core.first.call(null,seq57069);
var seq57069__$1 = cljs.core.next.call(null,seq57069);
var G__57071 = cljs.core.first.call(null,seq57069__$1);
var seq57069__$2 = cljs.core.next.call(null,seq57069__$1);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic(G__57070,G__57071,seq57069__$2);
});

/**
 * Checks that `new-state` includes the `delta`, where `delta` is a map keyed by data path (as in get-in). The
 * values of `delta` are literal values to verify at that path (nil means the path should be missing).
 */
untangled.client.impl.protocol_support.check_delta = (function untangled$client$impl$protocol_support$check_delta(new_state,delta){
if(cljs.core.empty_QMARK_.call(null,delta)){
throw cljs.core.ex_info.call(null,"Cannot have empty :merge-delta",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-state","new-state",-490349212),new_state], null));
} else {
var seq__57093 = cljs.core.seq.call(null,delta);
var chunk__57094 = null;
var count__57095 = (0);
var i__57096 = (0);
while(true){
if((i__57096 < count__57095)){
var vec__57097 = cljs.core._nth.call(null,chunk__57094,i__57096);
var key_path = cljs.core.nth.call(null,vec__57097,(0),null);
var value = cljs.core.nth.call(null,vec__57097,(1),null);
var behavior_string_57107 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_57108__$1 = (function (){var or__27635__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_57107);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_57107], null));

if((value_57108__$1 instanceof RegExp)){
try{var values__40013__auto___57109 = (function (){var x__28569__auto__ = value_57108__$1;
return cljs.core._conj.call(null,(function (){var x__28569__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto____$1);
})(),x__28569__auto__);
})();
var result__40014__auto___57110 = cljs.core.apply.call(null,cljs.core.re_matches,values__40013__auto___57109);
if(cljs.core.truth_(result__40014__auto___57110)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__40013__auto___57109),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28569__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__40013__auto___57109);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e57100){var t__40051__auto___57111 = e57100;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57111,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__47874__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__47875__auto__ = value_57108__$1;
var result__47876__auto__ = cljs.core._EQ_.call(null,exp__47875__auto__,act__47874__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__47876__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__47875__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__47874__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e57101){var t__40051__auto___57112 = e57101;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57112,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_57107], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__57113 = seq__57093;
var G__57114 = chunk__57094;
var G__57115 = count__57095;
var G__57116 = (i__57096 + (1));
seq__57093 = G__57113;
chunk__57094 = G__57114;
count__57095 = G__57115;
i__57096 = G__57116;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__57093);
if(temp__6753__auto__){
var seq__57093__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57093__$1)){
var c__28546__auto__ = cljs.core.chunk_first.call(null,seq__57093__$1);
var G__57117 = cljs.core.chunk_rest.call(null,seq__57093__$1);
var G__57118 = c__28546__auto__;
var G__57119 = cljs.core.count.call(null,c__28546__auto__);
var G__57120 = (0);
seq__57093 = G__57117;
chunk__57094 = G__57118;
count__57095 = G__57119;
i__57096 = G__57120;
continue;
} else {
var vec__57102 = cljs.core.first.call(null,seq__57093__$1);
var key_path = cljs.core.nth.call(null,vec__57102,(0),null);
var value = cljs.core.nth.call(null,vec__57102,(1),null);
var behavior_string_57121 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_57122__$1 = (function (){var or__27635__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27635__auto__)){
return or__27635__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_57121);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_57121], null));

if((value_57122__$1 instanceof RegExp)){
try{var values__40013__auto___57123 = (function (){var x__28569__auto__ = value_57122__$1;
return cljs.core._conj.call(null,(function (){var x__28569__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto____$1);
})(),x__28569__auto__);
})();
var result__40014__auto___57124 = cljs.core.apply.call(null,cljs.core.re_matches,values__40013__auto___57123);
if(cljs.core.truth_(result__40014__auto___57124)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__40013__auto___57123),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28569__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__40013__auto___57123);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e57105){var t__40051__auto___57125 = e57105;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57125,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__47874__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__47875__auto__ = value_57122__$1;
var result__47876__auto__ = cljs.core._EQ_.call(null,exp__47875__auto__,act__47874__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__47876__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__47875__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__47874__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e57106){var t__40051__auto___57126 = e57106;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__40051__auto___57126,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_57121], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__57127 = cljs.core.next.call(null,seq__57093__$1);
var G__57128 = null;
var G__57129 = (0);
var G__57130 = (0);
seq__57093 = G__57127;
chunk__57094 = G__57128;
count__57095 = G__57129;
i__57096 = G__57130;
continue;
}
} else {
return null;
}
}
break;
}
}
});
untangled.client.impl.protocol_support.with_behavior = (function untangled$client$impl$protocol_support$with_behavior(behavior_string,value){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cps","value","cps/value",307453219),value,new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882),behavior_string], null);
});
untangled.client.impl.protocol_support.allocate_tempids = (function untangled$client$impl$protocol_support$allocate_tempids(tx){
var allocated_ids = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
clojure.walk.prewalk.call(null,((function (allocated_ids){
return (function (v){
if(cljs.core.truth_(untangled.client.impl.protocol_support.tempid_QMARK_.call(null,v))){
cljs.core.swap_BANG_.call(null,allocated_ids,cljs.core.conj,v);
} else {
}

return v;
});})(allocated_ids))
,tx);

return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (allocated_ids){
return (function (p1__57131_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__57131_SHARP_,om.next.tempid.call(null)],null));
});})(allocated_ids))
,cljs.core.deref.call(null,allocated_ids)));
});
/**
 * @constructor
 */
untangled.client.impl.protocol_support.Root = (function untangled$client$impl$protocol_support$Root(){
var this__45370__auto__ = this;
React.Component.apply(this__45370__auto__,arguments);

if(!((this__45370__auto__.initLocalState == null))){
this__45370__auto__.state = this__45370__auto__.initLocalState();
} else {
this__45370__auto__.state = {};
}

return this__45370__auto__;
});

untangled.client.impl.protocol_support.Root.prototype = goog.object.clone(React.Component.prototype);

var x57136_57146 = untangled.client.impl.protocol_support.Root.prototype;
x57136_57146.componentWillUpdate = ((function (x57136_57146){
return (function (next_props__45225__auto__,next_state__45226__auto__){
var this__45224__auto__ = this;
if(((!((this__45224__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__45224__auto__.om$next$Ident$)))?true:false):false)){
var ident__45228__auto___57147 = om.next.ident.call(null,this__45224__auto__,om.next.props.call(null,this__45224__auto__));
var next_ident__45229__auto___57148 = om.next.ident.call(null,this__45224__auto__,om.next._next_props.call(null,next_props__45225__auto__,this__45224__auto__));
if(cljs.core.not_EQ_.call(null,ident__45228__auto___57147,next_ident__45229__auto___57148)){
var idxr__45230__auto___57149 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__45224__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__45230__auto___57149 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__45230__auto___57149),((function (idxr__45230__auto___57149,ident__45228__auto___57147,next_ident__45229__auto___57148,this__45224__auto__,x57136_57146){
return (function (indexes__45231__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__45231__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__45228__auto___57147], null),cljs.core.disj,this__45224__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__45229__auto___57148], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__45224__auto__);
});})(idxr__45230__auto___57149,ident__45228__auto___57147,next_ident__45229__auto___57148,this__45224__auto__,x57136_57146))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__45224__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__45224__auto__);
});})(x57136_57146))
;

x57136_57146.shouldComponentUpdate = ((function (x57136_57146){
return (function (next_props__45225__auto__,next_state__45226__auto__){
var this__45224__auto__ = this;
var next_children__45227__auto__ = next_props__45225__auto__.children;
var next_props__45225__auto____$1 = goog.object.get(next_props__45225__auto__,"omcljs$value");
var next_props__45225__auto____$2 = (function (){var G__57138 = next_props__45225__auto____$1;
if((next_props__45225__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__57138);
} else {
return G__57138;
}
})();
var or__27635__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__45224__auto__),next_props__45225__auto____$2);
if(or__27635__auto__){
return or__27635__auto__;
} else {
var or__27635__auto____$1 = (function (){var and__27623__auto__ = this__45224__auto__.state;
if(cljs.core.truth_(and__27623__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__45224__auto__.state,"omcljs$state"),goog.object.get(next_state__45226__auto__,"omcljs$state"));
} else {
return and__27623__auto__;
}
})();
if(cljs.core.truth_(or__27635__auto____$1)){
return or__27635__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__45224__auto__.props.children,next_children__45227__auto__);
}
}
});})(x57136_57146))
;

x57136_57146.componentWillUnmount = ((function (x57136_57146){
return (function (){
var this__45224__auto__ = this;
var r__45235__auto__ = om.next.get_reconciler.call(null,this__45224__auto__);
var cfg__45236__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__45235__auto__);
var st__45237__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__45236__auto__);
var indexer__45234__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__45236__auto__);
if(cljs.core.truth_((function (){var and__27623__auto__ = !((st__45237__auto__ == null));
if(and__27623__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__45237__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__45224__auto__], null));
} else {
return and__27623__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__45237__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__45224__auto__);
} else {
}

if((indexer__45234__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__45234__auto__,this__45224__auto__);
}
});})(x57136_57146))
;

x57136_57146.componentDidUpdate = ((function (x57136_57146){
return (function (prev_props__45232__auto__,prev_state__45233__auto__){
var this__45224__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__45224__auto__);
});})(x57136_57146))
;

x57136_57146.isMounted = ((function (x57136_57146){
return (function (){
var this__45224__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__45224__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x57136_57146))
;

x57136_57146.componentWillMount = ((function (x57136_57146){
return (function (){
var this__45224__auto__ = this;
var indexer__45234__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__45224__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__45234__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__45234__auto__,this__45224__auto__);
}
});})(x57136_57146))
;

x57136_57146.render = ((function (x57136_57146){
return (function (){
var this__45223__auto__ = this;
var this$ = this__45223__auto__;
var _STAR_reconciler_STAR_57139 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_57140 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_57141 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_57142 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_57143 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__45223__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__45223__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__45223__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__45223__auto__);

om.next._STAR_parent_STAR_ = this__45223__auto__;

try{return om.dom.div.call(null,null,"if you see this something is wrong");
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_57143;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_57142;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_57141;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_57140;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_57139;
}});})(x57136_57146))
;


untangled.client.impl.protocol_support.Root.prototype.constructor = untangled.client.impl.protocol_support.Root;

untangled.client.impl.protocol_support.Root.prototype.constructor.displayName = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.prototype.om$isComponent = true;

var x57144_57150 = untangled.client.impl.protocol_support.Root;
/** @nocollapse */
x57144_57150.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x57144_57150.om$next$IQuery$query$arity$1 = ((function (x57144_57150){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x57144_57150))
;


var x57145_57151 = untangled.client.impl.protocol_support.Root.prototype;

x57145_57151.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x57145_57151.om$next$IQuery$query$arity$1 = ((function (x57145_57151){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x57145_57151))
;


untangled.client.impl.protocol_support.Root.cljs$lang$type = true;

untangled.client.impl.protocol_support.Root.cljs$lang$ctorStr = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.cljs$lang$ctorPrWriter = (function (this__45373__auto__,writer__45374__auto__,opt__45375__auto__){
return cljs.core._write.call(null,writer__45374__auto__,"untangled.client.impl.protocol-support/Root");
});
untangled.client.impl.protocol_support.init_testing = (function untangled$client$impl$protocol_support$init_testing(){
return untangled.client.core.mount.call(null,untangled.client.core.new_untangled_test_client.call(null),untangled.client.impl.protocol_support.Root,"invisible-specs");
});

//# sourceMappingURL=protocol_support.js.map?rel=1486703217559