// Compiled by ClojureScript 1.9.456 {}
goog.provide('untangled_spec.reporters.impl.suite');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('goog.dom');
goog.require('om.next');
goog.require('untangled_spec.reporters.browser');
goog.require('untangled_spec.reporters.impl.base_reporter');
goog.require('bidi.bidi');
goog.require('pushy.core');
cljs.core.enable_console_print_BANG_.call(null);

/**
 * @interface
 */
untangled_spec.reporters.impl.suite.ITest = function(){};

/**
 * Render the test results to the DOM
 */
untangled_spec.reporters.impl.suite.render_tests = (function untangled_spec$reporters$impl$suite$render_tests(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$render_tests$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$render_tests$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.render_tests[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.render_tests["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.render-tests",this$);
}
}
}
});

/**
 * Set the pass/fail/error result of a test
 */
untangled_spec.reporters.impl.suite.set_test_result = (function untangled_spec$reporters$impl$suite$set_test_result(this$,status){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$set_test_result$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$set_test_result$arity$2(this$,status);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.set_test_result[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,status);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.set_test_result["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,status);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.set-test-result",this$);
}
}
}
});

/**
 * Tests are reporting that they passed
 */
untangled_spec.reporters.impl.suite.pass = (function untangled_spec$reporters$impl$suite$pass(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$pass$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$pass$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.pass[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.pass["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.pass",this$);
}
}
}
});

/**
 * Tests are reporting that they failed, with additional details
 */
untangled_spec.reporters.impl.suite.fail = (function untangled_spec$reporters$impl$suite$fail(this$,detail){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$fail$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$fail$arity$2(this$,detail);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.fail[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,detail);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.fail["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,detail);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.fail",this$);
}
}
}
});

/**
 * Tests are reporting that they error'ed, with additional details
 */
untangled_spec.reporters.impl.suite.error = (function untangled_spec$reporters$impl$suite$error(this$,detail){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$error$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$error$arity$2(this$,detail);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.error[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,detail);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.error["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,detail);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.error",this$);
}
}
}
});

/**
 * A summary of the test run, how many passed/failed/error'ed
 */
untangled_spec.reporters.impl.suite.summary = (function untangled_spec$reporters$impl$suite$summary(this$,stats){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$summary$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$summary$arity$2(this$,stats);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.summary[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,stats);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.summary["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,stats);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.summary",this$);
}
}
}
});

/**
 * Manual test
 */
untangled_spec.reporters.impl.suite.begin_manual = (function untangled_spec$reporters$impl$suite$begin_manual(this$,behavior){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$begin_manual$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$begin_manual$arity$2(this$,behavior);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.begin_manual[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,behavior);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.begin_manual["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,behavior);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.begin-manual",this$);
}
}
}
});

/**
 * Manual test
 */
untangled_spec.reporters.impl.suite.end_manual = (function untangled_spec$reporters$impl$suite$end_manual(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$end_manual$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$end_manual$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.end_manual[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.end_manual["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.end-manual",this$);
}
}
}
});

/**
 * Tests are reporting the start of a behavior
 */
untangled_spec.reporters.impl.suite.begin_behavior = (function untangled_spec$reporters$impl$suite$begin_behavior(this$,behavior){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$begin_behavior$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$begin_behavior$arity$2(this$,behavior);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.begin_behavior[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,behavior);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.begin_behavior["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,behavior);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.begin-behavior",this$);
}
}
}
});

/**
 * Tests are reporting the end of a behavior
 */
untangled_spec.reporters.impl.suite.end_behavior = (function untangled_spec$reporters$impl$suite$end_behavior(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$end_behavior$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$end_behavior$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.end_behavior[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.end_behavior["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.end-behavior",this$);
}
}
}
});

/**
 * Tests are reporting the start of a provided
 */
untangled_spec.reporters.impl.suite.begin_provided = (function untangled_spec$reporters$impl$suite$begin_provided(this$,behavior){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$begin_provided$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$begin_provided$arity$2(this$,behavior);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.begin_provided[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,behavior);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.begin_provided["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,behavior);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.begin-provided",this$);
}
}
}
});

/**
 * Tests are reporting the end of a provided
 */
untangled_spec.reporters.impl.suite.end_provided = (function untangled_spec$reporters$impl$suite$end_provided(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$end_provided$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$end_provided$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.end_provided[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.end_provided["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.end-provided",this$);
}
}
}
});

/**
 * Tests are reporting the start of a specification
 */
untangled_spec.reporters.impl.suite.begin_specification = (function untangled_spec$reporters$impl$suite$begin_specification(this$,spec){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$begin_specification$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$begin_specification$arity$2(this$,spec);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.begin_specification[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,spec);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.begin_specification["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,spec);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.begin-specification",this$);
}
}
}
});

/**
 * Tests are reporting the end of a specification
 */
untangled_spec.reporters.impl.suite.end_specification = (function untangled_spec$reporters$impl$suite$end_specification(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$end_specification$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$end_specification$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.end_specification[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.end_specification["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.end-specification",this$);
}
}
}
});

/**
 * Tests are reporting the start of a namespace
 */
untangled_spec.reporters.impl.suite.begin_namespace = (function untangled_spec$reporters$impl$suite$begin_namespace(this$,name){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$begin_namespace$arity$2 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$begin_namespace$arity$2(this$,name);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.begin_namespace[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,name);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.begin_namespace["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,name);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.begin-namespace",this$);
}
}
}
});

/**
 * Push a new test items onto the test item path
 */
untangled_spec.reporters.impl.suite.push_test_item_path = (function untangled_spec$reporters$impl$suite$push_test_item_path(this$,test_item,index){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3(this$,test_item,index);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.push_test_item_path[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$,test_item,index);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.push_test_item_path["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$,test_item,index);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.push-test-item-path",this$);
}
}
}
});

/**
 * Pops the last test item off of the test item path
 */
untangled_spec.reporters.impl.suite.pop_test_item_path = (function untangled_spec$reporters$impl$suite$pop_test_item_path(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1 == null)))){
return this$.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1(this$);
} else {
var x__28353__auto__ = (((this$ == null))?null:this$);
var m__28354__auto__ = (untangled_spec.reporters.impl.suite.pop_test_item_path[goog.typeOf(x__28353__auto__)]);
if(!((m__28354__auto__ == null))){
return m__28354__auto__.call(null,this$);
} else {
var m__28354__auto____$1 = (untangled_spec.reporters.impl.suite.pop_test_item_path["_"]);
if(!((m__28354__auto____$1 == null))){
return m__28354__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ITest.pop-test-item-path",this$);
}
}
}
});

untangled_spec.reporters.impl.suite.find_first = (function untangled_spec$reporters$impl$suite$find_first(pred,coll){
return cljs.core.first.call(null,cljs.core.filter.call(null,pred,coll));
});
untangled_spec.reporters.impl.suite.checked_index = (function untangled_spec$reporters$impl$suite$checked_index(items,index,id_keyword,value){
var index_valid_QMARK_ = (cljs.core.count.call(null,items) > index);
var proposed_item = ((index_valid_QMARK_)?cljs.core.get.call(null,items,index):null);
if(cljs.core.truth_((function (){var and__27623__auto__ = proposed_item;
if(cljs.core.truth_(and__27623__auto__)){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,proposed_item,id_keyword));
} else {
return and__27623__auto__;
}
})())){
return index;
} else {
return cljs.core.first.call(null,untangled_spec.reporters.impl.suite.find_first.call(null,((function (index_valid_QMARK_,proposed_item){
return (function (p1__70409_SHARP_){
return cljs.core._EQ_.call(null,value,id_keyword.call(null,cljs.core.second.call(null,p1__70409_SHARP_)));
});})(index_valid_QMARK_,proposed_item))
,cljs.core.map_indexed.call(null,cljs.core.vector,items)));

}
});
untangled_spec.reporters.impl.suite.path_ele_length = (4);
untangled_spec.reporters.impl.suite.resolve_data_path = (function untangled_spec$reporters$impl$suite$resolve_data_path(state,path_seq){
return cljs.core.reduce.call(null,(function (real_path,path_ele){
if(cljs.core.sequential_QMARK_.call(null,path_ele)){
if(cljs.core.not_EQ_.call(null,untangled_spec.reporters.impl.suite.path_ele_length,cljs.core.count.call(null,path_ele))){
return console.log("ERROR: VECTOR BASED DATA ACCESS MUST HAVE A 4-TUPLE KEY");
} else {
var vector_key = cljs.core.first.call(null,path_ele);
var state_vector = cljs.core.get_in.call(null,state,cljs.core.conj.call(null,real_path,vector_key));
var lookup_function = cljs.core.second.call(null,path_ele);
var target_value = cljs.core.nth.call(null,path_ele,(2));
var proposed_index = cljs.core.nth.call(null,path_ele,(3));
var index = untangled_spec.reporters.impl.suite.checked_index.call(null,state_vector,proposed_index,lookup_function,target_value);
if(cljs.core.truth_(index)){
return cljs.core.conj.call(null,real_path,vector_key,index);
} else {
console.log("ERROR: NO ITEM FOUND AT DATA PATH");

cljs.pprint.pprint.call(null,path_seq);

return real_path;
}
}
} else {
return cljs.core.conj.call(null,real_path,path_ele);
}
}),cljs.core.PersistentVector.EMPTY,path_seq);
});
untangled_spec.reporters.impl.suite.translate_item_path = (function untangled_spec$reporters$impl$suite$translate_item_path(app_state,test_item_path){
var data = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_state));
var path = test_item_path;
var result = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961)], null);
while(true){
if(cljs.core.empty_QMARK_.call(null,path)){
return result;
} else {
var resolved_path = untangled_spec.reporters.impl.suite.resolve_data_path.call(null,data,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.seq.call(null,cljs.core.take.call(null,untangled_spec.reporters.impl.suite.path_ele_length,path))],null)));
var context_data = cljs.core.get_in.call(null,data,resolved_path);
var G__70410 = context_data;
var G__70411 = cljs.core.drop.call(null,untangled_spec.reporters.impl.suite.path_ele_length,path);
var G__70412 = cljs.core.concat.call(null,result,resolved_path);
data = G__70410;
path = G__70411;
result = G__70412;
continue;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {untangled_spec.reporters.impl.suite.ITest}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.reporters.impl.suite.TestSuite = (function (app_state,dom_target,reconciler,renderer,test_item_path,__meta,__extmap,__hash){
this.app_state = app_state;
this.dom_target = dom_target;
this.reconciler = reconciler;
this.renderer = renderer;
this.test_item_path = test_item_path;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28310__auto__,k__28311__auto__){
var self__ = this;
var this__28310__auto____$1 = this;
return this__28310__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28311__auto__,null);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28312__auto__,k70415,else__28313__auto__){
var self__ = this;
var this__28312__auto____$1 = this;
var G__70417 = (((k70415 instanceof cljs.core.Keyword))?k70415.fqn:null);
switch (G__70417) {
case "app-state":
return self__.app_state;

break;
case "dom-target":
return self__.dom_target;

break;
case "reconciler":
return self__.reconciler;

break;
case "renderer":
return self__.renderer;

break;
case "test-item-path":
return self__.test_item_path;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k70415,else__28313__auto__);

}
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28324__auto__,writer__28325__auto__,opts__28326__auto__){
var self__ = this;
var this__28324__auto____$1 = this;
var pr_pair__28327__auto__ = ((function (this__28324__auto____$1){
return (function (keyval__28328__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,cljs.core.pr_writer,""," ","",opts__28326__auto__,keyval__28328__auto__);
});})(this__28324__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28325__auto__,pr_pair__28327__auto__,"#untangled-spec.reporters.impl.suite.TestSuite{",", ","}",opts__28326__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"app-state","app-state",-1509963278),self__.app_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dom-target","dom-target",893283431),self__.dom_target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),self__.reconciler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"renderer","renderer",336841071),self__.renderer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311),self__.test_item_path],null))], null),self__.__extmap));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__70414){
var self__ = this;
var G__70414__$1 = this;
return (new cljs.core.RecordIter((0),G__70414__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"app-state","app-state",-1509963278),new cljs.core.Keyword(null,"dom-target","dom-target",893283431),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"renderer","renderer",336841071),new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28308__auto__){
var self__ = this;
var this__28308__auto____$1 = this;
return self__.__meta;
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28304__auto__){
var self__ = this;
var this__28304__auto____$1 = this;
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,self__.renderer,self__.test_item_path,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28314__auto__){
var self__ = this;
var this__28314__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28305__auto__){
var self__ = this;
var this__28305__auto____$1 = this;
var h__28077__auto__ = self__.__hash;
if(!((h__28077__auto__ == null))){
return h__28077__auto__;
} else {
var h__28077__auto____$1 = cljs.core.hash_imap.call(null,this__28305__auto____$1);
self__.__hash = h__28077__auto____$1;

return h__28077__auto____$1;
}
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__28306__auto__,other__28307__auto__){
var self__ = this;
var this__28306__auto____$1 = this;
if(cljs.core.truth_((function (){var and__27623__auto__ = other__28307__auto__;
if(cljs.core.truth_(and__27623__auto__)){
return ((this__28306__auto____$1.constructor === other__28307__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__28306__auto____$1,other__28307__auto__));
} else {
return and__27623__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28319__auto__,k__28320__auto__){
var self__ = this;
var this__28319__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"dom-target","dom-target",893283431),null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),null,new cljs.core.Keyword(null,"renderer","renderer",336841071),null,new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311),null,new cljs.core.Keyword(null,"app-state","app-state",-1509963278),null], null), null),k__28320__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28319__auto____$1),self__.__meta),k__28320__auto__);
} else {
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,self__.renderer,self__.test_item_path,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28320__auto__)),null));
}
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28317__auto__,k__28318__auto__,G__70414){
var self__ = this;
var this__28317__auto____$1 = this;
var pred__70418 = cljs.core.keyword_identical_QMARK_;
var expr__70419 = k__28318__auto__;
if(cljs.core.truth_(pred__70418.call(null,new cljs.core.Keyword(null,"app-state","app-state",-1509963278),expr__70419))){
return (new untangled_spec.reporters.impl.suite.TestSuite(G__70414,self__.dom_target,self__.reconciler,self__.renderer,self__.test_item_path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70418.call(null,new cljs.core.Keyword(null,"dom-target","dom-target",893283431),expr__70419))){
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,G__70414,self__.reconciler,self__.renderer,self__.test_item_path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70418.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),expr__70419))){
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,G__70414,self__.renderer,self__.test_item_path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70418.call(null,new cljs.core.Keyword(null,"renderer","renderer",336841071),expr__70419))){
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,G__70414,self__.test_item_path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70418.call(null,new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311),expr__70419))){
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,self__.renderer,G__70414,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,self__.renderer,self__.test_item_path,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28318__auto__,G__70414),null));
}
}
}
}
}
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28322__auto__){
var self__ = this;
var this__28322__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"app-state","app-state",-1509963278),self__.app_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dom-target","dom-target",893283431),self__.dom_target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),self__.reconciler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"renderer","renderer",336841071),self__.renderer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311),self__.test_item_path],null))], null),self__.__extmap));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$pass$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.untangled_spec$reporters$impl$suite$ITest$set_test_result$arity$2(null,new cljs.core.Keyword(null,"passed","passed",-28165278));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$end_provided$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1(null);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$render_tests$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return om.next.add_root_BANG_.call(null,self__.reconciler,self__.renderer,goog.dom.getElement(self__.dom_target));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$begin_behavior$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var path = untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path));
var vec__70421 = untangled_spec.reporters.impl.base_reporter.begin.call(null,x,self__.app_state,path);
var test_item = cljs.core.nth.call(null,vec__70421,(0),null);
var test_items_count = cljs.core.nth.call(null,vec__70421,(1),null);
return this$__$1.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3(null,test_item,test_items_count);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3 = (function (this$,test_item,index){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.test_item_path,cljs.core.conj,new cljs.core.Keyword(null,"test-items","test-items",1900391985),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(test_item),index);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$begin_provided$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var path = untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path));
var vec__70424 = untangled_spec.reporters.impl.base_reporter.begin.call(null,x,self__.app_state,path);
var test_item = cljs.core.nth.call(null,vec__70424,(0),null);
var test_items_count = cljs.core.nth.call(null,vec__70424,(1),null);
return this$__$1.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3(null,test_item,test_items_count);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$begin_specification$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var path = untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path));
var vec__70427 = untangled_spec.reporters.impl.base_reporter.begin.call(null,x,self__.app_state,path);
var test_item = cljs.core.nth.call(null,vec__70427,(0),null);
var test_items_count = cljs.core.nth.call(null,vec__70427,(1),null);
return this$__$1.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3(null,test_item,test_items_count);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$end_behavior$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1(null);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.test_item_path,cljs.core.apply.call(null,cljs.core.comp,cljs.core.repeat.call(null,untangled_spec.reporters.impl.suite.path_ele_length,cljs.core.pop)));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$summary$arity$2 = (function (this$,stats){
var self__ = this;
var this$__$1 = this;
return untangled_spec.reporters.impl.base_reporter.summary.call(null,stats,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961)], null),self__.app_state);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$end_manual$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
this$__$1.untangled_spec$reporters$impl$suite$ITest$set_test_result$arity$2(null,new cljs.core.Keyword(null,"manual","manual",-237370608));

return this$__$1.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1(null);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$begin_manual$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var path = untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path));
var vec__70430 = untangled_spec.reporters.impl.base_reporter.begin.call(null,x,self__.app_state,path);
var test_item = cljs.core.nth.call(null,vec__70430,(0),null);
var test_items_count = cljs.core.nth.call(null,vec__70430,(1),null);
return this$__$1.untangled_spec$reporters$impl$suite$ITest$push_test_item_path$arity$3(null,test_item,test_items_count);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$fail$arity$2 = (function (this$,detail){
var self__ = this;
var this$__$1 = this;
return untangled_spec.reporters.impl.base_reporter.fail.call(null,detail,self__.app_state,untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path)));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$begin_namespace$arity$2 = (function (this$,name){
var self__ = this;
var this$__$1 = this;
var namespaces = cljs.core.get_in.call(null,cljs.core.deref.call(null,self__.app_state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)], null));
var name_space_location = untangled_spec.reporters.impl.base_reporter.get_namespace_location.call(null,namespaces,name);
cljs.core.reset_BANG_.call(null,self__.test_item_path,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.Keyword(null,"name","name",1843675177),name,name_space_location], null));

return cljs.core.swap_BANG_.call(null,self__.app_state,((function (namespaces,name_space_location,this$__$1){
return (function (p1__70413_SHARP_){
return cljs.core.assoc_in.call(null,p1__70413_SHARP_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),name_space_location], null),untangled_spec.reporters.impl.base_reporter.make_tests_by_namespace.call(null,name));
});})(namespaces,name_space_location,this$__$1))
);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$set_test_result$arity$2 = (function (this$,status){
var self__ = this;
var this$__$1 = this;
return untangled_spec.reporters.impl.base_reporter.set_test_result.call(null,self__.app_state,untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path)),status);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$end_specification$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.untangled_spec$reporters$impl$suite$ITest$pop_test_item_path$arity$1(null);
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.untangled_spec$reporters$impl$suite$ITest$error$arity$2 = (function (this$,detail){
var self__ = this;
var this$__$1 = this;
return untangled_spec.reporters.impl.base_reporter.error.call(null,detail,self__.app_state,untangled_spec.reporters.impl.suite.translate_item_path.call(null,self__.app_state,cljs.core.deref.call(null,self__.test_item_path)));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28309__auto__,G__70414){
var self__ = this;
var this__28309__auto____$1 = this;
return (new untangled_spec.reporters.impl.suite.TestSuite(self__.app_state,self__.dom_target,self__.reconciler,self__.renderer,self__.test_item_path,G__70414,self__.__extmap,self__.__hash));
});


untangled_spec.reporters.impl.suite.TestSuite.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28315__auto__,entry__28316__auto__){
var self__ = this;
var this__28315__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28316__auto__)){
return this__28315__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28316__auto__,(0)),cljs.core._nth.call(null,entry__28316__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28315__auto____$1,entry__28316__auto__);
}
});

untangled_spec.reporters.impl.suite.TestSuite.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"dom-target","dom-target",-1761152338,null),new cljs.core.Symbol(null,"reconciler","reconciler",-192295439,null),new cljs.core.Symbol(null,"renderer","renderer",1977372598,null),new cljs.core.Symbol(null,"test-item-path","test-item-path",317340216,null)], null);
});

untangled_spec.reporters.impl.suite.TestSuite.cljs$lang$type = true;

untangled_spec.reporters.impl.suite.TestSuite.cljs$lang$ctorPrSeq = (function (this__28346__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.reporters.impl.suite/TestSuite");
});

untangled_spec.reporters.impl.suite.TestSuite.cljs$lang$ctorPrWriter = (function (this__28346__auto__,writer__28347__auto__){
return cljs.core._write.call(null,writer__28347__auto__,"untangled-spec.reporters.impl.suite/TestSuite");
});

untangled_spec.reporters.impl.suite.__GT_TestSuite = (function untangled_spec$reporters$impl$suite$__GT_TestSuite(app_state,dom_target,reconciler,renderer,test_item_path){
return (new untangled_spec.reporters.impl.suite.TestSuite(app_state,dom_target,reconciler,renderer,test_item_path,null,null,null));
});

untangled_spec.reporters.impl.suite.map__GT_TestSuite = (function untangled_spec$reporters$impl$suite$map__GT_TestSuite(G__70416){
return (new untangled_spec.reporters.impl.suite.TestSuite(new cljs.core.Keyword(null,"app-state","app-state",-1509963278).cljs$core$IFn$_invoke$arity$1(G__70416),new cljs.core.Keyword(null,"dom-target","dom-target",893283431).cljs$core$IFn$_invoke$arity$1(G__70416),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(G__70416),new cljs.core.Keyword(null,"renderer","renderer",336841071).cljs$core$IFn$_invoke$arity$1(G__70416),new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311).cljs$core$IFn$_invoke$arity$1(G__70416),null,cljs.core.dissoc.call(null,G__70416,new cljs.core.Keyword(null,"app-state","app-state",-1509963278),new cljs.core.Keyword(null,"dom-target","dom-target",893283431),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"renderer","renderer",336841071),new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311)),null));
});

untangled_spec.reporters.impl.suite.om_read = (function untangled_spec$reporters$impl$suite$om_read(p__70434,key,_){
var map__70437 = p__70434;
var map__70437__$1 = ((((!((map__70437 == null)))?((((map__70437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70437.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70437):map__70437);
var state = cljs.core.get.call(null,map__70437__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,cljs.core.deref.call(null,state),key)], null);
});
if(typeof untangled_spec.reporters.impl.suite.om_write !== 'undefined'){
} else {
untangled_spec.reporters.impl.suite.om_write = (function (){var method_table__28666__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__28667__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__28668__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__28669__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__28670__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"untangled-spec.reporters.impl.suite","om-write"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__28670__auto__,method_table__28666__auto__,prefer_table__28667__auto__,method_cache__28668__auto__,cached_hierarchy__28669__auto__));
})();
}
cljs.core._add_method.call(null,untangled_spec.reporters.impl.suite.om_write,new cljs.core.Symbol(null,"set-filter","set-filter",-497127889,null),(function (p__70439,_,p__70440){
var map__70441 = p__70439;
var map__70441__$1 = ((((!((map__70441 == null)))?((((map__70441.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70441.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70441):map__70441);
var state = cljs.core.get.call(null,map__70441__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var map__70442 = p__70440;
var map__70442__$1 = ((((!((map__70442 == null)))?((((map__70442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70442.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70442):map__70442);
var new_filter = cljs.core.get.call(null,map__70442__$1,new cljs.core.Keyword(null,"new-filter","new-filter",452225696));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("report","filter","report/filter",2140776550),new_filter);
}));
untangled_spec.reporters.impl.suite.test_parser = om.next.parser.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read","read",1140058661),untangled_spec.reporters.impl.suite.om_read,new cljs.core.Keyword(null,"mutate","mutate",1422419038),untangled_spec.reporters.impl.suite.om_write], null));
untangled_spec.reporters.impl.suite.app_routes = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["",new cljs.core.PersistentArrayMap(null, 3, ["failed",new cljs.core.Keyword(null,"failed","failed",-1397425762),"all",new cljs.core.Keyword(null,"all","all",892129742),"manual",new cljs.core.Keyword(null,"manual","manual",-237370608)], null)], null);
untangled_spec.reporters.impl.suite.set_page_BANG_ = (function untangled_spec$reporters$impl$suite$set_page_BANG_(reconciler){
return (function (new_filter){
return om.next.transact_BANG_.call(null,reconciler,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28569__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set-filter","set-filter",-497127889,null)),(function (){var x__28569__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-filter","new-filter",452225696),new_filter], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28569__auto__);
})())))));
});
});
untangled_spec.reporters.impl.suite.new_test_suite = (function untangled_spec$reporters$impl$suite$new_test_suite(target){
var state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"top","top",-1856271961),untangled_spec.reporters.impl.base_reporter.make_testreport.call(null),new cljs.core.Keyword("report","filter","report/filter",2140776550),new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"time","time",1385887882),(new Date())], null));
var reconciler = om.next.reconciler.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"parser","parser",-1543495310),untangled_spec.reporters.impl.suite.test_parser], null));
var history = (function (){var update_history_BANG_70448 = pushy.core.update_history_BANG_;
pushy.core.update_history_BANG_ = ((function (update_history_BANG_70448,state,reconciler){
return (function (p1__70445_SHARP_){
var G__70449 = p1__70445_SHARP_;
G__70449.setUseFragment(true);

G__70449.setPathPrefix("");

G__70449.setEnabled(true);

return G__70449;
});})(update_history_BANG_70448,state,reconciler))
;

try{return pushy.core.pushy.call(null,untangled_spec.reporters.impl.suite.set_page_BANG_.call(null,reconciler),cljs.core.partial.call(null,bidi.bidi.match_route,untangled_spec.reporters.impl.suite.app_routes),new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),new cljs.core.Keyword(null,"handler","handler",-195596612));
}finally {pushy.core.update_history_BANG_ = update_history_BANG_70448;
}})();
pushy.core.start_BANG_.call(null,history);

return untangled_spec.reporters.impl.suite.map__GT_TestSuite.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"app-state","app-state",-1509963278),state,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler,new cljs.core.Keyword(null,"renderer","renderer",336841071),untangled_spec.reporters.browser.TestReport,new cljs.core.Keyword(null,"dom-target","dom-target",893283431),target,new cljs.core.Keyword(null,"test-item-path","test-item-path",-1323191311),cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY)], null));
});

//# sourceMappingURL=suite.js.map?rel=1486510911391