// Compiled by ClojureScript 1.9.473 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args42662 = [];
var len__8723__auto___42668 = arguments.length;
var i__8724__auto___42669 = (0);
while(true){
if((i__8724__auto___42669 < len__8723__auto___42668)){
args42662.push((arguments[i__8724__auto___42669]));

var G__42670 = (i__8724__auto___42669 + (1));
i__8724__auto___42669 = G__42670;
continue;
} else {
}
break;
}

var G__42664 = args42662.length;
switch (G__42664) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42662.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async42665 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42665 = (function (f,blockable,meta42666){
this.f = f;
this.blockable = blockable;
this.meta42666 = meta42666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42667,meta42666__$1){
var self__ = this;
var _42667__$1 = this;
return (new cljs.core.async.t_cljs$core$async42665(self__.f,self__.blockable,meta42666__$1));
});


cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42667){
var self__ = this;
var _42667__$1 = this;
return self__.meta42666;
});


cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async42665.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async42665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42666","meta42666",653924708,null)], null);
});

cljs.core.async.t_cljs$core$async42665.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42665";

cljs.core.async.t_cljs$core$async42665.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async42665");
});

cljs.core.async.__GT_t_cljs$core$async42665 = (function cljs$core$async$__GT_t_cljs$core$async42665(f__$1,blockable__$1,meta42666){
return (new cljs.core.async.t_cljs$core$async42665(f__$1,blockable__$1,meta42666));
});

}

return (new cljs.core.async.t_cljs$core$async42665(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args42674 = [];
var len__8723__auto___42677 = arguments.length;
var i__8724__auto___42678 = (0);
while(true){
if((i__8724__auto___42678 < len__8723__auto___42677)){
args42674.push((arguments[i__8724__auto___42678]));

var G__42679 = (i__8724__auto___42678 + (1));
i__8724__auto___42678 = G__42679;
continue;
} else {
}
break;
}

var G__42676 = args42674.length;
switch (G__42676) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42674.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args42681 = [];
var len__8723__auto___42684 = arguments.length;
var i__8724__auto___42685 = (0);
while(true){
if((i__8724__auto___42685 < len__8723__auto___42684)){
args42681.push((arguments[i__8724__auto___42685]));

var G__42686 = (i__8724__auto___42685 + (1));
i__8724__auto___42685 = G__42686;
continue;
} else {
}
break;
}

var G__42683 = args42681.length;
switch (G__42683) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42681.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args42688 = [];
var len__8723__auto___42691 = arguments.length;
var i__8724__auto___42692 = (0);
while(true){
if((i__8724__auto___42692 < len__8723__auto___42691)){
args42688.push((arguments[i__8724__auto___42692]));

var G__42693 = (i__8724__auto___42692 + (1));
i__8724__auto___42692 = G__42693;
continue;
} else {
}
break;
}

var G__42690 = args42688.length;
switch (G__42690) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42688.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_42695 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_42695);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_42695,ret){
return (function (){
return fn1.call(null,val_42695);
});})(val_42695,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args42696 = [];
var len__8723__auto___42699 = arguments.length;
var i__8724__auto___42700 = (0);
while(true){
if((i__8724__auto___42700 < len__8723__auto___42699)){
args42696.push((arguments[i__8724__auto___42700]));

var G__42701 = (i__8724__auto___42700 + (1));
i__8724__auto___42700 = G__42701;
continue;
} else {
}
break;
}

var G__42698 = args42696.length;
switch (G__42698) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42696.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8523__auto___42703 = n;
var x_42704 = (0);
while(true){
if((x_42704 < n__8523__auto___42703)){
(a[x_42704] = (0));

var G__42705 = (x_42704 + (1));
x_42704 = G__42705;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__42706 = (i + (1));
i = G__42706;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async42710 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42710 = (function (flag,meta42711){
this.flag = flag;
this.meta42711 = meta42711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_42712,meta42711__$1){
var self__ = this;
var _42712__$1 = this;
return (new cljs.core.async.t_cljs$core$async42710(self__.flag,meta42711__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_42712){
var self__ = this;
var _42712__$1 = this;
return self__.meta42711;
});})(flag))
;


cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async42710.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async42710.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42711","meta42711",381609260,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async42710.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42710";

cljs.core.async.t_cljs$core$async42710.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async42710");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async42710 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42710(flag__$1,meta42711){
return (new cljs.core.async.t_cljs$core$async42710(flag__$1,meta42711));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async42710(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async42716 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42716 = (function (flag,cb,meta42717){
this.flag = flag;
this.cb = cb;
this.meta42717 = meta42717;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42718,meta42717__$1){
var self__ = this;
var _42718__$1 = this;
return (new cljs.core.async.t_cljs$core$async42716(self__.flag,self__.cb,meta42717__$1));
});


cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42718){
var self__ = this;
var _42718__$1 = this;
return self__.meta42717;
});


cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async42716.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async42716.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42717","meta42717",-1897946694,null)], null);
});

cljs.core.async.t_cljs$core$async42716.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42716.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42716";

cljs.core.async.t_cljs$core$async42716.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async42716");
});

cljs.core.async.__GT_t_cljs$core$async42716 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42716(flag__$1,cb__$1,meta42717){
return (new cljs.core.async.t_cljs$core$async42716(flag__$1,cb__$1,meta42717));
});

}

return (new cljs.core.async.t_cljs$core$async42716(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42719_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42719_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42720_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42720_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7502__auto__ = wport;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return port;
}
})()], null));
} else {
var G__42721 = (i + (1));
i = G__42721;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7502__auto__ = ret;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__7490__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___42727 = arguments.length;
var i__8724__auto___42728 = (0);
while(true){
if((i__8724__auto___42728 < len__8723__auto___42727)){
args__8730__auto__.push((arguments[i__8724__auto___42728]));

var G__42729 = (i__8724__auto___42728 + (1));
i__8724__auto___42728 = G__42729;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42724){
var map__42725 = p__42724;
var map__42725__$1 = ((((!((map__42725 == null)))?((((map__42725.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42725.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42725):map__42725);
var opts = map__42725__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42722){
var G__42723 = cljs.core.first.call(null,seq42722);
var seq42722__$1 = cljs.core.next.call(null,seq42722);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42723,seq42722__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args42730 = [];
var len__8723__auto___42780 = arguments.length;
var i__8724__auto___42781 = (0);
while(true){
if((i__8724__auto___42781 < len__8723__auto___42780)){
args42730.push((arguments[i__8724__auto___42781]));

var G__42782 = (i__8724__auto___42781 + (1));
i__8724__auto___42781 = G__42782;
continue;
} else {
}
break;
}

var G__42732 = args42730.length;
switch (G__42732) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args42730.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42603__auto___42784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___42784){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___42784){
return (function (state_42756){
var state_val_42757 = (state_42756[(1)]);
if((state_val_42757 === (7))){
var inst_42752 = (state_42756[(2)]);
var state_42756__$1 = state_42756;
var statearr_42758_42785 = state_42756__$1;
(statearr_42758_42785[(2)] = inst_42752);

(statearr_42758_42785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (1))){
var state_42756__$1 = state_42756;
var statearr_42759_42786 = state_42756__$1;
(statearr_42759_42786[(2)] = null);

(statearr_42759_42786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (4))){
var inst_42735 = (state_42756[(7)]);
var inst_42735__$1 = (state_42756[(2)]);
var inst_42736 = (inst_42735__$1 == null);
var state_42756__$1 = (function (){var statearr_42760 = state_42756;
(statearr_42760[(7)] = inst_42735__$1);

return statearr_42760;
})();
if(cljs.core.truth_(inst_42736)){
var statearr_42761_42787 = state_42756__$1;
(statearr_42761_42787[(1)] = (5));

} else {
var statearr_42762_42788 = state_42756__$1;
(statearr_42762_42788[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (13))){
var state_42756__$1 = state_42756;
var statearr_42763_42789 = state_42756__$1;
(statearr_42763_42789[(2)] = null);

(statearr_42763_42789[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (6))){
var inst_42735 = (state_42756[(7)]);
var state_42756__$1 = state_42756;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42756__$1,(11),to,inst_42735);
} else {
if((state_val_42757 === (3))){
var inst_42754 = (state_42756[(2)]);
var state_42756__$1 = state_42756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42756__$1,inst_42754);
} else {
if((state_val_42757 === (12))){
var state_42756__$1 = state_42756;
var statearr_42764_42790 = state_42756__$1;
(statearr_42764_42790[(2)] = null);

(statearr_42764_42790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (2))){
var state_42756__$1 = state_42756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42756__$1,(4),from);
} else {
if((state_val_42757 === (11))){
var inst_42745 = (state_42756[(2)]);
var state_42756__$1 = state_42756;
if(cljs.core.truth_(inst_42745)){
var statearr_42765_42791 = state_42756__$1;
(statearr_42765_42791[(1)] = (12));

} else {
var statearr_42766_42792 = state_42756__$1;
(statearr_42766_42792[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (9))){
var state_42756__$1 = state_42756;
var statearr_42767_42793 = state_42756__$1;
(statearr_42767_42793[(2)] = null);

(statearr_42767_42793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (5))){
var state_42756__$1 = state_42756;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42768_42794 = state_42756__$1;
(statearr_42768_42794[(1)] = (8));

} else {
var statearr_42769_42795 = state_42756__$1;
(statearr_42769_42795[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (14))){
var inst_42750 = (state_42756[(2)]);
var state_42756__$1 = state_42756;
var statearr_42770_42796 = state_42756__$1;
(statearr_42770_42796[(2)] = inst_42750);

(statearr_42770_42796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (10))){
var inst_42742 = (state_42756[(2)]);
var state_42756__$1 = state_42756;
var statearr_42771_42797 = state_42756__$1;
(statearr_42771_42797[(2)] = inst_42742);

(statearr_42771_42797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42757 === (8))){
var inst_42739 = cljs.core.async.close_BANG_.call(null,to);
var state_42756__$1 = state_42756;
var statearr_42772_42798 = state_42756__$1;
(statearr_42772_42798[(2)] = inst_42739);

(statearr_42772_42798[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___42784))
;
return ((function (switch__42489__auto__,c__42603__auto___42784){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_42776 = [null,null,null,null,null,null,null,null];
(statearr_42776[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_42776[(1)] = (1));

return statearr_42776;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_42756){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_42756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e42777){if((e42777 instanceof Object)){
var ex__42493__auto__ = e42777;
var statearr_42778_42799 = state_42756;
(statearr_42778_42799[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42756);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42800 = state_42756;
state_42756 = G__42800;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_42756){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_42756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___42784))
})();
var state__42605__auto__ = (function (){var statearr_42779 = f__42604__auto__.call(null);
(statearr_42779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___42784);

return statearr_42779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___42784))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__42988){
var vec__42989 = p__42988;
var v = cljs.core.nth.call(null,vec__42989,(0),null);
var p = cljs.core.nth.call(null,vec__42989,(1),null);
var job = vec__42989;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42603__auto___43175 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results){
return (function (state_42996){
var state_val_42997 = (state_42996[(1)]);
if((state_val_42997 === (1))){
var state_42996__$1 = state_42996;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42996__$1,(2),res,v);
} else {
if((state_val_42997 === (2))){
var inst_42993 = (state_42996[(2)]);
var inst_42994 = cljs.core.async.close_BANG_.call(null,res);
var state_42996__$1 = (function (){var statearr_42998 = state_42996;
(statearr_42998[(7)] = inst_42993);

return statearr_42998;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42996__$1,inst_42994);
} else {
return null;
}
}
});})(c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results))
;
return ((function (switch__42489__auto__,c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_43002 = [null,null,null,null,null,null,null,null];
(statearr_43002[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__);

(statearr_43002[(1)] = (1));

return statearr_43002;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1 = (function (state_42996){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_42996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43003){if((e43003 instanceof Object)){
var ex__42493__auto__ = e43003;
var statearr_43004_43176 = state_42996;
(statearr_43004_43176[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42996);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43177 = state_42996;
state_42996 = G__43177;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = function(state_42996){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1.call(this,state_42996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results))
})();
var state__42605__auto__ = (function (){var statearr_43005 = f__42604__auto__.call(null);
(statearr_43005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43175);

return statearr_43005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___43175,res,vec__42989,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__43006){
var vec__43007 = p__43006;
var v = cljs.core.nth.call(null,vec__43007,(0),null);
var p = cljs.core.nth.call(null,vec__43007,(1),null);
var job = vec__43007;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__8523__auto___43178 = n;
var __43179 = (0);
while(true){
if((__43179 < n__8523__auto___43178)){
var G__43010_43180 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__43010_43180) {
case "compute":
var c__42603__auto___43182 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__43179,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (__43179,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function (state_43023){
var state_val_43024 = (state_43023[(1)]);
if((state_val_43024 === (1))){
var state_43023__$1 = state_43023;
var statearr_43025_43183 = state_43023__$1;
(statearr_43025_43183[(2)] = null);

(statearr_43025_43183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43024 === (2))){
var state_43023__$1 = state_43023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43023__$1,(4),jobs);
} else {
if((state_val_43024 === (3))){
var inst_43021 = (state_43023[(2)]);
var state_43023__$1 = state_43023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43023__$1,inst_43021);
} else {
if((state_val_43024 === (4))){
var inst_43013 = (state_43023[(2)]);
var inst_43014 = process.call(null,inst_43013);
var state_43023__$1 = state_43023;
if(cljs.core.truth_(inst_43014)){
var statearr_43026_43184 = state_43023__$1;
(statearr_43026_43184[(1)] = (5));

} else {
var statearr_43027_43185 = state_43023__$1;
(statearr_43027_43185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43024 === (5))){
var state_43023__$1 = state_43023;
var statearr_43028_43186 = state_43023__$1;
(statearr_43028_43186[(2)] = null);

(statearr_43028_43186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43024 === (6))){
var state_43023__$1 = state_43023;
var statearr_43029_43187 = state_43023__$1;
(statearr_43029_43187[(2)] = null);

(statearr_43029_43187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43024 === (7))){
var inst_43019 = (state_43023[(2)]);
var state_43023__$1 = state_43023;
var statearr_43030_43188 = state_43023__$1;
(statearr_43030_43188[(2)] = inst_43019);

(statearr_43030_43188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43179,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
;
return ((function (__43179,switch__42489__auto__,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_43034 = [null,null,null,null,null,null,null];
(statearr_43034[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__);

(statearr_43034[(1)] = (1));

return statearr_43034;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1 = (function (state_43023){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43035){if((e43035 instanceof Object)){
var ex__42493__auto__ = e43035;
var statearr_43036_43189 = state_43023;
(statearr_43036_43189[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43190 = state_43023;
state_43023 = G__43190;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = function(state_43023){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1.call(this,state_43023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__;
})()
;})(__43179,switch__42489__auto__,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
})();
var state__42605__auto__ = (function (){var statearr_43037 = f__42604__auto__.call(null);
(statearr_43037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43182);

return statearr_43037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(__43179,c__42603__auto___43182,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
);


break;
case "async":
var c__42603__auto___43191 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__43179,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (__43179,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function (state_43050){
var state_val_43051 = (state_43050[(1)]);
if((state_val_43051 === (1))){
var state_43050__$1 = state_43050;
var statearr_43052_43192 = state_43050__$1;
(statearr_43052_43192[(2)] = null);

(statearr_43052_43192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43051 === (2))){
var state_43050__$1 = state_43050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43050__$1,(4),jobs);
} else {
if((state_val_43051 === (3))){
var inst_43048 = (state_43050[(2)]);
var state_43050__$1 = state_43050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43050__$1,inst_43048);
} else {
if((state_val_43051 === (4))){
var inst_43040 = (state_43050[(2)]);
var inst_43041 = async.call(null,inst_43040);
var state_43050__$1 = state_43050;
if(cljs.core.truth_(inst_43041)){
var statearr_43053_43193 = state_43050__$1;
(statearr_43053_43193[(1)] = (5));

} else {
var statearr_43054_43194 = state_43050__$1;
(statearr_43054_43194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43051 === (5))){
var state_43050__$1 = state_43050;
var statearr_43055_43195 = state_43050__$1;
(statearr_43055_43195[(2)] = null);

(statearr_43055_43195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43051 === (6))){
var state_43050__$1 = state_43050;
var statearr_43056_43196 = state_43050__$1;
(statearr_43056_43196[(2)] = null);

(statearr_43056_43196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43051 === (7))){
var inst_43046 = (state_43050[(2)]);
var state_43050__$1 = state_43050;
var statearr_43057_43197 = state_43050__$1;
(statearr_43057_43197[(2)] = inst_43046);

(statearr_43057_43197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43179,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
;
return ((function (__43179,switch__42489__auto__,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_43061 = [null,null,null,null,null,null,null];
(statearr_43061[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__);

(statearr_43061[(1)] = (1));

return statearr_43061;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1 = (function (state_43050){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43062){if((e43062 instanceof Object)){
var ex__42493__auto__ = e43062;
var statearr_43063_43198 = state_43050;
(statearr_43063_43198[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43050);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43199 = state_43050;
state_43050 = G__43199;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = function(state_43050){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1.call(this,state_43050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__;
})()
;})(__43179,switch__42489__auto__,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
})();
var state__42605__auto__ = (function (){var statearr_43064 = f__42604__auto__.call(null);
(statearr_43064[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43191);

return statearr_43064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(__43179,c__42603__auto___43191,G__43010_43180,n__8523__auto___43178,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__43200 = (__43179 + (1));
__43179 = G__43200;
continue;
} else {
}
break;
}

var c__42603__auto___43201 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___43201,jobs,results,process,async){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___43201,jobs,results,process,async){
return (function (state_43086){
var state_val_43087 = (state_43086[(1)]);
if((state_val_43087 === (1))){
var state_43086__$1 = state_43086;
var statearr_43088_43202 = state_43086__$1;
(statearr_43088_43202[(2)] = null);

(statearr_43088_43202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43087 === (2))){
var state_43086__$1 = state_43086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43086__$1,(4),from);
} else {
if((state_val_43087 === (3))){
var inst_43084 = (state_43086[(2)]);
var state_43086__$1 = state_43086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43086__$1,inst_43084);
} else {
if((state_val_43087 === (4))){
var inst_43067 = (state_43086[(7)]);
var inst_43067__$1 = (state_43086[(2)]);
var inst_43068 = (inst_43067__$1 == null);
var state_43086__$1 = (function (){var statearr_43089 = state_43086;
(statearr_43089[(7)] = inst_43067__$1);

return statearr_43089;
})();
if(cljs.core.truth_(inst_43068)){
var statearr_43090_43203 = state_43086__$1;
(statearr_43090_43203[(1)] = (5));

} else {
var statearr_43091_43204 = state_43086__$1;
(statearr_43091_43204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43087 === (5))){
var inst_43070 = cljs.core.async.close_BANG_.call(null,jobs);
var state_43086__$1 = state_43086;
var statearr_43092_43205 = state_43086__$1;
(statearr_43092_43205[(2)] = inst_43070);

(statearr_43092_43205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43087 === (6))){
var inst_43072 = (state_43086[(8)]);
var inst_43067 = (state_43086[(7)]);
var inst_43072__$1 = cljs.core.async.chan.call(null,(1));
var inst_43073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43074 = [inst_43067,inst_43072__$1];
var inst_43075 = (new cljs.core.PersistentVector(null,2,(5),inst_43073,inst_43074,null));
var state_43086__$1 = (function (){var statearr_43093 = state_43086;
(statearr_43093[(8)] = inst_43072__$1);

return statearr_43093;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43086__$1,(8),jobs,inst_43075);
} else {
if((state_val_43087 === (7))){
var inst_43082 = (state_43086[(2)]);
var state_43086__$1 = state_43086;
var statearr_43094_43206 = state_43086__$1;
(statearr_43094_43206[(2)] = inst_43082);

(statearr_43094_43206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43087 === (8))){
var inst_43072 = (state_43086[(8)]);
var inst_43077 = (state_43086[(2)]);
var state_43086__$1 = (function (){var statearr_43095 = state_43086;
(statearr_43095[(9)] = inst_43077);

return statearr_43095;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43086__$1,(9),results,inst_43072);
} else {
if((state_val_43087 === (9))){
var inst_43079 = (state_43086[(2)]);
var state_43086__$1 = (function (){var statearr_43096 = state_43086;
(statearr_43096[(10)] = inst_43079);

return statearr_43096;
})();
var statearr_43097_43207 = state_43086__$1;
(statearr_43097_43207[(2)] = null);

(statearr_43097_43207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___43201,jobs,results,process,async))
;
return ((function (switch__42489__auto__,c__42603__auto___43201,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_43101 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43101[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__);

(statearr_43101[(1)] = (1));

return statearr_43101;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1 = (function (state_43086){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43102){if((e43102 instanceof Object)){
var ex__42493__auto__ = e43102;
var statearr_43103_43208 = state_43086;
(statearr_43103_43208[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43086);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43102;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43209 = state_43086;
state_43086 = G__43209;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = function(state_43086){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1.call(this,state_43086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___43201,jobs,results,process,async))
})();
var state__42605__auto__ = (function (){var statearr_43104 = f__42604__auto__.call(null);
(statearr_43104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43201);

return statearr_43104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___43201,jobs,results,process,async))
);


var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,jobs,results,process,async){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,jobs,results,process,async){
return (function (state_43142){
var state_val_43143 = (state_43142[(1)]);
if((state_val_43143 === (7))){
var inst_43138 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
var statearr_43144_43210 = state_43142__$1;
(statearr_43144_43210[(2)] = inst_43138);

(statearr_43144_43210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (20))){
var state_43142__$1 = state_43142;
var statearr_43145_43211 = state_43142__$1;
(statearr_43145_43211[(2)] = null);

(statearr_43145_43211[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (1))){
var state_43142__$1 = state_43142;
var statearr_43146_43212 = state_43142__$1;
(statearr_43146_43212[(2)] = null);

(statearr_43146_43212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (4))){
var inst_43107 = (state_43142[(7)]);
var inst_43107__$1 = (state_43142[(2)]);
var inst_43108 = (inst_43107__$1 == null);
var state_43142__$1 = (function (){var statearr_43147 = state_43142;
(statearr_43147[(7)] = inst_43107__$1);

return statearr_43147;
})();
if(cljs.core.truth_(inst_43108)){
var statearr_43148_43213 = state_43142__$1;
(statearr_43148_43213[(1)] = (5));

} else {
var statearr_43149_43214 = state_43142__$1;
(statearr_43149_43214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (15))){
var inst_43120 = (state_43142[(8)]);
var state_43142__$1 = state_43142;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43142__$1,(18),to,inst_43120);
} else {
if((state_val_43143 === (21))){
var inst_43133 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
var statearr_43150_43215 = state_43142__$1;
(statearr_43150_43215[(2)] = inst_43133);

(statearr_43150_43215[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (13))){
var inst_43135 = (state_43142[(2)]);
var state_43142__$1 = (function (){var statearr_43151 = state_43142;
(statearr_43151[(9)] = inst_43135);

return statearr_43151;
})();
var statearr_43152_43216 = state_43142__$1;
(statearr_43152_43216[(2)] = null);

(statearr_43152_43216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (6))){
var inst_43107 = (state_43142[(7)]);
var state_43142__$1 = state_43142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43142__$1,(11),inst_43107);
} else {
if((state_val_43143 === (17))){
var inst_43128 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
if(cljs.core.truth_(inst_43128)){
var statearr_43153_43217 = state_43142__$1;
(statearr_43153_43217[(1)] = (19));

} else {
var statearr_43154_43218 = state_43142__$1;
(statearr_43154_43218[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (3))){
var inst_43140 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43142__$1,inst_43140);
} else {
if((state_val_43143 === (12))){
var inst_43117 = (state_43142[(10)]);
var state_43142__$1 = state_43142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43142__$1,(14),inst_43117);
} else {
if((state_val_43143 === (2))){
var state_43142__$1 = state_43142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43142__$1,(4),results);
} else {
if((state_val_43143 === (19))){
var state_43142__$1 = state_43142;
var statearr_43155_43219 = state_43142__$1;
(statearr_43155_43219[(2)] = null);

(statearr_43155_43219[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (11))){
var inst_43117 = (state_43142[(2)]);
var state_43142__$1 = (function (){var statearr_43156 = state_43142;
(statearr_43156[(10)] = inst_43117);

return statearr_43156;
})();
var statearr_43157_43220 = state_43142__$1;
(statearr_43157_43220[(2)] = null);

(statearr_43157_43220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (9))){
var state_43142__$1 = state_43142;
var statearr_43158_43221 = state_43142__$1;
(statearr_43158_43221[(2)] = null);

(statearr_43158_43221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (5))){
var state_43142__$1 = state_43142;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43159_43222 = state_43142__$1;
(statearr_43159_43222[(1)] = (8));

} else {
var statearr_43160_43223 = state_43142__$1;
(statearr_43160_43223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (14))){
var inst_43120 = (state_43142[(8)]);
var inst_43122 = (state_43142[(11)]);
var inst_43120__$1 = (state_43142[(2)]);
var inst_43121 = (inst_43120__$1 == null);
var inst_43122__$1 = cljs.core.not.call(null,inst_43121);
var state_43142__$1 = (function (){var statearr_43161 = state_43142;
(statearr_43161[(8)] = inst_43120__$1);

(statearr_43161[(11)] = inst_43122__$1);

return statearr_43161;
})();
if(inst_43122__$1){
var statearr_43162_43224 = state_43142__$1;
(statearr_43162_43224[(1)] = (15));

} else {
var statearr_43163_43225 = state_43142__$1;
(statearr_43163_43225[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (16))){
var inst_43122 = (state_43142[(11)]);
var state_43142__$1 = state_43142;
var statearr_43164_43226 = state_43142__$1;
(statearr_43164_43226[(2)] = inst_43122);

(statearr_43164_43226[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (10))){
var inst_43114 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
var statearr_43165_43227 = state_43142__$1;
(statearr_43165_43227[(2)] = inst_43114);

(statearr_43165_43227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (18))){
var inst_43125 = (state_43142[(2)]);
var state_43142__$1 = state_43142;
var statearr_43166_43228 = state_43142__$1;
(statearr_43166_43228[(2)] = inst_43125);

(statearr_43166_43228[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43143 === (8))){
var inst_43111 = cljs.core.async.close_BANG_.call(null,to);
var state_43142__$1 = state_43142;
var statearr_43167_43229 = state_43142__$1;
(statearr_43167_43229[(2)] = inst_43111);

(statearr_43167_43229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__,jobs,results,process,async))
;
return ((function (switch__42489__auto__,c__42603__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_43171 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43171[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__);

(statearr_43171[(1)] = (1));

return statearr_43171;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1 = (function (state_43142){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43172){if((e43172 instanceof Object)){
var ex__42493__auto__ = e43172;
var statearr_43173_43230 = state_43142;
(statearr_43173_43230[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43142);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43231 = state_43142;
state_43142 = G__43231;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__ = function(state_43142){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1.call(this,state_43142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,jobs,results,process,async))
})();
var state__42605__auto__ = (function (){var statearr_43174 = f__42604__auto__.call(null);
(statearr_43174[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_43174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,jobs,results,process,async))
);

return c__42603__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args43232 = [];
var len__8723__auto___43235 = arguments.length;
var i__8724__auto___43236 = (0);
while(true){
if((i__8724__auto___43236 < len__8723__auto___43235)){
args43232.push((arguments[i__8724__auto___43236]));

var G__43237 = (i__8724__auto___43236 + (1));
i__8724__auto___43236 = G__43237;
continue;
} else {
}
break;
}

var G__43234 = args43232.length;
switch (G__43234) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args43232.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args43239 = [];
var len__8723__auto___43242 = arguments.length;
var i__8724__auto___43243 = (0);
while(true){
if((i__8724__auto___43243 < len__8723__auto___43242)){
args43239.push((arguments[i__8724__auto___43243]));

var G__43244 = (i__8724__auto___43243 + (1));
i__8724__auto___43243 = G__43244;
continue;
} else {
}
break;
}

var G__43241 = args43239.length;
switch (G__43241) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args43239.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args43246 = [];
var len__8723__auto___43299 = arguments.length;
var i__8724__auto___43300 = (0);
while(true){
if((i__8724__auto___43300 < len__8723__auto___43299)){
args43246.push((arguments[i__8724__auto___43300]));

var G__43301 = (i__8724__auto___43300 + (1));
i__8724__auto___43300 = G__43301;
continue;
} else {
}
break;
}

var G__43248 = args43246.length;
switch (G__43248) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args43246.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42603__auto___43303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___43303,tc,fc){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___43303,tc,fc){
return (function (state_43274){
var state_val_43275 = (state_43274[(1)]);
if((state_val_43275 === (7))){
var inst_43270 = (state_43274[(2)]);
var state_43274__$1 = state_43274;
var statearr_43276_43304 = state_43274__$1;
(statearr_43276_43304[(2)] = inst_43270);

(statearr_43276_43304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (1))){
var state_43274__$1 = state_43274;
var statearr_43277_43305 = state_43274__$1;
(statearr_43277_43305[(2)] = null);

(statearr_43277_43305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (4))){
var inst_43251 = (state_43274[(7)]);
var inst_43251__$1 = (state_43274[(2)]);
var inst_43252 = (inst_43251__$1 == null);
var state_43274__$1 = (function (){var statearr_43278 = state_43274;
(statearr_43278[(7)] = inst_43251__$1);

return statearr_43278;
})();
if(cljs.core.truth_(inst_43252)){
var statearr_43279_43306 = state_43274__$1;
(statearr_43279_43306[(1)] = (5));

} else {
var statearr_43280_43307 = state_43274__$1;
(statearr_43280_43307[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (13))){
var state_43274__$1 = state_43274;
var statearr_43281_43308 = state_43274__$1;
(statearr_43281_43308[(2)] = null);

(statearr_43281_43308[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (6))){
var inst_43251 = (state_43274[(7)]);
var inst_43257 = p.call(null,inst_43251);
var state_43274__$1 = state_43274;
if(cljs.core.truth_(inst_43257)){
var statearr_43282_43309 = state_43274__$1;
(statearr_43282_43309[(1)] = (9));

} else {
var statearr_43283_43310 = state_43274__$1;
(statearr_43283_43310[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (3))){
var inst_43272 = (state_43274[(2)]);
var state_43274__$1 = state_43274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43274__$1,inst_43272);
} else {
if((state_val_43275 === (12))){
var state_43274__$1 = state_43274;
var statearr_43284_43311 = state_43274__$1;
(statearr_43284_43311[(2)] = null);

(statearr_43284_43311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (2))){
var state_43274__$1 = state_43274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43274__$1,(4),ch);
} else {
if((state_val_43275 === (11))){
var inst_43251 = (state_43274[(7)]);
var inst_43261 = (state_43274[(2)]);
var state_43274__$1 = state_43274;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43274__$1,(8),inst_43261,inst_43251);
} else {
if((state_val_43275 === (9))){
var state_43274__$1 = state_43274;
var statearr_43285_43312 = state_43274__$1;
(statearr_43285_43312[(2)] = tc);

(statearr_43285_43312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (5))){
var inst_43254 = cljs.core.async.close_BANG_.call(null,tc);
var inst_43255 = cljs.core.async.close_BANG_.call(null,fc);
var state_43274__$1 = (function (){var statearr_43286 = state_43274;
(statearr_43286[(8)] = inst_43254);

return statearr_43286;
})();
var statearr_43287_43313 = state_43274__$1;
(statearr_43287_43313[(2)] = inst_43255);

(statearr_43287_43313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (14))){
var inst_43268 = (state_43274[(2)]);
var state_43274__$1 = state_43274;
var statearr_43288_43314 = state_43274__$1;
(statearr_43288_43314[(2)] = inst_43268);

(statearr_43288_43314[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (10))){
var state_43274__$1 = state_43274;
var statearr_43289_43315 = state_43274__$1;
(statearr_43289_43315[(2)] = fc);

(statearr_43289_43315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43275 === (8))){
var inst_43263 = (state_43274[(2)]);
var state_43274__$1 = state_43274;
if(cljs.core.truth_(inst_43263)){
var statearr_43290_43316 = state_43274__$1;
(statearr_43290_43316[(1)] = (12));

} else {
var statearr_43291_43317 = state_43274__$1;
(statearr_43291_43317[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___43303,tc,fc))
;
return ((function (switch__42489__auto__,c__42603__auto___43303,tc,fc){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_43295 = [null,null,null,null,null,null,null,null,null];
(statearr_43295[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_43295[(1)] = (1));

return statearr_43295;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_43274){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43296){if((e43296 instanceof Object)){
var ex__42493__auto__ = e43296;
var statearr_43297_43318 = state_43274;
(statearr_43297_43318[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43274);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43319 = state_43274;
state_43274 = G__43319;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_43274){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_43274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___43303,tc,fc))
})();
var state__42605__auto__ = (function (){var statearr_43298 = f__42604__auto__.call(null);
(statearr_43298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43303);

return statearr_43298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___43303,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__){
return (function (state_43383){
var state_val_43384 = (state_43383[(1)]);
if((state_val_43384 === (7))){
var inst_43379 = (state_43383[(2)]);
var state_43383__$1 = state_43383;
var statearr_43385_43406 = state_43383__$1;
(statearr_43385_43406[(2)] = inst_43379);

(statearr_43385_43406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (1))){
var inst_43363 = init;
var state_43383__$1 = (function (){var statearr_43386 = state_43383;
(statearr_43386[(7)] = inst_43363);

return statearr_43386;
})();
var statearr_43387_43407 = state_43383__$1;
(statearr_43387_43407[(2)] = null);

(statearr_43387_43407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (4))){
var inst_43366 = (state_43383[(8)]);
var inst_43366__$1 = (state_43383[(2)]);
var inst_43367 = (inst_43366__$1 == null);
var state_43383__$1 = (function (){var statearr_43388 = state_43383;
(statearr_43388[(8)] = inst_43366__$1);

return statearr_43388;
})();
if(cljs.core.truth_(inst_43367)){
var statearr_43389_43408 = state_43383__$1;
(statearr_43389_43408[(1)] = (5));

} else {
var statearr_43390_43409 = state_43383__$1;
(statearr_43390_43409[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (6))){
var inst_43370 = (state_43383[(9)]);
var inst_43366 = (state_43383[(8)]);
var inst_43363 = (state_43383[(7)]);
var inst_43370__$1 = f.call(null,inst_43363,inst_43366);
var inst_43371 = cljs.core.reduced_QMARK_.call(null,inst_43370__$1);
var state_43383__$1 = (function (){var statearr_43391 = state_43383;
(statearr_43391[(9)] = inst_43370__$1);

return statearr_43391;
})();
if(inst_43371){
var statearr_43392_43410 = state_43383__$1;
(statearr_43392_43410[(1)] = (8));

} else {
var statearr_43393_43411 = state_43383__$1;
(statearr_43393_43411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (3))){
var inst_43381 = (state_43383[(2)]);
var state_43383__$1 = state_43383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43383__$1,inst_43381);
} else {
if((state_val_43384 === (2))){
var state_43383__$1 = state_43383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43383__$1,(4),ch);
} else {
if((state_val_43384 === (9))){
var inst_43370 = (state_43383[(9)]);
var inst_43363 = inst_43370;
var state_43383__$1 = (function (){var statearr_43394 = state_43383;
(statearr_43394[(7)] = inst_43363);

return statearr_43394;
})();
var statearr_43395_43412 = state_43383__$1;
(statearr_43395_43412[(2)] = null);

(statearr_43395_43412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (5))){
var inst_43363 = (state_43383[(7)]);
var state_43383__$1 = state_43383;
var statearr_43396_43413 = state_43383__$1;
(statearr_43396_43413[(2)] = inst_43363);

(statearr_43396_43413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (10))){
var inst_43377 = (state_43383[(2)]);
var state_43383__$1 = state_43383;
var statearr_43397_43414 = state_43383__$1;
(statearr_43397_43414[(2)] = inst_43377);

(statearr_43397_43414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43384 === (8))){
var inst_43370 = (state_43383[(9)]);
var inst_43373 = cljs.core.deref.call(null,inst_43370);
var state_43383__$1 = state_43383;
var statearr_43398_43415 = state_43383__$1;
(statearr_43398_43415[(2)] = inst_43373);

(statearr_43398_43415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__))
;
return ((function (switch__42489__auto__,c__42603__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__42490__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42490__auto____0 = (function (){
var statearr_43402 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43402[(0)] = cljs$core$async$reduce_$_state_machine__42490__auto__);

(statearr_43402[(1)] = (1));

return statearr_43402;
});
var cljs$core$async$reduce_$_state_machine__42490__auto____1 = (function (state_43383){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43403){if((e43403 instanceof Object)){
var ex__42493__auto__ = e43403;
var statearr_43404_43416 = state_43383;
(statearr_43404_43416[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43417 = state_43383;
state_43383 = G__43417;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42490__auto__ = function(state_43383){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42490__auto____1.call(this,state_43383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42490__auto____0;
cljs$core$async$reduce_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42490__auto____1;
return cljs$core$async$reduce_$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__))
})();
var state__42605__auto__ = (function (){var statearr_43405 = f__42604__auto__.call(null);
(statearr_43405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_43405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__))
);

return c__42603__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args43418 = [];
var len__8723__auto___43470 = arguments.length;
var i__8724__auto___43471 = (0);
while(true){
if((i__8724__auto___43471 < len__8723__auto___43470)){
args43418.push((arguments[i__8724__auto___43471]));

var G__43472 = (i__8724__auto___43471 + (1));
i__8724__auto___43471 = G__43472;
continue;
} else {
}
break;
}

var G__43420 = args43418.length;
switch (G__43420) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args43418.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__){
return (function (state_43445){
var state_val_43446 = (state_43445[(1)]);
if((state_val_43446 === (7))){
var inst_43427 = (state_43445[(2)]);
var state_43445__$1 = state_43445;
var statearr_43447_43474 = state_43445__$1;
(statearr_43447_43474[(2)] = inst_43427);

(statearr_43447_43474[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (1))){
var inst_43421 = cljs.core.seq.call(null,coll);
var inst_43422 = inst_43421;
var state_43445__$1 = (function (){var statearr_43448 = state_43445;
(statearr_43448[(7)] = inst_43422);

return statearr_43448;
})();
var statearr_43449_43475 = state_43445__$1;
(statearr_43449_43475[(2)] = null);

(statearr_43449_43475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (4))){
var inst_43422 = (state_43445[(7)]);
var inst_43425 = cljs.core.first.call(null,inst_43422);
var state_43445__$1 = state_43445;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43445__$1,(7),ch,inst_43425);
} else {
if((state_val_43446 === (13))){
var inst_43439 = (state_43445[(2)]);
var state_43445__$1 = state_43445;
var statearr_43450_43476 = state_43445__$1;
(statearr_43450_43476[(2)] = inst_43439);

(statearr_43450_43476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (6))){
var inst_43430 = (state_43445[(2)]);
var state_43445__$1 = state_43445;
if(cljs.core.truth_(inst_43430)){
var statearr_43451_43477 = state_43445__$1;
(statearr_43451_43477[(1)] = (8));

} else {
var statearr_43452_43478 = state_43445__$1;
(statearr_43452_43478[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (3))){
var inst_43443 = (state_43445[(2)]);
var state_43445__$1 = state_43445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43445__$1,inst_43443);
} else {
if((state_val_43446 === (12))){
var state_43445__$1 = state_43445;
var statearr_43453_43479 = state_43445__$1;
(statearr_43453_43479[(2)] = null);

(statearr_43453_43479[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (2))){
var inst_43422 = (state_43445[(7)]);
var state_43445__$1 = state_43445;
if(cljs.core.truth_(inst_43422)){
var statearr_43454_43480 = state_43445__$1;
(statearr_43454_43480[(1)] = (4));

} else {
var statearr_43455_43481 = state_43445__$1;
(statearr_43455_43481[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (11))){
var inst_43436 = cljs.core.async.close_BANG_.call(null,ch);
var state_43445__$1 = state_43445;
var statearr_43456_43482 = state_43445__$1;
(statearr_43456_43482[(2)] = inst_43436);

(statearr_43456_43482[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (9))){
var state_43445__$1 = state_43445;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43457_43483 = state_43445__$1;
(statearr_43457_43483[(1)] = (11));

} else {
var statearr_43458_43484 = state_43445__$1;
(statearr_43458_43484[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (5))){
var inst_43422 = (state_43445[(7)]);
var state_43445__$1 = state_43445;
var statearr_43459_43485 = state_43445__$1;
(statearr_43459_43485[(2)] = inst_43422);

(statearr_43459_43485[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (10))){
var inst_43441 = (state_43445[(2)]);
var state_43445__$1 = state_43445;
var statearr_43460_43486 = state_43445__$1;
(statearr_43460_43486[(2)] = inst_43441);

(statearr_43460_43486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43446 === (8))){
var inst_43422 = (state_43445[(7)]);
var inst_43432 = cljs.core.next.call(null,inst_43422);
var inst_43422__$1 = inst_43432;
var state_43445__$1 = (function (){var statearr_43461 = state_43445;
(statearr_43461[(7)] = inst_43422__$1);

return statearr_43461;
})();
var statearr_43462_43487 = state_43445__$1;
(statearr_43462_43487[(2)] = null);

(statearr_43462_43487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__))
;
return ((function (switch__42489__auto__,c__42603__auto__){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_43466 = [null,null,null,null,null,null,null,null];
(statearr_43466[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_43466[(1)] = (1));

return statearr_43466;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_43445){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43467){if((e43467 instanceof Object)){
var ex__42493__auto__ = e43467;
var statearr_43468_43488 = state_43445;
(statearr_43468_43488[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43467;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43489 = state_43445;
state_43445 = G__43489;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_43445){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_43445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__))
})();
var state__42605__auto__ = (function (){var statearr_43469 = f__42604__auto__.call(null);
(statearr_43469[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_43469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__))
);

return c__42603__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8220__auto__ = (((_ == null))?null:_);
var m__8221__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,_);
} else {
var m__8221__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8221__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,ch);
} else {
var m__8221__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m);
} else {
var m__8221__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async43715 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43715 = (function (ch,cs,meta43716){
this.ch = ch;
this.cs = cs;
this.meta43716 = meta43716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_43717,meta43716__$1){
var self__ = this;
var _43717__$1 = this;
return (new cljs.core.async.t_cljs$core$async43715(self__.ch,self__.cs,meta43716__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_43717){
var self__ = this;
var _43717__$1 = this;
return self__.meta43716;
});})(cs))
;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async43715.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async43715.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43716","meta43716",1652975351,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async43715.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async43715.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43715";

cljs.core.async.t_cljs$core$async43715.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async43715");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async43715 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async43715(ch__$1,cs__$1,meta43716){
return (new cljs.core.async.t_cljs$core$async43715(ch__$1,cs__$1,meta43716));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async43715(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__42603__auto___43940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___43940,cs,m,dchan,dctr,done){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___43940,cs,m,dchan,dctr,done){
return (function (state_43852){
var state_val_43853 = (state_43852[(1)]);
if((state_val_43853 === (7))){
var inst_43848 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43854_43941 = state_43852__$1;
(statearr_43854_43941[(2)] = inst_43848);

(statearr_43854_43941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (20))){
var inst_43751 = (state_43852[(7)]);
var inst_43763 = cljs.core.first.call(null,inst_43751);
var inst_43764 = cljs.core.nth.call(null,inst_43763,(0),null);
var inst_43765 = cljs.core.nth.call(null,inst_43763,(1),null);
var state_43852__$1 = (function (){var statearr_43855 = state_43852;
(statearr_43855[(8)] = inst_43764);

return statearr_43855;
})();
if(cljs.core.truth_(inst_43765)){
var statearr_43856_43942 = state_43852__$1;
(statearr_43856_43942[(1)] = (22));

} else {
var statearr_43857_43943 = state_43852__$1;
(statearr_43857_43943[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (27))){
var inst_43795 = (state_43852[(9)]);
var inst_43793 = (state_43852[(10)]);
var inst_43720 = (state_43852[(11)]);
var inst_43800 = (state_43852[(12)]);
var inst_43800__$1 = cljs.core._nth.call(null,inst_43793,inst_43795);
var inst_43801 = cljs.core.async.put_BANG_.call(null,inst_43800__$1,inst_43720,done);
var state_43852__$1 = (function (){var statearr_43858 = state_43852;
(statearr_43858[(12)] = inst_43800__$1);

return statearr_43858;
})();
if(cljs.core.truth_(inst_43801)){
var statearr_43859_43944 = state_43852__$1;
(statearr_43859_43944[(1)] = (30));

} else {
var statearr_43860_43945 = state_43852__$1;
(statearr_43860_43945[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (1))){
var state_43852__$1 = state_43852;
var statearr_43861_43946 = state_43852__$1;
(statearr_43861_43946[(2)] = null);

(statearr_43861_43946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (24))){
var inst_43751 = (state_43852[(7)]);
var inst_43770 = (state_43852[(2)]);
var inst_43771 = cljs.core.next.call(null,inst_43751);
var inst_43729 = inst_43771;
var inst_43730 = null;
var inst_43731 = (0);
var inst_43732 = (0);
var state_43852__$1 = (function (){var statearr_43862 = state_43852;
(statearr_43862[(13)] = inst_43732);

(statearr_43862[(14)] = inst_43730);

(statearr_43862[(15)] = inst_43731);

(statearr_43862[(16)] = inst_43729);

(statearr_43862[(17)] = inst_43770);

return statearr_43862;
})();
var statearr_43863_43947 = state_43852__$1;
(statearr_43863_43947[(2)] = null);

(statearr_43863_43947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (39))){
var state_43852__$1 = state_43852;
var statearr_43867_43948 = state_43852__$1;
(statearr_43867_43948[(2)] = null);

(statearr_43867_43948[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (4))){
var inst_43720 = (state_43852[(11)]);
var inst_43720__$1 = (state_43852[(2)]);
var inst_43721 = (inst_43720__$1 == null);
var state_43852__$1 = (function (){var statearr_43868 = state_43852;
(statearr_43868[(11)] = inst_43720__$1);

return statearr_43868;
})();
if(cljs.core.truth_(inst_43721)){
var statearr_43869_43949 = state_43852__$1;
(statearr_43869_43949[(1)] = (5));

} else {
var statearr_43870_43950 = state_43852__$1;
(statearr_43870_43950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (15))){
var inst_43732 = (state_43852[(13)]);
var inst_43730 = (state_43852[(14)]);
var inst_43731 = (state_43852[(15)]);
var inst_43729 = (state_43852[(16)]);
var inst_43747 = (state_43852[(2)]);
var inst_43748 = (inst_43732 + (1));
var tmp43864 = inst_43730;
var tmp43865 = inst_43731;
var tmp43866 = inst_43729;
var inst_43729__$1 = tmp43866;
var inst_43730__$1 = tmp43864;
var inst_43731__$1 = tmp43865;
var inst_43732__$1 = inst_43748;
var state_43852__$1 = (function (){var statearr_43871 = state_43852;
(statearr_43871[(18)] = inst_43747);

(statearr_43871[(13)] = inst_43732__$1);

(statearr_43871[(14)] = inst_43730__$1);

(statearr_43871[(15)] = inst_43731__$1);

(statearr_43871[(16)] = inst_43729__$1);

return statearr_43871;
})();
var statearr_43872_43951 = state_43852__$1;
(statearr_43872_43951[(2)] = null);

(statearr_43872_43951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (21))){
var inst_43774 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43876_43952 = state_43852__$1;
(statearr_43876_43952[(2)] = inst_43774);

(statearr_43876_43952[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (31))){
var inst_43800 = (state_43852[(12)]);
var inst_43804 = done.call(null,null);
var inst_43805 = cljs.core.async.untap_STAR_.call(null,m,inst_43800);
var state_43852__$1 = (function (){var statearr_43877 = state_43852;
(statearr_43877[(19)] = inst_43804);

return statearr_43877;
})();
var statearr_43878_43953 = state_43852__$1;
(statearr_43878_43953[(2)] = inst_43805);

(statearr_43878_43953[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (32))){
var inst_43792 = (state_43852[(20)]);
var inst_43795 = (state_43852[(9)]);
var inst_43794 = (state_43852[(21)]);
var inst_43793 = (state_43852[(10)]);
var inst_43807 = (state_43852[(2)]);
var inst_43808 = (inst_43795 + (1));
var tmp43873 = inst_43792;
var tmp43874 = inst_43794;
var tmp43875 = inst_43793;
var inst_43792__$1 = tmp43873;
var inst_43793__$1 = tmp43875;
var inst_43794__$1 = tmp43874;
var inst_43795__$1 = inst_43808;
var state_43852__$1 = (function (){var statearr_43879 = state_43852;
(statearr_43879[(22)] = inst_43807);

(statearr_43879[(20)] = inst_43792__$1);

(statearr_43879[(9)] = inst_43795__$1);

(statearr_43879[(21)] = inst_43794__$1);

(statearr_43879[(10)] = inst_43793__$1);

return statearr_43879;
})();
var statearr_43880_43954 = state_43852__$1;
(statearr_43880_43954[(2)] = null);

(statearr_43880_43954[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (40))){
var inst_43820 = (state_43852[(23)]);
var inst_43824 = done.call(null,null);
var inst_43825 = cljs.core.async.untap_STAR_.call(null,m,inst_43820);
var state_43852__$1 = (function (){var statearr_43881 = state_43852;
(statearr_43881[(24)] = inst_43824);

return statearr_43881;
})();
var statearr_43882_43955 = state_43852__$1;
(statearr_43882_43955[(2)] = inst_43825);

(statearr_43882_43955[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (33))){
var inst_43811 = (state_43852[(25)]);
var inst_43813 = cljs.core.chunked_seq_QMARK_.call(null,inst_43811);
var state_43852__$1 = state_43852;
if(inst_43813){
var statearr_43883_43956 = state_43852__$1;
(statearr_43883_43956[(1)] = (36));

} else {
var statearr_43884_43957 = state_43852__$1;
(statearr_43884_43957[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (13))){
var inst_43741 = (state_43852[(26)]);
var inst_43744 = cljs.core.async.close_BANG_.call(null,inst_43741);
var state_43852__$1 = state_43852;
var statearr_43885_43958 = state_43852__$1;
(statearr_43885_43958[(2)] = inst_43744);

(statearr_43885_43958[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (22))){
var inst_43764 = (state_43852[(8)]);
var inst_43767 = cljs.core.async.close_BANG_.call(null,inst_43764);
var state_43852__$1 = state_43852;
var statearr_43886_43959 = state_43852__$1;
(statearr_43886_43959[(2)] = inst_43767);

(statearr_43886_43959[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (36))){
var inst_43811 = (state_43852[(25)]);
var inst_43815 = cljs.core.chunk_first.call(null,inst_43811);
var inst_43816 = cljs.core.chunk_rest.call(null,inst_43811);
var inst_43817 = cljs.core.count.call(null,inst_43815);
var inst_43792 = inst_43816;
var inst_43793 = inst_43815;
var inst_43794 = inst_43817;
var inst_43795 = (0);
var state_43852__$1 = (function (){var statearr_43887 = state_43852;
(statearr_43887[(20)] = inst_43792);

(statearr_43887[(9)] = inst_43795);

(statearr_43887[(21)] = inst_43794);

(statearr_43887[(10)] = inst_43793);

return statearr_43887;
})();
var statearr_43888_43960 = state_43852__$1;
(statearr_43888_43960[(2)] = null);

(statearr_43888_43960[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (41))){
var inst_43811 = (state_43852[(25)]);
var inst_43827 = (state_43852[(2)]);
var inst_43828 = cljs.core.next.call(null,inst_43811);
var inst_43792 = inst_43828;
var inst_43793 = null;
var inst_43794 = (0);
var inst_43795 = (0);
var state_43852__$1 = (function (){var statearr_43889 = state_43852;
(statearr_43889[(27)] = inst_43827);

(statearr_43889[(20)] = inst_43792);

(statearr_43889[(9)] = inst_43795);

(statearr_43889[(21)] = inst_43794);

(statearr_43889[(10)] = inst_43793);

return statearr_43889;
})();
var statearr_43890_43961 = state_43852__$1;
(statearr_43890_43961[(2)] = null);

(statearr_43890_43961[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (43))){
var state_43852__$1 = state_43852;
var statearr_43891_43962 = state_43852__$1;
(statearr_43891_43962[(2)] = null);

(statearr_43891_43962[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (29))){
var inst_43836 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43892_43963 = state_43852__$1;
(statearr_43892_43963[(2)] = inst_43836);

(statearr_43892_43963[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (44))){
var inst_43845 = (state_43852[(2)]);
var state_43852__$1 = (function (){var statearr_43893 = state_43852;
(statearr_43893[(28)] = inst_43845);

return statearr_43893;
})();
var statearr_43894_43964 = state_43852__$1;
(statearr_43894_43964[(2)] = null);

(statearr_43894_43964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (6))){
var inst_43784 = (state_43852[(29)]);
var inst_43783 = cljs.core.deref.call(null,cs);
var inst_43784__$1 = cljs.core.keys.call(null,inst_43783);
var inst_43785 = cljs.core.count.call(null,inst_43784__$1);
var inst_43786 = cljs.core.reset_BANG_.call(null,dctr,inst_43785);
var inst_43791 = cljs.core.seq.call(null,inst_43784__$1);
var inst_43792 = inst_43791;
var inst_43793 = null;
var inst_43794 = (0);
var inst_43795 = (0);
var state_43852__$1 = (function (){var statearr_43895 = state_43852;
(statearr_43895[(29)] = inst_43784__$1);

(statearr_43895[(20)] = inst_43792);

(statearr_43895[(9)] = inst_43795);

(statearr_43895[(21)] = inst_43794);

(statearr_43895[(10)] = inst_43793);

(statearr_43895[(30)] = inst_43786);

return statearr_43895;
})();
var statearr_43896_43965 = state_43852__$1;
(statearr_43896_43965[(2)] = null);

(statearr_43896_43965[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (28))){
var inst_43792 = (state_43852[(20)]);
var inst_43811 = (state_43852[(25)]);
var inst_43811__$1 = cljs.core.seq.call(null,inst_43792);
var state_43852__$1 = (function (){var statearr_43897 = state_43852;
(statearr_43897[(25)] = inst_43811__$1);

return statearr_43897;
})();
if(inst_43811__$1){
var statearr_43898_43966 = state_43852__$1;
(statearr_43898_43966[(1)] = (33));

} else {
var statearr_43899_43967 = state_43852__$1;
(statearr_43899_43967[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (25))){
var inst_43795 = (state_43852[(9)]);
var inst_43794 = (state_43852[(21)]);
var inst_43797 = (inst_43795 < inst_43794);
var inst_43798 = inst_43797;
var state_43852__$1 = state_43852;
if(cljs.core.truth_(inst_43798)){
var statearr_43900_43968 = state_43852__$1;
(statearr_43900_43968[(1)] = (27));

} else {
var statearr_43901_43969 = state_43852__$1;
(statearr_43901_43969[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (34))){
var state_43852__$1 = state_43852;
var statearr_43902_43970 = state_43852__$1;
(statearr_43902_43970[(2)] = null);

(statearr_43902_43970[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (17))){
var state_43852__$1 = state_43852;
var statearr_43903_43971 = state_43852__$1;
(statearr_43903_43971[(2)] = null);

(statearr_43903_43971[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (3))){
var inst_43850 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43852__$1,inst_43850);
} else {
if((state_val_43853 === (12))){
var inst_43779 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43904_43972 = state_43852__$1;
(statearr_43904_43972[(2)] = inst_43779);

(statearr_43904_43972[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (2))){
var state_43852__$1 = state_43852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43852__$1,(4),ch);
} else {
if((state_val_43853 === (23))){
var state_43852__$1 = state_43852;
var statearr_43905_43973 = state_43852__$1;
(statearr_43905_43973[(2)] = null);

(statearr_43905_43973[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (35))){
var inst_43834 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43906_43974 = state_43852__$1;
(statearr_43906_43974[(2)] = inst_43834);

(statearr_43906_43974[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (19))){
var inst_43751 = (state_43852[(7)]);
var inst_43755 = cljs.core.chunk_first.call(null,inst_43751);
var inst_43756 = cljs.core.chunk_rest.call(null,inst_43751);
var inst_43757 = cljs.core.count.call(null,inst_43755);
var inst_43729 = inst_43756;
var inst_43730 = inst_43755;
var inst_43731 = inst_43757;
var inst_43732 = (0);
var state_43852__$1 = (function (){var statearr_43907 = state_43852;
(statearr_43907[(13)] = inst_43732);

(statearr_43907[(14)] = inst_43730);

(statearr_43907[(15)] = inst_43731);

(statearr_43907[(16)] = inst_43729);

return statearr_43907;
})();
var statearr_43908_43975 = state_43852__$1;
(statearr_43908_43975[(2)] = null);

(statearr_43908_43975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (11))){
var inst_43729 = (state_43852[(16)]);
var inst_43751 = (state_43852[(7)]);
var inst_43751__$1 = cljs.core.seq.call(null,inst_43729);
var state_43852__$1 = (function (){var statearr_43909 = state_43852;
(statearr_43909[(7)] = inst_43751__$1);

return statearr_43909;
})();
if(inst_43751__$1){
var statearr_43910_43976 = state_43852__$1;
(statearr_43910_43976[(1)] = (16));

} else {
var statearr_43911_43977 = state_43852__$1;
(statearr_43911_43977[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (9))){
var inst_43781 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43912_43978 = state_43852__$1;
(statearr_43912_43978[(2)] = inst_43781);

(statearr_43912_43978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (5))){
var inst_43727 = cljs.core.deref.call(null,cs);
var inst_43728 = cljs.core.seq.call(null,inst_43727);
var inst_43729 = inst_43728;
var inst_43730 = null;
var inst_43731 = (0);
var inst_43732 = (0);
var state_43852__$1 = (function (){var statearr_43913 = state_43852;
(statearr_43913[(13)] = inst_43732);

(statearr_43913[(14)] = inst_43730);

(statearr_43913[(15)] = inst_43731);

(statearr_43913[(16)] = inst_43729);

return statearr_43913;
})();
var statearr_43914_43979 = state_43852__$1;
(statearr_43914_43979[(2)] = null);

(statearr_43914_43979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (14))){
var state_43852__$1 = state_43852;
var statearr_43915_43980 = state_43852__$1;
(statearr_43915_43980[(2)] = null);

(statearr_43915_43980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (45))){
var inst_43842 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43916_43981 = state_43852__$1;
(statearr_43916_43981[(2)] = inst_43842);

(statearr_43916_43981[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (26))){
var inst_43784 = (state_43852[(29)]);
var inst_43838 = (state_43852[(2)]);
var inst_43839 = cljs.core.seq.call(null,inst_43784);
var state_43852__$1 = (function (){var statearr_43917 = state_43852;
(statearr_43917[(31)] = inst_43838);

return statearr_43917;
})();
if(inst_43839){
var statearr_43918_43982 = state_43852__$1;
(statearr_43918_43982[(1)] = (42));

} else {
var statearr_43919_43983 = state_43852__$1;
(statearr_43919_43983[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (16))){
var inst_43751 = (state_43852[(7)]);
var inst_43753 = cljs.core.chunked_seq_QMARK_.call(null,inst_43751);
var state_43852__$1 = state_43852;
if(inst_43753){
var statearr_43920_43984 = state_43852__$1;
(statearr_43920_43984[(1)] = (19));

} else {
var statearr_43921_43985 = state_43852__$1;
(statearr_43921_43985[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (38))){
var inst_43831 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43922_43986 = state_43852__$1;
(statearr_43922_43986[(2)] = inst_43831);

(statearr_43922_43986[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (30))){
var state_43852__$1 = state_43852;
var statearr_43923_43987 = state_43852__$1;
(statearr_43923_43987[(2)] = null);

(statearr_43923_43987[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (10))){
var inst_43732 = (state_43852[(13)]);
var inst_43730 = (state_43852[(14)]);
var inst_43740 = cljs.core._nth.call(null,inst_43730,inst_43732);
var inst_43741 = cljs.core.nth.call(null,inst_43740,(0),null);
var inst_43742 = cljs.core.nth.call(null,inst_43740,(1),null);
var state_43852__$1 = (function (){var statearr_43924 = state_43852;
(statearr_43924[(26)] = inst_43741);

return statearr_43924;
})();
if(cljs.core.truth_(inst_43742)){
var statearr_43925_43988 = state_43852__$1;
(statearr_43925_43988[(1)] = (13));

} else {
var statearr_43926_43989 = state_43852__$1;
(statearr_43926_43989[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (18))){
var inst_43777 = (state_43852[(2)]);
var state_43852__$1 = state_43852;
var statearr_43927_43990 = state_43852__$1;
(statearr_43927_43990[(2)] = inst_43777);

(statearr_43927_43990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (42))){
var state_43852__$1 = state_43852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43852__$1,(45),dchan);
} else {
if((state_val_43853 === (37))){
var inst_43811 = (state_43852[(25)]);
var inst_43720 = (state_43852[(11)]);
var inst_43820 = (state_43852[(23)]);
var inst_43820__$1 = cljs.core.first.call(null,inst_43811);
var inst_43821 = cljs.core.async.put_BANG_.call(null,inst_43820__$1,inst_43720,done);
var state_43852__$1 = (function (){var statearr_43928 = state_43852;
(statearr_43928[(23)] = inst_43820__$1);

return statearr_43928;
})();
if(cljs.core.truth_(inst_43821)){
var statearr_43929_43991 = state_43852__$1;
(statearr_43929_43991[(1)] = (39));

} else {
var statearr_43930_43992 = state_43852__$1;
(statearr_43930_43992[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43853 === (8))){
var inst_43732 = (state_43852[(13)]);
var inst_43731 = (state_43852[(15)]);
var inst_43734 = (inst_43732 < inst_43731);
var inst_43735 = inst_43734;
var state_43852__$1 = state_43852;
if(cljs.core.truth_(inst_43735)){
var statearr_43931_43993 = state_43852__$1;
(statearr_43931_43993[(1)] = (10));

} else {
var statearr_43932_43994 = state_43852__$1;
(statearr_43932_43994[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___43940,cs,m,dchan,dctr,done))
;
return ((function (switch__42489__auto__,c__42603__auto___43940,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__42490__auto__ = null;
var cljs$core$async$mult_$_state_machine__42490__auto____0 = (function (){
var statearr_43936 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43936[(0)] = cljs$core$async$mult_$_state_machine__42490__auto__);

(statearr_43936[(1)] = (1));

return statearr_43936;
});
var cljs$core$async$mult_$_state_machine__42490__auto____1 = (function (state_43852){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_43852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e43937){if((e43937 instanceof Object)){
var ex__42493__auto__ = e43937;
var statearr_43938_43995 = state_43852;
(statearr_43938_43995[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43996 = state_43852;
state_43852 = G__43996;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42490__auto__ = function(state_43852){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42490__auto____1.call(this,state_43852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42490__auto____0;
cljs$core$async$mult_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42490__auto____1;
return cljs$core$async$mult_$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___43940,cs,m,dchan,dctr,done))
})();
var state__42605__auto__ = (function (){var statearr_43939 = f__42604__auto__.call(null);
(statearr_43939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___43940);

return statearr_43939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___43940,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args43997 = [];
var len__8723__auto___44000 = arguments.length;
var i__8724__auto___44001 = (0);
while(true){
if((i__8724__auto___44001 < len__8723__auto___44000)){
args43997.push((arguments[i__8724__auto___44001]));

var G__44002 = (i__8724__auto___44001 + (1));
i__8724__auto___44001 = G__44002;
continue;
} else {
}
break;
}

var G__43999 = args43997.length;
switch (G__43999) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args43997.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,ch);
} else {
var m__8221__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,ch);
} else {
var m__8221__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m);
} else {
var m__8221__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,state_map);
} else {
var m__8221__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8220__auto__ = (((m == null))?null:m);
var m__8221__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,m,mode);
} else {
var m__8221__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___44014 = arguments.length;
var i__8724__auto___44015 = (0);
while(true){
if((i__8724__auto___44015 < len__8723__auto___44014)){
args__8730__auto__.push((arguments[i__8724__auto___44015]));

var G__44016 = (i__8724__auto___44015 + (1));
i__8724__auto___44015 = G__44016;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((3) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8731__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__44008){
var map__44009 = p__44008;
var map__44009__$1 = ((((!((map__44009 == null)))?((((map__44009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44009):map__44009);
var opts = map__44009__$1;
var statearr_44011_44017 = state;
(statearr_44011_44017[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__44009,map__44009__$1,opts){
return (function (val){
var statearr_44012_44018 = state;
(statearr_44012_44018[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__44009,map__44009__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_44013_44019 = state;
(statearr_44013_44019[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq44004){
var G__44005 = cljs.core.first.call(null,seq44004);
var seq44004__$1 = cljs.core.next.call(null,seq44004);
var G__44006 = cljs.core.first.call(null,seq44004__$1);
var seq44004__$2 = cljs.core.next.call(null,seq44004__$1);
var G__44007 = cljs.core.first.call(null,seq44004__$2);
var seq44004__$3 = cljs.core.next.call(null,seq44004__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__44005,G__44006,G__44007,seq44004__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async44187 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44187 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta44188){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta44188 = meta44188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_44189,meta44188__$1){
var self__ = this;
var _44189__$1 = this;
return (new cljs.core.async.t_cljs$core$async44187(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta44188__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_44189){
var self__ = this;
var _44189__$1 = this;
return self__.meta44188;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async44187.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async44187.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta44188","meta44188",653220897,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async44187.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44187";

cljs.core.async.t_cljs$core$async44187.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44187");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async44187 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async44187(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta44188){
return (new cljs.core.async.t_cljs$core$async44187(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta44188));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async44187(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42603__auto___44354 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_44291){
var state_val_44292 = (state_44291[(1)]);
if((state_val_44292 === (7))){
var inst_44206 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
var statearr_44293_44355 = state_44291__$1;
(statearr_44293_44355[(2)] = inst_44206);

(statearr_44293_44355[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (20))){
var inst_44218 = (state_44291[(7)]);
var state_44291__$1 = state_44291;
var statearr_44294_44356 = state_44291__$1;
(statearr_44294_44356[(2)] = inst_44218);

(statearr_44294_44356[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (27))){
var state_44291__$1 = state_44291;
var statearr_44295_44357 = state_44291__$1;
(statearr_44295_44357[(2)] = null);

(statearr_44295_44357[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (1))){
var inst_44193 = (state_44291[(8)]);
var inst_44193__$1 = calc_state.call(null);
var inst_44195 = (inst_44193__$1 == null);
var inst_44196 = cljs.core.not.call(null,inst_44195);
var state_44291__$1 = (function (){var statearr_44296 = state_44291;
(statearr_44296[(8)] = inst_44193__$1);

return statearr_44296;
})();
if(inst_44196){
var statearr_44297_44358 = state_44291__$1;
(statearr_44297_44358[(1)] = (2));

} else {
var statearr_44298_44359 = state_44291__$1;
(statearr_44298_44359[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (24))){
var inst_44242 = (state_44291[(9)]);
var inst_44265 = (state_44291[(10)]);
var inst_44251 = (state_44291[(11)]);
var inst_44265__$1 = inst_44242.call(null,inst_44251);
var state_44291__$1 = (function (){var statearr_44299 = state_44291;
(statearr_44299[(10)] = inst_44265__$1);

return statearr_44299;
})();
if(cljs.core.truth_(inst_44265__$1)){
var statearr_44300_44360 = state_44291__$1;
(statearr_44300_44360[(1)] = (29));

} else {
var statearr_44301_44361 = state_44291__$1;
(statearr_44301_44361[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (4))){
var inst_44209 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44209)){
var statearr_44302_44362 = state_44291__$1;
(statearr_44302_44362[(1)] = (8));

} else {
var statearr_44303_44363 = state_44291__$1;
(statearr_44303_44363[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (15))){
var inst_44236 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44236)){
var statearr_44304_44364 = state_44291__$1;
(statearr_44304_44364[(1)] = (19));

} else {
var statearr_44305_44365 = state_44291__$1;
(statearr_44305_44365[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (21))){
var inst_44241 = (state_44291[(12)]);
var inst_44241__$1 = (state_44291[(2)]);
var inst_44242 = cljs.core.get.call(null,inst_44241__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44243 = cljs.core.get.call(null,inst_44241__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44244 = cljs.core.get.call(null,inst_44241__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44291__$1 = (function (){var statearr_44306 = state_44291;
(statearr_44306[(9)] = inst_44242);

(statearr_44306[(13)] = inst_44243);

(statearr_44306[(12)] = inst_44241__$1);

return statearr_44306;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_44291__$1,(22),inst_44244);
} else {
if((state_val_44292 === (31))){
var inst_44273 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44273)){
var statearr_44307_44366 = state_44291__$1;
(statearr_44307_44366[(1)] = (32));

} else {
var statearr_44308_44367 = state_44291__$1;
(statearr_44308_44367[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (32))){
var inst_44250 = (state_44291[(14)]);
var state_44291__$1 = state_44291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44291__$1,(35),out,inst_44250);
} else {
if((state_val_44292 === (33))){
var inst_44241 = (state_44291[(12)]);
var inst_44218 = inst_44241;
var state_44291__$1 = (function (){var statearr_44309 = state_44291;
(statearr_44309[(7)] = inst_44218);

return statearr_44309;
})();
var statearr_44310_44368 = state_44291__$1;
(statearr_44310_44368[(2)] = null);

(statearr_44310_44368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (13))){
var inst_44218 = (state_44291[(7)]);
var inst_44225 = inst_44218.cljs$lang$protocol_mask$partition0$;
var inst_44226 = (inst_44225 & (64));
var inst_44227 = inst_44218.cljs$core$ISeq$;
var inst_44228 = (cljs.core.PROTOCOL_SENTINEL === inst_44227);
var inst_44229 = (inst_44226) || (inst_44228);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44229)){
var statearr_44311_44369 = state_44291__$1;
(statearr_44311_44369[(1)] = (16));

} else {
var statearr_44312_44370 = state_44291__$1;
(statearr_44312_44370[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (22))){
var inst_44250 = (state_44291[(14)]);
var inst_44251 = (state_44291[(11)]);
var inst_44249 = (state_44291[(2)]);
var inst_44250__$1 = cljs.core.nth.call(null,inst_44249,(0),null);
var inst_44251__$1 = cljs.core.nth.call(null,inst_44249,(1),null);
var inst_44252 = (inst_44250__$1 == null);
var inst_44253 = cljs.core._EQ_.call(null,inst_44251__$1,change);
var inst_44254 = (inst_44252) || (inst_44253);
var state_44291__$1 = (function (){var statearr_44313 = state_44291;
(statearr_44313[(14)] = inst_44250__$1);

(statearr_44313[(11)] = inst_44251__$1);

return statearr_44313;
})();
if(cljs.core.truth_(inst_44254)){
var statearr_44314_44371 = state_44291__$1;
(statearr_44314_44371[(1)] = (23));

} else {
var statearr_44315_44372 = state_44291__$1;
(statearr_44315_44372[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (36))){
var inst_44241 = (state_44291[(12)]);
var inst_44218 = inst_44241;
var state_44291__$1 = (function (){var statearr_44316 = state_44291;
(statearr_44316[(7)] = inst_44218);

return statearr_44316;
})();
var statearr_44317_44373 = state_44291__$1;
(statearr_44317_44373[(2)] = null);

(statearr_44317_44373[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (29))){
var inst_44265 = (state_44291[(10)]);
var state_44291__$1 = state_44291;
var statearr_44318_44374 = state_44291__$1;
(statearr_44318_44374[(2)] = inst_44265);

(statearr_44318_44374[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (6))){
var state_44291__$1 = state_44291;
var statearr_44319_44375 = state_44291__$1;
(statearr_44319_44375[(2)] = false);

(statearr_44319_44375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (28))){
var inst_44261 = (state_44291[(2)]);
var inst_44262 = calc_state.call(null);
var inst_44218 = inst_44262;
var state_44291__$1 = (function (){var statearr_44320 = state_44291;
(statearr_44320[(7)] = inst_44218);

(statearr_44320[(15)] = inst_44261);

return statearr_44320;
})();
var statearr_44321_44376 = state_44291__$1;
(statearr_44321_44376[(2)] = null);

(statearr_44321_44376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (25))){
var inst_44287 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
var statearr_44322_44377 = state_44291__$1;
(statearr_44322_44377[(2)] = inst_44287);

(statearr_44322_44377[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (34))){
var inst_44285 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
var statearr_44323_44378 = state_44291__$1;
(statearr_44323_44378[(2)] = inst_44285);

(statearr_44323_44378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (17))){
var state_44291__$1 = state_44291;
var statearr_44324_44379 = state_44291__$1;
(statearr_44324_44379[(2)] = false);

(statearr_44324_44379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (3))){
var state_44291__$1 = state_44291;
var statearr_44325_44380 = state_44291__$1;
(statearr_44325_44380[(2)] = false);

(statearr_44325_44380[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (12))){
var inst_44289 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44291__$1,inst_44289);
} else {
if((state_val_44292 === (2))){
var inst_44193 = (state_44291[(8)]);
var inst_44198 = inst_44193.cljs$lang$protocol_mask$partition0$;
var inst_44199 = (inst_44198 & (64));
var inst_44200 = inst_44193.cljs$core$ISeq$;
var inst_44201 = (cljs.core.PROTOCOL_SENTINEL === inst_44200);
var inst_44202 = (inst_44199) || (inst_44201);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44202)){
var statearr_44326_44381 = state_44291__$1;
(statearr_44326_44381[(1)] = (5));

} else {
var statearr_44327_44382 = state_44291__$1;
(statearr_44327_44382[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (23))){
var inst_44250 = (state_44291[(14)]);
var inst_44256 = (inst_44250 == null);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44256)){
var statearr_44328_44383 = state_44291__$1;
(statearr_44328_44383[(1)] = (26));

} else {
var statearr_44329_44384 = state_44291__$1;
(statearr_44329_44384[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (35))){
var inst_44276 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
if(cljs.core.truth_(inst_44276)){
var statearr_44330_44385 = state_44291__$1;
(statearr_44330_44385[(1)] = (36));

} else {
var statearr_44331_44386 = state_44291__$1;
(statearr_44331_44386[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (19))){
var inst_44218 = (state_44291[(7)]);
var inst_44238 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44218);
var state_44291__$1 = state_44291;
var statearr_44332_44387 = state_44291__$1;
(statearr_44332_44387[(2)] = inst_44238);

(statearr_44332_44387[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (11))){
var inst_44218 = (state_44291[(7)]);
var inst_44222 = (inst_44218 == null);
var inst_44223 = cljs.core.not.call(null,inst_44222);
var state_44291__$1 = state_44291;
if(inst_44223){
var statearr_44333_44388 = state_44291__$1;
(statearr_44333_44388[(1)] = (13));

} else {
var statearr_44334_44389 = state_44291__$1;
(statearr_44334_44389[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (9))){
var inst_44193 = (state_44291[(8)]);
var state_44291__$1 = state_44291;
var statearr_44335_44390 = state_44291__$1;
(statearr_44335_44390[(2)] = inst_44193);

(statearr_44335_44390[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (5))){
var state_44291__$1 = state_44291;
var statearr_44336_44391 = state_44291__$1;
(statearr_44336_44391[(2)] = true);

(statearr_44336_44391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (14))){
var state_44291__$1 = state_44291;
var statearr_44337_44392 = state_44291__$1;
(statearr_44337_44392[(2)] = false);

(statearr_44337_44392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (26))){
var inst_44251 = (state_44291[(11)]);
var inst_44258 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_44251);
var state_44291__$1 = state_44291;
var statearr_44338_44393 = state_44291__$1;
(statearr_44338_44393[(2)] = inst_44258);

(statearr_44338_44393[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (16))){
var state_44291__$1 = state_44291;
var statearr_44339_44394 = state_44291__$1;
(statearr_44339_44394[(2)] = true);

(statearr_44339_44394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (38))){
var inst_44281 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
var statearr_44340_44395 = state_44291__$1;
(statearr_44340_44395[(2)] = inst_44281);

(statearr_44340_44395[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (30))){
var inst_44242 = (state_44291[(9)]);
var inst_44243 = (state_44291[(13)]);
var inst_44251 = (state_44291[(11)]);
var inst_44268 = cljs.core.empty_QMARK_.call(null,inst_44242);
var inst_44269 = inst_44243.call(null,inst_44251);
var inst_44270 = cljs.core.not.call(null,inst_44269);
var inst_44271 = (inst_44268) && (inst_44270);
var state_44291__$1 = state_44291;
var statearr_44341_44396 = state_44291__$1;
(statearr_44341_44396[(2)] = inst_44271);

(statearr_44341_44396[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (10))){
var inst_44193 = (state_44291[(8)]);
var inst_44214 = (state_44291[(2)]);
var inst_44215 = cljs.core.get.call(null,inst_44214,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44216 = cljs.core.get.call(null,inst_44214,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44217 = cljs.core.get.call(null,inst_44214,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_44218 = inst_44193;
var state_44291__$1 = (function (){var statearr_44342 = state_44291;
(statearr_44342[(7)] = inst_44218);

(statearr_44342[(16)] = inst_44217);

(statearr_44342[(17)] = inst_44216);

(statearr_44342[(18)] = inst_44215);

return statearr_44342;
})();
var statearr_44343_44397 = state_44291__$1;
(statearr_44343_44397[(2)] = null);

(statearr_44343_44397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (18))){
var inst_44233 = (state_44291[(2)]);
var state_44291__$1 = state_44291;
var statearr_44344_44398 = state_44291__$1;
(statearr_44344_44398[(2)] = inst_44233);

(statearr_44344_44398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (37))){
var state_44291__$1 = state_44291;
var statearr_44345_44399 = state_44291__$1;
(statearr_44345_44399[(2)] = null);

(statearr_44345_44399[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44292 === (8))){
var inst_44193 = (state_44291[(8)]);
var inst_44211 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44193);
var state_44291__$1 = state_44291;
var statearr_44346_44400 = state_44291__$1;
(statearr_44346_44400[(2)] = inst_44211);

(statearr_44346_44400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__42489__auto__,c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__42490__auto__ = null;
var cljs$core$async$mix_$_state_machine__42490__auto____0 = (function (){
var statearr_44350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44350[(0)] = cljs$core$async$mix_$_state_machine__42490__auto__);

(statearr_44350[(1)] = (1));

return statearr_44350;
});
var cljs$core$async$mix_$_state_machine__42490__auto____1 = (function (state_44291){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44351){if((e44351 instanceof Object)){
var ex__42493__auto__ = e44351;
var statearr_44352_44401 = state_44291;
(statearr_44352_44401[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44351;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44402 = state_44291;
state_44291 = G__44402;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42490__auto__ = function(state_44291){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42490__auto____1.call(this,state_44291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42490__auto____0;
cljs$core$async$mix_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42490__auto____1;
return cljs$core$async$mix_$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__42605__auto__ = (function (){var statearr_44353 = f__42604__auto__.call(null);
(statearr_44353[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44354);

return statearr_44353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8220__auto__ = (((p == null))?null:p);
var m__8221__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8221__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8220__auto__ = (((p == null))?null:p);
var m__8221__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,p,v,ch);
} else {
var m__8221__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args44403 = [];
var len__8723__auto___44406 = arguments.length;
var i__8724__auto___44407 = (0);
while(true){
if((i__8724__auto___44407 < len__8723__auto___44406)){
args44403.push((arguments[i__8724__auto___44407]));

var G__44408 = (i__8724__auto___44407 + (1));
i__8724__auto___44407 = G__44408;
continue;
} else {
}
break;
}

var G__44405 = args44403.length;
switch (G__44405) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44403.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8220__auto__ = (((p == null))?null:p);
var m__8221__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,p);
} else {
var m__8221__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8220__auto__ = (((p == null))?null:p);
var m__8221__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,p,v);
} else {
var m__8221__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args44411 = [];
var len__8723__auto___44536 = arguments.length;
var i__8724__auto___44537 = (0);
while(true){
if((i__8724__auto___44537 < len__8723__auto___44536)){
args44411.push((arguments[i__8724__auto___44537]));

var G__44538 = (i__8724__auto___44537 + (1));
i__8724__auto___44537 = G__44538;
continue;
} else {
}
break;
}

var G__44413 = args44411.length;
switch (G__44413) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44411.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__7502__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7502__auto__,mults){
return (function (p1__44410_SHARP_){
if(cljs.core.truth_(p1__44410_SHARP_.call(null,topic))){
return p1__44410_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__44410_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7502__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async44414 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44414 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44415){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44415 = meta44415;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_44416,meta44415__$1){
var self__ = this;
var _44416__$1 = this;
return (new cljs.core.async.t_cljs$core$async44414(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44415__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_44416){
var self__ = this;
var _44416__$1 = this;
return self__.meta44415;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async44414.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async44414.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44415","meta44415",1804190265,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async44414.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44414.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44414";

cljs.core.async.t_cljs$core$async44414.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44414");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async44414 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async44414(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44415){
return (new cljs.core.async.t_cljs$core$async44414(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44415));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async44414(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42603__auto___44540 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44540,mults,ensure_mult,p){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44540,mults,ensure_mult,p){
return (function (state_44488){
var state_val_44489 = (state_44488[(1)]);
if((state_val_44489 === (7))){
var inst_44484 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44490_44541 = state_44488__$1;
(statearr_44490_44541[(2)] = inst_44484);

(statearr_44490_44541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (20))){
var state_44488__$1 = state_44488;
var statearr_44491_44542 = state_44488__$1;
(statearr_44491_44542[(2)] = null);

(statearr_44491_44542[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (1))){
var state_44488__$1 = state_44488;
var statearr_44492_44543 = state_44488__$1;
(statearr_44492_44543[(2)] = null);

(statearr_44492_44543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (24))){
var inst_44467 = (state_44488[(7)]);
var inst_44476 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_44467);
var state_44488__$1 = state_44488;
var statearr_44493_44544 = state_44488__$1;
(statearr_44493_44544[(2)] = inst_44476);

(statearr_44493_44544[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (4))){
var inst_44419 = (state_44488[(8)]);
var inst_44419__$1 = (state_44488[(2)]);
var inst_44420 = (inst_44419__$1 == null);
var state_44488__$1 = (function (){var statearr_44494 = state_44488;
(statearr_44494[(8)] = inst_44419__$1);

return statearr_44494;
})();
if(cljs.core.truth_(inst_44420)){
var statearr_44495_44545 = state_44488__$1;
(statearr_44495_44545[(1)] = (5));

} else {
var statearr_44496_44546 = state_44488__$1;
(statearr_44496_44546[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (15))){
var inst_44461 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44497_44547 = state_44488__$1;
(statearr_44497_44547[(2)] = inst_44461);

(statearr_44497_44547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (21))){
var inst_44481 = (state_44488[(2)]);
var state_44488__$1 = (function (){var statearr_44498 = state_44488;
(statearr_44498[(9)] = inst_44481);

return statearr_44498;
})();
var statearr_44499_44548 = state_44488__$1;
(statearr_44499_44548[(2)] = null);

(statearr_44499_44548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (13))){
var inst_44443 = (state_44488[(10)]);
var inst_44445 = cljs.core.chunked_seq_QMARK_.call(null,inst_44443);
var state_44488__$1 = state_44488;
if(inst_44445){
var statearr_44500_44549 = state_44488__$1;
(statearr_44500_44549[(1)] = (16));

} else {
var statearr_44501_44550 = state_44488__$1;
(statearr_44501_44550[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (22))){
var inst_44473 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
if(cljs.core.truth_(inst_44473)){
var statearr_44502_44551 = state_44488__$1;
(statearr_44502_44551[(1)] = (23));

} else {
var statearr_44503_44552 = state_44488__$1;
(statearr_44503_44552[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (6))){
var inst_44467 = (state_44488[(7)]);
var inst_44419 = (state_44488[(8)]);
var inst_44469 = (state_44488[(11)]);
var inst_44467__$1 = topic_fn.call(null,inst_44419);
var inst_44468 = cljs.core.deref.call(null,mults);
var inst_44469__$1 = cljs.core.get.call(null,inst_44468,inst_44467__$1);
var state_44488__$1 = (function (){var statearr_44504 = state_44488;
(statearr_44504[(7)] = inst_44467__$1);

(statearr_44504[(11)] = inst_44469__$1);

return statearr_44504;
})();
if(cljs.core.truth_(inst_44469__$1)){
var statearr_44505_44553 = state_44488__$1;
(statearr_44505_44553[(1)] = (19));

} else {
var statearr_44506_44554 = state_44488__$1;
(statearr_44506_44554[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (25))){
var inst_44478 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44507_44555 = state_44488__$1;
(statearr_44507_44555[(2)] = inst_44478);

(statearr_44507_44555[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (17))){
var inst_44443 = (state_44488[(10)]);
var inst_44452 = cljs.core.first.call(null,inst_44443);
var inst_44453 = cljs.core.async.muxch_STAR_.call(null,inst_44452);
var inst_44454 = cljs.core.async.close_BANG_.call(null,inst_44453);
var inst_44455 = cljs.core.next.call(null,inst_44443);
var inst_44429 = inst_44455;
var inst_44430 = null;
var inst_44431 = (0);
var inst_44432 = (0);
var state_44488__$1 = (function (){var statearr_44508 = state_44488;
(statearr_44508[(12)] = inst_44429);

(statearr_44508[(13)] = inst_44432);

(statearr_44508[(14)] = inst_44430);

(statearr_44508[(15)] = inst_44454);

(statearr_44508[(16)] = inst_44431);

return statearr_44508;
})();
var statearr_44509_44556 = state_44488__$1;
(statearr_44509_44556[(2)] = null);

(statearr_44509_44556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (3))){
var inst_44486 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44488__$1,inst_44486);
} else {
if((state_val_44489 === (12))){
var inst_44463 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44510_44557 = state_44488__$1;
(statearr_44510_44557[(2)] = inst_44463);

(statearr_44510_44557[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (2))){
var state_44488__$1 = state_44488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44488__$1,(4),ch);
} else {
if((state_val_44489 === (23))){
var state_44488__$1 = state_44488;
var statearr_44511_44558 = state_44488__$1;
(statearr_44511_44558[(2)] = null);

(statearr_44511_44558[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (19))){
var inst_44419 = (state_44488[(8)]);
var inst_44469 = (state_44488[(11)]);
var inst_44471 = cljs.core.async.muxch_STAR_.call(null,inst_44469);
var state_44488__$1 = state_44488;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44488__$1,(22),inst_44471,inst_44419);
} else {
if((state_val_44489 === (11))){
var inst_44429 = (state_44488[(12)]);
var inst_44443 = (state_44488[(10)]);
var inst_44443__$1 = cljs.core.seq.call(null,inst_44429);
var state_44488__$1 = (function (){var statearr_44512 = state_44488;
(statearr_44512[(10)] = inst_44443__$1);

return statearr_44512;
})();
if(inst_44443__$1){
var statearr_44513_44559 = state_44488__$1;
(statearr_44513_44559[(1)] = (13));

} else {
var statearr_44514_44560 = state_44488__$1;
(statearr_44514_44560[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (9))){
var inst_44465 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44515_44561 = state_44488__$1;
(statearr_44515_44561[(2)] = inst_44465);

(statearr_44515_44561[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (5))){
var inst_44426 = cljs.core.deref.call(null,mults);
var inst_44427 = cljs.core.vals.call(null,inst_44426);
var inst_44428 = cljs.core.seq.call(null,inst_44427);
var inst_44429 = inst_44428;
var inst_44430 = null;
var inst_44431 = (0);
var inst_44432 = (0);
var state_44488__$1 = (function (){var statearr_44516 = state_44488;
(statearr_44516[(12)] = inst_44429);

(statearr_44516[(13)] = inst_44432);

(statearr_44516[(14)] = inst_44430);

(statearr_44516[(16)] = inst_44431);

return statearr_44516;
})();
var statearr_44517_44562 = state_44488__$1;
(statearr_44517_44562[(2)] = null);

(statearr_44517_44562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (14))){
var state_44488__$1 = state_44488;
var statearr_44521_44563 = state_44488__$1;
(statearr_44521_44563[(2)] = null);

(statearr_44521_44563[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (16))){
var inst_44443 = (state_44488[(10)]);
var inst_44447 = cljs.core.chunk_first.call(null,inst_44443);
var inst_44448 = cljs.core.chunk_rest.call(null,inst_44443);
var inst_44449 = cljs.core.count.call(null,inst_44447);
var inst_44429 = inst_44448;
var inst_44430 = inst_44447;
var inst_44431 = inst_44449;
var inst_44432 = (0);
var state_44488__$1 = (function (){var statearr_44522 = state_44488;
(statearr_44522[(12)] = inst_44429);

(statearr_44522[(13)] = inst_44432);

(statearr_44522[(14)] = inst_44430);

(statearr_44522[(16)] = inst_44431);

return statearr_44522;
})();
var statearr_44523_44564 = state_44488__$1;
(statearr_44523_44564[(2)] = null);

(statearr_44523_44564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (10))){
var inst_44429 = (state_44488[(12)]);
var inst_44432 = (state_44488[(13)]);
var inst_44430 = (state_44488[(14)]);
var inst_44431 = (state_44488[(16)]);
var inst_44437 = cljs.core._nth.call(null,inst_44430,inst_44432);
var inst_44438 = cljs.core.async.muxch_STAR_.call(null,inst_44437);
var inst_44439 = cljs.core.async.close_BANG_.call(null,inst_44438);
var inst_44440 = (inst_44432 + (1));
var tmp44518 = inst_44429;
var tmp44519 = inst_44430;
var tmp44520 = inst_44431;
var inst_44429__$1 = tmp44518;
var inst_44430__$1 = tmp44519;
var inst_44431__$1 = tmp44520;
var inst_44432__$1 = inst_44440;
var state_44488__$1 = (function (){var statearr_44524 = state_44488;
(statearr_44524[(12)] = inst_44429__$1);

(statearr_44524[(17)] = inst_44439);

(statearr_44524[(13)] = inst_44432__$1);

(statearr_44524[(14)] = inst_44430__$1);

(statearr_44524[(16)] = inst_44431__$1);

return statearr_44524;
})();
var statearr_44525_44565 = state_44488__$1;
(statearr_44525_44565[(2)] = null);

(statearr_44525_44565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (18))){
var inst_44458 = (state_44488[(2)]);
var state_44488__$1 = state_44488;
var statearr_44526_44566 = state_44488__$1;
(statearr_44526_44566[(2)] = inst_44458);

(statearr_44526_44566[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44489 === (8))){
var inst_44432 = (state_44488[(13)]);
var inst_44431 = (state_44488[(16)]);
var inst_44434 = (inst_44432 < inst_44431);
var inst_44435 = inst_44434;
var state_44488__$1 = state_44488;
if(cljs.core.truth_(inst_44435)){
var statearr_44527_44567 = state_44488__$1;
(statearr_44527_44567[(1)] = (10));

} else {
var statearr_44528_44568 = state_44488__$1;
(statearr_44528_44568[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44540,mults,ensure_mult,p))
;
return ((function (switch__42489__auto__,c__42603__auto___44540,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_44532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44532[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_44532[(1)] = (1));

return statearr_44532;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_44488){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44533){if((e44533 instanceof Object)){
var ex__42493__auto__ = e44533;
var statearr_44534_44569 = state_44488;
(statearr_44534_44569[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44488);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44533;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44570 = state_44488;
state_44488 = G__44570;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_44488){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_44488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44540,mults,ensure_mult,p))
})();
var state__42605__auto__ = (function (){var statearr_44535 = f__42604__auto__.call(null);
(statearr_44535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44540);

return statearr_44535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44540,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args44571 = [];
var len__8723__auto___44574 = arguments.length;
var i__8724__auto___44575 = (0);
while(true){
if((i__8724__auto___44575 < len__8723__auto___44574)){
args44571.push((arguments[i__8724__auto___44575]));

var G__44576 = (i__8724__auto___44575 + (1));
i__8724__auto___44575 = G__44576;
continue;
} else {
}
break;
}

var G__44573 = args44571.length;
switch (G__44573) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44571.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args44578 = [];
var len__8723__auto___44581 = arguments.length;
var i__8724__auto___44582 = (0);
while(true){
if((i__8724__auto___44582 < len__8723__auto___44581)){
args44578.push((arguments[i__8724__auto___44582]));

var G__44583 = (i__8724__auto___44582 + (1));
i__8724__auto___44582 = G__44583;
continue;
} else {
}
break;
}

var G__44580 = args44578.length;
switch (G__44580) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44578.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args44585 = [];
var len__8723__auto___44656 = arguments.length;
var i__8724__auto___44657 = (0);
while(true){
if((i__8724__auto___44657 < len__8723__auto___44656)){
args44585.push((arguments[i__8724__auto___44657]));

var G__44658 = (i__8724__auto___44657 + (1));
i__8724__auto___44657 = G__44658;
continue;
} else {
}
break;
}

var G__44587 = args44585.length;
switch (G__44587) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44585.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__42603__auto___44660 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_44626){
var state_val_44627 = (state_44626[(1)]);
if((state_val_44627 === (7))){
var state_44626__$1 = state_44626;
var statearr_44628_44661 = state_44626__$1;
(statearr_44628_44661[(2)] = null);

(statearr_44628_44661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (1))){
var state_44626__$1 = state_44626;
var statearr_44629_44662 = state_44626__$1;
(statearr_44629_44662[(2)] = null);

(statearr_44629_44662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (4))){
var inst_44590 = (state_44626[(7)]);
var inst_44592 = (inst_44590 < cnt);
var state_44626__$1 = state_44626;
if(cljs.core.truth_(inst_44592)){
var statearr_44630_44663 = state_44626__$1;
(statearr_44630_44663[(1)] = (6));

} else {
var statearr_44631_44664 = state_44626__$1;
(statearr_44631_44664[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (15))){
var inst_44622 = (state_44626[(2)]);
var state_44626__$1 = state_44626;
var statearr_44632_44665 = state_44626__$1;
(statearr_44632_44665[(2)] = inst_44622);

(statearr_44632_44665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (13))){
var inst_44615 = cljs.core.async.close_BANG_.call(null,out);
var state_44626__$1 = state_44626;
var statearr_44633_44666 = state_44626__$1;
(statearr_44633_44666[(2)] = inst_44615);

(statearr_44633_44666[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (6))){
var state_44626__$1 = state_44626;
var statearr_44634_44667 = state_44626__$1;
(statearr_44634_44667[(2)] = null);

(statearr_44634_44667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (3))){
var inst_44624 = (state_44626[(2)]);
var state_44626__$1 = state_44626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44626__$1,inst_44624);
} else {
if((state_val_44627 === (12))){
var inst_44612 = (state_44626[(8)]);
var inst_44612__$1 = (state_44626[(2)]);
var inst_44613 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_44612__$1);
var state_44626__$1 = (function (){var statearr_44635 = state_44626;
(statearr_44635[(8)] = inst_44612__$1);

return statearr_44635;
})();
if(cljs.core.truth_(inst_44613)){
var statearr_44636_44668 = state_44626__$1;
(statearr_44636_44668[(1)] = (13));

} else {
var statearr_44637_44669 = state_44626__$1;
(statearr_44637_44669[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (2))){
var inst_44589 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_44590 = (0);
var state_44626__$1 = (function (){var statearr_44638 = state_44626;
(statearr_44638[(9)] = inst_44589);

(statearr_44638[(7)] = inst_44590);

return statearr_44638;
})();
var statearr_44639_44670 = state_44626__$1;
(statearr_44639_44670[(2)] = null);

(statearr_44639_44670[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (11))){
var inst_44590 = (state_44626[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_44626,(10),Object,null,(9));
var inst_44599 = chs__$1.call(null,inst_44590);
var inst_44600 = done.call(null,inst_44590);
var inst_44601 = cljs.core.async.take_BANG_.call(null,inst_44599,inst_44600);
var state_44626__$1 = state_44626;
var statearr_44640_44671 = state_44626__$1;
(statearr_44640_44671[(2)] = inst_44601);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44626__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (9))){
var inst_44590 = (state_44626[(7)]);
var inst_44603 = (state_44626[(2)]);
var inst_44604 = (inst_44590 + (1));
var inst_44590__$1 = inst_44604;
var state_44626__$1 = (function (){var statearr_44641 = state_44626;
(statearr_44641[(7)] = inst_44590__$1);

(statearr_44641[(10)] = inst_44603);

return statearr_44641;
})();
var statearr_44642_44672 = state_44626__$1;
(statearr_44642_44672[(2)] = null);

(statearr_44642_44672[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (5))){
var inst_44610 = (state_44626[(2)]);
var state_44626__$1 = (function (){var statearr_44643 = state_44626;
(statearr_44643[(11)] = inst_44610);

return statearr_44643;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44626__$1,(12),dchan);
} else {
if((state_val_44627 === (14))){
var inst_44612 = (state_44626[(8)]);
var inst_44617 = cljs.core.apply.call(null,f,inst_44612);
var state_44626__$1 = state_44626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44626__$1,(16),out,inst_44617);
} else {
if((state_val_44627 === (16))){
var inst_44619 = (state_44626[(2)]);
var state_44626__$1 = (function (){var statearr_44644 = state_44626;
(statearr_44644[(12)] = inst_44619);

return statearr_44644;
})();
var statearr_44645_44673 = state_44626__$1;
(statearr_44645_44673[(2)] = null);

(statearr_44645_44673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (10))){
var inst_44594 = (state_44626[(2)]);
var inst_44595 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_44626__$1 = (function (){var statearr_44646 = state_44626;
(statearr_44646[(13)] = inst_44594);

return statearr_44646;
})();
var statearr_44647_44674 = state_44626__$1;
(statearr_44647_44674[(2)] = inst_44595);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44626__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44627 === (8))){
var inst_44608 = (state_44626[(2)]);
var state_44626__$1 = state_44626;
var statearr_44648_44675 = state_44626__$1;
(statearr_44648_44675[(2)] = inst_44608);

(statearr_44648_44675[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__42489__auto__,c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_44652 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44652[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_44652[(1)] = (1));

return statearr_44652;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_44626){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44653){if((e44653 instanceof Object)){
var ex__42493__auto__ = e44653;
var statearr_44654_44676 = state_44626;
(statearr_44654_44676[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44653;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44677 = state_44626;
state_44626 = G__44677;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_44626){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_44626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__42605__auto__ = (function (){var statearr_44655 = f__42604__auto__.call(null);
(statearr_44655[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44660);

return statearr_44655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44660,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args44679 = [];
var len__8723__auto___44737 = arguments.length;
var i__8724__auto___44738 = (0);
while(true){
if((i__8724__auto___44738 < len__8723__auto___44737)){
args44679.push((arguments[i__8724__auto___44738]));

var G__44739 = (i__8724__auto___44738 + (1));
i__8724__auto___44738 = G__44739;
continue;
} else {
}
break;
}

var G__44681 = args44679.length;
switch (G__44681) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44679.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___44741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44741,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44741,out){
return (function (state_44713){
var state_val_44714 = (state_44713[(1)]);
if((state_val_44714 === (7))){
var inst_44692 = (state_44713[(7)]);
var inst_44693 = (state_44713[(8)]);
var inst_44692__$1 = (state_44713[(2)]);
var inst_44693__$1 = cljs.core.nth.call(null,inst_44692__$1,(0),null);
var inst_44694 = cljs.core.nth.call(null,inst_44692__$1,(1),null);
var inst_44695 = (inst_44693__$1 == null);
var state_44713__$1 = (function (){var statearr_44715 = state_44713;
(statearr_44715[(7)] = inst_44692__$1);

(statearr_44715[(9)] = inst_44694);

(statearr_44715[(8)] = inst_44693__$1);

return statearr_44715;
})();
if(cljs.core.truth_(inst_44695)){
var statearr_44716_44742 = state_44713__$1;
(statearr_44716_44742[(1)] = (8));

} else {
var statearr_44717_44743 = state_44713__$1;
(statearr_44717_44743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (1))){
var inst_44682 = cljs.core.vec.call(null,chs);
var inst_44683 = inst_44682;
var state_44713__$1 = (function (){var statearr_44718 = state_44713;
(statearr_44718[(10)] = inst_44683);

return statearr_44718;
})();
var statearr_44719_44744 = state_44713__$1;
(statearr_44719_44744[(2)] = null);

(statearr_44719_44744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (4))){
var inst_44683 = (state_44713[(10)]);
var state_44713__$1 = state_44713;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44713__$1,(7),inst_44683);
} else {
if((state_val_44714 === (6))){
var inst_44709 = (state_44713[(2)]);
var state_44713__$1 = state_44713;
var statearr_44720_44745 = state_44713__$1;
(statearr_44720_44745[(2)] = inst_44709);

(statearr_44720_44745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (3))){
var inst_44711 = (state_44713[(2)]);
var state_44713__$1 = state_44713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44713__$1,inst_44711);
} else {
if((state_val_44714 === (2))){
var inst_44683 = (state_44713[(10)]);
var inst_44685 = cljs.core.count.call(null,inst_44683);
var inst_44686 = (inst_44685 > (0));
var state_44713__$1 = state_44713;
if(cljs.core.truth_(inst_44686)){
var statearr_44722_44746 = state_44713__$1;
(statearr_44722_44746[(1)] = (4));

} else {
var statearr_44723_44747 = state_44713__$1;
(statearr_44723_44747[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (11))){
var inst_44683 = (state_44713[(10)]);
var inst_44702 = (state_44713[(2)]);
var tmp44721 = inst_44683;
var inst_44683__$1 = tmp44721;
var state_44713__$1 = (function (){var statearr_44724 = state_44713;
(statearr_44724[(10)] = inst_44683__$1);

(statearr_44724[(11)] = inst_44702);

return statearr_44724;
})();
var statearr_44725_44748 = state_44713__$1;
(statearr_44725_44748[(2)] = null);

(statearr_44725_44748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (9))){
var inst_44693 = (state_44713[(8)]);
var state_44713__$1 = state_44713;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44713__$1,(11),out,inst_44693);
} else {
if((state_val_44714 === (5))){
var inst_44707 = cljs.core.async.close_BANG_.call(null,out);
var state_44713__$1 = state_44713;
var statearr_44726_44749 = state_44713__$1;
(statearr_44726_44749[(2)] = inst_44707);

(statearr_44726_44749[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (10))){
var inst_44705 = (state_44713[(2)]);
var state_44713__$1 = state_44713;
var statearr_44727_44750 = state_44713__$1;
(statearr_44727_44750[(2)] = inst_44705);

(statearr_44727_44750[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44714 === (8))){
var inst_44683 = (state_44713[(10)]);
var inst_44692 = (state_44713[(7)]);
var inst_44694 = (state_44713[(9)]);
var inst_44693 = (state_44713[(8)]);
var inst_44697 = (function (){var cs = inst_44683;
var vec__44688 = inst_44692;
var v = inst_44693;
var c = inst_44694;
return ((function (cs,vec__44688,v,c,inst_44683,inst_44692,inst_44694,inst_44693,state_val_44714,c__42603__auto___44741,out){
return (function (p1__44678_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__44678_SHARP_);
});
;})(cs,vec__44688,v,c,inst_44683,inst_44692,inst_44694,inst_44693,state_val_44714,c__42603__auto___44741,out))
})();
var inst_44698 = cljs.core.filterv.call(null,inst_44697,inst_44683);
var inst_44683__$1 = inst_44698;
var state_44713__$1 = (function (){var statearr_44728 = state_44713;
(statearr_44728[(10)] = inst_44683__$1);

return statearr_44728;
})();
var statearr_44729_44751 = state_44713__$1;
(statearr_44729_44751[(2)] = null);

(statearr_44729_44751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44741,out))
;
return ((function (switch__42489__auto__,c__42603__auto___44741,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_44733 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44733[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_44733[(1)] = (1));

return statearr_44733;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_44713){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44734){if((e44734 instanceof Object)){
var ex__42493__auto__ = e44734;
var statearr_44735_44752 = state_44713;
(statearr_44735_44752[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44713);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44753 = state_44713;
state_44713 = G__44753;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_44713){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_44713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44741,out))
})();
var state__42605__auto__ = (function (){var statearr_44736 = f__42604__auto__.call(null);
(statearr_44736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44741);

return statearr_44736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44741,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args44754 = [];
var len__8723__auto___44803 = arguments.length;
var i__8724__auto___44804 = (0);
while(true){
if((i__8724__auto___44804 < len__8723__auto___44803)){
args44754.push((arguments[i__8724__auto___44804]));

var G__44805 = (i__8724__auto___44804 + (1));
i__8724__auto___44804 = G__44805;
continue;
} else {
}
break;
}

var G__44756 = args44754.length;
switch (G__44756) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44754.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___44807 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44807,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44807,out){
return (function (state_44780){
var state_val_44781 = (state_44780[(1)]);
if((state_val_44781 === (7))){
var inst_44762 = (state_44780[(7)]);
var inst_44762__$1 = (state_44780[(2)]);
var inst_44763 = (inst_44762__$1 == null);
var inst_44764 = cljs.core.not.call(null,inst_44763);
var state_44780__$1 = (function (){var statearr_44782 = state_44780;
(statearr_44782[(7)] = inst_44762__$1);

return statearr_44782;
})();
if(inst_44764){
var statearr_44783_44808 = state_44780__$1;
(statearr_44783_44808[(1)] = (8));

} else {
var statearr_44784_44809 = state_44780__$1;
(statearr_44784_44809[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (1))){
var inst_44757 = (0);
var state_44780__$1 = (function (){var statearr_44785 = state_44780;
(statearr_44785[(8)] = inst_44757);

return statearr_44785;
})();
var statearr_44786_44810 = state_44780__$1;
(statearr_44786_44810[(2)] = null);

(statearr_44786_44810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (4))){
var state_44780__$1 = state_44780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44780__$1,(7),ch);
} else {
if((state_val_44781 === (6))){
var inst_44775 = (state_44780[(2)]);
var state_44780__$1 = state_44780;
var statearr_44787_44811 = state_44780__$1;
(statearr_44787_44811[(2)] = inst_44775);

(statearr_44787_44811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (3))){
var inst_44777 = (state_44780[(2)]);
var inst_44778 = cljs.core.async.close_BANG_.call(null,out);
var state_44780__$1 = (function (){var statearr_44788 = state_44780;
(statearr_44788[(9)] = inst_44777);

return statearr_44788;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44780__$1,inst_44778);
} else {
if((state_val_44781 === (2))){
var inst_44757 = (state_44780[(8)]);
var inst_44759 = (inst_44757 < n);
var state_44780__$1 = state_44780;
if(cljs.core.truth_(inst_44759)){
var statearr_44789_44812 = state_44780__$1;
(statearr_44789_44812[(1)] = (4));

} else {
var statearr_44790_44813 = state_44780__$1;
(statearr_44790_44813[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (11))){
var inst_44757 = (state_44780[(8)]);
var inst_44767 = (state_44780[(2)]);
var inst_44768 = (inst_44757 + (1));
var inst_44757__$1 = inst_44768;
var state_44780__$1 = (function (){var statearr_44791 = state_44780;
(statearr_44791[(10)] = inst_44767);

(statearr_44791[(8)] = inst_44757__$1);

return statearr_44791;
})();
var statearr_44792_44814 = state_44780__$1;
(statearr_44792_44814[(2)] = null);

(statearr_44792_44814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (9))){
var state_44780__$1 = state_44780;
var statearr_44793_44815 = state_44780__$1;
(statearr_44793_44815[(2)] = null);

(statearr_44793_44815[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (5))){
var state_44780__$1 = state_44780;
var statearr_44794_44816 = state_44780__$1;
(statearr_44794_44816[(2)] = null);

(statearr_44794_44816[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (10))){
var inst_44772 = (state_44780[(2)]);
var state_44780__$1 = state_44780;
var statearr_44795_44817 = state_44780__$1;
(statearr_44795_44817[(2)] = inst_44772);

(statearr_44795_44817[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44781 === (8))){
var inst_44762 = (state_44780[(7)]);
var state_44780__$1 = state_44780;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44780__$1,(11),out,inst_44762);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44807,out))
;
return ((function (switch__42489__auto__,c__42603__auto___44807,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_44799 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44799[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_44799[(1)] = (1));

return statearr_44799;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_44780){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44800){if((e44800 instanceof Object)){
var ex__42493__auto__ = e44800;
var statearr_44801_44818 = state_44780;
(statearr_44801_44818[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44780);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44819 = state_44780;
state_44780 = G__44819;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_44780){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_44780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44807,out))
})();
var state__42605__auto__ = (function (){var statearr_44802 = f__42604__auto__.call(null);
(statearr_44802[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44807);

return statearr_44802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44807,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async44827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44827 = (function (f,ch,meta44828){
this.f = f;
this.ch = ch;
this.meta44828 = meta44828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44829,meta44828__$1){
var self__ = this;
var _44829__$1 = this;
return (new cljs.core.async.t_cljs$core$async44827(self__.f,self__.ch,meta44828__$1));
});


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44829){
var self__ = this;
var _44829__$1 = this;
return self__.meta44828;
});


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async44830 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44830 = (function (f,ch,meta44828,_,fn1,meta44831){
this.f = f;
this.ch = ch;
this.meta44828 = meta44828;
this._ = _;
this.fn1 = fn1;
this.meta44831 = meta44831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_44832,meta44831__$1){
var self__ = this;
var _44832__$1 = this;
return (new cljs.core.async.t_cljs$core$async44830(self__.f,self__.ch,self__.meta44828,self__._,self__.fn1,meta44831__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_44832){
var self__ = this;
var _44832__$1 = this;
return self__.meta44831;
});})(___$1))
;


cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async44830.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__44820_SHARP_){
return f1.call(null,(((p1__44820_SHARP_ == null))?null:self__.f.call(null,p1__44820_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async44830.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44828","meta44828",706211510,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async44827","cljs.core.async/t_cljs$core$async44827",690990116,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta44831","meta44831",1888740512,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async44830.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44830.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44830";

cljs.core.async.t_cljs$core$async44830.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44830");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async44830 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44830(f__$1,ch__$1,meta44828__$1,___$2,fn1__$1,meta44831){
return (new cljs.core.async.t_cljs$core$async44830(f__$1,ch__$1,meta44828__$1,___$2,fn1__$1,meta44831));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async44830(self__.f,self__.ch,self__.meta44828,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7490__auto__ = ret;
if(cljs.core.truth_(and__7490__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__7490__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44827.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async44827.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44828","meta44828",706211510,null)], null);
});

cljs.core.async.t_cljs$core$async44827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44827";

cljs.core.async.t_cljs$core$async44827.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44827");
});

cljs.core.async.__GT_t_cljs$core$async44827 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44827(f__$1,ch__$1,meta44828){
return (new cljs.core.async.t_cljs$core$async44827(f__$1,ch__$1,meta44828));
});

}

return (new cljs.core.async.t_cljs$core$async44827(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async44836 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44836 = (function (f,ch,meta44837){
this.f = f;
this.ch = ch;
this.meta44837 = meta44837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44838,meta44837__$1){
var self__ = this;
var _44838__$1 = this;
return (new cljs.core.async.t_cljs$core$async44836(self__.f,self__.ch,meta44837__$1));
});


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44838){
var self__ = this;
var _44838__$1 = this;
return self__.meta44837;
});


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44836.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async44836.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44837","meta44837",202593967,null)], null);
});

cljs.core.async.t_cljs$core$async44836.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44836.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44836";

cljs.core.async.t_cljs$core$async44836.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44836");
});

cljs.core.async.__GT_t_cljs$core$async44836 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async44836(f__$1,ch__$1,meta44837){
return (new cljs.core.async.t_cljs$core$async44836(f__$1,ch__$1,meta44837));
});

}

return (new cljs.core.async.t_cljs$core$async44836(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async44842 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44842 = (function (p,ch,meta44843){
this.p = p;
this.ch = ch;
this.meta44843 = meta44843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44844,meta44843__$1){
var self__ = this;
var _44844__$1 = this;
return (new cljs.core.async.t_cljs$core$async44842(self__.p,self__.ch,meta44843__$1));
});


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44844){
var self__ = this;
var _44844__$1 = this;
return self__.meta44843;
});


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async44842.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async44842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44843","meta44843",2068122947,null)], null);
});

cljs.core.async.t_cljs$core$async44842.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async44842.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44842";

cljs.core.async.t_cljs$core$async44842.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"cljs.core.async/t_cljs$core$async44842");
});

cljs.core.async.__GT_t_cljs$core$async44842 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async44842(p__$1,ch__$1,meta44843){
return (new cljs.core.async.t_cljs$core$async44842(p__$1,ch__$1,meta44843));
});

}

return (new cljs.core.async.t_cljs$core$async44842(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args44845 = [];
var len__8723__auto___44889 = arguments.length;
var i__8724__auto___44890 = (0);
while(true){
if((i__8724__auto___44890 < len__8723__auto___44889)){
args44845.push((arguments[i__8724__auto___44890]));

var G__44891 = (i__8724__auto___44890 + (1));
i__8724__auto___44890 = G__44891;
continue;
} else {
}
break;
}

var G__44847 = args44845.length;
switch (G__44847) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44845.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___44893 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___44893,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___44893,out){
return (function (state_44868){
var state_val_44869 = (state_44868[(1)]);
if((state_val_44869 === (7))){
var inst_44864 = (state_44868[(2)]);
var state_44868__$1 = state_44868;
var statearr_44870_44894 = state_44868__$1;
(statearr_44870_44894[(2)] = inst_44864);

(statearr_44870_44894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (1))){
var state_44868__$1 = state_44868;
var statearr_44871_44895 = state_44868__$1;
(statearr_44871_44895[(2)] = null);

(statearr_44871_44895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (4))){
var inst_44850 = (state_44868[(7)]);
var inst_44850__$1 = (state_44868[(2)]);
var inst_44851 = (inst_44850__$1 == null);
var state_44868__$1 = (function (){var statearr_44872 = state_44868;
(statearr_44872[(7)] = inst_44850__$1);

return statearr_44872;
})();
if(cljs.core.truth_(inst_44851)){
var statearr_44873_44896 = state_44868__$1;
(statearr_44873_44896[(1)] = (5));

} else {
var statearr_44874_44897 = state_44868__$1;
(statearr_44874_44897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (6))){
var inst_44850 = (state_44868[(7)]);
var inst_44855 = p.call(null,inst_44850);
var state_44868__$1 = state_44868;
if(cljs.core.truth_(inst_44855)){
var statearr_44875_44898 = state_44868__$1;
(statearr_44875_44898[(1)] = (8));

} else {
var statearr_44876_44899 = state_44868__$1;
(statearr_44876_44899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (3))){
var inst_44866 = (state_44868[(2)]);
var state_44868__$1 = state_44868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44868__$1,inst_44866);
} else {
if((state_val_44869 === (2))){
var state_44868__$1 = state_44868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44868__$1,(4),ch);
} else {
if((state_val_44869 === (11))){
var inst_44858 = (state_44868[(2)]);
var state_44868__$1 = state_44868;
var statearr_44877_44900 = state_44868__$1;
(statearr_44877_44900[(2)] = inst_44858);

(statearr_44877_44900[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (9))){
var state_44868__$1 = state_44868;
var statearr_44878_44901 = state_44868__$1;
(statearr_44878_44901[(2)] = null);

(statearr_44878_44901[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (5))){
var inst_44853 = cljs.core.async.close_BANG_.call(null,out);
var state_44868__$1 = state_44868;
var statearr_44879_44902 = state_44868__$1;
(statearr_44879_44902[(2)] = inst_44853);

(statearr_44879_44902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (10))){
var inst_44861 = (state_44868[(2)]);
var state_44868__$1 = (function (){var statearr_44880 = state_44868;
(statearr_44880[(8)] = inst_44861);

return statearr_44880;
})();
var statearr_44881_44903 = state_44868__$1;
(statearr_44881_44903[(2)] = null);

(statearr_44881_44903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44869 === (8))){
var inst_44850 = (state_44868[(7)]);
var state_44868__$1 = state_44868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44868__$1,(11),out,inst_44850);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___44893,out))
;
return ((function (switch__42489__auto__,c__42603__auto___44893,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_44885 = [null,null,null,null,null,null,null,null,null];
(statearr_44885[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_44885[(1)] = (1));

return statearr_44885;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_44868){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_44868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e44886){if((e44886 instanceof Object)){
var ex__42493__auto__ = e44886;
var statearr_44887_44904 = state_44868;
(statearr_44887_44904[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44905 = state_44868;
state_44868 = G__44905;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_44868){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_44868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___44893,out))
})();
var state__42605__auto__ = (function (){var statearr_44888 = f__42604__auto__.call(null);
(statearr_44888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___44893);

return statearr_44888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___44893,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args44906 = [];
var len__8723__auto___44909 = arguments.length;
var i__8724__auto___44910 = (0);
while(true){
if((i__8724__auto___44910 < len__8723__auto___44909)){
args44906.push((arguments[i__8724__auto___44910]));

var G__44911 = (i__8724__auto___44910 + (1));
i__8724__auto___44910 = G__44911;
continue;
} else {
}
break;
}

var G__44908 = args44906.length;
switch (G__44908) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args44906.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__){
return (function (state_45078){
var state_val_45079 = (state_45078[(1)]);
if((state_val_45079 === (7))){
var inst_45074 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
var statearr_45080_45121 = state_45078__$1;
(statearr_45080_45121[(2)] = inst_45074);

(statearr_45080_45121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (20))){
var inst_45044 = (state_45078[(7)]);
var inst_45055 = (state_45078[(2)]);
var inst_45056 = cljs.core.next.call(null,inst_45044);
var inst_45030 = inst_45056;
var inst_45031 = null;
var inst_45032 = (0);
var inst_45033 = (0);
var state_45078__$1 = (function (){var statearr_45081 = state_45078;
(statearr_45081[(8)] = inst_45033);

(statearr_45081[(9)] = inst_45032);

(statearr_45081[(10)] = inst_45031);

(statearr_45081[(11)] = inst_45055);

(statearr_45081[(12)] = inst_45030);

return statearr_45081;
})();
var statearr_45082_45122 = state_45078__$1;
(statearr_45082_45122[(2)] = null);

(statearr_45082_45122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (1))){
var state_45078__$1 = state_45078;
var statearr_45083_45123 = state_45078__$1;
(statearr_45083_45123[(2)] = null);

(statearr_45083_45123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (4))){
var inst_45019 = (state_45078[(13)]);
var inst_45019__$1 = (state_45078[(2)]);
var inst_45020 = (inst_45019__$1 == null);
var state_45078__$1 = (function (){var statearr_45084 = state_45078;
(statearr_45084[(13)] = inst_45019__$1);

return statearr_45084;
})();
if(cljs.core.truth_(inst_45020)){
var statearr_45085_45124 = state_45078__$1;
(statearr_45085_45124[(1)] = (5));

} else {
var statearr_45086_45125 = state_45078__$1;
(statearr_45086_45125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (15))){
var state_45078__$1 = state_45078;
var statearr_45090_45126 = state_45078__$1;
(statearr_45090_45126[(2)] = null);

(statearr_45090_45126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (21))){
var state_45078__$1 = state_45078;
var statearr_45091_45127 = state_45078__$1;
(statearr_45091_45127[(2)] = null);

(statearr_45091_45127[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (13))){
var inst_45033 = (state_45078[(8)]);
var inst_45032 = (state_45078[(9)]);
var inst_45031 = (state_45078[(10)]);
var inst_45030 = (state_45078[(12)]);
var inst_45040 = (state_45078[(2)]);
var inst_45041 = (inst_45033 + (1));
var tmp45087 = inst_45032;
var tmp45088 = inst_45031;
var tmp45089 = inst_45030;
var inst_45030__$1 = tmp45089;
var inst_45031__$1 = tmp45088;
var inst_45032__$1 = tmp45087;
var inst_45033__$1 = inst_45041;
var state_45078__$1 = (function (){var statearr_45092 = state_45078;
(statearr_45092[(8)] = inst_45033__$1);

(statearr_45092[(9)] = inst_45032__$1);

(statearr_45092[(10)] = inst_45031__$1);

(statearr_45092[(14)] = inst_45040);

(statearr_45092[(12)] = inst_45030__$1);

return statearr_45092;
})();
var statearr_45093_45128 = state_45078__$1;
(statearr_45093_45128[(2)] = null);

(statearr_45093_45128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (22))){
var state_45078__$1 = state_45078;
var statearr_45094_45129 = state_45078__$1;
(statearr_45094_45129[(2)] = null);

(statearr_45094_45129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (6))){
var inst_45019 = (state_45078[(13)]);
var inst_45028 = f.call(null,inst_45019);
var inst_45029 = cljs.core.seq.call(null,inst_45028);
var inst_45030 = inst_45029;
var inst_45031 = null;
var inst_45032 = (0);
var inst_45033 = (0);
var state_45078__$1 = (function (){var statearr_45095 = state_45078;
(statearr_45095[(8)] = inst_45033);

(statearr_45095[(9)] = inst_45032);

(statearr_45095[(10)] = inst_45031);

(statearr_45095[(12)] = inst_45030);

return statearr_45095;
})();
var statearr_45096_45130 = state_45078__$1;
(statearr_45096_45130[(2)] = null);

(statearr_45096_45130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (17))){
var inst_45044 = (state_45078[(7)]);
var inst_45048 = cljs.core.chunk_first.call(null,inst_45044);
var inst_45049 = cljs.core.chunk_rest.call(null,inst_45044);
var inst_45050 = cljs.core.count.call(null,inst_45048);
var inst_45030 = inst_45049;
var inst_45031 = inst_45048;
var inst_45032 = inst_45050;
var inst_45033 = (0);
var state_45078__$1 = (function (){var statearr_45097 = state_45078;
(statearr_45097[(8)] = inst_45033);

(statearr_45097[(9)] = inst_45032);

(statearr_45097[(10)] = inst_45031);

(statearr_45097[(12)] = inst_45030);

return statearr_45097;
})();
var statearr_45098_45131 = state_45078__$1;
(statearr_45098_45131[(2)] = null);

(statearr_45098_45131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (3))){
var inst_45076 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45078__$1,inst_45076);
} else {
if((state_val_45079 === (12))){
var inst_45064 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
var statearr_45099_45132 = state_45078__$1;
(statearr_45099_45132[(2)] = inst_45064);

(statearr_45099_45132[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (2))){
var state_45078__$1 = state_45078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45078__$1,(4),in$);
} else {
if((state_val_45079 === (23))){
var inst_45072 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
var statearr_45100_45133 = state_45078__$1;
(statearr_45100_45133[(2)] = inst_45072);

(statearr_45100_45133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (19))){
var inst_45059 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
var statearr_45101_45134 = state_45078__$1;
(statearr_45101_45134[(2)] = inst_45059);

(statearr_45101_45134[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (11))){
var inst_45030 = (state_45078[(12)]);
var inst_45044 = (state_45078[(7)]);
var inst_45044__$1 = cljs.core.seq.call(null,inst_45030);
var state_45078__$1 = (function (){var statearr_45102 = state_45078;
(statearr_45102[(7)] = inst_45044__$1);

return statearr_45102;
})();
if(inst_45044__$1){
var statearr_45103_45135 = state_45078__$1;
(statearr_45103_45135[(1)] = (14));

} else {
var statearr_45104_45136 = state_45078__$1;
(statearr_45104_45136[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (9))){
var inst_45066 = (state_45078[(2)]);
var inst_45067 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_45078__$1 = (function (){var statearr_45105 = state_45078;
(statearr_45105[(15)] = inst_45066);

return statearr_45105;
})();
if(cljs.core.truth_(inst_45067)){
var statearr_45106_45137 = state_45078__$1;
(statearr_45106_45137[(1)] = (21));

} else {
var statearr_45107_45138 = state_45078__$1;
(statearr_45107_45138[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (5))){
var inst_45022 = cljs.core.async.close_BANG_.call(null,out);
var state_45078__$1 = state_45078;
var statearr_45108_45139 = state_45078__$1;
(statearr_45108_45139[(2)] = inst_45022);

(statearr_45108_45139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (14))){
var inst_45044 = (state_45078[(7)]);
var inst_45046 = cljs.core.chunked_seq_QMARK_.call(null,inst_45044);
var state_45078__$1 = state_45078;
if(inst_45046){
var statearr_45109_45140 = state_45078__$1;
(statearr_45109_45140[(1)] = (17));

} else {
var statearr_45110_45141 = state_45078__$1;
(statearr_45110_45141[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (16))){
var inst_45062 = (state_45078[(2)]);
var state_45078__$1 = state_45078;
var statearr_45111_45142 = state_45078__$1;
(statearr_45111_45142[(2)] = inst_45062);

(statearr_45111_45142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45079 === (10))){
var inst_45033 = (state_45078[(8)]);
var inst_45031 = (state_45078[(10)]);
var inst_45038 = cljs.core._nth.call(null,inst_45031,inst_45033);
var state_45078__$1 = state_45078;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45078__$1,(13),out,inst_45038);
} else {
if((state_val_45079 === (18))){
var inst_45044 = (state_45078[(7)]);
var inst_45053 = cljs.core.first.call(null,inst_45044);
var state_45078__$1 = state_45078;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45078__$1,(20),out,inst_45053);
} else {
if((state_val_45079 === (8))){
var inst_45033 = (state_45078[(8)]);
var inst_45032 = (state_45078[(9)]);
var inst_45035 = (inst_45033 < inst_45032);
var inst_45036 = inst_45035;
var state_45078__$1 = state_45078;
if(cljs.core.truth_(inst_45036)){
var statearr_45112_45143 = state_45078__$1;
(statearr_45112_45143[(1)] = (10));

} else {
var statearr_45113_45144 = state_45078__$1;
(statearr_45113_45144[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__))
;
return ((function (switch__42489__auto__,c__42603__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____0 = (function (){
var statearr_45117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45117[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__);

(statearr_45117[(1)] = (1));

return statearr_45117;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____1 = (function (state_45078){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_45078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e45118){if((e45118 instanceof Object)){
var ex__42493__auto__ = e45118;
var statearr_45119_45145 = state_45078;
(statearr_45119_45145[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45078);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45146 = state_45078;
state_45078 = G__45146;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__ = function(state_45078){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____1.call(this,state_45078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42490__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__))
})();
var state__42605__auto__ = (function (){var statearr_45120 = f__42604__auto__.call(null);
(statearr_45120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_45120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__))
);

return c__42603__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args45147 = [];
var len__8723__auto___45150 = arguments.length;
var i__8724__auto___45151 = (0);
while(true){
if((i__8724__auto___45151 < len__8723__auto___45150)){
args45147.push((arguments[i__8724__auto___45151]));

var G__45152 = (i__8724__auto___45151 + (1));
i__8724__auto___45151 = G__45152;
continue;
} else {
}
break;
}

var G__45149 = args45147.length;
switch (G__45149) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45147.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args45154 = [];
var len__8723__auto___45157 = arguments.length;
var i__8724__auto___45158 = (0);
while(true){
if((i__8724__auto___45158 < len__8723__auto___45157)){
args45154.push((arguments[i__8724__auto___45158]));

var G__45159 = (i__8724__auto___45158 + (1));
i__8724__auto___45158 = G__45159;
continue;
} else {
}
break;
}

var G__45156 = args45154.length;
switch (G__45156) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45154.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args45161 = [];
var len__8723__auto___45212 = arguments.length;
var i__8724__auto___45213 = (0);
while(true){
if((i__8724__auto___45213 < len__8723__auto___45212)){
args45161.push((arguments[i__8724__auto___45213]));

var G__45214 = (i__8724__auto___45213 + (1));
i__8724__auto___45213 = G__45214;
continue;
} else {
}
break;
}

var G__45163 = args45161.length;
switch (G__45163) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45161.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___45216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___45216,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___45216,out){
return (function (state_45187){
var state_val_45188 = (state_45187[(1)]);
if((state_val_45188 === (7))){
var inst_45182 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45189_45217 = state_45187__$1;
(statearr_45189_45217[(2)] = inst_45182);

(statearr_45189_45217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (1))){
var inst_45164 = null;
var state_45187__$1 = (function (){var statearr_45190 = state_45187;
(statearr_45190[(7)] = inst_45164);

return statearr_45190;
})();
var statearr_45191_45218 = state_45187__$1;
(statearr_45191_45218[(2)] = null);

(statearr_45191_45218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (4))){
var inst_45167 = (state_45187[(8)]);
var inst_45167__$1 = (state_45187[(2)]);
var inst_45168 = (inst_45167__$1 == null);
var inst_45169 = cljs.core.not.call(null,inst_45168);
var state_45187__$1 = (function (){var statearr_45192 = state_45187;
(statearr_45192[(8)] = inst_45167__$1);

return statearr_45192;
})();
if(inst_45169){
var statearr_45193_45219 = state_45187__$1;
(statearr_45193_45219[(1)] = (5));

} else {
var statearr_45194_45220 = state_45187__$1;
(statearr_45194_45220[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (6))){
var state_45187__$1 = state_45187;
var statearr_45195_45221 = state_45187__$1;
(statearr_45195_45221[(2)] = null);

(statearr_45195_45221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (3))){
var inst_45184 = (state_45187[(2)]);
var inst_45185 = cljs.core.async.close_BANG_.call(null,out);
var state_45187__$1 = (function (){var statearr_45196 = state_45187;
(statearr_45196[(9)] = inst_45184);

return statearr_45196;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45187__$1,inst_45185);
} else {
if((state_val_45188 === (2))){
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45187__$1,(4),ch);
} else {
if((state_val_45188 === (11))){
var inst_45167 = (state_45187[(8)]);
var inst_45176 = (state_45187[(2)]);
var inst_45164 = inst_45167;
var state_45187__$1 = (function (){var statearr_45197 = state_45187;
(statearr_45197[(7)] = inst_45164);

(statearr_45197[(10)] = inst_45176);

return statearr_45197;
})();
var statearr_45198_45222 = state_45187__$1;
(statearr_45198_45222[(2)] = null);

(statearr_45198_45222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (9))){
var inst_45167 = (state_45187[(8)]);
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45187__$1,(11),out,inst_45167);
} else {
if((state_val_45188 === (5))){
var inst_45164 = (state_45187[(7)]);
var inst_45167 = (state_45187[(8)]);
var inst_45171 = cljs.core._EQ_.call(null,inst_45167,inst_45164);
var state_45187__$1 = state_45187;
if(inst_45171){
var statearr_45200_45223 = state_45187__$1;
(statearr_45200_45223[(1)] = (8));

} else {
var statearr_45201_45224 = state_45187__$1;
(statearr_45201_45224[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (10))){
var inst_45179 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45202_45225 = state_45187__$1;
(statearr_45202_45225[(2)] = inst_45179);

(statearr_45202_45225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (8))){
var inst_45164 = (state_45187[(7)]);
var tmp45199 = inst_45164;
var inst_45164__$1 = tmp45199;
var state_45187__$1 = (function (){var statearr_45203 = state_45187;
(statearr_45203[(7)] = inst_45164__$1);

return statearr_45203;
})();
var statearr_45204_45226 = state_45187__$1;
(statearr_45204_45226[(2)] = null);

(statearr_45204_45226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___45216,out))
;
return ((function (switch__42489__auto__,c__42603__auto___45216,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_45208 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45208[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_45208[(1)] = (1));

return statearr_45208;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_45187){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_45187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e45209){if((e45209 instanceof Object)){
var ex__42493__auto__ = e45209;
var statearr_45210_45227 = state_45187;
(statearr_45210_45227[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45228 = state_45187;
state_45187 = G__45228;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_45187){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_45187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___45216,out))
})();
var state__42605__auto__ = (function (){var statearr_45211 = f__42604__auto__.call(null);
(statearr_45211[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___45216);

return statearr_45211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___45216,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args45229 = [];
var len__8723__auto___45299 = arguments.length;
var i__8724__auto___45300 = (0);
while(true){
if((i__8724__auto___45300 < len__8723__auto___45299)){
args45229.push((arguments[i__8724__auto___45300]));

var G__45301 = (i__8724__auto___45300 + (1));
i__8724__auto___45300 = G__45301;
continue;
} else {
}
break;
}

var G__45231 = args45229.length;
switch (G__45231) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45229.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___45303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___45303,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___45303,out){
return (function (state_45269){
var state_val_45270 = (state_45269[(1)]);
if((state_val_45270 === (7))){
var inst_45265 = (state_45269[(2)]);
var state_45269__$1 = state_45269;
var statearr_45271_45304 = state_45269__$1;
(statearr_45271_45304[(2)] = inst_45265);

(statearr_45271_45304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (1))){
var inst_45232 = (new Array(n));
var inst_45233 = inst_45232;
var inst_45234 = (0);
var state_45269__$1 = (function (){var statearr_45272 = state_45269;
(statearr_45272[(7)] = inst_45233);

(statearr_45272[(8)] = inst_45234);

return statearr_45272;
})();
var statearr_45273_45305 = state_45269__$1;
(statearr_45273_45305[(2)] = null);

(statearr_45273_45305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (4))){
var inst_45237 = (state_45269[(9)]);
var inst_45237__$1 = (state_45269[(2)]);
var inst_45238 = (inst_45237__$1 == null);
var inst_45239 = cljs.core.not.call(null,inst_45238);
var state_45269__$1 = (function (){var statearr_45274 = state_45269;
(statearr_45274[(9)] = inst_45237__$1);

return statearr_45274;
})();
if(inst_45239){
var statearr_45275_45306 = state_45269__$1;
(statearr_45275_45306[(1)] = (5));

} else {
var statearr_45276_45307 = state_45269__$1;
(statearr_45276_45307[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (15))){
var inst_45259 = (state_45269[(2)]);
var state_45269__$1 = state_45269;
var statearr_45277_45308 = state_45269__$1;
(statearr_45277_45308[(2)] = inst_45259);

(statearr_45277_45308[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (13))){
var state_45269__$1 = state_45269;
var statearr_45278_45309 = state_45269__$1;
(statearr_45278_45309[(2)] = null);

(statearr_45278_45309[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (6))){
var inst_45234 = (state_45269[(8)]);
var inst_45255 = (inst_45234 > (0));
var state_45269__$1 = state_45269;
if(cljs.core.truth_(inst_45255)){
var statearr_45279_45310 = state_45269__$1;
(statearr_45279_45310[(1)] = (12));

} else {
var statearr_45280_45311 = state_45269__$1;
(statearr_45280_45311[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (3))){
var inst_45267 = (state_45269[(2)]);
var state_45269__$1 = state_45269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45269__$1,inst_45267);
} else {
if((state_val_45270 === (12))){
var inst_45233 = (state_45269[(7)]);
var inst_45257 = cljs.core.vec.call(null,inst_45233);
var state_45269__$1 = state_45269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45269__$1,(15),out,inst_45257);
} else {
if((state_val_45270 === (2))){
var state_45269__$1 = state_45269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45269__$1,(4),ch);
} else {
if((state_val_45270 === (11))){
var inst_45249 = (state_45269[(2)]);
var inst_45250 = (new Array(n));
var inst_45233 = inst_45250;
var inst_45234 = (0);
var state_45269__$1 = (function (){var statearr_45281 = state_45269;
(statearr_45281[(7)] = inst_45233);

(statearr_45281[(8)] = inst_45234);

(statearr_45281[(10)] = inst_45249);

return statearr_45281;
})();
var statearr_45282_45312 = state_45269__$1;
(statearr_45282_45312[(2)] = null);

(statearr_45282_45312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (9))){
var inst_45233 = (state_45269[(7)]);
var inst_45247 = cljs.core.vec.call(null,inst_45233);
var state_45269__$1 = state_45269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45269__$1,(11),out,inst_45247);
} else {
if((state_val_45270 === (5))){
var inst_45233 = (state_45269[(7)]);
var inst_45234 = (state_45269[(8)]);
var inst_45242 = (state_45269[(11)]);
var inst_45237 = (state_45269[(9)]);
var inst_45241 = (inst_45233[inst_45234] = inst_45237);
var inst_45242__$1 = (inst_45234 + (1));
var inst_45243 = (inst_45242__$1 < n);
var state_45269__$1 = (function (){var statearr_45283 = state_45269;
(statearr_45283[(12)] = inst_45241);

(statearr_45283[(11)] = inst_45242__$1);

return statearr_45283;
})();
if(cljs.core.truth_(inst_45243)){
var statearr_45284_45313 = state_45269__$1;
(statearr_45284_45313[(1)] = (8));

} else {
var statearr_45285_45314 = state_45269__$1;
(statearr_45285_45314[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (14))){
var inst_45262 = (state_45269[(2)]);
var inst_45263 = cljs.core.async.close_BANG_.call(null,out);
var state_45269__$1 = (function (){var statearr_45287 = state_45269;
(statearr_45287[(13)] = inst_45262);

return statearr_45287;
})();
var statearr_45288_45315 = state_45269__$1;
(statearr_45288_45315[(2)] = inst_45263);

(statearr_45288_45315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (10))){
var inst_45253 = (state_45269[(2)]);
var state_45269__$1 = state_45269;
var statearr_45289_45316 = state_45269__$1;
(statearr_45289_45316[(2)] = inst_45253);

(statearr_45289_45316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45270 === (8))){
var inst_45233 = (state_45269[(7)]);
var inst_45242 = (state_45269[(11)]);
var tmp45286 = inst_45233;
var inst_45233__$1 = tmp45286;
var inst_45234 = inst_45242;
var state_45269__$1 = (function (){var statearr_45290 = state_45269;
(statearr_45290[(7)] = inst_45233__$1);

(statearr_45290[(8)] = inst_45234);

return statearr_45290;
})();
var statearr_45291_45317 = state_45269__$1;
(statearr_45291_45317[(2)] = null);

(statearr_45291_45317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___45303,out))
;
return ((function (switch__42489__auto__,c__42603__auto___45303,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_45295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45295[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_45295[(1)] = (1));

return statearr_45295;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_45269){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_45269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e45296){if((e45296 instanceof Object)){
var ex__42493__auto__ = e45296;
var statearr_45297_45318 = state_45269;
(statearr_45297_45318[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45319 = state_45269;
state_45269 = G__45319;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_45269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_45269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___45303,out))
})();
var state__42605__auto__ = (function (){var statearr_45298 = f__42604__auto__.call(null);
(statearr_45298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___45303);

return statearr_45298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___45303,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args45320 = [];
var len__8723__auto___45394 = arguments.length;
var i__8724__auto___45395 = (0);
while(true){
if((i__8724__auto___45395 < len__8723__auto___45394)){
args45320.push((arguments[i__8724__auto___45395]));

var G__45396 = (i__8724__auto___45395 + (1));
i__8724__auto___45395 = G__45396;
continue;
} else {
}
break;
}

var G__45322 = args45320.length;
switch (G__45322) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45320.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42603__auto___45398 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___45398,out){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___45398,out){
return (function (state_45364){
var state_val_45365 = (state_45364[(1)]);
if((state_val_45365 === (7))){
var inst_45360 = (state_45364[(2)]);
var state_45364__$1 = state_45364;
var statearr_45366_45399 = state_45364__$1;
(statearr_45366_45399[(2)] = inst_45360);

(statearr_45366_45399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (1))){
var inst_45323 = [];
var inst_45324 = inst_45323;
var inst_45325 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45364__$1 = (function (){var statearr_45367 = state_45364;
(statearr_45367[(7)] = inst_45324);

(statearr_45367[(8)] = inst_45325);

return statearr_45367;
})();
var statearr_45368_45400 = state_45364__$1;
(statearr_45368_45400[(2)] = null);

(statearr_45368_45400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (4))){
var inst_45328 = (state_45364[(9)]);
var inst_45328__$1 = (state_45364[(2)]);
var inst_45329 = (inst_45328__$1 == null);
var inst_45330 = cljs.core.not.call(null,inst_45329);
var state_45364__$1 = (function (){var statearr_45369 = state_45364;
(statearr_45369[(9)] = inst_45328__$1);

return statearr_45369;
})();
if(inst_45330){
var statearr_45370_45401 = state_45364__$1;
(statearr_45370_45401[(1)] = (5));

} else {
var statearr_45371_45402 = state_45364__$1;
(statearr_45371_45402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (15))){
var inst_45354 = (state_45364[(2)]);
var state_45364__$1 = state_45364;
var statearr_45372_45403 = state_45364__$1;
(statearr_45372_45403[(2)] = inst_45354);

(statearr_45372_45403[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (13))){
var state_45364__$1 = state_45364;
var statearr_45373_45404 = state_45364__$1;
(statearr_45373_45404[(2)] = null);

(statearr_45373_45404[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (6))){
var inst_45324 = (state_45364[(7)]);
var inst_45349 = inst_45324.length;
var inst_45350 = (inst_45349 > (0));
var state_45364__$1 = state_45364;
if(cljs.core.truth_(inst_45350)){
var statearr_45374_45405 = state_45364__$1;
(statearr_45374_45405[(1)] = (12));

} else {
var statearr_45375_45406 = state_45364__$1;
(statearr_45375_45406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (3))){
var inst_45362 = (state_45364[(2)]);
var state_45364__$1 = state_45364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45364__$1,inst_45362);
} else {
if((state_val_45365 === (12))){
var inst_45324 = (state_45364[(7)]);
var inst_45352 = cljs.core.vec.call(null,inst_45324);
var state_45364__$1 = state_45364;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45364__$1,(15),out,inst_45352);
} else {
if((state_val_45365 === (2))){
var state_45364__$1 = state_45364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45364__$1,(4),ch);
} else {
if((state_val_45365 === (11))){
var inst_45332 = (state_45364[(10)]);
var inst_45328 = (state_45364[(9)]);
var inst_45342 = (state_45364[(2)]);
var inst_45343 = [];
var inst_45344 = inst_45343.push(inst_45328);
var inst_45324 = inst_45343;
var inst_45325 = inst_45332;
var state_45364__$1 = (function (){var statearr_45376 = state_45364;
(statearr_45376[(7)] = inst_45324);

(statearr_45376[(11)] = inst_45342);

(statearr_45376[(8)] = inst_45325);

(statearr_45376[(12)] = inst_45344);

return statearr_45376;
})();
var statearr_45377_45407 = state_45364__$1;
(statearr_45377_45407[(2)] = null);

(statearr_45377_45407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (9))){
var inst_45324 = (state_45364[(7)]);
var inst_45340 = cljs.core.vec.call(null,inst_45324);
var state_45364__$1 = state_45364;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45364__$1,(11),out,inst_45340);
} else {
if((state_val_45365 === (5))){
var inst_45332 = (state_45364[(10)]);
var inst_45328 = (state_45364[(9)]);
var inst_45325 = (state_45364[(8)]);
var inst_45332__$1 = f.call(null,inst_45328);
var inst_45333 = cljs.core._EQ_.call(null,inst_45332__$1,inst_45325);
var inst_45334 = cljs.core.keyword_identical_QMARK_.call(null,inst_45325,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45335 = (inst_45333) || (inst_45334);
var state_45364__$1 = (function (){var statearr_45378 = state_45364;
(statearr_45378[(10)] = inst_45332__$1);

return statearr_45378;
})();
if(cljs.core.truth_(inst_45335)){
var statearr_45379_45408 = state_45364__$1;
(statearr_45379_45408[(1)] = (8));

} else {
var statearr_45380_45409 = state_45364__$1;
(statearr_45380_45409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (14))){
var inst_45357 = (state_45364[(2)]);
var inst_45358 = cljs.core.async.close_BANG_.call(null,out);
var state_45364__$1 = (function (){var statearr_45382 = state_45364;
(statearr_45382[(13)] = inst_45357);

return statearr_45382;
})();
var statearr_45383_45410 = state_45364__$1;
(statearr_45383_45410[(2)] = inst_45358);

(statearr_45383_45410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (10))){
var inst_45347 = (state_45364[(2)]);
var state_45364__$1 = state_45364;
var statearr_45384_45411 = state_45364__$1;
(statearr_45384_45411[(2)] = inst_45347);

(statearr_45384_45411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45365 === (8))){
var inst_45324 = (state_45364[(7)]);
var inst_45332 = (state_45364[(10)]);
var inst_45328 = (state_45364[(9)]);
var inst_45337 = inst_45324.push(inst_45328);
var tmp45381 = inst_45324;
var inst_45324__$1 = tmp45381;
var inst_45325 = inst_45332;
var state_45364__$1 = (function (){var statearr_45385 = state_45364;
(statearr_45385[(7)] = inst_45324__$1);

(statearr_45385[(14)] = inst_45337);

(statearr_45385[(8)] = inst_45325);

return statearr_45385;
})();
var statearr_45386_45412 = state_45364__$1;
(statearr_45386_45412[(2)] = null);

(statearr_45386_45412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___45398,out))
;
return ((function (switch__42489__auto__,c__42603__auto___45398,out){
return (function() {
var cljs$core$async$state_machine__42490__auto__ = null;
var cljs$core$async$state_machine__42490__auto____0 = (function (){
var statearr_45390 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45390[(0)] = cljs$core$async$state_machine__42490__auto__);

(statearr_45390[(1)] = (1));

return statearr_45390;
});
var cljs$core$async$state_machine__42490__auto____1 = (function (state_45364){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_45364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e45391){if((e45391 instanceof Object)){
var ex__42493__auto__ = e45391;
var statearr_45392_45413 = state_45364;
(statearr_45392_45413[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45391;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45414 = state_45364;
state_45364 = G__45414;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
cljs$core$async$state_machine__42490__auto__ = function(state_45364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42490__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42490__auto____1.call(this,state_45364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42490__auto____0;
cljs$core$async$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42490__auto____1;
return cljs$core$async$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___45398,out))
})();
var state__42605__auto__ = (function (){var statearr_45393 = f__42604__auto__.call(null);
(statearr_45393[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___45398);

return statearr_45393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___45398,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

