/*
 * Decompiled with CFR 0.152.
 */
package com.nebleena.persist;

import com.google.inject.Inject;
import com.nebleena.persist.JpaPersistService;
import com.nebleena.persist.Transactional;
import com.nebleena.persist.UnitOfWork;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class JpaLocalTxnInterceptor
implements MethodInterceptor {
    private final JpaPersistService emProvider;
    @Inject
    private final UnitOfWork unitOfWork = null;
    private final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    public JpaLocalTxnInterceptor(JpaPersistService emProvider) {
        this.emProvider = emProvider;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        if (!this.emProvider.isWorking()) {
            this.emProvider.begin();
            this.didWeStartWork.set(true);
        }
        Transactional transactional = this.readTransactionMetadata(methodInvocation);
        EntityManager em = this.emProvider.get();
        if (em.getTransaction().isActive()) {
            return methodInvocation.proceed();
        }
        EntityTransaction txn = em.getTransaction();
        txn.begin();
        try {
            try {
                result = methodInvocation.proceed();
            }
            catch (Exception e) {
                if (this.rollbackIfNecessary(transactional, e, txn)) {
                    txn.commit();
                }
                throw e;
            }
        }
        finally {
            if (this.didWeStartWork.get() != null && !txn.isActive()) {
                this.didWeStartWork.remove();
                this.unitOfWork.end();
            }
        }
        try {
            txn.commit();
        }
        finally {
            if (this.didWeStartWork.get() != null) {
                this.didWeStartWork.remove();
                this.unitOfWork.end();
            }
        }
        return result;
    }

    private Transactional readTransactionMetadata(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = methodInvocation.getThis().getClass();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null) {
            transactional = targetClass.getAnnotation(Transactional.class);
        }
        if (transactional == null) {
            transactional = Internal.class.getAnnotation(Transactional.class);
        }
        return transactional;
    }

    private boolean rollbackIfNecessary(Transactional transactional, Exception e, EntityTransaction txn) {
        boolean commit = true;
        Class<? extends Exception>[] classArray = transactional.rollbackOn();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Exception> rollBackOn = classArray[n2];
            if (rollBackOn.isInstance(e)) {
                commit = false;
                Class<? extends Exception>[] classArray2 = transactional.ignore();
                int n3 = classArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<? extends Exception> exceptOn = classArray2[n4];
                    if (exceptOn.isInstance(e)) {
                        commit = true;
                        break;
                    }
                    ++n4;
                }
                if (commit) break;
                txn.rollback();
                break;
            }
            ++n2;
        }
        return commit;
    }

    @Transactional
    private static class Internal {
        private Internal() {
        }
    }
}

