/*
 * Decompiled with CFR 0.152.
 */
package com.nebleena.persist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Provider;
import com.nebleena.persist.JpaLocalTxnInterceptor;
import com.nebleena.persist.JpaPersistService;
import com.nebleena.persist.PersistModule;
import com.nebleena.persist.PersistService;
import com.nebleena.persist.UnitOfWork;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.MethodInterceptor;

public final class JpaPersistModule
extends PersistModule {
    private final String jpaUnit;
    private Properties properties;
    private MethodInterceptor transactionInterceptor;
    public static HashMap<String, JpaPersistService> services = Maps.newHashMap();

    public JpaPersistModule(String jpaUnit) {
        Preconditions.checkArgument((jpaUnit != null && jpaUnit.length() > 0 ? 1 : 0) != 0, (Object)"JPA unit name must be a non-empty string.");
        this.jpaUnit = jpaUnit;
    }

    @Override
    protected void configurePersistence() {
        JpaPersistService service = services.get(this.jpaUnit);
        if (service == null) {
            service = new JpaPersistService(this.jpaUnit, this.properties);
            service.start();
            services.put(this.jpaUnit, service);
        }
        this.bind(PersistService.class).toInstance((Object)service);
        this.bind(UnitOfWork.class).toInstance((Object)service);
        this.bind(EntityManager.class).toProvider((Provider)service);
        this.bind(EntityManagerFactory.class).toProvider((Provider)new JpaPersistService.EntityManagerFactoryProvider(service));
        this.transactionInterceptor = new JpaLocalTxnInterceptor(service);
        this.requestInjection(this.transactionInterceptor);
    }

    @Override
    protected MethodInterceptor getTransactionInterceptor() {
        return this.transactionInterceptor;
    }

    public JpaPersistModule properties(Properties properties) {
        this.properties = properties;
        return this;
    }
}

