/*
 * Decompiled with CFR 0.152.
 */
package com.nebleena.persist;

import com.google.common.base.Preconditions;
import com.google.inject.Provider;
import com.nebleena.persist.PersistService;
import com.nebleena.persist.UnitOfWork;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

class JpaPersistService
implements Provider<EntityManager>,
UnitOfWork,
PersistService {
    private final ThreadLocal<EntityManager> entityManager = new ThreadLocal();
    private final String persistenceUnitName;
    private final Properties persistenceProperties;
    private volatile EntityManagerFactory emFactory;

    public JpaPersistService(String persistenceUnitName, Properties persistenceProperties) {
        this.persistenceUnitName = persistenceUnitName;
        this.persistenceProperties = persistenceProperties;
    }

    @Override
    public void begin() {
        Preconditions.checkState((this.entityManager.get() == null ? 1 : 0) != 0, (Object)"Work already begun on this thread. Looks like you have called UnitOfWork.begin() twice without a balancing call to end() in between.");
        this.entityManager.set(this.emFactory.createEntityManager());
    }

    @Override
    public void end() {
        EntityManager em = this.entityManager.get();
        if (em == null) {
            return;
        }
        em.close();
        this.entityManager.remove();
    }

    public EntityManager get() {
        EntityManager em;
        if (!this.isWorking()) {
            this.begin();
        }
        Preconditions.checkState(((em = this.entityManager.get()) != null ? 1 : 0) != 0, (Object)"Requested EntityManager outside work unit. Try calling UnitOfWork.begin() first, or use a PersistFilter if you are inside a servlet environment.");
        return em;
    }

    public boolean isWorking() {
        return this.entityManager.get() != null;
    }

    @Override
    public synchronized void start() {
        Preconditions.checkState((this.emFactory == null ? 1 : 0) != 0, (Object)"Persistence service was already initialized.");
        this.emFactory = this.persistenceProperties != null ? Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceProperties) : Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
    }

    @Override
    public synchronized void stop() {
        Preconditions.checkState((boolean)this.emFactory.isOpen(), (Object)"Persistence service was already shut down.");
        this.emFactory.close();
    }

    public static class EntityManagerFactoryProvider
    implements Provider<EntityManagerFactory> {
        private final JpaPersistService emProvider;

        public EntityManagerFactoryProvider(JpaPersistService emProvider) {
            this.emProvider = emProvider;
        }

        public EntityManagerFactory get() {
            assert (this.emProvider.emFactory != null);
            return this.emProvider.emFactory;
        }
    }
}

