/*
 * Decompiled with CFR 0.152.
 */
package com.nebleena.persist;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nebleena.persist.PersistService;
import com.nebleena.persist.UnitOfWork;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@Singleton
public final class PersistFilter
implements Filter {
    private final UnitOfWork unitOfWork;
    private PersistService persistService;

    @Inject
    public PersistFilter(UnitOfWork unitOfWork, PersistService persistService) {
        this.unitOfWork = unitOfWork;
        this.persistService = persistService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
        this.persistService.stop();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.unitOfWork.begin();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.unitOfWork.end();
        }
    }
}

