/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.io.Serializable;

public class CharSequenceReader
extends Reader
implements Serializable {
    private final CharSequence charSequence;
    private int idx;
    private int mark;

    public CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence != null ? charSequence : "";
    }

    public void close() {
        this.idx = 0;
        this.mark = 0;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.idx;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        return this.charSequence.charAt(this.idx++);
    }

    public int read(char[] array2, int offset, int length) {
        if (this.idx >= this.charSequence.length()) {
            return -1;
        }
        if (array2 == null) {
            throw new NullPointerException("Character array is missing");
        }
        if (length < 0 || offset + length > array2.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array2.length + ", offset=" + offset + ", length=" + length);
        }
        int count2 = 0;
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c == -1) {
                return count2;
            }
            array2[offset + i] = (char)c;
            ++count2;
        }
        return count2;
    }

    public void reset() {
        this.idx = this.mark;
    }

    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
        }
        if (this.idx >= this.charSequence.length()) {
            return -1L;
        }
        int dest = (int)Math.min((long)this.charSequence.length(), (long)this.idx + n);
        int count2 = dest - this.idx;
        this.idx = dest;
        return count2;
    }

    public String toString() {
        return ((Object)this.charSequence).toString();
    }
}

